#!/usr/bin/perl

# E-GADS! Electronic Ground Search and Rescue Administrative Database
# Copyright (C) 2003 Calvin Martini

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# Program: db_event_cal_mail.pl
# Version: 1.1, 20 April 2004
# Author: Calvin Martini
# Description: Mails the HTML report of event calendar to designated recipients based on changes in flag file 

use DBI;

$user = "egads";
$password = "password";
$hostname = "localhost";
$database = "e-gads";
$flagpath = "/home/httpd/html/egads/data/c_flag.txt";
$period = "next_3_months";
$event_filter = "";
$recipients = "your.email\@host.org";
$out_file = "/tmp/events.html";
$biabam = "/usr/local/scripts/biabam";

# Test of the changes flag file exists, only continue if it does
if (-f $flagpath || $ARGV[0] eq "-f"){

	# Read the list of changes
	if (-f $flagpath){
		open (FILE, "$flagpath");
		@changes = <FILE>;
		close(FILE);
		chomp(@changes);
	}

	&gettime;
	(@month) = split(/\|/, "January|February|March|April|May|June|July|August|September|October|November|December");

	$dbh = DBI->connect("DBI:mysql:$database:$hostname",$user, $password);

	$statement = "SELECT calendar.id_record AS id_record,
			calendar.id_teams AS team,
			teams.team_name,
			calendar.date,
			types_cal_events.type AS category,
			calendar.description,
			calendar.location
			FROM calendar
			LEFT JOIN types_cal_events ON calendar.id_category=types_cal_events.id_record 
			LEFT JOIN teams ON calendar.id_teams=teams.id_record 
			WHERE 1=1
			".($period ? period_filter($period,"calendar.date") : "" )."
			".($event_filter ? " AND calendar.id_category='$event_filter'" : "")."				
			".($s_filter && $s_filter != "All" && $s_filter != "None" ? " AND teams.id_record='$s_filter'" : "")."				
			ORDER BY calendar.date";

	$sth = $dbh->prepare($statement) or die "Can't prepare $statement: $dbh->errstr\n";

	$rv = $sth->execute or die "Can't execute the query: $sth->errstr\n";

	# Wite the modifed user list to disk
	open (FILE, ">$out_file") || die "FATAL: Could not create output file.";
	print FILE "<HTML><BODY><H1>NBGSARA TRAINING EVENTS CALENDAR</H1><H3>Generated $date $time</H3><BR>";
	print FILE "<TABLE border=1 cellpadding=2 cellspacing=0>";
	print FILE "<tr><td><h3>Date</h3></td><td><h3>Team</h3></td><td><h3>Category</h3></td><td><h3>Description</h3></td><td><h3>Location</h3></td></tr>";
	while (@data = $sth->fetchrow_array()) {
		my $id_record = $data[0];
		my $team = $data[1];
		my $team_name = $data[2];
		my $date = $data[3];
		my $category = $data[4];
		my $description = $data[5];
		my $location = $data[6];
		print FILE "<tr><td><p>$date</p></td><td><p>$team_name</p></td><td><p>$category</p></td><td><p>$description</p></td><td><p>$location</p></td></tr>\n";
	}
	print FILE "</TABLE><BR><P>For General Inquiries:<BR>NBGSARA Provincial Secretary<BR><A HREF=\"mailto:info\@nbgsara.nb.ca\">info\@nbgsara.nb.ca</A><BR><BR>For Technical Information:<BR>NBGSARA Provincial Webmaster<BR><A HREF=\"mailto:webmaster\@nbgsara.nb.ca\">webmaster\@nbgsara.nb.ca</A></P>";
	print FILE "</BODY></HTML>";
	close(FILE) || die "FATAL: Could not close output file.";

	$rc = $sth->finish;

	# Send the Email
	#     use Mail::Sender;
	#     $sender = new Mail::Sender
	#      {smtp => 'localhost', from => 'root@nec.prv'};
	#     $sender->MailFile({to => 'martinic@nbnet.nb.ca',
	#      subject => 'Here is the file',
	#      msg => "This is a test only.",
	#      file => 'temp.txt'});

	if (-f $flagpath){
		$change_text="The following is the list of changes for this revision:\n\n";
		for (@changes) {
			($e_date_time,$e_ip,$e_change) = split(/\t/);
			$change_text .= "$e_date_time - $e_change\n";
		}
	}
	
	system "echo \"Attached is the NBGSARA Training Calendar for $month[$month_index] $year, $period.\n\n$change_text\nFor General Inquiries:\nNBGSARA Provincial Secretary\ninfo\@nbgsara.nb.ca\n\nFor Technical Information:\nNBGSARA Provincial Webmaster\nwebmaster\@nbgsara.nb.ca\" | $biabam $out_file -s \"NBGSARA Training Calendar for $month[$month_index] $year\" $recipients";

	# Remove the file
	system "rm $out_file";

	# Remove the flag file
	if (-f $flagpath){system "rm $flagpath";}

}
exit;


sub period_filter{
		#/////////////////////////////////////////////////////////////////////////////////// 
		#/// FUNCTION:
		#/// Set the MYSQL period filter query
		#/// 
		#/// PARAMETERS:
		#/// $type							Period filter type - based on report
		#/// $field							Date field to compare with (table.field)
		#/// 
		#/// RETURNS: 
		#/// String containg MYSQL query condition for date
		#///////////////////////////////////////////////////////////////////////////////////

		my ($type,$field)= @_;

		if ($type eq "All") {
			$filter="";
		}elsif($type eq "last_year"){
			$filter="AND YEAR($field)=DATE_SUB(YEAR(CURDATE()), INTERVAL 1 YEAR)";
		}elsif($type eq "last_month"){
			$filter="AND (TO_DAYS($field)>TO_DAYS(DATE_SUB(YEAR(CURDATE()), INTERVAL 1 MONTH)))";
		}elsif($type eq "last_3_months"){
			$filter="AND (TO_DAYS($field)>TO_DAYS(DATE_SUB(YEAR(CURDATE()), INTERVAL 3 MONTH)))";
		}elsif($type eq "current_year"){
			$filter="AND YEAR($field)=YEAR(CURDATE())";
		}elsif($type eq "next_month"){
			$filter="AND TO_DAYS($field) BETWEEN TO_DAYS(CURDATE()) AND TO_DAYS(DATE_ADD(CURDATE(), INTERVAL 1 MONTH))";
		}elsif($type eq "next_3_months"){
			$filter="AND TO_DAYS($field) BETWEEN TO_DAYS(CURDATE()) AND TO_DAYS(DATE_ADD(CURDATE(), INTERVAL 3 MONTH))";
		}
	return $filter;
}

sub gettime {
	($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
	$month_index = $mon;
	$mon++;
	$year += 1900;       
	if ($sec < 10) { $sec = "0$sec"; }
	if ($min < 10) { $min = "0$min"; }
	if ($hour < 10) { $hour = "0$hour"; }
	if ($mday < 10) { $mday = "0$mday"; }
	$date = "$year-$mon-$mday";
	$time = "$hour:$min:$sec";
}
