#!/usr/local/bin/php -q
<?php

# E-GADS! Electronic Ground Search and Rescue Administrative Database
# Copyright (C) 2003 Calvin Martini

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

$ini_array = parse_ini_file($_SERVER['argv'][1], TRUE);
$ftp_server = $ini_array['Settings']['ftp_server'];
$ftp_user_name = $ini_array['Settings']['ftp_user_name'];
$ftp_user_pass = $ini_array['Settings']['ftp_user_pass'];

echo date("Y-m-d")."\t";

// set up basic connection
$conn_id = ftp_connect($ftp_server); 

// login with username and password
$login_result = ftp_login($conn_id, $ftp_user_name, $ftp_user_pass); 

// check connection
if ((!$conn_id) || (!$login_result)) { 
        echo "FTP connection has failed!";
        echo "Attempted to connect to $ftp_server for user $ftp_user_name. "; 
        exit; 
    } else {
        echo "Connected to $ftp_server, for user $ftp_user_name. ";
    }

foreach($ini_array as $data){
	if (isset($data['source_file'])){

		$remote_dir = $data['remote_dir'];
		$destination_file = $data['destination_file'];
		$source_file = $data['source_file'];
		
		ftp_chdir($conn_id, $remote_dir);

		// upload the file
		$upload = ftp_put($conn_id, $destination_file, $source_file, FTP_BINARY); 

		// check upload status
		if (!$upload) { 
				  echo "FTP upload has failed!";
			 } else {
				  echo "Uploaded $source_file to $ftp_server as $destination_file";
			 }

		// Chmod the file
		ftp_site($conn_id, "chmod 0755 $destination_file");

	}
}

// close the FTP stream 
ftp_close($conn_id); 
?>
