#!/usr/bin/perl

# E-GADS! Electronic Ground Search and Rescue Administrative Database
# Copyright (C) 2003 Calvin Martini

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# ===========================================================================
# ===> ip_forward.cgi
# ===> Author: Calvin Martini
# ===> 
# ===> Version 1.1 2002-Jan-11
# ===> 
# ===> Based on the user's IP, determines if the user is on vibe. If so, then
# ===> it redirects the user to the vibe webserver using the local address. If not,
# ===> it redirects the user to the vibe webserver's internet address. The URI 
# ===> for the redirect is the query string passed to this script by the caller.
# ===> 
# ===========================================================================

   use Socket;

	# File for input
	$in_file="./op_contacts/data_099/iponly.txt";

	# IP Address of fixed host (Vibe IP)
	$fixed_ip="10.166.51.250";

	# IP Prefix for proxy address for a vibe user (PERL Regex)
#	$ip_prefix="142\.166\.|192\.168\.";
	$ip_prefix="142\.166\.";

	# Log file
	$log="./op_contacts/data_099/ip_forward.log";

	# Get the calling user's IP
	$host= $ENV{'REMOTE_ADDR'};

	# Set date and time
	&gettime;

	# Open the file with the internet IP address for the site
	open (FILE,"$in_file");
	@ip = <FILE>;
	close(FILE);
	
	# Try to ontain the client's DNS name
   $iaddr = inet_aton($host);
	$DNS_Address  = gethostbyaddr($iaddr, AF_INET);
#   ($DNS_Address,$aliases,$addrtype,$length,@addrs)  = gethostbyaddr($iaddr, AF_INET);
#$DNS_Address  = `nslookup $host`;

	# Determine if user is on Vibe network
#	if ($DNS_Address =~ /nbtel.net/){
	if ($host =~ /$ip_prefix/){
		# A Vibe User - display the fixed IP
		$user="Vibe";

		# Redirect the user to the vibe address
		$location="http://$fixed_ip$ENV{'QUERY_STRING'}";
		$location2="http://$ip[0]$ENV{'QUERY_STRING'}";
		
	}else{
		# Not a Vibe User - display the file IP
		$user="Internet";
		
		# Redirect the user to the internet address
		$location="http://$ip[0]$ENV{'QUERY_STRING'}";
		$location2="http://$fixed_ip$ENV{'QUERY_STRING'}";

	}

	&redirect ($location, $location2, $host, $DNS_address);

	# Write the caller's IP address out to the log file
	open (DATA, ">>$log") || die "FATAL: Could not open $log";
	print DATA "$date $time\t\t$host\t\t$user user $DNS_Address redirected to $location\n";
	close (DATA);
  
sub gettime {
	($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
	$mon++;
	$year += 1900;       
	if ($sec < 10) { $sec = "0$sec"; }
	if ($min < 10) { $min = "0$min"; }
	if ($hour < 10) { $hour = "0$hour"; }
	if ($mday < 10) { $mday = "0$mday"; }
	$date = "$mon/$mday/$year";
	$time = "$hour:$min:$sec";
}

sub redirect {
	my($destination, $alternate, $client_ip, $client_name) = @_;
	print	"Content-type: text/html\n\n";
	print	"<html><body>\n";
	print	"<meta http-equiv=\"refresh\" content=\"1; URL=$destination\">\n";
	print	"<h2>You are being redirected to the application server.</h3><br>\n";
	print	"If it doesn't work, please try one of the following links:<br>\n";
	print	"<ol>\n";
	print	"<li><a href=\"$alternate\">$alternate</a>\n";
	print	"<li><a href=\"$destination\">$destination</a>\n";
	print	"</ol>\n";
	print	"<br>\n";
	print	"<hr>\n";
	print "Your IP address is $client_ip<br>\n";
	if ($client_name) {
		print "Your hostname is $client_name<br>\n";
	}
	print "<hr>\n";
	print "Contact the webmaster at <a href=\"mailto:webmaster\@nbgsara.nb.ca\">webmaster\@nbgsara.nb.ca</a>\n";
	print	"</body></html>";
}