<?php
/*
	This SQL query will create the table to store your object.

	CREATE TABLE `admin_users` (
	`admin_usersid` int(11) NOT NULL auto_increment,
	`username` VARCHAR(255) NOT NULL,
	`password` CHAR(40) NOT NULL,
	`salt` VARCHAR(255) NOT NULL,
	`privalleges` VARCHAR(255) NOT NULL,
	`logged_in_key` VARCHAR(255) NOT NULL,
	`age` VARCHAR(255) NOT NULL,
	`uaip` VARCHAR(255) NOT NULL, PRIMARY KEY  (`admin_usersid`)) ENGINE=MyISAM;
*/

/**
* <b>admin_users</b> class with integrated CRUD methods.
* @author Php Object Generator
* @version POG 3.0e / PHP5
* @copyright Free for personal & commercial use. (Offered under the BSD license)
* @link http://www.phpobjectgenerator.com/?language=php5&wrapper=pog&objectName=admin_users&attributeList=array+%28%0A++0+%3D%3E+%27username%27%2C%0A++1+%3D%3E+%27password%27%2C%0A++2+%3D%3E+%27salt%27%2C%0A++3+%3D%3E+%27privalleges%27%2C%0A++4+%3D%3E+%27logged_in_key%27%2C%0A++5+%3D%3E+%27age%27%2C%0A++6+%3D%3E+%27uaip%27%2C%0A%29&typeList=array+%28%0A++0+%3D%3E+%27VARCHAR%28255%29%27%2C%0A++1+%3D%3E+%27CHAR%2840%29%27%2C%0A++2+%3D%3E+%27VARCHAR%28255%29%27%2C%0A++3+%3D%3E+%27VARCHAR%28255%29%27%2C%0A++4+%3D%3E+%27VARCHAR%28255%29%27%2C%0A++5+%3D%3E+%27VARCHAR%28255%29%27%2C%0A++6+%3D%3E+%27VARCHAR%28255%29%27%2C%0A%29
*/
include_once('class.pog_base.php');
class admin_users extends POG_Base
{
	public $admin_usersId = '';

	/**
	 * @var VARCHAR(255)
	 */
	public $username;
	
	/**
	 * @var CHAR(40)
	 */
	public $password;
	
	/**
	 * @var VARCHAR(255)
	 */
	public $salt;
	
	/**
	 * @var VARCHAR(255)
	 */
	public $privalleges;
	
	/**
	 * @var VARCHAR(255)
	 */
	public $logged_in_key;
	
	/**
	 * @var VARCHAR(255)
	 */
	public $age;
	
	/**
	 * @var VARCHAR(255)
	 */
	public $uaip;
	
	public $pog_attribute_type = array(
		"admin_usersId" => array('db_attributes' => array("NUMERIC", "INT")),
		"username" => array('db_attributes' => array("TEXT", "VARCHAR", "255")),
		"password" => array('db_attributes' => array("TEXT", "CHAR", "40")),
		"salt" => array('db_attributes' => array("TEXT", "VARCHAR", "255")),
		"privalleges" => array('db_attributes' => array("TEXT", "VARCHAR", "255")),
		"logged_in_key" => array('db_attributes' => array("TEXT", "VARCHAR", "255")),
		"age" => array('db_attributes' => array("TEXT", "VARCHAR", "255")),
		"uaip" => array('db_attributes' => array("TEXT", "VARCHAR", "255")),
		);
	public $pog_query;
	
	
	/**
	* Getter for some private attributes
	* @return mixed $attribute
	*/
	public function __get($attribute)
	{
		if (isset($this->{"_".$attribute}))
		{
			return $this->{"_".$attribute};
		}
		else
		{
			return false;
		}
	}
	
	function admin_users($username='', $password='', $salt='', $privalleges='', $logged_in_key='', $age='', $uaip='')
	{
		$this->username = $username;
		$this->password = $password;
		$this->salt = $salt;
		$this->privalleges = $privalleges;
		$this->logged_in_key = $logged_in_key;
		$this->age = $age;
		$this->uaip = $uaip;
	}
	
	
	/**
	* Gets object from database
	* @param integer $admin_usersId 
	* @return object $admin_users
	*/
	function Get($admin_usersId)
	{
		$connection = Database::Connect();
		$this->pog_query = "select * from `admin_users` where `admin_usersid`='".intval($admin_usersId)."' LIMIT 1";
		$cursor = Database::Reader($this->pog_query, $connection);
		while ($row = Database::Read($cursor))
		{
			$this->admin_usersId = $row['admin_usersid'];
			$this->username = $this->Unescape($row['username']);
			$this->password = $this->Unescape($row['password']);
			$this->salt = $this->Unescape($row['salt']);
			$this->privalleges = $this->Unescape($row['privalleges']);
			$this->logged_in_key = $this->Unescape($row['logged_in_key']);
			$this->age = $this->Unescape($row['age']);
			$this->uaip = $this->Unescape($row['uaip']);
		}
		return $this;
	}
	
	
	/**
	* Returns a sorted array of objects that match given conditions
	* @param multidimensional array {("field", "comparator", "value"), ("field", "comparator", "value"), ...} 
	* @param string $sortBy 
	* @param boolean $ascending 
	* @param int limit 
	* @return array $admin_usersList
	*/
	function GetList($fcv_array = array(), $sortBy='', $ascending=true, $limit='')
	{
		$connection = Database::Connect();
		$sqlLimit = ($limit != '' ? "LIMIT $limit" : '');
		$this->pog_query = "select * from `admin_users` ";
		$admin_usersList = Array();
		if (sizeof($fcv_array) > 0)
		{
			$this->pog_query .= " where ";
			for ($i=0, $c=sizeof($fcv_array); $i<$c; $i++)
			{
				if (sizeof($fcv_array[$i]) == 1)
				{
					$this->pog_query .= " ".$fcv_array[$i][0]." ";
					continue;
				}
				else
				{
					if ($i > 0 && sizeof($fcv_array[$i-1]) != 1)
					{
						$this->pog_query .= " AND ";
					}
					if (isset($this->pog_attribute_type[$fcv_array[$i][0]]['db_attributes']) && $this->pog_attribute_type[$fcv_array[$i][0]]['db_attributes'][0] != 'NUMERIC' && $this->pog_attribute_type[$fcv_array[$i][0]]['db_attributes'][0] != 'SET')
					{
						if ($GLOBALS['configuration']['db_encoding'] == 1)
						{
							$value = POG_Base::IsColumn($fcv_array[$i][2]) ? "BASE64_DECODE(".$fcv_array[$i][2].")" : "'".$fcv_array[$i][2]."'";
							$this->pog_query .= "BASE64_DECODE(`".$fcv_array[$i][0]."`) ".$fcv_array[$i][1]." ".$value;
						}
						else
						{
							$value =  POG_Base::IsColumn($fcv_array[$i][2]) ? $fcv_array[$i][2] : "'".$this->Escape($fcv_array[$i][2])."'";
							$this->pog_query .= "`".$fcv_array[$i][0]."` ".$fcv_array[$i][1]." ".$value;
						}
					}
					else
					{
						$value = POG_Base::IsColumn($fcv_array[$i][2]) ? $fcv_array[$i][2] : "'".$fcv_array[$i][2]."'";
						$this->pog_query .= "`".$fcv_array[$i][0]."` ".$fcv_array[$i][1]." ".$value;
					}
				}
			}
		}
		if ($sortBy != '')
		{
			if (isset($this->pog_attribute_type[$sortBy]['db_attributes']) && $this->pog_attribute_type[$sortBy]['db_attributes'][0] != 'NUMERIC' && $this->pog_attribute_type[$sortBy]['db_attributes'][0] != 'SET')
			{
				if ($GLOBALS['configuration']['db_encoding'] == 1)
				{
					$sortBy = "BASE64_DECODE($sortBy) ";
				}
				else
				{
					$sortBy = "$sortBy ";
				}
			}
			else
			{
				$sortBy = "$sortBy ";
			}
		}
		else
		{
			$sortBy = "admin_usersid";
		}
		$this->pog_query .= " order by ".$sortBy." ".($ascending ? "asc" : "desc")." $sqlLimit";
		$thisObjectName = get_class($this);
		$cursor = Database::Reader($this->pog_query, $connection);
		while ($row = Database::Read($cursor))
		{
			$admin_users = new $thisObjectName();
			$admin_users->admin_usersId = $row['admin_usersid'];
			$admin_users->username = $this->Unescape($row['username']);
			$admin_users->password = $this->Unescape($row['password']);
			$admin_users->salt = $this->Unescape($row['salt']);
			$admin_users->privalleges = $this->Unescape($row['privalleges']);
			$admin_users->logged_in_key = $this->Unescape($row['logged_in_key']);
			$admin_users->age = $this->Unescape($row['age']);
			$admin_users->uaip = $this->Unescape($row['uaip']);
			$admin_usersList[] = $admin_users;
		}
		return $admin_usersList;
	}
	
	
	/**
	* Saves the object to the database
	* @return integer $admin_usersId
	*/
	function Save()
	{
		$connection = Database::Connect();
		$this->pog_query = "select `admin_usersid` from `admin_users` where `admin_usersid`='".$this->admin_usersId."' LIMIT 1";
		$rows = Database::Query($this->pog_query, $connection);
		if ($rows > 0)
		{
			$this->pog_query = "update `admin_users` set 
			`username`='".$this->Escape($this->username)."', 
			`password`='".$this->Escape($this->password)."', 
			`salt`='".$this->Escape($this->salt)."', 
			`privalleges`='".$this->Escape($this->privalleges)."', 
			`logged_in_key`='".$this->Escape($this->logged_in_key)."', 
			`age`='".$this->Escape($this->age)."', 
			`uaip`='".$this->Escape($this->uaip)."' where `admin_usersid`='".$this->admin_usersId."'";
		}
		else
		{
			$this->pog_query = "insert into `admin_users` (`username`, `password`, `salt`, `privalleges`, `logged_in_key`, `age`, `uaip` ) values (
			'".$this->Escape($this->username)."', 
			'".$this->Escape($this->password)."', 
			'".$this->Escape($this->salt)."', 
			'".$this->Escape($this->privalleges)."', 
			'".$this->Escape($this->logged_in_key)."', 
			'".$this->Escape($this->age)."', 
			'".$this->Escape($this->uaip)."' )";
		}
		$insertId = Database::InsertOrUpdate($this->pog_query, $connection);
		if ($this->admin_usersId == "")
		{
			$this->admin_usersId = $insertId;
		}
		return $this->admin_usersId;
	}
	
	
	/**
	* Clones the object and saves it to the database
	* @return integer $admin_usersId
	*/
	function SaveNew()
	{
		$this->admin_usersId = '';
		return $this->Save();
	}
	
	
	/**
	* Deletes the object from the database
	* @return boolean
	*/
	function Delete()
	{
		$connection = Database::Connect();
		$this->pog_query = "delete from `admin_users` where `admin_usersid`='".$this->admin_usersId."'";
		return Database::NonQuery($this->pog_query, $connection);
	}
	
	
	/**
	* Deletes a list of objects that match given conditions
	* @param multidimensional array {("field", "comparator", "value"), ("field", "comparator", "value"), ...} 
	* @param bool $deep 
	* @return 
	*/
	function DeleteList($fcv_array)
	{
		if (sizeof($fcv_array) > 0)
		{
			$connection = Database::Connect();
			$pog_query = "delete from `admin_users` where ";
			for ($i=0, $c=sizeof($fcv_array); $i<$c; $i++)
			{
				if (sizeof($fcv_array[$i]) == 1)
				{
					$pog_query .= " ".$fcv_array[$i][0]." ";
					continue;
				}
				else
				{
					if ($i > 0 && sizeof($fcv_array[$i-1]) !== 1)
					{
						$pog_query .= " AND ";
					}
					if (isset($this->pog_attribute_type[$fcv_array[$i][0]]['db_attributes']) && $this->pog_attribute_type[$fcv_array[$i][0]]['db_attributes'][0] != 'NUMERIC' && $this->pog_attribute_type[$fcv_array[$i][0]]['db_attributes'][0] != 'SET')
					{
						$pog_query .= "`".$fcv_array[$i][0]."` ".$fcv_array[$i][1]." '".$this->Escape($fcv_array[$i][2])."'";
					}
					else
					{
						$pog_query .= "`".$fcv_array[$i][0]."` ".$fcv_array[$i][1]." '".$fcv_array[$i][2]."'";
					}
				}
			}
			return Database::NonQuery($pog_query, $connection);
		}
	}
}
?>