<?php
/*
	This SQL query will create the table to store your object.

	CREATE TABLE `orders` (
	`ordersid` int(11) NOT NULL auto_increment,
	`name` VARCHAR(255) NOT NULL,
	`price` DECIMAL(16,2) NOT NULL,
	`quantity` VARCHAR(255) NOT NULL,
	`product_code` VARCHAR(255) NOT NULL,
	`postage` DECIMAL(16,2) NOT NULL,
	`only_one` VARCHAR(255) NOT NULL,
	`belongs_to_buyer` INT NOT NULL,
	`weight` DECIMAL(16,2) NOT NULL,
	`variant` MEDIUMTEXT NOT NULL, PRIMARY KEY  (`ordersid`)) ENGINE=MyISAM;
*/

/**
* <b>orders</b> class with integrated CRUD methods.
* @author Php Object Generator
* @version POG 3.0e / PHP5.1 MYSQL
* @see http://www.phpobjectgenerator.com/plog/tutorials/45/pdo-mysql
* @copyright Free for personal & commercial use. (Offered under the BSD license)
* @link http://www.phpobjectgenerator.com/?language=php5.1&wrapper=pdo&pdoDriver=mysql&objectName=orders&attributeList=array+%28%0A++0+%3D%3E+%27name%27%2C%0A++1+%3D%3E+%27price%27%2C%0A++2+%3D%3E+%27quantity%27%2C%0A++3+%3D%3E+%27product_code%27%2C%0A++4+%3D%3E+%27postage%27%2C%0A++5+%3D%3E+%27only_one%27%2C%0A++6+%3D%3E+%27belongs_to_buyer%27%2C%0A++7+%3D%3E+%27weight%27%2C%0A++8+%3D%3E+%27variant%27%2C%0A%29&typeList=array%2B%2528%250A%2B%2B0%2B%253D%253E%2B%2527VARCHAR%2528255%2529%2527%252C%250A%2B%2B1%2B%253D%253E%2B%2527DECIMAL%252816%252C2%2529%2527%252C%250A%2B%2B2%2B%253D%253E%2B%2527VARCHAR%2528255%2529%2527%252C%250A%2B%2B3%2B%253D%253E%2B%2527VARCHAR%2528255%2529%2527%252C%250A%2B%2B4%2B%253D%253E%2B%2527DECIMAL%252816%252C2%2529%2527%252C%250A%2B%2B5%2B%253D%253E%2B%2527VARCHAR%2528255%2529%2527%252C%250A%2B%2B6%2B%253D%253E%2B%2527INT%2527%252C%250A%2B%2B7%2B%253D%253E%2B%2527DECIMAL%252816%252C2%2529%2527%252C%250A%2B%2B8%2B%253D%253E%2B%2527MEDIUMTEXT%2527%252C%250A%2529
*/
include_once('class.pog_base.php');
class orders extends POG_Base
{
	public $ordersId = '';

	/**
	 * @var VARCHAR(255)
	 */
	public $name;
	
	/**
	 * @var DECIMAL(16,2)
	 */
	public $price;
	
	/**
	 * @var VARCHAR(255)
	 */
	public $quantity;
	
	/**
	 * @var VARCHAR(255)
	 */
	public $product_code;
	
	/**
	 * @var DECIMAL(16,2)
	 */
	public $postage;
	
	/**
	 * @var VARCHAR(255)
	 */
	public $only_one;
	
	/**
	 * @var INT
	 */
	public $belongs_to_buyer;
	
	/**
	 * @var DECIMAL(16,2)
	 */
	public $weight;
	
	/**
	 * @var MEDIUMTEXT
	 */
	public $variant;
	
	public $pog_attribute_type = array(
		"ordersId" => array('db_attributes' => array("NUMERIC", "INT")),
		"name" => array('db_attributes' => array("TEXT", "VARCHAR", "255")),
		"price" => array('db_attributes' => array("NUMERIC", "DECIMAL", "16,2")),
		"quantity" => array('db_attributes' => array("TEXT", "VARCHAR", "255")),
		"product_code" => array('db_attributes' => array("TEXT", "VARCHAR", "255")),
		"postage" => array('db_attributes' => array("NUMERIC", "DECIMAL", "16,2")),
		"only_one" => array('db_attributes' => array("TEXT", "VARCHAR", "255")),
		"belongs_to_buyer" => array('db_attributes' => array("NUMERIC", "INT")),
		"weight" => array('db_attributes' => array("NUMERIC", "DECIMAL", "16,2")),
		"variant" => array('db_attributes' => array("TEXT", "MEDIUMTEXT")),
		);
	public $pog_query;
	
	
	/**
	* Getter for some private attributes
	* @return mixed $attribute
	*/
	public function __get($attribute)
	{
		if (isset($this->{"_".$attribute}))
		{
			return $this->{"_".$attribute};
		}
		else
		{
			return false;
		}
	}
	
	function orders($name='', $price='', $quantity='', $product_code='', $postage='', $only_one='', $belongs_to_buyer='', $weight='', $variant='')
	{
		$this->name = $name;
		$this->price = $price;
		$this->quantity = $quantity;
		$this->product_code = $product_code;
		$this->postage = $postage;
		$this->only_one = $only_one;
		$this->belongs_to_buyer = $belongs_to_buyer;
		$this->weight = $weight;
		$this->variant = $variant;
	}
	
	
	/**
	* Gets object from database
	* @param integer $ordersId 
	* @return object $orders
	*/
	function Get($ordersId)
	{
		$connection = Database::Connect();
		$this->pog_query = "select * from `orders` where `ordersid`='".intval($ordersId)."' LIMIT 1";
		$cursor = Database::Reader($this->pog_query, $connection);
		while ($row = Database::Read($cursor))
		{
			$this->ordersId = $row['ordersid'];
			$this->name = $this->Unescape($row['name']);
			$this->price = $this->Unescape($row['price']);
			$this->quantity = $this->Unescape($row['quantity']);
			$this->product_code = $this->Unescape($row['product_code']);
			$this->postage = $this->Unescape($row['postage']);
			$this->only_one = $this->Unescape($row['only_one']);
			$this->belongs_to_buyer = $this->Unescape($row['belongs_to_buyer']);
			$this->weight = $this->Unescape($row['weight']);
			$this->variant = $this->Unescape($row['variant']);
		}
		return $this;
	}
	
	
	/**
	* Returns a sorted array of objects that match given conditions
	* @param multidimensional array {("field", "comparator", "value"), ("field", "comparator", "value"), ...} 
	* @param string $sortBy 
	* @param boolean $ascending 
	* @param int limit 
	* @return array $ordersList
	*/
	function GetList($fcv_array = array(), $sortBy='', $ascending=true, $limit='')
	{
		$connection = Database::Connect();
		$sqlLimit = ($limit != '' ? "LIMIT $limit" : '');
		$this->pog_query = "select * from `orders` ";
		$ordersList = Array();
		if (sizeof($fcv_array) > 0)
		{
			$this->pog_query .= " where ";
			for ($i=0, $c=sizeof($fcv_array); $i<$c; $i++)
			{
				if (sizeof($fcv_array[$i]) == 1)
				{
					$this->pog_query .= " ".$fcv_array[$i][0]." ";
					continue;
				}
				else
				{
					if ($i > 0 && sizeof($fcv_array[$i-1]) != 1)
					{
						$this->pog_query .= " AND ";
					}
					if (isset($this->pog_attribute_type[$fcv_array[$i][0]]['db_attributes']) && $this->pog_attribute_type[$fcv_array[$i][0]]['db_attributes'][0] != 'NUMERIC' && $this->pog_attribute_type[$fcv_array[$i][0]]['db_attributes'][0] != 'SET')
					{
						if ($GLOBALS['configuration']['db_encoding'] == 1)
						{
							$value = POG_Base::IsColumn($fcv_array[$i][2]) ? "BASE64_DECODE(".$fcv_array[$i][2].")" : "'".$fcv_array[$i][2]."'";
							$this->pog_query .= "BASE64_DECODE(`".$fcv_array[$i][0]."`) ".$fcv_array[$i][1]." ".$value;
						}
						else
						{
							$value =  POG_Base::IsColumn($fcv_array[$i][2]) ? $fcv_array[$i][2] : "'".$this->Escape($fcv_array[$i][2])."'";
							$this->pog_query .= "`".$fcv_array[$i][0]."` ".$fcv_array[$i][1]." ".$value;
						}
					}
					else
					{
						$value = POG_Base::IsColumn($fcv_array[$i][2]) ? $fcv_array[$i][2] : "'".$fcv_array[$i][2]."'";
						$this->pog_query .= "`".$fcv_array[$i][0]."` ".$fcv_array[$i][1]." ".$value;
					}
				}
			}
		}
		if ($sortBy != '')
		{
			if (isset($this->pog_attribute_type[$sortBy]['db_attributes']) && $this->pog_attribute_type[$sortBy]['db_attributes'][0] != 'NUMERIC' && $this->pog_attribute_type[$sortBy]['db_attributes'][0] != 'SET')
			{
				if ($GLOBALS['configuration']['db_encoding'] == 1)
				{
					$sortBy = "BASE64_DECODE($sortBy) ";
				}
				else
				{
					$sortBy = "$sortBy ";
				}
			}
			else
			{
				$sortBy = "$sortBy ";
			}
		}
		else
		{
			$sortBy = "ordersid";
		}
		$this->pog_query .= " order by ".$sortBy." ".($ascending ? "asc" : "desc")." $sqlLimit";
		$thisObjectName = get_class($this);
		$cursor = Database::Reader($this->pog_query, $connection);
		while ($row = Database::Read($cursor))
		{
			$orders = new $thisObjectName();
			$orders->ordersId = $row['ordersid'];
			$orders->name = $this->Unescape($row['name']);
			$orders->price = $this->Unescape($row['price']);
			$orders->quantity = $this->Unescape($row['quantity']);
			$orders->product_code = $this->Unescape($row['product_code']);
			$orders->postage = $this->Unescape($row['postage']);
			$orders->only_one = $this->Unescape($row['only_one']);
			$orders->belongs_to_buyer = $this->Unescape($row['belongs_to_buyer']);
			$orders->weight = $this->Unescape($row['weight']);
			$orders->variant = $this->Unescape($row['variant']);
			$ordersList[] = $orders;
		}
		return $ordersList;
	}
	
	
	/**
	* Saves the object to the database
	* @return integer $ordersId
	*/
	function Save()
	{
		$connection = Database::Connect();
		$this->pog_query = "select `ordersid` from `orders` where `ordersid`='".$this->ordersId."' LIMIT 1";
		$rows = Database::Query($this->pog_query, $connection);
		if ($rows > 0)
		{
			$this->pog_query = "update `orders` set 
			`name`='".$this->Escape($this->name)."', 
			`price`='".$this->Escape($this->price)."', 
			`quantity`='".$this->Escape($this->quantity)."', 
			`product_code`='".$this->Escape($this->product_code)."', 
			`postage`='".$this->Escape($this->postage)."', 
			`only_one`='".$this->Escape($this->only_one)."', 
			`belongs_to_buyer`='".$this->Escape($this->belongs_to_buyer)."', 
			`weight`='".$this->Escape($this->weight)."', 
			`variant`='".$this->Escape($this->variant)."' where `ordersid`='".$this->ordersId."'";
		}
		else
		{
			$this->pog_query = "insert into `orders` (`name`, `price`, `quantity`, `product_code`, `postage`, `only_one`, `belongs_to_buyer`, `weight`, `variant` ) values (
			'".$this->Escape($this->name)."', 
			'".$this->Escape($this->price)."', 
			'".$this->Escape($this->quantity)."', 
			'".$this->Escape($this->product_code)."', 
			'".$this->Escape($this->postage)."', 
			'".$this->Escape($this->only_one)."', 
			'".$this->Escape($this->belongs_to_buyer)."', 
			'".$this->Escape($this->weight)."', 
			'".$this->Escape($this->variant)."' )";
		}
		$insertId = Database::InsertOrUpdate($this->pog_query, $connection);
		if ($this->ordersId == "")
		{
			$this->ordersId = $insertId;
		}
		return $this->ordersId;
	}
	
	
	/**
	* Clones the object and saves it to the database
	* @return integer $ordersId
	*/
	function SaveNew()
	{
		$this->ordersId = '';
		return $this->Save();
	}
	
	
	/**
	* Deletes the object from the database
	* @return boolean
	*/
	function Delete()
	{
		$connection = Database::Connect();
		$this->pog_query = "delete from `orders` where `ordersid`='".$this->ordersId."'";
		return Database::NonQuery($this->pog_query, $connection);
	}
	
	
	/**
	* Deletes a list of objects that match given conditions
	* @param multidimensional array {("field", "comparator", "value"), ("field", "comparator", "value"), ...} 
	* @param bool $deep 
	* @return 
	*/
	function DeleteList($fcv_array)
	{
		if (sizeof($fcv_array) > 0)
		{
			$connection = Database::Connect();
			$pog_query = "delete from `orders` where ";
			for ($i=0, $c=sizeof($fcv_array); $i<$c; $i++)
			{
				if (sizeof($fcv_array[$i]) == 1)
				{
					$pog_query .= " ".$fcv_array[$i][0]." ";
					continue;
				}
				else
				{
					if ($i > 0 && sizeof($fcv_array[$i-1]) !== 1)
					{
						$pog_query .= " AND ";
					}
					if (isset($this->pog_attribute_type[$fcv_array[$i][0]]['db_attributes']) && $this->pog_attribute_type[$fcv_array[$i][0]]['db_attributes'][0] != 'NUMERIC' && $this->pog_attribute_type[$fcv_array[$i][0]]['db_attributes'][0] != 'SET')
					{
						$pog_query .= "`".$fcv_array[$i][0]."` ".$fcv_array[$i][1]." '".$this->Escape($fcv_array[$i][2])."'";
					}
					else
					{
						$pog_query .= "`".$fcv_array[$i][0]."` ".$fcv_array[$i][1]." '".$fcv_array[$i][2]."'";
					}
				}
			}
			return Database::NonQuery($pog_query, $connection);
		}
	}
}
?>