<?php
/*
	This SQL query will create the table to store your object.

	CREATE TABLE `products` (
	`productsid` int(11) NOT NULL auto_increment,
	`name` VARCHAR(255) NOT NULL,
	`price` DECIMAL(16,2) NOT NULL,
	`only_one` VARCHAR(255) NOT NULL,
	`weight` VARCHAR(255) NOT NULL,
	`code` VARCHAR(255) NOT NULL,
	`variants` MEDIUMTEXT NOT NULL,
	`type` VARCHAR(255) NOT NULL,
	`gal_id` INT NOT NULL,
	`form_id` INT NOT NULL,
	`in_stock` INT NOT NULL, PRIMARY KEY  (`productsid`)) ENGINE=MyISAM;
*/

/**
* <b>products</b> class with integrated CRUD methods.
* @author Php Object Generator
* @version POG 3.0e / PHP5.1 MYSQL
* @see http://www.phpobjectgenerator.com/plog/tutorials/45/pdo-mysql
* @copyright Free for personal & commercial use. (Offered under the BSD license)
* @link http://www.phpobjectgenerator.com/?language=php5.1&wrapper=pdo&pdoDriver=mysql&objectName=products&attributeList=array+%28%0A++0+%3D%3E+%27name%27%2C%0A++1+%3D%3E+%27price%27%2C%0A++2+%3D%3E+%27only_one%27%2C%0A++3+%3D%3E+%27weight%27%2C%0A++4+%3D%3E+%27code%27%2C%0A++5+%3D%3E+%27variants%27%2C%0A++6+%3D%3E+%27type%27%2C%0A++7+%3D%3E+%27gal_id%27%2C%0A++8+%3D%3E+%27form_id%27%2C%0A++9+%3D%3E+%27in_stock%27%2C%0A%29&typeList=array%2B%2528%250A%2B%2B0%2B%253D%253E%2B%2527VARCHAR%2528255%2529%2527%252C%250A%2B%2B1%2B%253D%253E%2B%2527DECIMAL%252816%252C2%2529%2527%252C%250A%2B%2B2%2B%253D%253E%2B%2527VARCHAR%2528255%2529%2527%252C%250A%2B%2B3%2B%253D%253E%2B%2527VARCHAR%2528255%2529%2527%252C%250A%2B%2B4%2B%253D%253E%2B%2527VARCHAR%2528255%2529%2527%252C%250A%2B%2B5%2B%253D%253E%2B%2527MEDIUMTEXT%2527%252C%250A%2B%2B6%2B%253D%253E%2B%2527VARCHAR%2528255%2529%2527%252C%250A%2B%2B7%2B%253D%253E%2B%2527INT%2527%252C%250A%2B%2B8%2B%253D%253E%2B%2527INT%2527%252C%250A%2B%2B9%2B%253D%253E%2B%2527INT%2527%252C%250A%2529
*/
include_once('class.pog_base.php');
class products extends POG_Base
{
	public $productsId = '';

	/**
	 * @var VARCHAR(255)
	 */
	public $name;
	
	/**
	 * @var DECIMAL(16,2)
	 */
	public $price;
	
	/**
	 * @var VARCHAR(255)
	 */
	public $only_one;
	
	/**
	 * @var VARCHAR(255)
	 */
	public $weight;
	
	/**
	 * @var VARCHAR(255)
	 */
	public $code;
	
	/**
	 * @var MEDIUMTEXT
	 */
	public $variants;
	
	/**
	 * @var VARCHAR(255)
	 */
	public $type;
	
	/**
	 * @var INT
	 */
	public $gal_id;
	
	/**
	 * @var INT
	 */
	public $form_id;
	
	/**
	 * @var INT
	 */
	public $in_stock;
	
	public $pog_attribute_type = array(
		"productsId" => array('db_attributes' => array("NUMERIC", "INT")),
		"name" => array('db_attributes' => array("TEXT", "VARCHAR", "255")),
		"price" => array('db_attributes' => array("NUMERIC", "DECIMAL", "16,2")),
		"only_one" => array('db_attributes' => array("TEXT", "VARCHAR", "255")),
		"weight" => array('db_attributes' => array("TEXT", "VARCHAR", "255")),
		"code" => array('db_attributes' => array("TEXT", "VARCHAR", "255")),
		"variants" => array('db_attributes' => array("TEXT", "MEDIUMTEXT")),
		"type" => array('db_attributes' => array("TEXT", "VARCHAR", "255")),
		"gal_id" => array('db_attributes' => array("NUMERIC", "INT")),
		"form_id" => array('db_attributes' => array("NUMERIC", "INT")),
		"in_stock" => array('db_attributes' => array("NUMERIC", "INT")),
		);
	public $pog_query;
	
	
	/**
	* Getter for some private attributes
	* @return mixed $attribute
	*/
	public function __get($attribute)
	{
		if (isset($this->{"_".$attribute}))
		{
			return $this->{"_".$attribute};
		}
		else
		{
			return false;
		}
	}
	
	function products($name='', $price='', $only_one='', $weight='', $code='', $variants='', $type='', $gal_id='', $form_id='', $in_stock='')
	{
		$this->name = $name;
		$this->price = $price;
		$this->only_one = $only_one;
		$this->weight = $weight;
		$this->code = $code;
		$this->variants = $variants;
		$this->type = $type;
		$this->gal_id = $gal_id;
		$this->form_id = $form_id;
		$this->in_stock = $in_stock;
	}
	
	
	/**
	* Gets object from database
	* @param integer $productsId 
	* @return object $products
	*/
	function Get($productsId)
	{
		$connection = Database::Connect();
		$this->pog_query = "select * from `products` where `productsid`='".intval($productsId)."' LIMIT 1";
		$cursor = Database::Reader($this->pog_query, $connection);
		while ($row = Database::Read($cursor))
		{
			$this->productsId = $row['productsid'];
			$this->name = $this->Unescape($row['name']);
			$this->price = $this->Unescape($row['price']);
			$this->only_one = $this->Unescape($row['only_one']);
			$this->weight = $this->Unescape($row['weight']);
			$this->code = $this->Unescape($row['code']);
			$this->variants = $this->Unescape($row['variants']);
			$this->type = $this->Unescape($row['type']);
			$this->gal_id = $this->Unescape($row['gal_id']);
			$this->form_id = $this->Unescape($row['form_id']);
			$this->in_stock = $this->Unescape($row['in_stock']);
		}
		return $this;
	}
	
	
	/**
	* Returns a sorted array of objects that match given conditions
	* @param multidimensional array {("field", "comparator", "value"), ("field", "comparator", "value"), ...} 
	* @param string $sortBy 
	* @param boolean $ascending 
	* @param int limit 
	* @return array $productsList
	*/
	function GetList($fcv_array = array(), $sortBy='', $ascending=true, $limit='')
	{
		$connection = Database::Connect();
		$sqlLimit = ($limit != '' ? "LIMIT $limit" : '');
		$this->pog_query = "select * from `products` ";
		$productsList = Array();
		if (sizeof($fcv_array) > 0)
		{
			$this->pog_query .= " where ";
			for ($i=0, $c=sizeof($fcv_array); $i<$c; $i++)
			{
				if (sizeof($fcv_array[$i]) == 1)
				{
					$this->pog_query .= " ".$fcv_array[$i][0]." ";
					continue;
				}
				else
				{
					if ($i > 0 && sizeof($fcv_array[$i-1]) != 1)
					{
						$this->pog_query .= " AND ";
					}
					if (isset($this->pog_attribute_type[$fcv_array[$i][0]]['db_attributes']) && $this->pog_attribute_type[$fcv_array[$i][0]]['db_attributes'][0] != 'NUMERIC' && $this->pog_attribute_type[$fcv_array[$i][0]]['db_attributes'][0] != 'SET')
					{
						if ($GLOBALS['configuration']['db_encoding'] == 1)
						{
							$value = POG_Base::IsColumn($fcv_array[$i][2]) ? "BASE64_DECODE(".$fcv_array[$i][2].")" : "'".$fcv_array[$i][2]."'";
							$this->pog_query .= "BASE64_DECODE(`".$fcv_array[$i][0]."`) ".$fcv_array[$i][1]." ".$value;
						}
						else
						{
							$value =  POG_Base::IsColumn($fcv_array[$i][2]) ? $fcv_array[$i][2] : "'".$this->Escape($fcv_array[$i][2])."'";
							$this->pog_query .= "`".$fcv_array[$i][0]."` ".$fcv_array[$i][1]." ".$value;
						}
					}
					else
					{
						$value = POG_Base::IsColumn($fcv_array[$i][2]) ? $fcv_array[$i][2] : "'".$fcv_array[$i][2]."'";
						$this->pog_query .= "`".$fcv_array[$i][0]."` ".$fcv_array[$i][1]." ".$value;
					}
				}
			}
		}
		if ($sortBy != '')
		{
			if (isset($this->pog_attribute_type[$sortBy]['db_attributes']) && $this->pog_attribute_type[$sortBy]['db_attributes'][0] != 'NUMERIC' && $this->pog_attribute_type[$sortBy]['db_attributes'][0] != 'SET')
			{
				if ($GLOBALS['configuration']['db_encoding'] == 1)
				{
					$sortBy = "BASE64_DECODE($sortBy) ";
				}
				else
				{
					$sortBy = "$sortBy ";
				}
			}
			else
			{
				$sortBy = "$sortBy ";
			}
		}
		else
		{
			$sortBy = "productsid";
		}
		$this->pog_query .= " order by ".$sortBy." ".($ascending ? "asc" : "desc")." $sqlLimit";
		$thisObjectName = get_class($this);
		$cursor = Database::Reader($this->pog_query, $connection);
		while ($row = Database::Read($cursor))
		{
			$products = new $thisObjectName();
			$products->productsId = $row['productsid'];
			$products->name = $this->Unescape($row['name']);
			$products->price = $this->Unescape($row['price']);
			$products->only_one = $this->Unescape($row['only_one']);
			$products->weight = $this->Unescape($row['weight']);
			$products->code = $this->Unescape($row['code']);
			$products->variants = $this->Unescape($row['variants']);
			$products->type = $this->Unescape($row['type']);
			$products->gal_id = $this->Unescape($row['gal_id']);
			$products->form_id = $this->Unescape($row['form_id']);
			$products->in_stock = $this->Unescape($row['in_stock']);
			$productsList[] = $products;
		}
		return $productsList;
	}
	
	
	/**
	* Saves the object to the database
	* @return integer $productsId
	*/
	function Save()
	{
		$connection = Database::Connect();
		$this->pog_query = "select `productsid` from `products` where `productsid`='".$this->productsId."' LIMIT 1";
		$rows = Database::Query($this->pog_query, $connection);
		if ($rows > 0)
		{
			$this->pog_query = "update `products` set 
			`name`='".$this->Escape($this->name)."', 
			`price`='".$this->Escape($this->price)."', 
			`only_one`='".$this->Escape($this->only_one)."', 
			`weight`='".$this->Escape($this->weight)."', 
			`code`='".$this->Escape($this->code)."', 
			`variants`='".$this->Escape($this->variants)."', 
			`type`='".$this->Escape($this->type)."', 
			`gal_id`='".$this->Escape($this->gal_id)."', 
			`form_id`='".$this->Escape($this->form_id)."', 
			`in_stock`='".$this->Escape($this->in_stock)."' where `productsid`='".$this->productsId."'";
		}
		else
		{
			$this->pog_query = "insert into `products` (`name`, `price`, `only_one`, `weight`, `code`, `variants`, `type`, `gal_id`, `form_id`, `in_stock` ) values (
			'".$this->Escape($this->name)."', 
			'".$this->Escape($this->price)."', 
			'".$this->Escape($this->only_one)."', 
			'".$this->Escape($this->weight)."', 
			'".$this->Escape($this->code)."', 
			'".$this->Escape($this->variants)."', 
			'".$this->Escape($this->type)."', 
			'".$this->Escape($this->gal_id)."', 
			'".$this->Escape($this->form_id)."', 
			'".$this->Escape($this->in_stock)."' )";
		}
		$insertId = Database::InsertOrUpdate($this->pog_query, $connection);
		if ($this->productsId == "")
		{
			$this->productsId = $insertId;
		}
		return $this->productsId;
	}
	
	
	/**
	* Clones the object and saves it to the database
	* @return integer $productsId
	*/
	function SaveNew()
	{
		$this->productsId = '';
		return $this->Save();
	}
	
	
	/**
	* Deletes the object from the database
	* @return boolean
	*/
	function Delete()
	{
		$connection = Database::Connect();
		$this->pog_query = "delete from `products` where `productsid`='".$this->productsId."'";
		return Database::NonQuery($this->pog_query, $connection);
	}
	
	
	/**
	* Deletes a list of objects that match given conditions
	* @param multidimensional array {("field", "comparator", "value"), ("field", "comparator", "value"), ...} 
	* @param bool $deep 
	* @return 
	*/
	function DeleteList($fcv_array)
	{
		if (sizeof($fcv_array) > 0)
		{
			$connection = Database::Connect();
			$pog_query = "delete from `products` where ";
			for ($i=0, $c=sizeof($fcv_array); $i<$c; $i++)
			{
				if (sizeof($fcv_array[$i]) == 1)
				{
					$pog_query .= " ".$fcv_array[$i][0]." ";
					continue;
				}
				else
				{
					if ($i > 0 && sizeof($fcv_array[$i-1]) !== 1)
					{
						$pog_query .= " AND ";
					}
					if (isset($this->pog_attribute_type[$fcv_array[$i][0]]['db_attributes']) && $this->pog_attribute_type[$fcv_array[$i][0]]['db_attributes'][0] != 'NUMERIC' && $this->pog_attribute_type[$fcv_array[$i][0]]['db_attributes'][0] != 'SET')
					{
						$pog_query .= "`".$fcv_array[$i][0]."` ".$fcv_array[$i][1]." '".$this->Escape($fcv_array[$i][2])."'";
					}
					else
					{
						$pog_query .= "`".$fcv_array[$i][0]."` ".$fcv_array[$i][1]." '".$fcv_array[$i][2]."'";
					}
				}
			}
			return Database::NonQuery($pog_query, $connection);
		}
	}
}
?>