<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>

	<title>SetSeed Hub</title>
	<link rel="stylesheet" href="css/reset.css" type="text/css" media="screen" title="Default Style" charset="utf-8"/>
	<link rel="stylesheet" href="css/global.css" type="text/css" media="screen" title="Default Style" charset="utf-8"/>

	<script src="javascripts/jquery.js" type="text/javascript" charset="utf-8"></script>
		<script src="javascripts/jquery.hoverintent.js" type="text/javascript" charset="utf-8"></script>
	<script src="javascripts/sha1-min.js" type="text/javascript" charset="utf-8"></script>
	<script src="javascripts/passwordcheck.js" type="text/javascript" charset="utf-8"></script>
	<script src="javascripts/custom.js" type="text/javascript" charset="utf-8"></script>
	<link rel="icon" href="graphics/favicon.ico" type="image/x-icon"/>
	<link rel="shortcut icon" href="graphics/favicon.ico" type="image/x-icon"/>
</head>

<body {if !$loggedIn || $firstTimeUser}id="loginbody"{/if}>
	<div id="header"><img src="graphics/logo3.png" alt="SetSeed" id="logo"/>
	{if $firstTimeUser || !$loggedIn}{else}<div id="settings"></div>{/if}
	<h1>Hub</h1>
	<div class="clear"><!-- --></div>
	</div>
	{if $installExists}
		<div id="wrapper"><p class="info">Important: As a security precaution please remove the 'install' folder from your Document Root, then refresh this page to continue.</p></div>
	{else}

	<div id="wrapper">

		{if !$loggedIn && !$firstTimeUser}
			{if $loginFail}
			<p id="loginerror">Your user or password is incorrect.</p>
			{/if}
			<form action="/setseed-hub/" method="post" id="login">
				<input type="hidden" name="salt" value="{$salt}" id="salt"/>
				<input type="hidden" name="timestamp" value="{$time}" id="timestamp"/>
				<input type="hidden" name="hash" value="" id="hash"/>
				{if $returnUrl!=""}
				<input type="hidden" name="returnUrl" value="{$returnUrl}" id="returnUrl"/>
				{/if}
				<label class="addSiteLabel">Username:</label>
				<input type="text" name="username" value="" id="loginUser" class="permInput"/>
				<div class="clear"><!-- --></div>
				<label class="addSiteLabel">Password:</label>
				<input type="password" name="password" value="" id="loginPass" class="permInput"/>
				<div class="clear"><!-- --></div>
				<input type="image" src="graphics/login.gif" id="loginBut"/>
			</form>

		{/if}
		{if $firstTimeUser}
			<p class="info">Before you can administer your sites, you need to create a login account.</p>
			<form action="" method="post" id="addLogin">
				<input type="hidden" name="salt" value="{$salt}" id="salt"/>
				<input type="hidden" name="timestamp" value="{$time}" id="timestamp"/>
				<label class="addSiteLabel">Username:</label>
				<input type="text" name="username" value="" id="addUsername" class="permInput"/>
				<div class="clear"><!-- --></div>
				<label class="addSiteLabel">Password:</label>
				<input type="password" name="password" value="" id="addPassword1" class="permInput"/>
				<div class="clear"><!-- --></div>
				<label class="addSiteLabel">Password (again):</label>
				<input type="password" name="password2" value="" id="addPassword2" class="permInput"/>
				<div class="clear"><!-- --></div>
				<input type="image" src="graphics/create-account.gif" value="" id="loginBut"/>
			</form>
			<div class="clear"><!-- --></div>
			<p id="notmatch">The passwords don't match!</p>
			<p id="notstrong">Your password ins't secure enough.</p>
		{/if}
		{if $loggedIn}{*
			<form action="" method="post" id="addSiteForm">
				<label id="addSiteLabel">http://</label>
				<input type="text" name="url" value="" id="addSiteInput" class="permInput"/>
				<a href="" id="addSite">Add Site</a>
			</form>
*}

			<div class="clearfix"></div>
			{if $readytoload}
				<p class="section">You have {$readytoload|@count} site{if $readytoload|@count > 1}s{/if} in your 'sites' folder that {if $readytoload|@count > 1}aren't{else}isn’t{/if} imported into SetSeed. They will not be accessible until you have imported them. </p>
				{foreach from=$readytoload item=load key=key name=loop1}
					<div class="site clearfix importSite">
						<div class="preview"><img src="preview.php?folder={$load.folder}" class="previewImage"/><img src="graphics/corners.png" class="corners"/></div>
						<p class="url"><span class="edit">{$load.folder|truncate:30:"&hellip;"}</span></p>
						<div class="popup">	
						<img src='/admin/graphics/bpeditor/help.png' alt='{if $fullpriv==false}Your SetSeed master user doesn’t have sufficient privileges to automate the creation of new MySQL Databases and Users, so please use your web host control panel to create a new database and user to use with this website and enter the connection information. This must be a unique and empty database used only with the website you are creating. It is not the same database/user you used when you installed SetSeed. || You can also use an existing database which already contains a valid SetSeed site database by choosing ‘Use existing database’ and entering the connection information for your existing database. || {else}If you want to import this site into SetSeed but use an existing database which you’ve already imported mannually, you can choose ‘Use existing database’ and then enter the database connection information for your database. This should be a database that already contains a SetSeed website’s data.{/if}' class='bpe_help' />
						<h2>Import site: {$load.folder}</h2>
						<label class="bpe_label">URL:</label>
						{if $load.folder=="examplecom"}
						<p class="infoP">This is an example site and must use www.example.com as the URL. You will be able to visit it using the preview domain system at: http://www.example.com.{$server}/ providing you add that URL as an Addon Domain or Domain Alias in your server control panel.</p>
						<input type="hidden" value="www.example.com" name="newUrl" class="newUrl bpe_input"/>
						<input type="radio" value="import" name="dbsource" style="position:absolute;top:-1000px;" checked="checked"/>
						{else}
						<form class="editUrl"><input type="text" value="" name="newUrl" class="newUrl bpe_input"/></form>
						{/if}
						<label class="bpe_label">Folder:</label>
						<p class="infoP">{$load.folder}</p>
						<div class="clear"><!-- --></div>
						{if $load.folder!="examplecom"}
						<p class="infoLabel"><input type="radio" value="import" name="dbsource" checked="checked"/></p>
						<p class="infoP">Import data from db.sql file in site's folder</p>
						<div class="clear"><!-- --></div>
						<p class="infoLabel"><input type="radio" value="existing" name="dbsource"/></p>
						<p class="infoP">Use existing database</p>
						<div class="clear"><!-- --></div>
						{/if}
						<div class="manualimport clearfix {if $fullpriv==false}show{/if}"{if $fullpriv==true}style="display:none"{/if}>
							<label class="bpe_label">Database name:</label> <input type="text" name="" value="" id="" class="bpe_input dbname"/>
							<div class="clear"><!-- --></div>
							<label class="bpe_label">Database host:</label> <input type="text" name="" value="{$host}" id="" class="bpe_input dbhost"/>
							<div class="clear"><!-- --></div>
							
							<label class="bpe_label">Database user:</label> <input type="text" name="" value="" id="" class="bpe_input dbuser"/>
							<div class="clear"><!-- --></div>

							<label class="bpe_label">Database password:</label> <input type="text" name="" value="" id="" class="bpe_input dbpass"/>
						</div>
						
						<div class="clear"><!-- --></div>
						<img src="graphics/4-1.gif" class="loadingButton" style="float:right;margin-top:10px;margin-right:25px;"/>
						<div class='bpe_savecancel'><a href='{$load.folder}' class='importNow bpe_save {if $fullpriv==false}manDB{/if}'><span>Import</span></a><a href='#' class='bpe_cancel'><span>Cancel</span></a></div>
						</div>
					</div>
				{/foreach}
				<div class="clear dotted"><!-- --></div>
				
			{/if}
			{*
			<p class="section">The following sites are loaded into SetSeed and will be visible providing the URL’s DNS ‘A’ record is pointing to this server.</p>*}
			<div class="site clearfix fake">
				<div class="preview"></div>
				<p class="url"><span class="edit">Add new website</span></p>
			</div>
			{foreach from=$sites|@array_reverse item=site key=key name=loop1}
				<div class="site clearfix" title="{$site.url}">
					<div class="preview"><img src="preview.php?folder={$site.invisible_key}" class="previewImage"/><img src="graphics/corners.png" class="corners"/></div>
					<p class="url"><span class="edit">{$site.url|truncate:30:"&hellip;"}</span></p>
					<input type="hidden" name="" value="{$site.invisible_key}" class="folderVal"/>
					{if $site.dbname==""}
					<input type="hidden" name="" value="setseed_{$site.invisible_key}" class="dbVal"/>
					{else}
					<input type="hidden" name="" value="{$site.dbname}" class="dbVal"/>					
					{/if}
					<input type="hidden" name="" value="{$site.user}" class="userVal"/>
					<div class="themes" style="display:none">
					<select name="theme" class="themesel">
						{if $site.themes|@count>1}
							{foreach from=$site.themes item=theme key=key name=loop1}
							<option value={$theme} {if $theme==$site.theme}selected="selected"{/if}>{$theme}</option>
							{/foreach}
						{else}
						<option class="dropdown" selected="selected">{$site.theme}</option>
						{/if}
					</select>
					</div>
				</div>
			{/foreach}
		{/if}
			<div class="clear"><!-- --></div>
	</div>
	{/if}
	<div id="mask"></div>
	<div id="lightbox" class="bpe_add_popup">
		<div id="lightboxInner" class="bpe_add_popup_inner">
		<img src='/admin/graphics/bpeditor/help.png' alt='To remove this site from SetSeed: || Export the database to the db.sql file in the site folder by clicking the "Prepare backup" button. This will then make it simple to re-import the site if you need to later. ||  Make a complete backup of the MySQL database. We recommend using the mysqldump tool to do this. The "Prepare backup" button above may not make an exact copy of the database (in particular it doesn’t save site statistics). || Removing the site from SetSeed by clicking the remove button will only remove the reference to this site from the master SetSeed list - it will not remove the MySQL user or database assocaited with this site. || You can then remove the site’s folder from the ‘sites’ folder on your server. Make a backup first! || Tip: Use your own preview image by adding a JPG image called preview.jpg to this site’s folder' class='bpe_help' />
		<h2>Edit site: <span class="foldername"></span></h2>

		<form class="editUrl">
		<label class="bpe_label">URL:</label>
<input type="hidden" class="oldUrl" name="oldUrl" value="" /><input type="text" value="" name="newUrl" class="newUrl bpe_input"/>

		<label class="bpe_label">Theme:</label>
		<p class="theme"></p>
		</form>
		<label class="bpe_label">Folder:</label>
		<p class="infoP foldername"></p>
		<label class="bpe_label">MySQL Database:</label>
		<p class="infoP db"></p>
		<label class="bpe_label">MySQL User:</label>
		<p class="infoP user"></p>
		<div class="clear"><!-- --></div>
		<div class="clear visible"><!-- --></div>
		<a href="#" id="backup" class="bpe_popup_button"><span>Prepare backup <img src="graphics/4-1.gif" class="loadingButton"/><img src="graphics/button-tick.gif" class="buttonSuccess"/></span></a>
		<a href="#" id="removeSite" class="bpe_popup_button"><span>Remove site&hellip;</span></a>
		<div class="clear"><!-- --></div>
		<div class="moreContent">
			<p>Remove the site from SetSeed by clicking <a href="" id="removeLink">here</a> - <span style="color:#f00">This will only remove the reference to this site from the master SetSeed list - it will not remove the MySQL user ('<span class="user"></span>') or database ('<span class="db"></span>') associated with this site.</span></p>
		</div>
		<div class="clear"><!-- --></div>
		<div class="clear visible"><!-- --></div>
<div class='bpe_savecancel'><a href='#' id="editSite" class='bpe_save {if $fullpriv==false}manDB{/if}'><span>Done</span></a><a href='#' class='bpe_cancel'><span>Cancel</span></a></div>
		</div>
	</div>
	<div id="import" class="bpe_add_popup">
		<div id="importInner" class="bpe_add_popup_inner clearfix">
			
		</div>
	</div>

	<div class='bpe_mask'></div><div class='bpe_add_popup' id="addnewsite"><div class='bpe_add_popup_inner'><img src='/admin/graphics/bpeditor/help.png' alt='Enter the domain you want to use with your site in the URL field. You will need to change your DNS settings to make sure that the domain points at this server, and also ensure that apache uses this host to serve the site when called from that domain. This is ususally done by adding the domain as a Domain Alias (Plesk) or a Parked Domain (cPanel). {if $fullpriv==false}|| Please use your web host control panel to create a new database and user to use with your new website and enter the connection information. This must be a unique and empty database used only with the website you are creating. It is not the same database/user you used when you installed SetSeed. || Please note: SetSeed can automitaclly create the database for you if you have root access to your server (VPS, dedicated etc) and can grant the following permissions to your master MySQL user (the one you used when you installed SetSeed): ALTER, DROP, CREATE, CREATE USER, SELECT, INSERT, UPDATE, GRANT OPTION{/if}' class='bpe_help' /><h2>Add new site</h2><form action="" method="post" id="addSiteForm" class="clearfix">
		<label class="bpe_label">URL: http://</label>
		<input type="text" name="url" value="" id="addSiteInput" class="bpe_input permInput"/>
		{if $fullpriv==false}
		<div id="manualDB">
			<div class="manDBForm clearfix">
			<label class="bpe_label">Database name:</label> <input type="text" name="" value="" id="dbname" class="bpe_input"/>
			<div class="clear"><!-- --></div>
			<label class="bpe_label">Database host:</label> <input type="text" name="" value="{$host}" id="dbhost" class="bpe_input"/>
			<div class="clear"><!-- --></div>
			
			<label class="bpe_label">Database user:</label> <input type="text" name="" value="" id="dbuser" class="bpe_input"/>
			<div class="clear"><!-- --></div>

			<label class="bpe_label">Database password:</label> <input type="text" name="" value="" id="dbpass" class="bpe_input"/>
			
			</div>

		</div>
		{/if}		
	</form><div class='clear'></div><img src="graphics/4-1.gif" class="loadingButton" style="float:right;margin-top:10px;margin-right:25px;"/><div class='bpe_savecancel'><a href='#' id="addSite" class='bpe_save {if $fullpriv==false}manDB{/if}'><span>Add site</span></a><a href='#' class='bpe_cancel'><span>Cancel</span></a></div>
	<div class='clear'></div>
	</div></div>
	<div id="overlay"></div>
	<div id="error"></div>
	<div id="changePass" class="bpe_add_popup">
		<div class="bpe_add_popup_inner">
			<h2>Change SetSeed Hub account username and password</h2>
			<form action="" method="post" id="changePassForm">
				<input type="hidden" name="salt" value="{$salt}" id="salt"/>
				<input type="hidden" name="timestamp" value="{$time}" id="timestamp"/>
				<label class="bpe_label">Username:</label>
				<input type="text" name="username" value="" class="bpe_input"/>
				<div class="clear"><!-- --></div>
				<label class="bpe_label">Password:</label>
				<input type="password" name="password" value=""  class="bpe_input"/>
				<div class="clear"><!-- --></div>
				<label class="bpe_label">Password (again):</label>
				<input type="password" name="password2" value="" class="bpe_input"/>
				<div class="clear"><!-- --></div>
				<div class='bpe_savecancel'><a href='#' id="changePassButton" class='bpe_save'><span>Change password</span></a><a href='#' class='bpe_cancel'><span>Cancel</span></a></div>
			</form>
			<p id="notmatch">The passwords don't match!</p>
			<p id="notstrong">Your password ins't secure enough.</p>
			
		</div>
	</div>
	<div id="about">
		<p><img src="graphics/logo3.png" alt="SetSeed"/></p>
		<p>SetSeed CMS<br/>© Copyright 2006-2011 Ben Vallack, T/A Phototropic. <br/>
			All Rights Reserved</p>
		<p style="text-align:right">Version: 5.8.20<br/>
			<a href="http://setseed.com"><strong>setseed.com</strong></a></p>
	</div>
</body>
</html>
