{* show search results*}
{if $search_all}
{if $search_results|@count==0}
<p class="status">Your search for <strong>{$searching_by}</strong> found no results.</p>
{/if}
{if $search_results|@count!=0}
<p class="status">Your search for <strong>{$searching_by}</strong> found {$totalResults} results.</p>
{/if}
{foreach from=$search_results item=search_result key=key name=loop}
	{if $search_result.homepage=="yes"}
	<h2 style="font-weight:normal;"><a href="/">{$search_result.title}</a></h2>
	{else}
	<h2 style="font-weight:normal;"><a href="/{$search_result.url}">{$search_result.title}</a></h2>
	{/if}
	{if $search_result.content!=""}
	<p class="nest">{$search_result.content|truncate:300}</p>
	{/if}
{/foreach}
	{if $totalPages > 1}
		
			<h5 id="paginate">{if $currentPage == 1}
				<span class="prevLink hidden">Previous Page</span>

			{else}
			<span class="prevLink"><a href="/search/{$searching_by}/page/{math equation="x - y" x=$currentPage y=1}/"><span>Previous Page</span></a></span>
			{/if} 
			{if $currentPage == $totalPages}
			<span class="nextLink hidden">Next Page</span>
			{else}
			<span class="nextLink"><a href="/search/{$searching_by}/page/{math equation="x + y" x=$currentPage y=1}/"><span>Next Page</span></a></span> 

			{/if}
			Viewing page <strong>{$currentPage} of {$totalPages}</strong>
		
			</h5>
	{/if}
{/if}

{*
----------------------------------------------------------------------------------------------
VARIABLES AVAILABLE IN THIS TEMPLATE: 
----------------------------------------------------------------------------------------------
Because this template is inlucded from templates/layouts/main.tpl it contains all variables
that template contains. However, when search results are being displayed a variable called
{$search_all} will be not-null (contains "yes"), and the following variables/arrays will be 
available to display the search results. 

{$search_all}		<-	Not-null when page is showing search results
{$searching_by}		<-	The search string/term
{$search_results}	<-	Array of pages and blog pages that match the search term. 
						Contains the following keys:
						id			->	ID of the page, or if item is a blog page, ID of the
										blog article.
						title 		->	Page name/title or blog entry title.
						longtitle	->	The long title for the page/blog entry.
						summary		-> 	Meta description for the page / blog entry.
						keywords	->	Meta keywords for the page / blog entry.
						content		->	String that contains the first instance of the matched
										word/term and a few words each side. The matched term 
										will be wrapped in <strong> tags.
						url			-> 	The url of the result, without the first slash.
						homepage	->	Contains "yes" if the page is the site's homepage
{$currentPage}		<-	The current page number if there is more than one page of search 
						results
{$totalPages}		<-	The total number of search result pages if there is more than one.
{$totalResults}		<-	Total number of pages/results for the search term.

----------------------------------------------------------------------------------------------
*}