{if $nocookie=="true"}
<p id="status">
	Please enable cookies in your browser
</p>
{/if}
{if $empty}
<p id="status">
	Your Shopping Basket is Empty
</p>
{/if}
{if $orders}
<div id="basketWrapper">
<form action="/actions/UpdateQuantities/" method="post">
<table id="basket">
	<tr>
		<th>Product name</th>
		<th class="price">Price</th>
		<th class="removeCell"></th>
	</tr>
	{foreach from=$orders item=item key=key name=loop1}
	<tr>
		<td class="product_name"><strong>{$item.name}</strong><br/>
			{if $item.variant!=""}{$item.variant}<br/>{/if}
			{if $item.allow_one=="no"}<span class="quantityWrapper">Quantity: <input type="text" name="{$item.id}" value="{$item.quantity}" class="quantity" /></span>{/if}</td>
		<td class="price">{$currency_sym}{$item.price}</td>
		<td class="removeCell"><a href="/actions/removeFromBasket/?ordersId={$item.id}"><img src="/graphics/remove.gif" alt="Remove from basket"/></a></td>
	</tr>
	{/foreach}
	<tr>
		<td><input type="image" src="/graphics/update.gif" alt="Update Quantities" id="updateQuantities"/></td>
		<td><strong>Total: {$currency_sym}{$totals}</strong></td>
		<td class="removeCell"></td>
	</tr>
</table>
</form>
<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
	<input type="hidden" name="cmd" value="_cart" />
	<input type="hidden" name="upload" value="1" />
	<input type="hidden" name="business" value="{$paypal_email}" />
	<input type="hidden" name="notify_url" value="{$ipn}" />
	<input type="hidden" name="custom" value="{$buyerId}" />
	<input type="hidden" name="rm" value="2" />
	<input type="hidden" name="return" value="{$return}" />
	<input type="hidden" name="cancel_return" value="{$return_fail}" />
	<input type="hidden" name="no_note" value="{$no_note}" />
	<input type="hidden" name="currency_code" value="{$currency_code}" />
	<input type="hidden" name="weight_unit" value="kgs" />
	{foreach from=$orders item=order name=ordersLoop}
	<input type="hidden" name="item_name_{$smarty.foreach.ordersLoop.iteration}" value="{$order.name|@htmlspecialchars} - {$order.variant|@htmlspecialchars}" />
	<input type="hidden" name="amount_{$smarty.foreach.ordersLoop.iteration}" value="{$order.price}" />
	<input type="hidden" name="quantity_{$smarty.foreach.ordersLoop.iteration}" value="{$order.quantity}" />
	<input type="hidden" name="weight_{$smarty.foreach.ordersLoop.iteration}" value="{$order.weight}" />
	{/foreach}
	<input type="image" src="https://www.paypal.com/en_GB/i/btn/btn_xpressCheckout.gif" name="" value="Checkout through PayPal"/>
</form>
</div>
<div class="clear"><!-- --></div>
{/if}
{*
------------------------------------------------------------------------------------
VARIABLES AVAILABLE IN THIS TEMPLATE: 
------------------------------------------------------------------------------------

{$empty}			<- 	if there are no products in the basket, this variable will 
						contain "yes", otherwise NULL
						
{$basket_link}		<-	the url string of the page that contains the shopping basket, 
						
						without slashes.
{$nocookie}			<- 	will be set to "yes" if the visitor has failed the cookie check

{$return}			<-	complete url of return page for successful transaction

{$return_fail}		<-	complete url of return page for cancelled transaction

{$ipn}				<-	complete url of the IPN file that PayPal will post data to

{$no_note}			<-	used in the PayPal hidden variable 'no_note' to show or hide
						the custom message field during paypal checkout, based on 
						the setting in the CMS.

{$currency_code} 	<-	the letter currency code, based on setting in the CMS

{$currency_sym}		<-	the currency symbol based on the selected currency code

{$paypal_email}		<-	the PayPal account email address, based on the setting in
						the CMS

{$totals}			<-	the total cost of all items

{$orders}			<-	the array of products in the basket. Contains the following 
						keys:
						name			<-	name of the product
						variant			<-	custom variant for product
						price			<-	price of the product
						quantity		<-	number of the product in the basket
						allow_one		<-	"yes" or "no" depending of if product
											can have more than one quantity in basket
						id				<-	id of the basket item (not a unique 
											product id)
						weight			<-	the weight value given to the product	
						product_code	<-	unique id for product

{$buyerId}			<-	the numerical id of this customer, used to identify this 
						order when PayPal post data back to the IPN script. Must 
						be added in the 'custom' PayPal hidden field

------------------------------------------------------------------------------------

*}