
CREATE TABLE `access_groups` (
`access_groupsid` int(11) NOT NULL AUTO_INCREMENT,
`password` char(40) NOT NULL,
`username` varchar(255) NOT NULL,
`salt` varchar(255) NOT NULL,
primary key(access_groupsid)
);




CREATE TABLE `admin_users` (
`admin_usersid` int(11) NOT NULL AUTO_INCREMENT,
`username` varchar(255) NOT NULL,
`password` char(40) NOT NULL,
`salt` varchar(255) NOT NULL,
`privalleges` varchar(255) NOT NULL,
`logged_in_key` varchar(255) NOT NULL,
`age` varchar(255) NOT NULL,
`uaip` varchar(255) NOT NULL,
primary key(admin_usersid)
);




CREATE TABLE `blog_author` (
`blog_authorid` int(11) NOT NULL AUTO_INCREMENT,
`name` varchar(255) NOT NULL,
`details` text NOT NULL,
primary key(blog_authorid)
);

INSERT INTO `blog_author` VALUES ('1', 'Ben Vallack', 'Ben Vallack is the developer of SetSeed CMS');



CREATE TABLE `blog_categories` (
`blog_categoriesid` int(11) NOT NULL AUTO_INCREMENT,
`name` varchar(255) NOT NULL,
primary key(blog_categoriesid)
);

INSERT INTO `blog_categories` VALUES ('1', 'Statues');
INSERT INTO `blog_categories` VALUES ('2', 'CMS');



CREATE TABLE `blog_comments` (
`blog_commentsid` int(11) NOT NULL AUTO_INCREMENT,
`belongs_to_blog` varchar(255) NOT NULL,
`content` longtext NOT NULL,
`timestamp` datetime NOT NULL,
`author` varchar(255) NOT NULL,
`website` varchar(255) NOT NULL,
`email` varchar(255) NOT NULL,
`approved` varchar(255) NOT NULL,
primary key(blog_commentsid)
);




CREATE TABLE `blog_config` (
`blog_configid` int(11) NOT NULL AUTO_INCREMENT,
`items_on_page` smallint(6) NOT NULL,
`sidebar_cal` varchar(3) NOT NULL,
`sidebar_cats` varchar(3) NOT NULL,
`sidebar_tags` varchar(3) NOT NULL,
`comment_email_notification` varchar(255) NOT NULL,
`related_articles_threshold` varchar(255) NOT NULL,
`comment_email_from` varchar(255) NOT NULL,
`comment_email_from_name` varchar(255) NOT NULL,
`secret_passcode` varchar(255) NOT NULL,
`sidebar_recent` varchar(255) NOT NULL,
`number_sidebar_recent` varchar(255) NOT NULL,
`sidebar_search` varchar(255) NOT NULL,
`manual_approve` varchar(255) NOT NULL,
primary key(blog_configid)
);

INSERT INTO `blog_config` VALUES ('1', '10', 'yes', 'yes', 'yes', '', '2', '', '', 'changeme', 'yes', '5', 'yes', '');



CREATE TABLE `blog_entries` (
`blog_entriesid` int(11) NOT NULL AUTO_INCREMENT,
`in_categories` varchar(255) NOT NULL,
`tags` varchar(255) NOT NULL,
`title` varchar(255) NOT NULL,
`summary` text NOT NULL,
`keywords` text NOT NULL,
`content` mediumtext NOT NULL,
`timestamp` varchar(255) NOT NULL,
`ad1` text NOT NULL,
`ad2` text NOT NULL,
`author` varchar(255) NOT NULL,
`live` varchar(255) NOT NULL,
`longtitle` varchar(255) NOT NULL,
`playlist` varchar(255) NOT NULL,
`language` varchar(255) NOT NULL,
`gallery` varchar(255) NOT NULL,
`content2` mediumtext NOT NULL,
`deleted` varchar(255) NOT NULL,
primary key(blog_entriesid)
);

INSERT INTO `blog_entries` VALUES ('1', ', 1', ', swans, statues, grass', 'My first great blog article', 'This is an example of a blog article created with SetSeed.', '', '<h2>Lorem ipsum dolor sit amet,</h2>\n\n\n\n\n\n\n\n<p>consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n\n\n\n\n\n\n\n<div class=\"bpe_image Left_Image\"><img src=\"/images/statue.jpg\" alt=\"\" />\n\n\n</div><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n\n\n\n\n\n\n\n<h2>Lorem ipsum dolor sit amet,</h2>\n\n\n\n\n\n\n\n<p>consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n\n\n\n\n\n\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n\n\n\n\n\n\n\n', '1312017780', '', '', '1', 'yes', 'A really cool blog article', '', 'en', '', '', '');



CREATE TABLE `blog_entries_versions` (
`blog_entries_versionsid` int(11) NOT NULL AUTO_INCREMENT,
`belongs_to_blog_entry_id` int(11) NOT NULL,
`content` mediumtext NOT NULL,
`date_saved` int(11) NOT NULL,
`draft` tinyint(4) NOT NULL,
primary key(blog_entries_versionsid)
);

INSERT INTO `blog_entries_versions` VALUES ('2', '1', '<h2>Lorem ipsum dolor sit amet,</h2>\n\n\n\n\n\n\n\n<p>consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n\n\n\n\n\n\n\n<div class=\\\"bpe_image Left_Image\\\"><img src=\\\"/images/statue.jpg\\\" alt=\\\"\\\" />\n\n\n</div><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n\n\n\n\n\n\n\n<h2>Lorem ipsum dolor sit amet,</h2>\n\n\n\n\n\n\n\n<p>consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n\n\n\n\n\n\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n\n\n\n\n\n\n\n', '1312025426', '1');
INSERT INTO `blog_entries_versions` VALUES ('19', '1', '<h2>Lorem ipsum dolor sit amet,</h2>\n\n\n\n\n\n\n\n<p>consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n\n\n\n\n\n\n\n<div class=\\\"bpe_image Left_Image\\\"><img src=\\\"/images/statue.jpg\\\" alt=\\\"\\\" />\n\n\n</div><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n\n\n\n\n\n\n\n<h2>Lorem ipsum dolor sit amet,</h2>\n\n\n\n\n\n\n\n<p>consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n\n\n\n\n\n\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n\n\n\n\n\n\n\n', '1312025421', '0');



CREATE TABLE `buyer` (
`buyerid` int(11) NOT NULL AUTO_INCREMENT,
`first_name` varchar(255) NOT NULL,
`last_name` varchar(255) NOT NULL,
`address_city` varchar(255) NOT NULL,
`address_country` varchar(255) NOT NULL,
`address_state` varchar(255) NOT NULL,
`address_street` varchar(255) NOT NULL,
`address_zip` varchar(255) NOT NULL,
`payer_business_name` varchar(255) NOT NULL,
`payer_email` varchar(255) NOT NULL,
`payer_id` varchar(255) NOT NULL,
`paid` int(11) NOT NULL,
`status` varchar(255) NOT NULL,
`txn_id` varchar(255) NOT NULL,
`dispatched` int(11) NOT NULL,
`mc_gross` decimal(16,2) NOT NULL,
`timestamp` int(10) unsigned NOT NULL,
primary key(buyerid)
);

INSERT INTO `buyer` VALUES ('1', 'Example', 'Buyer', 'City', 'Country', 'State', 'Street', 'Zip', 'Business Name', 'example@example.com', '1234', '1', 'STATUS', '123', '0', '55.00', '0');



CREATE TABLE `events` (
`eventsid` int(11) NOT NULL AUTO_INCREMENT,
`title` varchar(255) NOT NULL,
`day` varchar(255) NOT NULL,
`month` varchar(255) NOT NULL,
`year` varchar(255) NOT NULL,
`link` varchar(255) NOT NULL,
`summary` varchar(255) NOT NULL,
`belongs_to_category` int(11) NOT NULL,
primary key(eventsid)
);




CREATE TABLE `events_categories` (
`events_categoriesid` int(11) NOT NULL AUTO_INCREMENT,
`name` varchar(255) NOT NULL,
primary key(events_categoriesid)
);




CREATE TABLE `forms` (
`formsid` int(11) NOT NULL AUTO_INCREMENT,
`name` varchar(255) NOT NULL,
`destination` varchar(255) NOT NULL,
`from_email` varchar(255) NOT NULL,
`from_name` varchar(255) NOT NULL,
`subject` varchar(255) NOT NULL,
primary key(formsid)
);

INSERT INTO `forms` VALUES ('1', 'Contact form', '', '', '', '');
INSERT INTO `forms` VALUES ('2', 'Product customization form', '', '', '', '');



CREATE TABLE `galleries` (
`galleriesid` int(11) NOT NULL AUTO_INCREMENT,
`name` varchar(255) NOT NULL,
primary key(galleriesid)
);

INSERT INTO `galleries` VALUES ('1', 'Example photo gallery');
INSERT INTO `galleries` VALUES ('2', 'Product Swatches');



CREATE TABLE `images` (
`imagesid` int(11) NOT NULL AUTO_INCREMENT,
`caption` mediumtext NOT NULL,
`filename` varchar(255) NOT NULL,
`belongs_to_gallery` varchar(255) NOT NULL,
`order` int(11) NOT NULL,
primary key(imagesid)
);

INSERT INTO `images` VALUES ('1', 'Canal', 'zu0t4xdsc0002jpg', '1', '-1312023983');
INSERT INTO `images` VALUES ('2', 'Reflection', 'uzh66jdsc00062jpg', '1', '-1312023993');
INSERT INTO `images` VALUES ('3', 'Black &amp; White Reflection', 'ucx3xedsc0017jpg', '1', '-1312023997');
INSERT INTO `images` VALUES ('4', 'Black &amp; White Leaf', 'ew7pr7dsc0019jpg', '1', '-1312023999');
INSERT INTO `images` VALUES ('5', 'Leaf', '7maivxdsc0021jpg', '1', '-1312024001');
INSERT INTO `images` VALUES ('6', 'Swans', 'wg87toimg0151jpg', '1', '-1312024004');
INSERT INTO `images` VALUES ('7', 'Boat', 'p8gnixr0011041jpg', '1', '-1312024005');
INSERT INTO `images` VALUES ('8', 'Big hill', 'xr6kixr0011342jpg', '1', '-1312024008');
INSERT INTO `images` VALUES ('9', 'Lakes', 'buwc60r0011346jpg', '1', '-1312024010');
INSERT INTO `images` VALUES ('10', 'Hills', 'v8aot3r0011375jpg', '1', '-1312024013');
INSERT INTO `images` VALUES ('11', 'Landscape photo', 'gk748sr0011442jpg', '1', '-1312024015');
INSERT INTO `images` VALUES ('13', 'Example texture 2', 'x6ayvhx6xncatex2jpg', '2', '-1312027706');
INSERT INTO `images` VALUES ('14', 'Example texture 3', 'f3md2xbk6rs7tex1jpg', '2', '-1312027706');
INSERT INTO `images` VALUES ('16', 'Example texture 4', '0rb0jqth8fxztex3jpg', '2', '-1312027706');
INSERT INTO `images` VALUES ('19', 'Example texture 1', '4z35udsobr4btex4jpg', '2', '-1312027707');



CREATE TABLE `inputs` (
`inputsid` int(11) NOT NULL AUTO_INCREMENT,
`type` varchar(255) NOT NULL,
`label` varchar(255) NOT NULL,
`value` varchar(255) NOT NULL,
`order` varchar(255) NOT NULL,
`required` varchar(255) NOT NULL,
`belongs_to_form` varchar(255) NOT NULL,
`options` text NOT NULL,
primary key(inputsid)
);

INSERT INTO `inputs` VALUES ('1', 'name', 'Your name:', '', '30', 'yes', '1', '');
INSERT INTO `inputs` VALUES ('2', 'email', 'Your email address:', '', '40', 'yes', '1', '');
INSERT INTO `inputs` VALUES ('3', 'select', 'Please choose:', '', '80', '', '1', 'Love it**!!**Somewhere in the middle**!!**Hate it');
INSERT INTO `inputs` VALUES ('4', 'long', 'Any other comments?', '', '50', '', '1', '');
INSERT INTO `inputs` VALUES ('5', 'heading', 'Your info:', '', '10', '', '1', '');
INSERT INTO `inputs` VALUES ('6', 'text', 'Please tell us about yourself', '', '20', '', '1', '');
INSERT INTO `inputs` VALUES ('7', 'heading', 'Extra info:', '', '60', '', '1', '');
INSERT INTO `inputs` VALUES ('8', 'text', 'What did you think of this website?', '', '70', '', '1', '');
INSERT INTO `inputs` VALUES ('9', 'text', 'What do you like best about websites?', '', '90', '', '1', '');
INSERT INTO `inputs` VALUES ('10', 'checkbox', 'News', '', '100', '', '1', '');
INSERT INTO `inputs` VALUES ('11', 'checkbox', 'Video', '', '110', '', '1', '');
INSERT INTO `inputs` VALUES ('12', 'checkbox', 'Pictures', '', '120', '', '1', '');
INSERT INTO `inputs` VALUES ('13', 'text', 'You can even upload a file:', '', '130', '', '1', '');
INSERT INTO `inputs` VALUES ('14', 'file', 'Please choose:', '', '140', '', '1', '');
INSERT INTO `inputs` VALUES ('15', 'select', 'Choose a salad:', '', '10', '', '2', 'Lettuce**!!**Spinage**!!**Tomatoes**!!**Cucumber');
INSERT INTO `inputs` VALUES ('16', 'select', 'Choose a vegetable:', '', '20', '', '2', 'Turnip**!!**Carrot**!!**Potatoe**!!**Swedes');
INSERT INTO `inputs` VALUES ('17', 'long', 'Enter any likes:', '', '30', '', '2', '');
INSERT INTO `inputs` VALUES ('18', 'long', 'Enter any dislikes:', '', '40', '', '2', '');



CREATE TABLE `languages` (
`languagesid` int(11) NOT NULL AUTO_INCREMENT,
`name` varchar(255) NOT NULL,
`abr` varchar(255) NOT NULL,
primary key(languagesid)
);




CREATE TABLE `media` (
`mediaid` int(11) NOT NULL AUTO_INCREMENT,
`title` varchar(255) NOT NULL,
`author` varchar(255) NOT NULL,
`filename` varchar(255) NOT NULL,
`link` varchar(255) NOT NULL,
`description` varchar(255) NOT NULL,
`belongs_to_playlist` varchar(255) NOT NULL,
`image` varchar(255) NOT NULL,
primary key(mediaid)
);




CREATE TABLE `media_playlists` (
`media_playlistsid` int(11) NOT NULL AUTO_INCREMENT,
`title` varchar(255) NOT NULL,
`type` varchar(255) NOT NULL,
primary key(media_playlistsid)
);




CREATE TABLE `newsletter_email` (
`newsletter_emailid` int(11) NOT NULL AUTO_INCREMENT,
`belongs_to_mailing_list` varchar(255) NOT NULL,
`email` varchar(255) NOT NULL,
`name` varchar(255) NOT NULL,
`inactive` varchar(255) NOT NULL,
`fail_on_last_send` varchar(255) NOT NULL,
primary key(newsletter_emailid)
);




CREATE TABLE `newsletter_email_config` (
`newsletter_email_configid` int(11) NOT NULL AUTO_INCREMENT,
`smtp_server` varchar(255) NOT NULL,
`from_email` varchar(255) NOT NULL,
`from_name` varchar(255) NOT NULL,
`username` varchar(255) NOT NULL,
`password` varchar(255) NOT NULL,
`subject` varchar(255) NOT NULL,
`email_me` varchar(255) NOT NULL,
primary key(newsletter_email_configid)
);




CREATE TABLE `newsletter_email_groups` (
`newsletter_email_groupsid` int(11) NOT NULL AUTO_INCREMENT,
`name` varchar(255) NOT NULL,
primary key(newsletter_email_groupsid)
);




CREATE TABLE `orders` (
`ordersid` int(11) NOT NULL AUTO_INCREMENT,
`name` varchar(255) NOT NULL,
`price` decimal(16,2) NOT NULL,
`quantity` varchar(255) NOT NULL,
`product_code` varchar(255) NOT NULL,
`postage` decimal(16,2) NOT NULL,
`only_one` varchar(255) NOT NULL,
`belongs_to_buyer` int(11) NOT NULL,
`weight` decimal(16,2) NOT NULL,
`variant` mediumtext NOT NULL,
primary key(ordersid)
);

INSERT INTO `orders` VALUES ('8', 'A simple product', '10.00', '1', '5dn8hup45uywz', '0.00', 'no', '1', '0.00', '');
INSERT INTO `orders` VALUES ('9', 'Veg Box', '45.00', '1', 'fx4o2u67wd8xr', '0.00', 'no', '1', '0.00', '<p><strong>Choose a salad:</strong><br/>Lettuce</p><p><strong>Choose a vegetable:</strong><br/>Turnip</p><p><strong>Enter any likes:</strong><br/>Basil<br />\nPeas</p><p><strong>Enter any dislikes:</strong><br/>Beetroot<br />\nOnions</p>');



CREATE TABLE `products` (
`productsid` int(11) NOT NULL AUTO_INCREMENT,
`name` varchar(255) NOT NULL,
`price` decimal(16,2) NOT NULL,
`only_one` varchar(255) NOT NULL,
`weight` varchar(255) NOT NULL,
`code` varchar(255) NOT NULL,
`variants` mediumtext NOT NULL,
`type` varchar(255) NOT NULL,
`gal_id` int(11) NOT NULL,
`form_id` int(11) NOT NULL,
`in_stock` int(11) NOT NULL,
primary key(productsid)
);

INSERT INTO `products` VALUES ('1', 'Photo print', '60.00', 'no', '0.0', '4v5b23ttbs27g', 'Large**::**60.00||**||Medium**::**50.00||**||Small**::**40.00', 'gallery_multi', '1', '0', '0');
INSERT INTO `products` VALUES ('2', 'Product with options', '0.00', 'no', '0.0', 'ip3oc5mtv7n7i', 'Gold**::**20.00||**||Green**::**10.00||**||Red**::**10.00', 'simple_multi', '0', '0', '0');
INSERT INTO `products` VALUES ('3', 'Veg Box', '45.00', 'no', '0.0', 'fx4o2u67wd8xr', '', 'form', '0', '2', '0');
INSERT INTO `products` VALUES ('4', 'A simple product', '10.00', 'no', '0.0', '5dn8hup45uywz', '', 'simple', '0', '0', '10');
INSERT INTO `products` VALUES ('5', 'Clothes', '0.00', 'no', '0.0', 'cu3nfiduitkhg', 'Large**::**13.00||**||Medium**::**12.00||**||Small**::**10.00', 'gallery_multi', '2', '0', '0');



CREATE TABLE `redirects` (
`redirectsid` int(11) NOT NULL AUTO_INCREMENT,
`old` mediumtext NOT NULL,
`new` mediumtext NOT NULL,
primary key(redirectsid)
);

INSERT INTO `redirects` VALUES ('1', '/shop/simple-proucts/', '/shop/simple-products/');



CREATE TABLE `search` (
`searchid` int(11) NOT NULL AUTO_INCREMENT,
`blog_entry_id` int(11) NOT NULL,
`word` varchar(255) NOT NULL,
`count` int(11) NOT NULL,
primary key(searchid)
);

INSERT INTO `search` VALUES ('17', '1', 'elit', '4');
INSERT INTO `search` VALUES ('16', '1', 'adipis', '4');
INSERT INTO `search` VALUES ('15', '1', 'consectetur', '4');
INSERT INTO `search` VALUES ('14', '1', 'amet', '4');
INSERT INTO `search` VALUES ('13', '1', 'sit', '4');
INSERT INTO `search` VALUES ('12', '1', 'dolor', '16');
INSERT INTO `search` VALUES ('11', '1', 'ipsum', '4');
INSERT INTO `search` VALUES ('10', '1', 'lorem', '4');
INSERT INTO `search` VALUES ('18', '1', 'sed', '4');
INSERT INTO `search` VALUES ('19', '1', 'eiusmod', '4');
INSERT INTO `search` VALUES ('20', '1', 'tempor', '4');
INSERT INTO `search` VALUES ('21', '1', 'incididunt', '4');
INSERT INTO `search` VALUES ('22', '1', 'labor', '4');
INSERT INTO `search` VALUES ('23', '1', 'magna', '4');
INSERT INTO `search` VALUES ('24', '1', 'aliqua', '4');
INSERT INTO `search` VALUES ('25', '1', 'enim', '4');
INSERT INTO `search` VALUES ('26', '1', 'minim', '4');
INSERT INTO `search` VALUES ('27', '1', 'veniam', '4');
INSERT INTO `search` VALUES ('28', '1', 'qui', '8');
INSERT INTO `search` VALUES ('29', '1', 'nostrud', '4');
INSERT INTO `search` VALUES ('30', '1', 'exercit', '4');
INSERT INTO `search` VALUES ('31', '1', 'ullamco', '4');
INSERT INTO `search` VALUES ('32', '1', 'labori', '4');
INSERT INTO `search` VALUES ('33', '1', 'nisi', '4');
INSERT INTO `search` VALUES ('34', '1', 'aliquip', '4');
INSERT INTO `search` VALUES ('35', '1', 'commodo', '4');
INSERT INTO `search` VALUES ('36', '1', 'consequat', '4');
INSERT INTO `search` VALUES ('37', '1', 'dui', '4');
INSERT INTO `search` VALUES ('38', '1', 'aut', '4');
INSERT INTO `search` VALUES ('39', '1', 'irur', '4');
INSERT INTO `search` VALUES ('40', '1', 'reprehenderit', '4');
INSERT INTO `search` VALUES ('41', '1', 'volupt', '4');
INSERT INTO `search` VALUES ('42', '1', 'velit', '4');
INSERT INTO `search` VALUES ('43', '1', 'ess', '4');
INSERT INTO `search` VALUES ('44', '1', 'cillum', '4');
INSERT INTO `search` VALUES ('45', '1', 'fugiat', '4');
INSERT INTO `search` VALUES ('46', '1', 'nulla', '4');
INSERT INTO `search` VALUES ('47', '1', 'pariatur', '4');
INSERT INTO `search` VALUES ('48', '1', 'excepteur', '4');
INSERT INTO `search` VALUES ('49', '1', 'sint', '4');
INSERT INTO `search` VALUES ('50', '1', 'occaecat', '4');
INSERT INTO `search` VALUES ('51', '1', 'cupidatat', '4');
INSERT INTO `search` VALUES ('52', '1', 'non', '4');
INSERT INTO `search` VALUES ('53', '1', 'proident', '4');
INSERT INTO `search` VALUES ('54', '1', 'sunt', '4');
INSERT INTO `search` VALUES ('55', '1', 'culpa', '4');
INSERT INTO `search` VALUES ('56', '1', 'officia', '4');
INSERT INTO `search` VALUES ('57', '1', 'deserunt', '4');
INSERT INTO `search` VALUES ('58', '1', 'mollit', '4');
INSERT INTO `search` VALUES ('59', '1', 'anim', '4');
INSERT INTO `search` VALUES ('60', '1', 'est', '4');
INSERT INTO `search` VALUES ('61', '1', 'laborum', '4');
INSERT INTO `search` VALUES ('62', '1', 'first', '3');
INSERT INTO `search` VALUES ('63', '1', 'great', '3');
INSERT INTO `search` VALUES ('64', '1', 'blog', '6');
INSERT INTO `search` VALUES ('65', '1', 'articl', '6');
INSERT INTO `search` VALUES ('66', '1', 'realli', '1');
INSERT INTO `search` VALUES ('67', '1', 'cool', '1');
INSERT INTO `search` VALUES ('68', '1', 'exampl', '2');
INSERT INTO `search` VALUES ('69', '1', 'creat', '2');
INSERT INTO `search` VALUES ('70', '1', 'setse', '2');



CREATE TABLE `search_all` (
`search_allid` int(11) NOT NULL AUTO_INCREMENT,
`entry_id` int(11) NOT NULL,
`word` varchar(255) NOT NULL,
`count` int(11) NOT NULL,
`blog` varchar(255) NOT NULL,
primary key(search_allid)
);

INSERT INTO `search_all` VALUES ('1821', '26', 'section', '1', '');
INSERT INTO `search_all` VALUES ('1820', '26', 'differ', '1', '');
INSERT INTO `search_all` VALUES ('1819', '26', 'content', '1', '');
INSERT INTO `search_all` VALUES ('1818', '26', 'insert', '1', '');
INSERT INTO `search_all` VALUES ('1817', '26', 'client', '1', '');
INSERT INTO `search_all` VALUES ('1816', '26', 'easi', '2', '');
INSERT INTO `search_all` VALUES ('1815', '26', 'realli', '1', '');
INSERT INTO `search_all` VALUES ('1814', '26', 'make', '1', '');
INSERT INTO `search_all` VALUES ('1813', '26', 'csv', '1', '');
INSERT INTO `search_all` VALUES ('1812', '26', 'class', '1', '');
INSERT INTO `search_all` VALUES ('1811', '26', 'split', '1', '');
INSERT INTO `search_all` VALUES ('1810', '26', 'examplesit', '2', '');
INSERT INTO `search_all` VALUES ('1809', '26', 'file', '1', '');
INSERT INTO `search_all` VALUES ('1808', '26', 'see', '3', '');
INSERT INTO `search_all` VALUES ('1807', '26', 'theme', '3', '');
INSERT INTO `search_all` VALUES ('1806', '26', 'defin', '1', '');
INSERT INTO `search_all` VALUES ('1805', '26', '\'templat', '1', '');
INSERT INTO `search_all` VALUES ('1804', '26', 'sever', '1', '');
INSERT INTO `search_all` VALUES ('1803', '26', 'posit', '3', '');
INSERT INTO `search_all` VALUES ('1802', '26', 'templat', '6', '');
INSERT INTO `search_all` VALUES ('1801', '26', 'cm', '4', '');
INSERT INTO `search_all` VALUES ('1800', '26', 'start', '1', '');
INSERT INTO `search_all` VALUES ('1799', '26', 'domain', '1', '');
INSERT INTO `search_all` VALUES ('1798', '26', 'admin', '1', '');
INSERT INTO `search_all` VALUES ('1797', '26', 'visit', '1', '');
INSERT INTO `search_all` VALUES ('1796', '26', 'work', '1', '');
INSERT INTO `search_all` VALUES ('1795', '26', 'setse', '2', '');
INSERT INTO `search_all` VALUES ('1794', '26', 'test', '1', '');
INSERT INTO `search_all` VALUES ('1793', '26', 'site', '4', '');
INSERT INTO `search_all` VALUES ('1792', '26', 'us', '8', '');
INSERT INTO `search_all` VALUES ('1791', '26', 'can', '5', '');
INSERT INTO `search_all` VALUES ('1790', '26', 'websit', '1', '');
INSERT INTO `search_all` VALUES ('1789', '26', 'exampl', '2', '');
INSERT INTO `search_all` VALUES ('1788', '26', 'welcom', '1', '');
INSERT INTO `search_all` VALUES ('1311', '28', 'cm', '1', '');
INSERT INTO `search_all` VALUES ('1312', '28', 'compon', '5', '');
INSERT INTO `search_all` VALUES ('1203', '27', 'group', '1', '');
INSERT INTO `search_all` VALUES ('1202', '27', 'default', '1', '');
INSERT INTO `search_all` VALUES ('1201', '27', 'form', '1', '');
INSERT INTO `search_all` VALUES ('1200', '27', 'signup', '1', '');
INSERT INTO `search_all` VALUES ('1170', '27', 'compon', '5', '');
INSERT INTO `search_all` VALUES ('1171', '27', 'galleri', '5', '');
INSERT INTO `search_all` VALUES ('1172', '27', 'exampl', '2', '');
INSERT INTO `search_all` VALUES ('1173', '27', 'photo', '3', '');
INSERT INTO `search_all` VALUES ('1174', '27', 'creat', '2', '');
INSERT INTO `search_all` VALUES ('1175', '27', 'setse', '2', '');
INSERT INTO `search_all` VALUES ('1176', '27', 'imag', '1', '');
INSERT INTO `search_all` VALUES ('1177', '27', 'can', '2', '');
INSERT INTO `search_all` VALUES ('1178', '27', 'quickli', '1', '');
INSERT INTO `search_all` VALUES ('1179', '27', 'upload', '2', '');
INSERT INTO `search_all` VALUES ('1180', '27', 'us', '2', '');
INSERT INTO `search_all` VALUES ('1181', '27', 'fast', '1', '');
INSERT INTO `search_all` VALUES ('1182', '27', 'batch', '1', '');
INSERT INTO `search_all` VALUES ('1183', '27', 'thumbnail', '1', '');
INSERT INTO `search_all` VALUES ('1184', '27', 'automat', '1', '');
INSERT INTO `search_all` VALUES ('1185', '27', 'snippet', '1', '');
INSERT INTO `search_all` VALUES ('1186', '27', 'footer', '1', '');
INSERT INTO `search_all` VALUES ('1187', '27', 'text', '1', '');
INSERT INTO `search_all` VALUES ('1188', '27', 'blog', '1', '');
INSERT INTO `search_all` VALUES ('1189', '27', 'custom', '1', '');
INSERT INTO `search_all` VALUES ('1190', '27', 'recent', '1', '');
INSERT INTO `search_all` VALUES ('1191', '27', 'articl', '1', '');
INSERT INTO `search_all` VALUES ('1192', '27', 'email', '2', '');
INSERT INTO `search_all` VALUES ('1193', '27', 'newslett', '3', '');
INSERT INTO `search_all` VALUES ('1194', '27', 'site', '1', '');
INSERT INTO `search_all` VALUES ('1195', '27', 'system', '1', '');
INSERT INTO `search_all` VALUES ('1196', '27', 'collect', '1', '');
INSERT INTO `search_all` VALUES ('1197', '27', 'subscrib', '1', '');
INSERT INTO `search_all` VALUES ('1198', '27', 'mail', '1', '');
INSERT INTO `search_all` VALUES ('1199', '27', 'list', '1', '');
INSERT INTO `search_all` VALUES ('1403', '1', 'elit', '4', 'yes');
INSERT INTO `search_all` VALUES ('1402', '1', 'adipis', '4', 'yes');
INSERT INTO `search_all` VALUES ('1401', '1', 'consectetur', '4', 'yes');
INSERT INTO `search_all` VALUES ('1400', '1', 'amet', '4', 'yes');
INSERT INTO `search_all` VALUES ('1399', '1', 'sit', '4', 'yes');
INSERT INTO `search_all` VALUES ('1398', '1', 'dolor', '16', 'yes');
INSERT INTO `search_all` VALUES ('1397', '1', 'ipsum', '4', 'yes');
INSERT INTO `search_all` VALUES ('1396', '1', 'lorem', '4', 'yes');
INSERT INTO `search_all` VALUES ('1822', '26', 'slideshow', '3', '');
INSERT INTO `search_all` VALUES ('1823', '26', 'column', '1', '');
INSERT INTO `search_all` VALUES ('1824', '26', 'opposit', '1', '');
INSERT INTO `search_all` VALUES ('1825', '26', 'contain', '1', '');
INSERT INTO `search_all` VALUES ('1826', '26', 'creat', '1', '');
INSERT INTO `search_all` VALUES ('1827', '26', 'jqueri', '2', '');
INSERT INTO `search_all` VALUES ('1828', '26', 'imag', '3', '');
INSERT INTO `search_all` VALUES ('1829', '26', 'ad', '4', '');
INSERT INTO `search_all` VALUES ('1830', '26', 'edit', '1', '');
INSERT INTO `search_all` VALUES ('1831', '26', 'page', '3', '');
INSERT INTO `search_all` VALUES ('1832', '26', '\'re', '1', '');
INSERT INTO `search_all` VALUES ('1833', '26', 'simpli', '1', '');
INSERT INTO `search_all` VALUES ('1834', '26', 'given', '1', '');
INSERT INTO `search_all` VALUES ('1835', '26', '\'custom', '1', '');
INSERT INTO `search_all` VALUES ('1836', '26', 'style', '1', '');
INSERT INTO `search_all` VALUES ('1837', '26', '\'slideshow', '1', '');
INSERT INTO `search_all` VALUES ('1838', '26', 'code', '1', '');
INSERT INTO `search_all` VALUES ('1839', '26', 'javascript', '1', '');
INSERT INTO `search_all` VALUES ('1840', '26', 'custom', '4', '');
INSERT INTO `search_all` VALUES ('1841', '26', 'selector', '1', '');
INSERT INTO `search_all` VALUES ('1842', '26', 'convert', '1', '');
INSERT INTO `search_all` VALUES ('1843', '26', 'don', '1', '');
INSERT INTO `search_all` VALUES ('1844', '26', 'forget', '1', '');
INSERT INTO `search_all` VALUES ('1845', '26', 'try', '2', '');
INSERT INTO `search_all` VALUES ('1846', '26', '\'livechat', '2', '');
INSERT INTO `search_all` VALUES ('1847', '26', 'system', '4', '');
INSERT INTO `search_all` VALUES ('1848', '26', 'log', '1', '');
INSERT INTO `search_all` VALUES ('1849', '26', 'click', '2', '');
INSERT INTO `search_all` VALUES ('1850', '26', '\'set', '1', '');
INSERT INTO `search_all` VALUES ('1851', '26', '\'statu', '1', '');
INSERT INTO `search_all` VALUES ('1852', '26', '\'onlin', '1', '');
INSERT INTO `search_all` VALUES ('1853', '26', '\'ll', '1', '');
INSERT INTO `search_all` VALUES ('1854', '26', 'livechat', '1', '');
INSERT INTO `search_all` VALUES ('1855', '26', 'link', '1', '');
INSERT INTO `search_all` VALUES ('1856', '26', 'show', '1', '');
INSERT INTO `search_all` VALUES ('1857', '26', 'header', '2', '');
INSERT INTO `search_all` VALUES ('1858', '26', 'give', '1', '');
INSERT INTO `search_all` VALUES ('1859', '26', 'search', '3', '');
INSERT INTO `search_all` VALUES ('1860', '26', 'tool', '1', '');
INSERT INTO `search_all` VALUES ('1861', '26', 'site-wid', '1', '');
INSERT INTO `search_all` VALUES ('1862', '26', 'term', '1', '');
INSERT INTO `search_all` VALUES ('1863', '26', '\'search', '1', '');
INSERT INTO `search_all` VALUES ('1864', '26', 'box', '1', '');
INSERT INTO `search_all` VALUES ('1865', '26', 'compon', '4', '');
INSERT INTO `search_all` VALUES ('1866', '26', 'snippet', '1', '');
INSERT INTO `search_all` VALUES ('1867', '26', 'footer', '1', '');
INSERT INTO `search_all` VALUES ('1868', '26', 'text', '1', '');
INSERT INTO `search_all` VALUES ('1869', '26', 'email', '2', '');
INSERT INTO `search_all` VALUES ('1870', '26', 'newslett', '3', '');
INSERT INTO `search_all` VALUES ('1871', '26', 'collect', '1', '');
INSERT INTO `search_all` VALUES ('1872', '26', 'subscrib', '1', '');
INSERT INTO `search_all` VALUES ('1873', '26', 'mail', '1', '');
INSERT INTO `search_all` VALUES ('1874', '26', 'list', '1', '');
INSERT INTO `search_all` VALUES ('1875', '26', 'signup', '1', '');
INSERT INTO `search_all` VALUES ('1876', '26', 'form', '1', '');
INSERT INTO `search_all` VALUES ('1877', '26', 'default', '1', '');
INSERT INTO `search_all` VALUES ('1310', '28', 'menu', '1', '');
INSERT INTO `search_all` VALUES ('1309', '28', '\'email', '1', '');
INSERT INTO `search_all` VALUES ('1308', '28', '\'contact', '2', '');
INSERT INTO `search_all` VALUES ('1307', '28', '\'compon', '1', '');
INSERT INTO `search_all` VALUES ('1306', '28', 'recipi', '2', '');
INSERT INTO `search_all` VALUES ('1305', '28', 'address', '1', '');
INSERT INTO `search_all` VALUES ('1293', '28', 'build', '1', '');
INSERT INTO `search_all` VALUES ('1294', '28', 'amaz', '1', '');
INSERT INTO `search_all` VALUES ('1295', '28', 'unbeliev', '1', '');
INSERT INTO `search_all` VALUES ('1296', '28', 'simplic', '1', '');
INSERT INTO `search_all` VALUES ('1297', '28', 'see', '1', '');
INSERT INTO `search_all` VALUES ('1298', '28', 'exampl', '1', '');
INSERT INTO `search_all` VALUES ('1299', '28', 'want', '1', '');
INSERT INTO `search_all` VALUES ('1300', '28', 'test', '1', '');
INSERT INTO `search_all` VALUES ('1301', '28', '\'ll', '1', '');
INSERT INTO `search_all` VALUES ('1302', '28', 'need', '1', '');
INSERT INTO `search_all` VALUES ('1303', '28', 'enter', '1', '');
INSERT INTO `search_all` VALUES ('1304', '28', 'email', '1', '');
INSERT INTO `search_all` VALUES ('1292', '28', 'client', '1', '');
INSERT INTO `search_all` VALUES ('1291', '28', 'let', '1', '');
INSERT INTO `search_all` VALUES ('1290', '28', 'setse', '1', '');
INSERT INTO `search_all` VALUES ('1289', '28', 'form', '7', '');
INSERT INTO `search_all` VALUES ('1288', '28', 'contact', '5', '');
INSERT INTO `search_all` VALUES ('1313', '28', 'snippet', '2', '');
INSERT INTO `search_all` VALUES ('1314', '28', 'footer', '2', '');
INSERT INTO `search_all` VALUES ('1315', '28', 'text', '1', '');
INSERT INTO `search_all` VALUES ('1316', '28', 'middl', '1', '');
INSERT INTO `search_all` VALUES ('1317', '28', 'blog', '1', '');
INSERT INTO `search_all` VALUES ('1318', '28', 'custom', '1', '');
INSERT INTO `search_all` VALUES ('1319', '28', 'recent', '1', '');
INSERT INTO `search_all` VALUES ('1320', '28', 'articl', '1', '');
INSERT INTO `search_all` VALUES ('1373', '29', 'individu', '1', '');
INSERT INTO `search_all` VALUES ('1374', '29', 'page', '1', '');
INSERT INTO `search_all` VALUES ('1375', '29', 'try', '1', '');
INSERT INTO `search_all` VALUES ('1376', '29', 'cm', '1', '');
INSERT INTO `search_all` VALUES ('1377', '29', 'admin', '1', '');
INSERT INTO `search_all` VALUES ('1378', '29', 'click', '1', '');
INSERT INTO `search_all` VALUES ('1379', '29', '\'compon', '1', '');
INSERT INTO `search_all` VALUES ('1380', '29', '\'calendar', '1', '');
INSERT INTO `search_all` VALUES ('1381', '29', 'choos', '1', '');
INSERT INTO `search_all` VALUES ('1372', '29', 'show', '1', '');
INSERT INTO `search_all` VALUES ('1371', '29', 'add', '1', '');
INSERT INTO `search_all` VALUES ('1370', '29', 'categori', '3', '');
INSERT INTO `search_all` VALUES ('1369', '29', 'multipl', '1', '');
INSERT INTO `search_all` VALUES ('1368', '29', 'event', '3', '');
INSERT INTO `search_all` VALUES ('1367', '29', 'ad', '2', '');
INSERT INTO `search_all` VALUES ('1366', '29', 'can', '1', '');
INSERT INTO `search_all` VALUES ('1365', '29', 'built', '1', '');
INSERT INTO `search_all` VALUES ('1364', '29', 'system', '1', '');
INSERT INTO `search_all` VALUES ('1363', '29', 'power', '1', '');
INSERT INTO `search_all` VALUES ('1362', '29', 'setse', '1', '');
INSERT INTO `search_all` VALUES ('1361', '29', 'calendar', '5', '');
INSERT INTO `search_all` VALUES ('1382', '29', 'dai', '2', '');
INSERT INTO `search_all` VALUES ('1383', '29', '\'add', '1', '');
INSERT INTO `search_all` VALUES ('1384', '29', 'new', '2', '');
INSERT INTO `search_all` VALUES ('1385', '29', 'select', '1', '');
INSERT INTO `search_all` VALUES ('1386', '29', 'compon', '5', '');
INSERT INTO `search_all` VALUES ('1387', '29', 'snippet', '2', '');
INSERT INTO `search_all` VALUES ('1388', '29', 'footer', '2', '');
INSERT INTO `search_all` VALUES ('1389', '29', 'text', '1', '');
INSERT INTO `search_all` VALUES ('1390', '29', 'middl', '1', '');
INSERT INTO `search_all` VALUES ('1391', '29', 'custom', '1', '');
INSERT INTO `search_all` VALUES ('1392', '29', 'recent', '1', '');
INSERT INTO `search_all` VALUES ('1393', '29', 'articl', '1', '');
INSERT INTO `search_all` VALUES ('1394', '30', 'compon', '1', '');
INSERT INTO `search_all` VALUES ('1395', '30', 'blog', '2', '');
INSERT INTO `search_all` VALUES ('1404', '1', 'sed', '4', 'yes');
INSERT INTO `search_all` VALUES ('1405', '1', 'eiusmod', '4', 'yes');
INSERT INTO `search_all` VALUES ('1406', '1', 'tempor', '4', 'yes');
INSERT INTO `search_all` VALUES ('1407', '1', 'incididunt', '4', 'yes');
INSERT INTO `search_all` VALUES ('1408', '1', 'labor', '4', 'yes');
INSERT INTO `search_all` VALUES ('1409', '1', 'magna', '4', 'yes');
INSERT INTO `search_all` VALUES ('1410', '1', 'aliqua', '4', 'yes');
INSERT INTO `search_all` VALUES ('1411', '1', 'enim', '4', 'yes');
INSERT INTO `search_all` VALUES ('1412', '1', 'minim', '4', 'yes');
INSERT INTO `search_all` VALUES ('1413', '1', 'veniam', '4', 'yes');
INSERT INTO `search_all` VALUES ('1414', '1', 'qui', '8', 'yes');
INSERT INTO `search_all` VALUES ('1415', '1', 'nostrud', '4', 'yes');
INSERT INTO `search_all` VALUES ('1416', '1', 'exercit', '4', 'yes');
INSERT INTO `search_all` VALUES ('1417', '1', 'ullamco', '4', 'yes');
INSERT INTO `search_all` VALUES ('1418', '1', 'labori', '4', 'yes');
INSERT INTO `search_all` VALUES ('1419', '1', 'nisi', '4', 'yes');
INSERT INTO `search_all` VALUES ('1420', '1', 'aliquip', '4', 'yes');
INSERT INTO `search_all` VALUES ('1421', '1', 'commodo', '4', 'yes');
INSERT INTO `search_all` VALUES ('1422', '1', 'consequat', '4', 'yes');
INSERT INTO `search_all` VALUES ('1423', '1', 'dui', '4', 'yes');
INSERT INTO `search_all` VALUES ('1424', '1', 'aut', '4', 'yes');
INSERT INTO `search_all` VALUES ('1425', '1', 'irur', '4', 'yes');
INSERT INTO `search_all` VALUES ('1426', '1', 'reprehenderit', '4', 'yes');
INSERT INTO `search_all` VALUES ('1427', '1', 'volupt', '4', 'yes');
INSERT INTO `search_all` VALUES ('1428', '1', 'velit', '4', 'yes');
INSERT INTO `search_all` VALUES ('1429', '1', 'ess', '4', 'yes');
INSERT INTO `search_all` VALUES ('1430', '1', 'cillum', '4', 'yes');
INSERT INTO `search_all` VALUES ('1431', '1', 'fugiat', '4', 'yes');
INSERT INTO `search_all` VALUES ('1432', '1', 'nulla', '4', 'yes');
INSERT INTO `search_all` VALUES ('1433', '1', 'pariatur', '4', 'yes');
INSERT INTO `search_all` VALUES ('1434', '1', 'excepteur', '4', 'yes');
INSERT INTO `search_all` VALUES ('1435', '1', 'sint', '4', 'yes');
INSERT INTO `search_all` VALUES ('1436', '1', 'occaecat', '4', 'yes');
INSERT INTO `search_all` VALUES ('1437', '1', 'cupidatat', '4', 'yes');
INSERT INTO `search_all` VALUES ('1438', '1', 'non', '4', 'yes');
INSERT INTO `search_all` VALUES ('1439', '1', 'proident', '4', 'yes');
INSERT INTO `search_all` VALUES ('1440', '1', 'sunt', '4', 'yes');
INSERT INTO `search_all` VALUES ('1441', '1', 'culpa', '4', 'yes');
INSERT INTO `search_all` VALUES ('1442', '1', 'officia', '4', 'yes');
INSERT INTO `search_all` VALUES ('1443', '1', 'deserunt', '4', 'yes');
INSERT INTO `search_all` VALUES ('1444', '1', 'mollit', '4', 'yes');
INSERT INTO `search_all` VALUES ('1445', '1', 'anim', '4', 'yes');
INSERT INTO `search_all` VALUES ('1446', '1', 'est', '4', 'yes');
INSERT INTO `search_all` VALUES ('1447', '1', 'laborum', '4', 'yes');
INSERT INTO `search_all` VALUES ('1448', '1', 'first', '3', 'yes');
INSERT INTO `search_all` VALUES ('1449', '1', 'great', '3', 'yes');
INSERT INTO `search_all` VALUES ('1450', '1', 'blog', '6', 'yes');
INSERT INTO `search_all` VALUES ('1451', '1', 'articl', '6', 'yes');
INSERT INTO `search_all` VALUES ('1452', '1', 'realli', '1', 'yes');
INSERT INTO `search_all` VALUES ('1453', '1', 'cool', '1', 'yes');
INSERT INTO `search_all` VALUES ('1454', '1', 'exampl', '2', 'yes');
INSERT INTO `search_all` VALUES ('1455', '1', 'creat', '2', 'yes');
INSERT INTO `search_all` VALUES ('1456', '1', 'setse', '2', 'yes');
INSERT INTO `search_all` VALUES ('1560', '31', 'automat', '1', '');
INSERT INTO `search_all` VALUES ('1559', '31', 'built', '1', '');
INSERT INTO `search_all` VALUES ('1558', '31', 'templat', '1', '');
INSERT INTO `search_all` VALUES ('1557', '31', 'menu', '1', '');
INSERT INTO `search_all` VALUES ('1556', '31', 'left', '1', '');
INSERT INTO `search_all` VALUES ('1555', '31', 'page', '2', '');
INSERT INTO `search_all` VALUES ('1547', '31', 'site', '2', '');
INSERT INTO `search_all` VALUES ('1548', '31', 'get', '1', '');
INSERT INTO `search_all` VALUES ('1549', '31', 'idea', '1', '');
INSERT INTO `search_all` VALUES ('1550', '31', 'differ', '2', '');
INSERT INTO `search_all` VALUES ('1551', '31', 'kind', '1', '');
INSERT INTO `search_all` VALUES ('1552', '31', 'can', '1', '');
INSERT INTO `search_all` VALUES ('1553', '31', 'brows', '1', '');
INSERT INTO `search_all` VALUES ('1554', '31', 'exampl', '1', '');
INSERT INTO `search_all` VALUES ('1546', '31', 'anywher', '1', '');
INSERT INTO `search_all` VALUES ('1545', '31', 'product', '2', '');
INSERT INTO `search_all` VALUES ('1544', '31', 'sell', '2', '');
INSERT INTO `search_all` VALUES ('1543', '31', 'easi', '1', '');
INSERT INTO `search_all` VALUES ('1542', '31', 'realli', '1', '');
INSERT INTO `search_all` VALUES ('1541', '31', 'make', '1', '');
INSERT INTO `search_all` VALUES ('1540', '31', 'setse', '1', '');
INSERT INTO `search_all` VALUES ('1539', '31', 'store', '1', '');
INSERT INTO `search_all` VALUES ('1538', '31', 'onlin', '1', '');
INSERT INTO `search_all` VALUES ('1756', '36', 'even', '1', '');
INSERT INTO `search_all` VALUES ('1757', '36', 'automat', '1', '');
INSERT INTO `search_all` VALUES ('1581', '34', 'choic', '1', '');
INSERT INTO `search_all` VALUES ('1580', '34', 'list', '1', '');
INSERT INTO `search_all` VALUES ('1579', '34', 'serv', '1', '');
INSERT INTO `search_all` VALUES ('1578', '34', 'galleri', '1', '');
INSERT INTO `search_all` VALUES ('1577', '34', 'imag', '1', '');
INSERT INTO `search_all` VALUES ('1576', '34', 'product', '3', '');
INSERT INTO `search_all` VALUES ('1575', '34', 'combin', '1', '');
INSERT INTO `search_all` VALUES ('1574', '34', '\'ve', '1', '');
INSERT INTO `search_all` VALUES ('1573', '34', 'websit', '1', '');
INSERT INTO `search_all` VALUES ('1572', '34', 'sell', '1', '');
INSERT INTO `search_all` VALUES ('1571', '34', 'easi', '1', '');
INSERT INTO `search_all` VALUES ('1570', '34', 'realli', '1', '');
INSERT INTO `search_all` VALUES ('1569', '34', 'make', '1', '');
INSERT INTO `search_all` VALUES ('1568', '34', 'setse', '1', '');
INSERT INTO `search_all` VALUES ('1567', '34', 'print', '4', '');
INSERT INTO `search_all` VALUES ('1566', '34', 'photo', '3', '');
INSERT INTO `search_all` VALUES ('1561', '31', 'show', '1', '');
INSERT INTO `search_all` VALUES ('1562', '31', 'sub-menu', '1', '');
INSERT INTO `search_all` VALUES ('1563', '31', 'sub-pag', '1', '');
INSERT INTO `search_all` VALUES ('1564', '31', 'ad', '1', '');
INSERT INTO `search_all` VALUES ('1565', '31', 'shop', '1', '');
INSERT INTO `search_all` VALUES ('1582', '34', 'compon', '1', '');
INSERT INTO `search_all` VALUES ('1583', '34', 'photographi', '1', '');
INSERT INTO `search_all` VALUES ('1584', '39', 'shop', '2', '');
INSERT INTO `search_all` VALUES ('1585', '39', 'basket', '2', '');
INSERT INTO `search_all` VALUES ('1586', '39', 'compon', '1', '');
INSERT INTO `search_all` VALUES ('1587', '39', 'checkout', '1', '');
INSERT INTO `search_all` VALUES ('1613', '38', 'seperatorproduct', '1', '');
INSERT INTO `search_all` VALUES ('1612', '38', 'custom', '2', '');
INSERT INTO `search_all` VALUES ('1611', '38', 'compon', '4', '');
INSERT INTO `search_all` VALUES ('1610', '38', 'price', '1', '');
INSERT INTO `search_all` VALUES ('1609', '38', 'differ', '1', '');
INSERT INTO `search_all` VALUES ('1608', '38', 'variou', '1', '');
INSERT INTO `search_all` VALUES ('1607', '38', 'creat', '1', '');
INSERT INTO `search_all` VALUES ('1606', '38', 'easi', '1', '');
INSERT INTO `search_all` VALUES ('1605', '38', 'make', '1', '');
INSERT INTO `search_all` VALUES ('1604', '38', 'setse', '1', '');
INSERT INTO `search_all` VALUES ('1603', '38', 'option', '4', '');
INSERT INTO `search_all` VALUES ('1602', '38', 'product', '5', '');
INSERT INTO `search_all` VALUES ('1614', '38', 'optionscompon', '1', '');
INSERT INTO `search_all` VALUES ('1615', '38', 'seper', '1', '');
INSERT INTO `search_all` VALUES ('1651', '37', 'contact', '1', '');
INSERT INTO `search_all` VALUES ('1652', '37', 'form', '2', '');
INSERT INTO `search_all` VALUES ('1653', '37', 'receiv', '1', '');
INSERT INTO `search_all` VALUES ('1654', '37', 'complex', '1', '');
INSERT INTO `search_all` VALUES ('1655', '37', 'order', '2', '');
INSERT INTO `search_all` VALUES ('1656', '37', 'customis', '3', '');
INSERT INTO `search_all` VALUES ('1657', '37', 'even', '1', '');
INSERT INTO `search_all` VALUES ('1658', '37', 'file', '1', '');
INSERT INTO `search_all` VALUES ('1659', '37', 'upload', '1', '');
INSERT INTO `search_all` VALUES ('1650', '37', 'combin', '1', '');
INSERT INTO `search_all` VALUES ('1649', '37', 'can', '1', '');
INSERT INTO `search_all` VALUES ('1648', '37', 'product', '4', '');
INSERT INTO `search_all` VALUES ('1647', '37', 'customiz', '1', '');
INSERT INTO `search_all` VALUES ('1660', '37', 'place', '1', '');
INSERT INTO `search_all` VALUES ('1661', '37', 'compon', '4', '');
INSERT INTO `search_all` VALUES ('1662', '37', 'custom', '2', '');
INSERT INTO `search_all` VALUES ('1663', '37', 'seper', '2', '');
INSERT INTO `search_all` VALUES ('1664', '37', 'follow', '1', '');
INSERT INTO `search_all` VALUES ('1665', '37', 'exampl', '2', '');
INSERT INTO `search_all` VALUES ('1666', '37', 'us', '2', '');
INSERT INTO `search_all` VALUES ('1667', '37', '\'veg', '1', '');
INSERT INTO `search_all` VALUES ('1668', '37', 'box', '1', '');
INSERT INTO `search_all` VALUES ('1669', '37', 'show', '1', '');
INSERT INTO `search_all` VALUES ('1670', '37', 'could', '1', '');
INSERT INTO `search_all` VALUES ('1671', '37', 'veg', '1', '');
INSERT INTO `search_all` VALUES ('1672', '37', 'boxcompon', '1', '');
INSERT INTO `search_all` VALUES ('1755', '36', 'stock', '2', '');
INSERT INTO `search_all` VALUES ('1754', '36', 'item', '1', '');
INSERT INTO `search_all` VALUES ('1753', '36', 'number', '1', '');
INSERT INTO `search_all` VALUES ('1752', '36', 'displai', '1', '');
INSERT INTO `search_all` VALUES ('1751', '36', 'also', '1', '');
INSERT INTO `search_all` VALUES ('1750', '36', 'can', '1', '');
INSERT INTO `search_all` VALUES ('1749', '36', 'templat', '1', '');
INSERT INTO `search_all` VALUES ('1746', '36', 'name', '1', '');
INSERT INTO `search_all` VALUES ('1747', '36', 'depend', '1', '');
INSERT INTO `search_all` VALUES ('1748', '36', 'setup', '1', '');
INSERT INTO `search_all` VALUES ('1745', '36', 'price', '1', '');
INSERT INTO `search_all` VALUES ('1744', '36', 'contain', '1', '');
INSERT INTO `search_all` VALUES ('1743', '36', 'button', '2', '');
INSERT INTO `search_all` VALUES ('1742', '36', 'basket', '1', '');
INSERT INTO `search_all` VALUES ('1741', '36', '\'add', '1', '');
INSERT INTO `search_all` VALUES ('1740', '36', 'simpli', '1', '');
INSERT INTO `search_all` VALUES ('1739', '36', 'websit', '1', '');
INSERT INTO `search_all` VALUES ('1738', '36', 'sell', '1', '');
INSERT INTO `search_all` VALUES ('1737', '36', 'wai', '1', '');
INSERT INTO `search_all` VALUES ('1736', '36', 'easiest', '1', '');
INSERT INTO `search_all` VALUES ('1735', '36', 'quickest', '1', '');
INSERT INTO `search_all` VALUES ('1734', '36', 'product', '5', '');
INSERT INTO `search_all` VALUES ('1733', '36', 'simpl', '5', '');
INSERT INTO `search_all` VALUES ('1758', '36', 'hide', '1', '');
INSERT INTO `search_all` VALUES ('1759', '36', 'reach', '1', '');
INSERT INTO `search_all` VALUES ('1760', '36', 'compon', '4', '');
INSERT INTO `search_all` VALUES ('1761', '36', 'custom', '2', '');
INSERT INTO `search_all` VALUES ('1762', '36', 'seperatora', '1', '');
INSERT INTO `search_all` VALUES ('1763', '36', 'productcompon', '1', '');
INSERT INTO `search_all` VALUES ('1764', '36', 'seper', '1', '');
INSERT INTO `search_all` VALUES ('1765', '36', 'prouct', '1', '');
INSERT INTO `search_all` VALUES ('1766', '35', 'us', '2', '');
INSERT INTO `search_all` VALUES ('1767', '35', 'swatch', '1', '');
INSERT INTO `search_all` VALUES ('1768', '35', 'sell', '1', '');
INSERT INTO `search_all` VALUES ('1769', '35', 'item', '1', '');
INSERT INTO `search_all` VALUES ('1770', '35', 'like', '1', '');
INSERT INTO `search_all` VALUES ('1771', '35', 'cloth', '4', '');
INSERT INTO `search_all` VALUES ('1772', '35', 'templat', '1', '');
INSERT INTO `search_all` VALUES ('1773', '35', 'show', '1', '');
INSERT INTO `search_all` VALUES ('1774', '35', 'product', '4', '');
INSERT INTO `search_all` VALUES ('1775', '35', 'combin', '1', '');
INSERT INTO `search_all` VALUES ('1776', '35', 'imag', '1', '');
INSERT INTO `search_all` VALUES ('1777', '35', 'galleri', '1', '');
INSERT INTO `search_all` VALUES ('1778', '35', 'can', '1', '');
INSERT INTO `search_all` VALUES ('1779', '35', 'displai', '1', '');
INSERT INTO `search_all` VALUES ('1780', '35', '\'swatch', '1', '');
INSERT INTO `search_all` VALUES ('1781', '35', 'type', '1', '');
INSERT INTO `search_all` VALUES ('1782', '35', 'option', '1', '');
INSERT INTO `search_all` VALUES ('1783', '35', 'ideal', '1', '');
INSERT INTO `search_all` VALUES ('1784', '35', 'differ', '1', '');
INSERT INTO `search_all` VALUES ('1785', '35', 'visual', '1', '');
INSERT INTO `search_all` VALUES ('1786', '35', 'version', '1', '');
INSERT INTO `search_all` VALUES ('1787', '35', 'compon', '1', '');
INSERT INTO `search_all` VALUES ('1878', '26', 'group', '1', '');
INSERT INTO `search_all` VALUES ('1879', '26', 'recent', '4', '');
INSERT INTO `search_all` VALUES ('1880', '26', 'blog', '2', '');
INSERT INTO `search_all` VALUES ('1881', '26', 'articl', '4', '');
INSERT INTO `search_all` VALUES ('1882', '26', 'feed', '1', '');
INSERT INTO `search_all` VALUES ('1883', '26', 'built', '1', '');
INSERT INTO `search_all` VALUES ('1884', '26', 'featur', '1', '');
INSERT INTO `search_all` VALUES ('1885', '26', 'found', '1', '');
INSERT INTO `search_all` VALUES ('1886', '26', 'tpl', '1', '');
INSERT INTO `search_all` VALUES ('1887', '26', 'folder', '1', '');
INSERT INTO `search_all` VALUES ('1888', '26', 'anywher', '1', '');
INSERT INTO `search_all` VALUES ('1889', '26', 'home', '1', '');



CREATE TABLE `security` (
`securityid` int(11) NOT NULL AUTO_INCREMENT,
`username` varchar(255) NOT NULL,
`password` text NOT NULL,
`enabled` varchar(255) NOT NULL,
primary key(securityid)
);




CREATE TABLE `settings` (
`settingsid` int(11) NOT NULL AUTO_INCREMENT,
`tracking_code` text NOT NULL,
`livechat_status` varchar(255) NOT NULL,
`livechat_name` varchar(255) NOT NULL,
`livechat_message` varchar(255) NOT NULL,
`mini_nav` varchar(255) NOT NULL,
`page_filter_lang` varchar(255) NOT NULL,
`page_filter_search` varchar(255) NOT NULL,
`page_filter_page` smallint(6) NOT NULL,
`blog_filter_page` smallint(6) NOT NULL,
`blog_filter_lang` varchar(255) NOT NULL,
`blog_filter_search` varchar(255) NOT NULL,
`blog_filter_author` mediumint(9) NOT NULL,
`blog_filter_cat` varchar(255) NOT NULL,
`page_filter_parent` smallint(6) NOT NULL,
`page_filter_show` smallint(6) NOT NULL,
`page_filter_type` varchar(255) NOT NULL,
`newsletter_filter_page` smallint(6) NOT NULL,
`newsletter_filter_search` varchar(255) NOT NULL,
`db_version` smallint(6) NOT NULL,
`newsletter_filter_group` varchar(255) NOT NULL,
`products_filter_page` smallint(6) NOT NULL,
`products_filter_search` varchar(255) NOT NULL,
`products_filter_show` smallint(6) NOT NULL,
`snippets_filter_page` smallint(6) NOT NULL,
`snippets_filter_search` varchar(255) NOT NULL,
`snippets_filter_show` smallint(6) NOT NULL,
primary key(settingsid)
);

INSERT INTO `settings` VALUES ('1', '', 'off', '', '', '', '', '', '1', '1', '', '', '0', '', '-1', '31', '', '1', '', '8', '', '1', '', '0', '1', '', '0');



CREATE TABLE `shop_config` (
`shop_configid` int(11) NOT NULL AUTO_INCREMENT,
`paypal_email` varchar(255) NOT NULL,
`no_shipping` tinyint(4) NOT NULL,
`return_success` varchar(255) NOT NULL,
`return_fail` varchar(255) NOT NULL,
`no_note` varchar(255) NOT NULL,
`order_received_email` text NOT NULL,
`order_sent_email` text NOT NULL,
`currency` varchar(255) NOT NULL,
`smtp_server` varchar(255) NOT NULL,
`from_email` varchar(255) NOT NULL,
`from_name` varchar(255) NOT NULL,
`username` varchar(255) NOT NULL,
`password` varchar(255) NOT NULL,
`order_received_email_subject` varchar(255) NOT NULL,
`order_sent_email_subject` varchar(255) NOT NULL,
primary key(shop_configid)
);

INSERT INTO `shop_config` VALUES ('1', '', '0', '', '', '', '', '', 'USD', '', '', '', '', '', '', '');



CREATE TABLE `static_pages` (
`static_pagesid` int(11) NOT NULL AUTO_INCREMENT,
`pagetitle` varchar(255) NOT NULL,
`order` varchar(255) NOT NULL,
`keywords` mediumtext NOT NULL,
`summary` mediumtext NOT NULL,
`content` mediumtext NOT NULL,
`homepage` varchar(255) NOT NULL,
`gallery` varchar(255) NOT NULL,
`longtitle` varchar(255) NOT NULL,
`form` varchar(255) NOT NULL,
`parent` varchar(255) NOT NULL,
`live` varchar(255) NOT NULL,
`type` varchar(255) NOT NULL,
`template` varchar(255) NOT NULL,
`language` varchar(255) NOT NULL,
`calendar` varchar(255) NOT NULL,
`blog` varchar(255) NOT NULL,
`playlist` varchar(255) NOT NULL,
`content2` text NOT NULL,
`newsletter` varchar(255) NOT NULL,
`shop` varchar(255) NOT NULL,
`deleted` varchar(255) NOT NULL,
`sitemap` varchar(255) NOT NULL,
`locked` varchar(255) NOT NULL,
`security` varchar(255) NOT NULL,
`last_updated` int(11) NOT NULL,
`content_right` mediumtext NOT NULL,
`content_left` mediumtext NOT NULL,
`content2_left` mediumtext NOT NULL,
`content2_right` mediumtext NOT NULL,
`top_parent` varchar(255) NOT NULL,
primary key(static_pagesid)
);

INSERT INTO `static_pages` VALUES ('26', 'Home', '-1312016419', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1 style=\\\"text-align: left;\\\">Welcome to an example website!</h1>\n<h2 style=\\\"text-align: left;\\\">You can use this site to test out how SetSeed works. Visit <a href=\\\"/admin\\\">/admin</a> on your domain to start using the CMS.</h2>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<h2>Template Positions</h2>\n<p>This template has several \\\'Template Positions\\\' defined in the theme (see file: themes/examplesite/split_classes.csv) . Template positions make it really easy for your clients to insert content in different sections of your template.</p>\n<h2>Slideshows</h2>\n<p>The column opposite contains an example of a slideshow. These are easy to create using jQuery and can use images added in the CMS. Edit this page to see how the images are added, they\\\'re simply added to the page and given a \\\'Custom Style\\\' of \\\'Slideshow\\\'. The jQuery code in theme/examplesite/javascripts/custom.js then uses that selector to convert the images into a slideshow.</p>\n<h2>Don\\\'t forget to try out  the \\\'Livechat\\\' system</h2>\n<p>Log in to the CMS by <a href=\\\"/admin/\\\">clicking here</a> and then click \\\'Settings\\\' &gt; \\\'Livechat\\\' &gt; \\\'Status\\\' &gt; \\\'Online\\\'. You\\\'ll then see the Livechat link show up in the header of this site.</p>\n<h2>Give the search tool a go</h2>\n<p>Try using the site-wide search system by searching for terms in the \\\'search\\\' box in the header of this site.</p>\n<div class=\\\"bpe_split_divider Right_Column\\\" alt=\\\"Right_Column\\\"></div>\n<div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/statue.jpg\\\" alt=\\\"Statue\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/bridge.jpg\\\" alt=\\\"Man walking over bridge\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/lapwing.jpg\\\" alt=\\\"Lapwing having a bath\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/flowers.jpg\\\" alt=\\\"Blossom in the sun\\\" />\n</div><div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentSnippet-32\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>SNIPPET: Footer text</strong></div></div></div></div>\n<div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<h2>Email Newsletter</h2>\n<p>Your sites can use SetSeed\\\'s email newsletter system to collect subscribers to a mailing list.</p>\n<div class=\\\"SETSEEDcomponent ComponentNewsletter-default\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>NEWSLETTER SIGNUP FORM: ‘Default’ Group</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n<h2>Recent blog articles</h2>\n<p>These feed of recent blog articles is built using the Custom Feature system. It can be found in templates/custom/recent_articles.tpl - templates in that folder can be added anywhere to pages in the CMS.</p>\n<div class=\\\"SETSEEDcomponent ComponentCustom-recent_articles.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: recent articles</strong></div></div></div></div>\n', 'yes', '', 'Home', '', '', 'yes', 'topLevel', 'main', 'en', '', '', '', '', '', '', '', '', '', '', '1312044206', '', '', '', '', '');
INSERT INTO `static_pages` VALUES ('27', 'Gallery', '-1312016399', '', '', '<div class=\"SETSEEDcomponent ComponentGallery-1\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>GALLERY: Example photo gallery</strong></div></div></div></div><div class=\"bpe_split_divider Top_Section\" alt=\"Top_Section\"></div>\n<h1>Photo gallery</h1>\n<p>This is an example of a photo gallery created in SetSeed. Images can be quickly uploaded using the fast batch uploaded. Thumbnails are automatically created.</p>\n<div class=\"bpe_split_divider Footer_Left\" alt=\"Footer_Left\"></div>\n<div class=\"SETSEEDcomponent ComponentSnippet-32\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>SNIPPET: Footer text</strong></div></div></div></div><div class=\"bpe_split_divider Footer_Right\" alt=\"Footer_Right\"></div>\n<h2>Blog</h2>\n<div class=\"SETSEEDcomponent ComponentCustom-recent_articles.tpl\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>CUSTOM COMPONENT: recent articles</strong></div></div></div></div><div class=\"bpe_split_divider Footer_Middle\" alt=\"Footer_Middle\"></div>\n<h2>Email Newsletter</h2>\n<p>Your sites can use SetSeed\'s email newsletter system to collect subscribers to a mailing list.</p>\n<div class=\"SETSEEDcomponent ComponentNewsletter-default\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>NEWSLETTER SIGNUP FORM: ‘Default’ Group</strong></div></div></div></div>\n', '', '', 'Gallery', '', '', 'yes', 'topLevel', 'main', 'en', '', '', '', '', '', '', '', '', '', '', '1312024231', '', '', '', '', '');
INSERT INTO `static_pages` VALUES ('28', 'Contact', '-1312016389', '', '', '<div class=\"bpe_split_divider Top_Section\" alt=\"Top_Section\"></div>\n<h1>Contact form</h1>\n<p>SetSeed lets your clients build amazing contact forms with unbelievable simplicity. See the form below as an example. If you want to test it, you\'ll need to enter your email address as the recipient in the \'Components\' &gt; \'Contact forms\' &gt; \'Contact form\' &gt; \'Email recipient\' menu in the CMS.</p>\n<div class=\"bpe_split_divider Left_Column\" alt=\"Left_Column\"></div>\n<div class=\"SETSEEDcomponent ComponentForm-1\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>CONTACT FORM: Contact form</strong></div></div></div></div><div class=\"bpe_split_divider Footer_Left\" alt=\"Footer_Left\"></div>\n<div class=\"SETSEEDcomponent ComponentSnippet-32\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>SNIPPET: Footer text</strong></div></div></div></div>\n<div class=\"bpe_split_divider Footer_Middle\" alt=\"Footer_Middle\"></div>\n<div class=\"SETSEEDcomponent ComponentSnippet-33\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>SNIPPET: Footer Middle</strong></div></div></div></div><div class=\"bpe_split_divider Footer_Right\" alt=\"Footer_Right\"></div>\n<h2>Blog</h2>\n<div class=\"SETSEEDcomponent ComponentCustom-recent_articles.tpl\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>CUSTOM COMPONENT: recent articles</strong></div></div></div></div>\n', '', '', 'Contact', '', '', 'yes', 'topLevel', 'main', 'en', '', '', '', '', '', '', '', '', '', '', '1312025108', '', '', '', '', '');
INSERT INTO `static_pages` VALUES ('29', 'Calendar', '-1312016379', '', '', '<div class=\"bpe_split_divider Top_Section\" alt=\"Top_Section\"></div>\n<h1>Calendar</h1>\n<p>SetSeed has a powerful calendar system built in. You can added events in multiple categories and add calendars showing individual categories or all categories to your pages. Try adding an event in the <a href=\"/admin/\">CMS admin</a> by clicking \'Components\' &gt; \'Calendar\' &gt; (choose a day) &gt; \'Add new event for (selected day)\'.</p>\n<div class=\"SETSEEDcomponent ComponentCalendar\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>Calendar</strong></div></div></div></div><div class=\"bpe_split_divider Footer_Left\" alt=\"Footer_Left\"></div>\n<div class=\"SETSEEDcomponent ComponentSnippet-32\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>SNIPPET: Footer text</strong></div></div></div></div><div class=\"bpe_split_divider Footer_Middle\" alt=\"Footer_Middle\"></div>\n<div class=\"SETSEEDcomponent ComponentSnippet-33\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>SNIPPET: Footer Middle</strong></div></div></div></div><div class=\"bpe_split_divider Footer_Right\" alt=\"Footer_Right\"></div>\n<h2>News</h2>\n<div class=\"SETSEEDcomponent ComponentCustom-recent_articles.tpl\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>CUSTOM COMPONENT: recent articles</strong></div></div></div></div>\n', '', '', 'Calendar', '', '', 'yes', 'topLevel', 'main', 'en', '', '', '', '', '', '', '', '', '', '', '1312025347', '', '', '', '', '');
INSERT INTO `static_pages` VALUES ('30', 'Blog', '-1312016369', '', '', '<div class=\"SETSEEDcomponent ComponentBlog\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>Blog</strong></div></div></div></div>\n', '', '', 'Blog', '', '', 'yes', 'topLevel', 'main', 'en', '', 'yes', '', '', '', '', '', '', '', '', '1312025379', '', '', '', '', '');
INSERT INTO `static_pages` VALUES ('31', 'Shop', '-1312016409', '', '', '<div class=\"bpe_split_divider Top_Section\" alt=\"Top_Section\"></div>\n<h1>Online store</h1>\n<p>SetSeed makes it really easy to sell products from anywhere on your site. Get an idea of some of the different kinds of products you can sell by browsing the different example pages in the left menu. The template for this site is built to automatically show a sub-menu for a page if it has sub-pages added to it.</p>\n', '', '', 'Shop', '', '', 'yes', 'topLevel', 'main', 'en', '', '', '', '', '', '', '', '', '', '', '1312025859', '', '', '', '', '');
INSERT INTO `static_pages` VALUES ('32', 'Footer text', '', '', '', '<h2>Snippet System</h2>\n\n\n\n\n<p>This content is created using the Snippets system. Content created in a Snippet can be added anywhere on any page, and used as many times as needed. For example, this content is used on several pages on this example site, but was created just once, in the Components &gt; Snippets menu.</p>\n\n\n\n\n', '', '', '', '', '', '', 'snippet', '', '', '', '', '', '', '', '', '', '', '', '', '0', '', '', '', '', '');
INSERT INTO `static_pages` VALUES ('33', 'Footer Middle', '', '', '', '<h2>Email newsletter</h2>\n\n\n\n<div class=\"SETSEEDcomponent ComponentNewsletter-default\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>NEWSLETTER SIGNUP FORM: ‘Default’ Group</strong></div></div></div></div>', '', '', '', '', '', '', 'snippet', '', '', '', '', '', '', '', '', '', '', '', '', '0', '', '', '', '', '');
INSERT INTO `static_pages` VALUES ('34', 'Photography Prints', '-1312025657', '', '', '<div class=\"bpe_split_divider Top_Section\" alt=\"Top_Section\"></div>\n<h1>Photo Prints</h1>\n<p>SetSeed makes it really easy to sell photo prints over your website. Here we\'ve combined a product with an image gallery to serve as the list of choices for that product.</p>\n<div class=\"SETSEEDcomponent ComponentProduct-1\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>PRODUCT: Photo print</strong></div></div></div></div>\n', '', '', 'Photography Prints', '', '31', 'yes', 'subLevel', 'main', 'en', '', '', '', '', '', '', '', '', '', '', '1312025887', '', '', '', '', '');
INSERT INTO `static_pages` VALUES ('35', 'Clothing', '-1312025667', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Use swatches to sell items like clothes</h1>\n<p>This templates shows how a product combined with an image gallery can be used to display \\\'swatch\\\' type options for a product - ideal for clothes or other products with different visual versions.</p>\n<div class=\\\"SETSEEDcomponent ComponentProduct-5\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>PRODUCT: Clothes</strong></div></div></div></div>\n', '', '', 'Clothing', '', '31', 'yes', 'subLevel', 'Swatch_products', 'en', '', '', '', '', '', '', '', '', '', '', '1312027801', '', '', '', '', '');
INSERT INTO `static_pages` VALUES ('36', 'Simple Products', '-1312025697', '', '', '<div class=\"bpe_split_divider Top_Section\" alt=\"Top_Section\"></div>\n<h1>Simple products</h1>\n<h2>Simple products are the quickest, easiest way to sell products your website.</h2>\n<p>They are simply \'add to basket\' buttons which contain a price and name. Depending on how you setup your templates you can also display the number of items in stock, and even have the button automatically hide once the stock reaches \'0\'.</p>\n<div class=\"SETSEEDcomponent ComponentCustom-seperator.tpl\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>CUSTOM COMPONENT: seperator</strong></div></div></div></div><h2>A simple product</h2>\n<div class=\"SETSEEDcomponent ComponentProduct-4\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>PRODUCT: A simple product</strong></div></div></div></div><div class=\"SETSEEDcomponent ComponentCustom-seperator.tpl\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>CUSTOM COMPONENT: seperator</strong></div></div></div></div>\n', '', '', 'Simple Proucts', '', '31', 'yes', 'subLevel', 'main', 'en', '', '', '', '', '', '', '', '', '', '', '1312027477', '', '', '', '', '');
INSERT INTO `static_pages` VALUES ('37', 'Customisable Products', '-1312025677', '', '', '<div class=\"bpe_split_divider Top_Section\" alt=\"Top_Section\"></div>\n<h1>Customizable product</h1>\n<p>You can combine contact forms with products to receive complex order customisation, and even file uploads, with each order placed.</p>\n<div class=\"SETSEEDcomponent ComponentCustom-seperator.tpl\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>CUSTOM COMPONENT: seperator</strong></div></div></div></div>\n<p>The following example uses a \'Veg box\' as an example to show how such customisation forms could be used.</p>\n<div class=\"SETSEEDcomponent ComponentProduct-3\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>PRODUCT: Veg Box</strong></div></div></div></div><div class=\"SETSEEDcomponent ComponentCustom-seperator.tpl\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>CUSTOM COMPONENT: seperator</strong></div></div></div></div>\n', '', '', 'Customisable Products', '', '31', 'yes', 'subLevel', 'main', 'en', '', '', '', '', '', '', '', '', '', '', '1312027174', '', '', '', '', '');
INSERT INTO `static_pages` VALUES ('38', 'Products with options', '-1312025687', '', '', '<div class=\"bpe_split_divider Top_Section\" alt=\"Top_Section\"></div>\n<h1>Product with options</h1>\n<p>SetSeed makes it easy to create a product that has various options with different prices.</p>\n<div class=\"SETSEEDcomponent ComponentCustom-seperator.tpl\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>CUSTOM COMPONENT: seperator</strong></div></div></div></div><h2>Product with options</h2>\n<div class=\"SETSEEDcomponent ComponentProduct-2\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>PRODUCT: Product with options</strong></div></div></div></div><div class=\"SETSEEDcomponent ComponentCustom-seperator.tpl\"><div><div><div><a class=\"componentDelete\"></a>COMPONENT <strong>CUSTOM COMPONENT: seperator</strong></div></div></div></div>\n', '', '', 'Products with options', '', '31', 'yes', 'subLevel', 'main', 'en', '', '', '', '', '', '', '', '', '', '', '1312026955', '', '', '', '', '');
INSERT INTO `static_pages` VALUES ('39', 'Checkout', '-1312026072', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Shopping Basket</h1>\n<div class=\\\"SETSEEDcomponent ComponentShoppingBasket\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>Shopping Basket</strong></div></div></div></div>\n', '', '', 'Checkout', '', '', 'yes', 'nonLinking', 'main', 'en', '', '', '', '', '', 'yes', '', '', '', '', '1312026097', '', '', '', '', '');
INSERT INTO `static_pages` VALUES ('40', 'Footer', '', '', '', '<p>Global positions in the template like this copyright / footer space can be defined as Sitewide Content areas, and edited in the Settings &gt; Sitewide Content menu</p>\n', '', '', '', '', '', '', 'sitewideContent', '', '', '', '', '', '', '', '', '', '', '', '', '0', '', '', '', '', '');



CREATE TABLE `static_pages_versions` (
`static_pages_versionsid` int(11) NOT NULL AUTO_INCREMENT,
`pagetitle` varchar(255) NOT NULL,
`keywords` varchar(255) NOT NULL,
`summary` varchar(255) NOT NULL,
`content` mediumtext NOT NULL,
`longtitle` varchar(255) NOT NULL,
`content2` text NOT NULL,
`date_saved` int(11) NOT NULL,
`belongs_to_static_page_id` varchar(255) NOT NULL,
`content_left` mediumtext NOT NULL,
`content_right` mediumtext NOT NULL,
`content2_left` mediumtext NOT NULL,
`content2_right` mediumtext NOT NULL,
`draft` tinyint(4) NOT NULL,
primary key(static_pages_versionsid)
);

INSERT INTO `static_pages_versions` VALUES ('1', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1 style=\\\"text-align: left;\\\">Welcome to an example website!</h1>\n<h2 style=\\\"text-align: left;\\\">You can use this site to test out how SetSeed works. Visit <a href=\\\"/admin\\\">/admin</a> on your domain to start using the CMS.</h2>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<h2>Template Positions</h2>\n<p>This template has several \\\'Template Positions\\\' defined in the theme (see file: themes/examplesite/split_classes.csv) . Template positions make it really easy for your clients to insert content in different sections of your template.</p>\n<h2>Slideshows</h2>\n<p>The column opposite contains an example of a slideshow. These are easy to create using jQuery and can use images added in the CMS. Edit this page to see how the images are added, they\\\'re simply added to the page and given a \\\'Custom Style\\\' of \\\'Slideshow\\\'. The jQuery code in theme/examplesite/javascripts/custom.js then uses that selector to convert the images into a slideshow.</p>\n<h2>Don\\\'t forget to try out  the \\\'Livechat\\\' system</h2>\n<p>Log in to the CMS by <a href=\\\"/admin/\\\">clicking here</a> and then click \\\'Settings\\\' &gt; \\\'Livechat\\\' &gt; \\\'Status\\\' &gt; \\\'Online\\\'. You\\\'ll then see the Livechat link show up in the header of this site.</p>\n<h2>Give the search tool a go</h2>\n<p>Try using the site-wide search system by searching for terms in the \\\'search\\\' box in the header of this site.</p>\n<div class=\\\"bpe_split_divider Right_Column\\\" alt=\\\"Right_Column\\\"></div>\n<div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/statue.jpg\\\" alt=\\\"Statue\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/bridge.jpg\\\" alt=\\\"Man walking over bridge\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/lapwing.jpg\\\" alt=\\\"Lapwing having a bath\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/flowers.jpg\\\" alt=\\\"Blossom in the sun\\\" />\n</div><div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentSnippet-32\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>SNIPPET: Footer text</strong></div></div></div></div>\n<div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<h2>Email Newsletter</h2>\n<p>Your sites can use SetSeed\\\'s email newsletter system to collect subscribers to a mailing list.</p>\n<div class=\\\"SETSEEDcomponent ComponentNewsletter-default\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>NEWSLETTER SIGNUP FORM: ‘Default’ Group</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n<h2>Recent blog articles</h2>\n<p>These feed of recent blog articles is built using the Custom Feature system. It can be found in templates/custom/recent_articles.tpl - templates in that folder can be added anywhere to pages in the CMS.</p>\n<div class=\\\"SETSEEDcomponent ComponentCustom-recent_articles.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: recent articles</strong></div></div></div></div>\n', '', '', '1312044211', '26', '', '', '', '', '1');
INSERT INTO `static_pages_versions` VALUES ('2', '', '', '', '<div class=\\\"SETSEEDcomponent ComponentGallery-1\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>GALLERY: Example photo gallery</strong></div></div></div></div><div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Photo gallery</h1>\n<p>This is an example of a photo gallery created in SetSeed. Images can be quickly uploaded using the fast batch uploaded. Thumbnails are automatically created.</p>\n<div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentSnippet-32\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>SNIPPET: Footer text</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n<h2>Blog</h2>\n<div class=\\\"SETSEEDcomponent ComponentCustom-recent_articles.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: recent articles</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<h2>Email Newsletter</h2>\n<p>Your sites can use SetSeed\\\'s email newsletter system to collect subscribers to a mailing list.</p>\n<div class=\\\"SETSEEDcomponent ComponentNewsletter-default\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>NEWSLETTER SIGNUP FORM: ‘Default’ Group</strong></div></div></div></div>\n', '', '', '1312024236', '27', '', '', '', '', '1');
INSERT INTO `static_pages_versions` VALUES ('3', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Contact form</h1>\n<p>SetSeed lets your clients build amazing contact forms with unbelievable simplicity. See the form below as an example. If you want to test it, you\\\'ll need to enter your email address as the recipient in the \\\'Components\\\' &gt; \\\'Contact forms\\\' &gt; \\\'Contact form\\\' &gt; \\\'Email recipient\\\' menu in the CMS.</p>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentForm-1\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CONTACT FORM: Contact form</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentSnippet-32\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>SNIPPET: Footer text</strong></div></div></div></div>\n<div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentSnippet-33\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>SNIPPET: Footer Middle</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n<h2>Blog</h2>\n<div class=\\\"SETSEEDcomponent ComponentCustom-recent_articles.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: recent articles</strong></div></div></div></div>\n', '', '', '1312025113', '28', '', '', '', '', '1');
INSERT INTO `static_pages_versions` VALUES ('4', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Calendar</h1>\n<p>SetSeed has a powerful calendar system built in. You can added events in multiple categories and add calendars showing individual categories or all categories to your pages. Try adding an event in the <a href=\\\"/admin/\\\">CMS admin</a> by clicking \\\'Components\\\' &gt; \\\'Calendar\\\' &gt; (choose a day) &gt; \\\'Add new event for (selected day)\\\'.</p>\n<div class=\\\"SETSEEDcomponent ComponentCalendar\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>Calendar</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentSnippet-32\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>SNIPPET: Footer text</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentSnippet-33\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>SNIPPET: Footer Middle</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n<h2>News</h2>\n<div class=\\\"SETSEEDcomponent ComponentCustom-recent_articles.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: recent articles</strong></div></div></div></div>\n', '', '', '1312025352', '29', '', '', '', '', '1');
INSERT INTO `static_pages_versions` VALUES ('5', '', '', '', '<div class=\\\"SETSEEDcomponent ComponentBlog\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>Blog</strong></div></div></div></div>\n', '', '', '1312025384', '30', '', '', '', '', '1');
INSERT INTO `static_pages_versions` VALUES ('6', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Online store</h1>\n<p>SetSeed makes it really easy to sell products from anywhere on your site. Get an idea of some of the different kinds of products you can sell by browsing the different example pages in the left menu. The template for this site is built to automatically show a sub-menu for a page if it has sub-pages added to it.</p>\n', '', '', '1312025864', '31', '', '', '', '', '1');
INSERT INTO `static_pages_versions` VALUES ('7', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Welcome to an example website!</h1>\n<p>You can use this site to test out how SetSeed works.</p>\n', '', '', '1312016801', '26', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('8', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Welcome to an example website!</h1>\n<p>You can use this site to test out how SetSeed works.</p>\n', '', '', '1312016898', '26', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('9', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Welcome to an example website!</h1>\n<p>You can use this site to test out how SetSeed works.</p>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<h2>Template Positions</h2>\n<p>This template has several \\\'Template Positions\\\' defined in the theme (see file: themes/examplesite/split_classes.csv) .</p>\n<div class=\\\"bpe_split_divider Right_Column\\\" alt=\\\"Right_Column\\\"></div>\n<div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n', '', '', '1312017002', '26', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('10', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Welcome to an example website!</h1>\n<p>You can use this site to test out how SetSeed works.</p>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<h2>Template Positions</h2>\n<p>This template has several \\\'Template Positions\\\' defined in the theme (see file: themes/examplesite/split_classes.csv) . Template positions make it really easy for your clients to insert content in different sections of your template.</p>\n<div class=\\\"bpe_split_divider Right_Column\\\" alt=\\\"Right_Column\\\"></div>\n<div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n', '', '', '1312017031', '26', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('11', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Welcome to an example website!</h1>\n<p>You can use this site to test out how SetSeed works.</p>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<h2>Template Positions</h2>\n<p>This template has several \\\'Template Positions\\\' defined in the theme (see file: themes/examplesite/split_classes.csv) . Template positions make it really easy for your clients to insert content in different sections of your template.</p>\n<h2>Slideshows</h2>\n<p>The column opposite contains an example of a slideshow. These are easy to create using jQuery and can use images added in the CMS. Edit this page to see how the images are added, they\\\'re simply added to the page and given a \\\'Custom Style\\\' of \\\'Slideshow\\\'. The jQuery code in theme/examplesite/javascripts/custom.js then uses that selector to convert the images into a slideshow.</p>\n<div class=\\\"bpe_split_divider Right_Column\\\" alt=\\\"Right_Column\\\"></div>\n<div class=\\\"bpe_image\\\"><img src=\\\"/images/statue.jpg\\\" alt=\\\"\\\" />\n</div><div class=\\\"bpe_image\\\"><img src=\\\"/images/bridge.jpg\\\" alt=\\\"\\\" />\n</div><div class=\\\"bpe_image\\\"><img src=\\\"/images/lapwing.jpg\\\" alt=\\\"\\\" />\n</div><div class=\\\"bpe_image\\\"><img src=\\\"/images/flowers.jpg\\\" alt=\\\"\\\" />\n</div>\n', '', '', '1312017232', '26', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('12', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Welcome to an example website!</h1>\n<p>You can use this site to test out how SetSeed works.</p>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<h2>Template Positions</h2>\n<p>This template has several \\\'Template Positions\\\' defined in the theme (see file: themes/examplesite/split_classes.csv) . Template positions make it really easy for your clients to insert content in different sections of your template.</p>\n<h2>Slideshows</h2>\n<p>The column opposite contains an example of a slideshow. These are easy to create using jQuery and can use images added in the CMS. Edit this page to see how the images are added, they\\\'re simply added to the page and given a \\\'Custom Style\\\' of \\\'Slideshow\\\'. The jQuery code in theme/examplesite/javascripts/custom.js then uses that selector to convert the images into a slideshow.</p>\n<div class=\\\"bpe_split_divider Right_Column\\\" alt=\\\"Right_Column\\\"></div>\n<div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/statue.jpg\\\" alt=\\\"\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/bridge.jpg\\\" alt=\\\"\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/lapwing.jpg\\\" alt=\\\"\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/flowers.jpg\\\" alt=\\\"\\\" />\n</div>\n', '', '', '1312017245', '26', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('13', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Welcome to an example website!</h1>\n<p>You can use this site to test out how SetSeed works.</p>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<h2>Template Positions</h2>\n<p>This template has several \\\'Template Positions\\\' defined in the theme (see file: themes/examplesite/split_classes.csv) . Template positions make it really easy for your clients to insert content in different sections of your template.</p>\n<h2>Slideshows</h2>\n<p>The column opposite contains an example of a slideshow. These are easy to create using jQuery and can use images added in the CMS. Edit this page to see how the images are added, they\\\'re simply added to the page and given a \\\'Custom Style\\\' of \\\'Slideshow\\\'. The jQuery code in theme/examplesite/javascripts/custom.js then uses that selector to convert the images into a slideshow.</p>\n<div class=\\\"bpe_split_divider Right_Column\\\" alt=\\\"Right_Column\\\"></div>\n<div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/statue.jpg\\\" alt=\\\"Statue\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/bridge.jpg\\\" alt=\\\"Man walking over bridge\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/lapwing.jpg\\\" alt=\\\"Lapwing having a bath\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/flowers.jpg\\\" alt=\\\"Blossom in the sun\\\" />\n</div>\n', '', '', '1312017294', '26', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('14', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Welcome to an example website!</h1>\n<h2>You can use this site to test out how SetSeed works.</h2>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<h2>Template Positions</h2>\n<p>This template has several \\\'Template Positions\\\' defined in the theme (see file: themes/examplesite/split_classes.csv) . Template positions make it really easy for your clients to insert content in different sections of your template.</p>\n<h2>Slideshows</h2>\n<p>The column opposite contains an example of a slideshow. These are easy to create using jQuery and can use images added in the CMS. Edit this page to see how the images are added, they\\\'re simply added to the page and given a \\\'Custom Style\\\' of \\\'Slideshow\\\'. The jQuery code in theme/examplesite/javascripts/custom.js then uses that selector to convert the images into a slideshow.</p>\n<div class=\\\"bpe_split_divider Right_Column\\\" alt=\\\"Right_Column\\\"></div>\n<div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/statue.jpg\\\" alt=\\\"Statue\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/bridge.jpg\\\" alt=\\\"Man walking over bridge\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/lapwing.jpg\\\" alt=\\\"Lapwing having a bath\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/flowers.jpg\\\" alt=\\\"Blossom in the sun\\\" />\n</div>\n', '', '', '1312017324', '26', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('15', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Welcome to an example website!</h1>\n<h2>You can use this site to test out how SetSeed works.</h2>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<h2>Template Positions</h2>\n<p>This template has several \\\'Template Positions\\\' defined in the theme (see file: themes/examplesite/split_classes.csv) . Template positions make it really easy for your clients to insert content in different sections of your template.</p>\n<h2>Slideshows</h2>\n<p>The column opposite contains an example of a slideshow. These are easy to create using jQuery and can use images added in the CMS. Edit this page to see how the images are added, they\\\'re simply added to the page and given a \\\'Custom Style\\\' of \\\'Slideshow\\\'. The jQuery code in theme/examplesite/javascripts/custom.js then uses that selector to convert the images into a slideshow.</p>\n<div class=\\\"bpe_split_divider Right_Column\\\" alt=\\\"Right_Column\\\"></div>\n<div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/statue.jpg\\\" alt=\\\"Statue\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/bridge.jpg\\\" alt=\\\"Man walking over bridge\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/lapwing.jpg\\\" alt=\\\"Lapwing having a bath\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/flowers.jpg\\\" alt=\\\"Blossom in the sun\\\" />\n</div><div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<h2>This is another template position</h2>\n<p>And can have any content added to it.</p>\n<div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<h2>Email Newsletter</h2>\n<p>Your sites can use SetSeed\\\'s email newsletter system to collect subscribers to a mailing list.</p>\n<div class=\\\"SETSEEDcomponent ComponentNewsletter-default\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>NEWSLETTER SIGNUP FORM: ‘Default’ Group</strong></div></div></div></div>\n', '', '', '1312017468', '26', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('18', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1 style=\\\"text-align: center;\\\">Welcome to an example website!</h1>\n<h2>You can use this site to test out how SetSeed works.</h2>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<h2>Template Positions</h2>\n<p>This template has several \\\'Template Positions\\\' defined in the theme (see file: themes/examplesite/split_classes.csv) . Template positions make it really easy for your clients to insert content in different sections of your template.</p>\n<h2>Slideshows</h2>\n<p>The column opposite contains an example of a slideshow. These are easy to create using jQuery and can use images added in the CMS. Edit this page to see how the images are added, they\\\'re simply added to the page and given a \\\'Custom Style\\\' of \\\'Slideshow\\\'. The jQuery code in theme/examplesite/javascripts/custom.js then uses that selector to convert the images into a slideshow.</p>\n<div class=\\\"bpe_split_divider Right_Column\\\" alt=\\\"Right_Column\\\"></div>\n<div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/statue.jpg\\\" alt=\\\"Statue\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/bridge.jpg\\\" alt=\\\"Man walking over bridge\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/lapwing.jpg\\\" alt=\\\"Lapwing having a bath\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/flowers.jpg\\\" alt=\\\"Blossom in the sun\\\" />\n</div><div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<h2>This is another template position</h2>\n<p>And can have any content added to it.</p>\n<div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<h2>Email Newsletter</h2>\n<p>Your sites can use SetSeed\\\'s email newsletter system to collect subscribers to a mailing list.</p>\n<div class=\\\"SETSEEDcomponent ComponentNewsletter-default\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>NEWSLETTER SIGNUP FORM: ‘Default’ Group</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n<h2>Recent blog articles</h2>\n<p>These feed of recent blog articles is built using the Custom Feature system. It can be found in templates/custom/recent_articles.tpl - templates in that folder can be added anywhere to pages in the CMS.</p>\n<div class=\\\"SETSEEDcomponent ComponentCustom-recent_articles.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: recent articles</strong></div></div></div></div>\n', '', '', '1312017903', '26', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('16', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Welcome to an example website!</h1>\n<h2>You can use this site to test out how SetSeed works.</h2>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<h2>Template Positions</h2>\n<p>This template has several \\\'Template Positions\\\' defined in the theme (see file: themes/examplesite/split_classes.csv) . Template positions make it really easy for your clients to insert content in different sections of your template.</p>\n<h2>Slideshows</h2>\n<p>The column opposite contains an example of a slideshow. These are easy to create using jQuery and can use images added in the CMS. Edit this page to see how the images are added, they\\\'re simply added to the page and given a \\\'Custom Style\\\' of \\\'Slideshow\\\'. The jQuery code in theme/examplesite/javascripts/custom.js then uses that selector to convert the images into a slideshow.</p>\n<div class=\\\"bpe_split_divider Right_Column\\\" alt=\\\"Right_Column\\\"></div>\n<div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/statue.jpg\\\" alt=\\\"Statue\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/bridge.jpg\\\" alt=\\\"Man walking over bridge\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/lapwing.jpg\\\" alt=\\\"Lapwing having a bath\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/flowers.jpg\\\" alt=\\\"Blossom in the sun\\\" />\n</div><div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<h2>This is another template position</h2>\n<p>And can have any content added to it.</p>\n<div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<h2>Email Newsletter</h2>\n<p>Your sites can use SetSeed\\\'s email newsletter system to collect subscribers to a mailing list.</p>\n<div class=\\\"SETSEEDcomponent ComponentNewsletter-default\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>NEWSLETTER SIGNUP FORM: ‘Default’ Group</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n<h2>Recent blog articles</h2>\n<p>These feed of recent blog articles is built using the Custom Feature system. It can be found in themes/examplesite/templates/custom/recent_articles.tpl - templates in that folder can be added anywhere to pages in the CMS.</p>\n<div class=\\\"SETSEEDcomponent ComponentCustom-recent_articles.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: recent articles</strong></div></div></div></div>\n', '', '', '1312017737', '26', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('17', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Welcome to an example website!</h1>\n<h2>You can use this site to test out how SetSeed works.</h2>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<h2>Template Positions</h2>\n<p>This template has several \\\'Template Positions\\\' defined in the theme (see file: themes/examplesite/split_classes.csv) . Template positions make it really easy for your clients to insert content in different sections of your template.</p>\n<h2>Slideshows</h2>\n<p>The column opposite contains an example of a slideshow. These are easy to create using jQuery and can use images added in the CMS. Edit this page to see how the images are added, they\\\'re simply added to the page and given a \\\'Custom Style\\\' of \\\'Slideshow\\\'. The jQuery code in theme/examplesite/javascripts/custom.js then uses that selector to convert the images into a slideshow.</p>\n<div class=\\\"bpe_split_divider Right_Column\\\" alt=\\\"Right_Column\\\"></div>\n<div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/statue.jpg\\\" alt=\\\"Statue\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/bridge.jpg\\\" alt=\\\"Man walking over bridge\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/lapwing.jpg\\\" alt=\\\"Lapwing having a bath\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/flowers.jpg\\\" alt=\\\"Blossom in the sun\\\" />\n</div><div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<h2>This is another template position</h2>\n<p>And can have any content added to it.</p>\n<div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<h2>Email Newsletter</h2>\n<p>Your sites can use SetSeed\\\'s email newsletter system to collect subscribers to a mailing list.</p>\n<div class=\\\"SETSEEDcomponent ComponentNewsletter-default\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>NEWSLETTER SIGNUP FORM: ‘Default’ Group</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n<h2>Recent blog articles</h2>\n<p>These feed of recent blog articles is built using the Custom Feature system. It can be found in templates/custom/recent_articles.tpl - templates in that folder can be added anywhere to pages in the CMS.</p>\n<div class=\\\"SETSEEDcomponent ComponentCustom-recent_articles.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: recent articles</strong></div></div></div></div>\n', '', '', '1312017760', '26', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('19', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1 style=\\\"text-align: center;\\\">Welcome to an example website!</h1>\n<h2 style=\\\"text-align: center;\\\">You can use this site to test out how SetSeed works.</h2>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<h2>Template Positions</h2>\n<p>This template has several \\\'Template Positions\\\' defined in the theme (see file: themes/examplesite/split_classes.csv) . Template positions make it really easy for your clients to insert content in different sections of your template.</p>\n<h2>Slideshows</h2>\n<p>The column opposite contains an example of a slideshow. These are easy to create using jQuery and can use images added in the CMS. Edit this page to see how the images are added, they\\\'re simply added to the page and given a \\\'Custom Style\\\' of \\\'Slideshow\\\'. The jQuery code in theme/examplesite/javascripts/custom.js then uses that selector to convert the images into a slideshow.</p>\n<div class=\\\"bpe_split_divider Right_Column\\\" alt=\\\"Right_Column\\\"></div>\n<div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/statue.jpg\\\" alt=\\\"Statue\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/bridge.jpg\\\" alt=\\\"Man walking over bridge\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/lapwing.jpg\\\" alt=\\\"Lapwing having a bath\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/flowers.jpg\\\" alt=\\\"Blossom in the sun\\\" />\n</div><div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<h2>This is another template position</h2>\n<p>And can have any content added to it.</p>\n<div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<h2>Email Newsletter</h2>\n<p>Your sites can use SetSeed\\\'s email newsletter system to collect subscribers to a mailing list.</p>\n<div class=\\\"SETSEEDcomponent ComponentNewsletter-default\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>NEWSLETTER SIGNUP FORM: ‘Default’ Group</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n<h2>Recent blog articles</h2>\n<p>These feed of recent blog articles is built using the Custom Feature system. It can be found in templates/custom/recent_articles.tpl - templates in that folder can be added anywhere to pages in the CMS.</p>\n<div class=\\\"SETSEEDcomponent ComponentCustom-recent_articles.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: recent articles</strong></div></div></div></div>\n', '', '', '1312017914', '26', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('20', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1 style=\\\"text-align: left;\\\">Welcome to an example website!</h1>\n<h2 style=\\\"text-align: left;\\\">You can use this site to test out how SetSeed works.</h2>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<h2>Template Positions</h2>\n<p>This template has several \\\'Template Positions\\\' defined in the theme (see file: themes/examplesite/split_classes.csv) . Template positions make it really easy for your clients to insert content in different sections of your template.</p>\n<h2>Slideshows</h2>\n<p>The column opposite contains an example of a slideshow. These are easy to create using jQuery and can use images added in the CMS. Edit this page to see how the images are added, they\\\'re simply added to the page and given a \\\'Custom Style\\\' of \\\'Slideshow\\\'. The jQuery code in theme/examplesite/javascripts/custom.js then uses that selector to convert the images into a slideshow.</p>\n<div class=\\\"bpe_split_divider Right_Column\\\" alt=\\\"Right_Column\\\"></div>\n<div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/statue.jpg\\\" alt=\\\"Statue\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/bridge.jpg\\\" alt=\\\"Man walking over bridge\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/lapwing.jpg\\\" alt=\\\"Lapwing having a bath\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/flowers.jpg\\\" alt=\\\"Blossom in the sun\\\" />\n</div><div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<h2>This is another template position</h2>\n<p>And can have any content added to it.</p>\n<div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<h2>Email Newsletter</h2>\n<p>Your sites can use SetSeed\\\'s email newsletter system to collect subscribers to a mailing list.</p>\n<div class=\\\"SETSEEDcomponent ComponentNewsletter-default\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>NEWSLETTER SIGNUP FORM: ‘Default’ Group</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n<h2>Recent blog articles</h2>\n<p>These feed of recent blog articles is built using the Custom Feature system. It can be found in templates/custom/recent_articles.tpl - templates in that folder can be added anywhere to pages in the CMS.</p>\n<div class=\\\"SETSEEDcomponent ComponentCustom-recent_articles.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: recent articles</strong></div></div></div></div>\n', '', '', '1312017931', '26', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('21', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1 style=\\\"text-align: left;\\\">Welcome to an example website!</h1>\n<h2 style=\\\"text-align: left;\\\">You can use this site to test out how SetSeed works.</h2>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<h2>Template Positions</h2>\n<p>This template has several \\\'Template Positions\\\' defined in the theme (see file: themes/examplesite/split_classes.csv) . Template positions make it really easy for your clients to insert content in different sections of your template.</p>\n<h2>Slideshows</h2>\n<p>The column opposite contains an example of a slideshow. These are easy to create using jQuery and can use images added in the CMS. Edit this page to see how the images are added, they\\\'re simply added to the page and given a \\\'Custom Style\\\' of \\\'Slideshow\\\'. The jQuery code in theme/examplesite/javascripts/custom.js then uses that selector to convert the images into a slideshow.</p>\n<div class=\\\"bpe_split_divider Right_Column\\\" alt=\\\"Right_Column\\\"></div>\n<div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/statue.jpg\\\" alt=\\\"Statue\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/bridge.jpg\\\" alt=\\\"Man walking over bridge\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/lapwing.jpg\\\" alt=\\\"Lapwing having a bath\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/flowers.jpg\\\" alt=\\\"Blossom in the sun\\\" />\n</div><div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<h2>This is another template position</h2>\n<p>And can have any content added to it.</p>\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<h2>Email Newsletter</h2>\n<p>Your sites can use SetSeed\\\'s email newsletter system to collect subscribers to a mailing list.</p>\n<div class=\\\"SETSEEDcomponent ComponentNewsletter-default\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>NEWSLETTER SIGNUP FORM: ‘Default’ Group</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n<h2>Recent blog articles</h2>\n<p>These feed of recent blog articles is built using the Custom Feature system. It can be found in templates/custom/recent_articles.tpl - templates in that folder can be added anywhere to pages in the CMS.</p>\n<div class=\\\"SETSEEDcomponent ComponentCustom-recent_articles.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: recent articles</strong></div></div></div></div>\n', '', '', '1312017989', '26', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('26', '', '', '', '<h2>Snippet System</h2>\n\n\n\n\n<p>This content is created using the Snippets system. Content created in a Snippet can be added anywhere on any page, and used as many times as needed. For example, this content is used on several pages on this example site, but was created just once, in the Components &gt; Snippets menu.</p>\n\n\n\n\n', '', '', '1312023834', '32', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('25', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1 style=\\\"text-align: left;\\\">Welcome to an example website!</h1>\n<h2 style=\\\"text-align: left;\\\">You can use this site to test out how SetSeed works.</h2>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<h2>Template Positions</h2>\n<p>This template has several \\\'Template Positions\\\' defined in the theme (see file: themes/examplesite/split_classes.csv) . Template positions make it really easy for your clients to insert content in different sections of your template.</p>\n<h2>Slideshows</h2>\n<p>The column opposite contains an example of a slideshow. These are easy to create using jQuery and can use images added in the CMS. Edit this page to see how the images are added, they\\\'re simply added to the page and given a \\\'Custom Style\\\' of \\\'Slideshow\\\'. The jQuery code in theme/examplesite/javascripts/custom.js then uses that selector to convert the images into a slideshow.</p>\n<h2>Don\\\'t forget to try out  the \\\'Livechat\\\' system</h2>\n<p>Log in to the CMS by <a href=\\\"/admin/\\\">clicking here</a> and then click \\\'Settings\\\' &gt; \\\'Livechat\\\' &gt; \\\'Status\\\' &gt; \\\'Online\\\'. You\\\'ll then see the Livechat link show up in the header of this site.</p>\n<h2>Give the search tool a go</h2>\n<p>Try using the site-wide search system by searching for terms in the \\\'search\\\' box in the header of this site.</p>\n<div class=\\\"bpe_split_divider Right_Column\\\" alt=\\\"Right_Column\\\"></div>\n<div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/statue.jpg\\\" alt=\\\"Statue\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/bridge.jpg\\\" alt=\\\"Man walking over bridge\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/lapwing.jpg\\\" alt=\\\"Lapwing having a bath\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/flowers.jpg\\\" alt=\\\"Blossom in the sun\\\" />\n</div><div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentSnippet-32\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>SNIPPET: Footer text</strong></div></div></div></div>\n<div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<h2>Email Newsletter</h2>\n<p>Your sites can use SetSeed\\\'s email newsletter system to collect subscribers to a mailing list.</p>\n<div class=\\\"SETSEEDcomponent ComponentNewsletter-default\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>NEWSLETTER SIGNUP FORM: ‘Default’ Group</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n<h2>Recent blog articles</h2>\n<p>These feed of recent blog articles is built using the Custom Feature system. It can be found in templates/custom/recent_articles.tpl - templates in that folder can be added anywhere to pages in the CMS.</p>\n<div class=\\\"SETSEEDcomponent ComponentCustom-recent_articles.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: recent articles</strong></div></div></div></div>\n', '', '', '1312023778', '26', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('23', '', '', '', '<h2>Snippet System</h2>\n\n\n\n\n<p>This content is created using the Snippets system. Content created in a Snippet can be added anywhere on any page, and used as many times as needed. For example, this content is used on several pages on this example site, but was created just once, in the Components &gt; Snippets menu.</p>\n\n\n\n\n', '', '', '1312023839', '32', '', '', '', '', '1');
INSERT INTO `static_pages_versions` VALUES ('22', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1 style=\\\"text-align: left;\\\">Welcome to an example website!</h1>\n<h2 style=\\\"text-align: left;\\\">You can use this site to test out how SetSeed works.</h2>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<h2>Template Positions</h2>\n<p>This template has several \\\'Template Positions\\\' defined in the theme (see file: themes/examplesite/split_classes.csv) . Template positions make it really easy for your clients to insert content in different sections of your template.</p>\n<h2>Slideshows</h2>\n<p>The column opposite contains an example of a slideshow. These are easy to create using jQuery and can use images added in the CMS. Edit this page to see how the images are added, they\\\'re simply added to the page and given a \\\'Custom Style\\\' of \\\'Slideshow\\\'. The jQuery code in theme/examplesite/javascripts/custom.js then uses that selector to convert the images into a slideshow.</p>\n<h2>Don\\\'t forget to try out  the \\\'Livechat\\\' system</h2>\n<p>Log in to the CMS by <a href=\\\"/admin/\\\">clicking here</a> and then click \\\'Settings\\\' &gt; \\\'Livechat\\\' &gt; \\\'Status\\\' &gt; \\\'Online\\\'. You\\\'ll then see the Livechat link show up in the header of this site.</p>\n<h2>Give the search tool a go</h2>\n<p>Try using the site-wide search system by searching for terms in the \\\'search\\\' box in the header of this site.</p>\n<div class=\\\"bpe_split_divider Right_Column\\\" alt=\\\"Right_Column\\\"></div>\n<div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/statue.jpg\\\" alt=\\\"Statue\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/bridge.jpg\\\" alt=\\\"Man walking over bridge\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/lapwing.jpg\\\" alt=\\\"Lapwing having a bath\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/flowers.jpg\\\" alt=\\\"Blossom in the sun\\\" />\n</div><div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<h2>This is another template position</h2>\n<p>And can have any content added to it.</p>\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<h2>Email Newsletter</h2>\n<p>Your sites can use SetSeed\\\'s email newsletter system to collect subscribers to a mailing list.</p>\n<div class=\\\"SETSEEDcomponent ComponentNewsletter-default\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>NEWSLETTER SIGNUP FORM: ‘Default’ Group</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n<h2>Recent blog articles</h2>\n<p>These feed of recent blog articles is built using the Custom Feature system. It can be found in templates/custom/recent_articles.tpl - templates in that folder can be added anywhere to pages in the CMS.</p>\n<div class=\\\"SETSEEDcomponent ComponentCustom-recent_articles.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: recent articles</strong></div></div></div></div>\n', '', '', '1312018160', '26', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('24', '', '', '', '<h2>Snippet System</h2>\n\n\n<p>This content is created using the Snippets system. Content created in a Snippet can be added anywhere on any page, and used as many times as needed. We\\\'ve added this Snippet to the footer section on several pages on this example site.</p>\n\n\n', '', '', '1312023749', '32', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('27', '', '', '', '<div class=\\\"SETSEEDcomponent ComponentGallery-1\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>GALLERY: Example photo gallery</strong></div></div></div></div>\n', '', '', '1312024050', '27', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('28', '', '', '', '<div class=\\\"SETSEEDcomponent ComponentGallery-1\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>GALLERY: Example photo gallery</strong></div></div></div></div><div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Photo gallery</h1>\n<p>This is an example of a photo gallery created in SetSeed. Images can be quickly uploaded using the fast batch uploaded. Thumbnails are automatically created.</p>\n', '', '', '1312024124', '27', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('29', '', '', '', '<div class=\\\"SETSEEDcomponent ComponentGallery-1\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>GALLERY: Example photo gallery</strong></div></div></div></div><div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Photo gallery</h1>\n<p>This is an example of a photo gallery created in SetSeed. Images can be quickly uploaded using the fast batch uploaded. Thumbnails are automatically created.</p>\n<div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentSnippet-32\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>SNIPPET: Footer text</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n', '', '', '1312024153', '27', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('30', '', '', '', '<div class=\\\"SETSEEDcomponent ComponentGallery-1\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>GALLERY: Example photo gallery</strong></div></div></div></div><div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Photo gallery</h1>\n<p>This is an example of a photo gallery created in SetSeed. Images can be quickly uploaded using the fast batch uploaded. Thumbnails are automatically created.</p>\n<div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentSnippet-32\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>SNIPPET: Footer text</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n<div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<h2>Email Newsletter</h2>\n<p>Your sites can use SetSeed\\\'s email newsletter system to collect subscribers to a mailing list.</p>\n<div class=\\\"SETSEEDcomponent ComponentNewsletter-default\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>NEWSLETTER SIGNUP FORM: ‘Default’ Group</strong></div></div></div></div>\n', '', '', '1312024214', '27', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('31', '', '', '', '<div class=\\\"SETSEEDcomponent ComponentGallery-1\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>GALLERY: Example photo gallery</strong></div></div></div></div><div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Photo gallery</h1>\n<p>This is an example of a photo gallery created in SetSeed. Images can be quickly uploaded using the fast batch uploaded. Thumbnails are automatically created.</p>\n<div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentSnippet-32\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>SNIPPET: Footer text</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n<h2>Blog</h2>\n<div class=\\\"SETSEEDcomponent ComponentCustom-recent_articles.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: recent articles</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<h2>Email Newsletter</h2>\n<p>Your sites can use SetSeed\\\'s email newsletter system to collect subscribers to a mailing list.</p>\n<div class=\\\"SETSEEDcomponent ComponentNewsletter-default\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>NEWSLETTER SIGNUP FORM: ‘Default’ Group</strong></div></div></div></div>\n', '', '', '1312024231', '27', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('32', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<p>Contact form</p>\n<p>SetSeed lets your clients build amazing contact forms with unbelievable simplicity.</p>\n<div class=\\\"SETSEEDcomponent ComponentForm-1\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CONTACT FORM: Contact form</strong></div></div></div></div>\n', '', '', '1312024717', '28', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('33', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<p>Contact form</p>\n<p>SetSeed lets your clients build amazing contact forms with unbelievable simplicity.</p>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentForm-1\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CONTACT FORM: Contact form</strong></div></div></div></div>\n', '', '', '1312024730', '28', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('34', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Contact form</h1>\n<p>SetSeed lets your clients build amazing contact forms with unbelievable simplicity.</p>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentForm-1\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CONTACT FORM: Contact form</strong></div></div></div></div>\n', '', '', '1312024739', '28', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('35', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Contact form</h1>\n<p>SetSeed lets your clients build amazing contact forms with unbelievable simplicity. See the form below as an example. If you want to test it, you\\\'ll need to enter your email address as the recipient in the \\\'Components\\\' &gt; \\\'Contact forms\\\' &gt; \\\'Contact form\\\' &gt; \\\'Email recipient\\\' menu in the CMS.</p>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentForm-1\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CONTACT FORM: Contact form</strong></div></div></div></div>\n', '', '', '1312024795', '28', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('36', '', '', '', '<h2>Email newsletter</h2>\n\n\n\n<div class=\\\"SETSEEDcomponent ComponentNewsletter-default\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>NEWSLETTER SIGNUP FORM: ‘Default’ Group</strong></div></div></div></div>', '', '', '1312025078', '33', '', '', '', '', '1');
INSERT INTO `static_pages_versions` VALUES ('37', '', '', '', '<h2>Email newsletter</h2>\n\n\n\n<div class=\\\"SETSEEDcomponent ComponentNewsletter-default\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>NEWSLETTER SIGNUP FORM: ‘Default’ Group</strong></div></div></div></div>', '', '', '1312025073', '33', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('38', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Contact form</h1>\n<p>SetSeed lets your clients build amazing contact forms with unbelievable simplicity. See the form below as an example. If you want to test it, you\\\'ll need to enter your email address as the recipient in the \\\'Components\\\' &gt; \\\'Contact forms\\\' &gt; \\\'Contact form\\\' &gt; \\\'Email recipient\\\' menu in the CMS.</p>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentForm-1\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CONTACT FORM: Contact form</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentSnippet-32\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>SNIPPET: Footer text</strong></div></div></div></div>\n<div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentSnippet-33\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>SNIPPET: Footer Middle</strong></div></div></div></div>\n', '', '', '1312025092', '28', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('39', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Contact form</h1>\n<p>SetSeed lets your clients build amazing contact forms with unbelievable simplicity. See the form below as an example. If you want to test it, you\\\'ll need to enter your email address as the recipient in the \\\'Components\\\' &gt; \\\'Contact forms\\\' &gt; \\\'Contact form\\\' &gt; \\\'Email recipient\\\' menu in the CMS.</p>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentForm-1\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CONTACT FORM: Contact form</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentSnippet-32\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>SNIPPET: Footer text</strong></div></div></div></div>\n<div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentSnippet-33\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>SNIPPET: Footer Middle</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n<h2>Blog</h2>\n<div class=\\\"SETSEEDcomponent ComponentCustom-recent_articles.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: recent articles</strong></div></div></div></div>\n', '', '', '1312025108', '28', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('40', '', '', '', '<h1>Calendar</h1>\n<p>SetSeed has a powerful calendar system built in. You can added events in multiple categories and add calendars showing individual categories or all categories to your pages.</p>\n', '', '', '1312025235', '29', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('41', '', '', '', '<h1>Calendar</h1>\n<p>SetSeed has a powerful calendar system built in. You can added events in multiple categories and add calendars showing individual categories or all categories to your pages. Try adding an event in the <a href=\\\"/admin/\\\">CMS admin</a> by clicking \\\'Components\\\' &gt; \\\'Calendar\\\' &gt; (choose a day) &gt; \\\'Add new event for (selected day)\\\'.</p>\n<div class=\\\"SETSEEDcomponent ComponentCalendar\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>Calendar</strong></div></div></div></div>\n', '', '', '1312025302', '29', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('42', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Calendar</h1>\n<p>SetSeed has a powerful calendar system built in. You can added events in multiple categories and add calendars showing individual categories or all categories to your pages. Try adding an event in the <a href=\\\"/admin/\\\">CMS admin</a> by clicking \\\'Components\\\' &gt; \\\'Calendar\\\' &gt; (choose a day) &gt; \\\'Add new event for (selected day)\\\'.</p>\n<div class=\\\"SETSEEDcomponent ComponentCalendar\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>Calendar</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentSnippet-32\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>SNIPPET: Footer text</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentSnippet-33\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>SNIPPET: Footer Middle</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n<h2>News</h2>\n<div class=\\\"SETSEEDcomponent ComponentCustom-recent_articles.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: recent articles</strong></div></div></div></div>\n', '', '', '1312025347', '29', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('43', '', '', '', '<div class=\\\"SETSEEDcomponent ComponentBlog\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>Blog</strong></div></div></div></div>\n', '', '', '1312025379', '30', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('44', '', '', '', '<h1>Online store</h1>\n<p>SetSeed makes it really easy to sell products from anywhere on your site.</p>\n', '', '', '1312025597', '31', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('45', '', '', '', '<h1>Online store</h1>\n<p>SetSeed makes it really easy to sell products from anywhere on your site. Get an idea of some of the different kinds of products you can sell by browsing the different example pages in the left menu.</p>\n', '', '', '1312025622', '31', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('46', '', '', '', '<h1>Online store</h1>\n<p>SetSeed makes it really easy to sell products from anywhere on your site. Get an idea of some of the different kinds of products you can sell by browsing the different example pages in the left menu. The template for this site is built to automatically show a sub-menu for a page if it has sub-pages added to it.</p>\n', '', '', '1312025661', '31', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('47', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Photo Prints</h1>\n<p>SetSeed makes it really easy to sell photo prints over your website. Here we\\\'ve combined a product with an image gallery to serve as the list of choices for that product.</p>\n<div class=\\\"SETSEEDcomponent ComponentProduct-1\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>PRODUCT: Photo print</strong></div></div></div></div>\n', '', '', '1312025892', '34', '', '', '', '', '1');
INSERT INTO `static_pages_versions` VALUES ('48', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Use swatches to sell items like clothes</h1>\n<p>This templates shows how a product combined with an image gallery can be used to display \\\'swatch\\\' type options for a product - ideal for clothes or other products with different visual versions.</p>\n<div class=\\\"SETSEEDcomponent ComponentProduct-5\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>PRODUCT: Clothes</strong></div></div></div></div>\n', '', '', '1312027806', '35', '', '', '', '', '1');
INSERT INTO `static_pages_versions` VALUES ('49', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Simple products</h1>\n<h2>Simple products are the quickest, easiest way to sell products your website.</h2>\n<p>They are simply \\\'add to basket\\\' buttons which contain a price and name. Depending on how you setup your templates you can also display the number of items in stock, and even have the button automatically hide once the stock reaches \\\'0\\\'.</p>\n<div class=\\\"SETSEEDcomponent ComponentCustom-seperator.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: seperator</strong></div></div></div></div><h2>A simple product</h2>\n<div class=\\\"SETSEEDcomponent ComponentProduct-4\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>PRODUCT: A simple product</strong></div></div></div></div><div class=\\\"SETSEEDcomponent ComponentCustom-seperator.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: seperator</strong></div></div></div></div>\n', '', '', '1312027482', '36', '', '', '', '', '1');
INSERT INTO `static_pages_versions` VALUES ('50', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Customizable product</h1>\n<p>You can combine contact forms with products to receive complex order customisation, and even file uploads, with each order placed.</p>\n<div class=\\\"SETSEEDcomponent ComponentCustom-seperator.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: seperator</strong></div></div></div></div>\n<p>The following example uses a \\\'Veg box\\\' as an example to show how such customisation forms could be used.</p>\n<div class=\\\"SETSEEDcomponent ComponentProduct-3\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>PRODUCT: Veg Box</strong></div></div></div></div><div class=\\\"SETSEEDcomponent ComponentCustom-seperator.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: seperator</strong></div></div></div></div>\n', '', '', '1312027179', '37', '', '', '', '', '1');
INSERT INTO `static_pages_versions` VALUES ('51', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Product with options</h1>\n<p>SetSeed makes it easy to create a product that has various options with different prices.</p>\n<div class=\\\"SETSEEDcomponent ComponentCustom-seperator.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: seperator</strong></div></div></div></div><h2>Product with options</h2>\n<div class=\\\"SETSEEDcomponent ComponentProduct-2\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>PRODUCT: Product with options</strong></div></div></div></div><div class=\\\"SETSEEDcomponent ComponentCustom-seperator.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: seperator</strong></div></div></div></div>\n', '', '', '1312026960', '38', '', '', '', '', '1');
INSERT INTO `static_pages_versions` VALUES ('52', '', '', '', '<p>Photo Prints</p>\n<p>SetSeed makes it really easy to sell photo prints over your website. Here we\\\'ve combined a product with an image gallery to serve as the list of choices for that product.</p>\n<div class=\\\"SETSEEDcomponent ComponentProduct-1\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>PRODUCT: Photo print</strong></div></div></div></div>\n', '', '', '1312025832', '34', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('53', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Online store</h1>\n<p>SetSeed makes it really easy to sell products from anywhere on your site. Get an idea of some of the different kinds of products you can sell by browsing the different example pages in the left menu. The template for this site is built to automatically show a sub-menu for a page if it has sub-pages added to it.</p>\n', '', '', '1312025859', '31', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('55', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Shopping Basket</h1>\n<div class=\\\"SETSEEDcomponent ComponentShoppingBasket\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>Shopping Basket</strong></div></div></div></div>\n', '', '', '1312026102', '39', '', '', '', '', '1');
INSERT INTO `static_pages_versions` VALUES ('54', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Photo Prints</h1>\n<p>SetSeed makes it really easy to sell photo prints over your website. Here we\\\'ve combined a product with an image gallery to serve as the list of choices for that product.</p>\n<div class=\\\"SETSEEDcomponent ComponentProduct-1\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>PRODUCT: Photo print</strong></div></div></div></div>\n', '', '', '1312025887', '34', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('56', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Shopping Basket</h1>\n<div class=\\\"SETSEEDcomponent ComponentShoppingBasket\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>Shopping Basket</strong></div></div></div></div>\n', '', '', '1312026097', '39', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('57', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Product with options</h1>\n<p>SetSeed makes it easy to create a product that has various options with different prices.</p>\n<div class=\\\"SETSEEDcomponent ComponentCustom-seperator.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: seperator</strong></div></div></div></div><div class=\\\"SETSEEDcomponent ComponentProduct-2\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>PRODUCT: Product with options</strong></div></div></div></div><div class=\\\"SETSEEDcomponent ComponentCustom-seperator.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: seperator</strong></div></div></div></div>\n', '', '', '1312026934', '38', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('58', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Product with options</h1>\n<p>SetSeed makes it easy to create a product that has various options with different prices.</p>\n<div class=\\\"SETSEEDcomponent ComponentCustom-seperator.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: seperator</strong></div></div></div></div><h2>Product with options</h2>\n<div class=\\\"SETSEEDcomponent ComponentProduct-2\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>PRODUCT: Product with options</strong></div></div></div></div><div class=\\\"SETSEEDcomponent ComponentCustom-seperator.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: seperator</strong></div></div></div></div>\n', '', '', '1312026955', '38', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('59', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Customizable product</h1>\n<p>You can combine contact forms with products to receive complex order customisation, and even file uploads, with each order placed.</p>\n', '', '', '1312027124', '37', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('60', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Customizable product</h1>\n<p>You can combine contact forms with products to receive complex order customisation, and even file uploads, with each order placed.</p>\n<div class=\\\"SETSEEDcomponent ComponentProduct-3\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>PRODUCT: Veg Box</strong></div></div></div></div>\n', '', '', '1312027136', '37', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('61', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Customizable product</h1>\n<p>You can combine contact forms with products to receive complex order customisation, and even file uploads, with each order placed.</p>\n<div class=\\\"SETSEEDcomponent ComponentCustom-seperator.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: seperator</strong></div></div></div></div>\n<p>The following example uses a \\\'Veg box\\\' as an example to show how such customisation forms could be used.</p>\n<div class=\\\"SETSEEDcomponent ComponentProduct-3\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>PRODUCT: Veg Box</strong></div></div></div></div><div class=\\\"SETSEEDcomponent ComponentCustom-seperator.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: seperator</strong></div></div></div></div>\n', '', '', '1312027174', '37', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('62', '', '', '', '<h1>Simple products</h1>\n<h2>Simple products are the quickest, easiest way to sell products your website.</h2>\n<p>They are simply \\\'add to basket\\\' buttons which contain a price and name.</p>\n', '', '', '1312027239', '36', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('63', '', '', '', '<h1>Simple products</h1>\n<h2>Simple products are the quickest, easiest way to sell products your website.</h2>\n<p>They are simply \\\'add to basket\\\' buttons which contain a price and name.</p>\n<div class=\\\"SETSEEDcomponent ComponentProduct-4\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>PRODUCT: A simple product</strong></div></div></div></div>\n', '', '', '1312027307', '36', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('64', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Simple products</h1>\n<h2>Simple products are the quickest, easiest way to sell products your website.</h2>\n<p>They are simply \\\'add to basket\\\' buttons which contain a price and name. Depending on how you setup your templates you can also display the number of items in stock, and even have the button automatically hide once the stock reaches \\\'0\\\'.</p>\n<div class=\\\"SETSEEDcomponent ComponentProduct-4\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>PRODUCT: A simple product</strong></div></div></div></div>\n', '', '', '1312027408', '36', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('65', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Simple products</h1>\n<h2>Simple products are the quickest, easiest way to sell products your website.</h2>\n<p>They are simply \\\'add to basket\\\' buttons which contain a price and name. Depending on how you setup your templates you can also display the number of items in stock, and even have the button automatically hide once the stock reaches \\\'0\\\'.</p>\n<div class=\\\"SETSEEDcomponent ComponentCustom-seperator.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: seperator</strong></div></div></div></div><h2>A simple product</h2>\n<div class=\\\"SETSEEDcomponent ComponentProduct-4\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>PRODUCT: A simple product</strong></div></div></div></div><div class=\\\"SETSEEDcomponent ComponentCustom-seperator.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: seperator</strong></div></div></div></div>\n', '', '', '1312027477', '36', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('66', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1>Use swatches to sell items like clothes</h1>\n<p>This templates shows how a product combined with an image gallery can be used to display \\\'swatch\\\' type options for a product - ideal for clothes or other products with different visual versions.</p>\n<div class=\\\"SETSEEDcomponent ComponentProduct-5\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>PRODUCT: Clothes</strong></div></div></div></div>\n', '', '', '1312027801', '35', '', '', '', '', '0');
INSERT INTO `static_pages_versions` VALUES ('67', '', '', '', '<div class=\\\"bpe_split_divider Top_Section\\\" alt=\\\"Top_Section\\\"></div>\n<h1 style=\\\"text-align: left;\\\">Welcome to an example website!</h1>\n<h2 style=\\\"text-align: left;\\\">You can use this site to test out how SetSeed works. Visit <a href=\\\"/admin\\\">/admin</a> on your domain to start using the CMS.</h2>\n<div class=\\\"bpe_split_divider Left_Column\\\" alt=\\\"Left_Column\\\"></div>\n<h2>Template Positions</h2>\n<p>This template has several \\\'Template Positions\\\' defined in the theme (see file: themes/examplesite/split_classes.csv) . Template positions make it really easy for your clients to insert content in different sections of your template.</p>\n<h2>Slideshows</h2>\n<p>The column opposite contains an example of a slideshow. These are easy to create using jQuery and can use images added in the CMS. Edit this page to see how the images are added, they\\\'re simply added to the page and given a \\\'Custom Style\\\' of \\\'Slideshow\\\'. The jQuery code in theme/examplesite/javascripts/custom.js then uses that selector to convert the images into a slideshow.</p>\n<h2>Don\\\'t forget to try out  the \\\'Livechat\\\' system</h2>\n<p>Log in to the CMS by <a href=\\\"/admin/\\\">clicking here</a> and then click \\\'Settings\\\' &gt; \\\'Livechat\\\' &gt; \\\'Status\\\' &gt; \\\'Online\\\'. You\\\'ll then see the Livechat link show up in the header of this site.</p>\n<h2>Give the search tool a go</h2>\n<p>Try using the site-wide search system by searching for terms in the \\\'search\\\' box in the header of this site.</p>\n<div class=\\\"bpe_split_divider Right_Column\\\" alt=\\\"Right_Column\\\"></div>\n<div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/statue.jpg\\\" alt=\\\"Statue\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/bridge.jpg\\\" alt=\\\"Man walking over bridge\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/lapwing.jpg\\\" alt=\\\"Lapwing having a bath\\\" />\n</div><div class=\\\"bpe_image Slideshow\\\"><img src=\\\"/images/flowers.jpg\\\" alt=\\\"Blossom in the sun\\\" />\n</div><div class=\\\"bpe_split_divider Footer_Left\\\" alt=\\\"Footer_Left\\\"></div>\n<div class=\\\"SETSEEDcomponent ComponentSnippet-32\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>SNIPPET: Footer text</strong></div></div></div></div>\n<div class=\\\"bpe_split_divider Footer_Middle\\\" alt=\\\"Footer_Middle\\\"></div>\n<h2>Email Newsletter</h2>\n<p>Your sites can use SetSeed\\\'s email newsletter system to collect subscribers to a mailing list.</p>\n<div class=\\\"SETSEEDcomponent ComponentNewsletter-default\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>NEWSLETTER SIGNUP FORM: ‘Default’ Group</strong></div></div></div></div><div class=\\\"bpe_split_divider Footer_Right\\\" alt=\\\"Footer_Right\\\"></div>\n<h2>Recent blog articles</h2>\n<p>These feed of recent blog articles is built using the Custom Feature system. It can be found in templates/custom/recent_articles.tpl - templates in that folder can be added anywhere to pages in the CMS.</p>\n<div class=\\\"SETSEEDcomponent ComponentCustom-recent_articles.tpl\\\"><div><div><div><a class=\\\"componentDelete\\\"></a>COMPONENT <strong>CUSTOM COMPONENT: recent articles</strong></div></div></div></div>\n', '', '', '1312044206', '26', '', '', '', '', '0');



CREATE TABLE `stats` (
`statsid` int(11) NOT NULL AUTO_INCREMENT,
`browser` varchar(255) NOT NULL,
`ip` varchar(15) NOT NULL,
`date` int(11) NOT NULL,
`page_id` int(11) NOT NULL,
`referer` varchar(255) NOT NULL,
`country` varchar(255) NOT NULL,
`type` char(4) NOT NULL,
`browser_name` varchar(255) NOT NULL,
`os_name` varchar(255) NOT NULL,
`pagename` varchar(255) NOT NULL,
`url` text NOT NULL,
`engine` varchar(255) NOT NULL,
`timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
primary key(statsid)
);



