<h1>{$title}</h1>

<p class="blogDate">
	{foreach from=$authors item=aut} {* Loop through all authors in the system...*}
		{if $aut.id == $author} {* ... if the author matches we can use the author information. *}
			Written by <a href="#author">{$aut.name}</a> on 
		{/if}
	{/foreach}
	
	{$timestamp|date_format:"%A, %B %e, %Y at %I:%M%p"} <br/>
	
	{if $cats!=""}
		Filed in: 
		{foreach from=$cats item=cat} {* Loop through each category in the system... *}
			{foreach from=$in_categories item=in_cat} {* ... Then loop through all categories that this blog article is assigned to ...*}
				{if $in_cat == $cat.id}<a href="/{$contentUrl}/category/{$cat.url}/">{$cat.name}</a>{/if} {* ... if we have a match, we can use the data from the category. *}
			{/foreach}
		{/foreach}
		<br/>
	{/if}
	{if $tags}
		{foreach from=$tags item=tag key=key name=loop1}
			<a href="/{$contentUrl}/tag/{$tag.url}/">{$tag.name}{if !$smarty.foreach.loop1.last}, {/if}</a>
		{/foreach}<br/>
	{/if}
	<a href="#comments">Comments</a>: {$comments|@count} 
</p>

{$blog_content}

<div class="clear"><!-- --></div> {* Add a clear div just in case there is any floated overflowing content (images etc) in the post *}

{foreach from=$authors item=aut} {* Loop through all authors in the system...*}
	{if $aut.id == $author} {* ... if the author matches we can use the author information. *}
<a name="author"></a>
<p class="blogAuthor">
	<strong>About the author</strong><br/>
	{$aut.details}
</p>
	{/if}
{/foreach}

<a name="comments"></a>
<h2 class="leftColh2 notebook">Comments <a href="/rss/{$url}/" title="RSS feed for comments on this page"><img src="/graphics/rss.png" alt="RSS"/></a></h2>
<ol id="commentsList">
{include file=components/blog-comments.tpl}
</ol>

<div id="commentForm"> {* this is where the ajax comment form gets inserted on page load *}
	<noscript>
		<h1>Please enable Javascript to add a comment</h1>
		<p>We regret that this necessary to prevent spam messages.</p>
	</noscript>
</div>

<input type="hidden" name="blogId" value="{$blogId}" id="blogId"/> {* Don't delete this! *}
{* 
------------------------------------------------------------------------------------
VARIABLES AVAILABLE IN THIS TEMPLATE: 
------------------------------------------------------------------------------------

This file is included from blog.tpl so all variables available in that template will
be available in this template. Below are the ones like to be used in this file.

{$title} 			This is the title of the blog post

{$blog_content} 	This is the content of the blog post. This will include any 
					components that are added to the page. 

{$author} 			This is the ID of the article's author. To get other details of 
					the author, match inside a loop of all authors in the system.

{$authors} 			Array of all authors in the system. Keys in the array are: 
					('name', 'details')

{$in_categories} 	Array of IDs of the categories that the blog article is assigned 
					to. Match inside a loop of system categories to retrieve 
					information. 

{$cats} 			Array of all categories in the system. Keys are: 
					('id', 'url', 'name')

{$comments} 		Array of comments for the blog article. Used in this template 
					normally only to check how many comments are present. 

{$contenUrl} 		The name of the url of the blog page itself, use when 
					contructing links to blog pages. 
					e.g href="/{$contentUrl}/{$url}/"

{$url} 				Part of the url used in comment rss links, permalinks etc. 
					e.g href="/{$contentUrl}/{$url}/" or href ="/rss/{$url}/";

{$blogId} 			The ID of the blog page, used in the hidden input with id of 
					blogId which must be present on the page. 
					
{$tags}				Array of tags added for the article. Keys in the array are:
					('url','name')

------------------------------------------------------------------------------------
 
*}