<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="{$content.language}" lang="{$content.language}">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>

	<title>{$content.longtitle}</title>
	<meta name="keywords" content="{$content.keywords}"/>
	<meta name="description" content="{$content.description}"/>

	{if $content.blog=="yes" && $content.show_blog!="yes"}
	<link rel="alternate" type="application/rss+xml" title="RSS" href="{$server_name}/rss/"/>
	{/if}
	{if $content.show_blog=="yes"}
	<link rel="alternate" type="application/rss+xml" title="RSS" href="{$server_name}/rss/{$url}/"/>
	{/if}

	<link rel="stylesheet" href="/css/{$css}.css" type="text/css" media="screen" title="Default Style" charset="utf-8"/>
	{*
	IMPORTANT:
	The above css file is dynamically generated from the files in the theme's css folder, in the order specified in the theme's css/files.csv file. You can also references files individually if you want, just use the path: /css/yourfile.css - obviously keep the files in your site's theme's css folder though - don't put it in the actual /css/ folder in your document root! 
	*}
	
	<!--[if IE 6]>
		<link rel="stylesheet" href="/css/ie6.css" type="text/css" media="screen" title="Default Style" charset="utf-8"/>
	<![endif]-->
	<!--[if IE 7]>
		<link rel="stylesheet" href="/css/ie7.css" type="text/css" media="screen" title="Default Style" charset="utf-8"/>
	<![endif]-->

	<script src="/javascripts/{$js}.js" type="text/javascript" charset="utf-8"></script>
	{* 
	IMPORTANT:
	Do not delete the above javascript reference. It is necesary for many core CMS feature, form submission, loading caledars, loading blog comments, handling video and galleries, etc. The 'custom.js' file in a theme's 'javascripts' folder is automatically added to the above javascript file. 
	*}
</head>
<body class="page_{$content.url} {$content.parent} {$content.topParent} id_{$content.id}">
	<div id="wrapper">
		{include file=nav/nav.tpl}
		
		<form action="/actions/SearchForward/" method="post" id="searchForm">
			<input type="search" name="string" value="Search"/>
		</form>
		
		{if $loggedIn}<div id="loggedIn"><a href="/actions/Logout/">Logout</a></div>{/if}
		
		<p id="breadcrumb">{$breadcrumb}</p>
		
		{if $security}
			
			{include file=includes/login.tpl}
			
		{else}
			{$content.contentSplit.normal}

			{include file=includes/search-results.tpl}

		{/if}
		{include file=nav/side-bar-sub-menu.tpl} 
	

		<div id="livechat" style="display:none"><a href="/livechat/convo.php" id="startConvo">Livechat</a></div>
		{if $content.shop!="yes"}<div id="miniBasket"></div>{/if}
		{$sitewideContent.Footer}
	</div>
</body>
</html>{*
------------------------------------------------------------------------------------------
VARIABLES AVAILABLE IN THIS TEMPLATE: 
------------------------------------------------------------------------------------------

The following variables are the ones that are typically used in this file. There are other
variables/arrays available but they are documented in the templates where they are expected
to be used for organisation purposes, e.g templates/nav/main.tpl

{$content}			<-	Array of items used for page content. Keys are:
				
						url				<-	the url string for the page, without slashes
						title 			<-	the title of the page
						longtitle		<-	the long title entered in the meta settings
											of the CMS
						keywords		<-	keywords entered for this page, entered in 
											the meta settings of the cms
						description		<-	description for the page, entered in the meta
											settings of the CMS
						content			<-	this contains all content for the page and
											disregards the 'template position' sections
											definied in split_classes.csv - it is 
											prefered to use contentSplit.normal instead, 
											which will show all content that isn't 
											included in a template position section.
						contentSplit	<-	array of sections as definined by the
											split_classes.csv file. It will also include
											a key called 'normal' which shows all 
											content that isn't included in a template 
											position section.
						homepage		<-	if the page is site homepage this will be 
											"yes", otherwise NULL
						parent			<-	the id of the current page’s parent page, if
											the current page’s 'type' is "subLevel" or 
											"subSubLevel".
						language		<-	two letter language code assigned to the page
						id				<-	unique id of the page
						blog			<-	"yes" if blog is assigned to page, otherwise 
											NULL
						shop			<- 	"yes" if shopping basket is assigned to 
											page, otherwise NULL
						security		<- 	if page has security enabled and is visitor
											isn't logged in
						type			<-	type of page, either 'topLevel', 'subLevel',
											'subSubLevel' or 'nonLinker'
						topParent		<-	the id of the 'topLevel' page that current
											page belongs to, if it is a 'subSubLevel' 
											page
						recentArticles	<-	recent blog articles array, see blog.tpl 
											for keys
						blogUrl			<-	url of the page on the site that has a blog
											assigned to it
						orders			<-	array of orders in shopping basket, see 
											shoppingbasket.tpl for keys.
						totalItems		<-	total number of items in shopping basket
						totals			<-	total cost of all items in shopping basket	
						basket_link 	<-	url of shopping basket page
						currency_sym	<- 	symbol of currency in use for the site, 
											taken from the shop setting section of the
											CMS
						http_host		<-	value of the current website address
						last_updated	<-	UNIX timestamp of the last time the page was
											updated
						template		<-	the name of the template chosen to display 
											the page, will correspond to the name of 
											this file, without the file extension.


{$sitewideContent}	<-	array of items defined in sitewide_content.csv, editable in CMS
{$js}				<-	name of current javascript cache file, used to generate the js
						file path.
{$css}				<-	name of current css cache file, used to generate the css
						file path.
{$breadcrumb}		<-	string of links showing the parent page(s) of the current page
------------------------------------------------------------------------------------------
*}