<div id="blogContent">
	
	{if $show_blog=="yes"} {* if we are showing a single article, show the article template *}
		{include file=components/blog-article.tpl}
	{else} {* otherwise, show the blog listings *}
	
		{if $viewing_cat_name!="" && $viewing_date=="month"}
			<p id="status">You are currently browsing the category <strong>{$viewing_cat_name}</strong>, and viewing entries from <strong>{$month}, {$year}</strong> (<a href="/{$contentUrl}/">Show All</a>)</p>
		{elseif $viewing_cat_name!="" && $viewing_date=="day"}
			<p id="status">You are currently browsing the category <strong>{$viewing_cat_name}</strong>, and viewing entries from <strong>{$month} {$day}, {$year}</strong> (<a href="/{$contentUrl}/">Show All</a>)</p>
		{elseif $viewing_cat_name!=""}
			<p id="status">You are currently browsing the category: <strong>{$viewing_cat_name}</strong> (<a href="/{$contentUrl}/">Show All</a>)</p>
		{/if}
		{if $viewing_date=="month" && $viewing_cat_name==""}
			<p id="status">You are currently browsing all entries from <strong>{$month}, {$year}</strong> (<a href="/{$contentUrl}/">Show All</a>)</p>
		{/if}
		{if $viewing_date=="day" && $viewing_cat_name==""}
			<p id="status">You are currently browsing all entries from  <strong>{$month} {$day}, {$year}</strong> (<a href="/{$contentUrl}/">Show All</a>)</p>
		{/if}
		{if $searching_by!=""}
			<p id="status">You are currently searching all entries for  <strong>{$searching_by}</strong> (<a href="/{$contentUrl}/">Show All</a>)</p>
		{/if}
		{if $viewingtag}
			You are currently viewing all entires with the tag: {$viewingtag}
		{/if}
		{if $blogs}
		{foreach from=$blogs item=blog key=key name=loop}
			<h1><a href="/{$contentUrl}/{$blog.url}/">{$blog.title}</a></h1>
			<p class="blogDate">{$blog.timestamp|date_format:"%A, %B %e, %Y at %I:%M%p"}<br/>
				{if $blog.tags}Tags:
					{foreach from=$blog.tags item=tag key=key name=loop1}
						<a href="/{$contentUrl}/tag/{$tag.url}/">{$tag.name}{if !$smarty.foreach.loop1.last}, {/if}</a>
					{/foreach}
				{/if}<br/>
				{if $cats!=""}	Filed in: {foreach from=$cats item=cat}
						{foreach from=$blog.in_categories item=in_cat name=catsloop}
							{if $in_cat == $cat.id}<a href="/{$contentUrl}/category/{$cat.url}/">{$cat.name}</a>{if !$smarty.foreach.catsloop.last}, {/if}{/if}
						{/foreach}
					{/foreach}<br/> {/if}
				<a href="/{$contentUrl}/{$blog.url}/#comments">Read and add comments ({$blog.comments|@count})</a> </p>
			
			{$blog.content}
			
		<div class="clear"><!-- --></div>
		{/foreach}
		{if $totalPages != 1}
			{if $viewing_date}
				{if $viewing_date=="day"}
				<h5 id="paginate">{if $currentPage == 1}
					<span class="prevLink hidden">Previous Page</span>

					{else}
					<span class="prevLink"><a href="/{$contentUrl}/date/{$day}/{$month}/{$year}/{if $viewing_cat_name!=""}category/{$cat_url}/{/if}page/{math equation="x - y" x=$currentPage y=1}/"><span>Newer Entries</span></a></span>
					{/if} 
					{if $currentPage == $totalPages}
					<span class="nextLink hidden">Next Page</span>

					{else}
					<span class="nextLink"><a href="/{$contentUrl}/date/{$day}/{$month}/{$year}/{if $viewing_cat_name!=""}category/{$cat_url}/{/if}page/{math equation="x + y" x=$currentPage y=1}/"><span>Next Page</span></a></span> 

					{/if}
					Viewing page <strong>{$currentPage} of {$totalPages}</strong>
					
					</h5>
				{else}
					<h5 id="paginate">{if $currentPage == 1}
						<span class="prevLink hidden">Previous Page</span>
					{else}
					<span class="prevLink"><a href="/{$contentUrl}/date/{$month}/{$year}/{if $viewing_cat_name!=""}category/{$cat_url}/{/if}page/{math equation="x - y" x=$currentPage y=1}/"><span>Previous Page</span></a></span>
					{/if} 
					{if $currentPage == $totalPages}
					<span class="nextLink hidden">Next Page</span>
					{else}
					<span class="nextLink"><a href="/{$contentUrl}/date/{$month}/{$year}/{if $viewing_cat_name!=""}category/{$cat_url}/{/if}page/{math equation="x + y" x=$currentPage y=1}/"><span>Next Page</span></a></span> 

					{/if}
					Viewing page <strong>{$currentPage} of {$totalPages}</strong>
					
					</h5>
				{/if}
			{else}
				<h5 id="paginate">{if $currentPage == 1}
					<span class="prevLink hidden">Previous Page</span>

				{else}
				<span class="prevLink"><a href="/{$contentUrl}/{if $searching_by!=""}search/{$searching_by}/{/if}{if $viewingtag}tag/{$viewingtag}/{/if}{if $viewing_cat_name!=""}category/{$cat_url}/{/if}page/{math equation="x - y" x=$currentPage y=1}/"><span>Previous Page</span></a></span>
				{/if} 
				{if $currentPage == $totalPages}
				<span class="nextLink hidden">Next Page</span>
				{else}
				<span class="nextLink"><a href="/{$contentUrl}/{if $searching_by!=""}search/{$searching_by}/{/if}{if $viewingtag}tag/{$viewingtag}/{/if}{if $viewing_cat_name!=""}category/{$cat_url}/{/if}page/{math equation="x + y" x=$currentPage y=1}/"><span>Next Page</span></a></span> 

				{/if}
				Viewing page <strong>{$currentPage} of {$totalPages}</strong>
				
				</h5>
			{/if}
		{/if}
		{else}
		{if $searching_by!=""}
		<h1>There are no entries that match your search</h1>
		
		{else}
		<h1>There are no blog posts to display</h1>
		{/if}
		{/if} 
		
	{/if}
</div>
<div id="sidebar">
	<div id="blogCal"></div>
	<h2>Search</h2>
	<form action="/actions/SearchForward/" class="nest">
 		<input type="search" name="string" value="" id="string"/>
		<input type="hidden" name="url" value="{$contentUrl}" id="url"/>
	</form>
	<h2>Categories</h2>
	<ul class="nest">
		<li{if $viewing_cat_name=="" && $show_blog!="yes" && $viewing_date=="" && $searching_by==""} class="current"{/if}><a href="{if $content.homepage=="yes"}/{else}/{$contentUrl}/{/if}">Show All</a></li>
	{foreach from=$cats item=cat key=key name=loop1}
		<li{if $viewing_cat_name==$cat.name} class="current"{/if}><a href="/{$contentUrl}/category/{$cat.url}/">{$cat.name}</a></li>
	{/foreach}</ul>
	<h2>Recent Articles</h2>
	<ul class="nest">{foreach from=$recentArticles item=recArt key=key name=loop1}
		<li{if $title==$recArt.name} class="current"{/if}><a href="/{$contentUrl}/{$recArt.url}/">{$recArt.name}</a></li>
	{/foreach}</ul>
	<h2>Tag Cloud</h2>
	<ul id="tagCloud">
	{foreach from=$tagCloud item=item}
		<li class="tag-{$item.ratio}"><a href="/{$contentUrl}/tag/{$item.url}/">{$item.name}</a></li>
	{/foreach}
	</ul>
</div>
{* 
------------------------------------------------------------------------------------
VARIABLES AVAILABLE IN THIS TEMPLATE: 
------------------------------------------------------------------------------------

This is the template that is used to show content where the 'blog' component is
added to a page. 


{$show_blog} 			Will be either "yes" or NULL. If "yes", then this template
						is being used to display an individual blog article, if NULL
						then it will be used to display all entries, based on 
						category, tag, search, date, page etc. 
						
{$viewing_cat_name}		If viewing a blog category this variable with contain the
						name of the category.
						
{$viewing_date}			If viewing blog entries from a given date, this will be 
						either "day" or "month" - depending on if a single day is
						being viewed, or a whole month.
						
{$month}				If viewing by date, this will contain the month being viewed

{$year}					If viewing by date, this will contain the year being viewed

{$day}					If viewing by date and viewing a single day, this will
						contain the name of the day being viewed
						
{$contenUrl} 			The name of the url of the blog page itself, use when 
						contructing links to blog pages. 
						e.g href="/{$contentUrl}/{$url}/"
						
{$searching_by}			If viewing a blog search result this will contain the 
						search string.
						
{$viewingtag}			If viewing results for a certain tag, this will contain
						the tag name.
						
{$blogs}				An array containing the blog items to list in the results.
						Keys are:
						id					<- 	The id of the blog entry
						in_categories		<- 	Array of category id's that the entry
												is in.
						in_categories_full	<-	Array of arrays contains full 
												details of the categories this entry 
												is in. Keys are: ('name','url','id')
						tags				<-	Array of arrays containing details 
												about the tags added to the entry. 
												Keys are: ('name','url')
						title				<-	The title of the blog entry
						summary				<-	Summary/description for the entry,
												added in the meta information 
												section
						keywords			<-	Keywords for the entry, add in the
												meta information section
						content				<-	The content of the blog entry
						timestamp			<-	UNIX timestamp for the entry
						author				<-	The id of the author of the article
						url					<- 	The url formatted version of the 
												article. Used to construct the 
												full url.
						comments			<-	Array of comments for the blog entry.
												Keys are: ('id','author','timestamp',
												'website','belongs_to_blog',
												'content')
						picUrl				<-	Url of the first image in the entry,
												if present.
												
{$tagCloud}				Array of tags for a tag cloud. Key=name, Item=tag weight.
 						Tag weight is listed as a percentage, rounded to nearest 10.


------------------------------------------------------------------------------------
*}