<?php
/*******************************************************************************************

	SETSEED™
	
	© Copyright 2006-2011 Ben Vallack, T/A Phototropic. Redistribution of
	this code without permission from the copyright holder is strictly forbidden.
	
	More information at http://setseed.com

	SetSeed Installer 
	Version 2.3.13
 
*******************************************************************************************/
error_reporting(E_ALL);
ini_set('display_errors', '0');
$errors = array();
$allok = true;
$sapi_type = php_sapi_name();
if (!isset($_REQUEST['step2']) && isset($_REQUEST['step3']) && isset($_REQUEST['cont'])) {
	if ($_REQUEST['rootname']=="") {
		header("Location: ?step3&blank&username=".$_REQUEST['username']."&password=".$_REQUEST['password']."&host=".$_REQUEST['host']."");
	}
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>

	<title>SetSeed Installer</title>
	<style type="text/css" media="screen">
		* { margin: 0; padding: 0; text-decoration: none; font-size: 100%; }
		code, kbd, samp, pre, tt, var, textarea, input, select, isindex { font: inherit; font-size: 1em; }
		dfn, cite, var, address { font-style: normal; }
		th, b, h1, h2, h3, h4, h5, h6 { font-weight: normal; }
		a, img, a img, iframe, form, fieldset, abbr, acronym, object, applet { border: none; }
		table { border-collapse: collapse; border-spacing: 0; }
		caption, th, td, center { text-align: left; vertical-align: top; }
		body { line-height: 1em; background: white; }
		q { quotes: "" ""; }
		ul, ol, dir, menu { list-style: none; }
		a { color: inherit; }

		.clearfix:after {
		    content: "."; 
		    display: block; 
		    height: 0; 
		    clear: both; 
		    visibility: hidden;
		}

		.clearfix {display: inline-block;}

		/* Hides from IE-mac \*/
		* html .clearfix {height: 1%;}
		.clearfix {display: block;}
		/* End hide from IE-mac */
		.clear {clear:both;}
		body {
			background:#2D2D2E;
			width:900px;
			margin:0 auto;
			padding:20px 0 70px;
			font-family:arial,sans-serif;
			color:#fff;
		}
		h1 {
			font-size:24px;
			margin:40px 0 15px;
			border-top:1px solid #c7c7c7;
			padding-top:20px;
			font-weight:bold;
		}
		h2 {
			font-size:18px;
			margin:40px 0 10px;
			border-top:1px dashed #999;
			padding-top:10px;
			font-weight:bold;
			line-height:20px;
		}
		h3 {
			font-size:14px;
			margin:20px 0 10px;
			padding-top:10px;
			font-weight:normal;
			text-transform:uppercase;
		}
		p {
			color:#999;
			margin:10px 0;
			line-height:20px;
			font-size:14px;
		}
		p a {
			color:#fff;
			text-decoration:underline;
		}
		p strong {
			color:#fff
		}
		p.warning {
			padding:7px 5px 7px 40px;
			color:#fff;
			background:#42382F url("installer_assets/warning.png") no-repeat 12px 50%;
			border-radius:4px;-webkit-border-radius:4px;-moz-border-radius:4px;
		}
		p.ok {
			color:#fff;
			padding:7px 5px 7px 40px;
			background:#2F422A url("installer_assets/tick.png") no-repeat 4px 50%;
			border-radius:4px;-webkit-border-radius:4px;-moz-border-radius:4px;
		}
		p.error {
			color:#fff;
			padding:7px 5px 7px 40px;
			background:#421F1D url("installer_assets/error.png") no-repeat 5px 50%;
			border-radius:4px;-webkit-border-radius:4px;-moz-border-radius:4px;
		}
		pre {
			font-size:11px;
			padding:10px 20px;
			background:#444;
			border-radius:4px;-webkit-border-radius:4px;-moz-border-radius:4px;
			overflow:auto;
			font-family:Courier, monospace;
		}
		.inputSection {
			float:left;
			width:202px;
			padding-right:30px;
			border-bottom:1px solid #444;
			border-top:1px solid #444;
			padding-bottom:20px;
			padding-top:10px;
		}
		.inputSection.last {
			padding-right:0;
		}
		input {
			width:190px;
			padding:2px 5px;
			border:none;
			border-radius:4px;-webkit-border-radius:4px;-moz-border-radius:4px;
		}
		label {
			margin:4px 0;
			display:block;
			font-size:12px;
		}
		#send {
			margin:20px 0;
			padding:0;
			width:auto;
			float:right;
		}
		p.error a {
			float:right;
			border-radius:20px;-webkit-border-radius:20px;-moz-border-radius:20px;
			color:#000;
			padding:2px 10px;
			margin:2px 5px 0 0;
			line-height:12px;
			background:#fff;
			font-size:11px;
			text-decoration:none;
		}
		p.error a:hover {
			background:#D60000;
			color:#fff;
		}
	</style>
	<link rel="icon" href="installer_assets/favicon.ico" type="image/x-icon"/>
	<link rel="shortcut icon" href="installer_assets/favicon.ico" type="image/x-icon"/>
</head>
<body>
	<img src="installer_assets/logo3.png" alt="SetSeed"/>
	
	<?php
	
	if (!isset($_REQUEST['step2']) && !isset($_REQUEST['step3']) && !isset($_REQUEST['htaccesscheck'])) {

		if ($_SERVER['REQUEST_URI']!="/install/") {
			?>
			<p class="error">
				<strong>Error:</strong> Please make sure you have uploaded the application to the top level of your web server. SetSeed cannot be run from a sub-folder. 
			</p>
			<?php
		} else {
			if (
				is_writable("../app/cache") 
				&& is_writable("../admin/javascripts/js_archives") 
				&& is_writable("../admin/javascripts/js_archives2") 
				&& is_writable("../admin/css/css_archives") 
				&& is_writable("../sites") 
				&& is_writable("../app/configuration.php") 
			) {
				
			} else {
				?>
					<p class="error">
						<strong>Error:</strong> Please change permissions on the following folders to be server-writable. You can do this by selecting them in your FTP client and changing their permissions to 777. <br/><br/>
						<strong>app/cache<br/>
						admin/javascripts/js_archives<br/>
						admin/javascripts/js_archives2<br/>
						admin/css/css_archives<br/>
						sites<br/>
						app/configuration.php</strong>
					</p>
				<?php
				die();
			}
		?>
		<h1>Welcome to the SetSeed Installer</h1>
		<p>This installer will check your server for compatibility, help you make any necessary changes to your server's configuration and guide you through the installation process. </p>
			<h2>Step 1 of 3: Server Setup</h2>
			<h3>Installer Setup</h3>
			
			<?php
			$phpclear=true;
			if (is_writable("../install")) {
				?>
				
				<p class="ok">Installation folder is server-writable</p>
				<?php
			} else {
				$phpclear=false;
				?>
				
				<p class="error">Installation folder is not server-writable</p>
				<p>Please change the permissions for the 'install' folder to be server writable and then refresh this page.</p>
				<?php
				die();
			}
			if (substr($sapi_type, 0, 3) != 'cgi' && function_exists('apache_get_modules')) {
				if  (in_array  ('mod_rewrite', apache_get_modules())) {
					$htaccess = "RewriteEngine on
RewriteCond %{QUERY_STRING} ^htaccesscheck$
RewriteRule ^$ ?itworks=yes&htaccesscheck
RewriteCond %{QUERY_STRING} ^htaccesscheck&existing$
RewriteRule ^$ ?itworks=yes&htaccesscheck&existing
					";
					$myFile = ".htaccess";
					$fh = fopen($myFile, 'w') or die("<p class=\"error\">Test .htaccess file has not been created</p>");
					fwrite($fh, $htaccess);
					fclose($fh);
					if (file_exists(".htaccess")) {
						?>
						<p class="ok">Test .htaccess file successfully created</p>
						<?php
					}
				}
			} else {
				$htaccess = "RewriteEngine on
RewriteCond %{QUERY_STRING} ^htaccesscheck$
RewriteRule ^$ ?itworks=yes&htaccesscheck
RewriteCond %{QUERY_STRING} ^htaccesscheck&existing$
RewriteRule ^$ ?itworks=yes&htaccesscheck&existing

";
				$myFile = ".htaccess";
				$fh = fopen($myFile, 'w') or die("<p class=\"error\">Test .htaccess file has not been created</p>");
				fwrite($fh, $htaccess);
				fclose($fh);
				if (file_exists(".htaccess")) {
					?>
					<p class="ok">Test .htaccess file successfully created</p>
					<?php
				}
			}
		
			?>

			<h3>PHP Configuration</h3>
			<?php
			$phperrors = array();
			$phpok = array();
			$version = explode(".",phpversion());
		
			if ($version[0] == "5" && $version[1] >= "2") {
				$phpok[] = "Your version of PHP ($version[0].$version[1]) exceeds or meets the requirement of 5.2";
			} else {
				$phperrors[] = "The PHP version needs to be 5.2 or higher.";
				$phpclear = false;
			}
			if  (!in_array  ('curl', get_loaded_extensions())) {
				$phperrors[] = "The PHP extension 'cURL' needs to be enabled/installed. <a href='http://setseed.com/kb/server-setup' target='_blank'>Learn More</a>";
				$phpclear = false;
			} else {
				$phpok[] = "The PHP extension 'cURL' is enabled.";
			}
			if  (!in_array  ('mysql', get_loaded_extensions())) {
				$phperrors[] = "The PHP extension 'mysql' needs to be enabled/installed. <a href='http://setseed.com/kb/server-setup' target='_blank'>Learn More</a>";
				$phpclear = false;
			} else {
				$phpok[] = "The PHP extension 'mysql' is installed.";
			}
			if  (!in_array  ('gd', get_loaded_extensions())) {
				$phperrors[] = "The PHP extension 'gd' needs to be enabled/installed. <a href='http://setseed.com/kb/server-setup' target='_blank'>Learn More</a>";
				$phpclear = false;
			} else {
				$phpok[] =  "The PHP extension 'gd' is enabled.";
			}
			if  (!in_array  ('ionCube Loader', get_loaded_extensions())) {
				$phperrors[] = "The PHP extension 'ionCube Loader' needs to be enabled/installed. <a href='http://setseed.com/kb/server-setup' target='_blank'>Learn More</a>";
				$phpclear = false;
			} else {
				$phpok[] = "The PHP extension 'ionCube Loader' is installed.";
			}
			
		
			
			if (!function_exists('mb_detect_encoding')) {
				$phperrors[] = "The PHP extension 'mbstring' is not installed.";
				$phpclear = false;
			} else {
				$phpok[] = "The PHP extension 'mbstring' is installed.";
			}
			$to = "serverchecker@phototropic.co.uk";// this is not an active email account, please don't use it for correspondence!
			if (!mail($to, "", "", "From: $to")) {
				$phpclear = false;
				$phperrors[] = "Your PHP installation cannot send email using the mail() function. <a href='http://setseed.com/kb/server-setup' target='_blank'>Learn More</a>";
			} else {
				$phpok[] =  "PHP can send mail using the mail() function.";
			}
			if ($phpclear===true) {
				?>
				<p>Success! PHP is correctly configured to run SetSeed</p>
				<?php
				foreach ($phpok as $ok) {
					?>
					<p class="ok"><?php echo $ok; ?></p>
					<?php
				}
			} else {
				?>
				<p>Please address the following issues with your PHP installation.</p>
				<?php
				foreach ($phperrors as $error) {
					?>
					<p class="error"><?php echo $error; ?></p>
					<?php
				}
				?>
				<p>Your server meets the following PHP requirements.</p>
				<?php
				foreach ($phpok as $ok) {
					?>
					<p class="ok"><?php echo $ok; ?></p>
					<?php
				}
			}
			
			?>

			<h3>Apache modules</h3>
			<?php
			$apacheModsOk=true;
			if (substr($sapi_type, 0, 3) == 'cgi' || !function_exists('apache_get_modules')) {
			?>
			<p>Because you are running PHP as a CGI this installer cannot automatically determine if the following Apache modules are enabled. Please manually confirm that they are enabled in your server's configuration before continuing with the installation.<br/> <strong>Important: If you click 'Continue' below without confirming that the 'mod_rewrite' module is enabled, you will see a blank error page.</strong></p></p>
			<p class="warning">mod_rewrite</p>
			<p class="warning">mod_deflate</p>
			<p class="warning">mod_setenvif</p>
			<p class="warning">core</p>
			<p class="warning">http_core</p>
			<p class="warning">mod_headers</p>
			<p class="warning">mod_expires</p>
			<?php
			
			} else {
				$apacheok = array();
				$apacheerrors = array();
				if  (!in_array  ('mod_rewrite', apache_get_modules())) {
					$apacheerrors[] = "The Apache module 'mod_rewrite' is <strong>not</strong> enabled on this server.";
					$apacheModsOk = false;
				} else {
					$apacheok[] = "The Apache module 'mod_rewrite' is enabled on this server.";
				}
				if  (!in_array  ('mod_deflate', apache_get_modules())) {
					$apacheerrors[] = "The Apache module 'mod_deflate' is <strong>not</strong> enabled on this server.";
					$apacheModsOk = false;
				} else {
					$apacheok[] = "The Apache module 'mod_deflate' is enabled on this server.";
				}
				if  (!in_array  ('mod_setenvif', apache_get_modules())) {
					$apacheerrors[] = "The Apache module 'mod_setenvif' is <strong>not</strong> enabled on this server.";
					$apacheModsOk = false;
				} else {
					$apacheok[] = "The Apache module 'mod_setenvif' is enabled on this server.";
				}
				if  (!in_array  ('core', apache_get_modules())) {
					$apacheerrors[] = "The Apache module 'core' is <strong>not</strong> enabled on this server.";
					$apacheModsOk = false;
				} else {
					$apacheok[] = "The Apache module 'core' is enabled on this server.";
				}
				if  (!in_array  ('http_core', apache_get_modules())) {
					$apacheerrors[] = "The Apache module 'http_core' is <strong>not</strong> enabled on this server.";
					$apacheModsOk = false;
				} else {
					$apacheok[] = "The Apache module 'http_core' is enabled on this server.";
				}
				if  (!in_array  ('mod_headers', apache_get_modules())) {
					$apacheerrors[] = "The Apache module 'mod_headers' is <strong>not</strong> enabled on this server.";
					$apacheModsOk = false;
				} else {
					$apacheok[] = "The Apache module 'mod_headers' is enabled on this server.";
				}
				if  (!in_array  ('mod_expires', apache_get_modules())) {
					$apacheerrors[] = "The Apache module 'mod_expires' is <strong>not</strong> enabled on this server.";
					$apacheModsOk = false;
				} else {
					$apacheok[] = "The Apache module 'mod_expires' is enabled on this server.";
				}

				if ($apacheModsOk===true) {
					?>
					<p>Success! Your server has all the required Apache modules enabled.</p>
					<?php
					foreach ($apacheok as $ok) {
						?>
						<p class="ok"><?php echo $ok; ?></p>
						<?php
					}
				} else {
					?>
					<p>Please enable the Apache modules listed below that are not currently enabled. The way in which you can do this will depend on your flavour of Linux and the level of access you have. Contact your host tech support if you are using a shared server.
					</p>
					<p><strong>Debian/Ubuntu</strong><br/>Run the following command over SSH to enable a mod (once for each module, replacing 'rewrite' in the example with the name of module you want to enable):</p>			
					<pre>a2enmod rewrite</pre>
					<p><strong>RedHat/CentOS</strong><br/>
						You need to edit your Apache configuration file to to enable the required modules. This is normally found here: /etc/httpd/conf/httpd.conf. To enable a module look for a collection of lines starting with 'LoadModule'. Some of these lines with be 'commented out' by starting with the # symbol. This means those modules will be disabled. To enable a module remove the # from the beginning of that module's line. 
					</p>
					<?php
					foreach ($apacheerrors as $error) {
						?>
						<p class="error"><?php echo $error; ?></p>
						<?php
					}
					?>
					<p>Your Apache configuration meets the following requirements.</p>
					<?php
					foreach ($apacheok as $ok) {
						?>
						<p class="ok"><?php echo $ok; ?></p>
						<?php
					}
				}
				

			}
			$warningsclear = true;
			$fp = fsockopen("mail.setseed.com", 25, $errno, $errstr, 30);
			if (!$fp) {
			    $warnings[] = "Outgoing connections to SMTP servers using port 25 are blocked. You will not be able to configure SetSeed to send emails via SMTP. Emails will be sent using PHP's built in mail function instead.";
				$warningsclear = false;
			} else {
				fclose($fp);
			}
			if ($warningsclear===false) {
				?>
				<h3>Warnings</h3>
				<?php
					foreach ($warnings as $warning) {
						?>
						<p class="warning"><?php echo $warning; ?></p>
						
						<?php
					}
				?>
				<?php
			}
			if ($phpclear===true&&$apacheModsOk===true) {
				if (file_exists("../.htaccess")) {
					?>
					<p style="margin-top:40px;float:right"><a href="?htaccesscheck&existing"><img src="installer_assets/continue.png" alt="Continue"/></a></p>
					<h2>Click continue to complete Step 1</h2>	
					<?php					
				} else {
					?>
					<p style="margin-top:40px;float:right"><a href="?htaccesscheck"><img src="installer_assets/continue.png" alt="Continue"/></a></p>
					<h2>Click continue to complete Step 1</h2>
					<?php
				}
			}
		}
	}
	if (isset($_REQUEST['htaccesscheck']) && !isset($_REQUEST['step2']) && !isset($_REQUEST['step3']) && !isset($_REQUEST['cont'])) {
		?>
		<h2>Step 1 of 3: Server Setup</h2>
		<?php
		if (isset($_REQUEST['itworks'])) {
			?>
			<?php
			if (file_exists("../.htaccess")&&!isset($_REQUEST['existing'])) {
				?>
				<h3>Success</h3>
				<p class="ok">Primary .htaccess file successfully enabled</p>
				
				<p style="margin-top:40px;float:right"><a href="?step2"><img src="installer_assets/continue.png" alt="Continue"/></a></p>
				<h2>Please continue to Step 2</h2>
				<?php
			} else {
				?>
				<h3>Apache configuration</h3>
				
				<p class="ok">.htaccess check successful - your server allows .htaccess files to configure Apache</p>
				<?php
				if (isset($_REQUEST['inplace'])) {
					?>
					asd
					<?php
				}
				if (isset($_REQUEST['existing'])) {
					?>
					<h2>Rename primary .htaccess file</h2>
					<p>You can now enable the main .htaccess file for your SetSeed installation. This is the file you uploaded called 'rename-during-install.htaccess' - however, you already have an .htaccess file in your server. It is probbaly best to add the contents of rename-during-install.htaccess to the end of your existing .htaccess file rather than replacing it. However, you should be aware of .htaccess rules and potential problems resulting from doing this. If in doubt, try backing up and removing the existing .htaccess file and running the installer agin from the start.</p>
					<p>If you have added SetSeed .htaccess rules or replaced your existing file with the SetSeed file you can continue. </p>
					<p style="margin-top:40px;float:right"><a href="?step2"><img src="installer_assets/continue.png" alt="Continue"/></a></p>
					<h2>Please continue to Step 2</h2>
					<?php
				} else {
					?>
					<h2>Rename primary .htaccess file</h2>
					<p>You can now enable the main .htaccess file for your SetSeed installation. This is the file you uploaded called 'rename-during-install.htaccess' - please rename it so that it is called: </p>
					<pre>.htaccess</pre>
					<p>Be sure to leave the full stop / period at the begining of the file. Once you've done this, reload this page to continue. If you see a server error after reloading the page please rename the .htaccess file back and start the installer again, making sure that all required Apache modules are available and enabled.</p>
					<?php
				}
				
				?>
				
				<?php
			}
			?>
			<?php
		} else {
			$apacheModsOk=false;
			?>
			<p class="error">.htaccess file failed - your server doesn't allow Apache configuration via .htaccess files</p>
			<p><strong>If you are on a shared server or don't have access to your apache configuration file please contact your host and ask them to make this change for you.</strong></p>
			<p>Please edit your server's VirtualHost configuration file to change the 'AllowOverride' Apache directive to 'All' - it is probably set to 'None' at the moment. For example you will probably have a line in your config file as follows: </p>
			<pre>AllowOverride None</pre>
			<p>This needs to be changed to:</p>
			<pre>AllowOverride All</pre>
			<p>Once you have made this change, restart Apache and then reload this page.</p>

			<?php
		}
	}
	if (isset($_REQUEST['step2']) && !isset($_REQUEST['step3'])) {
		?>
		<h2>Step 2 of 3: MySQL configuration and table setup</h2>
		<?php
		$mysqlok = true;
		if (isset($_REQUEST['mysql'])) {
			?>
			<div class="clear"><!-- --></div>
			<?php
			$mysqlerrors = array();
			$mysqloks = array();
			$link = mysql_connect($_REQUEST['host'], $_REQUEST['username'], $_REQUEST['password']);
		
			if (!$link) {
			  	$mysqlerror = mysql_error();
				$mysqlok = false;
				$mysqlerrors[] = "Could not connect to mySQL. Please check the username and password values in configuration.php - mySQL generated the following error: \"$mysqlerror\"";
			} else {
				$t=mysql_query("select version() as ve");
				$r=mysql_fetch_object($t);
				$version = explode(".",$r->ve);
				$mysql_version_ok = false;
				if ($version[0]>="5") {
					if ($version[1]>="0") {
						$mysql_version_ok = true;
					}
				}
				if ($mysql_version_ok == false) {
					$mysqlok = false;
					$mysqlerrors[] = "The mySQL version needs to be 5.0 or higher. You are running version: ".$r->ve;
				} else {
					$mysqloks[] = "Connected to MySQL successfully.";
					$mysqloks[] = "MySQL version ".$r->ve." meets or exceeds the required 5.0";
				}
				$result = mysql_query("SHOW GRANTS FOR CURRENT_USER;",$link);
				$found=false;
				$replaceddb = str_replace("_","\_",$_REQUEST['database']);
				$replaceddb = str_replace("%","\%",$replaceddb);
				while ($row = mysql_fetch_array($result)) {	
					$smallcheck = false;			
					if (
						strpos($row[0],"ALTER") 
						&& strpos($row[0],"DROP") 
						&& strpos($row[0],"CREATE") 
						&& strpos($row[0],"SELECT")
						&& strpos($row[0],"INSERT") 
						&& strpos($row[0],"UPDATE") 
					) {
						$smallcheck=true;

					} else if (strpos($row[0],"ALL PRIVILEGES")) {
						$smallcheck=true;						
					}
					if ($smallcheck===true) {
						if (strpos($row[0],"*.*") || strpos($row[0],$replaceddb)) {
							if ($found===false) {
								$mysqloks[] = "The MySQL user has the required privileges.";
								$found=true;
							}
							
						}
					}
				}
				if ($found===false) {
					$mysqlok = false;
					$mysqlerrors[] = "The mySQL user doesn't have the required privileges. MySQL reported the following: ".$result[0];
				}
				if ($mysqlok===true) {
					$db_selected = mysql_select_db(mysql_real_escape_string($_REQUEST['database']), $link);
					$continue=true;
					if (!$db_selected) {
						$mysqlerrors[] = "Database ".$_REQUEST['database']." doesn't exist - trying to create it.";
						
						$result = mysql_query("CREATE DATABASE ".mysql_real_escape_string($_REQUEST['database']).";");
						if (!$result) {
							$mysqlok = false;
							$mysqlerror = mysql_error();
							$mysqlerrors[] = "Couldn't create database ".$_REQUEST['database']." MySQL gave the following error: $mysqlerror";
							$continue = false;
						} else {
							$db_selected = mysql_select_db(mysql_real_escape_string($_REQUEST['database']), $link);
							$mysqloks[] = "Database '".$_REQUEST['database']."' has been created.";
						}
					} else {
						$mysqloks[] = "Database '".$_REQUEST['database']."' already exists.";
					}
					if ($continue == true) {
						$result = mysql_query('select * from sites');
						if (!$result) {
					    	// sites table doesn't exist, create it
							$create = mysql_query("CREATE TABLE `sites` (
							  `url` mediumtext NOT NULL,
							  `invisible_key` varchar(255) NOT NULL,
							  `theme` varchar(255) NOT NULL DEFAULT 'default',
							  `db_username` varchar(255) NOT NULL,
							  `db_password` varchar(255) NOT NULL,
							  `db_name` varchar(255) NOT NULL,
							  `db_host` varchar(255) NOT NULL,
							  UNIQUE KEY `url` (`url`(300))
							) ENGINE=MyISAM DEFAULT CHARSET=latin1;");
							if (!$create) {
								$continue = false;
								$mysqlok = false;
								$mysqlerrors[] = "Couldn't create table 'sites'. Please ensure that the mySQL user account information entered in configuration.php has CREATE privileges.";
							} else {
								$mysqloks[] = "Table 'sites' has been created.";
							}
						} else { // sites already exists, check it
						
							$mysql ="SHOW CREATE TABLE sites;";
							$result = mysql_query ( $mysql );
							$result = mysql_fetch_array($result);	
							if (!strpos(implode(" ",$result),"db_name")) { 
								$mysql ="ALTER TABLE sites ADD db_name VARCHAR(255) NOT NULL;";
								$result = mysql_query ( $mysql );
								if (!$result) {
									$mysqlok = false;
									$mysqlerrors[] = "The installer couldn't update the table columns in the 'sites' table, please try running the installer again with an empty database.";
								} else {
									$mysqloks[] = "The installer has successfully updated the table columns in the 'sites' table.";
								}
							}	
							
							$result = mysql_query('select * from sites');
							
							$notaligned = false;
							$meta = mysql_fetch_field($result, 0);
							if ($meta->name != "url" || $meta->unique_key!="1") {
								$notaligned = true;
							}
							$meta = mysql_fetch_field($result, 1);
							if ($meta->name != "invisible_key") {
								$notaligned = true;
							}
							$meta = mysql_fetch_field($result, 2);
							if ($meta->name != "theme") {
								$notaligned = true;
							}
							$meta = mysql_fetch_field($result, 3);
							if ($meta->name != "db_username") {
								$notaligned = true;
							}
							$meta = mysql_fetch_field($result, 4);
							if ($meta->name != "db_password") {
								$notaligned = true;
							}
							$meta = mysql_fetch_field($result, 5);
							if ($meta->name != "db_name") {
								$notaligned = true;
							}
							if ($notaligned===true) {
								$mysqlok = false;
								$mysqlerrors[] = "Table 'sites' in database '".$_REQUEST['database']."' does not match the required schema. It is recommended that you backup and remove the database and run this installer again to create it from fresh.";	
							}else {
								$mysqloks[] = "Table 'sites' in database '".$_REQUEST['database']."' exists and has the correct columns.";	
							}
						}

						// check admin table

						$result = mysql_query('select * from admin');
						if (!$result) {
					    	// sites table doesn't exist, create it
							$create = mysql_query("CREATE TABLE `admin` (
							  	`username` varchar(255) NOT NULL,
							  	`password` char(40) NOT NULL,
							  	`salt` varchar(255) NOT NULL,
								`logged_in_key` VARCHAR(255) NOT NULL,
								`age` VARCHAR(255) NOT NULL,
								`uaip` VARCHAR(255) NOT NULL
							) ENGINE=MyISAM DEFAULT CHARSET=latin1;");
							if (!$create) {
								$continue = false;
								$mysqlok = false;
								$mysqlerrors[] = "Couldn't create table 'sites'. Please ensure that the mySQL user account information entered in configuration.php has CREATE privileges.";
							} else {
								$mysqloks[] = "Table 'admin' has been created.";
							}
						} else { // admin already exists, check it
							$notaligned = false;
							$meta = mysql_fetch_field($result, 0);
							if ($meta->name != "username") {
								$notaligned = true;
							}
							$meta = mysql_fetch_field($result, 1);
							if ($meta->name != "password") {
								$notaligned = true;
							}
							$meta = mysql_fetch_field($result, 2);
							if ($meta->name != "salt") {
								$notaligned = true;
							}
							$meta = mysql_fetch_field($result, 3);
							if ($meta->name != "logged_in_key") {
								$notaligned = true;
							}
							$meta = mysql_fetch_field($result, 4);
							if ($meta->name != "age") {
								$notaligned = true;
							}
							$meta = mysql_fetch_field($result, 5);
							if ($meta->name != "uaip") {
								$notaligned = true;
							}
							if ($notaligned===true) {
								$mysqlok = false;
								$mysqlerrors[] = "Table 'admin' in database '".$_REQUEST['database']."' does not match the required schema. It is recommended that you backup and remove the database and run this installer again to create it from fresh.";	
							} else {
								$mysqloks[] = "Table 'admin' in database '".$_REQUEST['database']."' exists and has the correct columns.";	
							}
						}
					}
				}
				
				
			}
			
			if ($mysqlok===true) {
				?>
				<p>Success! MySQL is correctly configured to run SetSeed using the supplied connection account.</p>
				<?php
				foreach ($mysqloks as $ok) {
					?>
					<p class="ok"><?php echo $ok; ?></p>
					<?php
				}
				?>
				<p style="margin-top:40px;float:right"><a href="?step3&username=<?php echo urlencode($_REQUEST['username']); ?>&password=<?php echo urlencode($_REQUEST['password']); ?>&host=<?php echo urlencode($_REQUEST['host']); ?>&database=<?php echo urlencode($_REQUEST['database']); ?>"><img src="installer_assets/continue.png" alt="Continue"/></a></p>
				<h2>You can now proceed to step 3 of 3</h2>
				<?php
			} else {

				?>
				<p>Please address the following issues with your MySQL configuration.</p>
				<?php
				foreach ($mysqlerrors as $error) {
					?>
					<p class="error"><?php echo $error; ?></p>
					<?php
				}
				if (count($mysqloks)>0) {
				?>
					<p>The following MySQL checks passed successfully.</p>
					<?php
					foreach ($mysqloks as $ok) {
						?>
						<p class="ok"><?php echo $ok; ?></p>
						<?php
					}
				}
				?>
				<p>Please follow the instructions below to try creating your MySQL user again.</p>
				<?php
			}

		}
		if ($mysqlok===false || !isset($_REQUEST['mysql'])) {
			?>
					<p>Please create a new MySQL database on your hosting system and enter it's connection information below. This database is used by SetSeed to maintain connection information on all websites powered by this installation of SetSeed.</p>
					<form action="" method="POST">
						<input type="hidden" name="step2" value=""/>
						<input type="hidden" name="mysql" value=""/>
						<div class="inputSection"><label>MySQL database:</label>
						<input type="text" name="database" value="<?php echo isset($_REQUEST['database']) ? htmlspecialchars($_REQUEST['database']) : ""; ?>" id="database"/></div>
						<div class="inputSection"><label>MySQL user name:</label>
						<input type="text" name="username" value="<?php echo isset($_REQUEST['username'])?htmlspecialchars($_REQUEST['username']):""; ?>" id="username"/></div>
						<div class="inputSection"><label>MySQL user password:</label>
						<input type="text" name="password" value="<?php echo isset($_REQUEST['password'])?htmlspecialchars($_REQUEST['password']):""; ?>" id="password"/></div>
						<div class="inputSection last"><label>MySQL host (usually 'localhost'):</label>
						<input type="text" name="host" value="<?php echo isset($_REQUEST['host']) ? htmlspecialchars($_REQUEST['host']) : "localhost"; ?>" id="host"/></div>
						<input type="image" src="installer_assets/privi.png" id="send"/>
					</form>
			<?php
		}
	}
	if (!isset($_REQUEST['step2']) && isset($_REQUEST['step3']) && !isset($_REQUEST['cont'])) {
		$path = realpath("index.php");
		if ($path!==false) {
			$path = explode("/",$path);
			$count = count($path);
			$count = $count-3;
		$DocRoot=$path[$count];			
		}
		$proceed=true;
		?>
		<h2>Step 3 of 3: Moving files to final location</h2>
		<p>Your server appears to be compatible with SetSeed and the initial database has been created and configured. </p>


	<?php
		
			function is_empty_dir($dir)
			{
			    if ($dh = @opendir($dir))
			    {
			        while ($file = readdir($dh))
			        {
			            if ($file != '.' && $file != '..' && $file != '.DS_Store') {
			                closedir($dh);
			                return false;
			            }
			        }
			        closedir($dh);
			        return true;
			    }
			    else return false; // whatever the reason is : no such dir, not a dir, not readable
			}
			

			function recurse_copy($src,$dst) {
			    if ($dir = opendir($src)) {
					$permissions = substr(sprintf('%o', fileperms($src)), -4);
				    mkdir($dst);
					if ($permissions == "0777") {
						chmod($dst,0777);
					}
				    while(false !== ( $file = readdir($dir)) ) {
				        if (substr($file,0,1)!=".") {
				            if ( is_dir($src . '/' . $file) ) {
				                recurse_copy($src . '/' . $file,$dst . '/' . $file);
				            }
				            else {
				                copy($src . '/' . $file,$dst . '/' . $file);
				            }
				        }
						if ($file==".htaccess") {
						    copy($src . '/' . $file,$dst . '/' . $file);
						}
				    }
				    closedir($dir);
				}
			}
			if (file_exists("../sites/default")) {
				?>
				<p class="error">Not copying default site folder to 'sites' folder because it already exists. </p>
				<?php
			} else {
				recurse_copy("default","../sites/default");
				
				if (!is_writable("../sites")) {
					chmod("../sites",0777);
				}
				if (!is_writable("../sites/default/db.sql")) {
					chmod("../sites/default/db.sql",0777);
				}
				if (!is_writable("../sites/default/themes/default/css/archives")) {
					chmod("../sites/default/themes/default/css/archives",0777);
				}
				if (!is_writable("../sites/default/themes/default/javascripts/archives")) {
					chmod("../sites/default/themes/default/javascripts/archives",0777);
				}
				if (!is_writable("../sites/default/themes/basic/css/archives")) {
					chmod("../sites/default/themes/basic/css/archives",0777);
				}
				if (!is_writable("../sites/default/themes/basic/javascripts/archives")) {
					chmod("../sites/default/themes/basic/javascripts/archives",0777);
				}
				if (!is_writable("../sites/default/downloads")) {
					chmod("../sites/default/downloads",0777);
				}
				if (!is_writable("../sites/default/images")) {
					chmod("../sites/default/images",0777);
				}
				if (!is_writable("../sites/default/images/galleries")) {
					chmod("../sites/default/images/galleries",0777);
				}
				if (!is_writable("../sites/default/images/galleries/thumbs")) {
					chmod("../sites/default/images/galleries/thumbs",0777);
				}
				if (!is_writable("../sites/default/media")) {
					chmod("../sites/default/media",0777);
				}
				if (!is_writable("../sites/default/livechatlogs")) {
					chmod("../sites/default/livechatlogs",0777);
				}
				if (!is_writable("../sites/default/livechatsaves")) {
					chmod("../sites/default/livechatsaves",0777);
				}
				if (!is_writable("../sites/default/cache/templates_c")) {
					chmod("../sites/default/cache/templates_c",0777);
				}
				if (!is_writable("../sites/default/cache/cache")) {
					chmod("../sites/default/cache/cache",0777);
				}
				if (!is_writable("../sites/default/cache/configs")) {
					chmod("../sites/default/cache/configs",0777);
				}

				?>
				<p class="ok">'default' site folder copied to 'sites' folder.</p>
				
				<?php
			}
			if (file_exists("../sites/examplecom")) {
				?>
				<p class="error">Not copying example site folder to 'sites' folder because it already exists. </p>
				<?php
			} else {
				recurse_copy("examplecom","../sites/examplecom");
				if (!is_writable("../sites/examplecom/db.sql")) {
					chmod("../sites/examplecom/db.sql",0777);
				}
				if (!is_writable("../sites/examplecom/themes/default/css/archives")) {
					chmod("../sites/examplecom/themes/default/css/archives",0777);
				}
				if (!is_writable("../sites/examplecom/themes/default/javascripts/archives")) {
					chmod("../sites/examplecom/themes/default/javascripts/archives",0777);
				}
				if (!is_writable("../sites/examplecom/themes/basic/css/archives")) {
					chmod("../sites/examplecom/themes/basic/css/archives",0777);
				}
				if (!is_writable("../sites/examplecom/themes/basic/javascripts/archives")) {
					chmod("../sites/examplecom/themes/basic/javascripts/archives",0777);
				}
				if (!is_writable("../sites/examplecom/themes/examplesite/css/archives")) {
					chmod("../sites/examplecom/themes/examplesite/css/archives",0777);
				}
				if (!is_writable("../sites/examplecom/themes/examplesite/javascripts/archives")) {
					chmod("../sites/examplecom/themes/examplesite/javascripts/archives",0777);
				}
				if (!is_writable("../sites/examplecom/downloads")) {
					chmod("../sites/examplecom/downloads",0777);
				}
				if (!is_writable("../sites/examplecom/images")) {
					chmod("../sites/examplecom/images",0777);
				}
				if (!is_writable("../sites/examplecom/images/galleries")) {
					chmod("../sites/examplecom/images/galleries",0777);
				}
				if (!is_writable("../sites/examplecom/images/galleries/thumbs")) {
					chmod("../sites/examplecom/images/galleries/thumbs",0777);
				}
				if (!is_writable("../sites/examplecom/media")) {
					chmod("../sites/examplecom/media",0777);
				}
				if (!is_writable("../sites/examplecom/livechatlogs")) {
					chmod("../sites/examplecom/livechatlogs",0777);
				}
				if (!is_writable("../sites/examplecom/livechatsaves")) {
					chmod("../sites/examplecom/livechatsaves",0777);
				}
				if (!is_writable("../sites/examplecom/cache/templates_c")) {
					chmod("../sites/examplecom/cache/templates_c",0777);
				}
				if (!is_writable("../sites/examplecom/cache/cache")) {
					chmod("../sites/examplecom/cache/cache",0777);
				}
				if (!is_writable("../sites/examplecom/cache/configs")) {
					chmod("../sites/examplecom/cache/configs",0777);
				}
				?>
				<p class="ok">Example site folder copied to 'sites' folder - ready to import in the Hub.</p>
				
				<?php
			}
			if ($proceed===true) {
				if (isset($_SERVER['HTTP_HOST'])) {
					$server = $_SERVER['HTTP_HOST']; 	
				} else if (isset($_SERVER['SERVER_NAME'])) {
					$server = $_SERVER['SERVER_NAME']; 
				}
				$server = explode(":",$server);
				$server = $server[0]; 
				$config = "<?php

/*
	Enter the MySQL connection information for your primary SetSeed database below: 
*/
\$mysql_database = \"".htmlspecialchars($_REQUEST['database'])."\";
\$mysql_username = \"".htmlspecialchars($_REQUEST['username'])."\";
\$mysql_password = \"".htmlspecialchars($_REQUEST['password'])."\";
\$mysql_server = \"".htmlspecialchars($_REQUEST['host'])."\";


/* 
	Enter the primary domain for this server. This can be a generic domain or subdomain that you use to identify and view this server. Enter it without http:// and without a trailing slash. 
*/
\$primaryDomain = \"$server\";


// Do not edit below this line
\$rootdir = dirname(__FILE__);
\$pos = strrpos(\$rootdir,\"/\");
\$rootdir = substr(\$rootdir,0,\$pos);
define( 'ROOT_DIR', \$rootdir );
if (!isset(\$installer)) {
	require_once \"boot.php\";	
}

?>";

				$myFile = "../app/configuration.php";
				$fh = fopen($myFile, 'w') or die("can't open configuration.php file");
				fwrite($fh, $config);
				fclose($fh);
				
				@mkdir("../app/cache/templates_c");
				@mkdir("../app/cache/configs");
				@mkdir("../app/cache/cache");
				if (!is_writable("../app/cache/templates_c")) {
					chmod("../app/cache/templates_c",0777);
				}
				if (!is_writable("../app/cache/configs")) {
					chmod("../app/cache/configs",0777);
				}
				if (!is_writable("../app/cache/cache")) {
					chmod("../app/cache/cache",0777);
				}
				
				?>
				<p class="ok">SetSeed configuration saved to configuration.php</p>
				<p style="margin-top:40px;float:right"><a href="/setseed-hub/"><img src="installer_assets/continue.png" alt="Continue"/></a></p>
				<h2>Congratulations! SetSeed is now installed on your server. <br/>
					You can now continue to the <a href="/setseed-hub/">SetSeed Hub</a> to start creating websites.</h2>
				<?php
			}
		}

		
		


	?>
</body>
</html>