<?php
require_once 'Config.php';
/**
*	Working with XML data
*
*	@author Dmitri Smirnov
*	@package sXML
*/
class WebXell {
	
	/**
	*   Constructor
	*/
	public function __construct() {
        @session_start();
	}
	
	/**
	*	Gets the XML content
	*
	*	@param string $file
	*	@access public
	*	@returns object
	*/	
	public static function getXml($file) {
		if(file_exists($file)) {
			$xml = simplexml_load_file($file);
		} else {
			throw new Exception("Cannot load file $file");
		}
		return $xml;
	}
	
	/**
	*	Writes the xml data to file
	*	
	*	@param string
	*	@param string
	*	@access private
	*	@returns void
	*/
	private function writeXmlInFile($xmlStr, $file) {
		$fp = fopen($file, 'w');
		if(!$fp) { throw new Exception("Cannot write data to file $file"); }
		fwrite($fp, $xmlStr);
		fclose($fp);
	}
	
	/**
	*	Backups old xml file befor writing with 'backup' suffix
	*
	*	@param string
	*	@access public
	*	@returns void
	*/
	public function backupXml($file) {
		$fp = fopen($file, 'r');
		if(!$fp) { throw new Exception("Cannot write data to file $file"); }
		$content = "<!-- Backup of $file, created at " . date("d.m.Y H:i:s") . " -->\n";
		while (!feof($fp))
			$content .= fread($fp, 8192);
		fclose($fp);
		
		$f = $this->findexts($file);
		$new_file = $f[0] . 'backup.' . $f[1];
		
		$fp = fopen($new_file, 'w');
		if(!$fp) { throw new Exception("Cannot write data to file $new_file"); }
		fwrite($fp, $content);
		fclose($fp);
	}
	
	/**
	*	Get file extension
	*
	*	@param string
	*	@returns array
	*/
	private function findexts($file)
	{
		$file = strtolower($file) ;
		$exts = split("[/\\.]", $file) ;
		$n = count($exts)-1;
		$str = '';
		for($i=0; $i<$n; $i++) {
			$str .= $exts[$i] . '.';
		}
		$exts = $exts[$n];
		return array(0 => $str, 1 => $exts);
	}
	
	/**
	*	Make the xml file
	*
	*	@access public
	*	@param array
	*	@param str
	*	@void
	*/
	public function writeXml($arr, $xmlObject, $filename) {
		//we need to check XSL linkage
		$f = file($filename);
		if(strpos($f[1], 'text/xsl'))
			$xsl = $f[1];
		unset($f);
		
		$xml = '<?xml version="1.0" encoding="utf-8"?>' . "\n";
		if($xsl)
			$xml .= "$xsl\n";
		
		$rootElement   = $xmlObject->getName();
		$entityElement = $xmlObject->children()->getName();
		//print_r($arr);exit;
		$xml .= "<$rootElement>\n";
		foreach($arr as $tmp) {
			$rec ="";
			$rec = "\t<record>\n";
			while(list($key, $val) = each($tmp)) {
                $rec .= "\t\t" . '<' . $key . '>' . $val . '</' . $key . '>' . "\n";
			}
			$rec .= "\t</record>\n";
			$xml .= $rec;
		}
		$xml .= "</$rootElement>\n";
		$this->writeXmlInFile($xml, $filename);
	}
	
	/**
	*	Get the XML file list
	*
	*	@param string
	*	@returns array
	*/
	public function getFileList($dir) {
		$files = array();
		if ($handle = opendir($dir)) {
			while (false !== ($file = readdir($handle))) {
				if(is_file($dir . $file))
					array_push($files, $file);
			}
			closedir($handle);
		}
		//TODO: use glob
		/*foreach(glob("$dir*.xml") as $filename) {
			array_push($files, $filename);
		}*/
		return $files;
	}
}

?>