<?php
//Do not cache this page. Must redraw field values
header("Cache-Control: no-cache, must-revalidate");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");

@session_start();

require_once 'Config.php';
require_once 'WebXell.php';
include_once 'lang/' . Config::LANG;

//get version
$fp = @fopen('VERSION', 'r');
if($fp) {
	$version = fread($fp, 256);
} else {
	$version = 'unknown';
}
fclose($fp);

$nofile = FALSE;
$count = 0;
$xml = array();

$filename = @$_GET['file'];

if(!file_exists(Config::FILE_DIR . $filename)) {
	header('Location: index.php');
	exit();
}

if(!$filename) {
	$nofile = TRUE;
}
$xmlDoc = new WebXell();
$xml_files = $xmlDoc->getFileList(Config::FILE_DIR);
if(!$nofile) {
	$xml = $xmlDoc->getXml(Config::FILE_DIR . $filename);
}
if($filename) {
	$f = file(Config::FILE_DIR . $filename);
	$f = $f[1];
	if(strpos($f, 'text/xsl')) {
		//TODO: make regular expression
		$f = str_replace('<?xml-stylesheet', '', $f);
		$f = str_replace('type="text/xsl"', '', $f);
		$f = str_replace('?>', '', $f);
		$f = str_replace('href=', '', $f);
		$f = str_replace('"', '', $f);
		$f = str_replace(' ', '', $f);
		$f = str_replace("\n", '', $f);
	} else {
		$f = '';
	}
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="author" content="Dmitri Smirnov" />
<meta name="copyright" content="2008 Dmitri Smirnov" />
<meta name="version" content="<?php echo $version; ?>" />
<link type="text/css" href="themes/BlueSky/base.css" rel="stylesheet" media="screen" />
<!--[if IE]>
<link type="text/css" href="themes/BlueSky/ie.css" rel="stylesheet" media="screen" />
<![endif]-->
<title>webXell Editor</title>
</head>

<body>
<!-- tools -->

<div id="panel">
<div title="webXell editor" class="label"></div>
<div class="tool-cont">
<?php if(Config::NEW_FILES) { ?><a class="tools" id="tool-new-file" href="#" title="<?php echo $L['new_file'] ?>"><?php if(Config::ICONS_LABELS) { ?><?php echo $L['new_file'] ?><?php } ?></a>
    
    <!--[if gt IE 6]><div class="clearer"></div><![endif]-->
	<div id="newFile" class="optPanel">
	<label><?php echo $L['new_file_name'] ?></label><br />
	<input type="text" value="" id="newFileField" />
	<input type="button" value="OK" id="newFileButton" /><br />
	<div class="input-error" id="file-regexp"><?php echo $L['wrong_file_name'] ?></div>
	</div>

<?php } ?>
</div>
<?php if($filename) { ?>
<div class="tool-cont">
<?php if(Config::XSL) { ?><a class="tools" id="tool-xsl" href="#" title="<?php echo $L['apply_xsl'] ?>">
<?php if(Config::ICONS_LABELS) { ?><?php echo $L['apply_xsl'] ?><?php } ?></a>
    <!--[if gt IE 6]><div class="clearer"></div><![endif]-->
	<div id="xsl" class="optPanel">
	<label><?php echo $L['xsl_path'] ?>:</label><br />
	<span class="tip"><?php echo $L['xsl_empty'] ?></span>
	<input type="text" value="<?php echo $f; ?>" id="XSLField" />
	<!-- TODO: add a script to get files from directories -->
	<input type="button" value="OK" id="XSLButton" /><br />
	<div class="input-error" id="xsl-wrongname"><?php echo $L['xsl_incorrect'] ?></div>
	</div>
<?php } ?>
</div>
<?php if(Config::ADD_RECORDS) { ?><a class="tools" id="tool-add-record" href="#" title="<?php echo $L['add_records'] ?>"><?php if(Config::ICONS_LABELS) { ?><?php echo $L['add_records'] ?><?php } ?></a><?php } ?>

<div class="tool-cont">
<?php if(Config::NEW_FIELDS) { ?><a class="tools" id="tool-add-column" href="#" title="<?php echo $L['new_fields'] ?>"><?php if(Config::ICONS_LABELS) { ?><?php echo $L['new_fields'] ?><?php } ?></a>

    <!--[if gt IE 6]><div class="clearer"></div><![endif]-->
	<div id="addColumnPanel" class="optPanel">
	<label><?php echo $L['new_field_name'] ?>:</label><br />
	<input type="text" value="" id="newColumnField" />
	<input type="button" value="OK" id="newColumnButton" /><br />
	<div class="input-error" id="col-empty"><?php echo $L['field_empy'] ?></div>
	<div class="input-error" id="col-regexp"><?php echo $L['field_incorrect'] ?></div>
	<div class="input-error" id="col-column-dpl"><?php echo $L['field_exists'] ?></div>
	<div class="input-error" id="col-reserved"><?php echo $L['field_reserved'] ?></div>
	</div>
</div>

<?php } ?>

<!-- sort -->
<div class="tool-cont">
<?php if(Config::SORTING) { ?><a class="tools" id="tool-sort" href="#" title="<?php echo $L['sort'] ?>"><?php if(Config::ICONS_LABELS) { ?><?php echo $L['sort'] ?><?php } ?></a><?php } ?>
	
	<!--[if gt IE 6]><div class="clearer"></div><![endif]-->
	<div id="sort" class="optPanel">
	<label><?php echo $L['order_by'] ?></label>
	<?php if(!$nofile) { $first = FALSE; ?>
	<select id="orderBy">
	<?php
	$t =  $xml->children()->children();
	foreach($t as $tmp) {
	if(!preg_match("/^img*/", $tmp->getName())) {
	?>
	<option value="<?php echo $tmp->getName();?>" <?php if(!$first) { echo ' selected="selected"'; $first = TRUE; } ?>><?php echo $tmp->getName() ?></option>
	<?php }} ?>
	</select>
	<?php } ?>
	<input type="radio" name="orderType" value="asc" checked="checked" /><?php echo $L['asc'] ?>
	<input type="radio" name="orderType" value="desc" /><?php echo $L['desc'] ?><br />
	<input type="button" value="<?php echo ucwords($L['sort']) ?>" id="sortButton" />
	</div>
</div>
<?php } ?>

<!-- options -->
<div class="tool-cont">
<?php if(Config::OPTIONS) { ?><a class="tools" id="tool-preferences" href="#" title="<?php echo $L['prefs'] ?>"><?php if(Config::ICONS_LABELS) { ?><?php echo $L['prefs'] ?><?php } ?></a>

<!--[if gt IE 6]><div class="clearer"></div><![endif]-->
<div id="preferences" class="optPanel">
<form action="generateConfig.php" method="post">
<table border="0">
	<tr>
		<th align="left">Name</th>
		<th align="left">Value</th>
	</tr>
	<tr>
		<td>Language</td>
		<td>
			<select name="prefsLang">
			<?php foreach(glob("lang/*") as $file) { ?>
				<option value="<?php echo $file ?>" <?php if(Config::LANG == str_replace('lang/', '', $file)) {echo "selected=\"selected\"";} ?>><?php echo str_replace('lang/', '', $file); ?></option>
			<?php } ?>
			</select>
		</td>
	</tr>
	<tr>
		<td><?php echo $L['icons_labels'] ?></td>
		<td><input type="checkbox" name="prefsIcons" <?php if(Config::ICONS_LABELS) echo "checked=\"checked\""; ?> /></td>
	</tr>
	<tr>
		<td><?php echo $L['create_new_files'] ?></td>
		<td><input type="checkbox" name="prefsFiles" <?php if(Config::NEW_FILES) echo "checked=\"checked\""; ?> /></td>
	</tr>
	<tr>
		<td><?php echo $L['enable_xsl'] ?></td>
		<td><input type="checkbox" name="prefsXSL" <?php if(Config::XSL) echo "checked=\"checked\""; ?> /></td>
	</tr>
	<tr>
		<td><?php echo $L['add_new_records'] ?></td>
		<td><input type="checkbox" name="prefsRecords" <?php if(Config::ADD_RECORDS) echo "checked=\"checked\""; ?> /></td>
	</tr>
	<tr>
		<td><?php echo $L['add_new_fields'] ?></td>
		<td><input type="checkbox" name="prefsFields" <?php if(Config::NEW_FIELDS) echo "checked=\"checked\""; ?> /></td>
	</tr>
	<tr>
		<td><?php echo $L['enable_sort'] ?></td>
		<td><input type="checkbox" name="prefsSorting" <?php if(Config::SORTING) echo "checked=\"checked\""; ?> /></td>
	</tr>
	<tr>
		<td><?php echo $L['options_enable'] ?></td>
		<td><input disabled="disabled" type="checkbox" name="prefsOptions" <?php if(Config::OPTIONS) echo "checked=\"checked\""; ?> /></td>
	</tr>
	<tr>
		<td><?php echo $L['file_dir'] ?></td>
		<!-- TODO: add a script to get directory GUI mode -->
		<td><input type="text" value="<?php echo Config::FILE_DIR ?>" name="xmlDir" id="xmlDir" disabled="disabled" /></td>
	</tr>
	<tr>
        <td colspan="2"><hr /></td>
	</tr>
	<tr>
		<td><?php echo $L['allow_img'] ?></td>
		<td><input id="imgswitcher"type="checkbox" name="prefsAllowImg" <?php if(Config::ALLOW_IMG) echo "checked=\"checked\""; ?> /></td>
	</tr>
	<tr>
		<td><?php echo $L['img_size'] ?></td>
		<td>
           <input <?php if(!Config::ALLOW_IMG) echo 'disabled="disabled" '; ?>class="imagesizeinput" type="text" value="<?php echo Config::IMG_WIDTH ?>" name="prefsImgWidth" /> X
            <input <?php if(!Config::ALLOW_IMG) echo 'disabled="disabled" '; ?>class="imagesizeinput" type="text" value="<?php echo Config::IMG_HEIGHT ?>" name="prefsImgHeight" />
        </td>
    </tr>
	<tr>
		<td><?php echo $L['generate_thumb'] ?></td>
		<td><input type="checkbox" name="prefsGenThumbs" <?php if(Config::GENERATE_THUMBS) echo "checked=\"checked\""; ?> id="fGenThumbs" /></td>
	</tr>
    <tr>
		<td><?php echo $L['thumb_size'] ?></td>
		<td>
            <input <?php if(!Config::GENERATE_THUMBS) echo 'disabled="disabled" '; ?>class="smallinput" type="text" value="<?php echo Config::THUMB_WIDTH ?>" name="prefsThumbWidth" /> X
            <input <?php if(!Config::GENERATE_THUMBS) echo 'disabled="disabled" '; ?>class="smallinput" type="text" value="<?php echo Config::THUMB_HEIGHT ?>" name="prefsThumbHeight" />
        </td>
    </tr>
	<tr>
		<td><?php echo $L['img_dir'] ?></td>
		<td><input type="text" value="<?php echo Config::IMG_DIR ?>" name="imgDir" id="imgDir" disabled="disabled" /></td>
	</tr>
	<tr>
        <td colspan="2"><hr /></td>
	</tr>
</table>
<input type="submit" value="<?php echo $L['apply'] ?>" id="prefsButton" />
</form>
</div>
</div>
<?php } ?>

<a class="tools" id="tool-help" href="help/<?php echo Config::LANG ?>/index.html" target="_blank" title="<?php echo $L['help'] ?>"><?php if(Config::ICONS_LABELS) { ?><?php echo $L['help'] ?><?php } ?></a>
<div class="separator"></div>
<div class="version"><?php echo $version ?></div>
</div>
<div class="panel-shadow"></div>
<div class="clearer"></div>


<!-- Upload form -->
<div class="upload-panel">
<h3><?php echo $L['upload_image'] ?></h3>
<span class="close"></span>
<div class="item-img"></div>

<a href="#" class="delete-img"><img src="themes/BlueSky/delete.png" alt="" border="0" /></a>
<a href="#" class="delete-img"><?php echo $L['delete_image'] ?></a><br />

<input type="file" class="multi" accept="gif|jpg|png" name="updFile" id="updFileField" />
<br />
<input type="button" id="updButton" value="<?php echo $L['upload'] ?>" />
</div>




<div id="wrapper">

<div id="col1">
<h2><?php echo $L['files'] ?></h2>
<ul id="files-list">
<?php foreach($xml_files as $tmp) { ?>
<li><a <?php if(!preg_match("/$tmp/", $filename)) { ?>href="index.php?file=<?php echo $tmp; ?>"<?php } else { echo "class=\"on\""; } ?>><?php echo $tmp; ?></a>
<a href="deleteFile.php?file=<?php echo $tmp; ?>" class="delete-file"><img src="themes/BlueSky/delete.png" alt="Delete" border="0" /></a>
<div class="clearer"></div>
</li>
<?php }?>
</ul>
</div><!-- #col1 end -->

<!-- Area for editing recrods  -->
<div id="col2">
<?php if(!$nofile) { ?>
<div class="editing-area">
<h2><?php echo ucwords($xml->getName()); ?></h2>
<form action="saveData.php?f=<?php echo $filename; ?>" method="post" id="recordSet">

<?php if(count($xml->children()) > 30) { ?>
<input type="submit" value="<?php echo $L['save'] ?>" /><br /><br />
<?php } ?>

<div class="header-container">
<?php
$t =  $xml->children()->children();
foreach($t as $tmp) {
    if(!preg_match("/^img*/", $tmp->getName())) {
        echo "<div class=\"field-header\"><span>" . $tmp->getName() . "</span><a href='#' class='delete-column' rel='" . $tmp->getName() . "'><img src=\"themes/BlueSky/delete.png\" alt=\"Delete\" border=\"0\" /></a></div>";
    }
}
?>
</div>

<span class="headers-end"></span>
<div class="clearer"></div>
<ul id="record-list">

<?php
$count = 0;
foreach($xml->children() as $tmp) { ?>
    <li>
        <div class="record" id="record<?php echo $count; ?>">
        <label class="record-number"><?php echo $count+1; ?>.</label>
        
        <?php foreach($tmp->children() as $t) { ?>
            <?php if(!preg_match("/^img*/", $t->getName())) {?>
                <input class="rec-field" type="text" name="<?php echo $t->getName(); ?>[]" value="<?php echo $t; ?>" />
            <?php } else {
                  $imname = Config::IMG_DIR . $t;
            ?>
                <input type="hidden" name="<?php echo $t->getName(); ?>[]" value="<?php echo $t; ?>" />
        <?php }
        } ?>
        
        <span class="field-end"></span>

        <?php if(Config::ALLOW_IMG) { ?>
            <div class="upload-image-icon <?php echo file_exists($imname)&&!is_dir($imname)  ? 'image-on' : 'image-off'; ?>" title='<?php echo $L['bind_image'] ?>'></div>
        <?php } ?>
        <a href="#" class="remove" target="<?php echo $count;?>"><img src="themes/BlueSky/delete.png" alt="Delete record" border="0" /></a>
        <div class="clearer"></div>
        </div><!-- #record end -->
    </li>

<?php $count++; }?>
</ul>
<br />

<input type="hidden" id="imagePath" value="<?php echo Config::IMG_DIR ?>" />
<input type="hidden" id="filename" value="<?php echo Config::FILE_DIR . $filename  ?>" />
<input type="submit" value="<?php echo $L['save'] ?>" />
<input type="button" value="<?php echo $L['download'] ?>" id="downloadBtn" />
</form>
</div>
<?php } else { ?>
<h2><?php echo $L['welcome'] ?></h2>
<p><?php echo $L['intro'] ?></p>
<?php } ?>
<div class="clearer"></div>
</div> <!-- #col2 end -->

</div><!-- #wrapper" end -->
<script type="text/javascript" src="js/jquery-1.2.6.min.js"></script>
<script type="text/javascript" src="js/jquery-ui-personalized-1.5rc1.min.js"></script>
<script type="text/javascript" src="js/jquery.ajaxfileupload.js"></script>
<?php /*
Png fix for Internet Explorer
<script type="text/javascript" src="js/jquery.pngFix.min.js"></script>
*/ ?>
<script type="text/javascript" src="js/webXell.js"></script>
<script type="text/javascript">
//<![CDATA[
var EDITABLE_FILE = "<?php echo @$_GET['file']; ?>";
var last_added = <?php echo $count; ?>;
var recordTemplate = new String();
recordTemplate += "<li>";
recordTemplate += "<div class='record' id='record{recId}'>";
recordTemplate += "<label class='record-number'>{recId1}.</label>";
recordTemplate += "<?php if($xml) {foreach($xml->children()->children() as $tmp) { echo !preg_match("/^img*/", $tmp->getName()) ? "<input class='rec-field' type='text' name='{$tmp->getName()}[]' value='' />" : "<input type='hidden' name='{$tmp->getName()}[]' value='' />";}} ?>";
recordTemplate += "<span class='field-end'></span>";
<?php if(Config::ALLOW_IMG) { ?>
recordTemplate += "<div class='upload-image-icon image-off' title='<?php echo $L['bind_image'] ?>'></div>";
<?php } ?>
recordTemplate += "<a href='#' class='remove' target='{recId}'><img src='themes/BlueSky/delete.png' alt='Delete' border='0' /></a>";
recordTemplate += "<div class='clearer'></div>";
recordTemplate += "</div>";
recordTemplate += "</li>";
function approveRemoving() {
	var sure = window.confirm("<?php echo $L['delete_record'] ?>");
	return sure ? true : false;
}
function approveUnSaved() {
	if(!saved) {
		var sure = window.confirm("<?php echo $L['not_saved'] ?>");
		return sure ? true : false;
	}/* else {
		return true;
	}*/
}
function approveFileDelete() {
	var sure = window.confirm("<?php echo $L['delete_file'] ?>");
	return sure ? true : false;
}

function approveColumnDelete() {
	var sure = window.confirm("<?php echo $L['delete_field'] ?>");
	return sure ? true : false;
}
//]]>
</script>
</body>
</html>
