/*
*	How fast are effects in ms, can use keywords "fast", "slow" etc.
*/
var effectsTime = 103;
/**
*	Defines changes are made
*/
var saved = true;
/**
*	Defines is the panel to add new column is opened
*/
var panelNewColumnOpened   = false;
var panelNewFileOpened     = false;
var panelSortOpened        = false;
var panelPrefsOpened       = false;
var panelXSLOpened         = false;
var panelUploadImageOpened = false;

/**
*   Defines for upload form who is it's parent.
*/
var uploadFormParent;

/**
*	Set the 'saved' variable to false
*
*	@returns boolean
*/
function savedToFalse() {
    
    saved = false;
    var val = $(".editing-area h2").text();

    if(val.charAt(val.length-1) == '*') return false;      
    $(".editing-area h2").text(val + '*');
	return false;
}

/**
*	When you delete or add some records it will draw new line numbers.
*
*	@void
*/
function rebuildNumbers() {
	var i = 1;
	$(".record-number").each(function() {
		$(this).html(i + ".");
		i++;
	});
}

/**
*	Deletes a record
*
*	@returns boolean
*/
function bindRemoveLinks() {
		$("#record" + $(this).attr("target")).addClass("delete");
		var sure = approveRemoving();
		if(sure) {
			$("#record" + $(this).attr("target")).html("");
			savedToFalse();
		}
		$("#record" + $(this).attr("target")).removeClass("delete");
		
		rebuildNumbers();
		closeAllPanels();
		
		return false;
}

/**
*	Opens dialog box for adding new column 
*
*	@returns boolean
*/
function openPanelNewColumns() {
	$("#tool-add-column").unbind("click", openPanelNewColumns);
	$(this).addClass("on");
	if(!panelNewColumnOpened) {
		$("#addColumnPanel").slideDown(effectsTime);
	} else {
		$("#addColumnPanel").slideUp(effectsTime);
	}
	panelNewColumnOpened = !panelNewColumnOpened;
	return false;
}
/**
*	Opens dialog box for touching new file
*
*	@returns boolean
*/
function openPanelNewFile() {
	$("#tool-new-file").unbind("click", openPanelNewFile);
	$(this).addClass("on");
	if(!panelNewFileOpened) {
		$("#newFile").slideDown(effectsTime);
	} else {
		$("#newFile").slideUp(effectsTime);
	}
	panelNewFileOpened = !panelNewFileOpened;
	return false;
}

/**
*	Opens dialog box for touching new file
*
*	@returns boolean
*/
function openPanelSort() {
	$("#tool-sort").unbind("click", openPanelSort);
	$(this).addClass("on");
	if(!panelSortOpened) {
		$("#sort").slideDown(effectsTime);
	} else {
		$("#sort").slideUp(effectsTime);
	}
	panelSortOpened = !panelSortOpened;
	return false;
}

/**
*	Opens dialog box for preferences
*
*	@returns boolean
*/
function openPanelPrefs() {
	$("#tool-preferences").unbind("click", openPanelPrefs);
	$(this).addClass("on");
	if(!panelPrefsOpened) {
		$("#preferences").slideDown(effectsTime);
	} else {
		$("#preferences").slideUp(effectsTime);
	}
	panelPrefsOpened = !panelPrefsOpened;
	return false;
}

/**
*	Opens dialog box for XSL file association
*
*	@returns boolean
*/
function openPanelXSL() {
	$(this).addClass("on");
	$("#tool-xsl").unbind("click", openPanelXSL);
	if(!panelXSLOpened) {
		$("#xsl").slideDown(effectsTime);
	} else {
		$("#xsl").slideUp(effectsTime);
	}
	
	return false;
}
/**
*	Closes all opened panels
*
*	@void
*/
function closeAllPanels() {
	$("#addColumnPanel").slideUp(effectsTime);
	panelNewColumnOpened = false;

	$("#newFile").slideUp(effectsTime);
	panelNewFileOpened   = false;
	
	$("#sort").slideUp(effectsTime);
	panelSortOpened = false;
	
	$("#preferences").slideUp(effectsTime);
	panelPrefsOpened = false;
	
	$("#xsl").slideUp(effectsTime);
	panelXSLOpened = false;
	
	$(".input-error").hide();
	$(".tools").removeClass("on");
	
	$("#tool-xsl").bind("click", openPanelXSL);
	$("#tool-add-column").bind("click", openPanelNewColumns);
	$("#tool-new-file").bind("click", openPanelNewFile);
	$("#tool-sort").bind("click", openPanelSort);
	$("#tool-preferences").bind("click", openPanelPrefs);
	
}
/**
*	Ordes by column
*
*	@void
*/
function orderBy() {
	//TODO: fix bug when drag and drop
	var values = new Array();
	var novos_seculurum = "";
	var numeric = true;
	var n;
	var orderField = $("#orderBy").val();
	var orderType  = $(":radio:checked").val();
	var orderFnc = new Function();
	
	$("ul#record-list li .record input[@name^="+orderField+"]").each(function() {
        n = parseInt($(this).val());
        if(isNaN(n)){
            numeric = false;
            values.push($(this).val());
        } else {
          values.push(n);
        }
        //console.log($(this));
	});
  orderFnc = new Function("a", "b", "return a-b");
  orderFnc = new Function("a", "b", "return a-b");
    
  //console.log(values);
    
	if(orderType == "asc") {
		if(numeric)
			values = values.sort(orderFnc);
		else
			values = values.sort();
	} else if(orderType == "desc") {
		if(numeric)
			values = values.sort(orderFnc).reverse();
		else
			values = values.sort().reverse();
	}
	
	//console.log(values);
	
	for(var i=0; i < values.length; i++) {
		$("ul#record-list li .record input[name^="+orderField+"]").each(function() {
			if($(this).val() == values[i]) {
				novos_seculurum +=  "<li>" + $(this).parent().parent().html() + "</li>";
				$(this).parent().parent().replaceWith("");
			}
		});
	}
	
	$("ul#record-list").html(novos_seculurum);
	
	$("ul#record-list").sortable({
		items: ".record",
		cursor: "move",
		axis: "y"
	});
	
	$("a.remove").bind("click", bindRemoveLinks);
	rebuildNumbers();
	savedToFalse();
	closeAllPanels();
}

/**
*	Adds a new column (field)
*
*	@void
*/
function addNewColumn() {
	var found = false;
	//TODO: test regular expressions
	var n = $("#newColumnField").val();
	var re = /^[a-z_:][A-Za-z0-9_:.-]*$/i;
	var reserved = '/^img*$/i';
	
	//if there is already column with similar name (starts) do not add and show the error
	$(".field-header").each(function() {
		var str = $(this).html().substring(0, $(this).html().indexOf('<'));
		if(str == n) {
			found = true;
		}
	});
	if(n.indexOf("img") == 0) {
		$("#col-column-dpl").css("display", "none");
		$("#col-regexp").css("display", "none");
		$("#col-empty").css("display", "none");
		$("#col-reserved").css("display", "block");
	} else if(found) {
		$("#col-column-dpl").css("display", "block");
		$("#col-regexp").css("display", "none");
		$("#col-empty").css("display", "none");
		$("#col-reserved").css("display", "none");
	} else
	if(!n) {
		$("#col-reserved").css("display", "none");
		$("#col-column-dpl").css("display", "none");
		$("#col-regexp").css("display", "none");
		$("#col-empty").css("display", "block");
	} else if(!n.match(re)) {
		$("#col-reserved").css("display", "none");
		$("#col-column-dpl").css("display", "none");
		$("#col-empty").css("display", "none");
		$("#col-regexp").css("display", "block");
	}else {
		$(".headers-end").before("<div class='field-header'>"+n+"<a href='#' class='delete-column' rel='"+n+"'><img src='themes/BlueSky/delete.png' alt='' border='0' /></a></div>");
		
		$("div.record").each(function(){
			$(this)
			.children(".field-end")
			.before("<input type='text' class='rec-field' name='" + n + "[]' />");
		});
		
		//rebuild template for record
		var spos = recordTemplate.indexOf("<span class='field-end'></span>");
		var rt1  = recordTemplate.substring(0, spos);
		var rt2  = recordTemplate.substring(spos, recordTemplate.length);
		recordTemplate = rt1;
		recordTemplate += "<input class='rec-field' type='text' name='"+n+"[]' value='' />";
		recordTemplate += rt2;
		
		//add a field to sort
		 $("#orderBy :last-child").after("<option value='"+n+"'>"+n+"</option>");
		
		//clear the field's value
		$("#newColumnField").val("");
		
		$(".delete-column").bind("click", deleteColumn);
		
		closeAllPanels();
		savedToFalse();
	}
}
/**
*	Delete whole column
*
*	@void
*/
function deleteColumn() {
	var ok = approveColumnDelete();
		if(ok) {
		var name = $(this).attr("rel");
		$("input[name^=" + name + "]").each(function() {
			$(this).replaceWith("");
		});
		$(this).parent().replaceWith("");
		savedToFalse();
	}
}


/**
*	Adds a new file /entity name
*
*	@void
*/
function addNewFile() {
	var re = /^[a-z_:][A-Za-z0-9_:.-]*$/i;
	var str = $("#newFileField").val();
	if(!str.match(re)) {
		$("#file-regexp").css("display", "block");
	} else {
		window.location.href = "newEntity.php?file=" + str;
	}
}

/**
*	Adds new record
*
*	@returns boolean
*/
function addNewRecord() {
	var tmp = recordTemplate.replace(/{recId}/g, last_added);
	var tmp = tmp.replace(/{recId1}/g, last_added+1);
	$("ul#record-list li:last").after(tmp);
	last_added++;
	$("a.remove").bind("click", bindRemoveLinks);
	$(".upload-image-icon").bind("click", openUploadForm);
	savedToFalse();
	
	$("ul#record-list").sortable({
		items: ".record",
		cursor: "move"
	});
	
	return false;
}

/**
*	applyies XSL stylesheet to XML file
*
*	@void
*/
function applyXSL() {
	var xsl = $("#XSLField").val();
	if(!xsl.match(/[:?*\\/%^|"'<> ]/)) {
		$.ajax({
			type: "POST",
			url:  "addXsl.php",
			data: "file=" + EDITABLE_FILE + "&xsl=" + xsl,
			success: closeAllPanels
		});
	} else {
		$("#xsl-wrongname").css("display", "block");
	}
}
/**
*   Opens the form for upload images
*
*   @void
*/
function openUploadForm(e) {
    $(".upload-panel").show(effectsTime);
    
    $(".upload-panel")
    .css("top", e.pageY + "px")
    .css("left", e.pageX + "px");
    
    //clear all images
    //$(".item-img").html("");
    
    uploadFormParent = $(this).parent();
    var imgs = uploadFormParent.children(":hidden");
    imgs.each(function() {
        $(".item-img").html("<img alt='' src='" + $("#imagePath").val() + $(this).val() + "' width='150' />");
    });
}
function uploadFile() {
    //TODO: change value not destroy?
    uploadFormParent.children(":hidden").replaceWith("");
    
    $(":file").each(function() {
        
        $.ajaxFileUpload({
            url:'upload_pictures.php',
            secureuri:false,
            fileElementId: $(this).attr("id"),
            dataType: 'html',
            success: function (data, status) {
                //console.log(data);
                uploadFormParent
                .children(".field-end")
                .before("<input type='hidden' value='" + data +  "' name='img1[]' />");
          
                $(".item-img")
                .html("<img alt='' src='" + $("#imagePath").val() + data + "' width='150' />");
                uploadFormParent.children(".upload-image-icon").removeClass("image-off");
                uploadFormParent.children(".upload-image-icon").addClass("image-on");
                savedToFalse();
            },
            error: function (data, status, e) {
               alert(e);
            }
        });
    });
    
}
/**
*   Download the file as XML or other data (in future)
*
*   @returns boolean
*/
function downloadFile() {
    window.location.href = $("#filename").val();
    return false;
}
/**
*   Delete image for record
*
*   @void
*/
function deleteImage() {

    var img = $(this).prevAll("div").children("img");
    var imgSrc = img.attr("src");
    
    $.ajax({
        type: "POST",
        url:  "deleteFile.php",
        data: "action=deleteImg&img=" + imgSrc,
        success: function(data, status) {
            uploadFormParent.children(".upload-image-icon").removeClass("image-on");
            uploadFormParent.children(".upload-image-icon").addClass("image-off");
            img.replaceWith("");
            uploadFormParent.children("[@name^=img1]").val("");
            savedToFalse();
        }
	});
}
/**
*	main
*
*	@returns integer
*/
$(document).ready(function() {
	
	//For IE 6 png fix, uncomment appropriate <script> tag in index.php
	//$(document).pngFix();
	
	$("ul#record-list").sortable({
		items: ".record",
		cursor: "move",
		axis: "y"
	});
	$("#downloadBtn").bind("click", downloadFile);
	$("#updButton").bind("click", uploadFile);
	
	$(".upload-image-icon").bind("click", openUploadForm);
	$("span.close").bind("click", function() {
        $(".upload-panel").hide(effectsTime);
	});
	
	$(".delete-img").bind("click", deleteImage);
	
	$("#newColumnButton").bind("change", function() {
		$("#addColumnPanel .input-error").css("display", "none");
	});
		
	$(".delete-column").bind("click", deleteColumn);
	$(".delete-file").bind("click", approveFileDelete);
	
	$("#XSLButton").bind("click", applyXSL);
	$("#newColumnButton").bind("click", addNewColumn);
	$("#newFileButton").bind("click", addNewFile);
	$("#sortButton").bind("click", orderBy);
	
	$("#wrapper, #panel a").not("#clearXSLfield").bind("click", closeAllPanels);
	
	$("#tool-xsl").bind("click", openPanelXSL);
	$("#tool-add-column").bind("click", openPanelNewColumns);
	$("#tool-new-file").bind("click", openPanelNewFile);
	$("#tool-sort").bind("click", openPanelSort);
	$("#tool-preferences").bind("click", openPanelPrefs);
	
	$("#files-list li a").bind("click", approveUnSaved);
	$(".rec-field").bind("change", savedToFalse);
	
	$("a.remove").bind("click", bindRemoveLinks);
	$("#tool-add-record").bind("click", addNewRecord);
	
	$("#clearXSLfield").bind("click", function() {
		$("#XSLField").val("");
		return false;
	});
	
	$("#fGenThumbs").bind("change", function() {
        if($(this).attr("checked")) {
            $(".smallinput").removeAttr("disabled");
        } else {
            $(".smallinput").attr("disabled", "disabled");
        }
	});
	
	$("#imgswitcher").bind("change", function() {
        if($(this).attr("checked")) {
            $(".imagesizeinput").removeAttr("disabled");
        } else {
            $(".imagesizeinput").attr("disabled", "disabled");
        }
	});
	return 1;
}); // end of main