<?php
require_once 'Config.php';
include_once 'lang/' . Config::LANG;

@session_start();

function resizer($name,$filename,$new_w,$new_h){
	$system=explode('.',$name);
	if (preg_match('/jpg|jpeg/',$system[1])){
		$src_img=imagecreatefromjpeg($name);
	}
	if (preg_match('/png/',$system[1])){
		$src_img=imagecreatefrompng($name);
	}
	if (preg_match('/gif/',$system[1])){
		$src_img=imagecreatefromgif($name);
	}
	$old_x=imageSX($src_img);
    $old_y=imageSY($src_img);
    if ($old_x > $old_y) {
        $thumb_w=$new_w;
        $thumb_h=$old_y*($new_h/$old_x);
    }
    if ($old_x < $old_y) {
        $thumb_w=$old_x*($new_w/$old_y);
        $thumb_h=$new_h;
    }
    if ($old_x == $old_y) {
        $thumb_w=$new_w;
        $thumb_h=$new_h;
    }
    $dst_img=ImageCreateTrueColor($thumb_w,$thumb_h);
	imagecopyresampled($dst_img,$src_img,0,0,0,0,$thumb_w,$thumb_h,$old_x,$old_y); 
	
		
    if (preg_match('/png/',$system[1])) {
        imagepng($dst_img,$filename); 
    } else if(preg_match('/jpg|jpeg/',$system[1])) {
        imagejpeg($dst_img,$filename); 
    } else {
        imagegif($dst_img,$filename); 
    }
    imagedestroy($dst_img); 
    imagedestroy($src_img);
}
function findexts($filename)
{
    $filename = strtolower($filename) ;
    $exts = split("[/\\.]", $filename) ;
    $n = count($exts)-1;
    $exts = $exts[$n];
    return $exts;
} 

$pattern = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_-';
$newname = '';
$ext = '';

foreach($_FILES as $file) {
    if(count($file)) {
        for($i=0;$i<6;$i++)
            $newname .= $pattern{rand(0,61)};
        
       
        switch($file['type']) {
            case 'image/jpeg': $ext = 'jpg'; break;
            case 'image/gif':  $ext = 'gif'; break;
            case 'image/png':  $ext = 'png'; break;
            default: $ext = findexts($file['name']); break;
         }
         
         $new_file_name = $newname . '.' . $ext;
         $new_path = Config::IMG_DIR . $new_file_name;
         
         if(!copy($file['tmp_name'], $new_path)) {
            echo 'Error:' . $L['cannot_upload'];
            exit();
         }
         if(preg_match('/jpg|gif|png/', $ext)) {
             if(Config::ALLOW_IMG && Config::IMG_WIDTH && Config::IMG_HEIGHT) {
                resizer($new_path, $new_path, Config::IMG_WIDTH, Config::IMG_HEIGHT);
             }
             
             if(Config::GENERATE_THUMBS) {
                resizer($new_path, Config::IMG_DIR . 'thumbs/' . $new_file_name, Config::THUMB_WIDTH, Config::THUMB_HEIGHT);
             }
         }
         
         //for security reasons delete temp file
         @unlink($file['tmp_name']);
         
         //print_r($file);
         echo $new_file_name;
     }
}
?>