<?php

$config_file = "../inc/header.inc.php";

$templ = <<<EOS
<?php
/***************************************************************************
*                            Orca Interactive Forum Script
*                              -----------------
*     begin                : Fr Nov 10 2006
*     copyright            : (C) 2006 BoonEx Group
*     website              : http://www.boonex.com/
* This file is part of Orca - Interactive Forum Script
*
* Orca is free software. This work is licensed under a Creative Commons Attribution 3.0 License. 
* http://creativecommons.org/licenses/by/3.0/
*
* Orca is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
* without even the implied warranty of  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the Creative Commons Attribution 3.0 License for more details. 
* You should have received a copy of the Creative Commons Attribution 3.0 License along with Orca, 
* see license.txt file; if not, write to marketing@boonex.com
*
* AUTOMATICALLY GENERATED BY INSTALLATION SCRIPT 
*
***************************************************************************/


\$gConf['ver'] = 'Orca-v.2.0b2';
\$gConf['def_title'] = 'Orca :: Interactive Forum Script';
\$path = '%dir_root%'; // path to orca files


/**
 * directories configuration
 */ 
\$gConf['dir']['error_log'] = \$path . 'log/orca.error.log'; // error log file path
\$gConf['dir']['classes'] = \$path . 'classes/'; // classes directiry path
\$gConf['dir']['js'] = \$path . 'js/'; // js directiry path
\$gConf['dir']['inc'] = \$path . 'inc/';	// include files path
\$gConf['dir']['xmlcache'] = \$path . 'xml/'; // not used
\$gConf['dir']['xml'] = \$path . 'xml/'; // path to integratiom directory
\$gConf['dir']['base'] = \$path;  // base dir
\$gConf['dir']['cache'] = \$path . 'cachejs/'; // js files cache 
\$gConf['dir']['config'] = \$path . 'conf/params.conf'; // config
\$gConf['dir']['layouts'] = \$path . 'layout/'; // layouts dir
\$gConf['dir']['integration'] = \$path . 'xml/orca.php'; // xml integration file path
\$gConf['dir']['editor'] = \$path . '3rdparty/tiny_mce/'; // path to javascript editor
\$gConf['dir']['langs'] = \$path . 'xml/langs/'; // lang files locaiton

/**
 * skin configuration
 */ 
\$skin = isset(\$_GET['skin']) && \$_GET['skin'] ? \$_GET['skin'] : (isset(\$_COOKIE['skin']) ? \$_COOKIE['skin'] : '');
if (preg_match("/^\w+$/",\$skin) && file_exists(\$path . 'layout/' . \$skin))
{
	\$gConf['skin'] = \$skin;
	setcookie ('skin', \$skin);
}
else
{
	\$gConf['skin'] = 'default';
}

/**
 * language configuration
 */ 
\$gConf['lang'] = isset(\$_GET['lang']) && \$_GET['lang'] ? \$_GET['lang'] : (isset(\$_COOKIE['lang']) ? \$_COOKIE['lang'] : '');
if (!preg_match("/^[a-z]{2}$/",\$gConf['lang']))
{
    \$gConf['lang'] = 'en';
}

if (file_exists(\$path . 'layout/base_' . \$gConf['lang']))
{
	setcookie ('lang', \$gConf['lang']);
}
else
{
	\$gConf['lang'] = 'en';
}


/**
 * urls configuration
 */ 
\$gConf['url']['base'] = '%site_url%';	// base url
\$gConf['url']['layouts'] = \$gConf['url']['base'] . 'layout/'; // layouts url
\$gConf['url']['integration'] = \$gConf['url']['base'] . 'xml/orca.php'; // xml integration file url
\$gConf['url']['js'] = \$gConf['url']['base'] . 'js/'; // layouts url
\$gConf['url']['editor'] = \$gConf['url']['base'] . '3rdparty/tiny_mce/'; // url to javascript editor

/**
 * langs pathes configuration
 */ 
if (\$gConf['lang'] && file_exists(\$path . 'layout/base_' . \$gConf['lang']))
{
    \$gConf['dir']['classes'] = \$gConf['dir']['classes'] . \$gConf['lang'] . '/';
    \$gConf['dir']['js'] = \$gConf['dir']['js'] . \$gConf['lang'] . '/';
    \$gConf['url']['js'] = \$gConf['url']['js'] . \$gConf['lang'] . '/';
    \$gConf['skin'] = \$gConf['skin'] . '_' . \$gConf['lang'];
}

/**
 * include custom template patches
 */ 
require_once (\$gConf['dir']['layouts'] . \$gConf['skin'] . '/params.php'); 


/**
 * database configuration
 */ 
\$gConf['db']['host'] = '%db_host%';	// hostname
\$gConf['db']['db'] = '%db_name%';		// database name
\$gConf['db']['user'] = '%db_user%';	// database username
\$gConf['db']['pwd'] = '%db_password%';	// database password
\$gConf['db']['port'] = '%db_port%';    // database port
\$gConf['db']['sock'] = '%db_sock%';    // database socket
\$gConf['db']['prefix'] = 'pre_';       // tables names prefix

/**
 * forum tweaks
 */ 
\$gConf['date_format'] = '%b %d, %Y %H:%i'; // time/date format
\$gConf['topics_per_page'] = 20;	// topics per page
\$gConf['topics_desc_len'] = 64;
\$gConf['live_tracker_desc_len'] = 128;

\$gConf['email']['sender'] = '%sender_email%'; // email sender

\$gConf['user']['admin'] = 'admin'; // admin user

\$gConf['min_point'] = -4; // min points to hide post automatically

\$gConf['online'] = 72000; // online user timeout (seconds) default: 20 min 

\$gConf['integration'] = 'file'; // url - read integration setting from url, file - read integration settings from file

\$xsl_mode = isset(\$_GET['xsl_mode']) && \$_GET['xsl_mode'] ? \$_GET['xsl_mode'] : (isset(\$_COOKIE['xsl_mode']) ? \$_COOKIE['xsl_mode'] : '');
if (preg_match("/^\w+$/",\$xsl_mode))
{
        \$gConf['xsl_mode'] = \$xsl_mode;
        setcookie ('xsl_mode', \$xsl_mode);
}
else
{
        \$gConf['xsl_mode'] = 'auto'; // client, server
}

require_once ('./xml/config.php');

?>
EOS;

$config_arr['sql_file'] = array(
    'name' => "SQL file",
    'ex' => "orca.sql",
    'desc' => "SQL file location",
    'def' => "orca.sql",
    'def_exp' => '
    if ( !( $dir = opendir( "." ) ) )
        return "";
    for ( $i = 0; $file = readdir( $dir ); )
    {
        $arr = explode( "-", $file );
        if ( $arr[0] == "." ) continue;
		if ( $arr[0] == ".." ) continue;        
		if ( !preg_match("/\.sql$/i", $arr[0]) ) continue;
		closedir ($dir);
        return $arr[0];
    }
    closedir( $dir );
    return "";
',  
    'check' => 'return strlen($arg0) >= 4 ? true : false;'
); 

$config_arr['site_url'] = array(
    'name' => "Site URL",
    'ex' => "http://www.mydomain.com/path/",
    'desc' => "Your site URL here (backslash at the end required)",
    'def' => "http://",
    'def_exp' => '
$str = "http://".$_SERVER[\'HTTP_HOST\'].$_SERVER[\'SCRIPT_NAME\'];
return preg_replace("/install\/(index\.php$)/","",$str);',
    'check' => 'return strlen($arg0) >= 10 ? true : false;'
);

$config_arr['sender_email'] = array(
    'name' => "Sender e-mail",
    'ex' => "no-reply@mydomain.com",
    'desc' => "Envelope \"From:\" address for email messages",
    'check' => 'return strlen($arg0) > 0 AND strstr($arg0,"@") ? true : false;'
);

$config_arr['dir_root'] = array(
    'name' => "Directory root",
    'ex' => "/path/to/your/script/files/",
    'desc' => "Path to directory where your Orca files are located.",
    'def_exp' => '
$str = $_SERVER[\'DOCUMENT_ROOT\'].$_SERVER[\'SCRIPT_NAME\'];
return preg_replace("/install\/(index\.php$)/","",$str);',
    'check' => 'return strlen($arg0) >= 1 ? true : false;'
);

$config_arr['db_host'] = array(
    'name' => "Database host name",
    'ex' => "localhost",
    'desc' => "Your MySQL database host name here.",
    'def' => "localhost",
    'check' => 'return strlen($arg0) >= 1 ? true : false;'
);

$config_arr['db_port'] = array(
    'name' => "Database port number",
    'ex' => "3306",
    'desc' => "Your MySQL database port number here. Leave blank for default.",
    'def' => "",
    'check' => 'return strlen($arg0) >= 0 ? true : false;'
);

$config_arr['db_sock'] = array(
    'name' => "Database socket path",
    'ex' => "/tmp/mysql.sock",
    'desc' => "Your MySQL database socket patch here. Leave blank for default.",
    'def' => "",
    'check' => 'return strlen($arg0) >= 0 ? true : false;'
);

$config_arr['db_name'] = array(
    'name' => "Database name",
    'ex' => "YourDatabaseName",
    'desc' => "Your MySQL database name here.",
    'check' => 'return strlen($arg0) >= 1 ? true : false;'
);

$config_arr['db_user'] = array(
    'name' => "Database user",
    'ex' => "YourName",
    'desc' => "Your MySQL database read/write user name here.",
    'check' => 'return strlen($arg0) >= 1 ? true : false;'
);

$config_arr['db_password'] = array(
    'name' => "Database password",
    'ex' => "YourPassword",
    'desc' => "Your MySQL database password here.",
    'check' => 'return strlen($arg0) >= 0 ? true : false;'
);



?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-US" lang="en-US">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Orca :: Installation</title>
<style>

	body
	{
		margin:0;
		padding:0;
		background-color:#999999;
		color:#333366;
		font-family:Arial;
		font-size:12px;
	}

	#main
	{
		position:relative;
		margin:10px auto 0 auto;
		width:780px;
		background-color:white;
	}

	#header
	{		
		position:relative;
		margin:0;
		width:778px;
		height:97px;
		border:1px solid black;
		border-bottom:1px solid #999999;		
		background-image:url(img/header_bg.gif);
	}

	#header #release
	{
		position:absolute;
		top:7px;
		right:7px;
		font-size:11px;
	}

	#header #title
	{
		position:absolute;
		top:54px;
		left:149px;
		font-size:36px;
		font-weight:bold;
	}

	#header #logo
	{
		position:absolute;
		left:15px;
		top:12px;
		width:128px;
		height:128px;
		z-index:1;
	}

	#content
	{		
		position:relative;
		margin:0;
		padding:15px;
		padding-top:50px;
		width:748px;
		height:auto;
		border:1px solid black;		
		border-bottom:1px solid #999999;
		border-top:none;		
	}	

	#content #installation
	{
		position:absolute;	
		font-size:24px;
		top:5px;
		left:150px;
	}

	#footer
	{		
		position:relative;
		margin:0;
		width:778px;
		height:93px;
		border:1px solid black;
		border-top:none;
	}	

	#footer #boonex
	{
		position:absolute;
		border:none;
		width:356px;
		height:82px;
		top:6px;
		left:17px;
	}

	table
	{
		border:1px solid #999999;
		border-bottom:none;
		padding:0;
		margin:0;
		margin-left:125px;
	}

	table td
	{
		padding:3px;
	}

	table td.line
	{
		border-bottom:1px solid #999999;
	}

	table tr.even
	{
		background-color: #EBEBEB;
	}

	table tr.odd
	{
		background-color: #FFFFFF;
	}

	.err
	{
		color:#993333;
		font-weight:bold;
	}

	.ok
	{
		color:#339933;
		font-weight:bold;
	}

</style>
</head>
<body>

	<div id="main">

		<div id="header">
			<img id="logo" src="img/logo.png" />
			<span id="title">Orca Interactive Forum Script</span>
			<span id="release">
				RELEASE: 25.02.2008
				<br />
				VERSION: 2.0.0 beta2
			</span>				
		</div>

		<script language="javascript">
		<!--
			var img = document.getElementById ('logo');
			var imgName = img.src.toUpperCase()
			if (imgName.substring(imgName.length-3, imgName.length) == "PNG")
			{
				var imgID = (img.id) ? "id='" + img.id + "' " : ""
				var imgClass = (img.className) ? "class='" + img.className + "' " : ""
				var imgTitle = (img.title) ? "title='" + img.title + "' " : "title='" + img.alt + "' "
				var imgStyle = "display:inline-block;" + img.style.cssText 
				if (img.align == "left") imgStyle = "float:left;" + imgStyle
				if (img.align == "right") imgStyle = "float:right;" + imgStyle
				if (img.parentElement && img.parentElement.href) imgStyle = "cursor:hand;" + imgStyle		
				var strNewHTML = "<span " + imgID + imgClass + imgTitle
				+ " style=\"" + "width:" + img.width + "px; height:" + img.height + "px;" + imgStyle + ";"
				+ "filter:progid:DXImageTransform.Microsoft.AlphaImageLoader"
				+ "(src=\'" + img.src + "\', sizingMethod='scale');\"></span>" 
				img.outerHTML = strNewHTML
			}
		-->
		</script>

		<div id="content">
			<span id="installation">INSTALLATION</span>

<?php


$err = formCheck ();

if (strlen($err))
{           
	echo <<<EOS
	    <div style="width:500px" class="err">
			$err
		</div>
	    <br />    
EOS;
}           

if ($_POST['Save'] && !strlen($err))
{
	printResults ();
}
else
{
	printForm ();
}

?>

		</div>

		<div id="footer">
			<a target="_blank" href="http://www.boonex.com"><img id="boonex" src="img/boonex.gif"/></a>
		</div>

	</div>

</body>
</html>
<?php


function printForm ()
{
	global $config_arr;

?>
				<form method="post">

				<p>
					1. Upload files to the server
				</p>

				<p>
					2. Change permissions <br />
                        Change permissions (chmod 777) to 
                        <u>inc</u>, 
                        <u>conf</u>, 
                        <u>classes</u>, 
                        <u>js</u>, 
                        <u>layout</u>, 
                        <u>log</u> and 
                        <u>cachejs</u> 
                        directories (via FTP or SSH)
				</p>

				<p>
					3. Creating config file <br />
				</p>
				
				<table width="500" align="center" cellpadding="0" cellspacing="0">
<?php

	$i = 0;
    foreach ( $config_arr as $key => $val )
    {
        $def_exp_text = "";
        if ( strlen($val['def_exp']) )
        {
            $funcbody = $val['def_exp'];
            $func = create_function("", $funcbody);
            $def_exp = $func();
            if ( strlen($def_exp) )
            {
                $def_exp_text = "&nbsp;<font color=\"green\">found</font>";
                $val['def'] = $def_exp;
            }
            else
            {
                $def_exp_text = "&nbsp;<font color=\"red\">not found</font>";
            }

        }

        if ( $error_arr[$key] == 1 ) {
            $st_err = " style=\"background: #FFDDDD;\" ";
        }
        else $st_err = "";

		if (0 == ($i % 2)) $class = "even";
		else $class = "odd";
		
        echo <<<EOS
        <tr class="$class"><td>{$val['name']}</td><td><input $st_err size="30" name="$key" value="{$val['def']}">$def_exp_text</td></tr>
        <tr class="$class"><td>Description:</td><td>$val[desc]</td></tr>
        <tr class="$class"><td class="line">Example:</td><td class="line">{$val['ex']}</td></tr>
EOS;
		++$i;
    }


?>
			</table>

			<p>
				4. AFTER SUBMISSION <br />
					<ul>
						<li>Change permission (chmod 755) to <u>inc</u> directory (via FTP) </li>

						<li>Remove the <u>install</u> directory </li>

						<li>Join with <u>admin</u> username to create a user with admin rights </li>
			</p>

			<p style="padding-left:315px;">
				<input type="hidden" name="Save" value="1" />
				<input type="submit" name="submit" value="submit" />
			</p>

			</form>

<?php
}


function formCheck ()
{
	global $config_arr;

	$err = '';
			
	if ( $_POST['Save'] )
	{
	    foreach ( $config_arr as $key => $val )
		{
			if ( !strlen($val['check']) ) continue;
		    $funcbody = $val['check'];
	        $func = create_function('$arg0', $funcbody);
			if ( !$func($_POST[$key]) )
		    {
	            $err .= "<p>Please, input valid data to {$val['name']} field</p>";
			    $error_arr[$key] = 1;
		    }
			else
			{
				$error_arr[$key] = 0;
			}

			$config_arr[$key]['def'] = $_POST[$key];
		}
	}

	return $err;
}


function printResults ()
{
	global $config_arr;
	global $templ;
	global $config_file;

    do
    {

    	// write config file
	
        foreach ( $config_arr as $key => $val )
        {
            $templ = str_replace ( "%$key%", $_POST[$key], $templ );
        }

        $fp = @fopen ( $config_file, 'w');
        if ( $fp )
        {
            fputs ($fp, $templ);
            fclose ($fp);
            print "<p class=\"ok\">Config file was successfully written to $config_file</p>";
        }
        else
        {
            print "<p class=\"err\">ERROR!!! can not get write access to config file '$config_file'.</p>";
            break;
        }

        // compile languages

        global $gConf;
        chdir ('..');
        require_once ('./inc/header.inc.php');
        require_once ('./classes/BxLang.php');
        require_once ('./xml/lang.php');
        $l = new BxLang ('en', 'default');
        $l->setVisualProcessing(0);
        if ($l->compile ())
        {
            print "<p class=\"ok\">Language files were compiled</p>";
        }
        else
        {
            print "<p class=\"err\">ERROR!!! can not compile language files</p>";
            break;
        }
        chdir ('install');

    	// run sql 	    

    	print run_sql ();

    }
    while (0);
}


function run_sql ( )
{
    global $_POST;

    $db['host']        = $_POST['db_host'];
    $db['host']     .= $_POST['db_port'] ? ':' . $_POST['db_port'] : '';
    $db['host']     .= $_POST['db_sock'] ? ':' . $_POST['db_sock'] : '';
    $db['user']        = $_POST['db_user'];
    $db['passwd']      = $_POST['db_password'];
    $db['db']          = $_POST['db_name'];

    $filename = $_POST['sql_file'];

    $link = @mysql_connect ( $db['host'], $db['user'], $db['passwd']  );

    if ( !$link ) return ('<p class="err">Could not connect to MySQL server: ' . mysql_error() . '</font>');

    if (!@mysql_select_db ($db['db'], $link))
        return ("<p class=\"err\">Could not select database '$db[db]': " . mysql_error()."</font>");

    $s_sql = "";

    if ( !($f = fopen ( $filename, "r" )) )
       return ("<p class=\"err\">Could not open file with sql instructions: $filename </font>");

    $ret .= '<p class="ok">Begin SQL script executing.</p>';

    while ( $s = fgets ( $f, 10240) )
    {
        $s = trim ($s);
        if ( $s[0] == '#' ) continue;
        if ( $s[0] == '' ) continue;


        if ( $s[strlen($s)-1] == ';' )
        {
            $s_sql .= $s;
        }
        else
        {
            $s_sql .= $s;
            continue;
        }

        $res = mysql_query ( $s_sql, $link );
        if ( !$res )
        {
            $ret .= "<p class=\"err\">Error while executing: $s_sql <br />".mysql_error()."</p>";
        }
        $s_sql = "";
    }

    fclose($f);


    $ret .= '<p class="ok">MySQL executing finished.</p>';

	mysql_close($link);

	return $ret;
}

?>
