<?
/**
*                            Orca Interactive Forum Script
*                              ---------------
*     Started             : Mon Mar 23 2006
*     Copyright           : (C) 2007 BoonEx Group
*     Website             : http://www.boonex.com
* This file is part of Orca - Interactive Forum Script
* Creative Commons Attribution 3.0 License
**/


/**
 * Main integration file
 */ 

		/**
		 * determine special user permissions
		 * @param $user username to check
		 * @param return true if user has special permissions in the forum 
         */ 
        if (!function_exists('isSpecialOrcaUser'))
        {
            function isSpecialOrcaUser ($user)
            {
                global $gConf;

                return ($user == $gConf['user']['admin']) ? 1 : 0;
            }		
        }

		/**
		 * determine admin user 
		 * @param $user username to check
		 * @param return true if user has special permissions in the forum 
         */ 		
        if (!function_exists('isOrcaAdmin'))
        {
            function isOrcaAdmin ($user)
            {
                global $gConf;
                return ($gConf['user']['admin'] == $user);
            }
        }        

        // -----------------------------------------

        if ('url' == $gConf['integration'] || !isset($gConf))
        {            	    	
            chdir ('..');
            require_once ("./inc/header.inc.php");
    		require_once ("./classes/Thing.php");
	    	require_once ("./classes/ThingPage.php");
		    require_once ("./classes/Mistake.php");
    		require_once ("./classes/BxDb.php");
	    	require_once ("./classes/DbLogin.php");            

            header ("content-type: text/xml");

            $orca_integration_xml = '<?xml version="1.0" encoding="utf-8"?>';

            $orca_integration_vars = &$_GET;
        }
        else
        {
            $orca_integration_xml = '';
        }

		$orca_integration_xml .= '<bxforum>';
		$orca_integration_xml .= '<time>' . time () . '</time>';

		$action = $orca_integration_vars['action'];
		$user = $orca_integration_vars['user'];
		
		switch ($action)
		{
			/**
			 * get logged in user (initial information about logged in user must be provided in url)
			 */ 
			case 'login_user':

				//  check login and password

				$user = $orca_integration_vars['user'];
				$pwd = $orca_integration_vars['pwd'];

				$db = new DbLogin ();
				if (!$db->checkLogin (array ('username' => $user, 'pwd' => $pwd)))
					$user = '';
				
				$orca_integration_xml .= <<<EOF
			<login_user>$user</login_user>
EOF;
				break;

			
			/**
			 * get user info
			 */
			case 'user_info':
                if (!$user) 
                {
                    $orca_integration_xml .= '<false />' ;
                }
		        else
                {
                    $isSpecialUser = isSpecialOrcaUser ($user);
                    $isOrcaAdmin = isOrcaAdmin ($user);

                    $av = $isSpecialUser ? $gConf['url']['icon'] .'special.gif' : $gConf['url']['icon'] .'basic.gif';
                    if ($isOrcaAdmin) $av = $gConf['url']['icon'] .'admin.gif'; 

                    $profile_url = $gConf['url']['base'] . "user/{$user}.htm";

                    $db = new DbLogin ();
                    $join_date = $db->getUserJoinDate ($user);

                    $orca_integration_xml .= <<<EOF
                <user_info name="$user">				
                    <avatar>$av</avatar>
                    <special>$isSpecialUser</special>
                    <admin>$isOrcaAdmin</admin>
                    <profile_url>$profile_url</profile_url>
                    <profile_onclick>return f.showProfile('$user');</profile_onclick>
                    <join_date>$join_date</join_date>
                </user_info>
EOF;
                }
				break;

			/**
			 * get user permissions
			 */ 
			case 'user_perm':				

                $isOrcaAdmin = isOrcaAdmin ($user);
				$isSpecialUser = isSpecialOrcaUser ($user);

				$read_public = 1;
				$post_public = $user ? 1 : 0;
				$edit_public = $isOrcaAdmin ? 1 : 0;
				$del_public  = $isOrcaAdmin ? 1 : 0;

				$read_private = $isOrcaAdmin || $isSpecialUser ? 1 : 0;
				$post_private = $isOrcaAdmin || $isSpecialUser ? 1 : 0;
				$edit_private = $isOrcaAdmin ? 1 : 0;
				$del_private  = $isOrcaAdmin ? 1 : 0;

				$edit_own = 1;
				$del_own = $isSpecialUser ? 1 : 0;

				$search = $user ? 1 : 0;
				$sticky = isOrcaAdmin ($user) ? 1 : 0;

				$orca_integration_xml .= <<<EOF
			<user_perm name="$user">

				<read_public>$read_public</read_public>
				<post_public>$post_public</post_public>
				<edit_public>$edit_public</edit_public>
				<del_public>$del_public</del_public>

				<read_private>$read_private</read_private>
				<post_private>$post_private</post_private>
				<edit_private>$edit_private</edit_private>
				<del_private>$del_private</del_private>

				<edit_own>$edit_own</edit_own>
				<del_own>$del_own</del_own>

				<search_>$search</search_>
				<sticky_>$sticky</sticky_>

			</user_perm>
EOF;
				break;
			default:
		}

		$orca_integration_xml .= '</bxforum>';

        if ('url' == $gConf['integration'])
            echo $orca_integration_xml;

?>
