# Table structure for table 'language_text'
#

CREATE TABLE `language_text` (
  `language_code` varchar(20) NOT NULL default '',
  `variable` varchar(30) NOT NULL default '',
  `term` varchar(50) NOT NULL default '',
  `text` blob NOT NULL,
  `revised_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `context` text,
  PRIMARY KEY  (`language_code`,`variable`,`term`),
  UNIQUE KEY `idx_unique_lang_term` (`language_code`,`term`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_1','All <code>img</code> elements have an <code>alt</code> attribute.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_10','All <code>img</code> elements have associated images that do not flicker.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_100','<code>blockquote</code> must not be used for indentation.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_101','<code>iframes</code> must have alternate content.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_102','All <code>onclick</code> event handlers have an associated <code>onkeypress</code> event handler.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_103','All <code>ondblclick</code> event handlers have corresponding keyboard-specific functions.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_104','All <code>onmousedown</code> event handlers have an associated <code>onkeydown</code> event handler.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_105','All <code>onmousemove</code> event handlers have corresponding keyboard-specific functions.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_106','All <code>onmouseout</code> event handlers have an associated <code>onblur</code> event handler.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_107','All <code>onmouseover</code> event handlers have an associated <code>onfocus</code> event handler.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_108','All <code>onmouseup</code> event handlers have an associated <code>onkeyup</code> event handler.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_109','Content must be readable when stylesheets are not applied.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_11','Alt text for all <code>img</code> elements contains all text in the image unless the image text is decorative or appears elsewhere in the document.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_110','Words and phrases not in the document\'s primary language are marked.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_111','All complex data tables have a summary.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_112','All data <code>table</code> summaries contain text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_113','All data <code>table</code> summaries are greater than 10 printable characters (English).','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_114','All layout <code>tables</code> have an empty <code>summary</code> attribute or no <code>summary</code> attribute.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_115','All layout tables do not contain <code>caption</code> elements.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_116','<code>b</code> (bold) element is not used.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_117','<code>i</code> (italic) element is not used.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_118','All <code>input</code> elements, <code>type</code> of \"password\", have an explicitly associated <code>label</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_119','All <code>input</code> elements, <code>type</code> of \"checkbox\", have an explicitly associated <code>label</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_12','All <code>img</code> elements with an <code>ismap</code> attribute have a valid <code>usemap</code> attribute.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_120','All <code>input</code> elements, <code>type</code> of \"file\", have an explicitly associated <code>label</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_121','All <code>input</code> elements, <code>type</code> of \"radio\", have an explicitly associated <code>label</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_122','All <code>input</code> elements, <code>type</code> of \"password\", have a label that is positioned close to the control.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_123','All <code>input</code> elements, <code>type</code> of \"checkbox\", have a label that is positioned close to the control.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_124','All <code>input</code> elements, <code>type</code> of \"file\", have a label that is positioned close to the control.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_125','All <code>input</code> elements, <code>type</code> of \"radio\", have a label that is positioned close to the control.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_126','<code>input</code> control, <code>type</code> of \"text\", must have valid default text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_127','Text equivalents for <code>object</code> should be updated if <code>object</code> changes - (classid).','2011-03-01 16:31:02','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_128','Content must be usable when <code>object</code>s are disabled.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_129','<code>object</code> user interface must be accessible - (classid).','2011-03-01 16:31:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_13','All links in all client side image-maps are duplicated within the document.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_131','Use the <code>blockquote</code> element to mark up block quotations.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_132','All active areas in all server-side image maps have duplicate text links in the document.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_133','All layout <code>tables</code> make sense when linearized.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_134','Include non-link, printable characters (surrounded by spaces) between adjacent links.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_135','All <code>img</code> elements with images containing math expressions have equivalent MathML markup.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_136','All data tables contain <code>th</code> elements.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_137','All layout tables do not contain <code>th</code> elements.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_138','All <code>input</code> elements, <code>type</code> of \"text\", have a valid tab index.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_139','All <code>input</code> elements, <code>type</code> of \"radio\", have a valid tab index.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_14','For all <code>img</code> elements, text does not refer to the image by color alone.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_140','All <code>input</code> elements, <code>type</code> of \"password\", have a valid tab index.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_141','All <code>input</code> elements, <code>type</code> of \"checkbox\", have a valid tab index.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_142','All <code>input</code> elements, <code>type</code> of \"file\", have a valid tab index.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_143','Content must have an <code>address</code> for author.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_144','<code>address</code> of page author must be valid.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_145','Links to multimedia have a link to text alternative.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_146','<code>object</code> link to multimedia file require equivalent alternatives (e.g., captions or auditory descriptions of the visual track).','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_147','Document uses <code>link</code> element to describe navigation if it is within a collection.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_148','Document should use LINK for alternate content.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_149','Nested ordered lists should use <code>style</code> to convey list depth.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_15','Alt text for all <code>img</code> elements used as source anchors identifies the destination of the link.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_150','Use CSS, not images, to change list bullets.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_151','All data tables contain a <code>caption</code> unless the table is identified within the document.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_152','Long <code>table</code> header labels require terse substitutes.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_153','Substitutes for <code>table</code> header <code>label</code>s must be terse.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_154','<code>pre</code> element should not be used to create tabular layout.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_155','Link sets must be grouped.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_156','Link groups must have a <code>title</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_157','Link group <code>title</code> must describe the link group.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_158','CSS must be used to hide link groups.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_159','All <code>img</code> elements do not contain a <code>title</code> attribute.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_16','Alt text for all <code>img</code> elements is the empty string (\"\") if the image is decorative.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_160','<code>object</code> may require a long description.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_161','Excessive use of emoticons.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_162','Emoticon missing <code>abbr</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_163','All <code>embed</code> elements have an associated <code>noembed</code> element that contains a text equivalent to the <code>embed</code> element.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_164','<code>noembed</code> must have equivalent content.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_165','<code>embed</code> must have <code>alt</code> attribute.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_166','<code>embed</code> must not have empty Alt text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_167','<code>iframe</code> must not use <code>longdesc</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_168','All radio button groups are marked using <code>fieldset</code> and <code>legend</code> elements.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_169','All <code>select</code> elements containing a large number <code>options</code> also contain <code>optgroup</code> elements.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_17','Sound file must have a text transcript.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_173','Suspicious link text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_174','Each source anchor contains text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_175','Alt text for all <code>img</code> elements used as source anchors is different from the link text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_176','<code>basefont</code> must not be used.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_177','<code>font</code> must not be used.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_178','Alt text for all <code>img</code> elements that are not used as source anchors conveys the same information as the image.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_179','Provide a reference to a glossary.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_18','Anchor should not open new window without warning.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_180','Adjacent links with same resource must be combined.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_181','Anchor must not use Javascript URL protocol.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_182','Do not use background images.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_183','Use the <code>embed</code> element within the <code>object</code> element.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_184','Sites must have a site map.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_185','<code>id</code> attributes must be unique.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_186','All <code>label</code> elements do not contain <code>input</code> elements.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_187','Each <code>input</code> element has only one associated <code>label</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_188','Each label associated with an <code>input</code> element contains text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_189','Each label describes its asssociated <code>input</code> element.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_19','Link text is meaningful when read out of context.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_190','Anchor element must have a <code>title</code> attribute.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_191','The <code>title</code> attribute of all source <code>a</code> (anchor) elements describes the link destination.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_192','Alt text for all <code>input</code> elements with a <code>type</code> attribute value of \"image\" does not use the words \"submit\" or \"button\" (English).','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_193','Alt text for all <code>input</code> elements with a <code>type</code> attribute value of \"image\" contains all non decorative text in the image.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_194','Alt text for all <code>area</code> elements contains all non decorative text in the image area.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_195','Link text does not begin with \"link to\" or \"go to\" (English).','2011-02-01 14:36:01','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_196','Server-side image maps are not used except when image map regions cannot be defined using an available geometric shape.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_197','All source anchors contain text that identifies the link destination.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_198','<code>legend</code> text describes the group of choices.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_199','<code>legend</code> text is not empty or whitespace.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_2','Alt text is not the same as the filename unless author has confirmed it is correct.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_20','Links to multimedia require a text transcript.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_200','<code>legend</code> text is not placeholder text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_201','All <code>frame</code> <code>titles</code> are not empty.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_202','All <code>frame</code> <code>titles</code> do not contain placeholder text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_203','All data table summaries describe navigation and structure of the table.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_204','All <code>input</code> elements, <code>type</code> of \"radio\", have a <code>label</code> containing text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_205','All <code>input</code> elements, <code>type</code> of \"file\", have a <code>label</code> that describes the purpose or function of the control.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_206','All <code>input</code> elements, <code>type</code> of \"checkbox\", have a <code>label</code> containing text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_207','All <code>input</code> elements, <code>type</code> of \"password\", have a <code>label</code> containing text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_208','All <code>select</code> elements have a label that contains text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_209','All <code>select</code> elements have a label that is positioned close to the control.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_21','<code>applet</code> should not use color alone.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_210','All <code>select</code> elements have a label that describes the purpose or function of the control.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_211','All <code>input</code> elements, <code>type</code> of \"text\", have a label that is positioned close to the control.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_212','All <code>textarea</code> elements have a <code>label</code> containing text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_213','All <code>input</code> elements, <code>type</code> of \"text\", have a <code>label</code> containing text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_214','All <code>textarea</code> elements have a <code>label</code> that describes the purpose or function of the control.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_216','All <code>input</code> elements, <code>type</code> of \"file\", have a <code>label</code> containing text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_217','All <code>input</code> elements, <code>type</code> of \"password\", have a <code>label</code> that describes the purpose or function of the control.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_218','All <code>input</code> elements, <code>type</code> of \"text\", have a <code>label</code> that describes the purpose or function of the control.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_219','All <code>input</code> elements, <code>type</code> of \"checkbox\", have a <code>label</code> that describes the purpose or function of the control.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_22','<code>applets</code> cause screen flicker.','2009-06-15 10:40:35','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_220','All <code>input</code> elements, <code>type</code> of \"radio\", have a <code>label</code> that describes the purpose or function of the control.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_221','The luminosity contrast ratio between text and background color is at least 5:1.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_222','The luminosity contrast ratio between link text and background color is at least 5:1.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_223','The luminosity contrast ratio between active link text and background color is at least 5:1.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_224','The luminosity contrast ratio between visited link text and background color is at least 5:1.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_225','Strict doctype is declared.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_226','The contrast between text and background colors is greater than WAI ERT color algorithm threshold.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_227','The contrast between link text and background color is greater than WAI ERT color algorithm threshold.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_228','The contrast between active link text and background color is greater than WAI ERT color algorithm threshold.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_229','The contrast between visited link text and background color is greater than WAI ERT color algorithm threshold.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_23','<code>applet</code> contains a text equivalent in the <code>alt</code> attribute of the <code>applet</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_230','Use <code>thead</code> to group repeated table headers, <code>tfoot</code> for repeated table footers, and <code>tbody</code> for other groups of rows.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_231','Use <code>colgroup</code> and <code>col</code> elements to group columns.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_232','Document validates to specification.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_233','<code>frameset</code> element is not used.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_234','<code>frame</code> element is not used.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_235','The reading direction of all text is correctly marked.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_236','There are no adjacent text and image links having the same destination.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_237','The labels for <code>form</code> submit buttons are unique for all buttons that lead to different results.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_238','All <code>input</code> elements, except those with with a <code>type</code> attribute value of \"image\", do not have an <code>alt</code> attribute.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_239','<code>title</code> attribute for all <code>img</code> elements is absent or the empty string (\"\") if the image is decorative.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_24','Text equivalents for <code>applet</code> must be updated if <code>applet</code> changes.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_240','Text alternative for multimedia file tells the same story and presents the same information as the multimedia file.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_241','Table markup is used for all tabular information.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_242','Table captions identify the table.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_243','Table summaries do not duplicate the table captions.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_244','Data tables that contain both row and column headers use the <code>scope</code> attribute to identify cells.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_245','Data tables that contain more than one row/column of headers use the <code>id</code> and <code>headers</code> attributes to identify cells.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_246','All <code>form</code> fields that are required are indicated to the user as required.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_247','All checkbox groups are marked using <code>fieldset</code> and <code>legend</code> elements.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_248','All visual lists are marked.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_249','Semantic markup is used to indicate emphasized or special text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_25','<code>applet</code> contains a text equivalent in the body of the <code>applet</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_250','All text references do not use shape, size, or relative position alone.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_251','The luminosity contrast ratio between text and background color in all images is at least 5:1.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_252','All text colors or no text colors are set.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_253','The luminosity contrast ratio between text and background color in all images is at least 10:1.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_254','The luminosity contrast ratio between text and background color is at least 10:1.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_255','The luminosity contrast ratio between link text and background color is at least 10:1.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_256','The luminosity contrast ratio between active link text and background color is at least 10:1.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_257','The luminosity contrast ratio between visited link text and background color is at least 10:1.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_258','<code>applet</code> provides a keyboard mechanism to return focus to the parent window.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_259','<code>object</code> provides a keyboard mechanism to return focus to the parent window.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_26','<code>applet</code> user interface must be accessible.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_260','<code>embed</code> provides a keyboard mechanism to return focus to the parent window.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_261','Each section of content is marked with a <code>header</code> element.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_262','All groups of links with a related purpose are marked.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_263','Repeated blocks of content appear in the same <code>frame</code> within the <code>frameset</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_264','All <code>input</code> elements, <code>type</code> of \"submit\", have a valid tab index.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_265','The tab order specified by <code>tabindex</code> attributes follows a logical order.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_266','The document contains a breadcrumb trail if it is part of a collection.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_267','All form submission error messages identify any empty required fields.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_268','All form submission error messages provide assistance in correcting the error.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_269','Form submission data is presented to the user before final acceptance for all irreversable transactions.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_27','<code>blink</code> element is not used.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_270','Unicode right-to-left marks or left-to-right marks are used whenever the HTML bidirectional algorithm produces undesirable results.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_271','All changes in text direction are marked using the <code>dir</code> attribute.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_272','Information deleted using a web page can be recovered.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_273','Reading order direction is marked using the html element\'s <code>dir</code> attribute if the document\'s primary language is read right to left.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_274','Change of context occurs only by user activation unless a warning is provided.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_275','Loading the web page does not cause a new window to open.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_276','Repeated components appear in the same relative order each time they appear.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_28','A \"skip to content\" link appears on all pages with blocks of material prior to the main document.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_29','HTML content has a valid <code>doctype</code> declaration.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_3','Image Alt text is short.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_30','All <code>objects</code> do not flicker.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_301','Provide sufficient contrast between text and background colours.','2011-01-12 12:31:59','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_302','Visited link text colour must contrast sufficiently with its background colour.','2011-01-12 12:28:32','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_303','Active link text colour must contrast sufficiently with its background colour.','2011-01-12 13:55:11','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_304','Selected link text colour must contrast sufficiently with its background colour.','2011-01-12 14:52:12','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_305','Link text colour must contrast sufficiently with its background colour.','2011-01-12 15:15:25','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_306','Text colour must provide high contrast with its background colour','2011-01-12 16:01:29','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_307','Visited link text colour must provide high contrast with its background colour.','2011-01-12 16:29:36','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_308','Active link text colour must provide high contrast with its background colour.','2011-01-12 16:43:01','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_309','Selected link text colour must provide high contrast with its background colour.','2011-01-13 08:58:59','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_31','All <code>frames</code> have a <code>title</code> attribute.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_310','The contrast between the colour of link text and its background is not sufficient to meet WCAG2.0 Level AAA.','2011-01-19 11:19:54','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_32','All <code>frame</code> <code>titles</code> identify the purpose or function of the <code>frame</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_33','The source for each <code>frame</code> is accessible content.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_34','Relationship between <code>frames</code> must be described.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_35','<code>frameset</code> must have a <code>noframes</code> section.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_36','NOFRAMES section must contain text equivalent of FRAMES section.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_37','The header following an <code>h1</code> is <code>h1</code> or <code>h2</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_38','The header following an <code>h2</code> is <code>h1</code>, <code>h2</code> or <code>h3</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_39','The header following an <code>h3</code> is <code>h1</code>, <code>h2</code>, <code>h3</code> or <code>h4</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_4','Non-Decorative images must have Alt text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_40','The header following an <code>h4</code> is <code>h1</code>, <code>h2</code>, <code>h3</code>, <code>h4</code> or <code>h5</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_41','The header following an <code>h5</code> is <code>h6</code> or any header less than <code>h6</code>.','2009-05-28 10:50:01','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_42','All <code>h1</code> elements are not used for formatting.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_43','All <code>h2</code> elements are not used for formatting.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_44','All <code>h3</code> elements are not used for formatting.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_45','All <code>h4</code> elements are not used for formatting.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_46','All <code>h5</code> elements are not used for formatting.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_47','All <code>h6</code> elements are not used for formatting.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_48','Document has required <code>lang</code> attribute(s).','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_49','Document has valid language code.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_5','Important images should not have spacer Alt text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_50','Document contains a <code>title</code> element.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_51','<code>title</code> contains text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_52','<code>title</code> is short.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_53','<code>title</code> is not placeholder text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_54','<code>title</code> describes the document.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_55','<code>input</code> should not use color alone.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_57','All <code>input</code> elements, <code>type</code> of \"text\", have an explicitly associated label.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_58','All <code>input</code> elements with a <code>type</code> attribute value of \"image\" have an <code>alt</code> attribute.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_59','Alt text for all <code>input</code> elements with a <code>type</code> attribute value of \"image\" identifies the purpose or function of the image.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_6','Alt text for all <code>img</code> elements is not placeholder text unless author has confirmed it is correct.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_60','Alt text for all <code>input</code> elements with a <code>type</code> attribute value of \"image\" is less than 100 characters (English) or the user has confirmed that the Alt text is as short as possible.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_61','Image used in <code>input</code> element - Alt text should not be the same as the filename.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_62','Image used in <code>input</code> element - Alt text should not be placeholder text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_63','<code>input</code> element, <code>type</code> of \"text\", must have default text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_64','All <code>area</code> elements have an <code>alt</code> attribute.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_65','Alt text for all <code>area</code> elements identifies the link destination.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_66','<code>area</code> link to sound file must have text transcript.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_68','<code>area</code> should not open new window without warning.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_69','<code>marquee</code> element is not used.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_7','Alt text for all <code>img</code> elements used as source anchors is not empty when there is no other text in the anchor.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_70','<code>menu</code> items should not be used to format text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_71','Auto-redirect must not be used.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_72','Meta refresh is not used with a time-out.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_73','<code>object</code> must not use color alone.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_74','Text equivalents for <code>object</code> should be updated if <code>object</code> changes - (codebase).','2011-03-01 16:32:30','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_75','Content must be usable when <code>object</code> are disabled.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_76','<code>object</code> user interface must be accessible - (codebase).','2011-03-01 16:32:18','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_77','<code>object</code> link to multimedia file must have text transcript.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_78','<code>object</code> must have a <code>title</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_79','<code>object</code> must have a valid <code>title</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_8','A long description is used for each <code>img</code> element that does not have Alt text conveying the same information as the image.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_80','All <code>objects</code> contain a text equivalent of the <code>object</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_81','List items must not be used to format text.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_82','All <code>p</code> elements are not used as headers.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_83','ASCII art should be replaced with image.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_84','ASCII art should have a skipover link.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_86','Color alone should not be used in the <code>script</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_87','<code>script</code> should not cause screen flicker.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_88','Content must be accessible when <code>script</code> is disabled.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_89','User interface for <code>script</code> must be accessible.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_9','All <code>img</code> elements that have a <code>longdesc</code> attribute also have an associated \'d-link\'.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_90','<code>script</code> must have a <code>noscript</code> section.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_91','All <code>select</code> elements have an explicitly associated <code>label</code>.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_92','All <code>select</code> elements do not cause an extreme change in context.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_94','Content must be readable when stylesheets are not applied (SCRIPT).','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_95','All <code>textarea</code> elements have an explicitly associated label.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_96','All <code>textarea</code> elements have a label that is positioned close to control.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_97','Document must be readable when stylesheets are not applied.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_98','Abbreviations must be marked with <code>abbr</code> element.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_CNAME_99','Acronyms must be marked with <code>acronym</code> element.','2008-11-24 13:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_10','Image does flicker.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_100','Text enclosed by <code>blockquote</code> is not a quotation.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_101','Iframe does not have alternate content.','2009-06-05 13:47:17','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_103','Document does not contain keyboard specific functions that correspond to the <code>ondblclick</code> event handler.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_105','Document does not contain keyboard specific functions that correspond to the <code>onmousemove</code> event handler.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_109','Page is not readable when stylesheets are removed.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_11','Image contains some text that is not in Alt text.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_110','Words outside the primary language are not identified.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_111','Table requires a summary.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_113','Short <code>summary</code> is not OK.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_122','Label is not close to input field with type \"password.\"','2009-06-05 13:46:53','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_123','Label is not close to input field with type \"checkbox.\"','2009-06-05 13:46:13','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_124','Label is not close to input field with type \"file.\"','2009-06-05 13:45:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_125','Label is not close to input field with type \"radio.\"','2009-06-05 13:45:26','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_127','Text equivalent is not appropriate for <code>object</code>.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_128','Content is not usable when <code>object</code> is disabled.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_129','<code>object</code> user interface is not accessible.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_131','All long quotations are not marked with the <code>blockquote</code> element.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_132','Document does not contain text links for all active areas of the image map.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_133','<code>table</code> does not make sense when linearized.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_135','Image contains math statement that is not described in the document.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_136','This is a layout table (and use of <code>th</code> is not appropriate appropriate).','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_137','Is this a data table (and requires <code>th</code> elements)','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_14','There is a reference to this image using color alone.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_144','<code>address</code> is not valid for page author.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_145','Link to multimedia file does not have a link to a text alternative.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_146','<code>object</code> does not have equivalent alternative and requires it.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_147','Document does not contain <code>link</code> elements and is within a collection that requires them.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_148','Document has alternate content.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_149','Document does not contain a <code>style</code> element that creates compound numbers for this list.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_15','Alt text does not identify the link destination.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_150','List is using images as list bullets.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_151','Table is not identified within the document and requires a <code>caption</code>.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_154','<code>pre</code> is used to create tabular layout.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_157','<code>title</code> does not describe the link group.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_158','CSS is not provided that allows user to hide link group.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_16','Image is decorative.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_160','<code>object</code> requires a long description and one is not provided.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_164','<code>embed</code> and <code>noembed</code> do not have equivalent content.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_169','<code>options</code> should be grouped by <code>optgroup</code>.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_17','Sound file requires an associated text transcript but does not have it.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_173','Link text is not as descriptive as possible.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_178','Alt text does not convey the same information as the image.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_179','A glossary document is not referenced but is required.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_18','User is not given warning that anchor opens a new window.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_184','Page is part of a collection that requires a site map.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_189','<code>label</code> does not describe its associated control.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_19','Link text is not meaningful when read alone (out of context).','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_191','<code>title</code> does not describe the link destination.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_193','Image contains text that is not in Alt text.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_194','Image contains non decorative text that is not in Alt text.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_196','A client-side image map can be used to replace this server-side image map.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_197','Anchor does not have text that identifies the link destination.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_198','<code>legend</code> text does not describe the group of choices.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_2','Alt text is not appropriate for the image.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_20','Link to multimedia file does not have an associate text transcript.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_200','<code>legend</code> text does not describe the group of choices.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_202','<code>frame</code> <code>title</code> does not describe the purpose or function of the frame.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_203','Summary does not describe navigation and structure of the table.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_205','<code>input</code> element\'s label does not describe the purpose or function of the control.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_209','<code>select</code> element\'s label is not positioned close to the control.','2011-02-01 14:39:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_21','<code>applet</code> uses color alone.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_210','<code>select</code> element\'s label does not describe the purpose or function of the control.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_211','Label is not positioned close to the control.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_214','<code>input</code> element\'s label does not describe the purpose or function of the control.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_217','<code>input</code> element\'s label does not describe the purpose or function of the control.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_218','<code>input</code> element\'s label does not describe the purpose or function of the control.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_219','<code>input</code> element\'s label does not describe the purpose or function of the control.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_22','<code>applet</code> causes screen flicker.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_220','<code>input</code> element\'s label does not describe the purpose or function of the control.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_23','<code>applet</code>\'s Alt text is not equivalent to the applet.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_230','Table does requires <code>thead</code>, <code>tfoot</code> or <code>tbody</code> elements to group repeated table row structures.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_231','Table requires <code>colgroup</code> or <code>col</code> elements to group table column structures.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_235','The reading direction of all text is not correctly marked.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_239','Image is decorative.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_24','<code>applet\'s</code> Alt text is not appropriate.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_240','Text alternative for multimedia file does not tell the same story and present the same information as the multimedia file.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_241','Table markup is not used for all tabular information.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_242','<code>table</code> <code>caption</code> does not identify the table.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_246','All required fields are not indicated to the user as required.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_248','Not all visual lists contain proper markup.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_249','Not all emphasized and special text has semantic markup.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_25','<code>applet</code> does not contain a text equivalent.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_250','There are references to items in the document by shape, size, or relative position alone.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_251','Image contains text with poor contrast ratio.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_253','Image contains text with poor contrast ratio.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_258','<code>applet</code> does not provide a keyboard mechanism that returns focus to the parent window.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_259','<code>object</code> does not provide a keyboard mechanism that returns focus to the parent window.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_26','<code>applet</code> user interface is not accessible.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_260','<code>embed</code> does not provide a keyboard mechanism that returns focus to the parent window.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_261','All sections of the content are not marked with <code>headers</code>.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_262','All groups of links with a related purpose are not marked.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_263','Repeated blocks of content do not appear in the same <code>frame</code> within the <code>frameset</code>.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_265','Tab order does not follow a logical order.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_266','Document does not have a breadcrumb trail and requires it.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_267','Required fields are not identified in all form submission error messages.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_268','All form submission error messages do not provide assistance in correcting the errors.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_269','All form submission data is not presented to the user before final acceptance for all irreversable transactions.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_270','Unicode right-to-left marks or left-to-right marks are not used whenever the HTML bidirectional algorithm produces undesirable results.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_271','All changes in text direction are not marked using the <code>dir</code> attribute.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_272','Information delted using this form can not be recovered.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_274','Script causes change of context.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_275','Loading the page causes a new window to open.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_276','Repeated components do not appear in the same relative order on this page.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_28','Document does not contain a \"skip to content\" link and requires it.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_3','Alt text is not as short as possible.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_30','<code>object</code> causes screen flicker.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_301','No, the contrast ratio is less than 4.5:1 for text, and less than 3:1 for large text','2011-01-12 11:48:53','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_302','No, the contrast ratio is less than 4.5:1 for visited link text, and less than 3:1 for large text','2011-01-12 14:20:33','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_303','No, the contrast ratio is less than  4.5:1 for active link text, and less than 3:1 for large text.','2011-01-12 14:22:08','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_304','No, the contrast ratio is less than  4.5:1 for selected link text, and less than 3:1 for large text.','2011-01-12 15:00:00','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_305','No, the contrast ratio is less than  4.5:1 for link text, and less than 3:1 for large text.','2011-01-12 15:15:25','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_306','No, the contrast ratio is less than  7:1 for  text, and 4.5:1 for large text.','2011-01-12 16:14:13','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_307','No, the contrast ratio is less than  7:1 for visited link text, and less than 4.5:1 for large text.','2011-01-12 16:29:36','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_308','No, the contrast ratio is less than  7:1 for active link text, and less than 4.5:1 for large text.','2011-01-12 16:43:01','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_309','No, the contrast ratio is less than  7:1 for selected link text, and less than 4.5:1 for large text','2011-01-13 08:58:59','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_310','No, the contrast ratio is less than  7:1 for link text, and less than 4.5:1 for large text.','2011-01-13 09:09:37','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_32','<code>frame</code> <code>title</code> does not describe the purpose or function of the <code>frame</code>.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_33','<code>frame</code> source is not accessible.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_34','Relationship between <code>frames</code> is not described.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_36','NOFRAMES section does not contain a text equivalent of the FRAMES section.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_4','Image is not decorative (null Alt text is not OK).','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_42','This <code>h1</code> element is used to format text (not really a section header).','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_43','This <code>h2</code> element is used to format text (not really a section header).','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_44','This <code>h3</code> element is used to format text (not really a section header).','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_45','This <code>h4</code> element is used to format text (not really a section header).','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_46','This <code>h5</code> element is used to format text (not really a section header).','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_47','This <code>h6</code> element is used to format text (not really a section header).','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_5','Image is not decorative (spacer Alt text is not OK).','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_52','<code>title</code> length is not appropriate for the content.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_53','<code>title</code> is not appropriate for the content.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_54','<code>title</code> does not describe the document.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_55','<code>input</code> element uses color alone.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_59','Alt text does not identify the purpose or function of the image.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_6','Alt text is not appropriate for the image.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_60','Alt text is not the shortest possible for the image.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_61','Alt text is not appropriate for the image.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_62','Alt text is not appropriate for the image.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_65','Alt text for <code>area</code> element does not identify the link destination.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_66','Link to sound file does not have an associated text transcript.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_68','User is not warned that <code>area</code> opens in a new window.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_70','<code>menu</code> item is not used appropriately but to format text.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_73','<code>object</code> uses color alone.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_74','Text equivalent is not appropriate for the <code>object</code>.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_75','Content is not usable when <code>object</code> is disabled.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_76','<code>object</code> user interface is not accessible.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_77','Multimedia file missing text transcript.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_8','Image requires a long description and is not properly marked.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_80','<code>object</code> does not contain a text equivalent of the <code>object</code>.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_81','List item is not used appropriately (its used just to format text).','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_82','Text is a header, markup should change.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_83','ASCII art can be replaced by an image.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_84','ASCII art does not have a skipover link.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_86','<code>script</code> uses color alone.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_87','<code>script</code> causes screen flicker.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_88','Content is not accessible when <code>script</code> is disabled.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_89','<code>script</code> user interface is not accessible.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_92','<code>select</code> element causes extreme change of context.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_94','Page is not readable when stylesheets are removed.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_96','Textarea element does not have a label close to it.','2009-06-05 13:47:43','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_97','Page is not readable when stylesheets are removed.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_98','Not all abbreviations are marked with the <code>abbr</code> element.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONFAIL_99','Not all acronyms are marked with the <code>acronym</code> element.','2008-11-24 13:02:46','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_10','Image does not flicker.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_100','Text enclosed by <code>blockquote</code> is a quotation.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_101','Iframe does have alternate content.','2009-06-05 13:49:52','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_103','Document contains keyboard specific functions that correspond to the <code>ondblclick</code> event handler.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_105','Document contains keyboard specific functions that correspond to the <code>onmousemove</code> event handler.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_109','Page is readable when stylesheets are removed.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_11','Any text in image is also in Alt text or text in image is decorative or redundant.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_110','All words outside the primary language are identified.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_111','Table does not require a summary.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_113','Short <code>summary</code> is OK.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_122','Label is close to input field with type \"password.\"','2009-06-05 13:49:18','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_123','Label is close to input field with type \"checkbox.\"','2009-06-05 13:48:54','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_124','Label is close to input field with type \"file.\"','2009-06-05 13:48:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_125','Label is close to input field with type \"radio.\"','2009-06-05 13:48:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_127','Text equivalent is appropriate for <code>object</code>.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_128','Content is usable when <code>object</code> is disabled.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_129','<code>object</code> user interface is accessible.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_131','All long quotations have been marked with the <code>blockquote</code> element.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_132','Document contains text links for all active areas of the image map.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_133','<code>table</code> makes sense when linearized.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_135','Image does not contain any math statements that are not described in the document.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_136','This is a data table (and use of <code>th</code> is appropriate).','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_137','This is a layout table (and does not require <code>th</code> elements).','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_14','There are no references to this image using color alone.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_144','<code>address</code> is valid for page author.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_145','Link to multimedia file has a link to a text alternative.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_146','<code>object</code> has equivalent alternative (or does not require it).','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_147','Document contains <code>link</code> elements or is not within a collection that requires them.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_148','Document does not have an alternate content.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_149','Document contains a <code>style</code> element that creates compound numbers for this list.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_15','Alt text identifies the link destination.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_150','List is not using images as list bullets.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_151','Table is identified within the document and does not require a <code>caption</code>.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_154','<code>pre</code> is not used to create tabular layout.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_157','<code>title</code> describes the link group.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_158','CSS is provided that allows user to hide link group.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_16','Image is not decorative.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_160','<code>object</code> does not require a long description (or one is provided).','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_164','<code>embed</code> and <code>noembed</code> have equivalent content.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_169','<code>options</code> do not require grouping by <code>optgroup</code>.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_17','Sound file has an associated text transcript or does not require it.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_173','Link text is as descriptive as possible.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_178','Alt text conveys the same information as the image.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_179','A glossary document is referenced or not required.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_18','There is a warning to user that anchor opens a new window.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_184','Page is not part of a collection that requires a site map.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_189','<code>label</code> describes its associated control.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_19','Link text is meaningful when read alone (out of context).','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_191','<code>title</code> describes the link destination.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_193','Any text in image is also in Alt text or text in image is decorative.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_194','All non decorative text in image is also in Alt text.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_196','A client-side image map can\'t be used because image map regions are not defined using an available geometric shape.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_197','Anchor has text that identifies the link destination.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_198','<code>legend</code> text describes the group of choices.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_2','Alt text is appropriate for the image.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_20','Link to multimedia file has an associated text transcript.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_200','<code>legend</code> text describes the group of choices.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_202','<code>frame</code> <code>title</code> describes the purpose or function of the frame.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_203','Summary describes navigation and structure of the table.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_205','<code>input</code> element\'s label describes the purpose or function of the control.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_209','<code>select</code> element\'s label is positioned close to the control.','2011-02-01 14:40:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_21','<code>applet</code> does not use color alone.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_210','<code>select</code> element\'s label describes the purpose or function of the control.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_211','Label is positioned close to the control.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_214','<code>input</code> element\'s label describes the purpose or function of the control.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_217','<code>input</code> element\'s label describes the purpose or function of the control.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_218','<code>input</code> element\'s label describes the purpose or function of the control.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_219','<code>input</code> element\'s label describes the purpose or function of the control.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_22','<code>applet</code> does not cause screen flicker.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_220','<code>input</code> element\'s label describes the purpose or function of the control.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_23','<code>applet</code>\'s Alt text is equivalent to the applet.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_230','Table does not require <code>thead</code>, <code>tfoot</code> or <code>tbody</code> elements to group repeated table row structures.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_231','Table does not require <code>colgroup</code> or <code>col</code> elements to group table column structures.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_235','The reading direction of all text is correctly marked.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_239','Image is not decorative.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_24','<code>applet\'s</code> Alt text is appropriate.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_240','Text alternative for multimedia file tells the same story and presents the same information as the multimedia file.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_241','Table markup is used for all tabular information.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_242','<code>table</code> <code>caption</code> identifies the table.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_246','All required fields are indicated to the user as required.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_248','All visual lists contain proper markup.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_249','All emphasized and special text has semantic markup.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_25','<code>applet</code> contains a text equivalent.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_250','There are no references to items in the document by shape, size, or relative position alone.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_251','Image does not contain text with a poor contrast ratio.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_253','Image does not contain text with a poor contrast ratio.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_258','<code>applet</code> provides a keyboard mechanism that returns focus to the parent window.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_259','<code>object</code> provides a keyboard mechanism that returns focus to the parent window.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_26','<code>applet</code> user interface is accessible.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_260','<code>embed</code> provides a keyboard mechanism that returns focus to the parent window.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_261','All sections of the content are marked with <code>headers</code>.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_262','All groups of links with a related purpose are marked.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_263','Repeated blocks of content appear in the same <code>frame</code> within the <code>frameset</code>.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_265','Tab order follows a logical order.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_266','Document has a breadcrumb trail or does not require it.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_267','Required fields are identified in all form submission error messages.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_268','All form submission error messages provide assistance in correcting the error.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_269','All form submission data is presented to the user before final acceptance for all irreversable transactions.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_270','Unicode right-to-left marks or left-to-right marks are used whenever the HTML bidirectional algorithm produces undesirable results.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_271','All changes in text direction are marked using the <code>dir</code> attribute.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_272','Information deleted using this form can be recovered.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_274','Script does not cause change of context.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_275','Loading the page does not cause a new window to open.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_276','Repeated components appear in the same relative order on this page.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_28','Document contians a \"skip to content\" link or does not require it.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_3','Alt text is as short as possible.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_30','<code>object</code> does not cause screen flicker.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_301','Yes, the contrast ratio is greater than 4.5:1 for text, and less than 3:1 for large text','2011-01-12 11:48:53','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_302','Yes, the contrast ratio is at least 4.5:1 for visited link text, and 3:1 for large text.','2011-01-19 10:39:27','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_303','Yes, the contrast ratio is at least 4.5:1 for active link text, and 3:1 for large text.','2011-01-19 10:46:37','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_304','Yes, the contrast ratio is at least 4.5:1 for selected link text, and 3:1 for large text.','2011-01-19 10:50:41','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_305','Yes, the contrast ratio is at least 4.5:1 for standard link text, and 3:1 for large text.','2011-01-19 10:56:26','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_306','Yes, the contrast ratio is at least 7:1 for  text, and 4.5:1 for large text.','2011-01-19 11:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_307','Yes, the contrast ratio is at least 7:1 for visited link text, and 4.5:1 for large text.','2011-01-19 11:08:14','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_308','Yes, the contrast ratio is at least 7:1 for active link text, and 4.5:1 for large text.','2011-01-19 11:12:12','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_309','Yes, the contrast ratio is at least 7:1 for selected link text, and 4.5:1 for large text.','2011-01-19 11:15:43','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_310','Yes, the contrast ratio is at least 7:1 for  link text, and 4.5:1 for large text.','2011-01-19 11:19:54','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_32','<code>frame</code> <code>title</code> describes the purpose or function of the <code>frame</code>.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_33','<code>frame</code> source is accessible.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_34','Relationship between <code>frames</code> is described.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_36','NOFRAMES section contains a text equivalent of the FRAMES section.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_4','Image is decorative (null Alt text is OK).','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_42','This <code>h1</code> element is really a section header.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_43','This <code>h2</code> element is really a section header.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_44','This <code>h3</code> element is really a section header.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_45','This <code>h4</code> element is really a section header.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_46','This <code>h5</code> element is really a section header.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_47','This <code>h6</code> element is really a section header.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_5','Image is decorative (spacer Alt text is OK).','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_52','<code>title</code> length is appropriate for the content.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_53','<code>title</code> is appropriate for the content.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_54','<code>title</code> describes the document.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_55','<code>input</code> element does not use color alone.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_59','Alt text identifies the purpose or function of the image.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_6','Alt text is appropriate for the image.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_60','Alt text is shortest possible for the image.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_61','Alt text is appropriate for the image.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_62','Alt text is appropriate for the image.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_65','Alt text for <code>area</code> element identifies the link destination.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_66','Link to sound file has an associated text transcript.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_68','User is warned that <code>area</code> opens in a new window.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_70','<code>menu</code> item is used appropriately, not to format text.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_73','<code>object</code> does not use color alone.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_74','Text equivalent is appropriate for the <code>object</code>.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_75','Content is usable when <code>object</code> is disabled.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_76','<code>object</code> user interface is accessible.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_77','Multimedia file has a text transcript.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_8','Image does not require a long description or a long description is provided.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_80','<code>object</code> contains a text equivalent of the <code>object</code>.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_81','List item is used appropriately.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_82','Text is not a header, current markup is OK.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_83','ASCII art can not be replaced by an image.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_84','ASCII art has a skipover link.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_86','<code>script</code> does not use color alone.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_87','<code>script</code> does not cause screen flicker.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_88','Content is accessible when <code>script</code> is disabled.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_89','<code>script</code> user interface is accessible.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_92','<code>select</code> element does not cause an extreme change of context.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_94','Page is readable when stylesheets are removed.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_96','Textarea element has a label close to it.','2009-06-05 13:50:10','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_97','Page is readable when stylesheets are removed.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_98','All abbreviations are marked with the <code>abbr</code> element.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DECISIONPASS_99','All acronyms are marked with the <code>acronym</code> element.','2008-11-24 13:02:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_1','All <code>img</code> elements must have an <code>alt</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_10','This error is generated for all <code>img</code> elements that contain a <code>src</code> attribute value that ends with \".gif\" (case insensitive). and have a width and height larger than 25.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_100','This error is generated if any <code>blockquote</code> element is missing a <code>cite</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_101','I<code>frame</code> element must have alternate content [Editor\'s Note - needs work.]','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_102','Any element that contains an <code>onclick</code> attribute must also contain an <code>onkeypress</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_103','Any element that contains an <code>ondblclick</code>  attribute will generate this error.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_104','Any element that contains an <code>onmousedown</code> attribute must also contain an <code>onkeydown</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_105','Any element that contains an <code>onmousemove</code> attribute will generate this error.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_106','Any element that contains an <code>onmouseout</code> attribute must also contain an <code>onblur</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_107','Any element that contains an <code>onmouseover</code> attribute must also contain an <code>onfocus</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_108','Any element that contains an <code>onmouseup</code> attribute must also contain an <code>onkeyup</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_109','The first occurrence of any element that contains a <code>style</code> attribute will generate this error.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_11','This error is generated for all <code>img</code> elements that have a width and height greater than 50.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_110','If the <code>body</code> element contains more than 10 characters (English) then this error will be generated.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_111','The summary is useful when the table has a complex structure (for example, when there are several sets of row or column headers, or when there are multiple groups of columns or rows). The summary may also be helpful for simple data tables that contain many columns or rows of data.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_112','<code>table</code> element cannot contain an empty <code>summary</code> attribute if it\'s a data <code>table</code>.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_113','<code>table</code> element, <code>summary</code> attribute value must be greater than 10 characters (English) if it\'s a data <code>table</code>.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_114','The <code>table</code> element, <code>summary</code> attribute for all layout tables contains no printable characters or is absent.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_115','<code>table</code> element content cannot contain a <code>caption</code> element if it\'s a layout <code>table</code>.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_116','This error will be generated for all B elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_117','This error will be generated for all <code>i</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_118','<code>input</code> element that contains a <code>type</code> attribute value of \"password\" must have an associated <code>label</code> element. An associated <code>label</code> is one in which the <code>for</code> attribute value of the <code>label</code> element is the same as the <code>id</code> attribute value of the <code>input</code> element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_119','<code>input</code> element that contains a <code>type</code> attribute value of \"checkbox\" must have an associated <code>label</code> element. An associated <code>label</code> is one in which the <code>for</code> attribute value of the <code>label</code> element is the same as the <code>id</code> attribute value of the <code>input</code> element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_12','<code>img</code> element may not contain an <code>ismap</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_120','<code>input</code> element that contains a <code>type</code> attribute value of \"file\" must have an associated <code>label</code> element. An associated <code>label</code> is one in which the <code>for</code> attribute value of the <code>label</code> element is the same as the <code>id</code> attribute value of the <code>input</code> element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_121','<code>input</code> element that contains a <code>type</code> attribute value of \"radio\" must have an associated <code>label</code> element. An associated <code>label</code> is one in which the <code>for</code> attribute value of the <code>label</code> element is the same as the <code>id</code> attribute value of the <code>input</code> element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_122','<code>input</code> element with a <code>type</code> attribute value of \"password\" must have an associated <code>label</code> element positioned close to it.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_123','<code>input</code> element with a <code>type</code> attribute value of \"checkbox\" must have an associated <code>label</code> element positioned close to it.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_124','<code>input</code> element with a <code>type</code> attribute value of \"file\" must have an associated <code>label</code> element positioned close to it.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_125','<code>input</code> element with a <code>type</code> attribute value of \"radio\" must have an associated <code>label</code> element positioned close to it.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_126','<code>input</code> element with a <code>type</code> of \"text\" cannot contain a VALUE attribute that is empty or whitespace.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_127','If <code>object</code> element contains a CLASS<code>id</code> attribute and any text then this error will be generated.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_128','If <code>object</code> element contains a CLASS<code>id</code> attribute and any text then this error will be generated.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_129','If <code>object</code> element contains a CLASS<code>id</code> attribute and any text then this error will be generated.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_13','<code>img</code> element must not contain a <code>usemap</code> attribute unless all links in the MAP are duplicated within the document. The MAP element is referred by the USEMAP element\'s <code>usemap</code> attribute. Links within MAP are referred by <code>area</code> elements <code>href</code> attribute contained by MAP element. [Editor\'s Note - can duplicate links appear anywhere within content or must they be part of a link group?]','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_131','If <code>body</code> element content is greater than 10 characters (English) then this error will be generated.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_132','Any <code>img</code> element that contains <code>ismap</code> attribute will generate this error.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_133','This error is generated for all layout <code>tables</code>.  If the <code>table</code> contains <code>th</code> elements then it is a data <code>table</code>. If the <code>table</code> does not contain <code>th</code> elements then it is a layout <code>table</code>.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_134','Adjacent links must be separated by printable characters. [Editor\'s Note - Define adjacent link? Printable characters always?]','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_135','This error is generated for all <code>img</code> elements that have a width and height greater than 100.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_136','Data tables must have <code>th</code> elements while layout tables can not have <code>th</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_137','Data tables must have <code>th</code> elements while layout tables can not have <code>th</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_138','<code>input</code> element that contains a <code>type</code> attribute value of \"text\" must have a <code>tabindex</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_139','<code>input</code> element that contains a <code>type</code> attribute value of \"radio\" must have a <code>tabindex</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_14','This error is generated for all <code>img</code> elements that have a width and height greater than 100.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_140','<code>input</code> element that contains a <code>type</code> attribute value of \"password\" must have a <code>tabindex</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_141','<code>input</code> element that contains a <code>type</code> attribute value of \"checkbox\" must have a <code>tabindex</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_142','<code>input</code> element that contains a <code>type</code> attribute value of \"file\" must have a <code>tabindex</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_143','<code>address</code> element must be present.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_144','This error will be generated for each <code>address</code> element. [Editor\'s Note: What is a valid address?]','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_145','This error will be generated for each <code>a</code> (anchor) element that contains an <code>href</code> attribute value ending with (case insensitive): .wmv, .mpg, .mov, .ram, .aif.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_146','If <code>object</code> element contains a <code>type</code> attribute value of \"video\" then this error will be generated.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_147','The <code>link</code> element can provide metadata about the position of an HTML page within a set of Web units or can assist in locating content with a set of Web units.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_148','<code>head</code> element must contain a <code>link</code> element with a <code>rel</code> attribute value that equals \"alternate\" and a <code>href</code> attribute value that is a valid URL.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_149','OL element that contains a LI element that contains an OL element cannot contain a LI element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_15','<code>img</code> element that is contained by an <code>a</code> (anchor) element must have Alt text that identifies the link destination.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_150','All LI elements in any list (OL or UL) may not contain an <code>img</code> element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_151','Tables must be identified by a <code>caption</code> unless they are identified within the document.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_152','<code>th</code> element content must be less than 20 characters (English) if <code>th</code> element does not contain <code>abbr</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_153','<code>abbr</code> attribute value on <code>th</code> element must be less than 20 characters (English).','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_154','This error is generated for each <code>pre</code> element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_155','<code>a</code> (anchor) elements that occur as part of a set must be contained by OL, UL, DIV, or MA<code>p</code> element. <code>a</code> (anchor) elements are part of a set when there are 3 or more <code>a</code> (anchor) elements with a separation of less than 4 printable characters per element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_156','Elements that contain a link group must have a <code>title</code> attribute. The elements that contain a link group are OL, UL, DIV and MAP. <code>a</code> (anchor) elements are part of a link set when there are 3 or more <code>a</code> (anchor) elements with a separation of less than 4 printable characters per element or all LI items contained by an OL or UL element contain an <code>a</code> (anchor) element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_157','This error is generated for all elements that contain a link group. The elements that contain a link group are OL, UL, DIV and MAP. <code>a</code> (anchor) elements are part of a link set when there are 3 or more <code>a</code> (anchor) elements with a separation of less than 4 printable characters per element or all LI items contained by an OL or UL element contain an <code>a</code> (anchor) element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_158','This error is generated for all elements that contain a link group. The elements that contain a link group are OL, UL, DIV and MAP. <code>a</code> (anchor) elements are part of a link set when there are 3 or more <code>a</code> (anchor) elements with a separation of less than 4 printable characters per element or all LI items contained by an OL or UL element contain an <code>a</code> (anchor) element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_159','<code>img</code> element must not contain the <code>title</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_16','Decorative images must have empty string (\"\") Alt text.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_160','This error is generated for every <code>object</code> element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_161','This error is generated if 4 or more emoticons are detected. [Editor\'s Note - how are emoticons detected?]','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_162','Each emoticon must be contained by a <code>abbr</code> element that has a <code>title</code> attribute labeling the emoticon. [Editor\'s Note - how are emoticons detected?]','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_163','Provide a text equivalent for the <code>embed</code> element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_164','This error is generated for each <code>noembed</code> element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_165','<code>embed</code> element must have an <code>alt</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_166','<code>embed</code> element cannot have <code>alt</code> attribute value of null (\"\") or whitespace.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_167','I<code>frame</code> element cannot contain a <code>longdesc</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_168','<code>form</code> element content must contain both <code>fieldset</code> and <code>legend</code> elements if there are related radio buttons.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_169','<code>select</code> element content that contains 4 or more <code>option</code> elements must contain at least 2 <code>optgroup</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_17','<code>a</code> (anchor) element cannot contain an <code>href</code> attribute value that ends with any of the following (all case insensitive): .wav, .snd, .mp3, .iff, .svx, .sam, .smp, .vce, .vox, .pcm, .aif.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_173','<code>a</code> (anchor) element cannot contain any of the following text (English): \"click here\", \"more\".','2011-02-01 14:41:19','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_174','<code>a</code> (anchor) element must contain text. The text may occur in the anchor text or in the <code>title</code> attribute of the anchor or in the Alt text of an image used within the anchor.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_175','If an image occurs within a link, the Alt text should be different from the link text.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_176','This error is generated for all <code>basefont</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_177','This error is generated for all <code>font</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_178','Alt text must be appropriate and meaningful for image.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_179','If <code>body</code> element content is greater than 10 characters (English) this error will be generated.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_18','<code>a</code> (anchor) element must not contain a <code>target</code> attribute unless the <code>target</code> attribute value is either _self, _top, or _parent.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_180','If 2 adjacent links have the same destination then this error will be generated.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_181','Anchor elements must not have an <code>href</code> attribute value that starts with \"javascript:\".','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_182','The <code>body</code> element must not contain a <code>background</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_183','Each <code>object</code> element must contain an <code>embed</code> element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_184','Each site must have a site map.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_185','Each <code>id</code> attribute value must be unique.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_186','<code>label</code> elements should not contain <code>input</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_187','<code>input</code> element must have only one associated <code>label</code> element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_188','Label must contain some text.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_189','Each label must describe its associated <code>input</code> element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_19','All <code>a</code> (anchor) elements that contains any text will generate this error.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_190','Each source <code>a</code> (anchor) element must have a <code>title</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_191','Each source <code>a</code> (anchor) element must have a <code>title</code> attribute that describes the link destination.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_192','Alt text for form submit buttons must not use the words \"submit\" or \"button\".','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_193','This error is generated for all <code>input</code> elements that have a <code>type</code> of \"image\".','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_194','This error is generated for all <code>area</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_195','Alt text for images used as links should not begin with \"link to\" or \"go to\".','2011-02-01 14:42:13','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_196','A server-side image map should only be used when a client-side image map can not be used.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_197','Anchor text must identify the link destination.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_198','The legend must describe the group of choices.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_199','The legend must describe the group of choices.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_2','<code>img</code> element cannot have <code>alt</code> attribute value that is the same as its <code>src</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_20','<code>a</code> (anchor) element must not contain an <code>href</code> attribute value that ends with (case insensitive): .wmv, .mpg, .mov, .ram, .aif.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_200','The legend must describe the group of choices.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_201','<code>frame</code> <code>title</code> can\'t be empty.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_202','<code>frame</code> <code>title</code> should not contain placeholder text.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_203','The <code>table</code> summary can\'t be garbage text.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_204','<code>input</code> element that contains a <code>type</code> attribute value of \"radio\" must have text in its associated label.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_206','<code>input</code> element that contains a <code>type</code> attribute value of \"checkbox\" must have text in its associated label.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_207','<code>input</code> element that contains a <code>type</code> attribute value of \"password\" must have text in its associated label.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_208','Label must contain some text.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_21','This error is generated for all <code>applet</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_211','<code>input</code> element with a <code>type</code> attribute value of \"text\" must have an associated <code>label</code> element positioned close to it.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_212','<code>textarea</code> element must have text in its associated label.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_213','<code>input</code> element that contains a <code>type</code> attribute value of \"text\" must have text in its associated label.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_216','<code>input</code> element that contains a <code>type</code> attribute value of \"file\" must have text in its associated label.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_22','This error is generated for all <code>applet</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_221','The luminosity contrast ratio between text and background color is at least 5:1','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_222','The luminosity contrast ratio between link text and background color is at least 5:1','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_223','The luminosity contrast ratio between active link text and background color is at least 5:1','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_224','The luminosity contrast ratio between visited link text and background color is at least 5:1','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_225','A \'strict\' doctype must be declared in the document. This can either be the HTML4.01 or XHTML 1.0 strict doctype.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_226','The contrast between text and background color must be greater than the WAI ERT color algorithm threshold.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_227','The contrast between link text and background color must be greater than the WAI ERT color algorithm threshold.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_228','The contrast between active link text and background color must be greater than the WAI ERT color algorithm threshold.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_229','The contrast between visited link text and background color must be greater than the WAI ERT color algorithm threshold.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_23','Use the <code>alt</code> attribute to label an <code>applet</code>.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_230','TODO: Describe the use and benefits of row structure elements. Clearly explain when it is a good idea to use these.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_231','TODO: Describe the use and benefits of row structure elements. Clearly explain when it is a good idea to use these.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_232','Document must validate to declared doctype.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_233','This error is generated for all <code>frameset</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_234','This error is generated for all <code>frame</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_235','The reading direction of all text is correctly marked.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_236','This objective of this technique is to avoid unnecessary duplication that occurs when adjacent text and iconic versions of a link are contained in a document.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_237','The label is especially important if there are multiple submit buttons on the page that each lead to different results.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_238','The <code>input</code> element is used to create many kinds of form controls. Although the HTML DTD permits the alt attribute on all of these, it should be used only on image submit buttons. User agent support for this attribute on other types of form controls is not well defined, and other mechanisms are used to label these controls.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_239','Decorative images must have no title or empty string title.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_24','This error is generated for all <code>applet</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_240','This error will be generated for each <code>a</code> (anchor) element that contains an <code>href</code> attribute value ending with (case insensitive): .wmv, .mpg, .mov, .ram, .aif.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_241','The objective of this technique is to present tabular information in a way that preserves relationships within the information even when users cannot see the table or the presentation format is changed.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_242','If the table has a caption then the caption must identify the table.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_243','The summary and the caption must be different. Caption identifies the table. Summary describes the table contents.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_244','The <code>scope</code> attribute may be used to clarify the scope of any cell used as a header.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_245','id and headers attributes allow screen readers to speak the headers associated with each data cell when the relationships are too complex to be identified using the th element alone or the th element with the scope attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_246','Ensure that the label for any interactive component within Web content makes the component\'s purpose clear.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_247','<code>form</code> element content must contain both <code>fieldset</code> and <code>legend</code> elements if there are related checkbox buttons.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_248','Create lists of related items using list elements appropriate for their purposes.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_249','Semantic markup must be used to mark emphasized or special text so that it can be programmatically determined','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_25','This error is generated for all <code>applet</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_250','Items within a Web unit are referenced in the content not only by shape, size or location, but also in ways that do not depend on visual perception.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_251','Make sure that users can read text that is presented over a background.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_252','If the author specifies that the text must be black, then it may override the settings of the user agent and render a page that has black text (specified by the author) on black background (that was set in the user agent).','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_253','Make sure that users can read text that is presented over a background.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_254','The luminosity contrast ratio between text and background color is at least 10:1','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_255','The luminosity contrast ratio between link text and background color is at least 10:1','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_256','The luminosity contrast ratio between active link text and background color is at least 10:1','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_257','The luminosity contrast ratio between visited link text and background color is at least 10:1','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_258','Ensure that keyboard users do not become trapped in a subset of the content that can only be exited using a mouse or pointing device.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_259','Ensure that keyboard users do not become trapped in a subset of the content that can only be exited using a mouse or pointing device.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_26','This error is generated for all <code>applet</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_260','Ensure that keyboard users do not become trapped in a subset of the content that can only be exited using a mouse or pointing device.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_261','Using the heading elements, h and h1 - h6, to markup the beginning of each section in the content can assist in navigation.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_262','When links are grouped into logical sets (for example, in a navigation bar or main menu that appears on every page in a site) they should be marked up as a unit.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_263','Framesets can be used to group blocks of repeated material.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_264','<code>input</code> element that contains a <code>type</code> attribute value of \"submit\" must have a <code>tabindex</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_265','Provide a logical tab order when the default tab order does not suffice.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_266','Helps the user to visualize how content has been structured and how to navigate back to previous Web units, and may identify the current location within a series of Web units.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_267','Helps the user to visualize how content has been structured and how to navigate back to previous Web units, and may identify the current location within a series of Web units.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_268','Information about the nature and location of the input error is provided in text to enable the users to identify the problem.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_269','Provide users with a way to ensure their input is correct before completing an irreversible transaction.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_27','This error is generated for all <code>blink</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_270','Use Unicode right-to-left marks and left-to-right marks to override the HTML bidirectional algorithm when it produces undesirable results. This may be necessary, for instance, when placing neutral characters such as spaces or punctuation between different directional text runs.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_271','Identify changes in the text direction of text that includes nested directional runs by providing the dir attribute on inline elements. A nested directional run is a run of text that includes mixed directional text, for example, a paragraph in English containing a quoted Hebrew sentence which in turn includes a quotation in French.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_272','Help users with disabilities avoid serious consequences as the result of a mistake when performing an action that cannot be reversed.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_273','The dir attribute allows assistive technology to render the content of the page in its intended order.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_274','Provide a method for activating things that is predictable by the user.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_275','Pages do not disorient users by opening up one or more new windows as soon as a page is loaded.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_276','Maintain consistent layout or presentation between Web units by presenting components that are repeated in these Web units in the same relative order each time they appear. Other components can be inserted between them, but their relative order is not changed.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_28','Provide a mechanism to bypass blocks of material that are repeated on multiple Web units.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_29','Each document must contain a valid <code>doctype</code> declaration.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_3','Image Alt text is short or user must confirm that Alt text is as short as possible.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_30','This error is generated for all <code>object</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_301','The visual presentation of text must have a contrast ratio of at least 4.5:1, except for large-scale text, which must have a contrast ratio of at least 3:1 as determined by a contrast algorithm specified by WCAG2.0. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 10:23:40','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_302','The visual presentation of visited link text must have a contrast ratio of at least 4.5:1, except for large-scale text, which must have a contrast ratio of at least 3:1 as determined by a contrast algorithm specified by WCAG2.0. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 10:22:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_303','The visual presentation of active link text must have a contrast ratio of at least 4.5:1, except for large-scale text, which must have a contrast ratio of at least 3:1 as determined by a contrast algorithm specified by WCAG2.0. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 10:42:48','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_304','The visual presentation of selected link text must have a contrast ratio of at least 4.5:1, except for large-scale text, which must have a contrast ratio of at least 3:1 as determined by a contrast algorithm specified by WCAG2.0. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 10:50:41','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_305','The visual presentation of link text must have a contrast ratio of at least 4.5:1, except for large-scale text, which must have a contrast ratio of at least 3:1 as determined by a contrast algorithm specified by WCAG2.0. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 10:56:26','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_306','The visual presentation of text must have a contrast ratio of at least 7:1, except for large-scale text, which must have a contrast ratio of at least 4.5:1 as determined by a contrast algorithm specified by WCAG2.0. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 11:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_307','The visual presentation of visited link text must have a contrast ratio of at least 7:1, except for large-scale text, which must have a contrast ratio of at least 4.5:1 as determined by a contrast algorithm specified by WCAG2.0. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 11:08:14','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_308','The visual presentation of active link text must have a contrast ratio of at least 7:1, except for large-scale text, which must have a contrast ratio of at least 4.5:1 as determined by a contrast algorithm specified by WCAG2.0. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 11:12:12','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_309','The visual presentation of selected link text must have a contrast ratio of at least 7:1, except for large-scale text, which must have a contrast ratio of at least 4.5:1 as determined by a contrast algorithm specified by WCAG2.0. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 11:15:43','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_31','Each <code>frame</code> element must have a <code>title</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_310','The visual presentation of link text must have a contrast ratio of at least 7:1, except for large-scale text, which must have a contrast ratio of at least 4.5:1 as determined by a contrast algorithm specified by WCAG2.0. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 11:19:54','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_32','<code>frame</code> <code>title</code> must describe the purpose or function of the <code>frame</code>.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_33','<code>frame</code> content should be accessible, like HTML, not just an image.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_34','If <code>frameset</code> element contains 3 or more <code>frame</code> elements then <code>frameset</code> element must contain a <code>longdesc</code> attribute that is a valid URL.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_35','<code>frameset</code> element must contain a <code>noframes</code> section.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_36','This error is generated for each NOFRAMES element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_37','The following header must be equal, one level greater or any level less.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_38','The following header must be equal, one level greater or any level less.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_39','The following header must be equal, one level greater or any level less.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_4','<code>img</code> element cannot have <code>alt</code> attribute value of null (\"\") if WIDTH and HEIGHT attribute values are both greater than 25.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_40','The following header must be equal, one level greater or any level less.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_41','The following header must be equal, one level greater or any level less.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_42','<code>h1</code> may be used for formatting. Use the proper markup.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_43','<code>h2</code> may be used for formatting. Use the proper markup.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_44','<code>h3</code> may be used for formatting. Use the proper markup.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_45','<code>h4</code> may be used for formatting. Use the proper markup.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_46','<code>h5</code> may be used for formatting. Use the proper markup.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_47','<code>h6</code> may be used for formatting. Use the proper markup.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_48','<code>html</code> element must contain a <code>lang</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_49','<code>html</code> element must have a <code>lang</code> attribute value of valid 2 or 3 letter language code according to ISO specification 639.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_5','<code>img</code> element cannot have <code>alt</code> attribute value of whitespace if WIDTH and HEIGHT attribute values are both greater than 25.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_50','<code>title</code> element must be present in <code>head</code> section of document.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_51','<code>title</code> element content cannot be empty or whitespace.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_52','<code>title</code> element content must be less than 150 characters (English).','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_53','<code>title</code> element content can not be any one of (case insensitive) \"the title\", \"title\", \"this is the title\".','2011-02-01 14:44:33','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_54','This error is generated for each <code>title</code> element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_55','All <code>input</code> elements, except those with a <code>type</code> of \"hidden\", will generate this error.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_57','<code>input</code> element that contains a <code>type</code> attribute value of \"text\" must have an associated <code>label</code> element. An associated <code>label</code> is one in which the <code>for</code> attribute value of the <code>label</code> element is the same as the <code>id</code> attribute value of the <code>input</code> element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_58','<code>input</code> element with <code>type</code> of \"image\" must have an <code>alt</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_59','<code>input</code> element with <code>type</code> of \"image\" must have Alt text that identifies the purpose or function of the image.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_6','<code>img</code> element cannot have <code>alt</code> attribute value of \"nbsp\" or \"spacer\".','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_60','<code>input</code> elements must have <code>alt</code> attribute value of less than 100 characters (English).','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_61','<code>input</code> elements cannot have <code>alt</code> attribute values that are the same as their <code>src</code> attribute values.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_62','<code>input</code> elements cannot have <code>alt</code> attribute values that are (case insensitive) (exactly) \"image\", (exactly) \"photo\" or (anywhere) \"bytes\".','2011-02-01 14:43:38','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_63','<code>input</code> elements that have a <code>type</code> attribute value of \"text\" must also contain a <code>value</code> attribute that contains text.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_64','<code>area</code> elements must contain a <code>alt</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_65','Alt text for <code>area</code> element must describe the link destination.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_66','<code>area</code> elements must not contain <code>href</code> attribute values that end with (all case insensitive) .wav, .snd, .mp3, .iff, .svx, .sam, .smp, .vce, .vox, .pcm, .aif','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_68','<code>area</code> element, <code>target</code> attribute values must contain any one of (case insensitive) _self, _top, _parent.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_69','This error will be generated for each <code>marquee</code> element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_7','<code>img</code> element cannot have <code>alt</code> attribute value of null or whitespace if the <code>img</code> element is contained by an A element and there is no other link text.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_70','<code>menu</code> element must contain one LI element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_71','<code>meta</code> elements that contain a <code>http-equiv</code> attribute with a value of \"refresh\" cannot contain a <code>content</code> attribute with a value of (start, case insensitive) \"http://\".','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_72','<code>meta</code> elements that contain a <code>http-equiv</code> attribute with a value of \"refresh\" cannot contain a <code>content</code> attribute with a value of any number greater than zero.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_73','This error is generated for every <code>applet</code> element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_74','If an <code>object</code> element contains a <code>codebase</code> attribute then the <code>codebase</code> attribute value must be null or whitespace.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_75','If an <code>object</code> element contains a <code>codebase</code> attribute then the <code>codebase</code> attribute value must be null or whitespace.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_76','If an <code>object</code> element contains a <code>codebase</code> attribute then the <code>codebase</code> attribute value must be null or whitespace.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_77','<code>object</code> element cannot contain <code>type</code> attribute value of \"video\".','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_78','<code>object</code> element must contain a <code>title</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_79','<code>object</code> element must not have a <code>title</code> attribute with value of null or whitespace.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_8','<code>img</code> element must contain a <code>longdesc</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_80','<code>object</code> element must contain a text equivalent for the object in case the <code>object</code> can\'t be rendered.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_81','OL element should not contain only one LI element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_82','All <code>p</code> element content must not be marked with either <code>b</code>, <code>i</code>, <code>u</code>, <code>strong</code>, <code>font</code>, <code>em</code>.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_83','ASCII art should be replaced with an image. [Editor\'s Note - describe how to detect ASCII art.]','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_84','ASCII art must have a link immediately preceding it that jumps over the ASCII art. [Editor\'s Note - describe how to detect ASCII art. How to detect if skipover link already present?]','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_86','This error will be generated for all <code>script</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_87','This error will be generated for all <code>script</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_88','This error will be generated for all <code>script</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_89','This error will be generated for all <code>script</code> elements.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_9','<code>img</code> element that contains a <code>longdesc</code> attribute must have a following d-link. A d-link must consist of an A element that contains only the text \"d\" or \"D\". The A element must have an <code>href</code> attribute that is a valid URL and is the same as the <code>img</code> element\'s <code>longdesc</code> attribute. The d-link must immediately follow the <code>img</code> element, separated only by whitespace.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_90','<code>script</code> elements that occur within the <code>body</code> must be followed by a <code>noscript</code> section.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_91','<code>select</code> element must have an associated <code>label</code> element. A <code>label</code> element is associated with the <code>select</code> element if the <code>for</code> attribute value of the <code>label</code> is the same as the <code>id</code> attribute of the <code>select</code> element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_92','<code>select</code> element cannot contain <code>onchange</code> attribute.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_94','This error is generated for each SCRIPT element.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_95','All <code>textarea</code> elements must have an explicitly associated label.','2009-04-14 10:45:04','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_96','<code>textarea</code> element must have an associated <code>label</code> element that is positioned close to it.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_97','This error will be generated for each <code>link</code> element that has a <code>rel</code> attribute with a value of \"stylesheet\".','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_98','If <code>body</code> element content is greater than 10 characters (English) this error will be generated.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_DESC_99','If <code>body</code> element content is greater than 10 characters (English) then this error will be generated.','2008-11-24 13:01:58','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_1','<code>img</code> element missing <code>alt</code> attribute.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_10','Image (GIF) may flicker.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_100','<code>blockquote</code> may be used for indentation.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_101','<code>iframe</code> missing alternate content.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_102','SCRIPT not keyboard accessible - <code>onclick</code> missing <code>onkeypress</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_103','<code>script</code> may not be keyboard accessible - <code>ondblclick</code> requires keyboard specific functions.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_104','<code>onmousedown</code> event missing <code>onkeydown</code> event.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_105','<code>script</code> may not be keyboard accessible - <code>onmousemove</code> requires keyboard specific functions.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_106','<code>script</code> not keyboard accessible - <code>onmouseout</code> missing <code>onblur</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_107','<code>onmouseover</code> event handler missing <code>onfocus</code> event handler.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_108','<code>onmouseup</code> event handler missing <code>onkeyup</code> event handler.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_109','Content may not be readable when stylesheets are removed.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_11','Image may contain text that is not in Alt text.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_110','Words or phrases that are not in the document\'s primary language may not be identified.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_111','Table may require a summary.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_112','Data <code>table</code> <code>summary</code> is empty.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_113','Data <code>table</code> <code>summary</code> is less than 10 characters.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_114','Layout <code>table</code> has a <code>summary</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_115','Layout <code>table</code> contains a <code>caption</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_116','<code>b</code> (bold) element used.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_117','<code>i</code> (italic) element used.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_118','<code>input</code> element, <code>type</code> of \"password\", missing an associated <code>label</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_119','<code>input</code> element, <code>type</code> of \"checkbox\", missing an associated <code>label</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_12','Server-side image map used without client-side image map.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_120','<code>input</code> element, <code>type</code> of \"file\", missing an associated <code>label</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_121','<code>input</code> element, <code>type</code> of \"radio\", missing an associated <code>label</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_122','<code>input</code> element <code>label</code>, <code>type</code> of \"password\" is not positioned close to control.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_123','<code>input</code> element <code>label</code>, <code>type</code> of \"checkbox\" is not positioned close to control.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_124','<code>input</code> element <code>label</code>, <code>type</code> of \"file\", is not positioned close to control.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_125','<code>input</code> element <code>label</code>, <code>type</code> of \"radio\", is not positioned close to control.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_126','Text <code>input</code> element missing valid default text.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_127','Text equivalent for <code>object</code> may not have been updated when <code>object</code> changed.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_128','Content may not be usable when <code>object</code> is disabled.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_129','<code>object</code> user interface may not be accessible.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_13','Client-side image map missing duplicate text links.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_131','Long quotations may not be marked using the <code>blockquote</code> element.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_132','Server-side image map may be missing equivalent text links.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_133','Layout <code>table</code> may not linearize.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_134','Adjacent links are not separated properly.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_135','Image may contain math statements.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_136','Data <code>table</code> may require <code>th</code> elements.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_137','Layout <code>table</code> may be misusing <code>th</code> elements.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_138','<code>input</code> element, <code>type</code> of \"text\", missing a tab index.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_139','<code>input</code> element, <code>type</code> of \"radio\", missing a tab index.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_14','Image may be using color alone.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_140','<code>input</code> element, <code>type</code> of \"password\", missing a tab index.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_141','<code>input</code> element, <code>type</code> of \"checkbox\", missing a tab index.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_142','<code>input</code> element, <code>type</code> of \"file\", missing a tab index.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_143','Content missing <code>address</code> of page author.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_144','<code>address</code> of page author may be incorrect.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_145','Link to multimedia may be missing a link to text alternative.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_146','<code>object</code> link to multimedia file may be missing equivalent alternative.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_147','Document may not be using <code>link</code> element to describe navigation.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_148','Document may be missing <code>link</code> element for alternate content.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_149','Nested ordered list may not be using <code>style</code> to convey list depth.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_15','Alt text may not identify the link destination.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_150','May be using images as list bullets.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_151','Data <code>table</code> may require a <code>caption</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_152','Long <code>table</code> header <code>label</code> missing terse substitute.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_153','Substitute for <code>table</code> header is not terse.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_154','<code>pre</code> element may be misused to create tabular layout.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_155','Link set not grouped.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_156','Link group missing <code>title</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_157','Link group <code>title</code> may not describe the link group.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_158','CSS not used to hide link group.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_159','IMG using <code>title</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_16','Alt text is not empty and image may be decorative.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_160','<code>object</code> may require a long description.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_161','Excessive use of emoticons.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_162','Emoticon missing <code>abbr</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_163','<code>embed</code> element missing <code>noembed</code> element.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_164','<code>noembed</code> may not have equivalent content to <code>embed</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_165','<code>embed</code> missing <code>alt</code> attribute.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_166','<code>embed</code> has null Alt text.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_167','<code>iframe</code> contains a <code>longdesc</code> attribute.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_168','Form missing <code>fieldset</code> and <code>legend</code> to group multiple radio buttons.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_169','<code>optgroup</code> may be required for large number of <code>options</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_17','Sound file may be missing text transcript.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_173','Suspicious link text (contains placeholder text).','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_174','Anchor contains no text.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_175','Anchor contains redundant text.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_176','<code>basefont</code> used.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_177','<code>font</code> used.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_178','Alt text does not convey the same information as the image.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_179','Reference to glossary may be missing.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_18','Anchor that opens new window may be missing warning.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_180','Adjacent links with same resource are not combined.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_181','Anchor using Javascript URL protocol.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_182','Using a background image.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_183','<code>object</code> element missing <code>embed</code> element.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_184','Site missing site map.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_185','<code>id</code> attribute is not unique.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_186','<code>label</code> element contains an <code>input</code> element.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_187','<code>input</code> element has more than one associated <code>label</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_188','Label text is empty.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_189','<code>label</code> may not describe its associated control.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_19','Link text may not be meaningful.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_190','Anchor element missing a <code>title</code> attribute.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_191','Anchor\'s <code>title</code> may not describe the link destination.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_192','<code>input</code> element <code>type</code> of \"image\" uses redundant words in Alt text.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_193','Form submit button image may contain text that is not in Alt text.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_194','<code>area</code> image may contain text that is not in Alt text.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_195','Link text begins with \"link to\" or \"go to\".','2011-02-01 14:43:13','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_196','Server-side image map may be used improperly.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_197','Anchor text may not identify the link destination.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_198','<code>legend</code> text may not describe the group of choices.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_199','<code>legend</code> text is empty.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_2','Image has suspicious Alt text (same as filename).','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_20','Link to multimedia may be missing a text transcript.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_200','<code>legend</code> text may be placeholder text.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_201','<code>frame</code> <code>titles</code> is empty.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_202','<code>frame</code> <code>title</code> contains placeholder text.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_203','Data <code>table</code> <code>summary</code> may not describe navigation and structure of the table.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_204','<code>input</code> element, <code>type</code> of \"radio\", has no text in <code>label</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_205','<code>input</code> element, <code>type</code> of \"file\", label may not describe the purpose or function of the control.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_206','<code>input</code> element, <code>type</code> of \"checkbox\", has no text in <code>label</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_207','<code>input</code> element, <code>type</code> of \"password\", has no text in <code>label</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_208','Label text is empty for <code>select</code> element.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_209','<code>select</code> element\'s label is not positioned close to control.','2011-02-01 14:42:28','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_21','<code>applet</code> may use color alone.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_210','<code>select</code> element\'s label may not describe the purpose or function of the control.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_211','<code>input</code> element <code>label</code>, <code>type</code> of \"text\", is not positioned close to control.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_212','<code>textarea</code> has no text in <code>label</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_213','<code>input</code> element, <code>type</code> of \"text\", has no text in <code>label</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_214','<code>textarea</code> element label may not describe the purpose or function of the control.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_216','<code>input</code> element, <code>type</code> of \"file\", has no text in <code>label</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_217','<code>input</code> element, <code>type</code> of \"password\", label may not describe the purpose or function of the control.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_218','<code>input</code> element, <code>type</code> of \"text\", label may not describe the purpose or function of the control.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_219','<code>input</code> element, <code>type</code> of \"checkbox\", label may not describe the purpose or function of the control.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_22','<code>applet</code> may flicker.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_220','<code>input</code> element, <code>type</code> of \"radio\", label may not describe the purpose or function of the control.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_221','Poor color contrast between text and background color.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_222','Poor color contrast between link text and background color.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_223','Poor color contrast between active link text and background color.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_224','Poor color contrast between visited link text and background color.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_225','Strict doctype is not declared.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_226','Poor contrast between text and background color (WAI ERT algorithm).','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_227','Poor contrast between link text and background color (WAI ERT algorithm).','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_228','Poor contrast between active link text and background color (WAI ERT algorithm).','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_229','Poor contrast between visited link text and background color (WAI ERT algorithm).','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_23','<code>applet</code> may not contain a text equivalent in the <code>alt</code> attribute.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_230','Table may require <code>thead</code>, <code>tfoot</code> and <code>tbody</code> elements to group repeated table row structures.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_231','Table may require <code>colgroup</code> and <code>col</code> elements to group table columns.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_232','Document does not validate.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_233','<code>frameset</code> element used.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_234','<code>frame</code> element used.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_235','The reading direction of all text may not be correctly marked','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_236','Adjacent text and image link have the same destination.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_237','<code>form</code> submit button label is not unique.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_238','<code>input</code> element has <code>alt</code> attribute.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_239','<code>img</code> has <code>title</code> attribute and image may be decorative.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_24','Text equivalent may not have been updated when <code>applet</code> changed.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_240','Text alternative for multimedia file may not tell the same story and present the same information as the multimedia file.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_241','Tabular information may be missing table markup.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_242','Table caption may not identify the table.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_243','Table summary duplicates the table caption.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_244','Data table with both row and column headers does not use <code>scope</code> to identify cells.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_245','Data table with more than one row/column of headers does not use <code>id</code> and <code>headers</code> attributes to identify cells.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_246','All required <code>form</code> fields may not be indicated as required.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_247','Form missing <code>fieldset</code> and <code>legend</code> to group multiple checkbox buttons.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_248','Visual lists may not be properly marked.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_249','Emphasized or special text may be missing semantic markup.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_25','<code>applet</code> body may not contain a text equivalent.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_250','Text may refer to items by shape, size, or relative position alone.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_251','Image may contain text with poor contrast.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_252','All text colors are not set.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_253','This image may contain text with poor contrast.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_254','Poor color contrast between text and background color.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_255','Poor color contrast between link text and background color.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_256','Poor color contrast between active link text and background color.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_257','Poor color contrast between visited link text and background color.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_258','<code>applet</code> may not provide a keyboard mechanism to return focus to the parent window.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_259','<code>object</code> may not provide a keyboard mechanism to return focus to the parent window.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_26','<code>applet</code> user interface may not be accessible.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_260','<code>embed</code> may not provide a keyboard mechanism to return focus to the parent window.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_261','Sections may not be marked with headers.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_262','Groups of links with a related purpose are not marked.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_263','Repeated blocks of content may not appear in the same <code>frame</code> within the <code>frameset</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_264','<code>input</code> element, <code>type</code> of \"submit\", missing a tab index.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_265','Tab order may not follow logical order.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_266','Document may require a breadcrumb trail.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_267','Form submission error messages may not identify empty required fields.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_268','Form submission error messages may not provide assistance.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_269','Form submission data may not be presented to the user before final acceptance of an irreversable transaction.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_27','<code>blink</code> element used.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_270','Unicode right-to-left marks or left-to-right marks may be required.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_271','<code>dir</code> attribute may be required to identify changes in text direction.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_272','Form may delete information without allowing for recovery.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_273','Right to left reading order not marked or marked incorrectly.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_274','Change of context may occur without user activation.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_275','Loading web page may cause new window to open.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_276','Repeated components may not appear in the same relative order each time they appear.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_28','Document may be missing a \"skip to content\" link.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_29','<code>doctype</code> declaration missing.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_3','Image Alt text may be too long.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_30','<code>object</code> may flicker.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_301','The contrast between the colour of text and its background for the element is not sufficient  to meet WCAG2.0 Level AA.','2011-01-19 10:13:24','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_302','The contrast between the colour of visited link text and its background for the element is not sufficient  to meet WCAG2.0 Level AA.','2011-01-19 10:22:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_303','The contrast between the colour of active link text and its background is not sufficient to meet WCAG2.0 Level AA.','2011-01-19 10:42:48','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_304','The contrast between the colour of selected link text and its background is not sufficient to meet WCAG2.0 Level AA.','2011-01-19 10:50:41','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_305','The contrast between the colour of link text and its background is not sufficient to meet WCAG2.0 Level AA.','2011-01-19 10:56:26','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_306','The contrast between the colour of text and its background is not sufficient to meet WCAG2.0 Level AAA.','2011-01-19 11:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_307','The contrast between the colour of visited link text and its background is not sufficient to meet WCAG2.0 Level AAA.','2011-01-19 11:08:14','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_308','The contrast between the colour of active link text and its background is not sufficient to meet WCAG2.0 Level AAA.','2011-01-19 11:12:12','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_309','The contrast between the colour of selected link text and its background is not sufficient to meet WCAG2.0 Level AAA.','2011-01-19 11:15:43','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_31','<code>frame</code> missing <code>title</code> attribute.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_310','Link text colour must provide high contrast with its background colour.','2011-01-19 19:47:57','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_32','<code>frame</code> <code>title</code> may not describe the purpose or function of the <code>frame</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_33','<code>frame</code> source may not be accessible content.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_34','Relationship between <code>frames</code> may not be described.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_35','<code>frameset</code> missing <code>noframes</code> section.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_36','NOFRAMES section may not contain a text equivalent of FRAMES section.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_37','Header nesting - header following <code>h1</code> is incorrect.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_38','Header nesting - header following <code>h2</code> is incorrect.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_39','Header nesting - header following <code>h3</code> is incorrect.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_4','Image has suspicious Alt text (empty string \"\").','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_40','Header nesting - header following <code>h4</code> is incorrect.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_41','Header nesting - header following <code>h5</code> is incorrect.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_42','<code>h1</code> may be used for formatting.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_43','<code>h2</code> may be used for formatting.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_44','<code>h3</code> may be used for formatting.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_45','<code>h4</code> may be used for formatting.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_46','<code>h5</code> may be used for formatting.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_47','<code>h6</code> may be used for formatting.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_48','Document language not identified.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_49','Document has invalid language code.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_5','Image has suspicious Alt text (all spaces).','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_50','Document missing <code>title</code> element.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_51','<code>title</code> element is empty.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_52','<code>title</code> text may be too long.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_53','<code>title</code> contains placeholder text.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_54','<code>title</code> might not describe the document.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_55','<code>input</code> possibly using color alone.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_57','<code>input</code> element, <code>type</code> of \"text\", missing an associated label.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_58','Image used for <code>input</code> element is missing Alt text.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_59','Image used for <code>input</code> element may have Alt text that does not identify the purpose or function as the image.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_6','Image has suspicious Alt text (placeholder text).','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_60','Image used for <code>input</code> element has long Alt text.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_61','Image used in <code>input</code> element - Suspicious Alt text (same as filename).','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_62','Image used in <code>input</code> element - Suspicious Alt text (placeholder).','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_63','<code>input</code> element, <code>type</code> of \"text\", missing default text.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_64','Imagemap <code>area</code> element missing <code>alt</code> attribute.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_65','Alt text for <code>area</code> element may not identify the link destination.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_66','<code>area</code> link to sound file may be missing text transcript.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_68','<code>area</code> opens new window may be missing warning.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_69','<code>marquee</code> element used.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_7','Image used as anchor is missing valid Alt text.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_70','<code>menu</code> item may be used to format text.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_71','Auto-redirect used.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_72','Meta refresh with a time-out is used.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_73','<code>object</code> may be using color alone.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_74','Text equivalent for <code>object</code> may not have been updated when <code>object</code> changed.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_75','Content may not be usable when <code>object</code> is disabled.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_76','<code>object</code> user interface may not be accessible.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_77','<code>object</code> link to multimedia file may be missing text transcript.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_78','<code>object</code> missing <code>title</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_79','<code>object</code> has invalid <code>title</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_8','<code>img</code> element may require a long description.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_80','<code>object</code> may be missing a text equivalent.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_81','List item used to format text.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_82','<code>p</code> element may be misused (could be a header).','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_83','ASCII art not replaced with image.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_84','ASCII art possibly missing a skipover link.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_86','<code>script</code> may use color alone.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_87','<code>script</code> may cause screen flicker.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_88','Content may not be accessible when <code>script</code> is disabled.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_89','<code>script</code> user interface may not be accessible.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_9','IMG missing d-link.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_90','<code>script</code> must have a <code>noscript</code> section.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_91','<code>select</code> element missing an associated <code>label</code>.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_92','<code>select</code> element may cause extreme change in context.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_94','Content possibly not readable when stylesheets are removed (SCRIPT).','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_95','<code>textarea</code> element missing an associated label.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_96','<code>textarea</code> label is not positioned close to control.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_97','Document may not be readable when stylesheets are removed.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_98','Abbreviations may not be marked with <code>abbr</code> element.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_ERR_99','Acronyms may not be marked with <code>acronym</code> element.','2008-11-24 13:01:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_1','1. All <code>img</code> elements have an <code>alt</code> attribute.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_10','1. All <code>img</code> elements have associated images that do not flicker.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_100','1. All text contained by the <code>blockquote</code> element is a quote.\n2. The <code>blockquote</code> element should not be used to simply indent text.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_101','1. TODO.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_102','1. All <code>onclick</code> event handlers have an associated <code>onkeypress</code> event handler.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_103','1. All <code>ondblclick</code> event handlers have corresponding keyboard-specific functions.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_104','1. All <code>onmousedown</code> event handlers have an associated <code>onkeydown</code> event handler.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_105','1. All <code>onmousemove</code> event handlers have corresponding keyboard-specific functions.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_106','1. All <code>onmouseout</code> event handlers have an associated <code>onblur</code> event handler.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_107','1. All <code>onmouseover</code> event handlers have an associated <code>onfocus</code> event handler.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_108','1. All <code>onmouseup</code> event handlers have an associated <code>onkeyup</code> event handler.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_109','1. The document must be readable when stylesheets are not applied.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_11','1. Alt text for all <code>img</code> elements contains all text in the image unless the image text is decorative or appears elsewhere in the content.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_110','1. Words and phrases not in the document\'s primary language are marked','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_111','1. All complex data tables have a summary.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_112','1. All data <code>table</code> summaries contain text.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_113','1. All data <code>table</code> summaries are greater than 10 printable characters (English).','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_114','1. All layout <code>tables</code> have an empty <code>summary</code> attribute or no <code>summary</code> attribute.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_115','1. All layout tables do not contain <code>caption</code> elements.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_116','1. <code>b</code> (bold) element is not used.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_117','1. <code>i</code> (italic) element is not used.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_118','1. All <code>input</code> elements, with <code>type</code> of \"password\", have an explicitly associated <code>label</code>.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_119','1. All <code>input</code> elements, with <code>type</code> of \"checkbox\", have an explicitly associated <code>label</code>.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_12','1. All <code>img</code> elements with an <code>ismap</code> attribute have a valid <code>usemap</code> attribute.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_120','1. All <code>input</code> elements, with <code>type</code> of \"file\", have an explicitly associated <code>label</code>.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_121','1. All <code>input</code> elements, <code>type</code> of \"radio\", have an explicitly associated <code>label</code>.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_122','1. All <code>input</code> elements, <code>type</code> of \"password\", have a label that is positioned close to the control.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_123','1. All <code>input</code> elements, <code>type</code> of \"checkbox\", have a label that is positioned close to the control.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_124','1. All <code>input</code> elements, <code>type</code> of \"file\", have a label that is positioned close to the control.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_125','1. All <code>input</code> elements, <code>type</code> of \"radio\", have a label that is positioned close to the control.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_126','1. The VALUE attribute value for text <code>input</code> elements must contain default text.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_127','1. The text equivalent is expected to be valid for the <code>object</code>.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_128','1. The content is expected to be usable with the <code>object</code> removed or disabled.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_129','1. The user interface for all <code>object</code>S must be keyboard accessible.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_13','1. All links in all client side image-maps are duplicated within the document.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_131','1. Blockquotes within the document are expected to be marked using the <code>blockquote</code> element.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_132','1. All active areas in all server-side image maps have duplicate text links in the document.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_133','1. All layout <code>tables</code> make sense when linearized.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_134','1. Adjacent <code>a</code> (anchor) elements are expected to have at least one printable character between them.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_135','1. All <code>img</code> elements with images containing math expressions have equivalent MathML markup.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_136','1. All data tables contain at least one row or column of <code>th</code> elements.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_137','1. All layout tables do not contain <code>th</code> elements.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_138','1. All <code>input</code> elements, <code>type</code> of \"text\", have a valid tab index.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_139','1. All <code>input</code> elements, <code>type</code> of \"radio\", have a valid tab index.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_14','1. For all <code>img</code> elements, text does not refer to the image by color alone.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_140','1. All <code>input</code> elements, <code>type</code> of \"password\", have a valid tab index.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_141','1. All <code>input</code> elements, <code>type</code> of \"checkbox\", have a valid tab index.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_142','1. All <code>input</code> elements, <code>type</code> of \"file\", have a valid tab index.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_143','1. Each content must contain a valid <code>address</code> for the page author.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_144','1. Each content must contain a valid <code>address</code> for the page author.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_145','1. Links to multimedia have a link to text alternative.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_146','1. Each multimedia <code>object</code> must have a text equivalent.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_147','1. Document uses <code>link</code> element to describe navigation if it is within a collection.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_148','1. Alternate documents must be linked using the <code>link</code> element.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_149','1. TODO.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_15','1. Alt text for all <code>img</code> elements used as source anchors identifies the destination of the link.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_150','1. TODO.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_151','1. All data tables contain a <code>caption</code> unless the table is identified within the document.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_152','1. Long TH labels must have a valid <code>abbr</code> attribute value.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_153','1. <code>abbr</code> attribute values are expected to be less than 20 characters.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_154','1. <code>pre</code> elements should not be used to created tabular layout.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_155','1. TODO.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_156','1. TODO.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_157','1. TODO.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_158','1. TODO.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_159','1. All <code>img</code> elements do not contain a <code>title</code> attribute.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_16','1. Alt text for all <code>img</code> elements is the empty string (\"\") if the image is decorative.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_160','1. The <code>object</code> is expected to have a long description.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_161','1. TODO.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_162','1. TODO.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_163','1. All <code>embed</code> elements have an associated <code>noembed</code> element that contains a text equivalent to the <code>embed</code> element.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_164','1. TODO.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_165','1. TODO.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_166','1. TODO.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_167','1. TODO.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_168','1. All radio button groups are marked using <code>fieldset</code> and <code>legend</code> elements.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_169','1. All <code>select</code> elements containing a large number <code>options</code> also contain <code>optgroup</code> elements.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_17','1. The sound file is expected to have an associated text transcript or does not require it.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_173','1. TODO.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_174','1. Each source anchor contains text.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_175','1. Alt text for all <code>img</code> elements used as source anchors is different from the link text.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_176','1. The document must not contain any <code>basefont</code> elements.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_177','1. The document must not contain any <code>font</code> elements.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_178','1. Alt text for all <code>img</code> elements that are not used as source anchors conveys the same information as the image.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_179','1. TODO.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_18','1. The document is expected to contain a warning that the <code>a</code> (anchor) elements opens a new window.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_180','1. Sequential <code>a</code> (anchor) elements are expected to have different HREF values.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_181','1. The HREF value must not start with \"javascript:\".','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_182','1. The <code>body</code> element must not contain a <code>background</code> attribute.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_183','1. Each <code>object</code> element is expected to contain an <code>embed</code> element.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_184','1. Each collection is expected to contain a site map.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_185','1. Each <code>id</code> attribute value is expected to be unique.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_186','1. <code>label</code> elements must not contain <code>input</code> elements.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_187','1. Each <code>input</code> element has only one associated label.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_188','1. Each associated label is expected to contain at least one printable character.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_189','1. Each label is expected to describe its associated <code>input</code> element.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_19','1. Link text is meaningful when read out of context.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_190','1. Each source <code>a</code> (anchor) element contains a <code>title</code> attribute.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_191','1. The <code>title</code> attribute of each source <code>a</code> (anchor) element describes the link destination.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_192','1. Alt text for all <code>input</code> elements with a <code>type</code> attribute value of \"image\" does not use the words \"submit\" or \"button\" (English).','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_193','1. Alt text for all <code>input</code> elements with a <code>type</code> attribute value of \"image\" contains all non decorative text in the image.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_194','1. Alt text for all <code>area</code> elements contains all non decorative text in the image area.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_195','1. Link text does not begin with \"link to\" or \"go to\" (English)','2011-02-01 14:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_196','1. Server-side image maps are not used except when image map regions cannot be defined using an available geometric shape.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_197','1. Each source anchor contains text that identifies the link destination.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_198','1. <code>legend</code> text describes the group of choices.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_199','1. <code>legend</code> text is not empty or whitespace.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_2','1. The <code>alt</code> attribute value and the <code>src</code> attribute values are expected to be different.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_20','1. The multi-media file is expected to have an associated text transcript or does not require it.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_200','1. <code>legend</code> does not contain placeholder text or user has confirmed that the text is appropriate.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_201','1. All <code>frame</code> <code>titles</code> are not empty.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_202','1. All <code>frame</code> <code>titles</code> do not contain placeholder text or the user has confirmed that the <code>title</code> text is appropriate.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_203','1. All data table summaries describe navigation and structure of the table.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_204','1. All <code>input</code> elements, <code>type</code> of \"radio\", have a <code>label</code> containing text.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_205','1. All <code>input</code> elements, <code>type</code> of \"file\", have a <code>label</code> that describes the purpose or function of the control.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_206','1. All <code>input</code> elements, <code>type</code> of \"checkbox\", have a <code>label</code> containing text.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_207','1. All <code>input</code> elements, <code>type</code> of \"password\", have a <code>label</code> containing text.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_208','1. Each associated label is expected to contain at least one printable character.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_209','1. The label must be positioned close to the control.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_21','1. The <code>applet</code> is expected to be fully functional without using color alone.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_210','1. All <code>select</code> elements have a label that describes the purpose or function of the control.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_211','1. All <code>input</code> elements, <code>type</code> of \"text\", have a label that is positioned close to the control.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_212','1. All <code>textarea</code> elements have a <code>label</code> containing text.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_213','1. All <code>input</code> elements, <code>type</code> of \"text\", have a <code>label</code> containing text.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_214','1. All <code>textarea</code> elements have a <code>label</code> that describes the purpose or function of the control.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_216','1. All <code>input</code> elements, <code>type</code> of \"file\", have a <code>label</code> containing text.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_217','1. All <code>input</code> elements, <code>type</code> of \"password\", have a <code>label</code> that describes the purpose or function of the control.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_218','1. All <code>input</code> elements, <code>type</code> of \"text\", have a <code>label</code> that describes the purpose or function of the control.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_219','1. All <code>input</code> elements, <code>type</code> of \"checkbox\", have a <code>label</code> that describes the purpose or function of the control.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_22','1. All <code>applets</code> do not flicker.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_220','1. All <code>input</code> elements, <code>type</code> of \"checkbox\", have a <code>label</code> that describes the purpose or function of the control.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_221','1. The luminosity contrast ratio between text and background color is at least 5:1 or the text and background colors are not set.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_222','1. The luminosity contrast ratio between link and background color is at least 5:1 or the link and background colors are not set.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_223','1. The luminosity contrast ratio between active link and background color is at least 5:1 or the active link and background colors are not set.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_224','1. The luminosity contrast ratio between visited link and background color is at least 5:1 or the visited link and background colors are not set.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_225','1. The document contains a \'strict\' doctype declaration.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_226','1. The color difference is expected to be greater than 124.\n2. The color brigheness difference is expected to be greater than 499.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_227','1. The color difference is expected to be greater than 124.\n2. The color brigheness difference is expected to be greater than 499.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_228','1. The color difference is expected to be greater than 124.\n2. The color brigheness difference is expected to be greater than 499.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_229','1. The color difference is expected to be greater than 124.\n2. The color brigheness difference is expected to be greater than 499.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_23','1. <code>applet</code> contains a text equivalent in the <code>alt</code> attribute of the <code>applet</code>.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_230','1. <code>thead</code>, <code>tfoot</code> and <code>tbody</code> elements are used to group repeated table row structures.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_231','1. <code>colgroup</code> and <code>col</code> elements are used to group table column structures.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_232','1. The document must validate according to specification.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_233','1. The document is expected to contain no <code>frameset</code> elements.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_234','1. The document is expected to contain no <code>frame</code> elements.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_235','1. Steps #2 and #3 are true for all text.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_236','1. There are no adjacent text and image links having the same destination.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_237','1. The labels for <code>form</code> submit buttons are unique for all buttons that lead to different results.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_238','1. All <code>input</code> elements, except those with with a <code>type</code> attribute value of \"image\", do not have an <code>alt</code> attribute.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_239','1. <code>title</code> attribute for all <code>img</code> elements is absent or the empty string (\"\") if the image is decorative.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_24','1. The text equivalent is expected to be appropriate for the <code>applet</code>.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_240','1. Text alternative for multimedia file tells the same story and presents the same information as the multimedia file.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_241','1. Table markup is used for all tabular information.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_242','1. Table captions identify the table.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_243','1. Table summaries do not duplicate the table captions.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_244','1. Data tables that contain both row and column headers use the <code>scope</code> attribute to identify cells.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_245','1. Data tables that contain more than one row/column of headers use the <code>id</code> and <code>headers</code> attributes to identify cells.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_246','1. All <code>form</code> fields that are required are indicated to the user as required.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_247','1. All checkbox groups are marked using <code>fieldset</code> and <code>legend</code> elements.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_248','1. All visual lists are marked.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_249','1. Semantic markup is used to indicate emphasized or special text.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_25','1. The <code>applet</code> content contains a text equivalent for the <code>applet</code>.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_250','1. All text references do not use shape, size, or relative position alone.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_251','1. The luminosity contrast ratio between text and background color in all images is at least 5:1.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_252','1. All text colors or no text colors are set.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_253','1. The luminosity contrast ratio between text and background color in all images is at least 10:1.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_254','1. The luminosity contrast ratio between text and background color is at least 10:1 or the text and background colors are not set.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_255','1. The luminosity contrast ratio between link and background color is at least 10:1 or the link and background colors are not set.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_256','1. The luminosity contrast ratio between active link and background color is at least 10:1 or the active link and background colors are not set.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_257','1. The luminosity contrast ratio between visited link and background color is at least 10:1 or the visited link and background colors are not set.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_258','1. <code>applet</code> provides a keyboard mechanism to return focus to the parent window.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_259','1. <code>object</code> provides a keyboard mechanism to return focus to the parent window.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_26','1. Each <code>applet</code> user interface must be fully operable by the keyboard.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_260','1. <code>embed</code> provides a keyboard mechanism to return focus to the parent window.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_261','1. Each section of content is marked with a <code>header</code> element.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_262','1. All groups of links with a related purpose are marked.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_263','1. Repeated blocks of content appear in the same <code>frame</code> within the <code>frameset</code>.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_264','1. All <code>input</code> elements, <code>type</code> of \"submit\", have a valid tab index.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_265','1. The tab order specified by <code>tabindex</code> attributes follows a logical order.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_266','1. The document contains a breadcrumb trail if it is part of a collection.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_267','1. All form submission error messages identify any empty required fields.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_268','1. All form submission error messages provide assistance in correcting the error.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_269','1. All form submission data is presented to the user before final acceptance for all irreversable transactions.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_27','1. <code>blink</code> element is not used.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_270','1. Unicode right-to-left marks or left-to-right marks are used whenever the HTML bidirectional algorithm produces undesirable results.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_271','1. All changes in text direction are marked using the <code>dir</code> attribute.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_272','1. Information deleted using a web page can be recovered.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_273','1. Reading order direction is marked using the html element\'s <code>dir</code> attribute if the document\'s primary language is read right to left.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_274','1. Change of context occurs only by user activation unless a warning is provided.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_275','1. Loading the web page does not cause a new window to open.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_276','1. Repeated components appear in the same relative order each time they appear.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_28','1. A \"skip to content\" link appears on all pages with blocks of material prior to the main content.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_29','1. HTML content has a valid <code>doctype</code> declaration.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_3','1. Image Alt text is short or the user has confirmed that the Alt text is as short as possible.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_30','1. All <code>objects</code> do not flicker.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_301','1. The contrast evaluator will display a contrast ratio greater than or equal to 4.5:1 for standard sized text.Standard sized text is considered to be less than 18-point (or 14 point when bold).\r\n2. The contrast evaluator will display a contrast ratio greater than or equal to 3:1 for large scale text. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 10:23:40','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_302','1. The contrast evaluator will display a contrast ratio of at least 4.5:1 for standard sized text. Standard sized text is considered to be less than 18-point (or 14 point when bold).\r\n2. The contrast evaluator will display a contrast ratio of at least 3:1 for large scale text. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 10:39:27','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_303','1. The contrast evaluator will display a contrast ratio of at least 4.5:1 for standard sized text. Standard sized text is considered to be less than 18-point (or 14 point when bold).\r\n2. The contrast evaluator will display a contrast ratio of at least 3:1 for large scale text. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 10:46:37','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_304','1. The contrast evaluator will display a contrast ratio of at least 4.5:1 for standard sized text. Standard sized text is considered to be less than 18-point (or 14 point when bold).\r\n2. The contrast evaluator will display a contrast ratio of at least 3:1 for large scale text. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 10:52:03','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_305','1. The contrast evaluator will display a contrast ratio of at least 4.5:1 for standard sized text. Standard sized text is considered to be less than 18-point (or 14 point when bold).\r\n2. The contrast evaluator will display a contrast ratio of at least 3:1 for large scale text. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 10:56:26','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_306','1. The contrast evaluator will display a contrast ratio of at least 7:1 for standard sized text. Standard sized text is considered to be less than 18-point (or 14 point when bold).\r\n2. The contrast evaluator will display a contrast ratio of at least 4.5:1 for large scale text. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 11:20:21','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_307','1. The contrast evaluator will display a contrast ratio of at least 7:1 for standard sized text. Standard sized text is considered to be less than 18-point (or 14 point when bold).\r\n2. The contrast evaluator will display a contrast ratio of at least 4.5:1 for large scale text. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 11:20:34','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_308','1. The contrast evaluator will display a contrast ratio of at least 7:1 for standard sized text. Standard sized text is considered to be less than 18-point (or 14 point when bold).\r\n2. The contrast evaluator will display a contrast ratio of at least 4.5:1 for large scale text. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 11:20:56','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_309','1. The contrast evaluator will display a contrast ratio of at least 7:1 for standard sized text. Standard sized text is considered to be less than 18-point (or 14 point when bold).\r\n2. The contrast evaluator will display a contrast ratio of at least 4.5:1 for large scale text. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 11:24:55','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_31','1. All <code>frames</code> have a <code>title</code> attribute.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_310','1. The contrast evaluator will display a contrast ratio of at least 7:1 for standard sized text. Standard sized text is considered to be less than 18-point (or 14 point when bold).\r\n2. The contrast evaluator will display a contrast ratio of at least 4.5:1 for large scale text. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 11:19:54','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_32','1. All <code>frame</code> <code>titles</code> identify the purpose or function of the <code>frame</code>.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_33','1. The source for each <code>frame</code> is accessible content.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_34','1. A <code>frameset</code> with 3 or more frames is expected to contain a valid <code>longdesc</code> attribute. The <code>longdesc</code> attribute must refer to a content that describes the relationship between the frames.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_35','1. Each <code>frameset</code> element is expected to contain a valid <code>noframes</code> section.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_36','1. Each NOFRAMES element is expected to contain a text equivalent of the FRAMES section.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_37','1. The header following an <code>h1</code> is <code>h1</code> or <code>h2</code>.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_38','1. The header following an <code>h2</code> is <code>h1</code>, <code>h2</code> or <code>h3</code>.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_39','1. The header following an <code>h3</code> is <code>h1</code>, <code>h2</code>, <code>h3</code> or <code>h4</code>.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_4','1. The <code>alt</code> attribute value contains text if the image is non-decorative.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_40','1. The header following an <code>h4</code> is <code>h1</code>, <code>h2</code>, <code>h3</code>, <code>h4</code> or <code>h5</code>.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_41','1. The header following an <code>h5</code> is <code>h6</code> or any header less than <code>h6</code>.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_42','1. All <code>h1</code> elements are not used for formatting.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_43','1. All <code>h2</code> elements are not used for formatting.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_44','1. All <code>h3</code> elements are not used for formatting.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_45','1. All <code>h4</code> elements are not used for formatting.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_46','1. All <code>h5</code> elements are not used for formatting.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_47','1. All <code>h6</code> elements are not used for formatting.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_48','1. Document has required <code>lang</code> attribute(s).','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_49','1. Document has valid language code.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_5','1. The <code>alt</code> attribute value is expected to contain one or more characters that are not whitespace characters.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_50','1. Document contains a <code>title</code> element.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_51','1. <code>title</code> contains text.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_52','1. <code>title</code> is short.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_53','1. <code>title</code> is not placeholder text.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_54','1. <code>title</code> describes the document.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_55','1. The <code>input</code> elements are expected to avoid using color alone.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_57','1. All <code>input</code> elements, with <code>type</code> of \"text\", have an explicitly associated label.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_58','1. All <code>input</code> elements with a <code>type</code> attribute value of \"image\" have an <code>alt</code> attribute.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_59','1. Alt text for all <code>input</code> elements with a <code>type</code> attribute value of \"image\" identifies the purpose or function of the image.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_6','1. Alt text for all <code>img</code> elements is not placeholder text or user has confirmed that the Alt text is appropriate.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_60','1. Alt text for all <code>input</code> elements with a <code>type</code> attribute value of \"image\" is less than 100 characters (English) or the user has confirmed that the Alt text is as short as possible.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_61','1. The <code>alt</code> attribute value is expected to be different from the <code>src</code> attribute value.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_62','1. The <code>alt</code> attribute value is expected to be different from common placeholder values.\\r\\n2. Common placeholder values are: \"image\", \"photo\" and any text with the word \"bytes\".','2011-02-01 14:57:48','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_63','1. The <code>alt</code> attribute value is expected to be different from common placeholder values.\n2. Common placeholder values are: \"image\", \"photo\" and any text with the word \"bytes\".','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_64','1. All <code>area</code> elements have an <code>alt</code> attribute.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_65','1. Alt text for all <code>area</code> elements identifies the link destination.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_66','1. If the <code>area\'s</code> <code>alt</code> attribute links to a sound file then the content is expected to contain a link to a text transcript for the sound file.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_68','1. If the <code>area</code> element opens a new window then the content must contain a warning to the user.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_69','1. <code>marquee</code> element is not used.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_7','1. Alt text for all <code>img</code> elements used as source anchors is not empty when there is no other text in the anchor.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_70','1. <code>li</code> elements are really list items and not used to format text.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_71','1. The content is expected to contain no <code>meta</code> elements that have an <code>http-equiv</code> attribute value of \"refresh\" and a <code>content</code> attribute value that starts with \"http://\".','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_72','1. <code>meta</code> element does not have a <code>http-equiv</code> attribute value of \"refresh\" unless the <code>content</code> attribute value is zero.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_73','1. It is expected that the <code>object</code> will not use color alone','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_74','1. It is expected that the text equivalent is valid for the <code>object</code>.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_75','1. The content must be usable when the <code>object</code> is disabled.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_76','1. The <code>object</code> user interface must be fully operable from the keyboard.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_77','1. There must be a text equivalent for the <code>object</code>.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_78','1. Each <code>object</code> is expected to contain a <code>title</code> attribute.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_79','1. Each <code>object</code> is expected to contain a <code>title</code> attribute value that describes the <code>object</code>.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_8','1. A long description is used for each <code>img</code> element that does not have Alt text conveying the same information as the image.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_80','1. All <code>objects</code> contain a text equivalent of the object.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_81','1. LI elements are really list items and not used to format text.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_82','1. All <code>p</code> elements are not used as headers.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_83','1. There should be no ASCII art in the document.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_84','1. There should be no ASCII art in the document.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_86','1. The <code>script</code> should not use color alone.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_87','1. The <code>script</code> should not cause the screen to flicker.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_88','1. The content must be accessible when the <code>script</code> is disabled.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_89','1. The <code>script</code> user interface must be accessible from the keyboard.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_9','1. All <code>img</code> elements that have a <code>longdesc</code> attribute also have an associated \'d-link\'.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_90','1. Essential <code>script</code> must have a valid <code>noscript</code> section.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_91','1. All <code>select</code> elements have an explicitly associated <code>label</code>.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_92','1. All <code>select</code> elements do not cause an extreme change in context.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_94','1. The content must be readable when SCRIPTs are not applied.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_95','1. All <code>textarea</code> elements have an explicitly associated label.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_96','1. All <code>textarea</code> elements have a label that is positioned close to control.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_97','1. The document must be readable when LINK stylesheets are not applied.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_98','1. All abbreviations are expected to be marked with a valid <code>abbr</code> element.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_EXPECTEDRESULT_99','1. All Acronyms are expected to be marked with a valid <code>acronym</code> element.','2009-03-18 13:52:44','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_1','1. Add an <code>alt</code> attribute to each <code>img</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_10','1. Use another image that does not flicker.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_100','1. Remove the <code>blockquote</code> element and replace it with other formatting elements or CSS.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_101','1. TODO','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_102','1. Add a valid <code>onkeypress</code> attribute to the element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_103','1. Remove the <code>ondblclick</code> attribute or add keyboard specific functions that perform the same action.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_104','1. Add a valid <code>onkeydown</code> attribute to the element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_105','1. Remove the <code>onmousemove</code> attribute or add keyboard specific functions that perform the same action.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_106','1. Add a valid <code>onblur</code> attribute to the element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_107','1. Add a valid <code>onfocus</code> attribute to the element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_108','1. Add a valid <code>onkeyup</code> attribute to the element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_109','1. Modify the document so it is readable when stylesheets are not applied.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_11','1. Modify the <code>alt</code> attribute value so it contains any text within the image.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_110','1. Add markup using the <code>lang</code> attribute to identify any words that are not in the primary language.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_111','1. Add a valid <code>summary</code> attribute to the <code>table</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_112','1. Add text to the <code>summary</code> attribute of each data <code>table</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_113','1. Modify the <code>summary</code> attribute value of the <code>table</code> element so it describes the purpose and structure of the table.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_114','1. Remove the <code>summary</code> attribute for layout <code>table</code>s or make the <code>summary</code> attribute value empty.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_115','1. Remove the <code>caption</code> element from the <code>table</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_116','1. Remove any <code>b</code> elements from the document and replace them with other markup.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_117','1. Remove any <code>i</code> (italic) elements from the document and replace them with other markup.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_118','1. Create a <code>label</code> element for the <code>input</code> element and associate these elements using the ID and <code>for</code> attributes.\n2. and/or\n3. Add a <code>title</code> attribute to the <code>input</code> element.\n4. and/or\n5. Add a <code>label</code> element that contains the <code>input</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_119','1. Create a <code>label</code> element for the <code>input</code> element and associate these elements using the ID and <code>for</code> attributes.\n2. and/or\n3. Add a <code>title</code> attribute to the <code>input</code> element.\n4. and/or\n5. Add a <code>label</code> element that contains the <code>input</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_12','1. Add a valid <code>usemap</code> attribute to the <code>img</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_120','1. Create a <code>label</code> element for the <code>input</code> element and associate these elements using the ID and <code>for</code> attributes.\n2. and/or\n3. Add a <code>title</code> attribute to the <code>input</code> element.\n4. and/or\n5. Add a <code>label</code> element that contains the <code>input</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_121','1. Create a <code>label</code> element for the <code>input</code> element and associate these elements using the ID and <code>for</code> attributes.\n2. and/or\n3. Add a <code>title</code> attribute to the <code>input</code> element.\n4. and/or\n5. Add a <code>label</code> element that contains the <code>input</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_122','1. Position the label close to the control.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_123','1. Position the label close to the control.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_124','1. Position the label close to the control.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_125','1. Position the label close to the control.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_126','1. Add text to the VALUE attribute on all text <code>input</code> elements.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_127','1. Modify the text equivalent so it is appropriate for the <code>object</code>.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_128','1. Modify the content so it is usable when the <code>object</code> is removed or disabled.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_129','1. Modify the user interface of the <code>object</code> so it is keyboard accessible.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_13','1. Add a set of text links that duplicate the text links in the image map.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_131','1. Mark any blockquotes using the <code>blockquote</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_132','1. Add a text link to the document for each active area in the server-side image map.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_133','1. Modify the <code>table</code> so it makes sense when linearized.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_134','1. Add a printable character between the adjacent characters.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_135','1. Provide MathML markup for all images containing math expressions.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_136','1. Create a row or column of headers using the <code>th</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_137','1. Remove all <code>th</code> elements from the <code>table</code>.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_138','1. Add a valid <code>tabindex</code> attribute value to the <code>input</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_139','1. Add a valid <code>tabindex</code> attribute value to the <code>input</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_14','1. Change the text so it does not refer to the image by color alone.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_140','1. Add a valid <code>tabindex</code> attribute value to the <code>input</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_141','1. Add a valid <code>tabindex</code> attribute value to the <code>input</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_142','1. Add a valid <code>tabindex</code> attribute value to the <code>input</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_143','1. Add an <code>address</code> element to the content.\n2. Put the author\'s address within the <code>address</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_144','1. Add an <code>address</code> element to the content.\n2. Put the author\'s address within the <code>address</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_145','1. Add a link to a text alternative immediately before or immediately after the link to the multimedia file.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_146','1. Add a text equivalent for the multimedia <code>object</code> within the document or link to it.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_147','1. Add one or more <code>link</code> elements to the <code>head</code> section of the document that place the document in the reading order.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_148','1. Add one or more <code>link</code> elements to the HEAD section of the document that link to the alternate content.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_149','1. TODO.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_15','1. Change the Alt text so it identifies the destination of the link.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_150','1. TODO.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_151','1. Add a valid <code>caption</code> element to the <code>table</code> or identify the table within the document.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_152','1. Add a valid <code>abbr</code> attribute value to the <code>th</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_153','1. Shorted the <code>abbr</code> attribute value so it is less than 20 characters.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_154','1. Remove the <code>pre</code> element and replace it with <code>table</code> elements.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_155','1. TODO.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_156','1. TODO.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_157','1. TODO.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_158','1. TODO.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_159','1. Remove the <code>title</code> attribute from the <code>img</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_16','1. Change the Alt text to an empty string (\"\") or confirm that\n        the image is not decorative.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_160','1. Add a long description to the <code>object</code>.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_161','1. TODO.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_162','1. TODO.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_163','1. Add a <code>noembed</code> element within the <code>embed</code> element.\n2. Add content within the <code>noembed</code> element that serves the same purpose and presents the same information as the <code>embed</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_164','1. TODO.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_165','1. TODO.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_166','1. TODO.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_167','1. TODO.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_168','1. Add <code>fieldset</code> and <code>legend</code> elements to groups of radio buttons.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_169','1. TODO.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_17','1. Create a text transcript of the sound file and include it within the document or link to it.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_173','1. TODO.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_174','1. Add text within the source anchor that describes the link destination.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_175','1. Change the Alt text or the link text so they are different.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_176','1. Remove the <code>basefont</code> elements from the document.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_177','1. Remove the <code>font</code> elements from the document.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_178','1. Change the <code>alt</code> attribute value so it conveys the same information as the image.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_179','1. TODO.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_18','1. Add a warning to the user that the <code>a</code> (anchor) element opens a new window.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_180','1. Combine both <code>a</code> (anchor) elements into one anchor element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_181','1. Remove the Javascript URL protocol from the anchor element and replace it with a fallback HREF value and a Javascript event handler.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_182','1. Remove the <code>background</code> attribute.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_183','1. Add a valid <code>embed</code> element within the <code>object</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_184','1. Add a site map and link to it from the main page.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_185','1. Modify the <code>id</code> attribute value so it is unique.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_186','1. Move the <code>input</code> element outside the <code>label</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_187','1. Remove or modify the <code>label</code> elements so there is only one <code>label</code> per <code>input</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_188','1. Add text to the <code>input</code> element\'s associated label.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_189','1. Modify the label text so it describes the purpose of the <code>input</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_19','1. Modify the link text so it makes sense when read out of context.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_190','1. Add a <code>title</code> attribute to each source <code>a</code> (anchor) element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_191','1. Modify the <code>title</code> attribute value so it describes the link destination.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_192','1. Change the Alt text for the <code>input</code> element so it does not use the words \"submit\" or \"button\" (English).','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_193','1. Modify the Alt text so it contains any non decorative text within the image.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_194','1. Modify the Alt text so it contains any non decorative text within the image.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_195','1. Modify the link text so it does not start with \"link to\" or \"go to\".','2011-02-01 14:57:27','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_196','1. Replace the server-side image map with a client-side image map.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_197','1. Add text within the source anchor that identifies the link destination.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_198','1. Modify the <code>legend</code> text so it describes the group of choices.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_199','1. Modify the <code>legend</code> text so it describes the group of choices.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_2','1. If both values are the same then view the image and determine if the <code>alt</code> attribute value is appropriate.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_20','1. Create a text transcript of the multi-media file and include it within the document or link to it.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_200','1. Modify the <code>legend</code> text so it describes the group of choices.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_201','1. Add text to the <code>frame</code> <code>title</code> that describes the purpose or function of the <code>frame</code>.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_202','1. Modify the <code>frame</code> <code>title</code> text so it is not placeholder text or confirm that the text identifies the purpose or function of the <code>frame</code>.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_203','1. Modify the table summary so it describes navigation and structure of the table.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_204','1. Add text to the label that describes the purpose or function of the control.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_205','1. Modify the label text so it describes the purpose or function of the control.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_206','1. Add text to the label that describes the purpose or function of the control.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_207','1. Add text to the label that describes the purpose or function of the control.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_208','1. Add text to the <code>select</code> element\'s associated label.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_209','1. Position the label close to the control.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_21','1. Modify the <code>applet</code> so it does not use color alone.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_210','1. Modify the label text so it describes the purpose or function of the control.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_211','1. Position the label close to the control.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_212','1. Add text to the label that describes the purpose or function of the control.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_213','1. Add text to the label that describes the purpose or function of the control.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_214','1. Modify the label text so it describes the purpose or function of the control.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_216','1. Add text to the label that describes the purpose or function of the control.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_217','1. Modify the label text so it describes the purpose or function of the control.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_218','1. Modify the label text so it describes the purpose or function of the control.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_219','1. Modify the label text so it describes the purpose or function of the control.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_22','1. Modify the <code>applet</code> so it does not flicker.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_220','1. Modify the label text so it describes the purpose or function of the control.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_221','1. Change either the <code>text</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the luminosity contrast ratio is greater than 5:1\n2. Another way to pass this test is to remove the <code>text</code> attribute and the <code>bgcolor</code> attribute from the <code>body</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_222','1. Change either the <code>link</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the luminosity contrast ratio is greater than 5:1\n2. Another way to pass this test is to remove the <code>link</code> attribute and the <code>bgcolor</code> attribute from the <code>body</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_223','1. Change either the <code>alink</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the luminosity contrast ratio is greater than 5:1\n2. Another way to pass this test is to remove the <code>alink</code> attribute and the <code>bgcolor</code> attribute from the <code>body</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_224','1. Change either the <code>vlink</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the luminosity contrast ratio is greater than 5:1\n2. Another way to pass this test is to remove the <code>vlink</code> attribute and the <code>bgcolor</code> attribute from the <code>body</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_225','1. Insert a strict doctype declaration in the document.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_226','1. Change either the <code>text</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the colors exceed the WAI ERT algorithm threshold\n2. Another way to pass this test is to remove the <code>text</code> attribute and the <code>bgcolor</code> attribute from the <code>body</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_227','1. Change either the <code>link</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the colors exceed the WAI ERT algorithm threshold\n2. Another way to pass this test is to remove the <code>link</code> attribute and the <code>bgcolor</code> attribute from the <code>body</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_228','1. Change either the <code>alink</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the colors exceed the WAI ERT algorithm threshold\n2. Another way to pass this test is to remove the <code>alink</code> attribute and the <code>bgcolor</code> attribute from the <code>body</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_229','1. Change either the <code>vlink</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the colors exceed the WAI ERT algorithm threshold\n2. Another way to pass this test is to remove the <code>vlink</code> attribute and the <code>bgcolor</code> attribute from the <code>body</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_23','1. Modify the <code>alt</code> attribute value so it is equivalent to the <code>applet</code>.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_230','1. Add <code>thead</code>, <code>tfoot</code> and <code>tbody</code> elements to group repeated table row structures.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_231','1. Add <code>colgroup</code> and <code>col</code> elements to group table column structures.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_232','1. Modify the document so it validates to declared doctype declaration.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_233','1. Remove any <code>frameset</code> elements from the document.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_234','1. Remove any <code>frame</code> elements from the document.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_235','1. Modify the dir attribute values so they correctly reflect the text reading direction.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_236','1. Place the text and image together in one link, and provide null alternative text on the image to eliminate duplication of text.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_237','1. Change the label on the submit buttons so they are unique.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_238','1. Remove the <code>alt</code> attribute from all <code>input</code> elements except those with a <code>type</code> attribute value of \"image\".','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_239','1. Remove the title attribute if the image is decorative.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_24','1. Create a text equivalent for the <code>applet</code>.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_240','1. Modify the text alternative file so it tells the same story and presents the same information as the multimedia file.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_241','1. Tabular information is presented using more than one Tab or more than one pipe character in a single line to separate data cells.\r\n2. Add table markup (<code>table</code>, <code>tr</code>, <code>th</code>, and <code>td</code> ) to all tabular information.','2011-01-18 14:22:13','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_242','1. Modify the caption so it identifies the table.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_243','1. Change the <code>summary</code> or the <code>caption</code> so they are different.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_244','1. Add <code>scope</code> attributes to header cells so they identify the cells that relate to the header.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_245','1. Add <code>id</code> and <code>headers</code> attributes to table cells so they identify the cells that relate to the header.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_246','1. Modify the form field labels so they indicate the required fields.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_247','1. Add <code>fieldset</code> and <code>legend</code> elements to groups of checkbox controls.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_248','1. Modify the lists so they contain the proper markup.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_249','1. Add semantic markup to any emphasized or special text.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_25','1. Modify the <code>applet</code> content so it provides a text alternative for the applet.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_250','1. Modify the text so it includes a reference that does not use visual perception alone.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_251','1. Change the background or text color so the luminosity contrast ratio is at least 5:1.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_252','1. Add all the color attributes or remove all the color attributes from the <code>body</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_253','1. Change the background or text color so the luminosity contrast ratio is at least 10:1.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_254','1. Change either the <code>text</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the luminosity contrast ratio is greater than 10:1\n2. Another way to pass this test is to remove the <code>text</code> attribute and the <code>bgcolor</code> attribute from the <code>body</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_255','1. Change either the <code>link</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the luminosity contrast ratio is greater than 10:1\n2. Another way to pass this test is to remove the <code>link</code> attribute and the <code>bgcolor</code> attribute from the <code>body</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_256','1. Change either the <code>alink</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the luminosity contrast ratio is greater than 10:1\n2. Another way to pass this test is to remove the <code>alink</code> attribute and the <code>bgcolor</code> attribute from the <code>body</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_257','1. Change either the <code>vlink</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the luminosity contrast ratio is greater than 10:1\n2. Another way to pass this test is to remove the <code>vlink</code> attribute and the <code>bgcolor</code> attribute from the <code>body</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_258','1. Upgrade the <code>applet</code> or do not use it.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_259','1. Upgrade the <code>object</code> or do not use it.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_26','1. Modify the <code>applet</code> so it can be operated by the keyboard.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_260','1. Upgrade the <code>embed</code> or do not use it.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_261','1. Add headers to each section of the content.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_262','1. Add markup to group related links.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_263','1. Change the document so the same type of content appears in the same frame.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_264','1. Add a valid <code>tabindex</code> attribute value to the <code>input</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_265','1. Change the tabindex values so the tab order is logical and follows relationships in the document.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_266','1. Add a breadcrumb trail to the document.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_267','1. Modify the form submission error messages so they identify any required fields.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_268','1. Modify the form submission error messages so they provide assistance in correcting the error.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_269','1. Modify the form submission process so the user is shown the data and allowed to correct it before final acceptance.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_27','1. Remove any <code>blink</code> elements from the document.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_270','1. Add Unicode right-to-left marks or left-to-right marks so the HTML bidirectional algorithm produces desirable results.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_271','1. Add a <code>dir</code> attribute to inline elements that mark blocks of text that have a reading order different from the document\'s primary language.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_272','1. Add functionality to the site that allows the user to recover data that has been deleted.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_273','1. Add a <code>dir</code> attribute to the html element and set its value to \"rtl\".','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_274','1. Modify or remove the script that causes change of context without user activation.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_275','1. Modify the page so it does not open any new windows upon loading.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_276','1. Modify the page so the repeated components appear in the same relative order as other pages.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_28','1. Add a \"skip to content\" link that bypasses the block of heading material and goes to the main content.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_29','1. Add a valid <code>doctype</code> declaration to the document.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_3','1. If the <code>alt</code> attribute value is greater than 100 characters (English) then either shorten the <code>alt</code> attribute value or confirm that current value is the shortest possible for the associated image.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_30','1. Remove the <code>object</code> or modify the <code>object</code> so it does not flicker.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_301','1. The contrast evaluator will display a contrast ratio less than 4.5:1 for standard sized text. Standard sized text is considered to be less than 18-point (or 14 point when bold).\r\n2. The contrast evaluator will display a contrast ratio less than 3:1 for large scale text. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 10:23:40','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_302','1. The contrast evaluator will display a contrast ratio less than 4.5:1 for standard sized text. Standard sized text is considered to be less than 18-point (or 14 point when bold).\r\n2. The contrast evaluator will display a contrast ratio less than 3:1 for large scale text. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 10:39:27','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_303','1. The contrast evaluator will display a contrast ratio less than 4.5:1 for standard sized text. Standard sized text is considered to be less than 18-point (or 14 point when bold).\r\n2. The contrast evaluator will display a contrast ratio less than 3:1 for large scale text. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 10:46:37','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_304','1. The contrast evaluator will display a contrast ratio less than 4.5:1 for standard sized text. Standard sized text is considered to be less than 18-point (or 14 point when bold).\r\n2. The contrast evaluator will display a contrast ratio less than 3:1 for large scale text. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 10:52:03','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_305','1. The contrast evaluator will display a contrast ratio less than 4.5:1 for standard sized text. Standard sized text is considered to be less than 18-point (or 14 point when bold).\r\n2. The contrast evaluator will display a contrast ratio less than 3:1 for large scale text. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 10:56:26','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_306','1. The contrast evaluator will display a contrast ratio less than 7:1 for standard sized text. Standard sized text is considered to be less than 18-point (or 14 point when bold).\r\n2. The contrast evaluator will display a contrast ratio less than 4.5:1 for large scale text. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 11:20:21','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_307','1. The contrast evaluator will display a contrast ratio less than 7:1 for standard sized text. Standard sized text is considered to be less than 18-point (or 14 point when bold).\r\n2. The contrast evaluator will display a contrast ratio less than 4.5:1 for large scale text. Large scale text is considered to be at least 18-point (or 14 point when bold','2011-01-19 11:20:34','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_308','1. The contrast evaluator will display a contrast ratio less than 7:1 for standard sized text. Standard sized text is considered to be less than 18-point (or 14 point when bold).\r\n2. The contrast evaluator will display a contrast ratio less than 4.5:1 for large scale text. Large scale text is considered to be at least 18-point (or 14 point when bold)','2011-01-19 11:20:56','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_309','1. The contrast evaluator will display a contrast ratio less than 7:1 for standard sized text. Standard sized text is considered to be less than 18-point (or 14 point when bold).\r\n2. The contrast evaluator will display a contrast ratio less than 4.5:1 for large scale text. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 11:24:55','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_31','1. Add a valid <code>title</code> attribute to the <code>frame</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_310','1. The contrast evaluator will display a contrast ratio less than 7:1 for standard sized text. Standard sized text is considered to be less than 18-point (or 14 point when bold).\r\n2. The contrast evaluator will display a contrast ratio less than 4.5:1 for large scale text. Large scale text is considered to be at least 18-point (or 14 point when bold).','2011-01-19 11:19:54','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_32','1. Modify the <code>frame\'s</code> <code>title</code> so it describes the purpose or function of the <code>frame</code>.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_33','1. Modify the source content for the <code>frame</code> so it is accessible.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_34','1. Add a <code>longdesc</code> attribute to the <code>frameset</code> element.\n2. Ensure the <code>longdesc</code> attribute refers to a content that describes the relationship between the frames.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_35','1. Add a valid <code>noframes</code> section to the <code>frameset</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_36','1. Create a NOFRAMES section that contains a text equivalent of the FRAMES section.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_37','1. Rearrange the header order so <code>h1</code> or <code>h2</code> elements follow <code>h1</code> elements.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_38','1. Rearrange the header order so the header following an <code>h2</code> is <code>h1</code>, <code>h2</code> or <code>h3</code>.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_39','1. Rearrange the header order so the header following an <code>h3</code> is <code>h1</code>, <code>h2</code>, <code>h3</code> or <code>h4</code>.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_4','1. If the image is non-decorative and the <code>alt</code> attribute value is an empty string (\"\") then add an appropriate <code>alt</code> attribute value.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_40','1. Rearrange the header order so the header following an <code>h4</code> is <code>h1</code>, <code>h2</code>, <code>h3</code>, <code>h4</code> or <code>h5</code>.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_41','1. Rearrange the header order so <code>h6</code> or any header less than <code>h6</code> follows <code>h5</code> headers.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_42','1. Remove the <code>h1</code> element and replace it with the appropriate text formatting elements.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_43','1. Remove the <code>h2</code> element and replace it with the appropriate text formatting elements.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_44','1. Remove the <code>h3</code> element and replace it with the appropriate text formatting elements.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_45','1. Remove the <code>h4</code> element and replace it with the appropriate text formatting elements.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_46','1. Remove the <code>h5</code> element and replace it with the appropriate text formatting elements.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_47','1. Remove the <code>h6</code> element and replace it with the appropriate text formatting elements.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_48','1. Add a valid <code>lang</code> attribute(s) to the <code>html</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_49','1. Set the <code>lang</code> attribute(s) to a valid language code.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_5','1. If the <code>alt</code> attribute value is whitespace then either add an appropriate <code>alt</code> attribute value or confirm that current empty value is appropriate for the associated image.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_50','1. Create a valid <code>title</code> element within the <code>head</code> section of the content.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_51','1. Add text to the <code>title</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_52','1. Reduce the number of characters contained by the <code>title</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_53','1. Change the <code>title</code> text to avoid placeholder text or confirm that the text is appropriate.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_54','1. Change the <code>title</code> text so it describes the document.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_55','1. Change the <code>input</code> element so it does not use color alone.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_57','1. Create a <code>label</code> element for the <code>input</code> element and associate these elements using the ID and <code>for</code> attributes.\n2. and/or\n3. Add a <code>title</code> attribute to the <code>input</code> element.\n4. and/or\n5. Add a <code>label</code> element that contains the <code>input</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_58','1. Add an <code>alt</code> attribute to the <code>input</code> element.\n2. Set the <code>alt</code> attribute value so it describes the function of the <code>input</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_59','1. Modify the Alt text so it identifies the purpose or function of the image.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_6','1. Change the <code>alt</code> attribute value or confirm that current value is appropriate for the associated image.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_60','1. Change the Alt text so it is less than 100 characters (English) or confirm that the current Alt text is the shortest possible for the image.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_61','1. Change the <code>alt</code> attribute value or confirm that the current <code>alt</code> attribute value is appropriate for the image.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_62','1. Change the <code>alt</code> attribute value or confirm that the current <code>alt</code> attribute value is appropriate for the image.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_63','1. Change the <code>alt</code> attribute value or confirm that the current <code>alt</code> attribute value is appropriate for the image.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_64','1. Add an <code>alt</code> attribute to the <code>area</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_65','1. Modify the <code>alt</code> attribute value so it identifies the destination of the link.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_66','1. Create a text transcript of the sound file and add a link to it.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_68','1. Add a warning that the <code>area</code> element opens a new window.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_69','1. Remove all <code>marquee</code> elements from the content.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_7','1. Modify the Alt text so it is not empty.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_70','1. Remove the <code>menu</code> and <code>li</code> elements and replace them with other markup that properly formats the text.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_71','1. Use a server-side redirect or place a link on the page that allows users to go to the new page.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_72','1. Remove the <code>meta</code> element.\n2. Or\n3. Set the <code>content</code> attribute value to zero.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_73','1. Modify the <code>object</code> so it does not use color alone.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_74','1. Modify the text equivalent so it is accurate for the <code>object</code>.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_75','1. Create a text equivalent that provides the same functionality as the <code>object</code>.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_76','1. Modify the <code>object</code> user interface so it can be operated by the keyboard.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_77','1. Add a text equivalent for the <code>object</code>.\n2. The text equivalent may be within the document or in a separate file linked from the content.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_78','1. Add a valid <code>title</code> attribute to the <code>object</code>.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_79','1. Add a valid <code>title</code> attribute to the <code>object</code> that describes the <code>object</code>.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_8','1. Add a long description for any image that is not fully described by the Alt text.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_80','1. Add a text equivalent for the object.\n2. The text equivalent may be text, a link to a text equivalent or an image with valid Alt text.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_81','1. Remove the OL and LI elements and replace them with other markup that properly formats the text.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_82','1. Remove the <code>p</code> element and replace it with the appropriate header element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_83','1. Remove the ASCII art and replace it with an image.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_84','1. Remove the ASCII art and replace it with an image.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_86','1. Remove the <code>script</code> or modify it so it does not use color alone.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_87','1. Remove the <code>script</code> or modify it so the screen does not flicker.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_88','1. Modify the content so it is accessible when the <code>script</code> is disabled.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_89','1. Remove the <code>script</code> or modify it so it is accessible from the keyboard.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_9','1. Add a following \'d-link\' to the <code>img</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_90','1. Add a <code>noscript</code> section after the script that is equivalent to the <code>script</code>.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_91','1. Create a <code>label</code> element for the <code>select</code> element and associate these elements using the ID and <code>for</code> attributes.\n2. and/or\n3. Add a <code>title</code> attribute to the <code>select</code> element.\n4. and/or\n5. Add a <code>label</code> element that contains the <code>select</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_92','1. Remove the <code>onchange</code> attribute from the <code>select</code> element or modify the event handler so it does not cause a page reload or extreme change of context.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_94','1. Modify the content so it is readable when SCRIPTs are not applied.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_95','1. Create a <code>label</code> element for the <code>textarea</code> element and associate these elements using the ID and <code>for</code> attributes.\\r\\n2. and/or\\r\\n3. Add a <code>title</code> attribute to the <code>textarea</code> element.\\r\\n4. and/or\\r\\n5. Add a <code>label</code> element that contains the <code>textarea</code> element.','2009-04-14 10:45:04','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_96','1. Position the label close to the control.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_97','1. Modify the document so it is readable when LINK stylesheets are not applied.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_98','1. Mark all abbreviations with a valid <code>abbr</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_FAILEDRESULT_99','1. Mark all Acronyms with a valid <code>acronym</code> element.','2009-03-18 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_1','Add an <code>alt</code> attribute to your <code>img</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_102','Add a <code>onkeypress</code> handler to your SCRIPT that performs the same function as the <code>onclick</code> function.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_104','Add an <code>onkeydown</code> handler to your <code>script</code> that performs the same function as the <code>onmousedown</code> function.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_106','Add an <code>onblur</code> handler to your <code>script</code> that performs the same function as the <code>onmouseout</code> handler.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_107','Add an <code>onfocus</code> handler to your <code>script</code> that performs the same function as the <code>onmouseover</code> handler.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_108','Add an <code>onkeyup</code> handler to your <code>script</code> that performs the same function as the <code>onmouseup</code> handler.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_112','Add text to the <code>summary</code> attribute on each <code>table</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_114','Remove the summary attribute from all layout table elements or set the summary attribute value so it contains no printable characters.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_115','Remove the <code>table</code>\'s <code>caption</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_116','Replace your <code>b</code> (bold) elements with <code>em</code> or <code>strong</code>.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_117','Replace your <code>i</code> elements with <code>em</code> or <code>strong</code>.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_118','Add a <code>label</code> element that surrounds the control\'s <code>label</code>. Set the <code>for</code> attribute on the <code>label</code> element to the same value as the <code>id</code> attribute of the control. And/or add a <code>title</code> attribute to the <code>input</code> element. And/or create a <code>label</code> element that contains the <code>input</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_119','Add a <code>label</code> element that surrounds the control\'s <code>label</code>. Set the <code>for</code> attribute on the <code>label</code> element to the same value as the <code>id</code> attribute of the control. And/or add a <code>title</code> attribute to the <code>input</code> element. And/or create a <code>label</code> element that contains the <code>input</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_12','Create a client-side image map that duplicates the functionality of the server-side image map.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_120','Add a <code>label</code> element that surrounds the control\'s <code>label</code>. Set the <code>for</code> attribute on the <code>label</code> element to the same value as the <code>id</code> attribute of the control. And/or add a <code>title</code> attribute to the <code>input</code> element. And/or create a <code>label</code> element that contains the <code>input</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_121','Add a <code>label</code> element that surrounds the control\'s <code>label</code>. Set the <code>for</code> attribute on the <code>label</code> element to the same value as the <code>id</code> attribute of the control. And/or add a <code>title</code> attribute to the <code>input</code> element. And/or create a <code>label</code> element that contains the <code>input</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_126','Add a VALUE attribute to this <code>input</code> element that contains default text.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_13','For each <code>area</code> element in an image-map, provide an equivalent anchor on the page. The anchor must have an <code>href</code> attribute set to the same value as the <code>area</code> element\'s <code>href</code> attribute. The anchor\'s text should be the same as the <code>area</code> element\'s Alt text.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_134','Insert printable characters (surrounded by spaces) between adjacent links.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_138','Add a <code>tabindex</code> attribute to your <code>input</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_139','Add a <code>tabindex</code> attribute to your <code>input</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_140','Add a <code>tabindex</code> attribute to your <code>input</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_141','Add a <code>tabindex</code> attribute to your <code>input</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_142','Add a <code>tabindex</code> attribute to your <code>input</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_143','Add an <code>address</code> element that describes the author\'s contact information.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_152','Add an <code>abbr</code> attribute to the <code>th</code> element that contains a terse substitute for the TH text.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_153','Shorten the <code>abbr</code> attribute value on this <code>th</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_155','Group the links using a list (OL or UL), using the DIV element or using the MA<code>p</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_156','Add a <code>title</code> attribute to the element (OL, UL, DIV or MAP) that contains the link set and make the <code>title</code> value describe the link group.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_159','Remove the <code>title</code> attribute from the <code>img</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_161','Remove the emoticons and replace them with text (i.e. \"wink\", \"grin\" etc.)','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_162','Add an <code>abbr</code> element around the emoticon and set its <code>title</code> attribute to a description of the emoticon.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_163','Add a <code>noembed</code> element within or beside the <code>embed</code> element. Add text to the <code>noembed</code> element that is equivalent to the <code>embed</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_165','Add an <code>alt</code> attribute to the <code>embed</code> element. The <code>alt</code> attribute value should describe the <code>embed</code> source.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_166','Add text to the <code>alt</code> attribute that describes the <code>embed</code> source.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_167','Remove the <code>longdesc</code> attribute from the I<code>frame</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_168','Add a <code>fieldset</code> and <code>legend</code> element to the <code>form</code> for each group of radio buttons.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_174','Add text to the <code>a</code> element or the <code>title</code> attribute of the <code>a</code> element or, if an image is used within the anchor, add Alt text to the image.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_175','Change the image\'s Alt text or link text so they differ.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_176','Remove the <code>basefont</code> element from the document.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_177','Remove the <code>font</code> element from the document.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_180','Combine both <code>a</code> (anchor) elements into one anchor element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_181','Remove the Javascript URL protocol from the anchor element and replace it with a fallback HREF value and a Javascript event handler.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_182','Remove the <code>background</code> attribute of the <code>body</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_183','Add a valid <code>embed</code> element within the <code>object</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_185','Modify the <code>id</code> attribute value so it is unique.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_186','Move the <code>input</code> element outside the <code>label</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_187','Remove or modify the <code>label</code> elements so there is only one associated <code>label</code> for each form control.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_188','Add text to the <code>label</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_190','Add a <code>title</code> attribute to your <code>a</code> (anchor) element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_192','Change the Alt text for the submit button so it does not use \"submit\" or \"button\".','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_195','Remove \"link to\" or \"go to\" at the beginning of the Alt text.','2011-02-01 14:58:25','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_199','Add text to the <code>legend</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_201','Add text to the <code>frame</code> element\'s <code>title</code> attribute.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_204','Add text to the <code>input</code> element\'s associated label that describes the purpose or function of the control.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_206','Add text to the <code>input</code> element\'s associated label that describes the purpose or function of the control.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_207','Add text to the <code>input</code> element\'s associated label that describes the purpose or function of the control.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_208','Add text to the <code>label</code> associated with the <code>select</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_212','Add text to the <code>textarea</code> element\'s associated label that describes the purpose or function of the control.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_213','Add text to the <code>input</code> element\'s associated label that describes the purpose or function of the control.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_216','Add text to the <code>input</code> element\'s associated label that describes the purpose or function of the control.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_221','Change either the <code>text</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the luminosity contrast ratio is greater than 5:1','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_222','Change either the <code>link</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the luminosity contrast ratio is greater than 5:1','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_223','Change either the <code>alink</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the luminosity contrast ratio is greater than 5:1','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_224','Change either the <code>vlink</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the luminosity contrast ratio is greater than 5:1','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_225','Insert a \'strict\' doctype declaration at the start of the document.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_226','Change either the <code>text</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the contrast surpasses the WAI ERT color algorithm threshold.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_227','Change either the <code>link</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the contrast surpasses the WAI ERT color algorithm threshold.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_228','Change either the <code>alink</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the contrast surpasses the WAI ERT color algorithm threshold.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_229','Change either the <code>vlink</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the contrast surpasses the WAI ERT color algorithm threshold.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_232','Validate the document using a validator service.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_233','Remove the <code>frameset</code> element and modify the structure of your site.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_234','Remove the <code>frame</code> element and modify the structure of your site.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_236','Put the text and image together in one link, and provide null alternative text on the image to eliminate duplication of text.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_237','Change the label on the submit buttons so they are unique.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_238','Remove the <code>alt</code> attribute from all <code>input</code> elements except those with a <code>type</code> attribute value of \"image\".','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_243','Change the table summary or caption.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_244','Add <code>scope</code> attributes to header cells so they identify the cells that relate to the header.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_245','Add <code>id</code> and headers attributes to table cells so they identify the cells that relate to the headers.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_247','Add a <code>fieldset</code> and <code>legend</code> element to the <code>form</code> for each group of checkbox buttons.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_252','Ensure all the text colors or none of the text colors are set using attributes on the <code>body</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_254','Change either the <code>text</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the luminosity contrast ratio is greater than 10:1','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_255','Change either the <code>link</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the luminosity contrast ratio is greater than 10:1','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_256','Change either the <code>alink</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the luminosity contrast ratio is greater than 10:1','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_257','Change either the <code>vlink</code> attribute value or the <code>bgcolor</code> attribute value of the <code>body</code> element so the luminosity contrast ratio is greater than 10:1','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_264','Add a <code>tabindex</code> attribute to your <code>input</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_27','Remove the <code>blink</code> element (replace with STRONG or EM).','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_273','Add a <code>dir</code> attribute to your <code>html</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_29','Add a valid <code>doctype</code> declaration to the document.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_301','Use a colour contrast evaluator to determine if text and background colours provide a contrast ratio of 4.5:1 for standard text, or 3:1 for larger text. Change colour codes to produce sufficient contrast.\r\n\r\nhttp://www.w3.org/TR/UNDERSTANDING-WCAG20/visual-audio-contrast-contrast.html#visual-audio-contrast-contrast-resources-head','2011-01-19 10:23:40','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_302','Use a colour contrast evaluator to determine if text and background colours provide a contrast ratio of 4.5:1 for standard text, or 3:1 for larger text. Change colour codes to produce sufficient contrast.\r\n\r\nhttp://www.w3.org/TR/UNDERSTANDING-WCAG20/visual-audio-contrast-contrast.html#visual-audio-contrast-contrast-resources-head','2011-01-19 10:39:27','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_303','Use a colour contrast evaluator to determine if active link text and background colours provide a contrast ratio of 4.5:1 for standard text, or 3:1 for larger text. Change colour codes to produce sufficient contrast.\r\n\r\nhttp://www.w3.org/TR/UNDERSTANDING-WCAG20/visual-audio-contrast-contrast.html#visual-audio-contrast-contrast-resources-head','2011-01-19 10:46:37','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_304','Use a colour contrast evaluator to determine if selected link text and background colours provide a contrast ratio of 4.5:1 for standard text, or 3:1 for larger text. Change colour codes to produce sufficient contrast.\r\n\r\nhttp://www.w3.org/TR/UNDERSTANDING-WCAG20/visual-audio-contrast-contrast.html#visual-audio-contrast-contrast-resources-head','2011-01-19 10:52:03','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_305','Use a colour contrast evaluator to determine if link text and background colours provide a contrast ratio of 4.5:1 for standard text, or 3:1 for larger text. Change colour codes to produce sufficient contrast.\r\n\r\nhttp://www.w3.org/TR/UNDERSTANDING-WCAG20/visual-audio-contrast-contrast.html#visual-audio-contrast-contrast-resources-head','2011-01-19 10:56:26','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_306','Use a colour contrast evaluator to determine if text and background colours provide a contrast ratio of 7:1 for standard text, or 4.5:1 for larger text. Change colour codes to produce sufficient contrast.\r\n\r\nhttp://www.w3.org/TR/UNDERSTANDING-WCAG20/visual-audio-contrast-contrast.html#visual-audio-contrast-contrast-resources-head','2011-01-19 11:20:21','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_307','Use a colour contrast evaluator to determine if text and background colours provide a contrast ratio of 7:1 for standard text, or 4.5:1 for larger text. Change colour codes to produce sufficient contrast.\r\n\r\nhttp://www.w3.org/TR/UNDERSTANDING-WCAG20/visual-audio-contrast-contrast.html#visual-audio-contrast-contrast-resources-head','2011-01-19 11:20:34','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_308','Use a colour contrast evaluator to determine if text and background colours provide a contrast ratio of 7:1 for standard text, or 4.5:1 for larger text. Change colour codes to produce sufficient contrast.\r\n\r\nhttp://www.w3.org/TR/UNDERSTANDING-WCAG20/visual-audio-contrast-contrast.html#visual-audio-contrast-contrast-resources-head','2011-01-19 11:20:56','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_309','Use a colour contrast evaluator to determine if text and background colours provide a contrast ratio of 7:1 for standard text, or 4.5:1 for larger text. Change colour codes to produce sufficient contrast.\r\n\r\nhttp://www.w3.org/TR/UNDERSTANDING-WCAG20/visual-audio-contrast-contrast.html#visual-audio-contrast-contrast-resources-head','2011-01-19 11:24:55','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_31','Add a <code>title</code> attribute to your <code>frame</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_310','Use a colour contrast evaluator to determine if text and background colours provide a contrast ratio of 7:1 for standard text, or 4.5:1 for larger text. Change colour codes to produce sufficient contrast.\r\n\r\nhttp://www.w3.org/TR/UNDERSTANDING-WCAG20/visual-audio-contrast-contrast.html#visual-audio-contrast-contrast-resources-head','2011-01-19 11:19:54','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_35','Add a <code>noframes</code> section within the <code>frameset</code>.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_37','Modify the header levels so only an <code>h1</code> or <code>h2</code> follows <code>h1</code>.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_38','Modify the header levels so only an <code>h3</code> or any header less than <code>h3</code> follows <code>h2</code>.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_39','Modify the header levels so the header following an <code>h3</code> is <code>h1</code>, <code>h2</code>, <code>h3</code> or <code>h4</code>.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_40','Modify the header levels so the header following an <code>h4</code> is <code>h1</code>, <code>h2</code>, <code>h3</code>, <code>h4</code> or <code>h5</code>.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_41','Modify the header levels so <code>h6</code> follows <code>h5</code>.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_48','For HTML documents add the lang attribute and a valid ISO-639-1 two letter language code to the opening HTML element. For XHTML documents add both the lang and xmllang attributes with a valid ISO-639-1 two letter language code to the opening HTML element.','2011-01-25 18:53:08','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_49','Add a valid 2 letter or 3 letter language code as defined in the ISO 639 specification to the HTML \'lang\' attribute. For XHTML, both \'lang\' and \'xml:lang\' must be set.','2011-01-13 14:41:45','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_50','Add a <code>title</code> element to the <code>head</code> section of your document.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_51','Add text to the <code>title</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_57','Add a <code>label</code> element that surrounds the control\'s <code>label</code>. Set the <code>for</code> attribute on the <code>label</code> element to the same value as the <code>id</code> attribute of the control. And/or add a <code>title</code> attribute to the <code>input</code> element. And/or create a <code>label</code> element that contains the <code>input</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_58','Add an <code>alt</code> attribute that describes the image to <code>input</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_63','Add a \"value\" attribute to the <code>input</code> element. Set the text in the \"value\" attribute to the default text for the control.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_64','Add an <code>alt</code> attribute to this <code>area</code> element. The <code>alt</code> attribute should describe the link destination and make sense when read out of context.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_69','Remove the <code>marquee</code> element (replace with <code>strong</code> or <code>em</code>).','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_7','Add Alt text that identifies the purpose or function of the image.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_71','Use a server-side redirect or place a link on the page that allows users to go to the new page.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_72','Remove the <code>meta</code> element from the document or set the <code>content</code> attribute value to zero.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_78','Add a <code>title</code> attribute to your <code>object</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_79','Modify the <code>title</code> attribute to your <code>object</code> element so it contains text.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_9','Immediately following the image, add an anchor that links to your long description file. The text of the anchor should be the letter \'d\'.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_90','Add a <code>noscript</code> section immediately following the <code>script</code> that provides the same functionality as the <code>script</code>.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_91','Add a <code>label</code> element that surrounds the control\'s <code>label</code>. Set the <code>for</code> attribute on the <code>label</code> element to the same value as the <code>id</code> attribute of the control. And/or add a <code>title</code> attribute to the <code>input</code> element. And/or create a <code>label</code> element that contains the <code>input</code> element.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_95','Add a <code>label</code> element immediately before or after the <code>textarea</code> element. Set the <code>for</code> attribute value of the <code>label</code> element to the same value as the <code>id</code> attribute value of the <code>textarea</code> element. Add label text to the <code>label</code> element. Or, set the <code>title</code> attribute value to the <code>textarea</code> element to the label text. Or, add a <code>label</code> element that surrounds the <code>textarea</code> element and add label text.','2008-11-24 13:02:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_HOWTOREPAIR_96','Position the control\'s label so it is close to the control.','2011-02-01 14:58:37','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_10','review postponed until we develop a test for flicker','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_109','move to CSS test suite','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_116','now allowed','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_117','now allowed','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_12','if using ismap then should not use usemap','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_126','no longer needed','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_132','ismap precludes text links','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_135','review postponed until issues with MathML resolved','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_138','tab order covered by user UAAG','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_139','tab order covered by user UAAG','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_140','tab order covered by user UAAG','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_141','tab order covered by user UAAG','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_142','tab order covered by user UAAG','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_143','does not improve accessibility','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_144','does not improve accessibility','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_15','covered by tests 174 and 197','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_159','test not useful','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_2','covered by test 6','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_264','tab order covered by user UAAG','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_301','The repair example shows black text on a white background, which provides better than 4.5:1 contrast.','2011-01-12 11:35:36','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_302','The style above the div in the repair example, sets the visited link text to blue, which provides a contrast ratio greater than 4.5:1 for visited link text over the white background of the surrounding div.','2011-01-19 10:39:27','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_303','The style above the div in the repair example, sets the active link text to blue, which provides a contrast ratio greater than 4.5:1 for active link text over the white background of the surrounding div.','2011-01-19 10:46:37','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_304','The style above the div in the repair example, sets the hover link text to blue, which provides a contrast ratio greater than 4.5:1 for selected link text over the white background of the surrounding div.','2011-01-19 10:50:41','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_305','The style above the div in the repair example, sets the link text to blue, which provides a contrast ratio greater than 4.5:1 for link text over the white background of the surrounding div.','2011-01-19 10:56:26','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_306','The repair example shows black text on a white background, which provides better than 7:1 contrast.','2011-01-19 11:20:21','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_307','The style above the div in the repair example sets the visited link text to black, which provides a contrast ratio greater than 7:1 for visited link text over the white background of the surrounding div.','2011-01-19 11:20:34','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_308','The style above the div in the repair example, sets the active link text to black, which provides a contrast ratio greater than 7:1 for active link text over the white background of the surrounding div.','2011-01-19 11:12:12','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_309','The style above the div in the repair example, sets the hover link text to black, which provides a contrast ratio greater than 7:1 for selected link text over the white background of the surrounding div.','2011-01-19 11:15:43','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_310','The style above the div in the repair example, sets the link text to black, which provides a contrast ratio greater than 7:1 for active link text over the white background of the surrounding div.','2011-01-19 11:19:54','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_34','not needed due to other tests','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_35','good frameset support','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_36','good frameset support','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_4','covered by test 178','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_41','any header after an h5 is OK','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_6','accepted by group but still need to define placeholder text','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_60','covered by test 3','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_63','no longer needed','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_7','covered by tests 174 and 197','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_70','menu element is deprecated','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_9','contentious - should review','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_NOTE_97','move to CSS test suite','2008-11-24 11:43:39','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_1','1. Check each <code>img</code> element for the presence of an <code>alt</code> attribute.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_10','1. Check each <code>img</code> element that has a <code>src</code> attribute value ending in \'.gif\'.\n2. View the associated image and determine if it flickers using the general flash threshold and red flash threshold.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_100','1. Check each <code>blockquote</code> element in the content.\n2. Check if the text enclosed by the <code>blockquote</code> element is really a quote.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_101','1. Check each I<code>frame</code> element in the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_102','1. Check each element in the document for an <code>onclick</code> attribute.\n2. If the element contains an <code>onclick</code> attribute then check if it also contains an <code>onkeypress</code> attribute.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_103','1. Check each element in the document for an <code>ondblclick</code>  attribute.\n2. Check if there are keyboard operations that perform the same function.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_104','1. Check each element in the document for an <code>onmousedown</code> attribute.\n2. If the element contains an <code>onmousedown</code> attribute then check if it also contains an <code>onkeydown</code> attribute.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_105','1. Check each element in the document for an <code>onmousemove</code> attribute.\n2. Check if there are keyboard operations that perform the same function.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_106','1. Check each element in the document for an <code>onmouseout</code> attribute.\n2. If the element contains an <code>onmouseout</code> attribute then check if it also contains an <code>onblur</code> attribute.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_107','1. Check each element in the document for an <code>onmouseover</code> attribute.\n2. If the element contains an <code>onmouseover</code> attribute then check if it also contains a valid <code>onfocus</code> attribute.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_108','1. Check each element in the document for an <code>onmouseup</code> attribute.\n2. If the element contains an <code>onmouseup</code> attribute then check if it also contains a valid <code>onkeyup</code> attribute.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_109','1. Check the document for the <code>style</code> attribute on any element.\n2. Remove or disable any <code>style</code> attributes.\n3. View the page and discern if it is still readable.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_11','1. For each <code>img</code> element in the document, check if the associated image contains any text.\n2. If the image contains text, check if the text is decorative.\n3. Note: For this document, \"decorative\" is defined as \"content that does not provide information, functionality, sensory experience and is neither multimedia nor time-dependent interactive\".\n4. If the text is not decorative, check if the text appears in the <code>longdesc</code> attribute or elsewhere in the document content.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_110','1. Check the document for any words or phrases that are not in the document\'s primary language.\n2. Check if these words are marked using the <code>lang</code> attribute.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_111','1. Check all data tables in the document.\n2. Determine if the table is complex enough to require a summary.\n3. Note: A table is complex if it has several sets of row or column headers, or if it has multiple groups of columns or rows.\n4. Check if the table has a <code>summary</code> attribute.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_112','1. Check all data <code>table</code>s in the document.\n2. Note: This <code>table</code> has been identified as a data <code>table</code> because it contains <code>th</code> elements. If this is a layout <code>table</code> then remove the <code>th</code> elements from the <code>table</code>.\n3. Check if each <code>table</code> element has a <code>summary</code> attribute which contains at least one printable character.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_113','1. For all data tables, check the <code>summary</code> attribute of <code>table</code> element and determine its length.\n2. Note: This <code>table</code> has been identified as a data <code>table</code> because it contains <code>th</code> elements. If this is a layout <code>table</code> then remove the <code>th</code> elements from the <code>table</code>.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_114','1. View all tables in the document.\n2. Determine if the table is used for layout purposes.\n3. Check the <code>summary</code> attribute of the <code>table</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_115','1. View all tables in the document.\n2. Determine if the table is used for layout purposes.\n3. Check if the table contains a <code>caption</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_116','1. Find any <code>b</code> elements in the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_117','1. Find any <code>i</code> (italic) elements in the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_118','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"password\".\n2. The <code>input</code> element must have an explicitly associated label using one or more of the following methods.\n3. The <code>input</code> element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.\n4. and/or\n5. The <code>input</code> element has a <code>title</code> attribute.\n6. and/or\n7. The <code>input</code> element is contained by a <code>label</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_119','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"checkbox\".\n2. The <code>input</code> element must have an explicitly associated label using one or more of the following methods.\n3. The <code>input</code> element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.\n4. and/or\n5. The <code>input</code> element has a <code>title</code> attribute.\n6. and/or\n7. The <code>input</code> element is contained by a <code>label</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_12','1. Check each <code>img</code> element that contains a <code>ismap</code> attribute.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_120','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"file\".\n2. The <code>input</code> element must have an explicitly associated label using one or more of the following methods.\n3. The <code>input</code> element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.\n4. and/or\n5. The <code>input</code> element has a <code>title</code> attribute.\n6. and/or\n7. The <code>input</code> element is contained by a <code>label</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_121','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"radio\".\n2. The <code>input</code> element must have an explicitly associated label using one or more of the following methods.\n3. The <code>input</code> element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.\n4. and/or\n5. The <code>input</code> element has a <code>title</code> attribute.\n6. and/or\n7. The <code>input</code> element is contained by a <code>label</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_122','1. Check all <code>input</code>  elements that have a <code>type</code> attribute value of \"password\".\n2. View the <code>input</code> element within the document and check the positioning of its label.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_123','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"checkbox\".\n2. View the <code>input</code> element within the document and check the positioning of its label.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_124','1. Check all <code>input</code>  elements that have a <code>type</code> attribute value of \"file\".\n2. View the <code>input</code> element within the document and check the positioning of its label.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_125','1. Check all <code>input</code>  elements that have a <code>type</code> attribute value of \"radio\".\n2. View the <code>input</code> element within the document and check the positioning of its label.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_126','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"text\".\n2. Check if the VALUE attribute value on the <code>input</code> element contains any text.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_127','1. Check the text equivalent for all <code>object</code> elements in the content.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_128','1. Remove or disable each <code>object</code> element in the content.\n2. View the content with the <code>object</code> removed or disabled.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_129','1. View each <code>object</code> within the document.\n2. Test the user interface of each object and check if it can be operated by the keyboard.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_13','1. Check each <code>img</code> element that contains a <code>usemap</code> attribute.\n2. Find the MAP element that is referred by the <code>usemap</code> attribute.\n3. Check if each <code>area</code> element in the MAP contains a duplicate link in the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_131','1. View the text within the document and identify and block quotes.\n2. Check if the text blocks are marked using the <code>blockquote</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_132','1. For each <code>img</code> element containing an <code>ismap</code> attribute, view the links in the server-side map.\n2. For each active area in the server-side image map, find an equivalent text link within the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_133','1. Check each layout <code>table</code> in the document.\n2. View the <code>table</code> cells in order starting at the top left corner and work row by row to the bottom right corner.\n3. Check if the <code>table</code> cells make sense when viewed one at a time in order.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_134','1. Check each <code>a</code> (anchor) element for a following <code>a</code> (anchor) element.\n2. If two <code>a</code> (anchor) elements are adjacent then check if there is a printable character (not tab or \'space\') between the 2 elements.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_135','1. Check each <code>img</code> element in the content.\n2. Discern if there are any math expressions in the image.\n3. If the image does contain a math expression then check the content for MathML markup that is equivalent to the math expression.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_136','1. Check each data <code>table</code> and determine if it contains <code>th</code> elements.\n2. Note: This <code>table</code> has been identified as a layout <code>table</code> because it does not contain <code>th</code> elements. If this is a data <code>table</code> then add <code>th</code> elements to the <code>table</code>','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_137','1. Check each table in the document.\n2. Determine if the table is used for layout purposes.\n3. Check if the table contains <code>th</code> elements.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_138','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"text\".\n2. Check if the <code>input</code> element contains a <code>tabindex</code> attribute.\n3. Check if the <code>tabindex</code> attribute value contains one or more characters.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_139','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"radio\".\n2. Check if the <code>input</code> element contains a <code>tabindex</code> attribute.\n3. Check if the <code>tabindex</code> attribute value contains one or more characters.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_14','1. View the text of the document.\n2. Check each image in the document.\n3. View the alt text for each image.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_140','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"password\".\n2. Check if the <code>input</code> element contains a <code>tabindex</code> attribute.\n3. Check if the <code>tabindex</code> attribute value contains one or more characters.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_141','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"checkbox\".\n2. Check if the <code>input</code> element contains a <code>tabindex</code> attribute.\n3. Check if the <code>tabindex</code> attribute value contains one or more characters.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_142','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"file\".\n2. Check if the <code>input</code> element contains a <code>tabindex</code> attribute.\n3. Check if the <code>tabindex</code> attribute value contains one or more characters.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_143','1. Check the content for an <code>address</code> element.\n2. If an <code>address</code> element is found, check if it contains a valid address of the author.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_144','1. Check the content for an <code>address</code> element.\n2. If an <code>address</code> element is found, check if it contains a valid address of the author.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_145','1. Check each <code>a</code> (anchor) element in the content.\n2. Check the <code>href</code> attribute value for a multimedia file extension.\n3. Common multimedia file extensions are .wmv, .mpg, .mov, .ram, and .aif.\n4. If the document contains a link to a multimedia file, then check for a link to a text alternative.\n5. The link to the text alternative must be immediately before or immediately after the link to the multimedia file.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_146','1. Check each <code>object</code> element for a <code>type</code> attribute value of \"video\".\n2. If this <code>object</code> is found then check the content for either a text equivalent for the <code>object</code> file or a link to a text equivalent.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_147','1. Check if the document is part of a collection that has a reading order (e.g. a book).\n2. If part of a collection, check the <code>head</code> section of the document for <code>link</code> elements.\n3. Determine if the <code>link</code> elements contain links to other documents within the collection.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_148','1. Check if there is another document with more accessible or alternate content for this content.\n2. If there is an alternate document, check the HEAD section of this content for <code>link</code> elements that link to the alternate content.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_149','1. TODO.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_15','1. Check each <code>img</code> element that is contained by a source <code>a</code> (anchor) element.\n2. Check the <code>alt</code> attribute value and the <code>a</code> (anchor) destination.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_150','1. TODO.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_151','1. Check all data tables in the document.\n2. Check for the presence of a <code>caption</code>.\n3. Check the document to see if the table is identified.\n4. Note: The table identification should be close to (immediately precede) the table.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_152','1. Check the contents of all <code>th</code> elements in the document.\n2. If the <code>th</code> element content is greater than 20 characters then check if there is an <code>abbr</code> attribute on the <code>th</code> element.\n3. Check if the <code>abbr</code> attribute value is an abbreviation for the <code>th</code> element content.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_153','1. Check the <code>abbr</code> attribute values of all <code>th</code> elements.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_154','1. Check the contents of all <code>pre</code> elements in the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_155','1. TODO.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_156','1. TODO.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_157','1. TODO.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_158','1. TODO.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_159','1. Check all <code>img</code> elements for the presence of a <code>title</code> attribute.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_16','1. Check each <code>img</code> element and view its Alt text.\n2. Determine if the image is decorative.\n3. Note: For this document, \"decorative\" is defined as \"content that does not provide information, functionality, sensory experience and is neither multimedia nor time-dependent interactive\".','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_160','1. Check all <code>object</code> elements for the presence of a long description.\n2. [editor note: where should the long description be?]','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_161','1. TODO.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_162','1. TODO.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_163','1. Check each <code>embed</code> element in the document.\n2. Check if there is a <code>noembed</code> element within the <code>embed</code> element or immediately following the <code>embed</code> element.\n3. Check if the <code>noembed</code> element contains a text equivalent to the <code>embed</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_164','1. TODO.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_165','1. TODO.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_166','1. TODO.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_167','1. TODO.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_168','1. For each form in the document, check if there are radio buttons that contain the same <code>name</code> attribute.\n2. If there are multiple radio buttons with the same <code>name</code> attribute, check if they are contained by a <code>fieldset</code> element.\n3. If there is a <code>fieldset</code> element that contains multiple radio buttons, check if the <code>fieldset</code> element contains a <code>legend</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_169','1. TODO.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_17','1. Check each <code>a</code> (anchor) element that contains an <code>href</code> attribute value that ends\n        with a sound file extension.\n2. Sound file extensions are: (all case insensitive): .wav, .snd, .mp3, .iff, .svx, .sam, .smp, .vce, .vox, .pcm, .aif\n3. Listen to the sound file to determine if it requires a text transcript.\n4. If the sound file requires a text transcript, check if the document contains the text transcript or a link to it.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_173','1. Check the text contained by each <code>a</code> (anchor) element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_174','1. View the link text for each source <code>a</code> (anchor) element.\n2. Note: A source <code>a</code> (anchor) element must contain an <code>href</code> attribute.\n3. Note: The link text may be contained in the body text of the <code>a</code> (anchor) element or the Alt text of an image used as a link.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_175','1. Check all <code>img</code> elements that occur within a source <code>a</code> (anchor) element.\n2. Compare the Alt text of the image to the link text.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_176','1. Check the document for any <code>basefont</code> elements.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_177','1. Check the document for any <code>font</code> elements.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_178','1. Check each <code>img</code> element that is not a source anchor and view the associated image and Alt text.\n2. Note: If the <code>img</code> element is contained by an <code>a</code> (anchor) element and the <code>a</code> (anchor) element has a valid <code>href</code> attribute value then the image is a source anchor.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_179','1. TODO.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_18','1. Check each <code>a</code> (anchor) element that contains a <code>target</code> attribute.\n2. Ignore an <code>a</code> (anchor) elements that contain a <code>target</code> attribute value of _self, _top, or _parent.\n3. Check the document text to see if there is a warning to the user that the <code>a</code> (anchor) element opens a new window.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_180','1. Check each <code>a</code> (anchor) element for a following <code>a</code> (anchor) element.\n2. If the <code>a</code> (anchor) element has a following <code>a</code> (anchor) element then check if both elements have the same destination (the values of their <code>href</code> attribute match).','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_181','1. Check the HREF value of each <code>a</code> (anchor) element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_182','1. Check the <code>body</code> element in the HTML document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_183','1. Check the HTML code contained by each <code>object</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_184','1. Check is this page is part of a collection of pages.\n2. If part of a collection, check if there is a site map for the collection.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_185','1. Check each <code>id</code> attribute to see if it is unique to the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_186','1. Check each <code>label</code> element to see if it contains an <code>input</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_187','1. Check all <code>input</code> elements and view their associated labels.\\r\\n2. Note: For information on what constitutes an associated label please see test 57.','2009-04-01 12:05:26','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_188','1. Check the associated label for all <code>input</code> elements.\n2. Note: For information on what constitutes an associated label please see test 57.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_189','1. Check all <code>input</code> elements and view their associated label.\n2. Note: For information on what constitutes an associated label please see test 57.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_19','1. Check each <code>a</code> (anchor) element that contains one or more characters.\r\n2. View the link text and confirm that it is meaningful when read out of context.','2011-01-13 14:48:16','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_190','1. Check each source <code>a</code> (anchor) element for the presence of a <code>title</code> attribute.\n2. Note that a source <code>a</code> (anchor) element must contain an <code>href</code> attribute.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_191','1. Check the <code>title</code> attribute value of each source <code>a</code> (anchor) element to determine if it describes the link destination.\n2. Note that a source <code>a</code> (anchor) element must contain an <code>href</code> attribute.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_192','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"image\".\n2. View the Alt text for the <code>input</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_193','1. For each <code>input</code> element that has a <code>type</code> attribute value of \"image\", check if the associated image contains any text.\n2. If the image contains text, check if the text is decorative.\n3. Note: For this document, \"decorative\" is defined as \"content that does not provide information, functionality, sensory experience and is neither multimedia nor time-dependent interactive\".','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_194','1. For each <code>area</code> element, check if the associated image contains any text.\n2. If the image contains text, check if the text is decorative.\n3. Note: For this document, \"decorative\" is defined as \"content that does not provide information, functionality, sensory experience and is neither multimedia nor time-dependent interactive\".','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_195','1. View the link text for each source <code>a</code> (anchor) element.\\r\\n2. Note: A source <code>a</code> (anchor) element must contain an <code>href</code> attribute.\\r\\n3. Note: The link text may be contained in the body text of the <code>a</code> (anchor) element or the Alt text of an image used as a link.','2009-04-01 12:52:34','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_196','1. Check each <code>img</code> element that contains a <code>ismap</code> attribute.\n2. Check if the active regions of the image map can be defined using available geometric shapes.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_197','1. View the link text for each source <code>a</code> (anchor) element.\n2. Note: A source <code>a</code> (anchor) element must contain an <code>href</code> attribute.\n3. Note: The link text may be contained in the body text of the <code>a</code> (anchor) element or the Alt text of an image used as a link.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_198','1. View the text contained by each <code>legend</code> element.\n2. View the group of choices associated with the <code>legend</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_199','1. View the text contained by each <code>legend</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_2','1. Check each <code>img</code> element and compare its <code>alt</code> attribute value to its <code>src</code> attribute value.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_20','1. Check each <code>a</code> (anchor) element that contains an <code>href</code> attribute value that ends\n        with a multi-media file extension.\n2. Sound file extensions are: (all case insensitive): .wmv, .mpg, .mov, .ram, .aif\n3. View the document text.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_200','1. View the text contained by each <code>legend</code> element and compare it to the list of placeholder values.\\r\\n2. Placeholder values are \"legend\".','2011-02-01 14:59:01','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_201','1. View the <code>title</code> attribute of each <code>frame</code> element in the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_202','1. Check each <code>frame</code> element and compare its <code>title</code> attribute value to the list of placeholder values.\\r\\n2. <code>frame</code> <code>title</code> placeholder values are: \'title\', \'the title\' and \'frame title\'.','2011-02-01 14:59:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_203','1. Check the contents of the summary attribute for each data table.\n2. Determine if the summary describes navigation and structure of the table.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_204','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"radio\".\n2. The <code>input</code> element must have an explicitly associated label using one or more of the following methods.\n3. The <code>input</code> element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.\n4. and/or\n5. The <code>input</code> element has a <code>title</code> attribute.\n6. and/or\n7. The <code>input</code> element is contained by a <code>label</code> element.\n8. Check if the label contains text.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_205','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"file\".\n2. The <code>input</code> element must have an explicitly associated label using one or more of the following methods.\n3. The <code>input</code> element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.\n4. and/or\n5. The <code>input</code> element has a <code>title</code> attribute.\n6. and/or\n7. The <code>input</code> element is contained by a <code>label</code> element.\n8. Check if the label text describes the purpose or function of the control.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_206','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"checkbox\".\n2. The <code>input</code> element must have an explicitly associated label using one or more of the following methods.\n3. The <code>input</code> element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.\n4. and/or\n5. The <code>input</code> element has a <code>title</code> attribute.\n6. and/or\n7. The <code>input</code> element is contained by a <code>label</code> element.\n8. Check if the label contains text.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_207','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"password\".\n2. The <code>input</code> element must have an explicitly associated label using one or more of the following methods.\n3. The <code>input</code> element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.\n4. and/or\n5. The <code>input</code> element has a <code>title</code> attribute.\n6. and/or\n7. The <code>input</code> element is contained by a <code>label</code> element.\n8. Check if the label contains text.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_208','1. Check the associated label for all <code>select</code> elements.\n2. Note: For information on what constitutes an associated label please see test 57.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_209','1. Check all <code>select</code> elements\\r\\n2. View the <code>select</code> element within the document and check the positioning of its label.','2009-04-23 10:07:33','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_21','1. View the operation of each <code>applet</code> in the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_210','1. Check all <code>select</code> elements within the document.\n2. View the <code>select</code> element\'s associated label.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_211','1. Check all <code>input</code>  elements that have a <code>type</code> attribute value of \"text\".\n2. View the <code>input</code> element within the document and check the positioning of its label.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_212','1. Check all <code>textarea</code> elements.\n2. The <code>textarea</code> element must have an explicitly associated label using one or more of the following methods.\n3. The <code>textarea</code> element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.\n4. and/or\n5. The <code>textarea</code> element has a <code>title</code> attribute.\n6. and/or\n7. The <code>textarea</code> element is contained by a <code>label</code> element.\n8. Check if the label contains text.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_213','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"text\".\n2. The <code>input</code> element must have an explicitly associated label using one or more of the following methods.\n3. The <code>input</code> element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.\n4. and/or\n5. The <code>input</code> element has a <code>title</code> attribute.\n6. and/or\n7. The <code>input</code> element is contained by a <code>label</code> element.\n8. Check if the label contains text.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_214','1. Check all <code>textarea</code> elements.\n2. The <code>textarea</code> element must have an explicitly associated label using one or more of the following methods.\n3. The <code>textarea</code> element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.\n4. and/or\n5. The <code>textarea</code> element has a <code>title</code> attribute.\n6. and/or\n7. The <code>textarea</code> element is contained by a <code>label</code> element.\n8. Check if the label text describes the purpose or function of the control.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_216','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"file\".\n2. The <code>input</code> element must have an explicitly associated label using one or more of the following methods.\n3. The <code>input</code> element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.\n4. and/or\n5. The <code>input</code> element has a <code>title</code> attribute.\n6. and/or\n7. The <code>input</code> element is contained by a <code>label</code> element.\n8. Check if the label contains text.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_217','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"password\".\n2. The <code>input</code> element must have an explicitly associated label using one or more of the following methods.\n3. The <code>input</code> element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.\n4. and/or\n5. The <code>input</code> element has a <code>title</code> attribute.\n6. and/or\n7. The <code>input</code> element is contained by a <code>label</code> element.\n8. Check if the label text describes the purpose or function of the control.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_218','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"text\".\n2. The <code>input</code> element must have an explicitly associated label using one or more of the following methods.\n3. The <code>input</code> element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.\n4. and/or\n5. The <code>input</code> element has a <code>title</code> attribute.\n6. and/or\n7. The <code>input</code> element is contained by a <code>label</code> element.\n8. Check if the label text describes the purpose or function of the control.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_219','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"checkbox\".\n2. The <code>input</code> element must have an explicitly associated label using one or more of the following methods.\n3. The <code>input</code> element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.\n4. and/or\n5. The <code>input</code> element has a <code>title</code> attribute.\n6. and/or\n7. The <code>input</code> element is contained by a <code>label</code> element.\n8. Check if the label text describes the purpose or function of the control.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_22','1. View the operation of each <code>applet</code> in the document.\n2. Determine if the applet flickers according to the general flash threshold and red flash threshold.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_220','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"radio\".\n2. The <code>input</code> element must have an explicitly associated label using one or more of the following methods.\n3. The <code>input</code> element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.\n4. and/or\n5. The <code>input</code> element has a <code>title</code> attribute.\n6. and/or\n7. The <code>input</code> element is contained by a <code>label</code> element.\n8. Check if the label text describes the purpose or function of the control.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_221','1. Check if the <code>text</code> attribute value and the <code>bgcolor</code> attribute value of the <code>body</code> element are set.\n2. If these 2 attribute values are not set then the test passes. If these 2 attribute values are set then perform the following steps:\n3. Calculate the luminosity contrast ratio between the <code>text</code> attribute value and the <code>bgcolor</code> attribute value of the <code>body</code> element.\n4. The luminosity contrast ratio can be determined using the following formula:\n5. (L1+.05) / (L2+.05) where L is luminosity and is defined as .2126*R + .7152*G + .0722B using linearized R, G, and B values. Linearized R (for example) = (R/FS)^2.2 where FS is full scale value (255 for 8 bit color channels). L1 is the higher value (of text or background) and L2 is the lower value.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_222','1. Check if the <code>link</code> attribute value and the <code>bgcolor</code> attribute value of the <code>body</code> element are set.\n2. If these 2 attribute values are not set then the test passes. If these 2 attribute values are set then perform the following steps:\n3. Calculate the luminosity contrast ratio between the <code>link</code> attribute value and the <code>bgcolor</code> attribute value of the <code>body</code> element.\n4. The luminosity contrast ratio can be determined using the following formula:\n5. (L1+.05) / (L2+.05) where L is luminosity and is defined as .2126*R + .7152*G + .0722B using linearized R, G, and B values. Linearized R (for example) = (R/FS)^2.2 where FS is full scale value (255 for 8 bit color channels). L1 is the higher value (of text or background) and L2 is the lower value.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_223','1. Check if the <code>alink</code> attribute value and the <code>bgcolor</code> attribute value of the <code>body</code> element are set.\n2. If these 2 attribute values are not set then the test passes. If these 2 attribute values are set then perform the following steps:\n3. Calculate the luminosity contrast ratio between the <code>alink</code> attribute value and the <code>bgcolor</code> attribute value of the <code>body</code> element.\n4. The luminosity contrast ratio can be determined using the following formula:\n5. (L1+.05) / (L2+.05) where L is luminosity and is defined as .2126*R + .7152*G + .0722B using linearized R, G, and B values. Linearized R (for example) = (R/FS)^2.2 where FS is full scale value (255 for 8 bit color channels). L1 is the higher value (of text or background) and L2 is the lower value.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_224','1. Check if the <code>vlink</code> attribute value and the <code>bgcolor</code> attribute value of the <code>body</code> element are set.\n2. If these 2 attribute values are not set then the test passes. If these 2 attribute values are set then perform the following steps:\n3. Calculate the luminosity contrast ratio between the <code>vlink</code> attribute value and the <code>bgcolor</code> attribute value of the <code>body</code> element.\n4. The luminosity contrast ratio can be determined using the following formula:\n5. (L1+.05) / (L2+.05) where L is luminosity and is defined as .2126*R + .7152*G + .0722B using linearized R, G, and B values. Linearized R (for example) = (R/FS)^2.2 where FS is full scale value (255 for 8 bit color channels). L1 is the higher value (of text or background) and L2 is the lower value.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_225','1. Check the document type declaration (DTD) in the document.\n2. The DTD must be either one of the following:\n3. <!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\n4. <!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_226','1. Calculate the color difference and the color brightness difference between the <code>text</code> attribute value and the <code>bgcolor</code> attribute value of the <code>body</code> element.\n2. The color difference can be determined using the following formula:\n3. (maximum (Red value 1, Red value 2) - minimum (Red value 1, Red value 2)) + (maximum (Green value 1, Green value 2) - minimum (Green value 1, Green value 2)) + (maximum (Blue value 1, Blue value 2) - minimum (Blue value 1, Blue value 2))\n4. The color brightness difference can be determined using the following formula:\n5. ((Red value X 299) + (Green value X 587) + (Blue value X 114)) / 1000','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_227','1. Calculate the color difference and the color brightness difference between the <code>link</code> attribute value and the <code>bgcolor</code> attribute value of the <code>body</code> element.\n2. The color difference can be determined using the following formula:\n3. (maximum (Red value 1, Red value 2) - minimum (Red value 1, Red value 2)) + (maximum (Green value 1, Green value 2) - minimum (Green value 1, Green value 2)) + (maximum (Blue value 1, Blue value 2) - minimum (Blue value 1, Blue value 2))\n4. The color brightness difference can be determined using the following formula:\n5. ((Red value X 299) + (Green value X 587) + (Blue value X 114)) / 1000','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_228','1. Calculate the color difference and the color brightness difference between the <code>alink</code> attribute value and the <code>bgcolor</code> attribute value of the <code>body</code> element.\n2. The color difference can be determined using the following formula:\n3. (maximum (Red value 1, Red value 2) - minimum (Red value 1, Red value 2)) + (maximum (Green value 1, Green value 2) - minimum (Green value 1, Green value 2)) + (maximum (Blue value 1, Blue value 2) - minimum (Blue value 1, Blue value 2))\n4. The color brightness difference can be determined using the following formula:\n5. ((Red value X 299) + (Green value X 587) + (Blue value X 114)) / 1000','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_229','1. Calculate the color difference and the color brightness difference between the <code>vlink</code> attribute value and the <code>bgcolor</code> attribute value of the <code>body</code> element.\n2. The color difference can be determined using the following formula:\n3. (maximum (Red value 1, Red value 2) - minimum (Red value 1, Red value 2)) + (maximum (Green value 1, Green value 2) - minimum (Green value 1, Green value 2)) + (maximum (Blue value 1, Blue value 2) - minimum (Blue value 1, Blue value 2))\n4. The color brightness difference can be determined using the following formula:\n5. ((Red value X 299) + (Green value X 587) + (Blue value X 114)) / 1000','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_23','1. View the <code>alt</code> attribute value for the <code>applet</code>.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_230','1. View the table and determine if <code>thead</code>, <code>tfoot</code> and <code>tbody</code> elements are required to group table row structures.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_231','1. View the table and determine if <code>colgroup</code> or <code>col</code> elements are required to group table column structures.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_232','1. Validate the document using a validator service.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_233','1. Find any <code>frameset</code> elements in the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_234','1. Find any <code>frame</code> elements in the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_235','1. Examine the reading direction of text in the document.\n2. If the reading direction is right-to-left, check that for the nearest parent element that has a <code>dir</code> attribute, the attribute has the value \"rtl\".\n3. If the reading direction is left-to-right, check that there is no parent element with a <code>dir</code> attribute, or that for the nearest parent element that has a <code>dir</code> attribute, the attribute has the value \"ltr\".','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_236','1. Check each <code>a</code> element in the document that contains an <code>img</code> element.\\r\\n2. Check if there is an adjacent <code>a</code> element with the same <code>href</code> attribute value.\\r\\n3. Note that the adjacent <code>a</code> element may be in an adjacent table cell.','2009-04-01 14:06:13','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_237','1. Check each <code>form</code> element in the document.\n2. Check the label for the submit button on the form and compare it to the label on submit buttons for all other forms.\n3. Note: The submit button label may be the <code>alt</code> attribute value of <code>input</code> elements with a <code>type</code> attribute value of \"image\" or the <code>value</code> attribute value of <code>input</code> elements with a <code>type</code> attribute value of \"submit\"\n4. Check if the forms lead to different results.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_238','1. Check each <code>input</code> element in the document.\n2. Check the <code>type</code> attribute value of the <code>input</code> element.\n3. Check for the presence of an <code>alt</code> attribute.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_239','1. Check each <code>img</code> element and check for a <code>title</code> attribute.\n2. Determine if the image is decorative.\n3. Note: For this document, \"decorative\" is defined as \"content that does not provide information, functionality, sensory experience and is neither multimedia nor time-dependent interactive\".','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_24','1. Check the text equivalent for each <code>applet</code> element in the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_240','1. Check each <code>a</code> (anchor) element in the document.\n2. Check the <code>href</code> attribute value for a multimedia file extension.\n3. Common multimedia file extensions are .wmv, .mpg, .mov, .ram, and .aif.\n4. Find the text alternative file that is associated with the multimedia file.\n5. View the multimedia file and view the text alternative file.\n6. Check that the dialogue in the text alternative matches the dialogue in the multimedia presentation.\n7. Check that the text alternative has descriptions of sounds.\n8. Check that the text alternative has descriptions of setting and setting changes.\n9. Check that the text alternative has descriptions of actions and expressions of any \'actors\' (people, animals etc).','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_241','1. Check the text content of the document.\r\n2. Check for any information that is presented in a tabular manner.\r\n3. Unstructured tabular information is detected where multiple tab spaces, or multiple pipe characters are found in a single line.','2011-01-24 14:59:17','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_242','1. View the table and the caption.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_243','1. Check each data table in the document.\n2. View the table summary and caption.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_244','1. Check each data table in the document.\n2. Check if the table contains both row and column headers.\n3. Check if the header cells contain a <code>scope</code> attribute that identifies the cells that relate to the header.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_245','1. Check each data table in the document.\n2. Check if the table contains more than one row or either row or column headers.\n3. Check if the table cells contain <code>id</code> and header attributes.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_246','1. View the <code>form</code>.\n2. Determine which fields are required for submission of the <code>form</code>.\n3. Check if the required fields are indicated to the user as required.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_247','1. For each form in the document, check if there are checkbox controls that contain the same <code>name</code> attribute.\n2. If there are multiple checkbox controls with the same <code>name</code> attribute, check if they are contained by a <code>fieldset</code> element.\n3. If there is a <code>fieldset</code> element that contains multiple checkbox controls, check if the <code>fieldset</code> element contains a <code>legend</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_248','1. View the document and find any visual lists.\n2. Determine if the lists contain proper markup.\n3. Note: The proper markup for visual lists includes the elements <code>li</code>, <code>ol</code>, <code>ul</code>, <code>dl</code> and <code>dt</code>.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_249','1. View the document text and determine if there is any emphasized or special text.\n2. Determine if there is markup used to indicate the emphasized or special text.\n3. Note: Semantic markup includes the elements <code>em</code>, <code>strong</code>, <code>dfn</code>, <code>code</code>, <code>samp</code>, <code>kbd</code>, <code>var</code>, <code>cite</code>, <code>abbr</code>, <code>acronym</code>, <code>sub</code> and <code>sup</code>.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_25','1. View the content of the <code>applet</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_250','1. View the document text and determine if there are references to other items in the document.\n2. Determine if the references use shape, size, or relative position alone.\n3. The references to other items must be indicated in ways that do not use visual perception.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_251','1. Check if the image contains any text.\n2. If the image contains text, calculate the luminosity contrast ratio between the text and the background color.\n3. The luminosity contrast ratio can be determined using the following formula:\n4. (L1+.05) / (L2+.05) where L is luminosity and is defined as .2126*R + .7152*G + .0722B using linearized R, G, and B values. Linearized R (for example) = (R/FS)^2.2 where FS is full scale value (255 for 8 bit color channels). L1 is the higher value (of text or background) and L2 is the lower value.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_252','1. Check the <code>body</code> element and determine if it contains any of the text colors <code>color</code>, <code>bgcolor</code>, <code>vlink</code>, <code>alink</code> or <code>link</code>.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_253','1. Check if the image contains any text.\n2. If the image contains text, calculate the luminosity contrast ratio between the text and the background color.\n3. The luminosity contrast ratio can be determined using the following formula:\n4. (L1+.05) / (L2+.05) where L is luminosity and is defined as .2126*R + .7152*G + .0722B using linearized R, G, and B values. Linearized R (for example) = (R/FS)^2.2 where FS is full scale value (255 for 8 bit color channels). L1 is the higher value (of text or background) and L2 is the lower value.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_254','1. Check if the <code>text</code> attribute value and the <code>bgcolor</code> attribute value of the <code>body</code> element are set.\n2. If these 2 attribute values are not set then the test passes. If these 2 attribute values are set then perform the following steps:\n3. Calculate the luminosity contrast ratio between the <code>text</code> attribute value and the <code>bgcolor</code> attribute value of the <code>body</code> element.\n4. The luminosity contrast ratio can be determined using the following formula:\n5. (L1+.05) / (L2+.05) where L is luminosity and is defined as .2126*R + .7152*G + .0722B using linearized R, G, and B values. Linearized R (for example) = (R/FS)^2.2 where FS is full scale value (255 for 8 bit color channels). L1 is the higher value (of text or background) and L2 is the lower value.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_255','1. Check if the <code>link</code> attribute value and the <code>bgcolor</code> attribute value of the <code>body</code> element are set.\n2. If these 2 attribute values are not set then the test passes. If these 2 attribute values are set then perform the following steps:\n3. Calculate the luminosity contrast ratio between the <code>link</code> attribute value and the <code>bgcolor</code> attribute value of the <code>body</code> element.\n4. The luminosity contrast ratio can be determined using the following formula:\n5. (L1+.05) / (L2+.05) where L is luminosity and is defined as .2126*R + .7152*G + .0722B using linearized R, G, and B values. Linearized R (for example) = (R/FS)^2.2 where FS is full scale value (255 for 8 bit color channels). L1 is the higher value (of text or background) and L2 is the lower value.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_256','1. Check if the <code>alink</code> attribute value and the <code>bgcolor</code> attribute value of the <code>body</code> element are set.\n2. If these 2 attribute values are not set then the test passes. If these 2 attribute values are set then perform the following steps:\n3. Calculate the luminosity contrast ratio between the <code>alink</code> attribute value and the <code>bgcolor</code> attribute value of the <code>body</code> element.\n4. The luminosity contrast ratio can be determined using the following formula:\n5. (L1+.05) / (L2+.05) where L is luminosity and is defined as .2126*R + .7152*G + .0722B using linearized R, G, and B values. Linearized R (for example) = (R/FS)^2.2 where FS is full scale value (255 for 8 bit color channels). L1 is the higher value (of text or background) and L2 is the lower value.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_257','1. Check if the <code>vlink</code> attribute value and the <code>bgcolor</code> attribute value of the <code>body</code> element are set.\n2. If these 2 attribute values are not set then the test passes. If these 2 attribute values are set then perform the following steps:\n3. Calculate the luminosity contrast ratio between the <code>vlink</code> attribute value and the <code>bgcolor</code> attribute value of the <code>body</code> element.\n4. The luminosity contrast ratio can be determined using the following formula:\n5. (L1+.05) / (L2+.05) where L is luminosity and is defined as .2126*R + .7152*G + .0722B using linearized R, G, and B values. Linearized R (for example) = (R/FS)^2.2 where FS is full scale value (255 for 8 bit color channels). L1 is the higher value (of text or background) and L2 is the lower value.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_258','1. Set keyboard focus to the <code>applet</code>.\n2. Determine if there is a keyboard mechanism to return keyboard focus to the parent window.\n3. Note: A common method of exiting an <code>applet</code> is to repeatedly press the \'tab\' key until the keyboard focus leaves the <code>applet</code>.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_259','1. Set keyboard focus to the <code>object</code>.\n2. Determine if there is a keyboard mechanism to return keyboard focus to the parent window.\n3. Note: A common method of exiting an <code>object</code> is to repeatedly press the \'tab\' key until the keyboard focus leaves the <code>object</code>.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_26','1. View the operation of each <code>applet</code> in the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_260','1. Set keyboard focus to the <code>embed</code>.\n2. Determine if there is a keyboard mechanism to return keyboard focus to the parent window.\n3. Note: A common method of exiting an <code>embed</code> is to repeatedly press the \'tab\' key until the keyboard focus leaves the <code>embed</code>.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_261','1. View the document content and find the major sections.\n2. Determine if there is a header prior to each section.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_262','1. View the document and find groups of links (anchor elements).\n2. Determine if the groups of links are related.\n3. Determine if the groups of links are marked.\n4. Note: Groups of links may be marked using the following elements: <code>ul</code>, <code>ol</code>, <code>div</code> or <code>map</code>.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_263','1. View the document and note the content that appears in each frame.\n2. Navigage the site so content in the frameset changes.\n3. Determine if the same type of content appears in the same frame.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_264','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"submit\".\n2. Check if the <code>input</code> element contains a <code>tabindex</code> attribute.\n3. Check if the <code>tabindex</code> attribute value contains one or more characters.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_265','1. Check the HTML code to see if the <code>tabindex</code> attribute is used.\n2. Start at the beginning of the document and view the keyboard focus change as you enter tab characters.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_266','1. Check if the document will be part of a collection.\n2. Check if the document contains a breadcrumb trail.\n3. Note: All elements in the breadcrumb trail must be implemented as links except for the current location.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_267','1. Check all forms in the document.\n2. Fill out the form leaving required fields blank and submit the form.\n3. Check that an error message is returned identifying the empty mandatory fields.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_268','1. Check all forms in the document.\n2. Fill out the form entering invalid data.\n3. Check that an error message is returned identifying the error with information that assists in correcting the error.\n4. The following are examples of information that assists in correcting the error:\n5. Examples of correct data entered into the form fields.\n6. Examples of correct data with directions on how to enter them into the form fields.\n7. A description of correct data.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_269','1. Check all forms in the document.\n2. Determine if the form submission is irreversable.\n3. Check if the user is shown the form data and can correct it before commiting the irreversable action.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_27','1. Check for any <code>blink</code> elements in the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_270','1. Check all text in the document.\n2. Look for blocks of text where the reading direction changes.\n3. Check if neutral characters such as spaces or punctuation occur adjacent to text that is rendered in the non-default direction.\n4. Check if the HTML bidirectional algorithm would produce the wrong placement of the neutral characters\n5. Check if the neutral characters are followed by Unicode right-to-left or left-to-right marks that cause neutral characters to be placed as part of the preceding characters.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_271','1. Check all text in the document.\n2. Determine if there are blocks of text that are not in the primary document language.\n3. Determine if the blocks of text have a reading order that is different from the primary language.\n4. Check if the blocks of text are marked using the <code>dir</code> attribute.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_272','1. Use the form to delete information on the server.\n2. Check if there is a mechanism for recovering the information.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_273','1. Determine the reading order of the document\'s primary language.\n2. Check if there is a <code>dir</code> attribute on the html element.\n3. Check if the <code>dir</code> attribute\'s value is \"rtl\" for languages that are read left-to-right or \"ltr\" for languages that are read right-to-left.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_274','1. Move the keyboard focus through all document content.\n2. Watch for new windows to appear.\n3. If change of focus causes new window to appear check if there is a warning message to user.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_275','1. Determine which technologies are required by the page.\n2. Ensure all the technologies required by the page are present and turned on.\n3. Load the web page and check if any new windows were opened.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_276','1. Determine which components are repeated on all pages within the site.\n2. Check that the components appear in the same relative order on this page.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_28','1. Determine if the document contains a block of material prior to the main content.\n2. Check if the document contains a link that bypasses the block of material and goes to the main content.\n3. Check if the \"skip to content\" link is the first link in the document.\n4. Check if the \"skip to content\" link is identified properly (i.e. the link text is \"skip to content\" or \"skip navigation\").','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_29','1. Check for the presence of a <code>doctype</code> declaration at the start of the document.\n2. Check the content of the <code>doctype</code> declaration.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_3','1. For each <code>img</code> element, calculate the length of text within the <code>alt</code> attribute value.\r\n2. If the Alt text is greater than 100 characters (English) then it must be shortened or the user must confirm that it is the shortest Alt text possible.','2011-01-13 14:54:26','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_30','1. View the operation of each <code>object</code> element in your document.\n2. Determine if the <code>object</code> flickers using the general flash threshold and red flash threshold.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_301','1. Enter the URL, or upload the HTML of a Web page in which colour values are defined for text and/or backgrounds, to have the contrast evaluator determine the contrast ratio between text and background colours. \r\n2. For some contrast evaluation tools, enter the Hex colour codes (e.g #FFEE00) for the text and the background on which it appears to calculate the contrast ratio.','2011-01-19 10:23:40','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_302','1. Enter the URL, or upload the HTML of a Web page in which colour values are defined for text and/or backgrounds, to have the contrast evaluator determine the contrast ratio between text and background colours. \r\n2. For some contrast evaluation tools, enter the Hex colour codes (e.g #FFEE00) for the text and the background on which it appears to calculate the contrast ratio.','2011-01-19 10:39:27','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_303','1. Enter the URL, or upload the HTML of a Web page in which colour values are defined for text and/or backgrounds, to have the contrast evaluator determine the contrast ratio between text and background colours. \r\n2. For some contrast evaluation tools, enter the Hex colour codes (e.g #FFEE00) for the text and the background on which it appears to calculate the contrast ratio.','2011-01-19 10:46:37','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_304','1. Enter the URL, or upload the HTML of a Web page in which colour values are defined for text and/or backgrounds, to have the contrast evaluator determine the contrast ratio between text and background colours. \r\n2. For some contrast evaluation tools, enter the Hex colour codes (e.g #FFEE00) for the text and the background on which it appears to calculate the contrast ratio.','2011-01-19 10:52:03','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_305','1. Enter the URL, or upload the HTML of a Web page in which colour values are defined for text and/or backgrounds, to have the contrast evaluator determine the contrast ratio between text and background colours. \r\n2. For some contrast evaluation tools, enter the Hex colour codes (e.g #FFEE00) for the text and the background on which it appears to calculate the contrast ratio.','2011-01-19 10:56:26','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_306','1. Enter the URL, or upload the HTML of a Web page in which colour values are defined for text and/or backgrounds, to have the contrast evaluator determine the contrast ratio between text and background colours. \r\n2. For some contrast evaluation tools, enter the Hex colour codes (e.g #FFEE00) for the text and the background on which it appears to calculate the contrast ratio.','2011-01-19 11:20:21','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_307','1. Enter the URL, or upload the HTML of a Web page in which colour values are defined for text and/or backgrounds, to have the contrast evaluator determine the contrast ratio between text and background colours. \r\n2. For some contrast evaluation tools, enter the Hex colour codes (e.g #FFEE00) for the text and the background on which it appears to calculate the contrast ratio.','2011-01-19 11:20:34','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_308','1. Enter the URL, or upload the HTML of a Web page in which colour values are defined for text and/or backgrounds, to have the contrast evaluator determine the contrast ratio between text and background colours. \r\n2. For some contrast evaluation tools, enter the Hex colour codes (e.g #FFEE00) for the text and the background on which it appears to calculate the contrast ratio.','2011-01-19 11:20:56','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_309','1. Enter the URL, or upload the HTML of a Web page in which colour values are defined for text and/or backgrounds, to have the contrast evaluator determine the contrast ratio between text and background colours. \r\n2. For some contrast evaluation tools, enter the Hex colour codes (e.g #FFEE00) for the text and the background on which it appears to calculate the contrast ratio.','2011-01-19 11:24:55','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_31','1. Check each <code>frame</code> element in your document for the presence of a <code>title</code> attribute.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_310','1. Enter the URL, or upload the HTML of a Web page in which colour values are defined for text and/or backgrounds, to have the contrast evaluator determine the contrast ratio between text and background colours. \r\n2. For some contrast evaluation tools, enter the Hex colour codes (e.g #FFEE00) for the text and the background on which it appears to calculate the contrast ratio.','2011-01-19 11:19:54','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_32','1. Check the <code>title</code> attribute of each <code>frame</code> element in the content.\n2. View the content within the <code>frame</code>.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_33','1. Check the <code>src</code> attribute of each <code>frame</code> element in the content.\n2. View the content associated with the <code>src</code> attribute.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_34','1. Count the number of frames in each <code>frameset</code>.\n2. If the <code>frameset</code> contains 3 or more frames then check for a <code>longdesc</code> attribute on the <code>frameset</code> element.\n3. Check the content that is referenced by the <code>longdesc</code> attribute to see if it contains a description of the relationship between the frames.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_35','1. Check the contents of each <code>frameset</code> for the presence of a <code>noframes</code> section.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_36','1. Check the contents of each NOFRAMES element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_37','1. For each <code>h1</code> element, find the header element that follows it.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_38','1. For each <code>h2</code> element, find the header element that follows it.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_39','1. For each <code>h3</code> element, find the header element that follows it.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_4','1. Check each <code>img</code> element and view its <code>alt</code> attribute value.\n2. If the <code>alt</code> attribute value is an empty string (\"\") then proceed to the next step.\n3. Determine if the image has non-decorative content.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_40','1. For each <code>h4</code> element, find the header element that follows it.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_41','1. For each <code>h5</code> element, find the header element that follows it.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_42','1. Check the contents of each <code>h1</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_43','1. Check the contents of each <code>h2</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_44','1. Check the contents of each <code>h3</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_45','1. Check the contents of each <code>h4</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_46','1. Check the contents of each <code>h5</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_47','1. Check the contents of each <code>h6</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_48','1. Determine the <code>type</code> of document.\n2. If the content is HTML, check for the <code>html</code> element\'s <code>lang</code> attribute.\n3. If the content is XHTML 1.0, or any version of XHTML served as \"text/html\", check for both the <code>html</code> element\'s <code>lang</code> attribute and XML:<code>lang</code> attribute.\n4. If the content is XHTML 1.1 or higher and served as type \"application/xhtml+xml\", check for the <code>html</code> element\'s XML:<code>lang</code> attribute.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_49','1. Determine the type of content within the document.\r\n2. If the content is HTML, check the value of the <code>html</code> element\'s <code>lang</code> attribute.\r\n3. If the content is XHTML 1.0, or any version of XHTML served as \"text/html\", check the values of both the <code>html</code> element\'s <code>lang</code> attribute and <code>xml:lang</code> attribute.\r\n4. Note: both <code>lang</code> attributes must be set to the same value.\r\n5. If the content is XHTML 1.1 or higher and served as type \"application/xhtml+xml\", check the value of the <code>html</code> element\'s <code>xml:lang</code> attribute.\r\n6. Compare the language attribute value to valid language codes according to the ISO 639 specification.','2011-01-13 14:41:45','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_5','1. Check each <code>img</code> element that has <code>width</code> and <code>height</code> attribute values that are both greater than 25.\n2. View the <code>alt</code> attribute value for the <code>img</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_50','1. Check the contents of the <code>head</code> element for the presence of a <code>title</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_51','1. Check the contents of the <code>title</code> element.\n2. Note: For this test the term \"contains text\" excludes whitespace.\n				The title element must contain at least one non-whitespace character.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_52','1. View the text that is contained by the <code>title</code> element.\n2. The <code>title</code> element is expected to contain less than 150 characters (English) or the user must confirm that it is the shortest possible title.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_53','1. View the text that is contained by the <code>title</code> element.\\r\\n2. Compare the title text to common placeholder values.','2009-03-31 10:30:21','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_54','1. View the text that is contained by the <code>title</code> element.\n2. View the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_55','1. View all <code>input</code> elements except those that have a <code>type</code> attribute value of \"hidden\".','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_57','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"text\".\n2. The <code>input</code> element must have an explicitly associated label using one or more of the following methods.\n3. The <code>input</code> element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.\n4. and/or\n5. The <code>input</code> element has a <code>title</code> attribute.\n6. and/or\n7. The <code>input</code> element is contained by a <code>label</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_58','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"image\".\n2. Check for the presence of an <code>alt</code> attribute.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_59','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"image\".\n2. Check the <code>alt</code> attribute value of the <code>input</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_6','1. Check each <code>img</code> element and compare its <code>alt</code> attribute value to the list of placeholder values.\n2. <code>alt</code> attribute placeholder values are: \'nbsp\', \'spacer\' and <code>src</code> attribute value (filename).','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_60','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"image\".\n2. Calculate the length of the Alt text.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_61','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"image\".\n2. Check the <code>alt</code> attribute value of the <code>input</code> element.\n3. Check the <code>src</code> attribute value of the <code>input</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_62','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"image\".\\r\\n2. Check the <code>alt</code> attribute value of the <code>input</code> element.','2011-02-01 15:01:02','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_63','1. Check all <code>input</code> elements that have a <code>type</code> attribute value of \"image\".\n2. Check the <code>alt</code> attribute value of the <code>input</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_64','1. Check all <code>area</code> elements for the presence of an <code>alt</code> attribute.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_65','1. Check the <code>alt</code> attribute value of each <code>area</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_66','1. Check the <code>alt</code> attribute value of each <code>area</code> element.\n2. Check if the <code>alt</code> attribute value ends with a sound file suffix.\n3. Following is a sample list of sound file suffixes. This is not an exhaustive list and the author should test the actual file to determine if it is a sound file: .wav, .snd, .mp3, .iff, .svx, .sam, .smp, .vce, .vox, .pcm, and .aif.\n4. If the <code>alt</code> attribute value ends with a sound file suffix then check the content for a link to a sound file transcript.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_68','1. Check for the presence of a <code>target</code> attribute on each <code>area</code> element.\n2. If the <code>area</code> element has a <code>target</code> attribute then check if the <code>target</code> attribute\'s value is one of _self, _top, or _parent.\n3. If the <code>target</code> attribute\'s value is not _self, _top, or _parent then check if the content text contains a warning letting the user know that the imagemap will open a new window.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_69','1. Check the content for the presence of <code>marquee</code> elements.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_7','1. Check each <code>img</code> element that occurs within a source <code>a</code> (anchor) element.\n2. View the Alt text for the image.\n3. Check if the <code>a</code> (anchor) element contains any other text.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_70','1. Check each <code>menu</code> element in the content.\n2. Count the number of <code>li</code> elements contained by the <code>menu</code> element.\n3. If the <code>menu</code> element contains only one <code>li</code> element then check if the <code>li</code> element is really a list item.\n4. <code>li</code> elements may be misused to format text.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_71','1. Check each <code>meta</code> element for an <code>http-equiv</code> attribute value of \"refresh\" and a <code>content</code> attribute value that starts with \"http://\".','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_72','1. Check the document for the <code>meta</code> element (it occurs in the <code>head</code> section of the document).\n2. Check if the <code>meta</code> element contains a <code>http-equiv</code> attribute with a value of \"refresh\".\n3. Check if the <code>meta</code> element contains a <code>content</code> attribute with a value greater than zero.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_73','1. View each <code>object</code> element in the content.\n2. Discern if the <code>object</code> uses color alone.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_74','1. View each <code>object</code> element in the content and its text equivalent.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_75','1. Disable or remove each <code>object</code> element and then view the content.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_76','1. Operate the user interface for each <code>object</code>.\n2. Check if the <code>object</code> can be operated with the keyboard.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_77','1. Check each <code>object</code> element and view the <code>type</code> attribute value.\n2. If the <code>type</code> attribute value is \"video\" then check the content for a text equivalent for the <code>object</code>.\n3. The text equivalent may be within the text of the content or there may be a link to the text equivalent.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_78','1. Check each <code>object</code> element and look for a <code>title</code> attribute.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_79','1. Check each <code>object</code> element and view the <code>title</code> attribute value.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_8','1. For each <code>img</code> element, view the associated image and Alt text.\n2. Determine if a longer description than the Alt text is required for the image.\n3. If a longer description is required, check if it is provided by one of the 3 following methods.\n4. Method 1 - Check if there is a <code>longdesc</code> attribute for the <code>img</code> element and the longdesc target text fully describes the image.\n5. Method 2 - Check if the body text fully describes the image. (Note: the Alt text for the image must refer to the position in the document of the text that fully describes the image.)\n6. Method 3 - Check if there is a link immediately following the image that goes to an accessible text file that fully describes the image.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_80','1. Check each <code>object</code> element and view its content.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_81','1. Check each OL element in the content.\n2. Count the number of LI elements contained by the OL element.\n3. If the OL element contains only one LI element then check if the LI element is really a list item.\n4. LI elements may be misused to format text.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_82','1. Check the contents of all <code>p</code> elements in the document.\n2. Check if all the text contained by the <code>p</code> element is marked with presentational elements.\n3. Presentational elements include the elements <code>b</code>, <code>i</code>, <code>u</code>, <code>strong</code>, <code>span</code>, <code>font</code>, and <code>em</code>.\n4. If all the text is marked with a presentational element then determine if the text might be better marked as a header.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_83','1. Find any ASCII art within the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_84','1. Find any ASCII art within the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_86','1. View the operation of each SCRIPT in the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_87','1. View the operation of each <code>script</code> in the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_88','1. Remove or disable each <code>script</code> within the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_89','1. View the operation of each <code>script</code> in the content.\n2. Check if the <code>script</code> user interface may be accessed by the keyboard.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_9','1. Check each <code>img</code> element that has a <code>longdesc</code> attribute.\n2. Check if there is a \'d-link\' following the <code>img</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_90','1. View the operation of each <code>script</code> in the content.\n2. Check if the <code>script</code> operation is essential to the page content (it\'s not just eye-candy).\n3. If the <code>script</code> operation is essential to the page content then check if there is a <code>noscript</code> section following.\n4. Check if the <code>noscript</code> section provides an equivalent to the <code>script</code>.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_91','1. Check all <code>select</code> elements in the content.\n2. The <code>select</code> element must have an explicitly associated label using one or more of the following methods.\n3. The <code>select</code> element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.\n4. and/or\n5. The <code>select</code> element has a <code>title</code> attribute.\n6. or\n7. The <code>select</code> element is contained by a <code>label</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_92','1. Check all <code>select</code> elements in the content.\n2. Check if the <code>select</code> element contains an <code>onchange</code> attribute.\n3. Examine the onchange handler for any action that will cause the page to reload or cause an extreme change of context.\n4. Actions that will cause the page to reload or cause an extreme change of context may be variations of one of the following JavaScript statements:\n5. form.submit();\n6. window.location.href = uri;\n7. elementElsewhereOnThePage.focus();\n8. (@@other examples??)','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_94','1. Remove or disable each SCRIPT element.\n2. Check if the content is still readable.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_95','1. Check all <code>textarea</code> elements.\\r\\n2. Each <code>textarea</code> element must have an explicitly associated label using one or more of the following methods.\\r\\n3. The <code>textarea</code> element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.\\r\\n4. and/or\\r\\n5. The <code>textarea</code> element has a <code>title</code> attribute.\\r\\n6. and/or\\r\\n7. The <code>textarea</code> element is contained by a <code>label</code> element.','2009-04-14 10:45:04','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_96','1. Check all <code>textarea</code> elements in the document.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_97','1. Check for any <code>link</code> elements that have a <code>rel</code> attribute value of \"stylesheet\".\n2. If any of these elements are found then remove or disable them.\n3. View the document to ensure it is readable.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_98','1. Check the document for any text abbreviations.\n2. If an abbreviation is found, check if it is properly marked with the <code>abbr</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_PROCEDURE_99','1. Check the content for any text Acronyms.\n2. If an Acronyms is found, check if it is properly marked with the <code>acronym</code> element.','2009-03-18 13:48:49','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_10','Does this image flicker?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_100','Is the text enclosed by <code>blockquote</code> actually a quotation?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_101','Does iframe have alternate content?','2009-06-05 13:40:14','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_103','Does this document contain keyboard specific functions that correspond to the <code>ondblclick</code> event handler?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_105','Does this document contain keyboard specific functions that correspond to the <code>onmousemove</code> event handler?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_109','Is this page readable when stylesheets are removed?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_11','Is any text within the image also in the Alt text (unless text is decorative or redundant)?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_110','Are there any words or phrases that are not in the document\'s primary language?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_111','Is this data table complex enouqh that it requires a summary?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_113','Is this short <code>table</code> <code>summary</code> adequate to describe the <code>table</code>\'s purpose?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_122','Does input field with type \"password\" have a label positioned close to it?','2009-06-05 13:41:15','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_123','Does input field with type \"checkbox\" have a label positioned close to it?','2009-06-05 13:42:47','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_124','Does input field with type \"file\" have a label positioned close to it?','2009-06-05 13:43:26','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_125','Does input field with type \"radio\" have a label positioned close to it?','2009-06-05 13:43:51','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_127','Is the text equivalent for this <code>object</code> appropriate?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_128','Is the content usable when the <code>object</code> is disabled?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_129','Is the user interface for this <code>object</code> accessible?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_131','Have all long quotations been marked with the <code>blockquote</code> element?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_132','Does the document contain text links for all active areas of the imagemap?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_133','Does this <code>table</code> make sense when linearized?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_135','Does this image contain any math statements that are not described in the document?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_136','Is this a data table (and use of <code>th</code> is appropriate)?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_137','Is this a layout table (and does not require <code>th</code> elements)?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_14','Are there any references to this image using color alone?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_144','Is this <code>address</code> for the page author valid?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_145','Does this link to a multimedia file have a link to a text alternative?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_146','Does this <code>object</code> have an equivalent alternative (or not require it)?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_147','Does this document contain <code>link</code> elements that describe its place?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_148','Does this document have an alternate (more accessible) content?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_149','Does the document contain a <code>style</code> element that creates compound numbers for this list?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_15','Does the Alt text for this image identify the link destination.','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_150','Are you using images as list bullets? (Use <code>style</code> instead of IMG to do this.)','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_151','Is this table identified within the document and does not require a <code>caption</code>?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_154','Is this <code>pre</code> element used to create tabular layout?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_157','Does this <code>title</code> describe the link group?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_158','Is there a CSS that allows the user to hide this link group?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_16','Is this image decorative?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_160','Does this <code>object</code> require a long description?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_164','Is the content of this <code>noembed</code> equivalent to the <code>embed</code>?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_169','Should this group of <code>options</code> be grouped with <code>optgroup</code>?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_17','Does this sound file have an associated text transcript file?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_173','Is this link text as descriptive of the link destination as possible?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_178','Does the Alt text convey the same information as the image?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_179','Are there terms defined in the document that are defined in a glossary document?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_18','Does this anchor open a new window without warning?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_184','Is this page part of a collection that requires a site map?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_189','Does this label describe its associated control?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_19','Is this link text meaningful when read alone (out of context)?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_191','Does the anchor\'s <code>title</code> attribute describe the link destination?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_193','Is any text within the image also in the Alt text unless text is decorative?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_194','Is any non decorative text within the image also in the Alt text?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_196','Can a client-side image map replace this server-side image map?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_197','Does the anchor contain text that identify the link destination?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_198','Does the <code>legend</code> text describe the group of choices?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_2','Is this Alt text appropriate for the image?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_20','Is there a text transcript associated with this link to a multimedia file?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_200','Does the <code>legend</code> text describe the group of choices?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_202','Does the <code>frame</code> <code>title</code> describe the purpose or function of the frame?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_203','Does this summary describe navigation and structure of the table?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_205','Does the <code>input</code> element\'s label describe the purpose or function of the control?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_209','Is the <code>select</code> element\'s label positioned close to the control?','2011-02-01 14:59:40','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_21','Does this <code>applet</code> make use of color alone?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_210','Does the <code>select</code> element\'s label describe the purpose or function of the control?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_211','Is the label positioned close to the control?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_214','Does the <code>input</code> element\'s label describe the purpose or function of the control?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_217','Does the <code>input</code> element\'s label describe the purpose or function of the control?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_218','Does the <code>input</code> element\'s label describe the purpose or function of the control?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_219','Does the <code>input</code> element\'s label describe the purpose or function of the control?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_22','Does this <code>applet</code> cause screen flicker?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_220','Does the <code>input</code> element\'s label describe the purpose or function of the control?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_23','Is the alt attribute value a text equivalent for the applet?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_230','Does this data table require <code>thead</code>, <code>tfoot</code> or <code>tbody</code> elements to group repeated table row structures?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_231','Does this data table require <code>colgroup</code> or <code>col</code> elements to group table column structures?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_235','Is the reading direction of all text correctly marked?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_239','Is this image decorative?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_24','Is the text equivalent for this <code>applet</code> appropriate?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_240','Does the text alternative for this multimedia file tell the same story and present the same information as the multimedia file?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_241','Is table markup used for all tabular information?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_242','Does this <code>table</code> <code>caption</code> identify the table?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_246','Are all required fields indicated to the user as required?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_248','Do all visual lists contain proper markup?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_249','Does all emphasized or special text have semantic markup?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_25','Does this applet contain a text equivalent for the <code>applet</code>?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_250','Are there any references to items in the document by shape, size or relative position alone?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_251','Does this image contain text with a poor contrast ratio?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_253','Does this image contain text with a poor contrast ratio?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_258','Does this <code>applet</code> provide a keyboard mechanism that returns focus to the parent window?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_259','Does this <code>object</code> provide a keyboard mechanism that returns focus to the parent window?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_26','Is the user interface for this <code>applet</code> accessible?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_260','Does this <code>embed</code> provide a keyboard mechanism that returns focus to the parent window?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_261','Are all sections of the content marked with <code>headers</code>?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_262','Are all groups of links with a related purpose marked?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_263','Do repeated blocks of content appear in the same <code>frame</code> within the <code>frameset</code>?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_265','Does the tab order follow a logical order?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_266','Does this document require a breadcrumb trail?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_267','For all form submission error messages, are required fields identified?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_268','Do all form submission error messages provide assistance in correcting the error?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_269','For all irreversable transactions, is form submission data presented to the user before final acceptance?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_270','Are Unicode right-to-left marks or left-to-right marks used whenever the HTML bidirectional algorithm produces undesirable results?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_271','Are all changes in text direction marked using the <code>dir</code> attribute?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_272','If this form deletes information, can the user recover the information?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_274','Does this script cause a change of context (new window)?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_275','Does loading this page cause a new window to open?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_276','Do the repeated components appear in the same relative order on this page?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_28','Does this document require and contain a \"skip to content\" link?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_3','Is this Alt text as short as possible?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_30','Does this <code>object</code> flicker?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_301','Is there more than a 4.5:1 contrast ratio between standard text and its background, or a 3:1 contrast ratio for large scale text?','2011-01-19 10:13:24','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_302','Does the colour of visited link text on a coloured background provide a contrast ratio of 4.5:1 or greater?','2011-01-12 13:34:54','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_303','Does the colour of active link text on a coloured background provide a contrast ratio of 4.5:1 or greater?','2011-01-12 14:00:37','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_304','Does the colour of selected link text on a coloured background provide a contrast ratio of 4.5:1 or greater?','2011-01-12 15:00:00','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_305','Does the colour of link text on a coloured background provide a contrast ratio of 4.5:1 or greater?','2011-01-12 15:15:25','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_306','Does the colour of text on a coloured background provide a contrast ratio of 7:1 or greater?','2011-01-12 16:14:13','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_307','Does the colour of visited link text on a coloured background provide a contrast ratio of 7:1 or greater?','2011-01-12 16:29:36','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_308','Does the colour of active link text on a coloured background provide a contrast ratio of 7:1 or greater?','2011-01-12 16:43:01','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_309','Does the colour of selected link text on a coloured background provide a contrast ratio of 7:1 or greater?','2011-01-13 08:58:59','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_310','Does the colour of link text on a coloured background provide a contrast ratio of 7:1 or greater?','2011-01-13 09:09:37','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_32','Does the <code>frame</code> <code>title</code> describe the purpose or function of the <code>frame</code>?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_33','Is the <code>frame</code> source accessible?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_34','Is the relationship between <code>frames</code> described within the document?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_36','Does this NOFRAMES section contain a text equivalent of the FRAMES section?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_4','Is this a decorative image that requires null Alt text?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_42','Is this <code>h1</code> element really a section header (not just used to format text)?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_43','Is this <code>h2</code> element really a section header (not just used to format text)?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_44','Is this <code>h3</code> element really a section header (not just used to format text)?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_45','Is this <code>h4</code> element really a section header (not just used to format text)?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_46','Is this <code>h5</code> element really a section header (not just used to format text)?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_47','Is this <code>h6</code> element really a section header (not just used to format text)?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_5','Is this a decorative image that requires spacer Alt text?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_52','Is this long title appropriate for the content?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_53','Is this <code>title</code> appropriate for the content?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_54','Does this <code>title</code> describe the document?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_55','Does this <code>input</code> element use color alone?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_59','Does the Alt text identify the purpose or function of the image?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_6','Is the Alt text appropriate for the image?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_60','Is this long Alt text the shortest possible for the image?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_61','Is this Alt text appropriate for the image?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_62','Is this Alt text appropriate for the image?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_65','Does the Alt text for this <code>area</code> element identify the link destination?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_66','Is there a text transcript associated with this link to a sound file?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_68','Is there a warning letting the user know that this <code>area</code> element opens a new window?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_70','Is this <code>menu</code> item used to format text?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_73','Does this <code>object</code> use color alone?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_74','Is the text equivalent appropriate for the <code>object</code>','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_75','Is the content usable when the <code>object</code> is disabled?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_76','Is the user interface for this <code>object</code> accessible?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_77','Does this multimedia file have a text transcript?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_8','Does this image require a long description and if so is the long description properly marked?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_80','Does the body of this object element contain a text equivalent for the object?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_81','Is this list item used appropriately (not just to format text)?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_82','Should this text be marked as a header?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_83','Can this ASCII art be replaced by an image?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_84','Is there a link that allows the user to skip over this ASCII art?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_86','Does this <code>script</code> use color alone?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_87','Does this <code>script</code> cause screen flicker?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_88','Is the content accessible when the <code>script</code> is disabled?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_89','Is any user interface for this <code>script</code> accessible?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_92','Does this select element cause an extreme change of context?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_94','Is this page readable when stylesheets are removed?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_96','Does textarea element have an associated label close to it?','2009-06-05 13:39:20','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_97','Is this page readable when stylesheets are removed?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_98','Are there any abbreviations in the document that are not marked with the <code>abbr</code> element?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_QUESTION_99','Are there any acronyms in the content that are not marked with the <code>acronym</code> element?','2008-11-24 13:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_1','All images must have alternate text. It\'s required by people that are unable to view the image.','2011-02-01 14:59:50','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_10','People with photosensitive epilepsy can have seizures triggered by flickering or flashing in the 4 to 59 flashes per second (Hertz) range with a peak sensitivity at 20 flashes per second as well as quick changes from dark to light (like strobe lights).','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_100','Only use <code>blockquote</code> to indicate a quotation. Do not use it to create an indented effect on the page. <code>blockquote</code> is a semantic element and using it improperly can confuse the user.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_110','If you use a number of different languages on a page, make sure that any changes in language are clearly identified by use of the <code>lang</code> attribute.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_116','The <code>b</code> element is not handled as well by screen readers as the <code>em</code> and <code>strong</code> elements.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_117','The <code>i</code> element is not handled as well by screen readers as the <code>em</code> and <code>strong</code> elements.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_13','Some people may not be able to access the links that are part of an image map. They require a duplicate set of links.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_131','The proper marking of text content makes it easier to understand.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_132','If server-side image maps must be used (e.g., because the geometry of a region cannot be represented with values of the shape attribute), authors must provide the same functionality or information in an alternative accessible format. One way to achieve this is to provide a textual link for each active region so that each link is navigable with the keyboard.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_14','You should not describe an image, or part of an image, using color alone. For example, when referring to a photograph, you should not say \"my son is wearing a red coat\". Instead say \"my son is third from the left wearing a red coat\".','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_2','Alt text should describe the image. This Alt text is suspicious because it may be just placeholder text.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_3','Alt text should be as short as possible.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_301','The rationale is based on a) adoption of the 3:1 contrast ratio for minimum acceptable contrast for normal observers, in the ANSI standard, and b) the empirical finding that in the population, visual acuity of 20/40 is associated with a contrast sensitivity loss of roughly 1.5 [ARDITI-FAYE]. A user with 20/40 would thus require a contrast ratio of 3 * 1.5 = 4.5 to 1. Following analogous empirical findings and the same logic, the user with 20/80 visual acuity would require contrast of about 7:1.','2011-01-12 11:35:36','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_302','The rationale is based on a) adoption of the 3:1 contrast ratio for minimum acceptable contrast for normal observers, in the ANSI standard, and b) the empirical finding that in the population, visual acuity of 20/40 is associated with a contrast sensitivity loss of roughly 1.5 [ARDITI-FAYE]. A user with 20/40 would thus require a contrast ratio of 3 * 1.5 = 4.5 to 1. Following analogous empirical findings and the same logic, the user with 20/80 visual acuity would require contrast of about 7:1.','2011-01-12 13:09:10','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_303','The rationale is based on a) adoption of the 3:1 contrast ratio for minimum acceptable contrast for normal observers, in the ANSI standard, and b) the empirical finding that in the population, visual acuity of 20/40 is associated with a contrast sensitivity loss of roughly 1.5 [ARDITI-FAYE]. A user with 20/40 would thus require a contrast ratio of 3 * 1.5 = 4.5 to 1. Following analogous empirical findings and the same logic, the user with 20/80 visual acuity would require contrast of about 7:1.','2011-01-12 13:57:12','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_304','The rationale is based on a) adoption of the 3:1 contrast ratio for minimum acceptable contrast for normal observers, in the ANSI standard, and b) the empirical finding that in the population, visual acuity of 20/40 is associated with a contrast sensitivity loss of roughly 1.5 [ARDITI-FAYE]. A user with 20/40 would thus require a contrast ratio of 3 * 1.5 = 4.5 to 1. Following analogous empirical findings and the same logic, the user with 20/80 visual acuity would require contrast of about 7:1.','2011-01-12 14:52:12','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_305','The rationale is based on a) adoption of the 3:1 contrast ratio for minimum acceptable contrast for normal observers, in the ANSI standard, and b) the empirical finding that in the population, visual acuity of 20/40 is associated with a contrast sensitivity loss of roughly 1.5 [ARDITI-FAYE]. A user with 20/40 would thus require a contrast ratio of 3 * 1.5 = 4.5 to 1. Following analogous empirical findings and the same logic, the user with 20/80 visual acuity would require contrast of about 7:1.','2011-01-12 15:15:25','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_306','The rationale is based on a) adoption of the 3:1 contrast ratio for minimum acceptable contrast for normal observers, in the ANSI standard, and b) the empirical finding that in the population, visual acuity of 20/40 is associated with a contrast sensitivity loss of roughly 1.5 [ARDITI-FAYE]. A user with 20/40 would thus require a contrast ratio of 3 * 1.5 = 4.5 to 1. Following analogous empirical findings and the same logic, the user with 20/80 visual acuity would require contrast of about 7:1.','2011-01-12 16:01:29','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_307','The rationale is based on a) adoption of the 3:1 contrast ratio for minimum acceptable contrast for normal observers, in the ANSI standard, and b) the empirical finding that in the population, visual acuity of 20/40 is associated with a contrast sensitivity loss of roughly 1.5 [ARDITI-FAYE]. A user with 20/40 would thus require a contrast ratio of 3 * 1.5 = 4.5 to 1. Following analogous empirical findings and the same logic, the user with 20/80 visual acuity would require contrast of about 7:1.','2011-01-12 16:29:36','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_308','The rationale is based on a) adoption of the 3:1 contrast ratio for minimum acceptable contrast for normal observers, in the ANSI standard, and b) the empirical finding that in the population, visual acuity of 20/40 is associated with a contrast sensitivity loss of roughly 1.5 [ARDITI-FAYE]. A user with 20/40 would thus require a contrast ratio of 3 * 1.5 = 4.5 to 1. Following analogous empirical findings and the same logic, the user with 20/80 visual acuity would require contrast of about 7:1.','2011-01-12 16:43:01','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_309','The rationale is based on a) adoption of the 3:1 contrast ratio for minimum acceptable contrast for normal observers, in the ANSI standard, and b) the empirical finding that in the population, visual acuity of 20/40 is associated with a contrast sensitivity loss of roughly 1.5 [ARDITI-FAYE]. A user with 20/40 would thus require a contrast ratio of 3 * 1.5 = 4.5 to 1. Following analogous empirical findings and the same logic, the user with 20/80 visual acuity would require contrast of about 7:1.','2011-01-13 08:58:59','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_310','The rationale is based on a) adoption of the 3:1 contrast ratio for minimum acceptable contrast for normal observers, in the ANSI standard, and b) the empirical finding that in the population, visual acuity of 20/40 is associated with a contrast sensitivity loss of roughly 1.5 [ARDITI-FAYE]. A user with 20/40 would thus require a contrast ratio of 3 * 1.5 = 4.5 to 1. Following analogous empirical findings and the same logic, the user with 20/80 visual acuity would require contrast of about 7:1.','2011-01-13 09:09:37','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_4','All images require a text equivalent (Alt text) but you should set the Alt text to null (\"\") for decorative images. This image has null Alt text but does not appear to be a decorative image.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_48','The <code>lang</code> attribute allows assistive technology to orient and adapt to the pronunciation and syntax that are specific to the language of the page. This attribute may also play a major role in the emerging global, multi-lingual, simultaneous translation Web environment.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_49','You must use a valid 2 letter or 3 letter language code to identify the primary language of the content.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_5','All images require a text equivalent (Alt text) but you may set the Alt text to all spaces (\"  \") for decorative images. This image has spacer Alt text but does not appear to be a decorative image.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_54','All contents, including individual <code>frames</code> in a <code>frameset</code>, should have a <code>title</code> element that defines, in a simple phrase, the purpose of the content.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_6','The alternate (ALT) text for this image is suspicious because it appears to be \"placeholder\" text.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_7','If an image is used as a link then it must have alternate (ALT) text that describes the link destination. The Alt text can\'t be null or all spaces.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_71','Developers cannot predict how much time a user will require to read a page; premature refresh can disorient users. Content developers should avoid periodic refresh and allow users to choose when they want the latest information.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_72','Developers cannot predict how much time a user will require to read a page; premature refresh can disorient users. Content developers should avoid periodic refresh and allow users to choose when they want the latest information.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_8','Complex images require a long description if the image is not described within the document. If the image does require a long description, then create the description file and link to it using the <code>longdesc</code> attribute.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_80','Each <code>object</code> must have a text equivalent that will be displayed if the <code>object</code> is not.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_9','D-links are required until there is more browser support for the <code>longdesc</code> attribute.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_98','When abbreviations and natural language changes are not identified, they may be indecipherable when machine-spoken or brailled.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_RATIONALE_99','When acronyms and natural language changes are not identified, they may be indecipherable when machine-spoken or brailled.','2008-11-24 13:02:09','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_1','<img src=\"rex.jpg\" alt=\"a picture of Rex the cat\" />','2011-02-01 15:00:07','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_112','<table summary=\"This data table shows the average temperature for each day of the week.\">','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_114','<table summary=\"\">. (Or remove the table summary attribute.)','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_134','<a href=\"dogs\">dogs</a> | <a href=\"cats\">cats</a>','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_162','<abbr title=\"smiley in ASCII art\">:-)</abbr>','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_163','<embed\n				  src=\"../movies/history_of_rome.mov\" height=\"60\" width=\"144\" autostart=\"false\">\n					<noembed>\n						<a href=\"../transcripts/transcript_history_rome.htm\">\n						Transcript of \"The history of Rome\"</a>\n					</noembed>\n				</embed>','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_180','<a href=\"products.html\"><img src=\"icon.gif\" alt=\"\" />Products pag</a>','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_186','<label for=\"name\">Name: <label><input type=\"text\" id=\"name\"/>','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_190','<a href=\"dogs.html\" title=\"stories about dogs\"/>.','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_221','<body text=\"#000000\" bgcolor=\"#ffffff\">','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_222','<body link=\"#000000\" bgcolor=\"#ffffff\">','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_223','<body alink=\"#000000\" bgcolor=\"#ffffff\">','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_224','<body vlink=\"#000000\" bgcolor=\"#ffffff\">','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_225','<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_226','<body text=\"#000000\" bgcolor=\"#ffffff\">','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_227','<body link=\"#000000\" bgcolor=\"#ffffff\">','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_228','<body alink=\"#000000\" bgcolor=\"#ffffff\">','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_229','<body vlink=\"#000000\" bgcolor=\"#ffffff\">','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_236','<a href=\"foo.htm\"><img src=\"house.gif\" alt=\"home page icon\"/>Go to the home page</a>','2011-02-01 15:00:25','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_252','<body color=\"#000000\" link=\"#330000\" alink=\"#003300\" vlink=\"#000033\" bgcolor=\"#ffffff\">','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_254','<body text=\"#000000\" bgcolor=\"#ffffff\">','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_255','<body link=\"#000000\" bgcolor=\"#ffffff\">','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_256','<body alink=\"#000000\" bgcolor=\"#ffffff\">','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_257','<body vlink=\"#000000\" bgcolor=\"#ffffff\">','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_273','<html dir=\"rtl\" />','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_301','<div style=\"background-color:#FFFFFF\">\r\n<span style=\"color:#000000\">Coloured text must contrast sufficiently with a coloured background</span>\r\n</div>','2011-01-19 10:23:40','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_302','<style type=\"text/css\">\r\na:visited {color:blue;}\r\n</style>\r\n<div style=\"background-color:#FFFFFF\">\r\n<a href=\"textcolour.html\">Coloured link text must contrast sufficiently with a coloured background</a>\r\n</div>','2011-01-19 10:39:27','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_303','<style type=\"text/css\">\r\na:active {color:blue;}\r\n</style>\r\n<div style=\"background-color:#FFFFFF\">\r\n<a href=\"textcolour.html\">Coloured link text must contrast sufficiently with a coloured background</a>\r\n</div>','2011-01-19 10:46:37','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_304','<style type=\"text/css\">\r\na:hover {color:blue;}\r\n</style>\r\n<div style=\"background-color:#FFFFFF\">\r\n<a href=\"textcolour.html\">Coloured link text must contrast sufficiently with a coloured background</a>\r\n</div>','2011-01-19 10:52:03','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_305','<style type=\"text/css\">\r\na:link {color:blue;}\r\n</style>\r\n<div style=\"background-color:#FFFFFF\">\r\n<a href=\"textcolour.html\">Coloured link text must contrast sufficiently with a coloured background</a>\r\n/div>','2011-01-19 10:56:26','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_306','<div style=\"background-color:#ffffff\">\r\n<span style=\"color:#000000\">Coloured text must provide high contrast with a coloured background</span>\r\n</div>','2011-01-19 11:20:21','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_307','<style type=\"text/css\">\r\na:visited {color:black;}\r\n</style>\r\n<div style=\"background-color:#ffffff\">\r\n<a href=\"high_contrast_text.html\">Coloured text must provide high contrast with a coloured background</a>\r\n</div>','2011-01-19 11:20:34','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_308','<style type=\"text/css\">\r\na:active {color:black;}\r\n</style>\r\n<div style=\"background-color:#ffffff\">\r\n<a href=\"high_contrast_text.html\">Coloured text must provide high contrast with a coloured background</a>\r\n</div>','2011-01-19 11:20:56','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_309','<style type=\"text/css\">\r\na:hover {color:black;}\r\n</style>\r\n<div style=\"background-color:#ffffff\">\r\n<a href=\"high_contrast_text.html\">Coloured text must provide high contrast with a coloured background</a>\r\n</div>','2011-01-19 11:24:55','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_31','<frame title=\"listing of common birds\">','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_310','<style type=\"text/css\">\r\na:link {color:black;}\r\n</style>\r\n<div style=\"background-color:#ffffff\">\r\n<a href=\"high_contrast_text.html\">Coloured text must provide high contrast with a coloured background</a>\r\n</div>','2011-01-19 11:19:54','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_48','<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_REPAIREXAMPLE_50','<title>A Story About Dogs</title>','2008-11-24 13:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_SEARCHSTR_173','click here, more','2009-04-01 11:02:53','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_SEARCHSTR_195','link to%, go to%','2009-04-01 12:52:34','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_SEARCHSTR_200','legend','2009-04-01 13:03:54','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_SEARCHSTR_202','title, the title, frame title','2009-04-01 13:07:40','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_SEARCHSTR_53','title, the title, this is the title, untitled document','2009-03-31 10:30:21','');
REPLACE INTO `language_text` VALUES ('eng', '_check','_SEARCHSTR_62','image, photo, %bytes%','2009-03-31 11:28:30','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GNAME_1','Barrierefreie Informationstechnik-Verordnung (German standard)','2008-11-24 13:02:53','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GNAME_2','Section 508 of the Workforce Rehabilitation Act (USA standard)','2008-11-24 13:02:53','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GNAME_3','Stanca Act (Italian accessibility law)','2008-11-24 13:02:53','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GNAME_4','Web Content Accessibility Guidelines (WCAG), Version 1.0, Level A','2008-11-24 13:02:53','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GNAME_5','Web Content Accessibility Guidelines (WCAG), Version 1.0, Level AA','2008-11-24 13:02:53','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GNAME_6','Web Content Accessibility Guidelines (WCAG), Version 1.0, Level AAA','2008-11-24 13:02:53','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GNAME_7','Web Content Accessibility Guidelines (WCAG), Version 2.0, Level A','2011-01-13 15:58:52','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GNAME_8','Web Content Accessibility Guidelines (WCAG), Version 2.0, Level AA','2011-01-13 15:58:38','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GNAME_9','Web Content Accessibility Guidelines (WCAG), Version 2.0, Level AAA','2011-01-13 15:58:25','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_1','Level 1','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_10','H - associate data cells and header cells','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_11','I - frames shall be titled','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_12','J - avoid flicker','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_13','K - text-only page','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_14','L - script must have functional text','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_15','M - applets etc. must comply','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_16','N - accessible forms','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_17','O - skip repetitive navigation links','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_18','P - timed response','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_19','Requirement 1: Conform To Specifications','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_2','Level 2','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_20','Requirement 2: No Frames','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_21','Requirement 3: Text Equivalents','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_22','Requirement 4: Color Specific','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_23','Requirement 5: Flicker','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_24','Requirement 6: Visual Contrast','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_25','Requirement 7: Avoid Server-side Image Maps','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_26','Requirement 8: Text Links For Server-side Image Maps','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_27','Requirement 9: Data Table Header Elements','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_28','Requirement 10: Data Table Header Elements Multiple Levels','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_29','Requirement 11: Use Style Sheets','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_3','A - text equivalents','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_30','Requirement 12: Use relative rather than absolute units of measure','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_31','Requirement 13: Layout Table Linearize And Markup','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_32','Requirement 14: Form Labels','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_33','Requirement 15: Script/Object Alternatives','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_34','Requirement 16: Script/Object Accessible','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_35','Requirement 17: Objects Are Accessible','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_36','Requirement 18: Synchronized Text Equivalents For Multimedia','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_37','Requirement 19: Link Text','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_38','Requirement 20: Time Limits','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_39','Requirement 21: Links Selectable And Dimensions','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_4','B - multimedia equivalents synchronized','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_40','Requirement 22: Alternate Accessible Page','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_41','Priority 1','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_42','Priority 1','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_43','Priority 2','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_44','Priority 1','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_45','Priority 2','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_46','Priority 3','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_47','1.1 Text Alternatives: Provide text alternatives for any non-text content','2009-05-20 13:57:16','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_48','1.2 Time-based Media: Provide alternatives for time-based media.','2009-05-20 13:58:34','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_49','1.3  Adaptable: Create content that can be presented in different ways (for example simpler layout) without losing information or structure.','2009-05-20 14:05:58','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_5','C - color also available without color','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_50','1.4 Distinguishable: Make it easier for users to see and hear content including separating foreground from background.','2009-05-20 14:07:50','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_51','2.1 Keyboard Accessible: Make all functionality available from a keyboard.','2009-05-20 14:21:26','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_52','2.2 Enough Time: Provide users enough time to read and use content.','2009-05-20 14:23:40','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_53','2.3 Seizures: Do not design content in a way that is known to cause seizures.','2009-05-20 14:25:58','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_54','2.4  Navigable: Provide ways to help users navigate, find content, and determine where they are.','2009-05-20 14:27:07','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_56','3.1 Readable: Make text content readable and understandable.','2009-05-20 14:33:21','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_57','3.2 Predictable: Make Web pages appear and operate in predictable ways.','2009-05-20 14:35:07','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_58','4.1 Compatible: Maximize compatibility with current and future user agents, including assistive technologies.','2009-05-20 14:41:27','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_6','D - stylesheets in use','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_60','1.1 Text Altrernatives: Provide text alternatives for any non-text content','2009-05-20 13:26:30','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_61','1.2 Provide synchronized alternatives for multimedia','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_62','1.3 Ensure that information and structure can be separated from presentation','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_63','1.4 Distinguishable: Make it easier for users to see and hear content including separating foreground from background.','2009-05-20 13:31:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_64','2.1 Keyboard Accessible: Make all functionality available from a keyboard.','2009-05-20 13:33:20','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_65','2.2 Enough Time: Provide users enough time to read and use content.','2009-05-20 13:35:26','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_66','2.3 Seizures: Do not design content in a way that is known to cause seizures.','2009-05-20 13:37:20','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_67','2.4 Navigable: Provide ways to help users navigate, find content, and determine where they are.','2009-05-20 13:43:36','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_69','3.1 Readable: Make text content readable and understandable.','2009-05-20 13:47:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_7','E - text links for server-side image map','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_70','3.2  Predictable: Make Web pages appear and operate in predictable ways.','2009-05-20 13:48:43','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_71','4.1 Compatible: Maximize compatibility with current and future user agents, including assistive technologies.','2009-05-20 13:54:58','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_73','1.1 Text Alternatives: Provide text alternatives for all non-text content','2009-05-20 12:41:06','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_74','1.2 Time-based Media: Provide alternatives for time-based media','2009-05-20 11:55:50','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_75','1.3 Adaptable: Create content that can be presented in different ways without losing information or structure.','2009-05-20 12:04:43','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_76','1.4 Distinguishable: Make it easier for users to see and hear content including separating foreground from background.','2009-05-20 12:04:18','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_77','2.1 Keyboard Accessible: Make all functionality available from a keyboard.','2009-05-20 12:03:30','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_78','2.2 Enough Time: Provide users enough time to read and use content.','2009-05-20 12:06:52','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_79','2.3 Seizures: Do not design content in a way that is known to cause seizures.','2009-05-20 12:10:32','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_8','F - client-side image maps instead of server-side','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_80','2.4 Navigable: Provide ways to help users navigate, find content, and determine where they are.','2009-05-20 12:11:55','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_82','3.1 Readable: Make text content readable and understandable','2009-05-20 12:17:14','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_83','3.2 Predictable: Make Web pages appear and operate in predictable ways.','2009-05-20 12:22:42','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_84','4.1 Robust - Content must be robust enough that it can be interpreted reliably by a wide variety of user agents, including assistive technologies.','2009-05-20 12:28:23','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_86','3.3 Input Assistance: Help users avoid and correct mistakes.','2009-05-20 11:18:14','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_87','3.3 Input Assistance: Help users avoid and correct mistakes.','2009-05-20 13:51:50','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_88','3.3 Input Assistance: Help users avoid and correct mistakes.','2009-05-20 14:38:08','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_GROUPNAME_9','G - row/column headers for data tables','2008-11-24 13:03:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_','Success Criteria 1.1.1 Non-text Content (A)','2009-05-20 11:32:05','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_1','1.1 Provide a text equivalent for every non-text element.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_10','3.4 Use relative rather than absolute units in markup language attribute values and style sheet property values.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_100','1.1 Provide a text equivalent for every non-text element.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_101','1.2 Provide redundant text links for each active region of a server-side image map.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_102','1.3 Until user agents can automatically read aloud the text equivalent of a visual track, provide an auditory description of the important information of the visual track of a multimedia presentation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_103','1.4 For any time-based multimedia presentation (e.g., a movie or animation), synchronize equivalent alternatives (e.g., captions or auditory descriptions of the visual track) with the presentation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_104','1.4 For any time-based multimedia presentation (e.g., a movie or animation), synchronize equivalent alternatives (e.g., captions or auditory descriptions of the visual track) with the presentation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_105','2.1 Ensure that all information conveyed with color is also available without color, for example from context or markup.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_106','4.1 Clearly identify changes in the natural language of a document\'s text and any text equivalents (e.g., captions).','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_107','5.1 For data tables, identify row and column headers.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_108','6.1 Organize documents so they may be read without style sheets.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_109','6.2 Ensure that equivalents for dynamic content are updated when the dynamic content changes.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_11','3.5 Use header elements to convey document structure and use them according to specification.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_110','6.3 Ensure that pages are usable when scripts, applets, or other programmatic objects are turned off or not supported.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_111','7.1 Until user agents allow users to control flickering, avoid causing the screen to flicker.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_112','8.1 Make programmatic elements such as scripts and applets directly accessible or compatible with assistive technologies.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_113','9.1 Provide client-side image maps instead of server-side image maps except where the regions cannot be defined with an available geometric shape.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_114','11.4 If, after best efforts, you cannot create an accessible page, provide a link to an alternative page that uses W3C technologies, is accessible, has equivalent information (or functionality), and is updated as often as the inaccessible (original) page.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_115','12.1 Title each frame to facilitate frame identification and navigation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_116','14.1 Use the clearest and simplest language appropriate for a site\'s content.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_117','1.1 Provide a text equivalent for every non-text element.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_118','1.2 Provide redundant text links for each active region of a server-side image map.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_119','1.3 Until user agents can automatically read aloud the text equivalent of a visual track, provide an auditory description of the important information of the visual track of a multimedia presentation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_12','3.6 Mark up lists and list items properly.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_120','1.4 For any time-based multimedia presentation (e.g., a movie or animation), synchronize equivalent alternatives (e.g., captions or auditory descriptions of the visual track) with the presentation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_121','1.4 For any time-based multimedia presentation (e.g., a movie or animation), synchronize equivalent alternatives (e.g., captions or auditory descriptions of the visual track) with the presentation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_122','2.1 Ensure that all information conveyed with color is also available without color, for example from context or markup.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_123','4.1 Clearly identify changes in the natural language of a document\'s text and any text equivalents (e.g., captions).','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_124','5.1 For data tables, identify row and column headers.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_125','6.1 Organize documents so they may be read without style sheets.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_126','6.2 Ensure that equivalents for dynamic content are updated when the dynamic content changes.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_127','6.3 Ensure that pages are usable when scripts, applets, or other programmatic objects are turned off or not supported.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_128','7.1 Until user agents allow users to control flickering, avoid causing the screen to flicker.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_129','8.1 Make programmatic elements such as scripts and applets directly accessible or compatible with assistive technologies.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_13','3.7 Mark up quotations. Do not use quotation markup for formatting effects such as indentation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_130','9.1 Provide client-side image maps instead of server-side image maps except where the regions cannot be defined with an available geometric shape.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_131','11.4 If, after best efforts, you cannot create an accessible page, provide a link to an alternative page that uses W3C technologies, is accessible, has equivalent information (or functionality), and is updated as often as the inaccessible (original) page.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_132','12.1 Title each frame to facilitate frame identification and navigation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_133','14.1 Use the clearest and simplest language appropriate for a site\'s content.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_134','2.2 Ensure that foreground and background color combinations provide sufficient contrast when viewed by someone having color deficits or when viewed on a black and white screen.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_135','3.1 When an appropriate markup language exists, use markup rather than images to convey information.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_136','3.2 Create documents that validate to published formal grammars.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_137','3.3 Use style sheets to control layout and presentation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_138','3.4 Use relative rather than absolute units in markup language attribute values and style sheet property values.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_139','3.5 Use header elements to convey document structure and use them according to specification.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_14','4.1 Clearly identify changes in the natural language of a document\'s text and any text equivalents (e.g., captions).','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_140','3.6 Mark up lists and list items properly.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_141','3.7 Mark up quotations. Do not use quotation markup for formatting effects such as indentation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_142','5.4 If a table is used for layout, do not use any structural markup for the purpose of visual formatting.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_143','6.4 For scripts and applets, ensure that event handlers are input device-independent.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_144','6.5 Ensure that dynamic content is accessible or provide an alternative presentation or page.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_145','7.2 Until user agents allow users to control blinking, avoid causing content to blink.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_146','7.3 Until user agents allow users to freeze moving content, avoid movement in pages.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_147','7.4 Until user agents provide the ability to stop the refresh, do not create periodically auto-refreshing pages.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_148','7.5 Until user agents provide the ability to stop auto-redirect, do not use markup to redirect pages automatically.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_149','9.2 Ensure that any element that has its own interface can be operated in a device-independent manner.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_15','5.1 For data tables, identify row and column headers.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_150','9.3 For scripts, specify logical event handlers rather than device-dependent event handlers.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_151','10.1 Until user agents allow users to turn off spawned windows, do not cause pop-ups or other windows to appear and do not change the current window without informing the user.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_152','10.2 Until user agents support explicit associations between labels and form controls, for all form controls with implicitly associated labels, ensure that the label is properly positioned.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_153','11.1 Use W3C technologies when they are available and appropriate for a task and use the latest versions when supported.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_154','11.2 Avoid deprecated features of W3C technologies.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_155','12.2 Describe the purpose of frames and how frames relate to each other if it is not obvious by frame titles alone.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_156','12.3 Divide large blocks of information into more manageable groups where natural and appropriate.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_157','12.4 Associate labels explicitly with their controls.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_158','13.1 Clearly identify the target of each link.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_159','13.2 Provide metadata to add semantic information to pages and sites.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_16','5.4 If a table is used for layout, do not use any structural markup for the purpose of visual formatting.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_160','13.3 Provide information about the general layout of a site (e.g., a site map or table of contents).','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_161','13.4 Use navigation mechanisms in a consistent manner.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_162','1.1 Provide a text equivalent for every non-text element.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_163','1.2 Provide redundant text links for each active region of a server-side image map.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_164','1.3 Until user agents can automatically read aloud the text equivalent of a visual track, provide an auditory description of the important information of the visual track of a multimedia presentation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_165','1.4 For any time-based multimedia presentation (e.g., a movie or animation), synchronize equivalent alternatives (e.g., captions or auditory descriptions of the visual track) with the presentation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_166','1.4 For any time-based multimedia presentation (e.g., a movie or animation), synchronize equivalent alternatives (e.g., captions or auditory descriptions of the visual track) with the presentation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_167','2.1 Ensure that all information conveyed with color is also available without color, for example from context or markup.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_168','4.1 Clearly identify changes in the natural language of a document\'s text and any text equivalents (e.g., captions).','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_169','5.1 For data tables, identify row and column headers.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_17','6.1 Organize documents so they may be read without style sheets.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_170','6.1 Organize documents so they may be read without style sheets.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_171','6.2 Ensure that equivalents for dynamic content are updated when the dynamic content changes.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_172','6.3 Ensure that pages are usable when scripts, applets, or other programmatic objects are turned off or not supported.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_173','7.1 Until user agents allow users to control flickering, avoid causing the screen to flicker.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_174','8.1 Make programmatic elements such as scripts and applets directly accessible or compatible with assistive technologies.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_175','9.1 Provide client-side image maps instead of server-side image maps except where the regions cannot be defined with an available geometric shape.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_176','11.4 If, after best efforts, you cannot create an accessible page, provide a link to an alternative page that uses W3C technologies, is accessible, has equivalent information (or functionality), and is updated as often as the inaccessible (original) page.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_177','12.1 Title each frame to facilitate frame identification and navigation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_178','14.1 Use the clearest and simplest language appropriate for a site\'s content.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_179','2.2 Ensure that foreground and background color combinations provide sufficient contrast when viewed by someone having color deficits or when viewed on a black and white screen.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_18','6.2 Ensure that equivalents for dynamic content are updated when the dynamic content changes.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_180','3.1 When an appropriate markup language exists, use markup rather than images to convey information.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_181','3.2 Create documents that validate to published formal grammars.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_182','3.3 Use style sheets to control layout and presentation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_183','3.4 Use relative rather than absolute units in markup language attribute values and style sheet property values.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_184','3.5 Use header elements to convey document structure and use them according to specification.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_185','3.6 Mark up lists and list items properly.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_186','3.7 Mark up quotations. Do not use quotation markup for formatting effects such as indentation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_187','5.4 If a table is used for layout, do not use any structural markup for the purpose of visual formatting.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_188','6.4 For scripts and applets, ensure that event handlers are input device-independent.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_189','6.5 Ensure that dynamic content is accessible or provide an alternative presentation or page.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_19','6.3 Ensure that pages are usable when scripts, applets, or other programmatic objects are turned off or not supported.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_190','7.2 Until user agents allow users to control blinking, avoid causing content to blink.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_191','7.3 Until user agents allow users to freeze moving content, avoid movement in pages.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_192','7.4 Until user agents provide the ability to stop the refresh, do not create periodically auto-refreshing pages.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_193','7.5 Until user agents provide the ability to stop auto-redirect, do not use markup to redirect pages automatically.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_194','9.2 Ensure that any element that has its own interface can be operated in a device-independent manner.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_195','9.3 For scripts, specify logical event handlers rather than device-dependent event handlers.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_196','10.1 Until user agents allow users to turn off spawned windows, do not cause pop-ups or other windows to appear and do not change the current window without informing the user.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_197','10.2 Until user agents support explicit associations between labels and form controls, for all form controls with implicitly associated labels, ensure that the label is properly positioned.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_198','11.1 Use W3C technologies when they are available and appropriate for a task and use the latest versions when supported.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_199','11.2 Avoid deprecated features of W3C technologies.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_2','1.2 Provide redundant text links for each active region of a server-side image map.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_20','6.4 For scripts and applets, ensure that event handlers are input device-independent.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_200','12.2 Describe the purpose of frames and how frames relate to each other if it is not obvious by frame titles alone.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_201','12.3 Divide large blocks of information into more manageable groups where natural and appropriate.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_202','12.4 Associate labels explicitly with their controls.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_203','13.1 Clearly identify the target of each link.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_204','13.2 Provide metadata to add semantic information to pages and sites.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_205','13.3 Provide information about the general layout of a site (e.g., a site map or table of contents).','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_206','13.4 Use navigation mechanisms in a consistent manner.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_207','1.5 Until user agents render text equivalents for client-side image map links, provide redundant text links for each active region of a client-side image map.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_208','4.2 Specify the expansion of each abbreviation or acronym in a document where it first occurs.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_209','4.3 Identify the primary natural language of a document.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_21','6.5 Ensure that dynamic content is accessible or provide an alternative presentation or page.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_210','5.5 Provide summaries for tables.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_211','9.4 Create a logical tab order through links, form controls, and objects.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_212','10.3 Until user agents (including assistive technologies) render side-by-side text correctly, provide a linear text alternative (on the current page or some other) for all tables that lay out text in parallel, word-wrapped columns.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_213','10.4 Until user agents handle empty controls correctly, include default, place-holding characters in edit boxes and text areas.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_214','10.5 Until user agents (including assistive technologies) render adjacent links distinctly, include non-link, printable characters (surrounded by spaces) between adjacent links.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_215','11.3 Provide information so that users may receive documents according to their preferences (e.g., language, content type, etc.)','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_216','13.5 Provide navigation bars to highlight and give access to the navigation mechanism.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_217','13.6 Group related links, identify the group (for user agents), and, until user agents do so, provide a way to bypass the group.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_218','13.7 If search functions are provided, enable different types of searches for different skill levels and preferences.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_219','13.8 Place distinguishing information at the beginning of headings, paragraphs, lists, etc.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_22','7.1 Until user agents allow users to control flickering, avoid causing the screen to flicker.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_220','13.9 Provide information about document collections (i.e., documents comprising multiple pages.).','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_221','13.10 Provide a means to skip over multi-line ASCII art.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_222','14.2 Supplement text with graphic or auditory presentations where they will facilitate comprehension of the page.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_223','14.3 Create a style of presentation that is consistent across pages.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_224','Success Criteria 1.1.1 Non-text Content (A)','2009-05-20 13:57:38','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_225','Success Criteria 1.2.1 Audio-only and Video-only (Prerecorded) (A)','2009-05-20 14:02:14','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_226','Success Criteria 1.2.2 Captions (Prerecorded) (A)','2009-05-20 14:03:28','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_227','Success Criteria 1.3.1 Info and Relationships (A)','2009-05-20 14:06:24','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_228','Success Criteria 1.3.2 Meaningful Sequence (A)','2009-05-20 14:06:57','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_229','Success Criteria 1.3.3 Sensory Characteristics (A)','2009-05-20 14:07:19','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_23','7.2 Until user agents allow users to control blinking, avoid causing content to blink.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_231','Success Criteria 2.1.1 Keyboard (A)','2009-05-20 14:21:53','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_232','Success Criteria 2.2.1 Timing Adjustable (A)','2009-05-20 14:24:15','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_233','Success Criteria 2.3.1 Three Flashes or Below Threshold (A)','2009-05-20 14:26:25','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_234','Success Criteria 2.4.1 Bypass Blocks (A)','2009-05-20 14:28:13','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_236','Success Criteria 3.1.1 Language of Page (A)','2009-05-20 14:33:46','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_237','Success Criteria 3.2.1 On Focus (A)','2009-05-20 14:35:40','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_238','Success Criteria 3.2.2 On Input (A)','2009-05-20 14:35:59','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_239','Success Criteria 4.1.1 Parsing (A)','2009-05-20 14:41:56','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_24','7.3 Until user agents allow users to freeze moving content, avoid movement in pages.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_240','Success Criteria 4.1.2 Name, Role, Value (A)','2009-05-20 14:42:28','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_242','Success Criteria 1.1.1 Non-text Content (A)','2009-05-20 13:26:49','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_244','Success Criteria 1.2.1 Audio-only and Video-only (Prerecorded) (A)','2009-05-20 13:28:04','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_245','Success Criteria 1.2.2 Captions (Prerecorded) (A)','2009-05-20 13:28:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_246','Success Criteria 1.2.3 Audio Description or Media Alternative (Prerecorded) (A)','2009-05-20 13:28:46','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_248','Success Criteria 1.3.1 Info and Relationships (A)','2009-05-20 13:29:18','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_249','Success Criteria 1.3.2 Meaningful Sequence (A)','2009-05-20 13:29:54','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_25','7.4 Until user agents provide the ability to stop the refresh, do not create periodically auto-refreshing pages.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_250','Success Criteria 1.3.3 Sensory Characteristics (A)','2009-05-20 13:30:18','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_253','Success Criteria 1.4.1 Use of Color (A)','2009-05-20 13:32:00','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_254','Success Criteria 1.4.2 Audio Control (A)','2009-05-20 13:32:21','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_255','Success Criteria 2.1.1 Keyboard (A)','2009-05-20 13:34:22','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_256','Success Criteria 2.1.2 No Keyboard Trap (A)','2009-05-20 13:34:52','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_257','Success Criteria 2.2.1 Timing Adjustable (A)','2009-05-20 13:35:56','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_258','Success Criteria 2.2.2 Pause, Stop, Hide (A)','2009-05-20 13:36:49','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_259','Success Criteria 2.3.1 Three Flashes or Below Threshold (A)','2009-05-20 13:37:44','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_26','7.5 Until user agents provide the ability to stop auto-redirect, do not use markup to redirect pages automatically.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_261','Success Criteria 2.4.1 Bypass Blocks (A)','2009-05-20 13:44:15','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_262','Success Criteria 2.4.2 Page Titled (A)','2009-05-20 13:44:39','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_263','Success Criteria 2.4.3 Focus Order (A)','2009-05-20 13:45:15','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_264','Success Criteria 2.4.4 Link Purpose (In Context) (A)','2009-05-20 13:45:48','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_268','Success Criteria 3.1.1 Language of Page (A)','2009-05-20 13:47:49','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_269','Success Criteria 3.1.2 Language of Parts (A)','2009-05-20 13:48:13','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_27','8.1 Make programmatic elements such as scripts and applets directly accessible or compatible with assistive technologies.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_270','Success Criteria 3.2.1 On Focus (A)','2009-05-20 13:49:10','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_271','Success Criteria 3.2.2 On Input (A)','2009-05-20 13:49:56','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_274','Success Criteria 4.1.1 Parsing (A)','2009-05-20 13:55:19','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_275','Success Criteria 4.1.2 Name, Role, Value (A)','2009-05-20 13:55:46','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_278','Success Criteria 1.1.1 Non-text Content (A)','2009-05-20 11:50:09','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_28','9.1 Provide client-side image maps instead of server-side image maps except where the regions cannot be defined with an available geometric shape.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_281','Success Criteria 1.2.1 Audio-only and Video-only (Prerecorded) (A)','2009-05-20 11:50:51','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_282','Success Criteria 1.2.2  Captions (Prerecorded) (A)','2009-05-20 11:51:17','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_283','Success Criteria 1.2.3 Audio Description or Media Alternative (Prerecorded) (A)','2009-05-20 11:51:36','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_284','Success Criteria 1.2.4 Captions (Live) (AA)','2009-05-20 11:52:02','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_285','Success Criteria 1.2.5 Audio Description (Prerecorded) (AA)','2009-05-20 11:52:32','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_286','Success Criteria 1.2.6  Sign Language (Prerecorded) (AAA)','2009-05-20 11:52:57','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_287','Success Criteria 1.2.7 Extended Audio Description (Prerecorded) (AAA)','2009-05-20 11:53:21','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_288','Success Criteria 1.3.1 Info and Relationships (A)','2009-05-20 11:55:08','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_289','Success Criteria 1.3.2 Meaningful Sequence (A)','2009-05-20 11:57:36','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_29','9.2 Ensure that any element that has its own interface can be operated in a device-independent manner.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_290','Success Criteria 1.3.3 Sensory Characteristics (A)','2009-05-20 11:57:59','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_293','Success Criteria 1.4.1 Use of Colour (A)','2009-05-20 11:59:23','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_294','Success Criteria 1.4.2 Audio Control (A)','2009-05-20 11:59:56','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_295','Success Criteria 1.4.3 Contrast (Minimum) (AA)','2009-05-20 12:00:24','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_296','Success Criteria 2.1.1 Keyboard (A)','2009-05-20 12:05:49','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_297','Success Criteria 2.1.2 No Keyboard Trap (A)','2009-05-20 12:06:23','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_298','Success Criteria 2.1.3 Keyboard (No Exception) (AAA)','2009-05-20 12:07:34','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_299','Success Criteria 2.2.1 Timing Adjustable (A)','2009-05-20 12:08:13','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_3','1.3 Until user agents can automatically read aloud the text equivalent of a visual track, provide an auditory description of the important information of the visual track of a multimedia presentation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_30','9.3 For scripts, specify logical event handlers rather than device-dependent event handlers.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_300','Success Criteria 2.2.2 Pause, Stop, Hide (A)','2009-05-20 12:08:42','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_301','Success Criteria 2.2.3 No Timing (AAA)','2009-05-20 12:09:09','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_302','Success Criteria 2.3.1 Three Flashes or Below Threshold (A)','2009-05-20 12:11:05','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_303','Success Criteria 2.3.2 Three Flashes (AAA)','2009-05-20 12:11:28','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_305','Success Criteria 2.4.1 Bypass Blocks (A)','2009-05-20 12:12:23','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_306','Success Criteria 2.4.2 Page Titled (A)','2009-05-20 12:12:54','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_307','Success Criteria 2.4.3 Focus Order (A)','2009-05-20 12:13:16','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_308','Success Criteria 2.4.4 Link Purpose (In Context) (A)','2009-05-20 12:13:45','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_309','Success Criteria 2.4.5 Multiple Ways (AA)','2009-05-20 12:14:12','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_31','10.1 Until user agents allow users to turn off spawned windows, do not cause pop-ups or other windows to appear and do not change the current window without informing the user.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_310','Success Criteria 2.4.6  Headings and Labels (AA)','2009-05-20 12:14:41','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_311','Success Criteria 2.4.7 Focus Visible (AA)','2009-05-20 12:15:09','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_312','Success Criteria 2.4.8 Location (AAA)','2009-05-20 12:15:34','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_317','Success Criteria 3.1.1 Language of Page (A)','2009-05-20 12:41:47','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_318','Success Criteria 3.1.2 Language of Parts (AA)','2009-05-20 12:20:17','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_319','Success Criteria 3.1.3 Unusual Words (AAA)','2009-05-20 12:20:53','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_32','10.2 Until user agents support explicit associations between labels and form controls, for all form controls with implicitly associated labels, ensure that the label is properly positioned.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_320','Success Criteria 3.2.1 On Focus (A)','2009-05-20 12:23:15','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_321','Success Criteria 3.2.2 On Input (A)','2009-05-20 12:23:47','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_322','Success Criteria 3.2.3 Consistent Navigation (AA)','2009-05-20 12:24:23','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_323','Success Criteria 3.2.4  Consistent Identification (AA)','2009-05-20 12:25:01','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_324','Success Criteria 3.2.5 Change on Request (AAA)','2009-05-20 12:25:37','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_325','Success Criteria 4.1.1 Parsing (A)','2009-05-20 12:29:18','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_326','Success Criteria 4.1.2 Name, Role, Value (A)','2009-05-20 12:29:47','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_33','11.1 Use W3C technologies when they are available and appropriate for a task and use the latest versions when supported.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_330','Success Criteria 1.2.8 Media Alternative (Prerecorded) (AAA)','2009-05-20 11:53:48','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_331','Success Criteria 1.2.9 Audio-only (Live) (AAA)','2009-05-20 11:54:17','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_332','Success Criteria 1.4.4 Resize text (AA)','2009-05-20 12:00:50','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_333','Success Criteria 1.4.6 Contrast (Enhanced) (AAA)','2009-05-20 12:01:44','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_334','Success Criteria 1.4.5 Images of Text (AA)','2009-05-20 12:01:15','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_335','Success Criteria 1.4.7  Low or No Background Audio (AAA)','2009-05-20 12:02:07','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_336','Success Criteria 1.4.8 Visual Presentation (AAA)','2009-05-20 12:02:31','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_337','Success Criteria 1.4.9 Images of Text (No Exception) (AAA)','2009-05-20 12:02:53','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_338','Success Criteria 2.2.4 Interruptions (AAA)','2009-05-20 12:09:33','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_339','Success Criteria 2.2.5 Re-authenticating (AAA)','2009-05-20 12:09:59','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_34','11.2 Avoid deprecated features of W3C technologies.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_340','Success Criteria 2.4.9 Link Purpose (Link Only) (AAA)','2009-05-20 12:16:25','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_342','Success Criteria 2.4.10 Section Headings (AAA)','2009-05-20 12:16:40','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_343','Success Criteria 3.1.4 Abbreviations (AAA)','2009-05-20 12:21:12','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_344','Success Criteria 3.1.5 Reading Level (AAA)','2009-05-20 12:21:35','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_345','Success Criteria 3.1.6 Pronunciation (AAA)','2009-05-20 12:22:13','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_346','Success Criteria 3.3.1 Error Identification (A)','2009-05-20 12:26:06','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_347','Success Criteria 3.3.2 Labels or Instructions (A)','2009-05-20 12:26:59','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_348','Success Criteria 3.3.3 Error Suggestion (AA)','2009-05-20 12:27:19','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_349','Success Criteria 3.3.4 Error Prevention (Legal, Financial, Data) (AA)','2009-05-20 12:27:48','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_35','11.4 If, after best efforts, you cannot create an accessible page, provide a link to an alternative page that uses W3C technologies, is accessible, has equivalent information (or functionality), and is updated as often as the inaccessible (original) page.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_350','Success Criteria 3.3.5 Help (AAA)','2009-05-20 11:21:43','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_351','Success Criteria 3.3.6 Error Prevention (All) (AAA)','2009-05-20 11:22:39','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_353','Success Criteria 3.3.1 Error Identification (A)','2009-05-20 13:52:40','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_354','Success Criteria 3.3.2 Labels or Instructions (A)','2009-05-20 13:53:19','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_355','Success Criteria 1.2.3 Audio Description or Media Alternative (Prerecorded) (A)','2009-05-20 14:01:49','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_356','Success Criteria 1.2.4 Captions (Live) (AA)','2009-05-20 14:04:36','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_357','Success Criteria 1.2.5 Audio Description (Prerecorded) (AA)','2009-05-20 14:05:19','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_358','Success Criteria 1.4.1 Use of Color (A)','2009-05-20 14:08:50','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_359','Success Criteria 1.4.2 Audio Control (A)','2009-05-20 14:09:27','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_36','12.1 Title each frame to facilitate frame identification and navigation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_360','Success Criteria 1.4.3 Contrast (Minimum) (AA)','2009-05-20 14:10:08','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_361','Success Criteria 1.4.4 Resize text (AA)','2009-05-20 14:10:45','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_362','Success Criteria 1.4.5 Images of Text (AA)','2009-05-20 14:11:39','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_363','Success Criteria 2.1.2 No Keyboard Trap (A)','2009-05-20 14:23:08','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_364','Success Criteria 2.2.2 Pause, Stop, Hide (A)','2009-05-20 14:24:58','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_365','Success Criteria 2.4.2 Page Titled (A)','2009-05-20 14:28:53','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_366','Success Criteria 2.4.3 Focus Order (A)','2009-05-20 14:29:37','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_367','Success Criteria 2.4.4 Link Purpose (In Context) (A)','2009-05-20 14:30:27','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_368','Success Criteria 2.4.5 Multiple Ways (AA)','2009-05-20 14:31:05','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_369','Success Criteria 2.4.6 Headings and Labels (AA)','2009-05-20 14:31:47','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_37','12.2 Describe the purpose of frames and how frames relate to each other if it is not obvious by frame titles alone.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_370','Success Criteria 2.4.7 Focus Visible (AA)','2009-05-20 14:32:25','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_371','Success Criteria 3.1.2 Language Parts (AA)','2009-05-20 14:34:33','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_372','Success Criteria 3.2.3 Consistent Navigation (AA)','2009-05-20 14:36:38','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_373','Success Criteria 3.2.4 Consistent Identification (AA)','2009-05-20 14:37:19','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_374','Success Criteria 3.3.1 Error Identification (A)','2009-05-20 14:38:56','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_375','Success Criteria 3.3.2 Labels or Instructions (A)','2009-05-20 14:39:34','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_376','Success Criteria 3.3.3 Error Suggestion (AA)','2009-05-20 14:40:13','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_377','Success Criteria 3.3.4  Error Prevention (Legal, Financial, Data) (AA)','2009-05-20 14:40:47','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_38','12.3 Divide large blocks of information into more manageable groups where natural and appropriate.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_39','12.4 Associate labels explicitly with their controls.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_4','1.4 For any time-based multimedia presentation (e.g., a movie or animation), synchronize equivalent alternatives (e.g., captions or auditory descriptions of the visual track) with the presentation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_40','13.1 Clearly identify the target of each link.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_41','13.2 Provide metadata to add semantic information to pages and sites.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_42','13.3 Provide information about the general layout of a site (e.g., a site map or table of contents).','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_43','13.4 Use navigation mechanisms in a consistent manner.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_44','14.1 Use the clearest and simplest language appropriate for a site\'s content.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_45','1.5 Until user agents render text equivalents for client-side image map links, provide redundant text links for each active region of a client-side image map.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_46','4.2 Specify the expansion of each abbreviation or acronym in a document where it first occurs.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_47','4.3 Identify the primary natural language of a document.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_48','5.5 Provide summaries for tables.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_49','9.4 Create a logical tab order through links, form controls, and objects.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_5','1.4 For any time-based multimedia presentation (e.g., a movie or animation), synchronize equivalent alternatives (e.g., captions or auditory descriptions of the visual track) with the presentation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_50','10.3 Until user agents (including assistive technologies) render side-by-side text correctly, provide a linear text alternative (on the current page or some other) for all tables that lay out text in parallel, word-wrapped columns.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_51','10.4 Until user agents handle empty controls correctly, include default, place-holding characters in edit boxes and text areas.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_52','10.5 Until user agents (including assistive technologies) render adjacent links distinctly, include non-link, printable characters (surrounded by spaces) between adjacent links.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_53','11.3 Provide information so that users may receive documents according to their preferences (e.g., language, content type, etc.)','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_54','13.5 Provide navigation bars to highlight and give access to the navigation mechanism.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_55','13.6 Group related links, identify the group (for user agents), and, until user agents do so, provide a way to bypass the group.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_56','13.7 If search functions are provided, enable different types of searches for different skill levels and preferences.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_57','13.8 Place distinguishing information at the beginning of headings, paragraphs, lists, etc.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_58','13.9 Provide information about document collections (i.e., documents comprising multiple pages.).','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_59','13.10 Provide a means to skip over multi-line ASCII art.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_6','2.1 Ensure that all information conveyed with color is also available without color, for example from context or markup.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_60','14.2 Supplement text with graphic or auditory presentations where they will facilitate comprehension of the page.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_61','14.3 Create a style of presentation that is consistent across pages.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_7','3.1 When an appropriate markup language exists, use markup rather than images to convey information.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_8','3.2 Create documents that validate to published formal grammars.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_guideline','_SUBGROUPNAME_9','3.3 Use style sheets to control layout and presentation.','2008-11-24 13:03:29','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_CONFIRM_DELETE_CHECK','Are you sure you want to delete the following check? Please note that deleting a check also deletes this check from guidelines and where this check is defined as a prerequisite/next check in other checks. <strong>%s</strong>','2009-03-26 14:19:22','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_CONFIRM_DELETE_GUIDELINE','Are you sure you want to delete the guideline <strong><em>%s</em></strong>?','2009-01-23 11:20:13','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_CONFIRM_DELETE_ITEM','Are you sure you want to delete the following items? <strong>%s</strong>','2009-03-17 15:19:54','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_CONFIRM_DELETE_LANG','Are you sure you want to delete the language (<strong>%s</strong>)? If there are no other language packs installed, the system may become unusable.','2011-01-28 15:19:51','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_CONFIRM_DELETE_MYOWN_UPDATE','Are you sure you want to <strong>delete</strong> update <strong>%s</strong>?','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_CONFIRM_DELETE_USER','Are you sure you want to delete the following users? Please note that deleting a user also deletes the guidelines and checks that are created by this user but not yet open to public. <strong>%s</strong>','2009-02-06 11:58:02','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_CONFIRM_DELETE_USER_GROUP','Are you sure you want to delete the following user groups? <strong>%s</strong>','2009-02-12 15:08:53','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_CONFIRM_IMPORT_LANG','The imported language pack is for AChecker version <span style=\"font-weight:bold\">%1s</span>. You are using AChecker version <span style=\"font-weight:bold\">%2s</span>. Some language terms may be missing. Are you sure you want to continue?','2011-03-03 20:32:49','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_ABBR_EXISTS','A guideline with this abbreviation already exists.','2009-04-17 09:57:14','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_ACCOUNT_DISABLED','That account has been disabled.','2009-01-08 11:43:51','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_ACCOUNT_UNCONFIRMED','Your account has not been confirmed. Check your email for an account confirmation message from AChecker.','2011-01-31 13:07:56','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_CANNOT_CONNECT','Cannot connect to URL: %s','2009-04-22 09:26:45','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_CANNOT_DEL_DEFAULT_LANG','Cannot delete default language <strong>%s</strong>. The system cannot run properly without it.','2009-02-23 15:47:44','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_CANNOT_UNZIP','Can NOT unzip the uploaded file.','2009-06-22 14:49:02','error msg');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_CANT_CONNECT','Cannot connect to <strong>%s</strong>','2011-01-20 13:56:55','CSS validator');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_CHECK_FUNC','The following check function is incorrect. Check function must return true or false.<br/><strong>%s</strong>','2009-03-30 11:34:58','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_CHOOSE_ACTION','Please choose action for file <strong>%s</strong>','2009-06-22 14:49:02','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_CHOOSE_UNINSTALLED_UPDATE','Please choose an uninstalled update.','2009-06-22 14:49:02','Updater: error msg');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_CONFIRM_BAD','Your email address and account could not be confirmed.','2009-01-14 14:40:42','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_CSS_VALIDATOR_ERROR','CSS validator error. Unable to generate results from the validator.','2011-01-20 14:08:58','CSS validator');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_DB_NOT_UPDATED','Information could not be added to the database.','2009-01-09 11:34:42','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_EMAIL_EXISTS','An account with that email address already exists.','2009-01-09 11:34:42','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_EMAIL_INVALID','Email address was invalid.','2009-01-09 11:34:42','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_EMAIL_NOT_FOUND','No account found with that email address.','2009-01-14 14:40:42','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_EMPTY_FIELDS','The following required field(s) are empty:<br />\r\n%s.','2009-01-09 11:34:42','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_EMPTY_GID','Empty guideline ID.','2009-04-22 11:40:24','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_EMPTY_SESSIONID','Empty Session ID.','2009-03-03 13:44:57','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_EMPTY_URI','Empty URL.','2009-03-03 13:44:57','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_EMPTY_USER','Empty user.','2009-03-03 13:44:57','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_EMPTY_WEB_SERVICE_ID','Empty web service ID.','2009-03-04 14:53:18','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_FIRST_LAST_NAME_UNIQUE','First, second, and last names combination must be unique.','2009-01-09 11:34:42','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_GUIDELINE_NOT_FOUND','Guideline not found.','2009-01-20 14:19:07','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_ID_ZERO','Check ID was zero, or was missing.','2009-03-26 10:03:56','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_INVALID_CHECK_ID','Invalid check ID.','2009-03-31 10:52:38','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_INVALID_FORMAT','Invalid format.','2009-03-03 13:44:57','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_INVALID_GID','Invalid guideline ID.','2009-04-22 11:40:24','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_INVALID_LOGIN','Invalid login/password combination.','2009-01-08 11:43:51','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_INVALID_SESSION','Invalid session.','2009-03-03 13:44:57','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_INVALID_URI','Invalid URL.','2009-03-04 14:49:59','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_INVALID_WEB_SERVICE_ID','Invalid web service ID.','2009-03-04 14:49:59','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_LANG_EMPTY','The text for this language has not been translated yet.','2009-02-24 13:57:01','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_LANG_EXISTS','The language you are trying to create already exists.','2009-02-24 09:20:45','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_LOGIN_CHARS','Your Login Name must only contain letters, numbers, periods, or underscores (_\'s).','2009-01-09 11:34:42','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_LOGIN_EXISTS','That login already exists, please choose another.','2009-01-09 11:34:42','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_MISSING_GID','Missing guideline ID or guideline group ID.','2009-04-08 13:11:12','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_NONE_USER_LINK','USER_LINK_ID cannot be null at creating user decision section.','2009-02-27 09:16:25','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_NOT_LOCALHOST','Sorry, the IP address of localhost is not public. For security reasons, validating resources located at non-public IP addresses has been disabled in this service.','2009-04-22 09:26:45','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_NO_ACTION_SELECTED','No action selected.','2009-02-04 15:31:02','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_NO_ENOUGH_MEMORY','The available memory is not enough to process this size of html.','2009-06-04 12:59:43','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_NO_ITEM_SELECTED','You must select an item before using a button.','2009-02-04 15:31:02','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_NO_PHP_FUNC','PHP functions cannot be called. Please remove the following function calls from the code: <br/><ul>%s</ul>','2009-03-31 08:48:28','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_NO_PHP_GLOBAL_VARS','PHP super global variables cannot be called. Please remove the following calls from the code: <br/><ul>%s</ul>','2009-03-31 08:48:28','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_PAGE_NOT_FOUND','Page (%s) cannot be found','2008-12-12 13:28:09','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_PASSWORD_CHARS','The password must contain letters, numbers, and symbols.','2009-01-09 13:41:06','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_PASSWORD_LENGTH','Password must be at least 8 characters long.','2009-01-09 13:41:06','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_PASSWORD_MISMATCH','Passwords did not match.','2009-01-09 13:41:06','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_REFERER_URI_NOT_MATCH','Referrer URL does NOT match.','2009-04-21 14:11:42','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_REMOVE_WRITE_PERMISSION','Please remove write permission from the listed files.','2009-06-22 14:49:02','error msg');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_SELECT_ONE_ITEM','Only <em>one</em> item must be selected.','2009-02-04 15:31:02','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_SENDING_ERROR','There was an error sending the email message.','2009-01-16 13:14:08','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_SEQUENCEID_NOT_GIVEN','No sequence ID is given.','2009-03-09 14:21:28','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_SYNTAX_ERROR','Syntax error.','2009-03-26 15:54:24','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_UPDATE_ALREADY_INSTALLED','The selected update is already installed.','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_UPDATE_DEPENDENCY','Due to update dependency, please install the listed updates before installing this update: %s','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_UPDATE_XML_NOT_FOUND','Update XML file is not found.','2009-06-22 14:49:02','error msg');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_USER_NOT_MATCH','User ID does NOT match. Please logout AChecker and try again.','2009-04-21 14:43:51','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_ERROR_WRONG_PASSWORD','Incorrect password.','2009-01-16 10:29:47','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_FEEDBACK_ACCOUNT_CONFIRMED','Account has been confirmed.','2009-01-14 14:40:42','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_FEEDBACK_ACTION_COMPLETED_SUCCESSFULLY','Action completed successfully.','2009-01-16 11:29:41','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_FEEDBACK_CANCELLED','Successfully cancelled without any changes.','2009-01-14 14:40:42','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_FEEDBACK_CHANGE_TO_SAME_EMAIL','The email address is same as what you currently have.','2009-01-16 11:54:46','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_FEEDBACK_CONFIRMATION_SENT','An email confirmation message has been sent.','2009-01-14 14:40:42','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_FEEDBACK_CONFIRM_EMAIL','A confirmation email has been sent to the email address you registered. Follow the link in the email to confirm your account.','2011-01-16 11:54:46','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_FEEDBACK_CONFIRM_EMAIL2','An email with instructions on retrieving your password has been sent.','2009-01-16 13:14:08','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_FEEDBACK_CONFIRM_GOOD','Your email address has been confirmed successfully.','2009-01-14 14:40:42','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_FEEDBACK_IMPORT_LANG_SUCCESS','New language was successfully imported.','2009-02-24 13:58:25','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_FEEDBACK_LOGIN_SUCCESS','You have logged in successfully.','2009-01-08 11:43:51','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_FEEDBACK_LOGOUT','You have successfully been logged out.','2009-01-08 09:38:14','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_FEEDBACK_ONLY_ENGLISH','Only English language is defined in the system. There is no foreign languages to translate.','2009-02-18 11:52:10','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_FEEDBACK_PASSWORD_CHANGED','Password changed successfully.','2009-01-16 10:35:40','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_FEEDBACK_PROFILE_UPDATED','Your Profile was successfully updated.','2009-01-15 10:59:58','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_FEEDBACK_REGISTER_SUCCESS','You have registered successfully. Your web service ID is %s. This ID must be presented when using web service. This ID can always be retrieved from \"Profile\" page.','2009-03-04 13:30:45','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_FEEDBACK_REG_THANKS_CONFIRM','Thank-you for registering. Please follow the instructions in the email we sent you to confirm your account. You will need to confirm your account before you can login.','2011-01-14 13:39:19','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_FEEDBACK_UPDATE_CREATED_SUCCESSFULLY','The update has been created successfully.','2009-06-22 14:49:02','Updater: feedback msg');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_FEEDBACK_UPDATE_INSTALLED_SUCCESSFULLY','The update has been installed successfully.','2009-06-22 14:49:02','Updater: feedback msg');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_ADD_EDIT_LANGUAGE','<h2>Add/Edit Language</h2>\r\n\r\n	<p>Adding and Editing the language properties allows users to change the following:\r\n	<ul>\r\n		<li>Language Code (3 digit ISO-639-2 language code)</li>\r\n		<li>Locale (two letter abritrary code to represent a variation of a language)</li>\r\n		<li>Character Set (should always be UTF-8)</li>\r\n		<li>Regular Expression (leave blank)</li>\r\n		<li>Language name translated</li>\r\n		<li>Language name in English</li>\r\n		<li>Status (enabled/disabled)</li>\r\n	</ul>\r\n	</p>\r\n	<p>When \"Status\" is set to enabled, the language is displayed in the selector at the bottom of AChecker pages, which allows users to switch to this language.</p>\r\n','2009-04-15 09:46:37','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_CHANGE_EMAIL','<h2>Change Email</h2>\r\n<p>This page allows users to change email addresses. </p>\r\n','2009-04-15 09:47:18','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_CHANGE_PASSWORD','<h2>Change Password</h2>\r\n<p>This page allows users to change passwords. The form authenticates users by checking their old password first, and then setting a new password and typing it again.</p>\r\n','2009-04-15 09:53:55','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_CHECK','<h2>Check Management</h2>\r\n\r\n<p>This tool allows users to manage all accessibility checks. This includes creating checks, editing existing ones,  and deleting checks.</p>\r\n\r\n<h3>Creating Checks</h3>\r\n\r\n<p>The users who have \"Check Management\" privileges can manually add checks to the system by using <em>Create Check</em>.</p>','2009-06-04 10:31:32','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_CREATE_EDIT_CHECK','<h2>Create/Edit Check</h2>\r\n<p>The Create/Edit Checks tool is used to create new accessibility checks, or to edit existing ones.</p> \r\n<p>The first step in creating a new check is to define its basic properties. Once the properties have been saved, you may then add prerequisite checks to your new check. These are checks that must be run and passed before the new check runs. For example, if you are writing a check to determine if the Alt attribute has a value, the prerequisite check would be to check if the alt attribute exists. The prerequisite checks are validated before the check being edited runs. If one of the prerequisite checks fail, the validation will stop and an accessibility error is reported on the prerequisite check. </p>\r\n\r\n<h3>Check properties include:</h3>\r\n\r\n<dl>\r\n	<dt>HTML Tag To Check (Mandatory field)</dt>\r\n	<dd>The html tag to check against (e.g. input). Users can select a html tag by using link \"Select From Existing HTML Tags\" or directly type in the tag.</dd>\r\n\r\n	<dt>Error Type (Mandatory field)</dt>\r\n	<dd>Select from one of the error types: Known Problem, Likely Problem, Potential Problem</dd>\r\n\r\n	<dt>Open To Public (Mandatory field)</dt>\r\n	<dd>When \'Yes\' is selected, the check will be available to use by other users.</dd>\r\n\r\n	<dt>Name (Mandatory field)</dt>\r\n	<dd>Check name.</dd>\r\n	\r\n	<dt>Error (Mandatory field)</dt>\r\n	<dd>Error to check.</dd>\r\n	\r\n	<dt>Short Description</dt>\r\n	<dd>Short description.</dd>\r\n\r\n	<dt>Search String</dt>\r\n	<dd>The search strings this check tries to match. (e.g. title, %title1, title2%, %title3%). <br/>\'%\' can be used in front and at the end of a string to match any characters.<br/>As an explanation, \"title\" matches exact string of \"title\". <br/>\"%title1\" matches any string ending with \"title1\". <br/>\"title2%\" matches any string starting with \"title2\". <br/>\"%title3%\" matches any string containing string \"title3\". </dd>\r\n\r\n	<dt>Long Description</dt>\r\n	<dd>Detailed long description.</dd>\r\n\r\n	<dt>Rationale</dt>\r\n	<dd>Rationale.</dd>\r\n\r\n	<dt>How To Repair</dt>\r\n	<dd>Description of how to repair when failed at this check. This field is recommended to fill in for checks with error type \"Known Problem\".</dd>\r\n\r\n	<dt>Repair Example</dt>\r\n	<dd>Repair example. This field is recommended to fill in for checks with error type \"Known Problem\". An HTML exmaple that fixed the identified barrier.</dd>\r\n\r\n	<dt>Note</dt>\r\n	<dd>Note.</dd>\r\n\r\n	<dt>Question</dt>\r\n	<dd>The question to answer in order to decide if the check is passed or failed. This field is recommended for checks with error type \"Likely Problem\" or \"Potential Problem\".</dd>\r\n\r\n	<dt>Pass Decision</dt>\r\n	<dd>When the answer to the \"Question\" is made on this decision, the check is considered passed. This field is recommended for checks with error type \"Likely Problem\" or \"Potential Problem\".</dd>\r\n\r\n	<dt></dt>\r\n	<dd>When the answer to the \"Question\" is made on this decision, the check is considered failed. This field is recommended for checks with error type \"Likely Problem\" or \"Potential Problem\".</dd>\r\n\r\n	<dt>Procedure</dt>\r\n	<dd>Procedure used to go through to ensure this check is passed.</dd>\r\n\r\n	<dt>Expected Result</dt>\r\n	<dd>Expected result to pass the check after going through the \"Procedure\".</dd>\r\n\r\n	<dt>Failed Result</dt>\r\n	<dd>The check is considered failed if this result is met after going through the \"Procedure\".</dd>\r\n\r\n	<dt>Pass Example Description</dt>\r\n	<dd>The description for \"Pass HTML Example\"</dd>\r\n\r\n	<dt>Pass HTML Example</dt>\r\n	<dd>HTML example file that passes this check.</dd>\r\n\r\n	<dt>Fail Example Description</dt>\r\n	<dd>The description for \"Fail HTML Example\"</dd>\r\n\r\n	<dt>Fail HTML Example</dt>\r\n	<dd>HTML example file that fails this check.</dd>\r\n\r\n</dl>\r\n<h3>Prerequisite Checks:</h3>\r\n<p>Once a check\'s basic properties have been saved, the \"Prerequisite Checks\" section will appear below. The prerequisite checks are validated before the check. If one of the pre-requisite checks fails, the validation will stop and error is reported on this pre-requisite check. Use button \"Add Prerequisite Checks\" to add checks into this section.</p>','2009-06-04 12:32:23','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_CREATE_EDIT_GUIDELINE ','<h2>Create/Edit Guideline</h2>\r\n<p>This page to create new guidelines, or edit existing ones.</p> \r\n<p>The first step in creating a new guideline is to define its basic properties. Once the properties have been saved, you may then add checks to your new guideline. </p>\r\n<h3>Guideline properties include:</h3>\r\n\r\n<dl>\r\n	<dt>Title (Mandatory field)</dt>\r\n	<dd>Guideline title (e.g. Ontario Ministry of Community and Social Services Intranet)</dd>\r\n\r\n	<dt>Abbreviation</dt>\r\n	<dd>A shortened form of guideline title (e.g. MCSS-1.0)</dd>\r\n\r\n	<dt>Long Name</dt>\r\n	<dd>Guideline description (e.g. A modified version of WCAG 2.0 specifically for Intranet sites within the Government of Ontario)</dd>\r\n\r\n	<dt>Published Date</dt>\r\n	<dd>The published date of the guideline</dd>\r\n	\r\n	<dt>URL</dt>\r\n	<dd>A URL that the guideline refers to (if the guideline is defined elsewhere, include a link to it here) </dd>\r\n	\r\n	<dt>Status</dt>\r\n	<dd>Set this to \"Enabled\" to make it available to be used with AChecker. Once turned on, the guideline will be listed in the \"Options\" => \"Guidelines to Validate Against\" section. Enabling the guideline makes it available only to the user who created it. To make the guideline available to everyone, an administrator must set the guideline to \"Open to Public.\" </dd>\r\n\r\n</dl>\r\n<h3>Add Checks to Guideline:</h3>\r\n<p>Once a guideline\'s basic properties have been saved, the Checks section will appear below. A guideline is created by defining optional groups, and subgroups, to structure the guidelines  For example, create a group for guideline one call \"Guideline 1\", then define a subgroup for that guideline called \"Guideline 1.1\" and another called \"Guideline 1.2\" and so on. Once the structure for a guideline has been created, you can then add checks to each of the groupings. Have a look at the Standard Guidelines that come with AChecker, for examples of how guidelines are structured.</p>\r\n\r\n<p>The following icons represent functions used to assemble groups and checks. You can hold a mouse pointer over each icon to see its functions.</p>\r\n<dl>\r\n<dt><img src=\"../themes/default/images/add_group.gif\" alt=\"Add Group Icon\" title=\"Add Group Icon\"/>Add Group: Create a grouping for Checks</dt>\r\n<dt><img src=\"../themes/default/images/add.gif\" alt=\"Add Check Icon\" title=\"Add Check Icon\" />Add Check: Associate a check with the guideline grouping.</dt>\r\n<dt><img src=\"../themes/default/images/edit.gif\" alt=\"Edit Group\" title=\"Edit Group\"/>Edit Group: Modify an editing Check grouping.</dt>\r\n<dt><img src=\"../themes/default/images/delete.gif\" alt=\"Delete Group\" title=\"Delete Group\"/>Delete Group: Remove a check grouping and all its subgroups.</dt>\r\n</dl>','2009-04-15 09:54:58','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_CREATE_EDIT_USER ','<h2>Create/Edit User</h2>\r\n\r\n<p>All fields on \"Create User\" and \"Edit User\" forms are required. Most fields are self-explanatory. When the \"Account Status\" field is set to disabled, the user is not able to login. </p>\r\n<p>User accounts can also be created by individuals using the Registration form available through the public pages of AChecker. The accounts created via the Registration form are automatically set to user group \"Regular User\". </p>','2009-06-04 13:00:03','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_CREATE_EDIT_USER_GROUP','<h2>Create/Edit User Group</h2>\r\n\r\n<p>All fields are relatively self-explanatory.</p>\r\n\r\n<p>There are seven privileges provided by AChecker. Privileges are fixed and not changeable.\r\n	<dl>\r\n		<dt>Web Accessibility Checker</dt>\r\n		<dd>This privilege is also open to public. Users don\'t need to login to use it.</dd>\r\n		<dt>User Management</dt>\r\n		<dd>Create, edit, delete users.</dd>\r\n		<dt>Guideline Management</dt>\r\n		<dd>Create, edit, delete, enable, disable guidelines.</dd>\r\n		<dt>Check Management</dt>\r\n		<dd>Create, edit, delete, enable, disable checks.</dd>\r\n		<dt>Language Management</dt>\r\n		<dd>Create, edit, delete, enable, disable languages.</dd>\r\n		<dt>Translation</dt>\r\n		<dd>Translate all AChecker terms into languages other than English, or edit existing English text.</dd>\r\n		<dt>Profile Management</dt>\r\n		<dd>Edit profile, change password or email.</dd>\r\n	</dl>\r\n</p>','2009-06-04 13:05:21','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_CREATE_UPDATE','<h2>Creating Update</h2>\r\n\r\n<p>If you happen to come across a bug you can fix, or have a new feature you would like added to the AChecker public distribution, you can use Create Update to put your changes into a form that can be easily added to the AChecker public code. Or, if you have a feature you are adding to one AChecker installation that you would like to have added to another, Create Update is ideal for reproducing your feature across installations. If you are creating new features that are not going to become part of the AChecker public source code, you can build them into a update so they can be reapplied from version to version as you upgrade your AChecker system. Creating updates does require knowledge of PHP, and of SQL if you plan on creating a update that changes the AChecker database. Please refer to the appropriate documentation for information on PHP and SQL. <p>\r\n\r\n<dl>\r\n	<dt>AChecker Update ID</dt>\r\n	<dd>The update id you give to your update must be different from all updates available for the particular version of AChecker it applies to. It is suggested you prefix your updates with a special identifier that represents the author or the authoring organization. If for example the University of Toronto is creating the update, a update ID might look like \"uoft_0002.\"</dd>\r\n	<dt>AChecker Version to Apply</dt>\r\n	<dd>This needs to be the exact version number of the AChecker version the update applies to (e.g 1.6). including any minor version numbers (e.g 1.6.1.2)  The exact version number can be found on the Administrator open screen under \"Statistics and Information.\" In most cases when applying a update created for an older version of AChecker, the \"AChecker version to Apply\" will need to be adjusted. Or, this can be adjusted manually in the patch.xml file included with the source code of the update.\r\n	</dd>\r\n	<dt>Description</dt>\r\n	<dd>This should be a detailed description of what the update does. Example might include \"fixes problem uploading files to filemanager\" for a bug fix, or \"added a timer function to tests\" for an added feature, or \"removes registration tab\" for a feature adjustment, etc. Include enough detail so those applying the update understand exactly what it will do..</dd>\r\n	<dt>SQL Statement</dt>\r\n	<dd>This optional field can be used to insert SQL commands which modify the AChecker database. It might be used to write an SQL statement to modify and existing table, such as changing a data type, or a field size, or to add or remove an field. It can also be used to insert SQL that generates a new table for a new feature created by a update, or it can be used to insert data into a table used by a feature created by the update. Any SQL can be included in this field. Be careful when running SQL, that that SQL is not going to interfere with upgrade SQL. If you are changing table structures and those same tables are being altered during an upgrade, the upgrade may fail.</dd>\r\n	<dt>Dependant Updates</dt>\r\n	<dd>It is common for later updates to require changes from earlier updates before they can be installed. If this is the case for the update you are creating, enter the update IDs into the Dependant Update ID field. Click on Add Dependent Update if additional dependencies are required. Be sure to check the updates on the opening screen of the Updater to see if the file you are modifying with your update is  being modified by an update.AChecker.ca update. If they are modifying the same files, you may need to include the ID numbers for those updates in the Dependant Updates for the update your are creating.</dd>\r\n	<dt>Files</dt>	\r\n	<dd>This area is where most AChecker updates are created. Click on <strong>Add File</strong>  to generate a update block. A update block can include one of four actions on the file being modified, as described below. As many update blocks as required can be added to a update. </dd>\r\n		<dl>\r\n	<dt>Add File</dt>\r\n	<dd>The <strong>Add</strong> action can be used to add a new file to AChecker. This action is often used in conjuction with other update blocks that alter or delete files, to add a replacement file for one deleted, or to perhaps add a required or include file needed by a modified section in the file being changed. In the <strong>File Name</strong> field enter the file name to be assigned to the file when it is installed. In the <strong>Directory</strong> field enter the <i>relative path</i> from the AChecker root directory in which the modified file is or will exist. Select  from <strong>Upload File</strong> using the Browse button to locate the file in your local computer\'s file system. Note that the upload file can have any name. It will be renamed to the file name listed in the File Name field when it is installed.</dd>\r\n	<dt>Alter File</dt>\r\n	<dd>This option is used when you wish to make changes to a piece of code within an existing source code file. In the <strong>File Name</strong> field enter the name of the file in the AChecker source code that will be altered. In the <strong>Directory</strong> field enter the relative path to the directory in which the to be alter file exists, relative to the AChecker root directory. In the <strong>Code To Replace From</strong> field copy the code from the original file the will be replaced, or appended to, and in the <strong>Code To Replace To</strong> field enter to code that will replace the code above in the <i>From</i> field. Or, if you are adding code instead of replacing code, include the code from the field above so it gets added back if you are only using that code as a way of identifying a location in the file where new code is being added.</dd>\r\n	<dt>Delete File</dt>\r\n	<dd>This option will remove files from AChecker. In the <strong>File Name</strong>  field enter the name of the file to be deleted. In the <strong>Directory</strong> field enter the path to the directory in which the to be delete file exists, relative to the root directory of the AChecker installation. </dd>\r\n	<dt>Overwrite File</dt>\r\n	<dd>This option is used to replace an existing file in AChecker with a new one. In the <strong>File Name</strong>  field enter the name of the file to be replaced. In the <strong>Directory</strong> field enter the path to the directory in which the to be replaced file exists, relative to the root directory of the AChecker installation. In the <strong>Upload File</strong> field use the Browse button to choose a file from your local computer to replace the specified file. The upload file may be named anything. It will be renamed to the file it is replacing when the update is installed.</dd>\r\n	</dl>\r\n	<dt>Create Update</dt>\r\n	<dd>Click on this button to build the update into a downloadable zip file. This zip file can then be uploaded in the Upload field on the main Updater screen to apply a update to a system.</dd>\r\n	<dt>Save Update</dt>\r\n	<dd>Click on this button to save the developing update to the AChecker database for future reference. Though it is not required, you should save a copy of the update in this way, so it can be retrieved and edited if necessary. Or, if a update takes more than a single sitting to build, you can save it, then retrieve it later to continue.</dd>\r\n	<dt>Cancel</dt>\r\n	<dd>Press this button to ignore the latest changes to the update, and return to My Own Updates Screen.</dd>\r\n\r\n</dl>','2009-06-22 15:32:56','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_EDIT_CHECK_FUNCTION','<h2>Edit Check Function</h2>\r\n<p>This page is to edit the check function. Check function is the code performed to validate the check. AChecker provides class BasicFunctions to be called in here. Please note that none of php functions or super global variables can be used here.</p>\r\n<h3>class BasicFunctions API</h3>\r\n\r\n<table class=\"data\" rules=\"all\">\r\n<tbody>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_associatedLabelHasText\">associatedLabelHasText()</a></th>\r\n  <td>Find whether each label associated with the element contains text.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getAttributeTrimedValueLength\">getAttributeTrimedValueLength($attr)</a></th>\r\n  <td>Return the length of the trimmed value of the attribute <code>$attr</code>.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getAttributeValue\">getAttributeValue($attr)</a></th>\r\n  <td>Return the trimmed value of the attribute <code>$attr</code>.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getAttributeValueAsNumber\">getAttributeValueAsNumber($attr)</a></th>\r\n  <td>Return the trimmed value of the attribute <code>$attr</code> in number.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getAttributeValueInLowerCase\">getAttributeValueInLowerCase($attr)</a></th>\r\n  <td>Return the trimmed value of the attribute <code>$attr</code> in lower case.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getAttributeValueLength\">getAttributeValueLength($attr)</a></th>\r\n  <td>Return the length of the attribute <code>$attr</code> value. The value is NOT trimmed.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getFirstChildTag\">getFirstChildTag()</a></th>\r\n  <td>Return the html tag of the first child in the element.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getImageWidthAndHeight\">getImageWidthAndHeight($attr)</a></th>\r\n  <td>Return an array with 2 elements. Index 0 and 1 contains respectively the width and the height of the image. On failure, FALSE is returned.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getInnerText\">getInnerText()</a></th>\r\n  <td>Return the inner text contained in the element.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getInnerTextLength\">getInnerTextLength()</a></th>\r\n  <td>Return the length of the inner text contained in the element.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getLangCode\">getLangCode()</a></th>\r\n  <td>Return the language code defined in \"html\" element.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getLast4CharsFromAttributeValue\">getLast4CharsFromAttributeValue($attr)</a></th>\r\n  <td>Return last 4 characters of trimmed value from attribute <code>$attr</code>.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getLengthOfAttributeValueWithGivenTagInChildren\">getLengthOfAttributeValueWithGivenTagInChildren($tag, $attr)</a></th>\r\n  <td>Return the length of trimmed value in the attribute <code>$attr</code> where the first html tag <code>$tag</code> appears.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getLowerCaseAttributeValueWithGivenTagInChildren\">getLowerCaseAttributeValueWithGivenTagInChildren($tag, $attr)</a></th>\r\n  <td>Return the trimmed value of the attribute <code>$attr</code> where the first html tag <code>$tag</code> appears. The returned value is in lower case.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getLowerCasePlainTextWithGivenTagInChildren\">getLowerCasePlainTextWithGivenTagInChildren($tag)</a></th>\r\n  <td>Search through all children, return the trimmed inner text enclosed in the children tag <code>$tag</code>. The returned value is in plain text without any html tags.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getLuminosityContrastRatio\">getLuminosityContrastRatio($color1, $color2)</a></th>\r\n  <td>Return luminosity contrast ratio between <code>$color1</code> and <code>$color2</code>.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getNextSiblingAttributeValueInLowerCase\">getNextSiblingAttributeValueInLowerCase($attr)</a></th>\r\n  <td>Return the value of the attribute <code>$attr</code> in the next sibling element. The returned value is in lower case.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getNextSiblingInnerText\">getNextSiblingInnerText()</a></th>\r\n  <td>Return the inner text of the next sibling element.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getNextSiblingTag\">getNextSiblingTag()</a></th>\r\n  <td>Return the html tag of the next sibling html tag.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getNumOfTagInChildren\">getNumOfTagInChildren($tag)</a></th>\r\n  <td>Return the total number of times that the html tag <code>$tag</code> appears in children elements.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getNumOfTagInChildrenWithInnerText\">getNumOfTagInChildrenWithInnerText($tag)</a></th>\r\n  <td>Return the total number of times that the html tag <code>$tag</code> appears in the children elements and the inner text has content.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getNumOfTagInWholeContent\">getNumOfTagInWholeContent($tag)</a></th>\r\n  <td>Return the total number of times that the html tag <code>$tag</code> appears in the whole html content.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getNumOfTagRecursiveInChildren\">getNumOfTagRecursiveInChildren($tag)</a></th>\r\n  <td>Recursively scan through of all the children and return the number of times that the html tag <code>$tag</code> appears in all children.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getParentHTMLTag\">getParentHTMLTag()</a></th>\r\n  <td>Return the html tag of the parent element.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getPlainTextInLowerCase\">getPlainTextInLowerCase()</a></th>\r\n  <td>Return the trimmed inner text of the element. The returned value is in plain text without any html tags.</td>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getPlainTextLength\">getPlainTextLength()</a></th>\r\n  <td>Return the length of the trimmed plain text of the element. The plain text is the inner text without any html tags.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_getSubstring\">getSubstring($string, $start, $length)</a></th>\r\n  <td>Returns the portion of <code>$string</code> specified by the <code>$start</code> and <code>$length</code> parameters. </td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_hasAssociatedLabel\">hasAssociatedLabel()</a></th>\r\n  <td>Find whether the element has associated label.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_hasAttribute\">hasAttribute($attr)</a></th>\r\n  <td>Find whether the element has attribute <code>$attr</code>.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_hasDuplicateAttribute\">hasDuplicateAttribute($attr)</a></th>\r\n  <td>Recursively search all the children elements. Find whether the attribute <code>$attr</code> value appears more than once in children elements.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_hasFieldsetOnMultiCheckbox\">hasFieldsetOnMultiCheckbox()</a></th>\r\n  <td>Only perform on <code>form</code> element. Recursively search all its elements. Find whether all multiple checkbox buttons are grouped in \"fieldset\" and \"legend\" elements.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_hasGoodContrastWaiert\">hasGoodContrastWaiert($color1, $color2)</a></th>\r\n  <td>Find whether the luminosity contrast ratio between <code>$color1</code> and <code>$color2</code> is at least 5:1.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_hasIdHeaders\">hasIdHeaders()</a></th>\r\n  <td>Only performs on <code>table</code> element. Find whether the <code>table</code> element contains more than one header row or header column.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_hasLinkChildWithText\">hasLinkChildWithText($searchStrArray)</a></th>\r\n  <td>Search all the children elements. Find whether there is a <code>a</code> element with the value of attribute <code>href</code> matches one of the string in array <code>$searchStrArray</code>.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_hasParent\">hasParent($parent_tag)</a></th>\r\n  <td>Recursively search all the parent elements. Find whether there is a parent element with tag <code>$parent_tag</code>.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_hasScope\">hasScope()</a></th>\r\n  <td>Only performs on <code>table</code> element. Find whether the <code>table</code> element contains both row and column headers and the header cells contain a <code>scope</code> attribute that identifies the cells that relate to the header.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_hasTabularInfo\">hasTabularInfo()</a></th>\r\n  <td>Find whether the tag plain text contains a line that is separated by more than one tab or vertical line.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_hasTagInChildren\">hasTagInChildren($tag)</a></th>\r\n  <td>Find whether the child element with html tag <code>$tag</code> exists.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_hasTextInBtw\">hasTextInBtw()</a></th>\r\n  <td>Find whether there is text in between <code>a</code> element. Only perform on <code>a</code>.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_hasTextInChild\">hasTextInChild($childTag, $childAttribute, $valueArray)</a></th>\r\n  <td>Find whether there is a child element with tag named <code>$childTag</code>, in which the value of attribute <code>$childAttribute</code> equals one of the values in array <code>$valueArray</code>.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_hasTextLinkEquivalents\">hasTextLinkEquivalents($attr)</a></th>\r\n  <td>Only performs when <code>usemap</code> attribute in <code>img</code> element is on. Find whether there is a <code>map</code> element referred by the <code>usemap</code> attribute and each <code>area</code> element in the <code>map</code> contains a duplicate link in the document.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_hasWindowOpenInScript\">hasWindowOpenInScript()</a></th>\r\n  <td>Find whether window.open is contained in <code>script</code> element.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_htmlValidated\">htmlValidated()</a></th>\r\n  <td>Find whether the html markup language in the content is validated.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_isAttributeValueInSearchString\">isAttributeValueInSearchString($attr)</a></th>\r\n  <td>Find whether the attribute <code>$attr</code> value matches one of the search string criteria.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_isDataTable\">isDataTable()</a></th>\r\n  <td>Find whether the table defined in <code>table</code> element is a data table. Only performs on <code>table</code> element.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_isInnerTextInSearchString\">isInnerTextInSearchString()</a></th>\r\n  <td>Find whether the inner text matches one of the search string criteria.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_isNextTagNotIn\">isNextTagNotIn($notInArray)</a></th>\r\n  <td>Find whether the next header tag equals one of the values in <code>$notInArray</code>. Only performs on header tags: <code>h1</code>, <code>h2</code>, <code>h3</code>, <code>h4</code>, <code>h5</code>, <code>h6</code>.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_isPlainTextInSearchString\">isPlainTextInSearchString()</a></th>\r\n  <td>Find whether the plain text matches one of the search string criteria.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_isRadioButtonsGrouped\">isRadioButtonsGrouped()</a></th>\r\n  <td>Find whether radio button groups are marked with <code>fieldset</code> and <code>legend</code> elements.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_isSubmitLabelDifferent\">isSubmitLabelDifferent()</a></th>\r\n  <td>Find whether the labels for all the submit buttons on the form are different.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_isTextMarked\">isTextMarked($htmlTagArray)</a></th>\r\n  <td>Find whether the element content is marked with the html tags defined in <code>$htmlTagArray</code>.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_isValidLangCode\">isValidLangCode()</a></th>\r\n  <td>Find whether the language codes specified in <code>html</code> are valid.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_isValidRTL\">isValidRTL()</a></th>\r\n  <td>Find whether the <code>dir</code> attribute value has correct \"rtl\" or \"ltr\" value matching with the language code. Only perfoms on <code>html</code> element.</td>\r\n</tr>\r\n<tr>\r\n  <th align=\"left\"><a href=\"#f_validateDoctype\">validateDoctype()</a></th>\r\n  <td>Find whether <code>!DOCTYPE</code> content is valid. Only performs on <code>html</code> element.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<div>\r\n<ul>\r\n\r\n<li>\r\n<p><a name=\"f_associatedLabelHasText\">associatedLabelHasText(<code>str</code>)</a></p>\r\n<p>Returns true if each label associated with the element contains text. Otherwise, return false.</p>\r\n<p>The label associated with the element is considered as containing text when one or more of the following methods are satisfied:\r\n<ol>\r\n  <li>The element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.</li>\r\n  <li>The element has a <code>title</code> attribute.</li>\r\n  <li>The element is contained by a label element and the label contains text.</li>\r\n</ol>\r\n</p>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getAttributeTrimedValueLength\">getAttributeTrimedValueLength(<code>attr</code>)</a></p>\r\n<p>Return the length of the trimmed value of the attribute <code>attr</code>.</p>\r\n<pre>\r\nAn <code>input</code> element: <br/><input id=\" radioa \" type=\"radio\" name=\"aradio\" tabindex=\"1\" /><br/>\r\nBasicFunctions::getAttributeTrimedValueLength(\"id\") returns 6.\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getAttributeValue\">getAttributeValue(<code>attr</code>)</a></p>\r\n<p>Return the trimmed value of the attribute <code>attr</code>.</p>\r\n<pre>\r\nAn <code>input</code> element: <br/><input id=\" radioa \" type=\"radio\" name=\"aradio\" tabindex=\"1\" /><br/>\r\nBasicFunctions::getAttributeValue(\"id\") returns \"radioa\".\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getAttributeValueAsNumber\">getAttributeValueAsNumber(<code>attr</code>)</a></p>\r\n<p>Return the trimmed value of the attribute <code>attr</code> in number.</p>\r\n<pre>\r\nAn <code>input</code> element: <br/><input id=\" radioa \" type=\"radio\" name=\"aradio\" tabindex=\"1\" /><br/>\r\nBasicFunctions::getAttributeValueAsNumber(\"tabindex\") returns 1.\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getAttributeValueInLowerCase\">getAttributeValueInLowerCase(<code>attr</code>)</a></p>\r\n<p>Return the trimmed value of the attribute <code>attr</code> in lower case.</p>\r\n<pre>\r\nAn <code>input</code> element: <br/><input id=\" RADIOA \" type=\"radio\" name=\"aradio\" tabindex=\"1\" /><br/>\r\nBasicFunctions::getAttributeValueInLowerCase(\"id\") returns \"radioa\".\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getAttributeValueLength\">getAttributeValueLength(<code>attr</code>)</a></p>\r\n<p>Return the length of the attribute <code>$attr</code> value. The value is NOT trimmed.</p>\r\n<pre>\r\nAn <code>input</code> element: <br/><input id=\" RADIOA \" type=\"radio\" name=\"aradio\" tabindex=\"1\" /><br/>\r\nBasicFunctions::getAttributeValueLength(\"id\") returns 8.\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getFirstChildTag\">getFirstChildTag()</a></p>\r\n<p>Return the html tag of the first child in the element.</p>\r\n<pre>\r\nAn <code>table</code> element: <br/><table border=\"0\" cellpadding=\"5\"><caption>Latin And English Text</caption><br/>\r\nBasicFunctions::getFirstChildTag() returns \"caption\".\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getImageWidthAndHeight\">getImageWidthAndHeight(<code>attr</code>)</a></p>\r\n<p>Return an array with 2 elements. Index 0 and 1 contains respectively the width and the height of the image. On failure, FALSE is returned.</p>\r\n<pre>\r\nAn <code>img</code> element: <br/><img src=\"chart.gif\" alt=\"a complex chart\" /><br/>\r\nlist($width, $height) = BasicFunctions::getImageWidthAndHeight(\"src\");<br/>\r\n$width and $height contains the width and the height of the image \"chart.gif\". On failure, FALSE is returned.\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getInnerText\">getInnerText()</a></p>\r\n<p>Return the inner text contained in the element.</p>\r\n<pre>\r\nAn <code>a</code> element: <br/><a href=\"dogs.html\">dogs</a><br/>\r\nBasicFunctions::getInnerText() returns \"dogs\".\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getInnerTextLength\">getInnerTextLength()</a></p>\r\n<p>Return the length of the inner text contained in the element.</p>\r\n<pre>\r\nAn <code>a</code> element: <br/><a href=\"dogs.html\">dogs</a><br/>\r\nBasicFunctions::getInnerTextLength() returns 4.\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getLangCode\">getLangCode()</a></p>\r\n<p>Return the value of attribute \"xml:lang\" specified in \"html\" tag. If \"xml:lang\" is not set, return the value of attribute \"lang\".</p>\r\n<pre>\r\nAn <code>html</code> element: <br/><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\"><br/>\r\nBasicFunctions::getLangCode() returns \"en\".\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getLast4CharsFromAttributeValue\">getLast4CharsFromAttributeValue()</a></p>\r\n<p>Return last 4 characters of trimmed value from attribute <code>$attr</code>.</p>\r\n<pre>\r\nAn <code>img</code> element: <br/><img src=\"rex.gif\" alt=\"A brown and black cat named Rex.\"/><br/>\r\nBasicFunctions::getLast4CharsFromAttributeValue(\"src\") returns \".gif\".\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getLengthOfAttributeValueWithGivenTagInChildren\">getLengthOfAttributeValueWithGivenTagInChildren(<code>tag</code>, <code>attr</code>)</a></p>\r\n<p>Return the length of trimmed value in the attribute <code>attr</code> where the first html tag <code>tag</code> appears.</p>\r\n<pre>\r\nAn <code>img</code> element: <br/><p>Select link for more <a href=\"dogs.html\">information about dogs</a>.</p><br/>\r\nBasicFunctions::getLengthOfAttributeValueWithGivenTagInChildren(\"a\", \"src\") returns 9.\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getLowerCaseAttributeValueWithGivenTagInChildren\">getLowerCaseAttributeValueWithGivenTagInChildren(<code>tag</code>, <code>attr</code>)</a></p>\r\n<p>Return the trimmed value of the attribute <code>$attr</code> where the first html tag <code>$tag</code> appears. The returned value is in lower case.</p>\r\n<pre>\r\nAn <code>img</code> element: <br/><p>Select link for more <a href=\"dogs.html\">information about dogs</a>.</p><br/>\r\nBasicFunctions::getLowerCaseAttributeValueWithGivenTagInChildren(\"a\", \"src\") returns \"information about dogs\".\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getLowerCasePlainTextWithGivenTagInChildren\">getLowerCasePlainTextWithGivenTagInChildren(<code>tag</code>)</a></p>\r\n<p>Search through all children, return the trimmed inner text enclosed in the children tag <code>tag</code>. The returned value is in plain text without any html tags.</p>\r\n<pre>\r\nAn <code>table</code> element: <br/><table><caption>This is attribute <code>table</code>.</caption></table><br/>\r\nBasicFunctions::getLowerCasePlainTextWithGivenTagInChildren(\"caption\") returns \"This is attribute table.\". The html tag <code> is removed.\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getLuminosityContrastRatio\">getLuminosityContrastRatio(<code>color1</code>, <code>color2</code>)</a></p>\r\n<p>Return luminosity contrast ratio between <code>color1</code> and <code>color2</code>. Color value can be one of: rgb(x,x,x), #xxxxxx, colorname.</p>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getNextSiblingAttributeValueInLowerCase\">getNextSiblingAttributeValueInLowerCase(<code>attr</code>)</a></p>\r\n<p>Return the value of the attribute <code>attr</code> in the next sibling element. The returned value is in lower case.</p>\r\n<pre>\r\nPerform on the first <code>a</code> element: <br/><a href=\"dogs.html\">dogs</a><a href=\"Cats.html\">Products For Cats</a><br/>\r\nBasicFunctions::getNextSiblingAttributeValueInLowerCase(\"href\") returns \"cats.html\".\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getNextSiblingInnerText\">getNextSiblingInnerText()</a></p>\r\n<p>Return the inner text of the next sibling element.</p>\r\n<pre>\r\nPerform on the first <code>a</code> element: <br/><a href=\"dogs.html\">dogs</a><a href=\"Cats.html\">Products For Cats</a><br/>\r\nBasicFunctions::getNextSiblingInnerText() returns \"Products For Cats\".\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getNextSiblingTag\">getNextSiblingTag()</a></p>\r\n<p>Return the html tag of the next sibling element.</p>\r\n<pre>\r\nPerform on the first <code>a</code> element: <br/><a href=\"dogs.html\">dogs</a><a href=\"Cats.html\">Products For Cats</a><br/>\r\nBasicFunctions::getNextSiblingTag() returns \"a\".\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getNumOfTagInChildren\">getNumOfTagInChildren(<code>tag</code>)</a></p>\r\n<p>Return the total number of times that the html tag <code>tag</code> appears in children elements.</p>\r\n<pre>\r\nPerform on the <code>frameset</code> element: <br/><frameset longdesc=\"description.html\">\r\n     <frame />\r\n     <frame />\r\n     <frame />\r\n     <frame />\r\n     <noframe />\r\n</frameset><br/>\r\nBasicFunctions::getNumOfTagInChildren(\"frame\") returns 4.\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getNumOfTagInChildrenWithInnerText\">getNumOfTagInChildrenWithInnerText(<code>tag<code>)</a></p>\r\n<p>Return the total number of times that the html tag <code>tag</code> appears in the children elements and the inner text has content.</p>\r\n<pre>\r\nPerform on the <code>ol</code> element: <br/><ol>\r\n<li>Item text 1</li>\r\n<li>Item text 2</li>\r\n<li></li>\r\n</ol><br/>\r\nBasicFunctions::getNumOfTagInChildrenWithInnerText(\"li\") returns 2.\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getNumOfTagInWholeContent\">getNumOfTagInWholeContent(<code>tag</code>)</a></p>\r\n<p>Return the total number of times that the html tag <code>tag</code> appears in the whole html content.</p>\r\n<pre>\r\n<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">\r\n<head>\r\n<meta http-equiv=\"Content-Type\" content=\"text/xhtml; charset=UTF-8\" />\r\n<title>OAC Testfile - Check #29 - Negative</title>\r\n</head>\r\n<body>\r\n</body>\r\n</html><br/>\r\nBasicFunctions::getNumOfTagInWholeContent(\"doctype\") returns 1.\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getNumOfTagRecursiveInChildren\">getNumOfTagRecursiveInChildren(<code>tag<code>)</a></p>\r\n<p>Recursively scan through of all the children and return the number of times that the html tag <code>tag</code> appears in all children.</p>\r\n<pre>\r\nPerform on the <code>form</code> element: <br/><form action=\"http://example.com/prog/someprog\" method=\"post\">\r\n  <select name=\"ComOS\">\r\n    <optgroup label=\"PortMaster 3\">\r\n      <option label=\"3.7.1\" value=\"pm3_3.7.1\">\r\n        PortMaster 3 with ComOS 3.7.1\r\n      </option>\r\n      <option label=\"3.7\" value=\"pm3_3.7\">\r\n        PortMaster 3 with ComOS 3.7\r\n      </option>\r\n      <option label=\"3.5\" value=\"pm3_3.5\">\r\n        PortMaster 3 with ComOS 3.5\r\n      </option>\r\n    </optgroup>\r\n    <optgroup label=\"PortMaster 2\">\r\n      <option label=\"3.7\" value=\"pm2_3.7\">\r\n        PortMaster 2 with ComOS 3.7\r\n      </option>\r\n      <option label=\"3.5\" value=\"pm2_3.5\">\r\n        PortMaster 2 with ComOS 3.5\r\n      </option>\r\n    </optgroup>\r\n  </select>\r\n</form><br/>\r\nBasicFunctions::getNumOfTagRecursiveInChildren(\"optgroup\") returns 2.\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getParentHTMLTag\">getParentHTMLTag()</a></p>\r\n<p>Return the html tag of the parent element.</p>\r\n<pre>\r\nPerform on the <code>img</code> element: <br/><a href=\"rex.html\"><img src=\"rex.jpg\" alt=\"a story about Rex the cat\"/></a><br/>\r\nBasicFunctions::getParentHTMLTag() returns \"a\".\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getPlainTextInLowerCase\">getPlainTextInLowerCase()</a></p>\r\n<p>Return the trimmed inner text of the element. The returned value is in plain text without any html tags.</p>\r\n<pre>\r\nPerform on the <code>a</code> element: <br/><a href=\"page1.html\"><img src=\"star.jpg\" alt=\"\"/>page1</a>\r\n<br/>\r\nBasicFunctions::getPlainTextInLowerCase() returns \"page1\".\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getPlainTextLength\">getPlainTextLength()</a></p>\r\n<p>Return the length of the trimmed plain text of the element. The plain text is the inner text without any html tags.</p>\r\n<pre>\r\nPerform on the <code>a</code> element: <br/><a href=\"page1.html\"><img src=\"star.jpg\" alt=\"\"/>page1</a>\r\n<br/>\r\nBasicFunctions::getPlainTextLength() returns 5.\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_getSubstring\">getSubstring(<code>string</code>, <code>start</code>, <code>length</code>)</a></p>\r\n<p>Returns the portion of <code>string</code> specified by the <code>start</code> and <code>length</code> parameters.</p>\r\n<pre>\r\n$rest = BasicFunctions::getSubstring(\"abcdef\", -1);    // returns \"f\"\r\n$rest = BasicFunctions::getSubstring(\"abcdef\", -2);    // returns \"ef\"\r\n$rest = BasicFunctions::getSubstring(\"abcdef\", -3, 1); // returns \"d\"\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_hasAssociatedLabel\">hasAssociatedLabel()</a></p>\r\n<p>Return true if the element has associated label. Otherwise, return false.</p>\r\n<p>The element is considered as having associated label when one or more of the following methods are satisfied:\r\n<ol>\r\n  <li>The element has an <code>id</code> attribute value that matches the <code>for</code> attribute value of a <code>label</code> element.</li>\r\n  <li>The element has a <code>title</code> attribute.</li>\r\n  <li>The element is contained by a label element and the label contains text.</li>\r\n</ol>\r\n</p>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_hasAttribute\">hasAttribute(<code>attr</code>)</a></p>\r\n<p>Return true if the element has attribute <code>$attr</code>. Otherwise, return false.</p>\r\n<pre>\r\nPerform on the <code>a</code> element: <br/><a href=\"page1.html\"></a><br/>\r\nBasicFunctions::hasAttribute(\"href\") returns true.\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_hasDuplicateAttribute\">hasDuplicateAttribute(<code>attr</code>)</a></p>\r\n<p>Recursively search all the children elements. Return true if the same attribute <code>$attr</code> value appears more than once in children elements. Otherwise, return false.</p>\r\n<pre>\r\nPerform on the <code>table</code> element: <br/><table border=1 summary=\"table #1 with IDs and HEADERS\">\r\n<tr>\r\n <th id=\"city\">City</th>\r\n <th id=\"state\">State</th>\r\n</tr>\r\n<tr>\r\n <td id=\"city\">Phoenix</td>\r\n <td headers=\"state\">Arizona</td>\r\n</tr>\r\n<tr>\r\n <td headers=\"city\">Seattle</td>\r\n <td headers=\"state\">Washington</td>\r\n</tr>\r\n</table><br/>\r\nBasicFunctions::hasDuplicateAttribute(\"id\") returns true. Attribute <code>id</code> value \"city\" appears twice.\r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_hasFieldsetOnMultiCheckbox\">hasFieldsetOnMultiCheckbox()</a></p>\r\n<p>Only perform on <code>form</code> element. Recursively search all its elements. Return true if all multiple checkbox buttons are grouped in \"fieldset\" and \"legend\" elements. Otherwise, return false.</p>\r\n<pre>\r\nPerform on the <code>table</code> element: <br/><form action=\"http://example.com/donut\" method=\"post\">\r\n<fieldset>\r\n<legend>Donuts Requested (check all that apply)</legend>\r\n<p>\r\n<input type=\"checkbox\" name=\"flavour\" id=\"choc\" value=\"chocolate\" />\r\n<label for=\"choc\">Chocolate</label><br/>\r\n<input type=\"checkbox\" name=\"flavour\" id=\"cream\" value=\"cream\" />\r\n<label for=\"cream\">Cream Filled</label><br/>\r\n<input type=\"checkbox\" name=\"flavour\" id=\"honey\" value=\"honey\" />\r\n<label for=\"honey\">Honey Glazed</label>\r\n</p>\r\n</fieldset>\r\n<p><input type=\"submit\" value=\"Purchase Donuts\"/></p>\r\n</form><br/>\r\nBasicFunctions::hasFieldsetOnMultiCheckbox() returns true. \r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_hasGoodContrastWaiert\">hasGoodContrastWaiert(<code>color1</code>, <code>color2</code>)</a></p>\r\n<p>Return true if the luminosity contrast ratio between <code>color1</code> and <code>color2</code> is at least 5:1. Color value can be one of: rgb(x,x,x), #xxxxxx, colorname.</p>\r\n</li>\r\n  \r\n<li>\r\n<p><a name=\"f_hasIdHeaders\">hasIdHeaders()</a></p>\r\n<p>Only performs on <code>table</code> element. Return true if the <code>table</code> element contains more than one header row or header column.</p>\r\n<pre>\r\nPerform on the <code>table</code> element: <br/><table border=\"1\" >\r\n<tr>\r\n        <th id=\"class\">Class</th>\r\n     <th id=\"teacher\">Teacher</th>\r\n <th id=\"males\">Males</th>\r\n     <th id=\"females\">Females</th>\r\n</tr>\r\n<tr>\r\n    <th id=\"firstyear\" rowspan=\"2\">First Year</th>\r\n      <th id=\"Bolter\" headers=\"firstyear teacher\">D. Bolter</th>\r\n  <td headers=\"firstyear Bolter males\">5</td>\r\n   <td headers=\"firstyear Bolter females\">4</td>\r\n</tr>\r\n<tr>\r\n    <th id=\"Cheetham\" headers=\"firstyear teacher\">A. Cheetham</th>\r\n      <td headers=\"firstyear Cheetham males\">7</td>\r\n <td headers=\"firstyear Cheetham females\">9</td>\r\n</tr>\r\n</table><br/>\r\nBasicFunctions::hasIdHeaders() returns true. \r\n</pre>\r\n</li>\r\n \r\n<li>\r\n<p><a name=\"f_hasLinkChildWithText\">hasLinkChildWithText(<code>searchStrArray</code>)</a></p>\r\n<p>Search all the children elements. Return true if there is a <code>a</code> element with the value of attribute <code>href</code> matches one of the string in array <code>$searchStrArray</code>. Otherwise, return false.</p>\r\n<p>\r\nThe element in array searchStrArray can be one of these values:<br/>\r\ne.g. title, %title1, title2%, %title3%<br/>\r\n\"%\" can be used in front and at the end of a string to match any characters.<br/>\r\nAs an explanation, \"title\" matches exact string of \"title\".<br/>\r\n\"%title1\" matches any string ending with \"title1\".<br/>\r\n\"title2%\" matches any string starting with \"title2\".<br/>\r\n\"%title3%\" matches any string containing string \"title3\". \r\n</p>\r\n<pre>\r\nPerform on the <code>body</code> element: <br/><body>\r\n<a href=\"#content\">Go To Content</a>\r\n<a name=\"cnotent\"></a>This is cnotent.\r\n</body><br/>\r\nreturn BasicFunctions::hasLinkChildWithText(array(\"%jump%\",\"%go to%\",\"%skip%\",\"%navigation%\",\"%content%\")) returns true. \r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_hasParent\">hasParent(<code>parent_tag</code>)</a></p>\r\n<p>Recursively search all the parent elements. Return true if there is a parent element with tag <code>parent_tag</code>. Otherwise, return false.</p>\r\n<pre>\r\nPerform on the <code>script</code> element: <br/><body>\r\n<script>\r\n</script>\r\n<noscript>Alternate content for script</noscript>\r\n</body><br/>\r\nBasicFunctions::hasParent(\"body\") returns true. \r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_hasScope\">hasScope()</a></p>\r\n<p>Only performs on <code>table</code> element. Return true if the <code>table</code> element contains both row and column headers and the header cells contain a <code>scope</code> attribute that identifies the cells that relate to the header.</p>\r\n<pre>\r\nPerform on the <code>table</code> element: <br/><table border=\"1\">\r\n<tr><th scope=\"col\">Name</th><th scope=\"col\">Birth</th><th scope=\"col\">Gender</th></tr>\r\n<tr><th scope=\"row\">Clayton</th><td>2005-10-10</td><td>male</td></tr>\r\n<tr><th scope=\"row\">Carol</th><td>2005-10-11</td><td>female</td></tr>\r\n<tr><th scope=\"row\">Susan</th><td>2005-10-12</td><td>female</td></tr>\r\n<tr><th scope=\"row\">Oleg</th><td>2005-10-13</td><td>male</td></tr>\r\n<tr><th scope=\"row\">Belnar</th><td>2005-10-14</td><td>male</td></tr>\r\n</table><br/>\r\nBasicFunctions::hasScope() returns true. \r\n</pre>\r\n</li>\r\n  \r\n<li>\r\n<p><a name=\"f_hasTagInChildren\">hasTagInChildren(<code>tag</code>)</a></p>\r\n<p>Return true if the <code>tag</code> is found in children elements. Otherwise, return false.</p>\r\n<pre>\r\nPerform on the <code>body</code> element: <br/><body>\r\n<address><a href=\"mailto:name@company.com\">joe smith</a></address>\r\n</body><br/>\r\nBasicFunctions::hasTagInChildren(\"address\") returns true. \r\n</pre>\r\n</li>\r\n  \r\n<li>\r\n<p><a name=\"f_hasTextInBtw\">hasTextInBtw()</a></p>\r\n<p>Return true if there is text in between <code>a</code> element. Otherwise, return false. Only perform on <code>a</code>.</p>\r\n<pre>\r\nPerform on the first <code>a</code> element: <br/><a href=\"dogs\">dogs</a> | <a href=\"cats\">cats</a><br/>\r\nBasicFunctions::hasTextInBtw() returns true. \r\n</pre>\r\n</li>\r\n  \r\n<li>\r\n<p><a name=\"f_hasTextInChild\">hasTextInChild(<code>childTag</code>, <code>childAttribute</code>, <code>valueArray</code>)</a></p>\r\n<p>Return true if there is a child element with tag named <code>childTag</code>, in which the value of attribute <code>childAttribute</code> equals one of the values in array <code>valueArray</code>. Otherwise, return false.</p>\r\n<pre>\r\nPerform on the <code>head</code> element: <br/><head>\r\n<meta http-equiv=\"Content-Type\" content=\"text/xhtml; charset=UTF-8\" />\r\n<title>ATRC Testfile - Check #147.2 - Negative</title>\r\n<link rel=\"Index\" href=\"../index.html\" />\r\n</head><br/>\r\nBasicFunctions::hasTextInChild(\"link\", \"rel\", array(\"index\")) returns true. \r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_hasTextLinkEquivalents\">hasTextLinkEquivalents(<code>attr</code>)</a></p>\r\n<p>Only performs when <code>usemap</code> attribute in <code>img</code> element is on. Return true if there is a <code>map</code> element referred by the <code>usemap</code> attribute and each <code>area</code> element in the <code>map</code> contains a duplicate link in the document. Otherwise, return false.</p>\r\n<pre>\r\nPerform on the <code>img</code> element: <br/><p><map name=\"imagemap\" id=\"map1\">\r\n<area shape=\"poly\" coords=\"185,0,355,0,295,123\" href=\"horses.html\" alt=\"horses\"/>\r\n<area shape=\"poly\" coords=\"336,202,549,203,549\" href=\"dogs.html\" alt=\"dogs\"/>\r\n<area shape=\"rect\" coords=\"0,10,172,10\" href=\"birds.html\" alt=\"birds\"/>\r\n</map></p>\r\n\r\n<p><img src=\"navigation.gif\" usemap=\"#imagemap\" alt=\"navigation\"/></p><br/>\r\nBasicFunctions::hasTextLinkEquivalents(\"usemap\") returns true. \r\n</pre>\r\n</li>\r\n  \r\n<li>\r\n<p><a name=\"f_hasWindowOpenInScript\">hasWindowOpenInScript()</a></p>\r\n<p>Return true if window.open is contained in <code>script</code> element. Otherwise, return false.</p>\r\n<pre>\r\nPerform on the whole html content: <br/><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">\r\n<head>\r\n<meta http-equiv=\"Content-Type\" content=\"text/xhtml; charset=UTF-8\" />\r\n<title>ATRC Testfile - Check #275.1 - Positive</title>\r\n<script>\r\nwindow.onload = showAdvertisement;\r\nfunction showAdvertisement()\r\n{\r\n  window.open(\"275-2.html\", \"_blank\", \"height=200,width=150\");\r\n}\r\n</script>\r\n\r\n</head>\r\n\r\n<body>\r\n<p>This page will open a new window upon loading as long as scripting is enabled.</p>\r\n</body>\r\n</html><br/>\r\nBasicFunctions::hasWindowOpenInScript() returns true. \r\n</pre>\r\n</li>\r\n  \r\n<li>\r\n<p><a name=\"f_htmlValidated\">htmlValidated()</a></p>\r\n<p>Return true if the third party HTML markup language validator is turned on. Otherwise, return false.</p>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_isAttributeValueInSearchString\">isAttributeValueInSearchString(<code>attr</code>)</a></p>\r\n<p>Return true if the attribute <code>$attr</code> value matches one of the search string criteria. Otherwise, return false. Search string criteria is defined via \"Create/Edit Check\" page, \"Search String\" field.</p>\r\n<pre>\r\n\"Search String\" field on \"Create/Edit Check\" page is defined as \"image, photo, %bytes%\".<br/><br/>Perform on the <code>input</code> element: <br/><input type=\"image\" name=\"name\" id=\"name\" src=\"input.jpg\" alt=\"image\"><br/>\r\nBasicFunctions::isAttributeValueInSearchString(\"alt\") returns true. \r\n</pre>\r\n</li>\r\n  \r\n<li>\r\n<p><a name=\"f_isDataTable\">isDataTable()</a></p>\r\n<p>Return true if the table defined in <code>table</code> element is a data table. Otherwise, return false. Only performs on <code>table</code> element.<br/><br/> A <code>table</code> contains <code>th</code> element is considered as a data table.</p>\r\n<pre>\r\nPerform on the <code>table</code> element: <br/><table>\r\n\r\n<tr><th>name</th><th>number of cups</th><th>type</th><th>with sugar</th></tr>\r\n<tr><td>Adams, Willie</td><td>2</td><td>regular</td><td>sugar</td></tr>\r\n<tr><td>Bacon, Lise</td><td>4</td><td>regular</td><td>no sugar</td></tr>\r\n\r\n</table><br/>\r\nBasicFunctions::isDataTable() returns true. \r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_isInnerTextInSearchString\">isInnerTextInSearchString(<code>attr</code>)</a></p>\r\n<p>Return true if the inner text matches one of the search string criteria. Otherwise, return false. Search string criteria is defined via \"Create/Edit Check\" page, \"Search String\" field.</p>\r\n<pre>\r\n\"Search String\" field on \"Create/Edit Check\" page is defined as \"title, the title, this is the title, untitled document\".<br/><br/>Perform on the <code>title</code> element: <br/><title>title</title><br/>\r\nBasicFunctions::isInnerTextInSearchString() returns true. \r\n</pre>\r\n</li>\r\n  \r\n<li>\r\n<p><a name=\"f_isNextTagNotIn\">isNextTagNotIn(<code>notInArray</code>)</a></p>\r\n<p>Return true if the next header tag equals one of the values in <code>notInArray</code>. Otherwise, return false. Only performs on header tags: <code>h1</code>, <code>h2</code>, <code>h3</code>, <code>h4</code>, <code>h5</code>, <code>h6</code>.</p>\r\n<pre>\r\nPerform on the <code>h1</code> element: <br/><h1>The First Heading</h1>\r\n<p>Here is some demo text.</p>\r\n<div><div><h3>The bad Heading</h3></div></div>\r\n<p>Here is some more demo text.</p><br/>\r\nBasicFunctions::isNextTagNotIn(array(\"h1\", \"h2\")) returns true. \r\n</pre>\r\n</li>\r\n  \r\n<li>\r\n<p><a name=\"f_isPlainTextInSearchString\">isPlainTextInSearchString()</a></p>\r\n<p>Return true if the plain text matches one of the search string criteria. Otherwise, return false. Search string criteria is defined via \"Create/Edit Check\" page, \"Search String\" field.</p>\r\n<pre>\r\n\"Search String\" field on \"Create/Edit Check\" page is defined as \"click here, more\".<br/><br/>Perform on the <code>a</code> element: <br/><a href=\"dogs.html\">click <br/>here</a><br/>\r\nBasicFunctions::isPlainTextInSearchString() returns true. \r\n</pre>\r\n</li>\r\n  \r\n<li>\r\n<p><a name=\"f_isRadioButtonsGrouped\">isRadioButtonsGrouped()</a></p>\r\n<p>Return true if radio button groups are marked with <code>fieldset</code> and <code>legend</code> elements. Otherwise, return false.</p>\r\n<pre>\r\nPerform on the <code>form</code> element: <br/><form action=\"http://example.com/donut\" method=\"post\">\r\n<fieldset>\r\n<legend>Donut Type</legend>\r\n<p>\r\n<input type=\"radio\" name=\"flavour\" id=\"choc\" value=\"chocolate\" checked=\"checked\" />\r\n<label for=\"choc\">Chocolate</label><br/>\r\n<input type=\"radio\" name=\"flavour\" id=\"cream\" value=\"cream\"/>\r\n<label for=\"cream\">Cream Filled</label><br/>\r\n<input type=\"radio\" name=\"flavour\" id=\"honey\" value=\"honey\"/>\r\n<label for=\"honey\">Honey Glazed</label>\r\n</p>\r\n</fieldset>\r\n<p><input type=\"submit\" value=\"Purchase Donut\"/></p>\r\n</form><br/>\r\nBasicFunctions::isRadioButtonsGrouped() returns true. \r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_isSubmitLabelDifferent\">isSubmitLabelDifferent()</a></p>\r\n<p>Return true if the labels for all the submit buttons on the form are different. Otherwise, return false.</p>\r\n<p>The submit button label may be the <code>alt</code> attribute value of <code>input</code> elements with a <code>type</code> attribute value of \"image\" or the <code>value</code> attribute value of <code>input</code> elements with a <code>type</code> attribute value of \"submit\".</p>\r\n<pre>\r\nPerform on the <code>form</code> element: <br/><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">\r\n<head>\r\n<meta http-equiv=\"Content-Type\" content=\"text/xhtml; charset=UTF-8\" />\r\n<title>ATRC Testfile - Check #237.1 - Positive</title>\r\n</head>\r\n<body>\r\n\r\n<form action=\"http://mysite.com\">\r\n<p><input type=\"submit\" value=\"submit\"/></p>\r\n</form>\r\n\r\n<form action=\"http://yoursite.com\">\r\n<p><input type=\"image\" name=\"submit\" src=\"submit.gif\" alt=\"submit\" /></p>\r\n</form>\r\n\r\n</body>\r\n</html><br/>\r\nBasicFunctions::isSubmitLabelDifferent() returns false. \r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_isTextMarked\">isTextMarked(<code>htmlTagArray</code>)</a></p>\r\n<p>Return true if the element content is marked with the html tags defined in <code>htmlTagArray</code>. Otherwise, return false.</p>\r\n<pre>\r\nPerform on the <code>p</code> element: <br/><p><strong>Looks like a header</strong></p><br/>\r\nBasicFunctions::isTextMarked(array(\"b\", \"i\", \"u\", \"strong\")) returns true. \r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_isValidLangCode\">isValidLangCode()</a></p>\r\n<p>Return true if the language codes specified in <code>html</code> are valid. Otherwise, return false.</p>\r\n<p>\r\nThe way to determine whether the language codes are valid:<br/>\r\n1. If the content is HTML, check the value of the html element\'s lang attribute.<br/>\r\n2. If the content is XHTML 1.0, or any version of XHTML served as \"text/html\", check the values of both the html element\'s lang attribute and xml:lang attribute.<br/>\r\n   Note: both lang attributes must be set to the same value.<br/>\r\n3. If the content is XHTML 1.1 or higher and served as type \"application/xhtml+xml\", check the value of the html element\'s xml:lang attribute.<br/>\r\n4. Compare the language attribute value to valid language codes according to the ISO 639 specification.\r\n</p>\r\n<pre>\r\nPerform on the <code>html</code> element: <br/><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\"><br/>\r\nBasicFunctions::isValidLangCode(\"lang\")) returns true. \r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_isValidRTL\">isValidRTL()</a></p>\r\n<p>Return true if the <code>dir</code> attribute value has correct \"rtl\" or \"ltr\" value matching with the language code. Otherwise, return false. Only perfoms on <code>html</code> element.</p>\r\n<pre>\r\nPerform on the <code>html</code> element: <br/><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"he\" lang=\"he\" dir=\"rtl\"><br/>\r\nBasicFunctions::isValidRTL()) returns true. \r\n</pre>\r\n</li>\r\n\r\n<li>\r\n<p><a name=\"f_validateDoctype\">validateDoctype()</a></p>\r\n<p>Return true if <code>!DOCTYPE</code> content is valid. Only performs on <code>html</code> element. Return false otherwise or <code>!DOCTYPE</code> is not defined. Only perfoms on <code>html</code> element.</p>\r\n<p>\r\n<code>!DOCTYPE</code> content must and only must contain one of these values:\r\n<ol>\r\n<li>-//W3C//DTD HTML 4.01//EN</li>\r\n<li>-//W3C//DTD HTML 4.0//EN</li>\r\n<li>-//W3C//DTD XHTML 1.0 Strict//EN</li>\r\n</ol>\r\n</p>\r\n<pre>\r\nPerform on the <code>html</code> element: <br/><!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\"><br/>\r\nBasicFunctions::validateDoctype()) returns true. \r\n</pre>\r\n</li>\r\n\r\n</ul>\r\n</div>','2011-02-10 15:11:33','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_GUIDELINE','<h2>Guideline Management</h2>\r\n<p>If enabled by the AChecker administrator, users can create, edit, and delete their own guidelines and view the details of the system default guidelines. Once a user enables the guideline he/she created, it will be displayed along with the system default guidelines.</p>\r\n\r\n<p>Administrators may edit customized guidelines created by users. They can also turn on/off the \"Open to Public\" option for all the customized guidelines or system default guidelines. Once a customized guideline is public, it becomes available to all users.</p>\r\n\r\n<p>Please note that 9 system default guidelines can only be edited by an administrator. And, only an administrator can turn on \"Open to Public\".</p>\r\n','2009-04-15 10:23:02','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_HTML_TAG_LIST','<h2>HTML Tag List</h2>\n<p>This page lists all the html tags that are validated by existing AChecker checks.</p> \n','2009-04-15 11:21:58','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_INDEX','<h2>Web Accessibility Checker</h2>\r\n<p>AChecker is used to evaluate HTML content for accessibility problems by entering the location of a web page, uploading an html file, or by pasting the complete HTML source code from a Web page.</p> \r\n\r\n<p>AChecker produces a report of all accessibility problems for your selected guidelines. AChecker identifies 3 types of problems:\r\n<ol>\r\n <li><strong>Known problems</strong>: These are problems that have been identified with certainty as accessibility barriers. You must modify your page to fix these problems;</li>\r\n <li><strong>Likely problems</strong>:These are problems that have been identified as probable barriers, but require a human to make a decision.  You will likely need to modify your page to fix these problems;</li>\r\n <li><strong>Potential problems</strong>: These are problems that AChecker cannot identify, that require a human decision. You may have to modify your page for these problems, but in many cases you will just need to confirm that the problem described is not present.</li>\r\n</ol>\r\n</p>\r\n<p>Options include:</p>\r\n	<dl>\r\n		<dt>Enable HTML Validator</dt>\r\n		<dd>When this option is turned on, AChecker sends the HTML content to W3C Markup Validation Service (http://validator.w3.org/) which identifies HTML markup errors and displays the validation results in \"HTML Markup Validation Results\" section. Expect reviews to take longer when this option is enabled.</dd>\r\n		<dt>Enable CSS Validator</dt>\r\n		<dd>When this option is enabled, AChecker will send the HTML content, along with its inline styles, styles defined in the head area of the HTML, and linked external style sheets, to the W3C Jigsaw CSS Validator (http://jigsaw.w3.org/css-validator/), which will identify any errors in the CSS, and display those results under the CSS Validation tab of the Accessibility Review.</dd>\r\n		<dt>Show Source</dt>\r\n		<dd>Print out the HTML of the page being reviewed, and link listed accessibility errors directly to the lines where they occur.</dd>\r\n		<dt>Guidelines to Check Against</dt>\r\n		<dd>Turn on/off the checkboxes to select the accessibility guidelines that AChecker validates against.</dd>\r\n                <dt>View by Guideline:</dt>\r\n		<dd>Default: Present the report listing all errors grouped by guideline success criteria.</dd>\r\n                <dt>View by Line Number:</dt>\r\n		<dd>Present the report listing all errors as they occur in the HTML being evaluated, line by line.</dd>\r\n	</dl>','2011-02-24 19:46:14','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_LANGUAGE','<h2>Language Management</h2>\r\n\r\n	<p>AChecker can be displayed in many different languages! Through the Language Manager language packs can be selected and imported.</p>\r\n\r\n<h3>Managing Existing Languages</h3>\r\n	<p>Installed languages can be edited, deleted, or exported as an AChecker language pack for redistribution. When exporting a language, a download prompt will appear asking to download a zip file of the language pack.</p>\r\n	<p>Note that the English language (language code: eng) cannot be deleted. This is the base language pack that ensures AChecker runs properly. When other languages are installed, users can disable it if they don\'t want AChecker to be displayed in English.</p>\r\n	\r\n<h3>Importing Languages</h3>\r\n	<p>Language packs can be imported by retreiving the package and then importing it into AChecker.</p>\r\n	<ol>\r\n		<li>Visit <a href=\"http://www.atutor.ca/achecker/translate/index.php\" target=\"_new\">AChecker Language Packs</a> to download one of the available language packs for your version.</li>\r\n		<li>Use the <code>Browse...</code> button to find the downloaded language pack.</li>\r\n		<li>Use the <code>Import</code> button to import the language.</li>\r\n	</ol>\r\n\r\n	<p>You can contribute to the AChecker community by exporting a language pack from your AChecker installation, and attaching it to a message in the atutor.ca <a href=\"http://atutor.ca/forum/4/1.html\">Translation Forum</a>. Also see the <a href=\"http://atutor.ca/atutor/docs/translate.php\">Translator Documentation</a> for further details about translating AChecker.</p>','2009-06-04 13:08:15','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_LOGIN','<h2>Login</h2>\r\n\r\n<p>A user may login to AChecker with their Login Name or Email address, and the Password entered during <a href=\"../register.php\">registration</a>. Logging in gives users access to create, edit and use customized validation guidelines, and to save result of completed accessibility evaluations.</p>\r\n','2009-04-15 09:51:28','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_PASSWORD_REMINDER','<h2>Forgot Your Password</h2>\r\n\r\n<p>If you have forgotten your password, use the <em>Forgot your password?</em> link on the Login screen. The form will email the login name to you, along with a link you must follow to change your password.</p>\r\n','2009-04-15 09:51:37','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_PROFILE','<h2>Profile</h2>\r\n<p>This section allows a user to change elements of his/her personal profile.</p>\r\n\r\n<p>Although the login name cannot be altered, password, email address, and other personal information are editable.</p>\r\n','2009-04-15 09:51:47','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_REGISTRATION','<h2>Register</h2>\r\n\r\n<p>In order for a user to login to the AChecker system and save results from accessibility reviews, manage guidelines, translate or administer the system, a unique system account needs to be created.  Use the <em>Register</em> link on the login screen to access the registration form. If email-confirmation has been enabled by the system administrator, a message will be sent to the email address entered, containing a link that must be followed to confirm the new account. Once this has been done, the login name or email address, and the password entered during registration can now be used on the <a href=\"../login.php\">Login</a> screen.</p>','2009-04-15 09:52:02','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_SUGGESTION','<h2>Check Details</h2>\r\n<p>To view details associated with an identified barrier, click on its text link in the accessibility evaluation results to open a window and display a range of information on the barrier.</p> \r\n','2009-04-15 09:52:14','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_TRANSLATION','<h2>Translation</h2>\r\n\r\n	<p>All fields are self-explanatory. Note that language drop down box lists all the languages defined in the current installation of AChecker, no matter the language status (enabled or disabled). If you are translating a new language for AChecker, first define the language using the Language management tool\'s Add Language feature. If you do not have access to the Language management tools, ask your AChecker administrators to add the language.</p>\r\n\r\n<p>You can contribute to the AChecker community by exporting a language pack from your AChecker installation, and attaching it to a message in the atutor.ca <a href=\"http://atutor.ca/forum/4/1.html\">Translation Forum</a>. Also see the <a href=\"http://atutor.ca/atutor/docs/translate.php\">Translator Documentation</a> for further details about translating AChecker.</p>','2009-06-04 13:17:38','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_UPDATER','<h2>Updater</h2>\r\n	<p>The Updater was introduce in AChecker 1.1 to allow administrators to update their systems with feature adjustments, security fixes, and other AChecker code changes in between AChecker releases. </p>\r\n<dl>\r\n	<dt>The Update List</dt>\r\n	<dd>On the opening screen of the Updater will appear a list of updates available for the version of AChecker you are using, along with a description of each update.  This list is retrieved from update.atutor.ca, as are the updates themselves, so you must be connected to the Internet. Updates are retrieved from update.atutor.ca by AChecker and applied as necessary. </dd>\r\n	<dt>File Permissions</dt>\r\n	<dd>In most cases you will be asked to temporarily grant write permission to the files that need to be updated or replaced, then once the update has been applied, you will be asked to change the permissions back to read only. It is important that you follow the instructions after updates have been applied, otherwise you run the risk of opening a security hole. \r\n	</dd>\r\n	<dt>Types of Updates</dt>\r\n	<dd>Updates come in various forms. Some updates replace code in a file with new code. Others replace a file with a new file.  Others may do both on multiple files and multiple code changes. Other updates delete files that are no longer required.</dd>\r\n	<dt>Required and Non-Required Updates</dt>\r\n	<dd>In most cases you will want to install updates in the order they appear in the update list, but not all updates are required updates.  Some feature updates can be ignored if you do not need the features they would add or modify on your system. Other updates will have dependencies, requiring the administrator to install earlier updates before installing a later one. You will be prompted to install previous updates if there are dependencies.</dd>\r\n	<dt>Checks and File Backups</dt>\r\n	<dd>If you have made changes to a file the Updater wishes to change,  you will be prompted to continue or not. The updater compares your local file with the same file in the AChecker code repository, and if they differ the prompt will display. In many cases  the Updater can apply updates without changing the code you have modified, but if the code to be replaced was modified, the update will fail, or if the update replaces a file, your changes will be lost. In all cases the updater will create a backup of the files that were modified, identified by the filename plus the update number added as a suffix. Rename the file to its original name to restore that file back to its original state. You can list these files by clicking the view messages button next to the update listing after the update is installed. After you have confirmed that the updates were applied and are working properly, it is safe to delete the backup files, though it does not hurt to keep them around. </dd>\r\n	<dt>Private Updates</dt>\r\n	<dd>In some cases private updates can be applied by uploading a update file through the upload form below the update list.  Private updates are often those used to apply changes that are not being applied to the AChecker default source code, or to apply custom features, or to share updates between users, etc. When uploading a update, be sure the update id, defined in the patch.xml file, is unique . </dd>\r\n</dl>','2011-03-02 21:31:05','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_USER','<h2>User Management</h2>\r\n\r\n	<p>This section allows administrators to manage all user accounts. Each user belongs to a user group to which privileges are assigned.</p>\r\n\r\n<p>There are four types of default user groups that are created when AChecker is installed. These are described below along with the default privileges associated with each groups. \r\n	<dl>\r\n		<dt>Administrator</dt>\r\n		<dd>Administrators have privileges to use the Web Accessibility Checker, manage users, guidelines, checks, languages and manage their own profile.</dd>\r\n		<dt>Regular User</dt>\r\n		<dd>Regular users have privileges to use the Web Accessibility Checker, create/edit their own guidelines, and manage their own profile. The guidelines created by regular users are only accessible to the creator. To make the guidelines accessible by other users, administrator\'s publish action is required.</dd>\r\n		<dt>Guideline/Check editor</dt>\r\n		<dd>Guideline/Check editor have privileges to use the Web Accessibility Checker, create/edit guidelines and accessibility checks, and manage to their own profile. The guidelines created by this group of users needs an administrator to publish them to make them available to other users.</dd>\r\n		<dt>Translator</dt>\r\n		<dd>Translators have privileges to use the Web Accessibility Checker, translate AChecker terms from English to other languages, and to manage their own profile. The languages that can be used in the system are defined by users who have \"Language Management\" privileges.</dd>\r\n	</dl>\r\n</p>\r\n\r\n<h3>Creating User Accounts</h3>\r\n\r\n<p>The users who belong to a group that has \"User Management\" privileges can manually add users to the system by using <em>Create User</em>.</p>\r\n<p>User accounts can also be created by individuals using the Registration form available through the public pages of AChecker. The accounts created via the Registration form are automatically set to user group \"Regular User\". </p>\r\n\r\n<h3>User Group</h3>\r\n\r\n<p><em>User Group</em> is used to create new user groups and edit existing user groups.</p>','2009-06-04 12:55:56','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_USER_GROUP ','<h2>User Group</h2>\r\n\r\n<p>The User Group section allows administrators to manage user groups. User groups define the privileges that are granted to the users who are members of a group. Note that \"Administrator\" and \"Regular User\" groups can not  be deleted. They must exist for AChecker\'s proper operations. All other groups are optional.</p>\r\n\r\n<p>There are four default user groups in AChecker. Below is a description of the default privileges that are granted to each group. The privileges in user groups are editable by users who are a member of a group that has the \"User Management\" privilege.\r\n<dl>\r\n<dt>Administrator</dt>\r\n<dd>Administrators have privileges to use the  Web Accessibility Checker, manage users, guidelines, checks, languages and manage their own profile.</dd>\r\n<dt>Regular User</dt>\r\n<dd>Regular users have privileges to use the Web Accessibility Checker, create/edit their own guidelines and manage their own profile. The guidelines created by regular users are only accessible to the creator. To make the guidelines accessible by other users, administrator\'s publish action is required.</dd>\r\n<dt>Guideline/Check editor</dt>\r\n<dd>Guideline/Check editor have privileges to use the  Web Accessibility Checker, create/edit guidelines and accessibility checks, and manage to their own profile. The guidelines created by this group of users need administrator\'s to publish them to make them accessible to other users.</dd>\r\n<dt>Translator</dt>\r\n<dd>Translators have privileges to use the Web Accessibility Checker, translate AChecker terms from English to other languages, and to manage their own profile. The languages that can be used in the system are defined by users who have \"Language Management\" privileges.</dd>\r\n</dl>\r\n</p>','2009-06-04 13:04:37','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_USER_PASSWORD ','<h2>Change Password</h2>\r\n\r\n<p>All fields are required and self-explanatory. Once the new password is set successfully, an email notification is sent to the user.</p>\r\n','2009-04-15 09:53:11','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_HELP_VIEW_GUIDELINE ','<h2>View Guidelines</h2>\r\n<p>Under the Guidelines tab, choose a radio button beside one of the listed guidelines, then press the View button to view details about that guideline. Details include the guideline\'s basic information, as well as all the checks being run when this guideline is selected during an accessibility review.</p> \r\n','2009-04-15 09:53:24','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_INFOS_INVALID_USER','You must <a href=\"login.php\">login</a> to use this section.','2009-01-15 16:13:14','');
REPLACE INTO `language_text` VALUES ('eng', '_msgs','AC_INFOS_UPDATE_INSTALLED_AND_REMOVE_PERMISSION','The update has been installed. Please remove write permission as instruction.','2009-06-22 14:49:02','Updater: info msg');
REPLACE INTO `language_text` VALUES ('eng', '_template','15_max_chars','8 characters minimum, 15 characters maximum','2009-01-09 10:16:38','');
REPLACE INTO `language_text` VALUES ('eng', '_template','20_max_chars','20 character maximum','2009-01-09 10:16:38','');
REPLACE INTO `language_text` VALUES ('eng', '_template','abbr','Abbreviation','2009-01-21 12:38:17','');
REPLACE INTO `language_text` VALUES ('eng', '_template','accessibility_review','Accessibility Review','2008-11-24 14:12:25','');
REPLACE INTO `language_text` VALUES ('eng', '_template','achecker_documentation','AChecker Documentation','2009-06-16 10:25:25','');
REPLACE INTO `language_text` VALUES ('eng', '_template','achecker_handbook','AChecker Handbook','2011-01-14 11:24:15','');
REPLACE INTO `language_text` VALUES ('eng', '_template','achecker_home','AChecker Home','2009-01-09 14:15:29','');
REPLACE INTO `language_text` VALUES ('eng', '_template','achecker_update_id','AChecker Update ID','2009-06-22 14:49:01','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','achecker_version_to_apply','AChecker Version to Apply','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','achecker_whatis','<strong>Welcome to AChecker</strong>. This tool checks single HTML pages for conformance with accessibility standards to ensure the content can be accessed by everyone. See the Handbook link to the upper right for more about the Web Accessibility Checker.','2011-02-01 10:19:52','');
REPLACE INTO `language_text` VALUES ('eng', '_template','acheck_copyright','Web site engine\'s code is copyright &copy; 2011','2011-01-14 11:48:19','');
REPLACE INTO `language_text` VALUES ('eng', '_template','add','Add','2009-03-24 13:47:37','');
REPLACE INTO `language_text` VALUES ('eng', '_template','add_a_file','Add A File','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','add_checks','Add Checks','2009-01-21 16:23:10','');
REPLACE INTO `language_text` VALUES ('eng', '_template','add_checks_into_group','Add Checks Into Group','2009-04-08 15:19:33','');
REPLACE INTO `language_text` VALUES ('eng', '_template','add_checks_into_guideline','Add Checks Into Guideline','2009-04-08 15:19:33','');
REPLACE INTO `language_text` VALUES ('eng', '_template','add_checks_into_subgroup','Add Checks Into Subgroup','2009-04-08 15:19:33','');
REPLACE INTO `language_text` VALUES ('eng', '_template','add_dependent_update','Add A Dependent Update','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','add_edit_group','Add/Edit Group','2009-04-08 15:20:56','');
REPLACE INTO `language_text` VALUES ('eng', '_template','add_edit_language','Add/Edit Language','2009-02-23 13:27:38','');
REPLACE INTO `language_text` VALUES ('eng', '_template','add_group','Add Group','2009-04-08 10:09:06','');
REPLACE INTO `language_text` VALUES ('eng', '_template','add_language','Add Language','2009-02-18 15:56:02','');
REPLACE INTO `language_text` VALUES ('eng', '_template','add_next_checks','Add Next Checks','2009-03-24 13:47:37','');
REPLACE INTO `language_text` VALUES ('eng', '_template','add_pre_checks','Add Prerequisite Checks','2009-03-20 12:01:45','');
REPLACE INTO `language_text` VALUES ('eng', '_template','add_privileges','Add Privileges','2009-02-17 09:45:53','');
REPLACE INTO `language_text` VALUES ('eng', '_template','add_subgroup','Add Subgroup','2009-04-08 10:09:06','');
REPLACE INTO `language_text` VALUES ('eng', '_template','all','All','2008-11-27 09:49:41','');
REPLACE INTO `language_text` VALUES ('eng', '_template','alter','Alter','2009-06-22 14:49:02','');
REPLACE INTO `language_text` VALUES ('eng', '_template','author','Author','2009-02-06 11:42:21','');
REPLACE INTO `language_text` VALUES ('eng', '_template','author_not_exist','[ Author no longer exists ]','2009-02-06 11:50:50','');
REPLACE INTO `language_text` VALUES ('eng', '_template','available_to','Available To','2009-06-22 14:49:01','');
REPLACE INTO `language_text` VALUES ('eng', '_template','available_updates','Available Updates','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','back_to','Back To: ','2009-01-15 13:18:41','');
REPLACE INTO `language_text` VALUES ('eng', '_template','back_to_chapters','Back to Chapters','2009-01-29 13:49:27','');
REPLACE INTO `language_text` VALUES ('eng', '_template','back_to_contents','Back to Contents','2009-01-29 15:05:04','');
REPLACE INTO `language_text` VALUES ('eng', '_template','bold','bold','2010-09-22 00:00:00','');
REPLACE INTO `language_text` VALUES ('eng', '_template','calendar','Calendar','2009-04-06 10:43:09','');
REPLACE INTO `language_text` VALUES ('eng', '_template','cancel','Cancel','2009-01-09 10:29:35','');
REPLACE INTO `language_text` VALUES ('eng', '_template','change_email','Change Email','2009-01-15 11:29:34','');
REPLACE INTO `language_text` VALUES ('eng', '_template','change_password','Change Password','2009-01-15 11:29:34','');
REPLACE INTO `language_text` VALUES ('eng', '_template','charset','Character Set','2009-02-20 11:43:44','');
REPLACE INTO `language_text` VALUES ('eng', '_template','check','Check','2009-05-29 16:20:08','');
REPLACE INTO `language_text` VALUES ('eng', '_template','checks','Checks','2009-01-21 12:38:17','');
REPLACE INTO `language_text` VALUES ('eng', '_template','check_by_paste','Paste HTML Markup','2011-01-26 21:15:50','');
REPLACE INTO `language_text` VALUES ('eng', '_template','check_by_upload','HTML File Upload','2011-01-26 21:16:00','');
REPLACE INTO `language_text` VALUES ('eng', '_template','check_by_uri','Web Page URL','2011-01-26 21:16:09','');
REPLACE INTO `language_text` VALUES ('eng', '_template','check_id','Check ID','2009-04-02 13:16:21','');
REPLACE INTO `language_text` VALUES ('eng', '_template','check_it','Check It','2008-11-21 14:25:37','');
REPLACE INTO `language_text` VALUES ('eng', '_template','check_terms','Check Terms','2008-11-27 09:48:36','');
REPLACE INTO `language_text` VALUES ('eng', '_template','choose_lang','Choose a language to translate','2008-11-26 10:11:15','');
REPLACE INTO `language_text` VALUES ('eng', '_template','close_from_public','Close From Public','2009-01-26 13:34:22','');
REPLACE INTO `language_text` VALUES ('eng', '_template','close_popup','Close Popup','2009-01-28 15:28:06','');
REPLACE INTO `language_text` VALUES ('eng', '_template','code_to_replace_from','Code To Replace From','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','code_to_replace_to','Code To Replace To','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','color_contrast_example','color contrast example','2010-09-22 00:00:00','');
REPLACE INTO `language_text` VALUES ('eng', '_template','column','Column','2009-06-08 11:10:16','');
REPLACE INTO `language_text` VALUES ('eng', '_template','combination','Use a combination of letters, numbers and symbols','2009-01-09 10:16:38','');
REPLACE INTO `language_text` VALUES ('eng', '_template','conditional_pass','CONDITIONAL PASS','2009-03-09 12:54:29','');
REPLACE INTO `language_text` VALUES ('eng', '_template','confirm_delete','Are you sure you want to delete these records?','2009-04-09 11:29:46','');
REPLACE INTO `language_text` VALUES ('eng', '_template','congrats_css_validation','Congratulations! Passed CSS Validation.','2010-06-09 00:00:00','');
REPLACE INTO `language_text` VALUES ('eng', '_template','congrats_html_validation','Congratulations! Passed HTML Validation.','2008-11-24 14:12:25','');
REPLACE INTO `language_text` VALUES ('eng', '_template','congrats_no_known','Congratulations! No known problems.','2008-11-24 14:12:25','');
REPLACE INTO `language_text` VALUES ('eng', '_template','congrats_no_likely','Congratulations! No likely problems.','2008-11-24 14:12:25','');
REPLACE INTO `language_text` VALUES ('eng', '_template','congrats_no_potential','Congratulations! No potential problems.','2008-11-24 14:12:25','');
REPLACE INTO `language_text` VALUES ('eng', '_template','contain_only','May contain only letters, numbers, underscores, hyphens or periods.','2009-01-09 10:16:38','');
REPLACE INTO `language_text` VALUES ('eng', '_template','content_start','Start Content','2009-05-28 08:59:13','');
REPLACE INTO `language_text` VALUES ('eng', '_template','continue','Continue','2009-06-22 14:49:02','');
REPLACE INTO `language_text` VALUES ('eng', '_template','create_check','Create Check','2009-03-17 13:29:08','');
REPLACE INTO `language_text` VALUES ('eng', '_template','create_edit_check','Create/Edit Check','2009-03-18 09:42:26','');
REPLACE INTO `language_text` VALUES ('eng', '_template','create_edit_guideline','Create/Edit Guideline','2009-02-05 10:22:12','');
REPLACE INTO `language_text` VALUES ('eng', '_template','create_edit_update','Create/Edit Update','2009-06-22 14:49:01','');
REPLACE INTO `language_text` VALUES ('eng', '_template','create_edit_user','Create/Edit User','2009-02-05 10:25:08','');
REPLACE INTO `language_text` VALUES ('eng', '_template','create_edit_user_group','Create User Group','2009-02-18 11:13:36','');
REPLACE INTO `language_text` VALUES ('eng', '_template','create_guideline','Create Guideline','2009-01-21 15:58:32','');
REPLACE INTO `language_text` VALUES ('eng', '_template','create_update','Create Update','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','create_user','Create User','2009-01-21 15:58:32','');
REPLACE INTO `language_text` VALUES ('eng', '_template','css_validation_result','CSS Validation','0000-00-00 00:00:00','');
REPLACE INTO `language_text` VALUES ('eng', '_template','css_validator_disabled','CSS Validator is turned off. Enable it in \"Options\".','2011-02-01 10:22:32','');
REPLACE INTO `language_text` VALUES ('eng', '_template','css_validator_provided_by','<strong>Note: Results are provided by http://jigsaw.w3.org/css-validator </strong>','2011-03-02 18:56:34','');
REPLACE INTO `language_text` VALUES ('eng', '_template','css_validator_unavailable','CSS Validator is only available when validating by URL.','2011-02-02 10:33:34','');
REPLACE INTO `language_text` VALUES ('eng', '_template','customized_guidelines','Customized Guidelines','2009-01-26 13:27:56','');
REPLACE INTO `language_text` VALUES ('eng', '_template','date','Date','2009-02-27 16:07:19','');
REPLACE INTO `language_text` VALUES ('eng', '_template','date_created','Date Created','2009-02-17 12:02:27','');
REPLACE INTO `language_text` VALUES ('eng', '_template','decision','Decision','2009-02-27 16:07:19','');
REPLACE INTO `language_text` VALUES ('eng', '_template','decision_fail','FAIL Decision','2009-03-18 14:53:42','');
REPLACE INTO `language_text` VALUES ('eng', '_template','decision_pass','PASS Decision','2009-03-18 14:53:42','');
REPLACE INTO `language_text` VALUES ('eng', '_template','delete','Delete','2009-01-22 16:02:07','');
REPLACE INTO `language_text` VALUES ('eng', '_template','delete_check','Delete Check','2009-03-17 13:29:08','');
REPLACE INTO `language_text` VALUES ('eng', '_template','delete_guideline','Delete Guideline','2009-01-23 11:20:13','');
REPLACE INTO `language_text` VALUES ('eng', '_template','delete_language','Delete Language','2009-02-18 15:56:02','');
REPLACE INTO `language_text` VALUES ('eng', '_template','delete_this_file','Delete This File','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','delete_update','Delete Update','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','delete_user','Delete User','2009-02-06 11:41:23','');
REPLACE INTO `language_text` VALUES ('eng', '_template','delete_user_group','Delete User Group','2009-02-12 15:08:53','');
REPLACE INTO `language_text` VALUES ('eng', '_template','del_this_group','Delete This Group','2009-04-09 12:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_template','del_this_subgroup','Delete This Subgroup','2009-04-09 12:02:22','');
REPLACE INTO `language_text` VALUES ('eng', '_template','dependent_updates','Dependent Updates','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','dependent_update_id','Dependent Update ID','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','dependent_update_not_installed','<br><span style=\"color: red\">Waring: Due to update dependency, please install the listed updates first: </span>','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','description','Description','2008-11-24 14:25:44','');
REPLACE INTO `language_text` VALUES ('eng', '_template','details','Check Details','2009-04-24 09:52:05','');
REPLACE INTO `language_text` VALUES ('eng', '_template','directory','Directory','2009-06-22 14:49:01','');
REPLACE INTO `language_text` VALUES ('eng', '_template','disable','Disable','2009-01-20 11:47:15','');
REPLACE INTO `language_text` VALUES ('eng', '_template','disabled','Disabled','2009-01-20 11:45:23','');
REPLACE INTO `language_text` VALUES ('eng', '_template','done','Done','2009-06-22 16:16:50','');
REPLACE INTO `language_text` VALUES ('eng', '_template','earlid','URL','2009-01-21 12:38:17','');
REPLACE INTO `language_text` VALUES ('eng', '_template','edit','Edit','2009-01-22 16:02:07','');
REPLACE INTO `language_text` VALUES ('eng', '_template','edit_check_function','Edit Check Function','2009-03-17 13:29:08','');
REPLACE INTO `language_text` VALUES ('eng', '_template','edit_function','Edit Function','2009-03-17 14:58:36','');
REPLACE INTO `language_text` VALUES ('eng', '_template','edit_group_name','Edit Group Name','2009-04-08 15:19:33','');
REPLACE INTO `language_text` VALUES ('eng', '_template','edit_profile','Edit Profile','2009-01-16 10:52:51','');
REPLACE INTO `language_text` VALUES ('eng', '_template','edit_subgroup_name','Edit Subgroup Name','2009-04-08 15:19:33','');
REPLACE INTO `language_text` VALUES ('eng', '_template','edit_update','Edit Update','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','element','Element','2011-01-20 14:03:52','CSS validator');
REPLACE INTO `language_text` VALUES ('eng', '_template','element_CSS_rules','CSS rules for the element','2010-09-22 00:00:00','');
REPLACE INTO `language_text` VALUES ('eng', '_template','email','Email','2009-02-04 11:51:16','');
REPLACE INTO `language_text` VALUES ('eng', '_template','email_address','Email Address','2009-01-09 10:40:36','');
REPLACE INTO `language_text` VALUES ('eng', '_template','email_confirmation_message','You have registered for an account on %1s. Please finish the registration process by confirming your email address by using the following link: %2s .','2009-01-14 13:25:55','');
REPLACE INTO `language_text` VALUES ('eng', '_template','email_confirmation_message2','To finish changing your account\'s email address on %1s, please confirm your email address by using the following link: %2s .','2009-01-16 11:07:44','');
REPLACE INTO `language_text` VALUES ('eng', '_template','email_confirmation_required','Confirmation will be sent to this email address. Follow instructions in the email to activate your account.','2011-01-31 16:32:17','');
REPLACE INTO `language_text` VALUES ('eng', '_template','email_confirmation_subject','Email Confirmation','2009-01-14 13:25:55','');
REPLACE INTO `language_text` VALUES ('eng', '_template','enable','Enable','2009-01-20 11:47:15','');
REPLACE INTO `language_text` VALUES ('eng', '_template','enabled','Enabled','2009-01-20 11:45:23','');
REPLACE INTO `language_text` VALUES ('eng', '_template ','enable_css_validation','Enable CSS Validator','2010-06-08 00:00:00','');
REPLACE INTO `language_text` VALUES ('eng', '_template','enable_html_validator','Enable HTML Validator','2008-11-21 14:25:37','');
REPLACE INTO `language_text` VALUES ('eng', '_template','english_context','English Context','2008-12-01 13:18:57','');
REPLACE INTO `language_text` VALUES ('eng', '_template','english_text','English Text','2008-12-01 13:18:57','');
REPLACE INTO `language_text` VALUES ('eng', '_template','enter','Paste from clipboard complete HTML source','2011-01-28 15:24:36','');
REPLACE INTO `language_text` VALUES ('eng', '_template','error','Error','2008-11-24 14:25:44','');
REPLACE INTO `language_text` VALUES ('eng', '_template','errors','Errors','2009-03-09 09:55:45','');
REPLACE INTO `language_text` VALUES ('eng', '_template','error_type','Error Type','2009-01-21 12:38:17','');
REPLACE INTO `language_text` VALUES ('eng', '_template','examples','Examples','2009-04-02 13:16:21','');
REPLACE INTO `language_text` VALUES ('eng', '_template','example_type','Example Type','2009-04-02 13:16:21','');
REPLACE INTO `language_text` VALUES ('eng', '_template','expand_add_checks','Expand Add Checks','2009-01-21 16:23:10','');
REPLACE INTO `language_text` VALUES ('eng', '_template','expand_add_pre_checks','Expand Add Prerequisite Checks','2009-03-20 12:01:45','');
REPLACE INTO `language_text` VALUES ('eng', '_template','expand_add_privileges','Expand Add Privileges','2009-02-17 09:45:53','');
REPLACE INTO `language_text` VALUES ('eng', '_template','expand_guidelines','Expand Guidelines','2008-11-21 14:25:37','');
REPLACE INTO `language_text` VALUES ('eng', '_template','expected_result','Expected Result','2008-11-24 14:25:44','');
REPLACE INTO `language_text` VALUES ('eng', '_template','export','Export','2009-02-24 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_template','external_CSS','External CSS','2010-09-22 00:00:00','');
REPLACE INTO `language_text` VALUES ('eng', '_template','fail','FAIL','2009-03-09 12:54:29','');
REPLACE INTO `language_text` VALUES ('eng', '_template','failed_result','Failed Result','2008-11-24 14:25:44','');
REPLACE INTO `language_text` VALUES ('eng', '_template','fail_example','Fail HTML Example','2009-04-02 11:08:06','');
REPLACE INTO `language_text` VALUES ('eng', '_template','fail_examples','Fail Examples','2009-04-02 13:16:21','');
REPLACE INTO `language_text` VALUES ('eng', '_template','fail_example_desc','Fail Example Description','2009-04-02 11:08:06','');
REPLACE INTO `language_text` VALUES ('eng', '_template','feedback','Feedback','2009-06-08 18:08:18','');
REPLACE INTO `language_text` VALUES ('eng', '_template','file','File','2009-06-22 14:49:01','');
REPLACE INTO `language_text` VALUES ('eng', '_template','files','Files','2009-06-22 14:49:01','');
REPLACE INTO `language_text` VALUES ('eng', '_template','file_name','File Name','2009-06-22 14:49:01','');
REPLACE INTO `language_text` VALUES ('eng', '_template','filter','Filter','2008-11-27 09:48:36','');
REPLACE INTO `language_text` VALUES ('eng', '_template','first_name','First Name','2009-01-09 10:40:36','');
REPLACE INTO `language_text` VALUES ('eng', '_template','fixed_size_example_text','Fixed size example','2010-09-22 00:00:00','');
REPLACE INTO `language_text` VALUES ('eng', '_template','function','Function','2009-03-26 10:09:37','');
REPLACE INTO `language_text` VALUES ('eng', '_template','get_my_update','Get My Update','2009-06-22 14:49:01','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','get_seal','&nbsp;&nbsp;<span style=\"color:#E41B17;;border:thin solid #E41B17;\"><a href=\"checker/index.php#seals_div\">Conformance seal now issued.</a></span>','2011-02-28 20:08:38','');
REPLACE INTO `language_text` VALUES ('eng', '_template','grant_write_permission','Please grant <strong>write</strong> permission to folders and files listed below:<p><strong>Note:</strong> To change permissions on Unix use <kbd>chmod a+rw</kbd> then the file name.</p>','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','guidelines','Guidelines','2008-11-24 14:12:25','');
REPLACE INTO `language_text` VALUES ('eng', '_template','guideline_group','Guideline Group','2009-04-30 15:19:16','');
REPLACE INTO `language_text` VALUES ('eng', '_template','guideline_subgroup','Guideline Subgroup','2009-04-30 15:19:16','');
REPLACE INTO `language_text` VALUES ('eng', '_template','guideline_terms','Guideline Terms','2008-11-27 09:48:36','');
REPLACE INTO `language_text` VALUES ('eng', '_template','guidelins_to_check','Guidelines to Check Against','2008-11-21 14:25:37','');
REPLACE INTO `language_text` VALUES ('eng', '_template','handbook_toc','Handbook Toc','2009-01-28 15:28:06','');
REPLACE INTO `language_text` VALUES ('eng', '_template','has_unsaved_info','You have unsaved changes. Do you want to save them? Proceeding without saving them will cause the lose of those changes.','2009-04-07 11:10:39','');
REPLACE INTO `language_text` VALUES ('eng', '_template','hide_contents','Hide Contents','2009-01-28 15:28:06','');
REPLACE INTO `language_text` VALUES ('eng', '_template','how_to_determine','How To Determine','2008-11-24 14:25:44','');
REPLACE INTO `language_text` VALUES ('eng', '_template','how_to_repair','How To Repair','2008-11-24 14:25:44','');
REPLACE INTO `language_text` VALUES ('eng', '_template','html_tag','Element','2009-05-28 11:11:15','');
REPLACE INTO `language_text` VALUES ('eng', '_template','html_tag_list','HTML Tag List','2009-03-18 10:34:20','');
REPLACE INTO `language_text` VALUES ('eng', '_template','html_tag_text','Use lower case on html tag.','2009-03-18 10:16:17','');
REPLACE INTO `language_text` VALUES ('eng', '_template','html_validation_result','HTML Validation','2009-05-28 08:52:06','');
REPLACE INTO `language_text` VALUES ('eng', '_template','html_validator_disabled','HTML Validator is turned off. Enable it in \"Options\".','2011-02-01 10:22:12','');
REPLACE INTO `language_text` VALUES ('eng', '_template','html_validator_provided_by','<strong>Note: Results are provided by http://validator.w3.org/</strong>','2008-11-24 14:12:25','');
REPLACE INTO `language_text` VALUES ('eng', '_template','import','Import','2009-02-18 15:56:02','');
REPLACE INTO `language_text` VALUES ('eng', '_template','import_a_new_lang','Import a New Language','2009-02-24 13:58:06','');
REPLACE INTO `language_text` VALUES ('eng', '_template','info','Information','2009-03-06 11:29:10','');
REPLACE INTO `language_text` VALUES ('eng', '_template','input','Check Accessibility By:','2011-01-26 21:16:34','');
REPLACE INTO `language_text` VALUES ('eng', '_template','install','Install','2009-06-22 14:49:03','');
REPLACE INTO `language_text` VALUES ('eng', '_template','installed_date','Installed Date','2009-06-22 14:49:01','');
REPLACE INTO `language_text` VALUES ('eng', '_template','interface_terms','Interface Terms','2008-11-27 09:48:36','');
REPLACE INTO `language_text` VALUES ('eng', '_template','internal_CSS','Internal CSS','2010-09-22 00:00:00','');
REPLACE INTO `language_text` VALUES ('eng', '_template','in_progress','Accessibility Validation in Progress','2011-03-03 17:47:26','');
REPLACE INTO `language_text` VALUES ('eng', '_template','jump_to_content','Jump to Content','2009-05-25 10:17:46','');
REPLACE INTO `language_text` VALUES ('eng', '_template','known','Known','2008-11-24 13:04:52','');
REPLACE INTO `language_text` VALUES ('eng', '_template','known_problem','Known Problem','2009-03-18 11:18:40','');
REPLACE INTO `language_text` VALUES ('eng', '_template','known_problems','Known Problems','2008-11-24 14:12:25','');
REPLACE INTO `language_text` VALUES ('eng', '_template','language','Language','2009-04-14 10:35:06','');
REPLACE INTO `language_text` VALUES ('eng', '_template','lang_code','Language Code','2009-02-20 11:43:44','');
REPLACE INTO `language_text` VALUES ('eng', '_template','last_login','Last Login','2009-02-04 11:51:16','');
REPLACE INTO `language_text` VALUES ('eng', '_template','last_modified','Last Modified','2009-06-22 14:49:01','');
REPLACE INTO `language_text` VALUES ('eng', '_template','last_name','Last Name','2009-01-09 10:28:23','');
REPLACE INTO `language_text` VALUES ('eng', '_template','last_update','Last Update','2009-02-17 12:02:27','');
REPLACE INTO `language_text` VALUES ('eng', '_template','likely','Likely','2008-11-24 13:04:52','');
REPLACE INTO `language_text` VALUES ('eng', '_template','likely_problem','Likely Problem','2009-03-10 15:00:57','');
REPLACE INTO `language_text` VALUES ('eng', '_template','likely_problems','Likely Problems','2008-11-24 14:12:25','');
REPLACE INTO `language_text` VALUES ('eng', '_template','line','Line','2009-06-08 11:09:47','');
REPLACE INTO `language_text` VALUES ('eng', '_template','link_open_in_new','(link opens in a new window)','2009-03-26 14:19:22','');
REPLACE INTO `language_text` VALUES ('eng', '_template','locale','Locale','2009-02-23 13:27:38','');
REPLACE INTO `language_text` VALUES ('eng', '_template','login','Login','2009-01-07 16:14:08','');
REPLACE INTO `language_text` VALUES ('eng', '_template','login_name','Login Name','2009-01-09 10:40:36','');
REPLACE INTO `language_text` VALUES ('eng', '_template','login_name_or_email','Login Name or Email','2009-01-09 10:40:36','');
REPLACE INTO `language_text` VALUES ('eng', '_template','login_text','Enter the Login Name (or email) and Password you chose at registration.<br /><br /><br />Not registered yet? <a href=\"register.php\" >Register</a> Or, <a href=\"password_reminder.php\">Forgot your password?</a><br /><br />','2009-01-29 14:24:45','');
REPLACE INTO `language_text` VALUES ('eng', '_template','logout','Logout','2009-01-08 09:31:41','');
REPLACE INTO `language_text` VALUES ('eng', '_template','long_desc','Long Description','2009-03-19 11:38:11','');
REPLACE INTO `language_text` VALUES ('eng', '_template','long_name','Long Name','2009-01-21 12:38:17','');
REPLACE INTO `language_text` VALUES ('eng', '_template','make_decision','Make Decision(s)','2011-01-14 13:49:46','');
REPLACE INTO `language_text` VALUES ('eng', '_template','manual_check','Manual Check Required','2011-02-25 18:20:28','');
REPLACE INTO `language_text` VALUES ('eng', '_template','match_all_words','Match All Words','2009-02-04 11:51:16','');
REPLACE INTO `language_text` VALUES ('eng', '_template','match_any_word','Match Any Word','2009-02-04 11:51:16','');
REPLACE INTO `language_text` VALUES ('eng', '_template','msg_terms','Message Terms','2009-05-05 09:05:33','');
REPLACE INTO `language_text` VALUES ('eng', '_template','myown_updates','My Own Updates','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','my_guidelines','My Guidelines','2009-01-20 11:45:23','');
REPLACE INTO `language_text` VALUES ('eng', '_template','na','N/A','2009-02-23 14:31:55','');
REPLACE INTO `language_text` VALUES ('eng', '_template','name','Name','2009-03-18 14:53:42','');
REPLACE INTO `language_text` VALUES ('eng', '_template','name_in_english','Language name in English','2009-02-20 11:43:44','');
REPLACE INTO `language_text` VALUES ('eng', '_template','name_in_language','Language name translated','2009-02-23 13:28:12','');
REPLACE INTO `language_text` VALUES ('eng', '_template','name_in_translated','Language name translated','2009-02-20 11:43:44','');
REPLACE INTO `language_text` VALUES ('eng', '_template','never','Never','2009-02-05 11:25:19','');
REPLACE INTO `language_text` VALUES ('eng', '_template','new_or_translated','New or Translated Terms','2008-11-27 09:48:36','');
REPLACE INTO `language_text` VALUES ('eng', '_template','new_password','New Password','2009-01-16 10:52:03','');
REPLACE INTO `language_text` VALUES ('eng', '_template','new_terms','New Terms','2008-11-27 09:48:36','');
REPLACE INTO `language_text` VALUES ('eng', '_template','next_chapter','Next Chapter','2009-01-28 15:28:06','');
REPLACE INTO `language_text` VALUES ('eng', '_template','next_checks','Next Checks','2009-03-24 13:47:37','');
REPLACE INTO `language_text` VALUES ('eng', '_template','no','No','2009-01-21 12:38:17','');
REPLACE INTO `language_text` VALUES ('eng', '_template','none_found','None Found.','2009-01-21 15:06:01','');
REPLACE INTO `language_text` VALUES ('eng', '_template','note','Note','2009-03-18 15:20:21','');
REPLACE INTO `language_text` VALUES ('eng', '_template','note_edit_pre_next_checks','Note: \"Prerequisite Checks\" are disabled when creating a new check. Clicking \"Submit\" to save the new check enables these sections.','2011-01-25 15:48:29','');
REPLACE INTO `language_text` VALUES ('eng', '_template','not_installed','Not Installed','2009-06-22 14:49:03','');
REPLACE INTO `language_text` VALUES ('eng', '_template','no_decision','No Decision','2009-02-27 16:07:19','');
REPLACE INTO `language_text` VALUES ('eng', '_template','no_instance','Error: Validation instances are not found.','2008-11-24 14:12:25','');
REPLACE INTO `language_text` VALUES ('eng', '_template','no_results_found','No results found.','2009-01-21 12:38:17','');
REPLACE INTO `language_text` VALUES ('eng', '_template','open_to_public','Open To Public','2009-01-21 12:38:17','');
REPLACE INTO `language_text` VALUES ('eng', '_template','options','Options','2008-11-21 14:25:37','');
REPLACE INTO `language_text` VALUES ('eng', '_template','or','Or','2008-12-02 10:07:17','');
REPLACE INTO `language_text` VALUES ('eng', '_template','overwrite','Overwrite','2009-06-22 14:49:01','');
REPLACE INTO `language_text` VALUES ('eng', '_template','pass','PASS','2009-03-09 12:54:29','');
REPLACE INTO `language_text` VALUES ('eng', '_template','passed_decision','Pass Decision Made','2011-02-25 18:21:01','');
REPLACE INTO `language_text` VALUES ('eng', '_template','password','Password','2009-01-09 10:40:36','');
REPLACE INTO `language_text` VALUES ('eng', '_template','password_again','New Password Again','2009-01-16 10:52:03','');
REPLACE INTO `language_text` VALUES ('eng', '_template','password_blurb','Enter your account\'s email address below and an email with instructions on retrieving your password will be sent to you. The email address must be the same as the one you used for registration.','2009-01-16 13:19:57','');
REPLACE INTO `language_text` VALUES ('eng', '_template','password_changed','Password Changed','2009-02-06 09:08:32','');
REPLACE INTO `language_text` VALUES ('eng', '_template','password_change_confirm','Your password on %s has been changed successfully. Go to %s to login.','2009-01-16 13:17:32','');
REPLACE INTO `language_text` VALUES ('eng', '_template','password_change_msg','Your password has been altered. Please use the information below.','2009-02-06 09:08:31','');
REPLACE INTO `language_text` VALUES ('eng', '_template','password_forgot','Reset Password','2011-01-21 12:38:17','');
REPLACE INTO `language_text` VALUES ('eng', '_template','password_new_blurb','Enter a new password for your account.','2009-01-16 13:55:40','');
REPLACE INTO `language_text` VALUES ('eng', '_template','password_old','Old Password','2009-01-16 10:27:02','');
REPLACE INTO `language_text` VALUES ('eng', '_template','password_reminder','Password Reminder','2009-01-07 16:14:08','');
REPLACE INTO `language_text` VALUES ('eng', '_template','password_request2','Dear %1$s,\r\n\r\nYour login name is %1$s.\r\n\r\nTo set a new password, follow the link below.\r\n\r\n%4$s\r\n\r\n(If this link does not take you to the site, copy and paste it into the address bar of your internet browser)\r\n\r\nThe link will become invalid after %3$s days.','2009-01-16 13:05:25','');
REPLACE INTO `language_text` VALUES ('eng', '_template','pass_example','Pass HTML Example','2009-04-02 11:08:06','');
REPLACE INTO `language_text` VALUES ('eng', '_template','pass_examples','Pass Examples','2009-04-02 13:16:21','');
REPLACE INTO `language_text` VALUES ('eng', '_template','pass_example_desc','Pass Example Description','2009-04-02 11:08:06','');
REPLACE INTO `language_text` VALUES ('eng', '_template','pass_header','Pass?','2011-02-25 17:47:22','');
REPLACE INTO `language_text` VALUES ('eng', '_template','path_not_allowed','Cannot proceed! The listed file path(s) is not allowed:<br />','2011-01-19 11:22:59','');
REPLACE INTO `language_text` VALUES ('eng', '_template','points','points','2010-09-22 00:00:00','');
REPLACE INTO `language_text` VALUES ('eng', '_template','potential','Potential','2008-11-24 13:04:52','');
REPLACE INTO `language_text` VALUES ('eng', '_template','potential_problem','Potential Problem','2009-03-10 15:00:57','');
REPLACE INTO `language_text` VALUES ('eng', '_template','potential_problems','Potential Problems','2008-11-24 14:12:25','');
REPLACE INTO `language_text` VALUES ('eng', '_template','previous_chapter','Previous Chapter','2009-01-28 15:28:06','');
REPLACE INTO `language_text` VALUES ('eng', '_template','pre_checks','Prerequisite Checks','2009-03-20 12:01:45','');
REPLACE INTO `language_text` VALUES ('eng', '_template','print_version','Print Version','2009-01-28 15:28:06','');
REPLACE INTO `language_text` VALUES ('eng', '_template','privileges','Privileges','2009-02-12 14:15:23','');
REPLACE INTO `language_text` VALUES ('eng', '_template','procedure','Procedure','2008-11-24 14:25:44','');
REPLACE INTO `language_text` VALUES ('eng', '_template','profile','Profile','2009-01-15 10:02:55','');
REPLACE INTO `language_text` VALUES ('eng', '_template','published_date','Published Date','2009-01-21 12:38:17','');
REPLACE INTO `language_text` VALUES ('eng', '_template','question','Question','2008-11-24 14:25:44','');
REPLACE INTO `language_text` VALUES ('eng', '_template','rationale','Rationale','2008-11-24 14:25:44','');
REPLACE INTO `language_text` VALUES ('eng', '_template','real_size_example_text','Real size example','2010-09-22 00:00:00','');
REPLACE INTO `language_text` VALUES ('eng', '_template','register','Register','2009-01-08 09:30:56','');
REPLACE INTO `language_text` VALUES ('eng', '_template','registration','Registration','2009-01-08 15:51:23','');
REPLACE INTO `language_text` VALUES ('eng', '_template','relative_directory','Directory is relative directory to AChecker root, for example: docs/images/ or tools/tests/. Leave empty if it is AChecker root directory.','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','remove','Remove','2009-01-23 14:04:46','');
REPLACE INTO `language_text` VALUES ('eng', '_template','remove_write_permission','<span style=\"color:red\">Please <strong>REMOVE</strong> write permission on the listed folders and files for your security:</span><p><strong>Note:</strong> To remove permissions on Unix use <kbd>chmod 755</kbd> then the file name..</p>','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','repair','Repair','2011-02-24 19:31:45','');
REPLACE INTO `language_text` VALUES ('eng', '_template','repair_example','Repair Example','2008-11-24 14:25:44','');
REPLACE INTO `language_text` VALUES ('eng', '_template','replace_file','Replace File','2009-06-22 14:49:02','');
REPLACE INTO `language_text` VALUES ('eng', '_template','report_format','Report Format','2011-02-24 19:30:38','options');
REPLACE INTO `language_text` VALUES ('eng', '_template','report_start','Start Report','2009-05-28 08:59:36','');
REPLACE INTO `language_text` VALUES ('eng', '_template','required_field','Required Field','2009-01-08 15:51:23','');
REPLACE INTO `language_text` VALUES ('eng', '_template','required_field_text','<div class=\"required\" title=\"Required Field\">*</div> indicates required fields.','2009-01-08 15:51:23','');
REPLACE INTO `language_text` VALUES ('eng', '_template','requirement','Requirement','2008-11-24 14:25:44','');
REPLACE INTO `language_text` VALUES ('eng', '_template','reset_filter','Reset Filter','2008-11-27 09:48:36','');
REPLACE INTO `language_text` VALUES ('eng', '_template','result','Result','2008-12-01 14:45:48','');
REPLACE INTO `language_text` VALUES ('eng', '_template','results_found','Results Found: %s','2008-11-27 09:48:36','');
REPLACE INTO `language_text` VALUES ('eng', '_template','return_to_handbook','Return to Handbook','2009-01-28 15:28:06','');
REPLACE INTO `language_text` VALUES ('eng', '_template','reverse_decision','Reverse Decision','2009-03-02 13:22:49','');
REPLACE INTO `language_text` VALUES ('eng', '_template','review_output','Review Output','2008-11-24 14:12:25','');
REPLACE INTO `language_text` VALUES ('eng', '_template','save','Save','2009-01-15 10:01:07','');
REPLACE INTO `language_text` VALUES ('eng', '_template','saved_successfully','Saved Successfully.','2011-02-24 19:37:48','');
REPLACE INTO `language_text` VALUES ('eng', '_template','save_and_close','Save and Close','2009-04-09 11:36:31','');
REPLACE INTO `language_text` VALUES ('eng', '_template','search','Search','2009-01-28 15:28:06','');
REPLACE INTO `language_text` VALUES ('eng', '_template','search_phase','Search Phase','2008-12-01 13:18:57','');
REPLACE INTO `language_text` VALUES ('eng', '_template','search_str','Search String','2009-03-24 13:47:37','');
REPLACE INTO `language_text` VALUES ('eng', '_template','search_term_longer_3_chars','Please enter a search term that is longer than 3 characters.','2009-01-21 12:38:17','');
REPLACE INTO `language_text` VALUES ('eng', '_template','search_text','Search for terms that contains the given string. For example, search for phrase \"desc\" returns all terms that contain string \"desc\".','2011-01-13 14:26:59','');
REPLACE INTO `language_text` VALUES ('eng', '_template','select','Select','2009-02-05 14:16:51','');
REPLACE INTO `language_text` VALUES ('eng', '_template','select_all','select/unselect all','2009-01-23 14:04:46','');
REPLACE INTO `language_text` VALUES ('eng', '_template','select_from_tag_list','Select From Existing HTML Tags','2009-03-18 14:57:04','');
REPLACE INTO `language_text` VALUES ('eng', '_template','sent_via_achecker','Sent via an AChecker system at %s','2009-01-09 14:15:29','');
REPLACE INTO `language_text` VALUES ('eng', '_template','short_desc','Short Description','2009-03-19 11:38:11','');
REPLACE INTO `language_text` VALUES ('eng', '_template','show_contents','Show Contents','2009-01-28 15:28:06','');
REPLACE INTO `language_text` VALUES ('eng', '_template','show_source','Show Source','2009-04-06 14:08:37','');
REPLACE INTO `language_text` VALUES ('eng', '_template','skip_over_ads','Jump past advertisements','2009-05-25 11:29:07','');
REPLACE INTO `language_text` VALUES ('eng', '_template','source','Source','2009-04-06 15:23:53','');
REPLACE INTO `language_text` VALUES ('eng', '_template','source_note','Below is the source input I used for this validation:','2009-04-06 15:23:53','');
REPLACE INTO `language_text` VALUES ('eng', '_template','sql_statement','SQL Statement','2009-06-22 14:49:02','');
REPLACE INTO `language_text` VALUES ('eng', '_template','standard_guidelines','Standard Guidelines','2009-01-20 11:45:22','');
REPLACE INTO `language_text` VALUES ('eng', '_template','status','Status','2009-01-21 12:38:52','');
REPLACE INTO `language_text` VALUES ('eng', '_template','steps_to_check','Steps To Check','2008-11-24 14:25:44','');
REPLACE INTO `language_text` VALUES ('eng', '_template','submit','Submit','2008-12-01 13:18:57','');
REPLACE INTO `language_text` VALUES ('eng', '_template','submit_no','No','2009-01-23 11:25:56','');
REPLACE INTO `language_text` VALUES ('eng', '_template','submit_yes','Yes','2009-01-23 11:25:56','');
REPLACE INTO `language_text` VALUES ('eng', '_template','suggestion','Suggestion','2009-01-13 15:58:15','');
REPLACE INTO `language_text` VALUES ('eng', '_template','suggest_improvements','Suggest improvements on this error message','2008-11-24 14:12:25','');
REPLACE INTO `language_text` VALUES ('eng', '_template','support_by_ontario','This version of AChecker was supported by the Ontario Government\'s Enabling Change Program','2009-05-25 11:02:32','footer');
REPLACE INTO `language_text` VALUES ('eng', '_template','term_type','Term Type','2008-12-01 14:12:35','');
REPLACE INTO `language_text` VALUES ('eng', '_template','test_terms','Test Terms','2008-11-27 09:48:36','');
REPLACE INTO `language_text` VALUES ('eng', '_template','the_follow_errors_occurred','The following errors occurred:','2008-12-15 09:25:06','');
REPLACE INTO `language_text` VALUES ('eng', '_template','title','Title','2009-01-20 11:45:23','');
REPLACE INTO `language_text` VALUES ('eng', '_template','translated_context','Translated Context','2008-12-01 13:18:57','');
REPLACE INTO `language_text` VALUES ('eng', '_template','translated_terms','Translated Terms','2008-11-27 09:48:36','');
REPLACE INTO `language_text` VALUES ('eng', '_template','translated_text','Translated Text','2008-12-01 13:18:57','');
REPLACE INTO `language_text` VALUES ('eng', '_template','translate_to','Translate to','2008-12-01 13:18:57','');
REPLACE INTO `language_text` VALUES ('eng', '_template','translation','Translation','2009-02-18 11:01:39','');
REPLACE INTO `language_text` VALUES ('eng', '_template','translator','Translator','2009-01-07 15:05:34','');
REPLACE INTO `language_text` VALUES ('eng', '_template','unconfirmed','Unconfirmed','2011-01-21 18:02:20','admin create user');
REPLACE INTO `language_text` VALUES ('eng', '_template','updated_terms','Updated Terms','2008-12-02 09:16:45','');
REPLACE INTO `language_text` VALUES ('eng', '_template','updater','Updater','2009-06-22 14:49:01','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','updater_alter_modified_files','The listed files have been modified locally. If you choose to proceed, your local file will be modified. The original\r\nfile will be backup before the modification. Please note that the modification on your customized code may break your customization.<br>','2011-01-19 20:44:43','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','updater_overwrite_modified_files','The listed files have been modified locally. If you choose to proceed, the update file will be copied to your local machine. \nYou have to manually merge this file and your local copy.<br>','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','updater_show_backup_files','Below is the list of the backup files created by update installation. After ensuring AChecker works properly with the update, you may want to delete these files. If AChecker does not work properly with the update, you can always revert back to the old files by renaming the backup files \nto the original file names,  removing the [update_id].old portion of the file name. <br>','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','updater_show_update_files','Below is the list of the update files copied to your computer. \nPlease manually merge the change between the update files and your local copy. <br>','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','updates','Updates','2009-06-22 14:49:01','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','update_dependent_update_not_installed','<br><span style=\"color: red\">Warning: There are update dependencies, please install the listed updates first: </span>','2009-06-22 14:49:03','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','update_local_file_not_exist','Cannot proceed. The listed files are not exist in your local machine. If you renamed them to your copy, in order to proceed, please rename back.<br>','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','upload','Upload','2009-06-22 14:49:01','');
REPLACE INTO `language_text` VALUES ('eng', '_template','upload_file','Upload File','2009-06-22 14:49:01','');
REPLACE INTO `language_text` VALUES ('eng', '_template','upload_update','Upload a zip file to install update:','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','URL','Address','2011-01-28 13:46:07','');
REPLACE INTO `language_text` VALUES ('eng', '_template','user','User','2009-02-27 16:07:19','');
REPLACE INTO `language_text` VALUES ('eng', '_template','users','Users','2009-04-14 10:41:51','');
REPLACE INTO `language_text` VALUES ('eng', '_template','user_group','User Group','2009-02-04 11:51:16','');
REPLACE INTO `language_text` VALUES ('eng', '_template','user_status','User Status','2009-02-04 11:51:16','');
REPLACE INTO `language_text` VALUES ('eng', '_template','valid_icons','Conformance Seal(s) for your Web page','2009-06-03 10:38:36','');
REPLACE INTO `language_text` VALUES ('eng', '_template','valid_icons_text','To show your readers that you have taken the care to create a web page that conforms to accessibility guidelines, you may display this(these) conformance seal(s) on the page that validates. Below is the HTML you could use to add the seal(s) to your web page. You may copy the seal image to your local Web site, and adjust the path to the image accordingly:','2009-06-03 10:37:58','');
REPLACE INTO `language_text` VALUES ('eng', '_template','version_not_match','This update is for AChecker version %s. Does not match with your current AChecker version. The installation of it may break AChecker. Are you sure you want to proceed?','2009-06-22 14:49:02','Updater');
REPLACE INTO `language_text` VALUES ('eng', '_template','view','View','2009-01-20 11:47:15','');
REPLACE INTO `language_text` VALUES ('eng', '_template','view_by_guideline','View by Guideline','2011-02-24 19:31:01','');
REPLACE INTO `language_text` VALUES ('eng', '_template','view_by_line','View by Line Number','2011-02-24 19:31:23','');
REPLACE INTO `language_text` VALUES ('eng', '_template','view_guideline','View Guideline','2009-01-20 13:59:15','');
REPLACE INTO `language_text` VALUES ('eng', '_template','view_message','View Message','2009-06-22 14:49:01','');
REPLACE INTO `language_text` VALUES ('eng', '_template','warning','Warning: Confirmation Required','2011-02-25 18:21:34','');
REPLACE INTO `language_text` VALUES ('eng', '_template','web_accessibility_checker','Web Accessibility Checker','2008-12-01 13:19:43','');
REPLACE INTO `language_text` VALUES ('eng', '_template','web_service_api','Web Service API','2009-03-13 11:56:12','');
REPLACE INTO `language_text` VALUES ('eng', '_template','web_service_id','Web Service ID','2009-03-04 13:48:23','');
REPLACE INTO `language_text` VALUES ('eng', '_template','web_site','Web Site','2009-02-06 09:08:32','');
REPLACE INTO `language_text` VALUES ('eng', '_template','welcome','Welcome','2009-01-08 09:30:56','');
REPLACE INTO `language_text` VALUES ('eng', '_template','yes','Yes','2009-01-21 12:38:17','');
REPLACE INTO `language_text` VALUES ('eng', '_template','yyyy-mm-dd','yyyy-mm-dd','2009-01-21 15:06:01','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_100_0','<code>blockquote</code> does not have <code>cite</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_100_1','<code>blockquote</code> has <code>cite</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_102_0','Contains an element that has an <code>onclick</code> attribute without an <code>onkeypress</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_102_1','Contains an element that has an <code>onclick</code> attribute and an <code>onkeypress</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_103_0','Contains an element that has an <code>ondblclick</code> attribute without keyboard equivalents.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_103_1','Contains an element that has an <code>ondblclick</code> attribute with keyboard equivalents.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_104_0','Contains an element that has an <code>onmousedown</code> attribute without an <code>onkeydown</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_104_1','Contains an element that has an <code>onmousedown</code> attribute and an <code>onkeydown</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_105_0','Contains an element that has an <code>onmousemove</code> attribute without keyboard equivalents.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_105_1','Contains an element that has an <code>onmousemove</code> attribute with keyboard equivalents.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_106_0','Contains an element that has an <code>onmouseout</code> attribute without an <code>onblur</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_106_1','Contains an element that has an <code>onmouseout</code> attribute and an <code>onblur</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_107_0','Contains an element that has an <code>onmouseover</code> attribute without an <code>onfocus</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_107_1','Contains an element that has an <code>onmouseover</code> attribute and an <code>onfocus</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_108_0','Contains an element that has an <code>onmouseup</code> attribute without an <code>onkeyup</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_108_1','Contains an element that has an <code>onmouseup</code> attribute and an <code>onkeyup</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_109_0','Contains an element that has a <code>style</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_109_1','Contains no elements with <code>style</code> attributes.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_10_0','Image flickers.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_10_1','Image does not flicker.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_110_0','Document contains words outside the primary language.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_110_1','Document contains words outside the primary language but they are marked as such.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_111_0','Complex data table without a <code>summary</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_111_1','Complex data table with a <code>summary</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_111_2','Simple data table does not require a summary.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_112_0','Data <code>table</code> with an empty <code>summary</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_112_1','Data <code>table</code> with a valid <code>summary</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_113_0','Data <code>table</code> with short <code>summary</code> (less than 10 characters).','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_113_1','Data <code>table</code> with valid <code>summary</code> (greater than 10 characters).','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_114_0','Layout <code>table</code> with <code>summary</code> text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_114_1','Layout <code>table</code> with empty <code>summary</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_114_2','Layout <code>table</code> with no <code>summary</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_115_0','Layout table with <code>caption</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_115_1','Layout table without <code>caption</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_116_0','<code>b</code> element used.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_116_1','No <code>b</code> elements used.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_117_0','<code>i</code> (italic) element used.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_117_1','No <code>i</code> (italic) elements used.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_118_0','<code>input</code> element does not have associated label.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_118_1','<code>input</code> element has an associated label using <code>label</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_118_2','<code>input</code> has associated label using <code>title</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_118_3','<code>input</code> has associated label using <code>label</code> element containing <code>input</code>element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_119_0','<code>input</code> element, <code>type</code> of \"checkbox\", does not have associated label.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_119_1','<code>input</code> element has an associated label using <code>label</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_119_2','<code>input</code> element has an associated label using <code>title</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_119_3','<code>input</code> has associated label using <code>label</code> element containing <code>input</code>element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_11_0','Alt text does not contain all text in image.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_11_1','Alt text has all text within image.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_120_0','<code>input</code> element does not have associated label.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_120_1','<code>input</code> element has an associated label using <code>label</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_120_2','<code>input</code> element has an associated label using <code>title</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_120_3','<code>input</code> has associated label using <code>label</code> element containing <code>input</code>element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_121_0','<code>input</code> element does not have associated label.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_121_1','<code>input</code> element has an associated label using <code>label</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_121_2','<code>input</code> element has an associated label using <code>title</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_121_3','<code>input</code> has associated label using <code>label</code> element containing <code>input</code>element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_122_0','Label is not close to password control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_122_1','Label is close to password control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_123_0','Label is not close to checkbox control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_123_1','Label is close to checkbox control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_124_0','Label is not close to file control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_124_1','Label is close to file control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_125_0','Label is not close to radio button control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_125_1','Label is close to radio button control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_126_0','<code>input</code> element does not have default text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_126_1','<code>input</code> element with default text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_127_0','Contains an <code>object</code> element with a valid CLASS<code>id</code> attribute and contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_127_1','Contains an <code>object</code> element with a valid CLASS<code>id</code> attribute but contains no text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_128_0','Contains an <code>object</code> element with a valid CLASS<code>id</code> attribute and contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_128_1','Contains an <code>object</code> element with a valid CLASS<code>id</code> attribute but contains no text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_129_0','Contains an <code>object</code> element with a valid CLASS<code>id</code> attribute and contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_129_1','Contains an <code>object</code> element with a valid CLASS<code>id</code> attribute but contains no text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_12_0','<code>img</code> element contains an <code>ismap</code> attribute but no <code>usemap</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_12_1','<code>img</code> element contains both ISMAP and <code>usemap</code> attributes.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_131_0','Body contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_131_1','Body does not contain text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_132_0','Image contains <code>ismap</code> attribute without duplicate text links.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_132_1','Image contains <code>ismap</code> attribute with duplicate text links.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_133_0','layout <code>table</code> does not make sense when linearized.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_133_1','Layout <code>table</code> makes sense when linearized.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_134_0','Adjacent links that do not contain separator characters.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_134_1','Adjacent links with separator characters.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_135_0','Image contains math but document has no MathML.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_135_1','Image contains math and document has MathML.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_136_0','Data <code>table</code> without <code>th</code> elements.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_136_1','Data <code>table</code> with <code>th</code> elements.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_137_0','Layout <code>table</code> with <code>th</code> elements.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_137_1','Layout <code>table</code> without <code>th</code> elements.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_138_0','Text <code>input</code> element does not have <code>tabindex</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_138_1','Text <code>input</code> element has <code>tabindex</code> attribute but it is empty.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_138_2','Text <code>input</code> element has valid <code>tabindex</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_139_0','Radio <code>input</code> element does not have <code>tabindex</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_139_1','Radio <code>input</code> element has <code>tabindex</code> attribute but it is empty.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_139_2','Radio <code>input</code> element has valid <code>tabindex</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_13_0','<code>img</code> element has <code>usemap</code> but is missing all text links.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_13_1','<code>img</code> element has <code>usemap</code> but is missing one text link.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_13_2','<code>img</code> element has <code>usemap</code> and equivalent text links.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_140_0','Password <code>input</code> element does not have <code>tabindex</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_140_1','Password <code>input</code> element has <code>tabindex</code> attribute but it is empty.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_140_2','Password <code>input</code> element has valid <code>tabindex</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_141_0','Checkbox <code>input</code> element does not have <code>tabindex</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_141_1','Checkbox <code>input</code> element has <code>tabindex</code> attribute but it is empty.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_141_2','Checkbox <code>input</code> element has valid <code>tabindex</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_142_0','File <code>input</code> element does not have <code>tabindex</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_142_1','File <code>input</code> element has <code>tabindex</code> attribute but it is empty.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_142_2','File <code>input</code> element has valid <code>tabindex</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_143_0','Content does not have <code>address</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_143_1','Content contains <code>address</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_145_0','Link to multimedia file (.wmv) without a text alternative.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_145_1','Link to multimedia file also has link to text alternative.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_145_2','Link to multimedia file (.mpg) without a text alternative.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_145_3','Link to multimedia file (.mov) without a text alternative.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_145_4','Link to multimedia file (.ram) without a text alternative.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_145_5','Link to multimedia file (.aif) without a text alternative.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_146_0','Object with <code>type</code> of \"video\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_146_1','Object does not have <code>type</code> of \"video\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_147_0','Does not have a <code>link</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_147_1','Has a <code>link</code> element with a <code>rel</code> attribute value of \"index\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_147_2','Has a <code>link</code> element with a <code>rel</code> attribute value of \"stylesheet\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_147_3','Has a <code>link</code> element with a <code>rel</code> attribute value of \"alternate\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_148_0','Does not have a <code>link</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_148_1','Has a <code>link</code> element with a <code>rel</code> attribute value of \"stylesheet\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_14_0','Image is referenced by color alone.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_14_1','Image is not referenced within document text by color alone.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_14_2','Image is not referenced within alt text by color alone.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_151_0','Data <code>table</code> without a <code>caption</code> is not identified within the document.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_151_1','Data <code>table</code> with a <code>caption</code> that describes the nature of the table.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_151_2','Data <code>table</code> without a <code>caption</code> but is identified within the document.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_152_0','<code>table</code> headers are long.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_152_1','<code>table</code> headers are short.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_152_2','<code>table</code> headers are long but contains an <code>abbr</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_153_0','Header abbreviations are long.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_153_1','Header abbreviations are short.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_154_0','<code>pre</code> used.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_154_1','<code>pre</code> not used.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_159_0','IMG has a <code>title</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_159_1','IMG does not have a <code>title</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_15_0','Alt text for an image used as a link does not identify the destination of the link.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_15_1','Alt text for an image used as a link identifies the destination of the link.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_160_0','Document contains an <code>object</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_160_1','Document does not contain an <code>object</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_163_0','<code>embed</code> missing <code>noembed</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_163_1','<code>embed</code> contains a <code>noembed</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_163_2','<code>embed</code> has <code>noembed</code> element immediately following.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_164_0','<code>noembed</code> element present.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_164_1','<code>noembed</code> element not present.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_165_0','<code>embed</code> missing <code>alt</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_165_1','<code>embed</code> with <code>alt</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_166_0','<code>embed</code> with empty <code>alt</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_166_1','<code>embed</code> with valid <code>alt</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_167_0','<code>iframe</code> with a <code>longdesc</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_167_1','<code>iframe</code> without a <code>longdesc</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_168_0','radio button group contains no <code>fieldset</code> or <code>legend</code> elements.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_168_1','radio button group contains both <code>fieldset</code> and <code>legend</code> elements.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_169_0','<code>option</code>s without <code>optgroup</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_169_1','<code>option</code>s with <code>optgroup</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_16_0','Image is decorative and Alt text is not an empty string (\"\").','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_16_1','Image is decorative and Alt text is an empty string (\"\").','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_16_2','Image within link is decorative but Alt text is not an empty string (\"\").','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_16_3','Image within link is decorative and Alt text is an empty string (\"\").','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_173_0','Anchor with \"click here\" text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_173_1','Anchor with \"more\" text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_173_2','Anchor with non placeholder text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_174_0','Anchor has no text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_174_1','Anchor with text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_174_2','Anchor with image that has text in <code>alt</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_175_0','Anchor contains image with Alt text same as link text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_175_1','Anchor contains image with Alt text different from link text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_176_0','Contains a <code>basefont</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_176_1','Does not contain a <code>basefont</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_177_0','Contains a <code>font</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_177_1','Does not contain a <code>font</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_178_0','Alt text does not convey same information as image.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_178_1','Alt text conveys same information as image.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_179_0','Glossary document is required but not referenced.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_179_1','Glossary document is required and is referenced.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_17_0','Link to sound file (.wav) but no link to text transcript.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_17_1','Link to sound file (.snd) but no link to text transcript.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_17_10','Link to sound file (.aif) but no link to text transcript.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_17_11','No link to sound file.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_17_2','Link to sound file (.mp3) but no link to text transcript.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_17_3','Link to sound file (.iff) but no link to text transcript.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_17_4','Link to sound file (.svx) but no link to text transcript.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_17_5','Link to sound file (.sam) but no link to text transcript.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_17_6','Link to sound file (.smp) but no link to text transcript.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_17_7','Link to sound file (.vce) but no link to text transcript.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_17_8','Link to sound file (.vox) but no link to text transcript.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_17_9','Link to sound file (.pcm) but no link to text transcript.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_180_0','Two sequential Anchor elements that have the same target.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_180_1','Two sequential Anchor elements that have different targets.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_181_0','Anchor uses the Javascript URL protocol.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_181_1','Anchor does not use the Javascript URL protocol.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_182_0','<code>body</code> contains a <code>background</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_182_1','<code>body</code> does not contain a <code>background</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_183_0','<code>object</code> does not contain an <code>embed</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_183_1','<code>object</code> contains an <code>embed</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_184_0','Document is part of a collection but there is not site map.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_184_1','Document is part of a collection that has a site map.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_185_0','<code>id</code> attribute values are not unique.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_185_1','<code>id</code> attribute values are unique.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_186_0','<code>label</code> contains an <code>input</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_186_1','<code>label</code> does not contain an <code>input</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_187_0','<code>input</code> has 2 associated <code>labels</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_187_1','<code>input</code> has only 1 associated label.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_188_0','<code>label</code> is empty.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_188_1','<code>label</code> contains one printable character.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_188_2','<code>label</code> contains only whitespace.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_189_0','<code>label</code> does not describe its associated <code>input</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_189_1','<code>label</code> does describe its associated <code>input</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_18_0','<code>a</code> (anchor) element has target of \"_new\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_18_1','<code>a</code> (anchor) element has target of \"_self\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_18_2','<code>a</code> (anchor) element has target of \"_top\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_18_3','<code>a</code> (anchor) element has target of \"_parent\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_190_0','<code>a</code> (anchor) element does not have a <code>title</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_190_1','<code>a</code> (anchor) element does have a <code>title</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_191_0','<code>title</code> attribute value on source anchor does not describe the link destination.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_191_1','<code>title</code> attribute value on source anchor describes the link destination.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_192_0','Alt text uses the word \"submit\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_192_1','Alt text does not use the word \"submit\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_193_0','Alt text does not contain all text in image and text is not decorative.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_193_1','Alt text has all text within image.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_194_0','Alt text does not contain all non decorative text in image.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_194_1','Alt text has all text within image.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_195_0','Link text begins with \"link to\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_195_1','Link text does not begin with \"link to\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_195_2','Alt text for image used as link begins with \"link to\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_195_3','Alt text for image used as link does not begin with \"link to\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_196_0','Server-side image map uses available geometric shapes.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_196_1','Server-side image map does not use available geometric shapes.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_197_0','link text does not identify the link destination.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_197_1','link text identifies the link destination','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_197_2','link text identifying the link destination is in Alt text','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_197_3','link text identifying the link destination is in <code>title</code> attribute','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_197_4','link text (in alt attribute) does not identify the link destination.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_198_0','<code>legend</code> does not describe the group of choices.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_198_1','<code>legend</code> text describes the group of choices.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_199_0','<code>legend</code> text is empty.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_199_1','<code>legend</code> text is not empty.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_19_0','Link text is not meaningful when read out of context.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_19_1','Link text is meaningful when read out of context.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_1_0','<code>img</code> element without an <code>alt</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_1_1','<code>img</code> element with an <code>alt</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_200_0','<code>legend</code> text is placeholder text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_200_1','<code>legend</code> text describes the group of choices.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_201_0','<code>frame</code> <code>title</code> is empty.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_201_1','<code>frame</code> <code>title</code> is not empty.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_202_0','<code>frame</code> <code>title</code> is placeholder text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_202_1','<code>frame</code> <code>title</code> is not placeholder text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_203_0','Data <code>table</code> <code>summary</code> does not describe navigation and structure of the table.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_203_1','Data <code>table</code> <code>summary</code> describes navigation and structure of the table.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_204_0','Label using <code>for</code> and <code>id</code> does not contain text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_204_1','Label using <code>for</code> and <code>id</code> contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_204_2','Label using <code>title</code> attribute does not contain text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_204_3','Label using <code>title</code> attribute contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_204_4','Label containing <code>input</code> does not contain text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_204_5','Label containing <code>input</code> contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_205_0','Label using <code>for</code> and <code>id</code> does not describe control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_205_1','Label using <code>for</code> and <code>id</code> describes control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_205_2','Label using <code>title</code> attribute does not describe control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_205_3','Label using <code>title</code> attribute describes control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_205_4','Label containing <code>input</code> does not describe control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_205_5','Label containing <code>input</code> describes control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_206_0','Label using <code>for</code> and <code>id</code> does not contain text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_206_1','Label using <code>for</code> and <code>id</code> contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_206_2','Label using <code>title</code> attribute does not contain text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_206_3','Label using <code>title</code> attribute contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_206_4','Label containing <code>input</code> does not contain text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_206_5','Label containing <code>input</code> contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_207_0','Label using <code>for</code> and <code>id</code> does not contain text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_207_1','Label using <code>for</code> and <code>id</code> contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_207_2','Label using <code>title</code> attribute does not contain text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_207_3','Label using <code>title</code> attribute contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_207_4','Label containing <code>input</code> does not contain text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_207_5','Label containing <code>input</code> contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_208_0','associated <code>label</code> is empty.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_208_1','associated <code>label</code> contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_208_2','associated <code>label</code> contains only whitespace.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_208_3','<code>title</code> is empty.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_208_4','<code>title</code> contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_208_5','<code>title</code> contains only whitespace.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_208_6','<code>label</code> containing <code>input</code> is empty.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_208_7','<code>label</code> containing <code>input</code> contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_208_8','<code>label</code> containing <code>input</code> has only whitespace.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_209_0','<code>label</code> is not positioned close to control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_209_1','<code>label</code> is positioned close to control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_20_0','Link to multimedia file (.wav) without a text transcript.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_20_1','No link to multimedia file','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_20_2','Link to multimedia file (.mpg) without a text transcript.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_20_3','Link to multimedia file (.mov) without a text transcript.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_20_4','Link to multimedia file (.ram) without a text transcript.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_20_5','Link to multimedia file (.aif) without a text transcript.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_211_0','Labels are positioned far from controls.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_211_1','Labels are positioned close to controls.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_212_0','Label using <code>for</code> and <code>id</code> does not contain text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_212_1','Label using <code>for</code> and <code>id</code> contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_212_2','Label using <code>title</code> attribute does not contain text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_212_3','Label using <code>title</code> attribute contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_212_4','<code>label</code> containing <code>textarea</code> element does not contain text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_212_5','<code>label</code> containing <code>textarea</code> element contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_213_0','Label using <code>for</code> and <code>id</code> attributes does not contain text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_213_1','Label using <code>for</code> and <code>id</code> attributes contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_213_2','Label using <code>title</code> attribute does not contain text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_213_3','Label using <code>title</code> attribute contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_213_4','Label containing <code>input</code> does not contain text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_213_5','Label containing <code>input</code> contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_213_6','Label using <code>for</code> and <code>id</code> attributes contains an image with alt text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_214_0','Label using <code>for</code> and <code>id</code> does not describe control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_214_1','Label using <code>for</code> and <code>id</code> describes control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_214_2','Label using <code>title</code> attribute does not describe control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_214_3','Label using <code>title</code> attribute describes control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_214_4','Label containing <code>textarea</code> does not describe control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_214_5','Label containing <code>textarea</code> describes control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_216_0','Label using <code>for</code> and <code>id</code> does not contain text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_216_1','Label using <code>for</code> and <code>id</code> contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_216_2','Label using <code>title</code> attribute does not contain text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_216_3','Label using <code>title</code> attribute contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_216_4','Label containing <code>input</code> does not contain text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_216_5','Label containing <code>input</code> contains text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_217_0','Label using <code>for</code> and <code>id</code> does not describe control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_217_1','Label using <code>for</code> and <code>id</code> describes control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_217_2','Label using <code>title</code> attribute does not describe control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_217_3','Label using <code>title</code> attribute describes control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_217_4','Label containing <code>input</code> does not describe control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_217_5','Label containing <code>input</code> describes control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_218_0','Label using <code>for</code> and <code>id</code> does not describe control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_218_1','Label using <code>for</code> and <code>id</code> describes control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_218_2','Label using <code>title</code> attribute does not describe control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_218_3','Label using <code>title</code> attribute describes control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_218_4','Label containing <code>input</code> does not describe control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_218_5','Label containing <code>input</code> describes control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_219_0','Label using <code>for</code> and <code>id</code> does not describe control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_219_1','Label using <code>for</code> and <code>id</code> describes control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_219_2','Label using <code>title</code> attribute does not describe control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_219_3','Label using <code>title</code> attribute describes control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_219_4','Label containing <code>input</code> does not describe control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_219_5','Label containing <code>input</code> describes control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_21_0','Contains an <code>applet</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_21_1','Does not have an <code>applet</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_220_0','Label using <code>for</code> and <code>id</code> does not describe control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_220_1','Label using <code>for</code> and <code>id</code> describes control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_220_2','Label using <code>title</code> attribute does not describe control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_220_3','Label using <code>title</code> attribute describes control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_220_4','Label containing <code>input</code> does not describe control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_220_5','Label containing <code>input</code> describes control.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_221_0','The luminosity contrast ratio between text and background color is less than 5:1.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_221_1','The luminosity contrast ratio between text and background color is greater than 5:1.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_221_2','The text and background colors are not specified.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_222_0','The luminosity contrast ratio between link and background color is less than 5:1.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_222_1','The luminosity contrast ratio between link and background color is greater than 5:1.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_222_2','The link and background colors are not specified.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_223_0','The luminosity contrast ratio between active link and background color is less than 5:1.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_223_1','The luminosity contrast ratio between active link and background color is greater than 5:1.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_223_2','The active link and background colors are not specified.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_224_0','The luminosity contrast ratio between visited link and background color is less than 5:1.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_224_1','The luminosity contrast ratio between visited link and background color is greater than 5:1.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_224_2','The visited link and background colors are not specified.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_225_0','The document does not contain a DTD.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_225_1','The document contains an HTML 4.01 strict DTD.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_225_2','The document contains an XHTML 1.0 strict DTD.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_225_3','The document contains an HTML transitional DTD.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_225_4','The document contains an HTML frameset DTD.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_226_0','The background color and the text color do not surpass the WAI ERT color algorithm threshold.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_226_1','The background color and the text color surpass the WAI ERT color algorithm threshold.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_226_2','The text and background colors are not specified.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_227_0','The background color and the link color do not surpass the WAI ERT color algorithm threshold.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_227_1','The background color and the link color surpass the WAI ERT color algorithm threshold.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_227_2','The link and background colors are not specified.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_228_0','The background color and the alink color do not surpass the WAI ERT color algorithm threshold.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_228_1','The background color and the alink color surpass the WAI ERT color algorithm threshold.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_228_2','The alink and background colors are not specified.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_229_0','The background color and the vlink color do not surpass the WAI ERT color algorithm threshold.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_229_1','The background color and the vlink color surpass the WAI ERT color algorithm threshold.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_229_2','The vlink and background colors are not specified.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_22_0','<code>applet</code> flickers.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_22_1','<code>applet</code> does not flicker.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_230_0','Data table does not contain any markup to group repeated header markup.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_230_1','Data table contains markup to group repeated header markup.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_231_0','Data table does not contain any markup to group column structures.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_231_1','Data table contains markup to group column structures.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_232_0','The document does not validate to declared specification - \'strict\' doctype does not allow <code>target</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_232_1','The document validates to declared specification.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_233_0','Contains a <code>frameset</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_233_1','Does not have a <code>frameset</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_234_0','Contains a <code>frame</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_234_1','Does not have a <code>frame</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_235_0','Primary document text reads left to right and contains a section that reads right to left but is unmarked.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_235_1','Primary document text reads left to right and contains a section that reads right to left that is unmarked.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_236_0','Adjacent text and image links with the same destination and duplicate text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_236_1','Text and image are combined into one link.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_236_2','Adjacent text and image links with the same destination and null alt text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_237_0','The two forms produce different results but the submit button labels are the same.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_237_1','The two forms produce different results and the submit button labels are different.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_238_0','<code>input</code> element with type of \"submit\" has an <code>alt</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_238_1','<code>input</code> element with type of \"submit\" does not have an <code>alt</code> attribute','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_238_2','<code>input</code> element with type of \"image\" has an <code>alt</code> attribute','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_239_0','Image is decorative and <code>title</code> attribute is not an empty string (\"\").','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_239_1','Image is decorative and <code>title</code> attribute is an empty string (\"\").','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_239_2','Image is decorative and <code>title</code> attribute is absent.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_23_0','Contains an <code>applet</code> element with empty Alt text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_23_1','Contains an <code>applet</code> element without <code>alt</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_23_2','<code>applet</code> has alt text that is equivalent to the <code>applet</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_240_0','Text alternative file does not tell the same story and present the same information as the multimedia file.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_240_1','Text alternative file tells the same story and presents the same information as the multimedia file.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_241_0','Table markup is not used for tabular information.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_241_1','Table markup is used for tabular information.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_242_0','<code>caption</code> does not identify the <code>table</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_242_1','<code>caption</code> identifies the <code>table</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_243_0','The table summary is the same as the table caption.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_243_1','The table summary and caption are different.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_244_0','Data table with both row and column headers does not contain <code>scope</code> attributes.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_244_1','Data table with both row and column headers contains <code>scope</code> attributes.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_245_0','Data table with multiple rows of column headers does not contain <code>id</code> or <code>headers</code> attributes.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_245_1','Data table with multiple rows of column headers contains <code>id</code> and <code>headers</code> attributes.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_246_0','Required fields (first name and last name) are not marked as \"required\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_246_1','Required fields (first name and last name) are marked as \"required\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_247_0','Checkbox group contains no <code>fieldset</code> or <code>legend</code> elements.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_247_1','Checkbox group contains both <code>fieldset</code> and <code>legend</code> elements.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_248_0','Visual list does not contain proper markup.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_248_1','Visual list contains proper markup.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_248_2','List within sentence does not require markup.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_249_0','Semantic markup not used for emphasized and special text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_249_1','Semantic markup is used for emphasized and special text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_24_0','Contains an <code>applet</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_24_1','Does not have an <code>applet</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_250_0','Submit button is referenced by shape alone.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_250_1','Submit button is referenced by both shape and text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_251_0','The luminosity contrast ratio between text and background color is less than 5:1.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_251_1','The luminosity contrast ratio between text and background color is greater than 5:1.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_252_0','The text color and background color are set but other colors are not set.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_252_1','All text colors are set.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_252_2','No text colors are set.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_253_0','The luminosity contrast ratio between text and background color is less than 10:1.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_253_1','The luminosity contrast ratio between text and background color is greater than 10:1.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_254_0','The luminosity contrast ratio between text and background color is less than 10:1.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_254_1','The luminosity contrast ratio between text and background color is greater than 10:1.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_254_2','The text and background colors are not specified.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_255_0','The luminosity contrast ratio between link and background color is less than 10:1.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_255_1','The luminosity contrast ratio between link and background color is greater than 10:1.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_255_2','The link and background colors are not specified.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_256_0','The luminosity contrast ratio between active link and background color is less than 10:1.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_256_1','The luminosity contrast ratio between active link and background color is greater than 10:1.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_256_2','The active link and background colors are not specified.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_257_0','The luminosity contrast ratio between visited link and background color is less than 10:1.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_257_1','The luminosity contrast ratio between visited link and background color is greater than 10:1.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_257_2','The visited link and background colors are not specified.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_258_0','<code>applet</code> does not have a keyboard mechanism that returns focus to the parent window.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_258_1','<code>applet</code> has a keyboard mechanism that returns focus to the parent window.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_259_0','<code>object</code> does not have a keyboard mechanism that returns focus to the parent window.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_259_1','<code>object</code> has a keyboard mechanism that returns focus to the parent window.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_25_0','<code>applet</code> element does not contain a text equivalent.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_25_1','<code>applet</code> element contains a text equivalent.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_260_0','<code>embed</code> does not have a keyboard mechanism that returns focus to the parent window.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_260_1','<code>embed</code> has a keyboard mechanism that returns focus to the parent window.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_261_0','Sections are not marked with headers.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_261_1','Sections are marked with headers.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_262_0','Groups of related links are not marked.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_262_1','Groups of related links are marked.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_263_0','Different types of content appear in the same frame.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_263_1','Similar types of content appear in the same frame.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_264_0','Submit <code>input</code> element does not have <code>tabindex</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_264_1','Submit <code>input</code> element has <code>tabindex</code> attribute but it is empty.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_264_2','Submit <code>input</code> element has valid <code>tabindex</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_265_0','Tab order is not logical.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_265_1','Tab order is logical.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_266_0','Document does not contain a breadcrumb trail.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_266_1','Document contains a breadcrumb trail.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_267_0','Form submission error message does not identify required fields.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_267_1','Form submission error message identifies required fields.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_268_0','Form submission error message does not provide assistance.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_268_1','Form submission error message provides assistance.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_269_0','Form submission proces does not allow user to correct data before final acceptance.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_269_1','Form submission process allows user to correct data before final acceptance.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_26_0','Contains an <code>applet</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_26_1','Does not have an <code>applet</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_270_0','Unicode right-to-left marking is missing from text and HTML bidirectional algorithm produces undesirable results.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_270_1','Unicode right-to-left marking is present and HTML bidirectional algorithm produces desirable results.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_271_0','Block of text with a reading order different from the primary language is not marked using the <code>dir</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_271_1','Block of text with a reading order different from the primary language is marked using the <code>dir</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_272_0','Form allows user to delete information without allowing recovery.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_272_1','Form allows user to delete information and provides a method of recovery.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_273_0','Document\'s primary reading order is right to left but <code>dir</code> attribute is not set.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_273_1','Document\'s primary reading order is right to left and <code>dir</code> attribute is set.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_273_2','Document\'s primary reading order is left to right so <code>dir</code> attribute not required.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_273_3','Document\'s primary reading order is left to right but <code>dir</code> attribute is set to \"rtl\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_274_0','Window changes when user selects option.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_274_1','Window change occurs only after user selects form submit button.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_274_2','Window changes when user selects option but warning is provided.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_274_3','Form is submitted after focus leaves text entry field but user is warned.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_274_4','Form is submitted after focus leaves text entry field but user is warned.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_274_5','New window opens when user selects a radio button.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_274_6','User is warned about new window opening when radio button is selected.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_275_0','Opens a new page when loaded.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_275_1','Does not open a new page when loaded.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_276_0','Links appear in the same order as the other page.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_276_1','Links appear in the same order as the other page.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_276_2','Links do not appear in the same order as the other page.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_27_0','Contains a <code>blink</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_27_1','Does not have a <code>blink</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_28_0','Does not have a \"skip to content\" link.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_28_1','Has a \"skip to content\" link.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_29_0','Does not have a doctype declaration.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_29_1','Does have a doctype declaration.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_2_0','Alt text is the same as <code>src</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_2_1','Alt text is different from <code>src</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_30_0','<code>object</code> flickers.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_30_1','<code>object</code> does not flicker.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_31_0','<code>frame</code> has no <code>title</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_31_1','<code>frame</code> has a <code>title</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_32_0','<code>frame</code> <code>title</code> does not describe the purpose or function of the <code>frame</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_32_1','<code>frame</code> <code>title</code> describes the purpose or function of the <code>frame</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_33_0','<code>frame</code> content not accessible - just image','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_33_1','<code>frame</code> content accessible - image within HTML page','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_34_0','<code>frameset</code> has 4 frames and no <code>longdesc</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_34_1','<code>frameset</code> has 4 frames and a <code>longdesc</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_35_0','FRAMESET missing NOFRAMES section.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_35_1','FRAMESET has NOFRAMES section.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_36_0','NOFRAMES section is equivalent to FRAMES section.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_36_1','NOFRAMES section is equivalent to FRAMES section.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_37_0','<code>h3</code> follows an <code>h1</code>','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_37_1','<code>h2</code> follows an <code>h1</code>','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_38_0','<code>h4</code> follows an <code>h2</code>','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_38_1','<code>h3</code> follows an <code>h2</code>','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_39_0','<code>h5</code> follows an <code>h3</code>','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_39_1','<code>h4</code> follows an <code>h3</code>','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_3_0','Alt text is longer than 100 characters.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_3_1','Alt text is shorter than 100 characters.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_40_0','<code>h6</code> follows an <code>h4</code>','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_40_1','<code>h5</code> follows an <code>h4</code>','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_41_0','<code>h6</code> follows an <code>h4</code>','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_41_1','<code>h6</code> follows an <code>h5</code>','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_42_0','Header is used to format text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_42_1','Header is not used to format text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_43_0','Header is used to format text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_43_1','Header is not used to format text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_44_0','Header is used to format text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_44_1','Header is not used to format text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_45_0','Header is used to format text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_45_1','Header is not used to format text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_46_0','Header is used to format text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_46_1','Header is not used to format text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_47_0','Header is used to format text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_47_1','Header is not used to format text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_48_0','<code>html</code> element missing a <code>lang</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_48_1','<code>html</code> element has a <code>lang</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_49_0','<code>lang</code> attribute is not valid.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_49_1','<code>lang</code> attribute is valid.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_4_0','IMG is non-decorative but has empty Alt text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_4_1','IMG is non-decorative and has valid Alt text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_50_0','<code>title</code> element is missing.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_50_1','<code>title</code> element is present.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_51_0','<code>title</code> element is empty.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_51_1','<code>title</code> element contains only whitespace.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_51_2','<code>title</code> element has content.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_52_0','<code>title</code> element is too long (greater than 150 characters).','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_52_1','<code>title</code> element has valid length (less than 150 characters).','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_53_0','<code>title</code> element has placehoder text \'title\'.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_53_1','<code>title</code> element has placehoder text \'the title\'.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_53_2','<code>title</code> element has placehoder text \'this is the title\'.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_53_3','<code>title</code> element has placehoder text \'untitled content\'.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_53_4','<code>title</code> element does not contain placeholder text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_54_0','<code>title</code> does not describe the document','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_54_1','<code>title</code> describes the document','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_55_0','Has <code>input</code> element','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_55_1','Does not have an <code>input</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_57_0','<code>input</code> does not have associated label.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_57_1','<code>input</code> has associated label with matching <code>for</code> and <code>id</code>attributes.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_57_2','<code>input</code> has associated label using <code>title</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_57_3','<code>input</code> has associated label using <code>label</code> element containing <code>input</code>element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_58_0','<code>input</code> element, <code>type</code> of \"image\", is missing <code>alt</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_58_1','<code>input</code> element, <code>type</code> of \"image\", has <code>alt</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_59_0','<code>input</code> element, <code>type</code> of \"image\", has Alt text that does not identify the purpose or function of the image.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_59_1','<code>input</code> element, <code>type</code> of \"image\", has Alt text that identifies the purpose or function of the image.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_5_0','<code>img</code> element has whitespace Alt text and width and height are both greater than 25.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_5_1','<code>img</code> element has whitespace Alt text but width and height are less than 25.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_60_0','<code>input</code> element, <code>type</code> of \"image\", has Alt text greater than 100 characters.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_60_1','<code>input</code> element, <code>type</code> of \"image\", has Alt text less than 100 characters.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_61_0','<code>input</code> <code>alt</code> attribute is same as the <code>src</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_61_1','<code>input</code> <code>alt</code> attribute is different from the <code>src</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_62_0','<code>input</code> <code>alt</code> attribute is \"image\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_62_1','<code>input</code> <code>alt</code> attribute is \"photo\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_62_2','<code>input</code> <code>alt</code> attribute contains \"bytes\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_62_3','<code>input</code> <code>alt</code> attribute is valid text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_63_0','<code>input</code> element, <code>type</code> of text, missing default text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_63_1','<code>input</code> element, <code>type</code> of text, contains default text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_64_0','<code>area</code> element missing <code>alt</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_64_1','<code>area</code> element has <code>alt</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_65_0','Alt text does not identify the link destination.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_65_1','Alt text identifies the link destination.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_66_0','<code>area</code> has link to sound file (.mp3) but no text equivalent link.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_66_1','<code>area</code> has link to sound file (.mp3) and has a text equivalent link.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_68_0','<code>area</code> has target of new window.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_68_1','<code>area</code> has target of \"_self\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_68_2','<code>area</code> has target of \"_top\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_68_3','<code>area</code> has target of \"_parent\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_69_0','Contains <code>marquee</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_69_1','Does not contain <code>marquee</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_6_0','<code>img</code> has alt text of \'spacer\'.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_6_1','<code>img</code> has alt text of \'nbsp\'.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_6_2','<code>img</code> has alt text that does not contain any placeholder text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_71_0','Contains auto-redirect.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_71_1','Does not contain auto-redirect.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_72_0','meta refresh used with a timeout','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_72_1','meta refresh used with a timeout of zero','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_72_2','meta refresh not used','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_73_0','<code>object</code> element used.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_73_1','<code>object</code> element not used','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_74_0','<code>object</code> element used.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_74_1','<code>object</code> element not used','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_75_0','<code>object</code> element used.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_75_1','<code>object</code> element not used','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_76_0','<code>object</code> element used.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_76_1','<code>object</code> element not used','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_77_0','<code>object</code> element has <code>type</code> attribute value of \"video\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_77_1','<code>object</code> element not used.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_78_0','<code>object</code> element missing <code>title</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_78_1','<code>object</code> element has <code>title</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_79_0','<code>object</code> with empty <code>title</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_79_1','<code>object</code> with whitespace <code>title</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_79_2','<code>object</code> with valid <code>title</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_7_0','<code>img</code> is contained by A element, anchor has no other text and Alt text is empty.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_7_1','<code>img</code> is contained by A element, anchor has no other text and Alt text is not empty.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_80_0','No alternate content.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_80_1','Contains text equivalent.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_80_2','Contains image alternate content.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_80_3','Contains link to alternate content.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_81_0','List with only one item.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_81_1','List with two items.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_82_0','Paragraph with all text marked as \"strong\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_82_1','Paragraph with all text marked as \"b\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_82_2','Paragraph with all text marked as \"i\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_82_3','Paragraph with all text marked as \"u\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_82_4','Paragraph with all text marked as \"font\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_82_5','Paragraph with all text marked as \"em\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_82_6','Paragraph with unmarked text.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_86_0','Contains a <code>script</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_86_1','Does not contain a <code>script</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_87_0','Contains a <code>script</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_87_1','Does not contain a <code>script</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_88_0','Contains a <code>script</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_88_1','Does not contain a <code>script</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_89_0','Contains a <code>script</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_89_1','Does not contain a <code>script</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_8_0','Image is not fully described in Alt text and a long description is not provided.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_8_1','Image is not fully described in Alt text but image has a <code>longdesc</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_8_2','Image is not fully described in Alt text. Document has a long description of image but alt text does not refer to it.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_8_3','Image is not fully described in Alt text. Document has a long description of image and Alt text refers to it.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_8_4','Image is not fully described in Alt text. Document does not have a long description of image. There is a link immediately following the image that goes to a text file providing the long description.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_90_0','Contains a <code>script</code> element without a <code>noscript</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_90_1','Contains both <code>script</code> and <code>noscript</code>.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_91_0','<code>select</code> element does not have associated label.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_91_1','<code>select</code> element has an associated label using <code>label</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_91_2','<code>select</code> element has an associated label using <code>title</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_91_3','<code>select</code> has associated label using <code>label</code> element containing <code>select</code>element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_92_0','<code>select</code> element\'s <code>onchange</code> attribute causes extreme change of context.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_92_1','<code>select</code> element\'s <code>onchange</code> attribute does not cause extreme change of context.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_92_2','<code>select</code> element\'s <code>onchange</code> attribute does not cause extreme change of context.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_94_0','Contains a SCRIPT element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_94_1','Does not contain a SCRIPT element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_95_0','<code>textarea</code> element does not have associated label.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_95_1','<code>textarea</code> element has an associated label using <code>label</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_95_2','<code>textarea</code> element has an associated label using <code>title</code> attribute.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_95_3','<code>textarea</code> element has associated label using <code>label</code> element containing <code>textarea</code>element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_96_0','Label is not close to <code>textarea</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_96_1','Label is close to <code>textarea</code> element.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_97_0','<code>link</code> element has <code>rel</code> attribute with value of \"stylesheet\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_97_1','<code>link</code> element does not have <code>rel</code> attribute with value of \"stylesheet\".','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_98_0','<code>body</code> has text with unmarked abbreviation.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_98_1','<code>body</code> text is less than 10 characters.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_99_0','<code>body</code> has more than 10 characters','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_99_1','<code>body</code> has less than 10 characters','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_9_0','<code>img</code> with <code>longdesc</code> but no d-link.','2008-11-24 13:03:48','');
REPLACE INTO `language_text` VALUES ('eng', '_test','_FILEDESC_9_1','<code>img</code> with a <code>longdesc</code> and d-link.','2008-11-24 13:03:48','');
