<?
//////////////////////////////////////////////////////////////////////
//
// Browse.php - Cwfm
//
// By Vincenzo Valvano - vival@cometweb.it
//
// This program is free software; you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version. This program 
// is distributed in the hope that it will be useful, but WITHOUT 
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public 
// License for more details. You should have received a copy of the 
// GNU General Public License along with this program; if not, write 
// to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
// Boston, MA  02111-1307  USA
//////////////////////////////////////////////////////////////////////
header ("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header ("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header ("Cache-Control: no-cache, must-revalidate");
header ("Pragma: no-cache");
session_start();
include_once("Global.php");
include_once("data/Cwfmini.php");
if( !ValidSession() )
{
	IntrusionNotify();
	exit;
}
function dirImg($ndir)
{
	global $ShowIcons;

	if( !$ShowIcons )
		return(" ");
	else
		return("<img src=\"img/small/Folder.png\"  border=\"0\" name=\"$ndir\">");
}
function rootImg()
{
	global $ShowIcons;

	if( !$ShowIcons )
		return("");
	else
		return("<img src=\"img/small/Root.png\"  border=\"0\" name=\"/\">");
}
function GetTree($sPath) 
{ 
	global $cwfmPath;
	$retVal = array();

	//Load Directory Into Array 
	$handle = @opendir($sPath); 
	while( ($file = @readdir($handle)) !== false ) 
	{
		if( $file == "." || $file == ".." )
			continue;
		if( !@file_exists($sPath.$file) )
			continue;
		if( !@is_dir($sPath.$file) )
			continue;
		if( $cwfmPath != "" && ($sPath.$file == $cwfmPath) )
			continue;
		$retVal[count($retVal)] = $file; 
	}
	//Clean up and sort 
	@closedir($handle); 
	if( count($retVal) > 0 )
		sort($retVal); 
	return $retVal; 
}
function hasSubdir($d)
{
	if( ($handle=@opendir($d)) == 0 )
		return(FALSE);
	while($file = readdir($handle)) 
	{
		if( $file == "." || $file == ".." )
			continue;
		if( !@file_exists($d."/".$file) )
			continue;
		if( @is_dir($d."/".$file) )
		{
			closedir($handle); 
			return(TRUE);
		}
	}
	closedir($handle); 
	return(FALSE); 
}
function isempty($dir)
{
	if( ($d=@opendir($dir)) == false )
		return(-1);
	while($entry = @readdir($d)) 
	{ 
		if ($entry != "." && $entry != ".." && $entry != "") 
		{ 
			closedir($d);
			return(0);
		} 
	} 
	closedir($d); 
	return(1);
}
function clickAction($s1, $s)
{
	global $oTarget, $HTTP_USER_AGENT;

	if( strstr($HTTP_USER_AGENT, "MSIE 5.0") )
		return("<a href=\"javascript:cAction('$s1', '$oTarget')\" >".dirImg($s1)."$s</a>");
	else
		return("<a href=\"#\" onClick=\"cAction('$s1', '$oTarget')\">".dirImg($s1)."$s</a>");
}
/*
*	Prints directory listing with open trees recursively
*
*	$command : ('goto', 'open', 'close', 'refresh') indicates the type of operation to be done
*	$target  : is the (relative) directory name selected for the operation (goto, open, close, refresh)
*	$parent  : is the directory from witch the function prints dir & subdir
*	$level	 : nesting level (starts from 0)
*/
function printTree($command, $target, $parent, $level)
{
	global $oTarget, $iPath, $sel, $MnOvBgCol;
	$a = array();

	if( $target != "/"  )
		$target = $target."/";
	if( $parent != "/" )
		$parent = $parent."/";
	if( ereg( '(^/[^/]*)(.*)', $target, $a) )
	{
		$left = $a[1];
		$right = $a[2];
	}
	else
		$left = $right = "";
	$d = GetTree($iPath.$parent);
	if( $level == 0 )
		echo "<table width=\"100%%\" border=\"0\">";
	for($i=0; $i < count($d); $i++)
	{
		$s = $d[$i];
		$s1 = $parent.$s;
		if( ($command == "open") && $left == ("/".$s))
		{
			if( $sel == $s1 )
				echo "<tr><td nowrap bgcolor=\"$MnOvBgCol\" nowrap>";
			else
				echo "<tr><td nowrap>";
			indent(2*$level);
			echo "<a name=\"$s1\" href=\"Browse.php?command=close&sel=$sel&target=$s1#$s1\">[-]</a>";
			echo clickAction($s1, $s)."</td></tr>\n";
			printTree($command, $right, $parent.$s, $level+1);
		}
		else
		if( ($command == "refresh" ) && $left == ("/".$s))
		{
			if( $sel == $s1 )
				echo "<tr><td nowrap bgcolor=\"$MnOvBgCol\" nowrap>";
			else
				echo "<tr><td nowrap>";
			indent(2*$level);
			$s1 = $parent.$s;
			if( hasSubdir($iPath.$s1) )
				echo "<a name=\"$s1\" href=\"Browse.php?command=close&sel=$sel&target=$s1#$s1\">[-]</a>";
			else
			{
				indent(2);
				echo "<a name=\"$s1\" href=\"Browse.php?command=close&sel=$sel&target=$s1#$s1\"></a>";
			}
			echo clickAction($s1, $s)."</td></tr>\n";
			printTree($command, $right, $parent.$s, $level+1);
		}
		else
		if( $command == "close" )
		{
			if( $sel == $s1 )
				echo "<tr><td nowrap bgcolor=\"$MnOvBgCol\" nowrap>";
			else
				echo "<tr><td nowrap>";
			indent(2*$level);
			$s1 = $parent.$s;
			if( $left != "/".$s )
			{
				if( hasSubdir($iPath.$s1) )
				{
					echo "<a name=\"$s1\" href=\"Browse.php?command=open&sel=$sel&target=$s1#$s1\">[+]</a>";
					echo clickAction($s1, $s)."</td></tr>\n";
				}
				else
				{
					indent(2);
					echo clickAction($s1, $s)."</td></tr>\n";
				}
			}
			else
			{
				if( $oTarget != $parent.$s )
				{
					echo "<a name=\"$s1\" href=\"Browse.php?command=close&sel=$sel&target=$s1#$s1\">[-]</a>";
					echo clickAction($s1, $s)."</td></tr>\n";
					printTree($command, $right, $parent.$s, $level+1);
				}
				else
				{
					$s1 = $parent.$s;
					echo "<a name=\"$s1\" href=\"Browse.php?command=open&sel=$sel&target=$s1#$s1\">[+]</a>";
					echo clickAction($s1, $s)."</td></tr>\n";
				}
			}
		}
		else
		{
			if( $sel == $s1 )
				echo "<tr><td nowrap bgcolor=\"$MnOvBgCol\" nowrap>";
			else
				echo "<tr><td nowrap>";
			indent(2*$level);
			if( hasSubdir($iPath.$s1) )
			{
				echo "<a name=\"$s1\" href=\"Browse.php?command=open&sel=$sel&target=$s1#$s1\">[+]</a>";
				echo clickAction($s1, $s)."</td></tr>\n";
			}
			else
			{
				indent(2);
				echo clickAction($s1, $s)."</td></tr>\n";
			}
		}
	}
	if( $level == 0 )
		echo "</table>";
}
function indent($level)
{
	if( $level == 0 )
		return;
	for($i=0; $i <= $level; $i++)
	{
		echo "&nbsp";
	}
}
?>
<html>
<head>
<title>Browse.php</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel=stylesheet href="Css.php" type="text/css">
<script language="JavaScript">
var Path;

<? if( isset($path) )
		echo "Path='$path';\n"; 
?> 

function cAction(s, t)
{
	document.location = 'Browse.php?command=refresh&path='+s+'&sel='+s+'&target='+t+'#'+t ;
}
</script>
</head>
<body>
<?
	global $target, $command, $ipath;

	$oTarget = $target;
	if( $ipath != "" )
		$iPath = $ipath;
	else
		$iPath = "";
	if( $iPath == "/" )
		$iPath = "";
	echo rootImg()."/<br>";
	printTree($command, $target, "/", 0);
?> 
</body>
</html>
