<?
//////////////////////////////////////////////////////////////////////
//
// File.php - Cwfm
//
// By Vincenzo Valvano - vival@cometweb.it
//
// This program is free software; you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version. This program 
// is distributed in the hope that it will be useful, but WITHOUT 
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public 
// License for more details. You should have received a copy of the 
// GNU General Public License along with this program; if not, write 
// to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
// Boston, MA  02111-1307  USA
//////////////////////////////////////////////////////////////////////
header ("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header ("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header ("Cache-Control: no-cache, must-revalidate");
header ("Pragma: no-cache");
session_start();
include_once("Global.php");
include_once("lang/$Language.php");
include_once("data/Cwfmini.php");
if( !ValidSession() )
{
	IntrusionNotify();
	exit;
}
global $numCol, $vm, $fCount;

if( $numCol != "" )
	$NumCol = $numCol;
if( $vm != "" )
	$ViewMode = $vm;

function FileIcon($file, $d)
{
	global $ShowIcons;

	if( !$ShowIcons || $file == "" )
		return("");
	$dot = strrchr($file, ".");
	if( !$dot )
		$img = "Generic.png";
	else
	{
		$ext = substr($dot, 1 );	
		switch(strtolower($ext))
		{
		case "txt":
			$img = "Txt.png";
			break;
		case "bmp":
		case "jpg":
		case "jpeg":
		case "jpe":
		case "gif":
		case "emf":
		case "tif":
		case "png":
			$img = "Image.png";
			break;
		case "ttf":
			$img = "Ttf.png";
			break;
		case "ini":
			$img = "Ini.png";
			break;
		case "bat":
			$img = "Script.png";
			break;
		case "dll":
		case "sys":
		case "com":
		case "exe":
			$img = "Binary.png";
			break;
		case "htm":
		case "shtm":
		case "html":
		case "shtml":
			$img = "Web.png";
			break;
		case "doc":
		case "rtf":
			$img = "Word.png";
			break;
		case "pdf":
			$img = "Pdf.png";
			break;
		case "xls":
		case "csv":
			$img = "Xls.png";
			break;
		case "ppt":
			$img = "Ppt.png";
			break;
		case "mdb":
		case "mda":
			$img = "Mdb.png";
			break;
		case "zip":
		case "tar":
		case "gz":
		case "arj":
		case "lha":
		case "tgz":
			$img = "Comp.png";
			break;
		case "mp3":
		case "wav":
			$img = "Sound.png";
			break;
		case "mpe":
		case "mpg":
		case "mpeg":
		case "avi":
		case "mov":
		case "asf":
		case "asx":
		case "wmv":
			$img = "Video.png";
			break;
		case "ram":
		case "ra":
		case "rm":
			$img = "Real.png";
			break;
		default:
			$img = "Generic.png";
			break;
		}
	}
	if( $d == "large" )
		return("<img src=\"img/$d/$img\" border=\"0\"> ");
	else
		return("<img src=\"img/$d/$img\" border=\"0\" align=\"absbottom\"> ");
}

function FType($file)
{
	$dot = strrchr($file, ".");
	if( !$dot )
		return("Generic");
	else
	{
		$ext = substr($dot, 1 );	
		return(ucfirst(strtolower($ext)));
	}
}


function myAcmp($a, $b)
{
	return(strnatcasecmp($a[1], $b[1]));
}

function myDcmp($a, $b)
{
	return(strnatcasecmp($b[1], $a[1]));
}

function GetDir($sPath) 
{ 
	global $order, $iPath, $dir, $fCount;

	$fCount = 0;
	//Load Directory Into Array 
	$handle=@opendir($sPath); 
	if( $handle == 0 )
		return("");
	$n = -1;
	while( ($file=@readdir($handle)) !== false ) 
	{
		if( $file == "." || $file == ".." )
			continue;
		if( !@file_exists($sPath.$file) )
			continue;
		if( @is_dir($sPath.$file) )
			continue;
		if( $n == -1 )
			$retVal = array();
		$n++;
		$retVal[$n][0] = $file; 
		switch($order)
		{
		case "NameUp":
		case "NameDw":
		default:
			$retVal[$n][1] = $file; 
			break;
		case "SizeUp":
		case "SizeDw":
			$retVal[$n][1] = filesize($iPath.$dir."/".$file); 
			break;
		case "TimeUp":
		case "TimeDw":
			$retVal[$n][1] = filemtime($iPath.$dir."/".$file); 
			break;
		case "TypeUp":
		case "TypeDw":
			$retVal[$n][1] = FType($file); 
			break;
		}
	}
	//Clean up and sort 
	closedir($handle); 
	if( isset($retVal) )
	{
		$fCount = $n;
		switch($order)
		{
		case "NameUp":
		case "SizeUp":
		case "TimeUp":
		case "TypeUp":
		default:
			usort($retVal, "myAcmp"); 
			break;
		case "NameDw":
		case "SizeDw":
		case "TimeDw":
		case "TypeDw":
			usort($retVal, "myDcmp"); 
			break;
		}
		return $retVal; 
	}
	else
		return(NULL);
}


function FileAttr($f)
{
	if( !($mode=@fileperms($f)) )
		return("-------");
	if( ($mode & 0x1000) === 0x1000 )
		$type='p'; /* FIFO pipe */
	else 
	if( ($mode & 0x2000) === 0x2000 )
		$type='c'; /* Character special */
	else 
	if(($mode & 0x4000) === 0x4000)
		$type='d'; /* Directory */
	else 
	if( ($mode & 0x6000) === 0x6000 )
		$type='b'; /* Block special */
	else 
	if( ($mode & 0x8000) === 0x8000 )
    	$type='-'; /* Regular */
	else 
	if( ($mode & 0xA000) === 0xA000 )
		$type='l'; /* Symbolic Link */
	else 
	if(($mode & 0xC000) === 0xC000)       
		$type='s'; // Unix domain socket
	else
		$type='?'; /* UNKNOWN */
	
	$att = ($mode & 00400) ? 'r' : '-';
	$att .= ($mode & 00200) ? 'w' : '-';
	$att .= ($mode & 00100) ? 'x' : '-';
	$att .= ($mode & 00040) ? 'r' : '-';
	$att .= ($mode & 00020) ? 'w' : '-';
	$att .= ($mode & 00010) ? 'x' : '-';
	$att .= ($mode & 00004) ? 'r' : '-';
	$att .= ($mode & 00002) ? 'w' : '-';
	$att .= ($mode & 00001) ? 'x' : '-';
	
	if( $mode & 0x800 )
		$att[2] = ($att[2]=='x')?'s':'S';
	if( $mode & 0x400 )
		$att[5] = ($att[5]=='x')?'s':'S';
	if( $mode & 0x200 )
		$att[5] = ($att[5]=='x')?'t':'T';
	return($type.$att);
}

function FOwner($f)
{
	if( !($ouid=@fileowner($f)) )
		return("");
	$arr = @posix_getpwuid($ouid);
	$own = $arr["name"];
	if( strlen($own) < 10 )
		return($own);
	else
		return(substr($own,0,7)."...");	
}

function printList($dir, $numCol)
{
	global $iPath, $sid, $ViewMode, $DetailLevel, $HTTP_USER_AGENT;
	global $LoBgCol, $LoFgCol, $HiBgCol, $HiFgCol, $BgCol, $TimeFormat, $TmpPrefix;
		
	if( $dir != "/" )
		$d = GetDir($iPath.$dir."/");
	else
		$d = GetDir($iPath.$dir);
	if( ($fp = @fopen("tmp/$sid/fsel.php", "rb")) )
		fgets($fp, 1024); // $Stop
	for($i=$c=$tf=$sf=$ts=$ss=0; $d != NULL && $d[0] != "" && $i < count($d); $i++)
	{
		$s = $d[$i][0];
		$e = EncodeFileName($s);
		if( !file_exists($iPath.$dir."/".$s))
			continue;
		if( $ViewMode == 1 )
			$bgCol = $LoBgCol;
		else
			$bgCol = $LoBgCol;
		$fgCol = $LoFgCol;
		$action = "select";
		$tf++;
		$fsize = filesize($iPath.$dir."/".$s);
		$ts += $fsize;
		if( $fp )
		{
			$path = CanonicalPath($iPath, $dir, $s)."\n";
			rewind($fp);
			fgets($fp, 1024); // $Stop
			while( !feof($fp) )
			{
				$buffer = fgets($fp, 1024);
				if( !strcmp($buffer, $path) )
				{
					$action = "unselect";
					$bgCol = $HiBgCol;
					$fgCol = $HiFgCol;
					$sf++;
					$ss += $fsize;
					break;
				}
			}
		}
		switch($ViewMode)
		{
		case 1: // Large Icons
			if( $c < $numCol )
			{
				echo "<table width=\"80\" height=\"80\" align=\"left\"";
				$c++;
			}
			else
			{
				echo "<table width=\"80\" height=\"80\" ";
				$c = 0;
			}
			echo "><tr><td align=\"center\">";
			echo "<a href=\"#\" onMouseOver=\"OnContext('$i','".EncodeFilename($s)."')\" onMouseOut=\"OffContext()\" onClick=\"ActionFile('$i', '".EncodeFilename($s)."',0)\">";
			echo FileIcon($s, "large");
			echo"</a></td></tr><tr><td";
			if( strlen($s) < 10 )
				echo " align=\"center\" valign=\"top\">";
			else
				echo ">";
			echo "<div id=\"A$i\" style=\"position:relative;layer-background-color: $bgCol; background-color: $bgCol; color: $fgCol\">";
			if( strlen($s) <= 10 )
				echo "$s<br>&nbsp;";
			else
			if( strlen($s) <= 20 )
				echo substr($s, 0, 10)."<br>".substr($s,10);
			else
				echo substr($s, 0, 10)."<br>".substr($s,10,7)."...";
			echo "</div></td></tr></table>";			
			break;
		case 2: // Details
			echo "<table width=\"100%\" border=\"0\">\n<tr><td>";
			// Name
			echo "<a href=\"#\" onMouseOver=\"OnContext('$i','".EncodeFilename($s)."')\" onMouseOut=\"OffContext()\" onClick=\"ActionFile('$i', '".EncodeFilename($s)."',0)\">";
			echo "<div id=\"A$i\" style=\"position:relative;layer-background-color: $bgCol; background-color: $bgCol; height: 20px ;color: $fgCol\">";
			printf("%s%s</div></a></td>", FileIcon($s, "small"), $s);
			if( $DetailLevel > 0 )
			{
				// Size
        		if( strstr($HTTP_USER_AGENT, "Mozilla/5") && $DetailLevel == 1 ) 
					echo "<td width=\"112\" align=\"right\">";
				else
					echo "<td width=\"90\" align=\"right\">";
				echo "<div id=\"B$i\" style=\"layer-background-color: $bgCol; background-color: $bgCol; height: 20px; color: $fgCol\">";
				printf("%s</div></td>", number_format($fsize,0,"","."));
			}
			if( $DetailLevel > 2 )
			{
				// Type
				echo "<td width=\"55\" align=\"center\">";
				echo "<div id=\"D$i\" style=\"layer-background-color: $bgCol; background-color: $bgCol; height: 20px; color: $fgCol\">";
				printf("%s</div></td>", substr(FType($s),0,7));
			}
			if( $DetailLevel > 4 )
			{
				// owner
				echo "<td width=\"70\" align=\"center\">";
				echo "<div id=\"F$i\" style=\"layer-background-color: $bgCol; background-color: $bgCol; height: 20px; color: $fgCol\">";
				printf("%s</div></td>", FOwner($iPath.$dir."/".$s));
			}
			if( $DetailLevel > 3 )
			{
				// Attrib
				echo "<td width=\"70\" align=\"center\">";
				echo "<div id=\"E$i\" style=\"layer-background-color: $bgCol; background-color: $bgCol; height: 20px; color: $fgCol\">";
				printf("%s</div></td>", FileAttr($iPath.$dir."/".$s));
			}
			if( $DetailLevel > 1 )
			{
				// Date
				$t = filemtime($iPath.$dir."/".$s);
				echo "<td width=\"125\" align=\"right\">";
				echo "<div id=\"C$i\" style=\"layer-background-color: $bgCol; background-color: $bgCol; height: 20px; color: $fgCol\">";
				echo (($TimeFormat)?date("d/m/Y H:i", $t):date("m/d/Y H:i", $t))."</div></td>";
			}
			echo "</tr></table>\n";
			break;
		}
	}
	if( $fp )
		fclose($fp);
	$ret[0] = $tf;
	$ret[1] = $sf;
	$ret[2] = $ts;
	$ret[3] = $ss;
	return($ret);
}

?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel=stylesheet href="Css.php" type="text/css">
<style>
<!--

/* Context menu Script-  Dynamic Drive (www.dynamicdrive.com) Last updated: 01/08/22
For full source code and Terms Of Use, visit http://www.dynamicdrive.com */

.skin0{
position:absolute;
width:140px;
border-bottom:2px solid #555555;
border-right:2px solid #555555;
border-top:2px solid #EEEEEE;
border-left:2px solid #EEEEEE;
background-color:menu;
font-family:Verdana;
line-height:15px;
cursor:default;
font-size:10px;
z-index:100;
visibility:hidden;
}

.menuitems{
padding-left:10px;
padding-right:10px;
}

.menudisabled{
padding-left:10px;
padding-right:10px;
background-color:menu;
color:#8F8F8F;
}

-->
</style>
<script language="JavaScript1.2">
<!--
var Over=0;
var File='';

function OnContext(id,f)
{
	Over=1;
	File=f;
	parent.FileId = id;
}
function OffContext()
{
	Over=0;
}

function SetStatus()
{
	parent.Done--;
}
function Sc(y)
{
	window.scroll(0, y);
}

var lastSelA = -1;  // Name
var lastSelB = -1;  // Size
var lastSelC = -1;  // Date
var lastSelD = -1; //  Type
var lastSelE = -1; //  Attr
var lastSelF = -1; //  Owner

function ActionFile(id, f, context)
{
	var objA = MM_findObj('A'+id);

	HideRename();
	parent.LastSelFileId=id;
<?
	echo "var bgCol = '$HiBgCol';\n";
	echo "var rgbBgCol = '".Rgb($HiBgCol)."';\n";
?>
	if( context)
	{
		eval("tmp=objA.style.backgroundColor");
		if( tmp.toUpperCase() == bgCol || tmp == rgbBgCol )
			return;
	}
	asel=SelectFile(id, f);
	if( !parent.MS )
		window.open("FileAction.php?command=selectsingle&dir="+parent.Dir+"&file="+f, "rightFrame", "");
	else
	{
		if( !asel )
			window.open("FileAction.php?command=select&dir="+parent.Dir+"&file="+f, "rightFrame", "");
		else
			window.open("FileAction.php?command=unselect&dir="+parent.Dir+"&file="+f, "rightFrame", "");
	}
}
function SelectFile(id, f)
{
	var col, ret=0;
	var objA = MM_findObj('A'+id);
<? 
if( $ViewMode == 2 ) 
{ 
	if( $DetailLevel > 0 )
		echo "var objB = MM_findObj('B'+id);\n";
	if( $DetailLevel > 1 )
		echo "var objC = MM_findObj('C'+id);\n";
	if( $DetailLevel > 2 )
		echo "var objD = MM_findObj('D'+id);\n";
	if( $DetailLevel > 3 )
		echo "var objE = MM_findObj('E'+id);\n";
	if( $DetailLevel > 4 )
		echo "var objF = MM_findObj('F'+id);\n";
	echo "var bgCol = '$LoBgCol';\n";
	echo "var rgbBgCol = '".Rgb($LoBgCol)."';\n";
}		
else
{
	echo "var bgCol = '$LoBgCol';\n";
	echo "var rgbBgCol = '".Rgb($LoBgCol)."';\n";
}
echo "var fgCol='$LoFgCol';\n";
?>
	var sT;
			
    if (document.all)
        sT = document.body.scrollTop;
    else
        sT = window.pageYOffset;
	if( !parent.MS )
	{
		if( lastSelA != -1 )
		{
			lastSelA.style.backgroundColor = bgCol;
			lastSelA.style.color = fgCol;
<? 
			if( $ViewMode == 2 ) 
			{ 
				if( $DetailLevel > 0 )
				{
					echo "lastSelB.style.backgroundColor = bgCol;\n";
					echo "lastSelB.style.color = fgCol;\n";
				}			
				if( $DetailLevel > 1 )
				{
					echo "lastSelC.style.backgroundColor = bgCol;\n";
					echo "lastSelC.style.color = fgCol;\n";
				}
				if( $DetailLevel > 2 )
				{
					echo "lastSelD.style.backgroundColor = bgCol;\n";
					echo "lastSelD.style.color = fgCol;\n";
				}
				if( $DetailLevel > 3 )
				{
					echo "lastSelE.style.backgroundColor = bgCol;\n";
					echo "lastSelE.style.color = fgCol;\n";
				}
				if( $DetailLevel > 4 )
				{
					echo "lastSelF.style.backgroundColor = bgCol;\n";
					echo "lastSelF.style.color = fgCol;\n";
				}
			}
?>
		}
		bgCol = '<?echo $HiBgCol?>';
		fgCol = '<?echo $HiFgCol?>';
		objA.style.color=fgCol;
		objA.style.backgroundColor=bgCol;
		lastSelA = objA; 		
<? 
		if( $ViewMode == 2 )
		{
			if( $DetailLevel > 0 )
			{
				echo "objB.style.backgroundColor=bgCol;\n";
				echo "objB.style.color=fgCol;\n";
				echo "lastSelB = objB;\n";
			}
			if( $DetailLevel > 1 )
			{
				echo "objC.style.backgroundColor=bgCol;\n";
				echo "objC.style.color=fgCol;\n";
				echo "lastSelC = objC;\n";
			}
			if( $DetailLevel > 2 )
			{
				echo "objD.style.backgroundColor=bgCol;\n";
				echo "objD.style.color=fgCol;\n";
				echo "lastSelD = objD;\n";
			}
			if( $DetailLevel > 3 )
			{
				echo "objE.style.backgroundColor=bgCol;\n";
				echo "objE.style.color=fgCol;\n";
				echo "lastSelE = objE;\n";
			}
			if( $DetailLevel > 4 )
			{
				echo "objF.style.backgroundColor=bgCol;\n";
				echo "objF.style.color=fgCol;\n";
				echo "lastSelF = objF;\n";
			}
		}
?>
	}
	else
	{
		eval("tmp=objA.style.backgroundColor");
		if( tmp.toUpperCase() == bgCol || tmp == rgbBgCol )
		{
			bgCol = '<?echo $HiBgCol?>';
			fgCol = '<?echo $HiFgCol?>';
			ret = 0;
		}
		else
		{
			bgCol = '<?echo $LoBgCol?>';
			fgCol = '<?echo $LoFgCol?>';
			ret = 1;
		}
		objA.style.color=fgCol;
		objA.style.backgroundColor=bgCol;
<?
		if( $ViewMode == 2 )
		{
			if( $DetailLevel > 0 )
			{
				echo "objB.style.backgroundColor=bgCol;\n";
				echo "objB.style.color=fgCol;\n";
			}
			if( $DetailLevel > 1 )
			{
				echo "objC.style.backgroundColor=bgCol;\n";
				echo "objC.style.color=fgCol;\n";
			}
			if( $DetailLevel > 2 )
			{
				echo "objD.style.backgroundColor=bgCol;\n";
				echo "objD.style.color=fgCol;\n";
			}
			if( $DetailLevel > 3 )
			{
				echo "objE.style.backgroundColor=bgCol;\n";
				echo "objE.style.color=fgCol;\n";
			}
			if( $DetailLevel > 4 )
			{
				echo "objF.style.backgroundColor=bgCol;\n";
				echo "objF.style.color=fgCol;\n";
			}
		}
?>
	}
	eval("setTimeout('Sc('+sT+')', 1)");
	return(ret);
}

function MM_findObj(n, d) { //v4.0
  var p,i,x;  if(!d) d=document; if((p=n.indexOf("?"))>0&&parent.frames.length) {
    d=parent.frames[n.substring(p+1)].document; n=n.substring(0,p);}
  if(!(x=d[n])&&d.all) x=d.all[n]; for (i=0;!x&&i<d.forms.length;i++) x=d.forms[i][n];
  for(i=0;!x&&d.layers&&i<d.layers.length;i++) x=MM_findObj(n,d.layers[i].document);
  if(!x && document.getElementById) x=document.getElementById(n); return x;
}

function MM_changeProp(objName,x,theProp,theValue) { //v3.0
  var obj = MM_findObj(objName);
  if (obj && (theProp.indexOf("style.")==-1 || obj.style)) eval("obj."+theProp+"='"+theValue+"'");
}

function numCol()
{
	if( document.all )
		var w = parent.document.all.MainMenuFrame.width / 80
	else
		var w = window.innerWidth / 80
	return(Math.round(w)-2);
}

function largeIcons()
{
	if( parent.ViewMode == 1 )
		return;
	parent.ViewMode = 1;
	window.open('Headers.php?dir='+parent.Dir+'&vm=1', 'headerFrame', '');
	window.open('File.php?command=goto&dir='+parent.Dir+'&numCol='+numCol()+'&vm=1', 'mainFrame', '');
}
function details()
{
	if( parent.ViewMode == 2 )
		return;
	parent.ViewMode = 2;
	window.open('Headers.php?dir='+parent.Dir+'&vm=2', 'headerFrame', '');
	window.open('File.php?command=goto&dir='+parent.Dir+'&vm=2', 'mainFrame', '');
}
function newFile()
{
	var w = 700;
	var h = 520;
	var top = (screen.height-h)/2 - 50;
	var left = (screen.width-w)/2;

	window.open('FileEdit.php?command=new&dir='+parent.Dir,'Newfile','width='+w+',height='+h+',top='+top+',left='+left);
}
function upload(unz)
{
<? if( strstr($HTTP_USER_AGENT, "Mozilla/5") ) { ?>
	var w = 550;
	var h = 250;
<? } else { ?>
	var w = 470;
	var h = 155;
<? } ?>
	var h = 155;
	var top = (screen.height-h)/2;
	var left = (screen.width-w)/2;

	window.open('MUpload.php?dir='+parent.Dir+'&unz='+unz,'MUpload','width='+w+',height='+h+',top='+top+',left='+left);
}

function Copy()
{
	parent.FileCopyState = 1;
	window.open('Copy.php', 'rightFrame', '');
}

function Cut()
{
	parent.FileCopyState = 1;
	window.open('Cut.php', 'rightFrame', '');
}

function Paste()
{
	parent.FileCopyState = 0;
	window.open('Paste.php?dir=<?echo $dir?>', 'rightFrame', '');
}
function Rename()
{
	var showIcons = <?echo $ShowIcons ?>;
	var id=document.getElementById("dfname");
	var lid=document.getElementById('A'+parent.LastSelFileId);
<? if( strstr($HTTP_USER_AGENT, "Mozilla/5") ) { ?>
	if( parent.ViewMode == 1 )
	{
		id.style.top=lid.offsetTop;
		id.style.left=lid.offsetLeft;
	}
	else
	{
		id.style.top=lid.offsetTop+1;
		if( showIcons )
			id.style.left=lid.offsetLeft+23;
		else
			id.style.left=lid.offsetLeft-1;
	}
<? } else { ?>
	if( parent.ViewMode == 1 )
	{
		id.style.top=lid.offsetTop-40;
		id.style.left=lid.offsetLeft;
	}
	else
	{
		id.style.top=lid.offsetTop;
		if( showIcons )
			id.style.left=lid.offsetLeft+22;
		else
			id.style.left=lid.offsetLeft-1;
	}
<? } ?>
	document.fname.fname.value=parent.LastSelFile;
	document.fname.fname.size=parent.LastSelFile.length+4;
	id.style.visibility="visible"
	document.fname.fname.select();
	document.fname.fname.focus();
}
function ExecRename()
{
	if( document.fname.fname.value == "" )
	{
		alert('<?echo $A48_L?>');
		return;
	}
	window.open('RenameFile.php?dir=<?echo $dir?>&n='+document.fname.fname.value, 'rightFrame', '');
}
function HideRename()
{
	var id=document.getElementById("dfname");
	id.style.visibility="hidden";
}

//-->
</script>
</head>
<body>
<div id="dfname" class="fname" display:hidden ><form name="fname" class="fname" action="javascript:ExecRename()">
<input type="text" class="fname" name="fname"  maxlength="255">
</form></div>
<div id="ie5menu" class="skin0" onMouseover="highlightie5(event)" onMouseout="lowlightie5(event)" onClick="jumptoie5(event)" display:hidden>
<? if( $CanEdit ) { ?>
<div class="menuitems" target="rightFrame" url="BootOpenFile.php?dir=<?echo $dir?>"><?echo $L26_L?></div>
<? } else { ?>
<div class="menudisabled" url=""><?echo $L26_L?></div>
<? } ?>
<hr width="95%">
<? if( $CanCut ) { ?>
<div class="menuitems" js="Cut()"><?echo $L5_L?></div>
<? } else { ?>
<div class="menudisabled"><?echo $L5_L?></div>
<? } ?>
<? if( $CanCopy ) { ?>
<div class="menuitems" js="Copy()"><?echo $L6_L?></div>
<? } else { ?>
<div class="menudisabled"><?echo $L6_L?></div>
<? } ?>
<hr width="95%">
<? 
if( $CanDwload )
{
	echo "<div class=\"menuitems\" target=\"rightFrame\" url=\"Dw.php?zip=0\">$L13_L</div>\n";
	if( $ZipPath != "" )
		echo "<div class=\"menuitems\" target=\"rightFrame\" url=\"Dw.php?zip=1\">$L14_L</div>\n";
	else
		echo "<div class=\"menudisabled\" >$L14_L</div>\n";
}
else
{
	echo "<div class=\"menudisabled\" >$L13_L</div>\n";
	echo "<div class=\"menudisabled\" >$L14_L</div>\n";
} 
?>
<hr width="95%">
<? if( $CanDelete ) { ?>
<div class="menuitems" target="rightFrame" url="BootDelete.php?dir=<?echo $dir?>" ><?echo $L12_L?></div>
<? } else { ?>
<div class="menudisabled"><?echo $L12_L?></div>
<? } ?>
<? if( $CanRename ) { ?>
<div class="menuitems" js="Rename()"><?echo $L11_L?></div>
<? } else { ?>
<div class="menudisabled"><?echo $L11_L?></div>
<? } ?>
<hr width="95%">
<div class="menuitems" target="rightFrame" url="FileAction.php?command=selectall&dir=<?echo $dir?>" ><?echo $L8_L?></div>
<div class="menuitems" target="rightFrame" url="FileAction.php?command=unselectall&dir=<?echo $dir?>"><?echo $L9_L?></div>
</div>

<div id="ie5menu2" class="skin0" onMouseover="highlightie5(event)" onMouseout="lowlightie5(event)" onClick="jumptoie5(event)" display:hidden>
<? if( $CanCreate ) { ?>
<div class="menuitems" js="newFile()"><?echo $L44_L?></div>
<? } else { ?>
<div class="menudisabled"><?echo $L44_L?></div>
<? } ?>
<? if( $CanPaste ) { ?>
<div id="paste" class="menudisabled" js="Paste()" ><?echo $L7_L?></div>
<? } else { ?>
<div class="menudisabled"><?echo $L7_L?></div>
<? } ?>
<hr width="95%">
<? 
if( $CanUpload )
{
	echo "<div class=\"menuitems\" js=\"upload(0)\" >$L15_L</div>\n";
	if( $UnzipPath != "" )
		echo "<div class=\"menuitems\" js=\"upload(1)\" >$L34_L</div>\n";
	else
		echo "<div class=\"menudisabled\" >$L34_L</div>\n";
} 
else
{ 
	echo "<div class=\"menudisabled\" >$L15_L</div>\n";
	echo "<div class=\"menudisabled\" >$L34_L</div>\n";
} 
?>
<hr width="95%">
<? if( $ShowIcons ) { ?>
<div class="menuitems" js="largeIcons()"><?echo $L30_L?></div>
<div class="menuitems" js="details()"><?echo $L32_L?></div>
<? } else { ?>
<div class="menudisabled"><?echo $L30_L?></div>
<div class="menudisabled"><?echo $L32_L?></div>
<? } ?>
<hr width="95%">
<div class="menuitems" target="rightFrame" url="FileAction.php?command=selectall&dir=<?echo $dir?>" ><?echo $L8_L?></div>
<div class="menuitems" target="rightFrame" url="FileAction.php?command=unselectall&dir=<?echo $dir?>"><?echo $L9_L?></div>
</div>

<?
	global $file, $dir, $command;

	if( $command == "" )
		exit;
	if( $iPath == "/")
		$iPath = "";
	if( $dir == "" )
		$dir = "/";
	echo "<script language=\"JavaScript\">\n";
	echo "parent.Dir='$dir';\n";	
	echo "</script>\n";
	if( $command == "goto")
	{
		@unlink("tmp/$sid/fsel.php");
		@unlink("tmp/$sid/tmp.zip");
	}
	if( $command == "delete" && $CanDelete )
	{
		$ok = FALSE;
		$fp = @fopen("tmp/$sid/fsel.php", "rb");
		if( $fp )
		{	
			fgets($fp, 1024); // $Stop
			$ok = TRUE;
			for($i=0; !feof($fp); )
			{
				$s = fgets($fp, 1024);
				if( $s == "" )
					continue;
				$i++;
				$file = substr($s, 0, -1);
				if( !@unlink($file) )
					$ok = FALSE;
			}
			fclose($fp);
			@unlink("tmp/$sid/fsel.php");
		}
	}
	$ret = printList($dir, $NumCol );
	if( $command == "delete" && $CanDelete && !$ok)
	{
		echo "<script language=\"JavaScript\">\n";
		if( $i == 1 )
			echo "alert('$A29_L');\n";
		else
			echo "alert('$A30_L');\n";
		echo "</script>\n";
	}
	if( ($fp=@fopen("tmp/$sid/fstat","w")) )
	{
		fwrite($fp, "$ret[0]\n$ret[1]\n$ret[2]\n$ret[3]\n");
		fclose($fp);
		chmod("tmp/$sid/fstat", 0600);
	}
	echo "\n<script language=\"JavaScript\">\n";
	echo "window.open('Status.php?command=$command&dir=$dir&file=$file', 'bottomFrame', '');\n";
	echo "</script>";

?>
<script language="JavaScript1.2">
function RefreshDir(d)
{
	var id = parent.MainMenuFrame.document.getElementById("dirtext");
	id['innerHTML'] = '<strong>'+d+'</strong>';
}
SetStatus();
if( parent.FileCopyState == 1 )
{
	var id = document.getElementById("paste");
 	id.className='menuitems';
	id.style.backgroundColor="";
	id.style.color="";
}

//set this variable to 1 if you wish the URLs of the highlighted menu to be displayed in the status bar
var display_url=0

var ie5=document.all&&document.getElementById
var ns6=document.getElementById&&!document.all
if (ie5||ns6)
	var menuobj=document.getElementById("ie5menu");

function showmenuie5(e)
{
	hidemenuie5(e);
	var ie5=document.all&&document.getElementById
	var ns6=document.getElementById&&!document.all
	if (ie5||ns6)
	{
		if( Over )
		{
			var menuobj=document.getElementById("ie5menu");
			ActionFile(parent.FileId, File,1);
		}
		else
			var menuobj=document.getElementById("ie5menu2")
	}
//Find out how close the mouse is to the corner of the window
	var rightedge=ie5? document.body.clientWidth-event.clientX : window.innerWidth-e.clientX
	var bottomedge=ie5? document.body.clientHeight-event.clientY : window.innerHeight-e.clientY

//if the horizontal distance isn't enough to accomodate the width of the context menu
	if (rightedge<menuobj.offsetWidth)
//move the horizontal position of the menu to the left by it's width
		menuobj.style.left=ie5? document.body.scrollLeft+event.clientX-menuobj.offsetWidth : window.pageXOffset+e.clientX-menuobj.offsetWidth
	else
//position the horizontal position of the menu where the mouse was clicked
		menuobj.style.left=ie5? document.body.scrollLeft+event.clientX : window.pageXOffset+e.clientX

//same concept with the vertical position
	if(bottomedge<menuobj.offsetHeight)
		tmp=ie5? document.body.scrollTop+event.clientY-menuobj.offsetHeight : window.pageYOffset+e.clientY-menuobj.offsetHeight
	else
		tmp=ie5? document.body.scrollTop+event.clientY : window.pageYOffset+e.clientY
	if( tmp < 2 )
		tmp = 2;
	menuobj.style.top = tmp;
	menuobj.style.visibility="visible"
	return false
}

function hidemenuie5(e)
{
	var menuobj=document.getElementById("ie5menu");
	menuobj.style.visibility="hidden";
	menuobj=document.getElementById("ie5menu2");
	menuobj.style.visibility="hidden";

	menuobj = parent.leftFrame.document.getElementById("ie5menu");
	menuobj.style.visibility="hidden";

	menuobj = parent.MainMenuFrame.document.getElementById("Edit");
	menuobj.style.visibility="hidden";
	menuobj = parent.MainMenuFrame.document.getElementById("View");
	menuobj.style.visibility="hidden";
	menuobj = parent.MainMenuFrame.document.getElementById("Dir");
	menuobj.style.visibility="hidden";
	menuobj = parent.MainMenuFrame.document.getElementById("File");
	menuobj.style.visibility="hidden";
	menuobj = parent.MainMenuFrame.document.getElementById("Transfer");
	menuobj.style.visibility="hidden";
	RefreshDir(parent.Dir);
}

function highlightie5(e)
{
	var firingobj=ie5? event.srcElement : e.target
	if( firingobj.className=="menuitems"||ns6&&firingobj.parentNode.className=="menuitems" )
	{
		if (ns6&&firingobj.parentNode.className=="menuitems") 
			firingobj=firingobj.parentNode //up one node
		firingobj.style.backgroundColor="highlight"
		firingobj.style.color="white"
		if (display_url==1)
			window.status=event.srcElement.url
	}
}

function lowlightie5(e)
{
	var firingobj=ie5? event.srcElement : e.target
	if (firingobj.className=="menuitems"||ns6&&firingobj.parentNode.className=="menuitems")
	{
		if (ns6&&firingobj.parentNode.className=="menuitems") 
			firingobj=firingobj.parentNode //up one node
		firingobj.style.backgroundColor=""
		firingobj.style.color="black"
		window.status=''
	}
}

function jumptoie5(e)
{
	var firingobj=ie5? event.srcElement : e.target
	if (firingobj.className=="menuitems"||ns6&&firingobj.parentNode.className=="menuitems")
	{
		if (ns6&&firingobj.parentNode.className=="menuitems") 
			firingobj=firingobj.parentNode
		if (firingobj.getAttribute("js"))
			eval(firingobj.getAttribute("js"))
		else
		if (firingobj.getAttribute("target"))
			window.open(firingobj.getAttribute("url"),firingobj.getAttribute("target"))
		else
			window.location=firingobj.getAttribute("url")
	}
}

if (ie5||ns6)
{
	menuobj.style.display=''
	document.oncontextmenu=showmenuie5
	document.onclick=hidemenuie5
}
</script>
</body>
</html>
