<?
//////////////////////////////////////////////////////////////////////
//
// Userdb.php - Cwfm
//
// By Vincenzo Valvano - vival@cometweb.it
//
// This program is free software; you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version. This program 
// is distributed in the hope that it will be useful, but WITHOUT 
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public 
// License for more details. You should have received a copy of the 
// GNU General Public License along with this program; if not, write 
// to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
// Boston, MA  02111-1307  USA
//////////////////////////////////////////////////////////////////////
if( file_exists("data/Cwfmini.php") )
	include_once("data/Cwfmini.php");
// User data record
class UserRecordV9
{
	var $username;
	var $password;	
	var $iPath;
	var $mkdir;
	var $upload;
	var $dwload;
	var $rmdir;
	var $delete;
	var $rename;
	var $rmdir;
	var $view;
	var $descV;
	var $descM;
	var $root1;
	var $root2;
	var $root3;
	var $root4;
	var $rname1;
	var $rname2;
	var $rname3;
	var $rname4;
// Added in V0.9
	var $mail;
	var $language;
	var $icons;
	var $cut;
	var $copy;
	var $paste;
	var $options;
	var $chpwd;
	var $rendir;
	var $viewM;
	var $detailL;
	var $editFile;
	var $newFile;
	var $exec;
	var $timeFormat;
}

class UserRecord
{
	var $username;
	var $password;	
	var $iPath;
	var $mkdir;
	var $upload;
	var $dwload;
	var $rmdir;
	var $delete;
	var $rename;
	var $view;
	var $descV;
	var $descM;
	var $search;
	var $clip;
	var $root1;
	var $root2;
	var $root3;
	var $root4;
	var $rname1;
	var $rname2;
	var $rname3;
	var $rname4;
	var $url1;
	var $url2;
	var $url3;
	var $url4;
}

function UpgradeUserDb()
{
	global	$userDat, $Stop, $userTmp, $DbVersion;
	$or = new UserRecord;
	$nr = new UserRecordV9;
	
	if( !file_exists($userDat) )
		return(1);
	if( !($fpi = @fopen($userDat, "rb")) )
		return(-1);
	fgets($fpi, 64);	// Skip header
// Checks db version
	$v = fgets($fpi,4096);
	if( $v == $DbVersion."\n" )
	{
		fclose($fpi);
		return(2);
	}
	if( !($fpo = @fopen($userTmp, "wb")) )
	{
		fclose($fpi);
		return(-2);
	}
	fputs($fpo, $Stop);
	fputs($fpo, "$DbVersion\n");
	while(!feof($fpi) )
	{
		if( $v == "" )
		{
			$v = fgets($fpi, 4096);
			continue;
		}
		$or = unserialize($v);
		$nr->username = $or->username;
		$nr->password = $or->password;	
		$nr->iPath = $or->iPath;
		$nr->mkdir = $or->mkdir;
		$nr->upload = $or->upload;
		$nr->dwload = $or->dwload;
		$nr->rmdir = $or->rmdir;
		$nr->delete = $or->delete;
		$nr->view = $or->view;
		$nr->descV = $or->descV;
		$nr->descM = $or->descM;
		$nr->root1 = $or->root1;
		$nr->root2 = $or->root2;
		$nr->root3 = $or->root3;
		$nr->root4 = $or->root4;
		$nr->rname1 = $or->rname1;
		$nr->rname2 = $or->rname2;
		$nr->rname3 = $or->rname3;
		$nr->rname4 = $or->rname4;
		$nr->rename = $or->delete;
		$nr->mail = "";
		$nr->language = "English";
		$nr->icons = 1;
		$nr->cut = $or->delete;
		$nr->copy = 1;
		$nr->paste = $or->upload;
		$nr->options = 1;
		$nr->chpwd = 1;
		$nr->editFile = $or->delete;
		$nr->newFile = $or->upload;
		$nr->rendir = $or->delete;
		$nr->rename = $or->delete;
		$nr->viewM = 2;
		$nr->detailL = 2;
		$nr->exec = 0;
		$nr->timeFormat = 0;  // mm/dd/yyy
		fwrite($fpo, serialize($nr));
		fwrite($fpo, "\n");
		$v = fgets($fpi, 4096);
	}
	fclose($fpo);
	fclose($fpi);
	copy($userTmp, $userDat);
	unlink($userTmp);
	@chmod($userDat,0600);
	return(0);
}
function addUser($r)
{
	global	$userDat, $Stop, $DbVersion;

	if( file_exists($userDat) )
	{
		if( !($fp = @fopen($userDat, "ab")) )
			return(-1);
	}
	else
	{
		if( !($fp = @fopen($userDat, "wb")) )
			return(-1);
		fputs($fp, $Stop);	// Add header
		fputs($fp, "$DbVersion\n");
	}
	$s = serialize($r);
	fwrite($fp, $s);
	fwrite($fp, "\n");
	fclose($fp);
	@chmod($userDat,0600);
	return(0);
}

function modifyUser($r)
{
	global	$userDat, $userTmp;
	$or = new UserRecordV9;

	if( ($fp=@fopen($userDat, "rb")) == 0 )
		exit;
	if( ($fp1=@fopen($userTmp, "wb")) == 0 )
		exit;
	$l = fgets($fp, 32); //Header
	fputs($fp1, $l);
	$l = fgets($fp, 32); //Version
	fputs($fp1, $l);
	for($i=0; !feof($fp); )
	{
		$s = fgets($fp, 4096);
		if( $s == "" )
			continue;
		$or = unserialize($s);
		if( $or->username == "" )
			continue;
		if( $or->username == $r->username )
		{
			$t = serialize($r);
			fwrite($fp1, $t);
			fwrite($fp1, "\n");
		}
		else	
			fwrite($fp1, $s);
	}
	fclose($fp);
	fclose($fp1);
	copy($userTmp, $userDat);
	unlink($userTmp);
	@chmod($userDat,0600);
}

function getUser($username, &$r)
{
	global	$userDat;

	if( ($fp = @fopen($userDat, "rb")) == 0)
		return("");
	fgets($fp, 32);	// Skip header
	fgets($fp, 32);	// Skip Version
	while( !feof($fp) )
	{
		$s = fgets($fp, 4096);
		if( $s == "" )
			continue;
		$r = unserialize($s);
		if( $r->username == "" )
			continue;
		if( md5($r->username.session_id()) == $username)
		{
			fclose($fp);
			return($r->username);
		}
	}
	fclose($fp);
	return("");
}

function validUser($username, $password)
{
	global	$userDat;
	$r = new UserRecordV9;
	
	if( ($fp = @fopen($userDat, "rb")) == 0 )
		return(FALSE);
	fgets($fp, 32);	// Skip header
	fgets($fp, 32);	// Skip Version
	while( !feof($fp) )
	{
		$s = fgets($fp, 4096);
		if( $s == "" )
			continue;
		$r = unserialize($s);
		if( $r->username == "" )
			continue;
		if( md5($r->username.session_id()) == $username && md5($r->password.session_id()) == $password )
		{
			fclose($fp);
			return(TRUE);
		}
	}
	fclose($fp);
	return(FALSE);
}
?>