<?php
/**
 * This file is part of the Achievo ATK distribution.
 * Detailed copyright and licensing information can be found
 * in the doc/COPYRIGHT and doc/LICENSE files which should be
 * included in the distribution.
 *
 * @package atk
 * @subpackage utils
 *
 * @copyright (c) 2000-2007 Ibuildings.nl BV
 *
 * @license http://www.achievo.org/atk/licensing ATK Open Source License
 */

atkimport('atk.datagrid.atkdgevent');

/**
 * The data grid listener can be implemented and registered for a data grid
 * to listen for data grid events. 
 *
 * @author Peter C. Verhage <peter@achievo.org>
 * @package atk
 * @subpackage datagrid
 */
interface atkDGListener
{

  /**
   * Will be called for each data grid event.
   *
   * @param atkDGEvent $event event
   */
  public function notify(atkDGEvent $event);
}