<?php
// Copyright (C) 2014 TeemIp
//
//   This file is part of TeemIp.
//
//   TeemIp is free software; you can redistribute it and/or modify	
//   it under the terms of the GNU Affero General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   TeemIp is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU Affero General Public License for more details.
//
//   You should have received a copy of the GNU Affero General Public License
//   along with TeemIp. If not, see <http://www.gnu.org/licenses/>

/**
 * @copyright   Copyright (C) 2014 TeemIp
 * @license     http://opensource.org/licenses/AGPL-3.0
 */

/*******************
 * Global constants
 */

define('DEFAULT_MAX_FREE_IP_OFFERS_REQ', 10);
define('DEFAULT_MAX_FREE_IP_OFFERS_WITH_PING_REQ', 5);
define('DEFAULT_MAX_FREE_SPACE_OFFERS_REQ', 10);

/***********************************************************************************
 * Plugin to extend the list of possible actions that can be applied to IP Requests 
 */

class IPRequestPlugIn implements iApplicationUIExtension
{
	public function OnDisplayProperties($oObject, WebPage $oPage, $bEditMode = false)
	{
	}
	
	public function OnDisplayRelations($oObject, WebPage $oPage, $bEditMode = false)
	{
	}
	
	public function OnFormSubmit($oObject, $sFormPrefix = '')
	{
	}
	
	public function OnFormCancel($sTempId)
	{
	}
	
	public function EnumUsedAttributes($oObject)
	{
		return array();
	}
	
	public function GetIcon($oObject)
	{
		return '';
	}
	
	public function GetHilightClass($oObject)
	{
		return HILIGHT_CLASS_NONE;
	}
	
	public function EnumAllowedActions(DBObjectSet $oSet)
	{
		$oObj = $oSet->Fetch();
		
		// Additional actions for IPRequest
		if ($oObj instanceof IPRequest)
		{
			// Add action if in new state only
			if ($oObj->Get('status') == 'assigned')
			{
				$oAppContext = new ApplicationContext();
				$sContext = $oAppContext->GetForLink();
			
				$sClass = get_class($oObj);
				if (UserRights::IsStimulusAllowed($sClass, 'ev_resolve'))
				{
					$id = $oObj->GetKey();
					return array(Dict::S('UI:IPManagement:Action:Implement:IPRequest') => utils::GetAbsoluteUrlModulesRoot()."teemip-request-mgmt/ui.teemip-request-mgmt.php?operation=stimulus&stimulus=ev_resolve&class=$sClass&id=$id&$sContext");
				}
			}
		}
		return array();
	}
}
