<?php
/* Sandbox v0.5-1.0b
 * Copyright (c) 2006-2007
 * Sam O'Connor (Kiasyn) http://www.kiasyn.com
 *
 * Additions to Sandbox after 1.0:
 * Copyright (c) 2007-2010
 * Roger Libiez [Samson] http://www.iguanadons.net
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the authors be held liable for any damages arising from the
 * use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it freely,
 * subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not claim
 * that you wrote the original software. If you use this software in a product,
 * an acknowledgment in the product documentation is required.
 *
 * 2. Altered source versions must be plainly marked as such, and must not be
 * misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * 4. You must make an effort to notify the author (Sam O'Connor) at the email
 * address sandbox@kiasyn.com if you plan on publicly distributing a derivative
 * of this software, whether by email, download or a form of disk/disc.
 *
 * Notifying Roger Libiez is not required but would still be appreciated :)
 */

if ( !defined('SANDBOX') || !defined('SANDBOX_ADM') ) {
	header('HTTP/1.0 403 Forbidden');
	die;
}

class sys extends module
{
	function execute()
	{
		if( $this->user['user_level'] < USER_ADMIN )
			return $this->error( 'Access Denied: You do not have permission to perform that action.' );

		if( isset($this->get['s']) ) {
			switch( $this->get['s'] )
			{
				case 'phpinfo':
					$this->nohtml = true;
					return phpinfo();
				case 'sql':		return $this->perform_sql();
				case 'stats':		return $this->display_stats();
				case 'optimize':	return $this->opt_tables();
				case 'repair':		return $this->repair_tables();
				case 'recount':		return $this->recount_all();
			}
		}
		return $this->display_stats();
	}

	// Counts all comment entries and resets the counters on each blog, image, or download entry.
	// Should not be needed unless you are manually removing entries through another database interface.
	function recount_all()
	{
		$posts = $this->db->query( "SELECT post_id FROM {$this->pre}blogposts" );
		while( $row = $this->db->assoc($posts) )
		{
			$comments = $this->db->quick_query( "SELECT COUNT(comment_id) count FROM {$this->pre}blogcomments
				WHERE comment_post={$row['post_id']} AND comment_type=" . COMMENT_BLOG );
			if( $comments['count'] && $comments['count'] > 0 )
				$this->db->query( "UPDATE {$this->pre}blogposts SET post_comment_count={$comments['count']} WHERE post_id={$row['post_id']}" );
			else
				$this->db->query( "UPDATE {$this->pre}blogposts SET post_comment_count=0 WHERE post_id={$row['post_id']}" );
		}

		$images = $this->db->query( "SELECT photo_id FROM {$this->pre}photogallery" );
		while( $row = $this->db->assoc($images) )
		{
			$comments = $this->db->quick_query( "SELECT COUNT(comment_id) count FROM {$this->pre}blogcomments
				WHERE comment_post={$row['photo_id']} AND comment_type=" . COMMENT_GALLERY );
			if( $comments['count'] && $comments['count'] > 0 )
				$this->db->query( "UPDATE {$this->pre}photogallery SET photo_comment_count={$comments['count']} WHERE photo_id={$row['photo_id']}" );
			else
				$this->db->query( "UPDATE {$this->pre}photogallery SET photo_comment_count=0 WHERE photo_id={$row['photo_id']}" );
		}

		$downloads = $this->db->query( "SELECT file_id FROM {$this->pre}filelist" );
		while( $row = $this->db->assoc($downloads) )
		{
			$comments = $this->db->quick_query( "SELECT COUNT(comment_id) count FROM {$this->pre}blogcomments
				WHERE comment_post={$row['file_id']} AND comment_type=" . COMMENT_FILE );
			if( $comments['count'] && $comments['count'] > 0 )
				$this->db->query( "UPDATE {$this->pre}filelist SET file_comment_count={$comments['count']} WHERE file_id={$row['file_id']}" );
			else
				$this->db->query( "UPDATE {$this->pre}filelist SET file_comment_count=0 WHERE file_id={$row['file_id']}" );
		}
		return $this->message( 'Recount Comments', 'All comment counts have been corrected.', 'Continue', 'admin.php' );
	}

	/**
	 * Grabs the current list of table names in the database
	 *
	 * @author Roger Libiez [Samson] http://www.iguanadons.net
	 * @since 1.2
	 * @return array
	 **/
	function get_db_tables()
	{
		$tarray = array();

		// This looks a bit strange, but it will pull all of the proper prefixed tables.
		$tb = $this->db->query( "SHOW TABLES LIKE '{$this->pre}%%'" );
		while( $tb1 = $this->db->assoc($tb) )
		{
			foreach( $tb1 as $col => $data )
				$tarray[] = $data;
		}

		return $tarray;
	}

	function repair_tables()
	{
		$tables = implode( ', ', $this->get_db_tables() );

		$result = $this->db->query( 'REPAIR TABLE ' . $tables );

		$xtpl = new XTemplate( './skins/' . $this->skin . '/AdminCP/database.xtpl' );

		$xtpl->assign( 'header_text', 'Repair Database' );

		while ($row = $this->db->assoc($result))
		{
			foreach ($row as $col => $data)
			{
				$xtpl->assign( 'table_row_entry', htmlspecialchars($data) );
				$xtpl->parse( 'Database.Row.Entry' );
			}
			$xtpl->parse( 'Database.Row' );
		}

		$xtpl->parse( 'Database' );
		return $xtpl->text( 'Database' );
	}

	function opt_tables()
	{
		$this->title('Optimize Database');

		$tables = implode( ', ', $this->get_db_tables() );

		$result = $this->db->query( 'OPTIMIZE TABLE ' . $tables );

		$xtpl = new XTemplate( './skins/' . $this->skin . '/AdminCP/database.xtpl' );

		$xtpl->assign( 'header_text', 'Optimize Database' );

		while ($row = $this->db->assoc($result))
		{
			foreach ($row as $col => $data)
			{
				$xtpl->assign( 'table_row_entry', htmlspecialchars($data) );
				$xtpl->parse( 'Database.Row.Entry' );
			}
			$xtpl->parse( 'Database.Row' );
		}

		$xtpl->parse( 'Database' );
		return $xtpl->text( 'Database' );
	}

	function display_stats()
	{
		$post = $this->db->quick_query( "SELECT COUNT(post_id) count FROM {$this->pre}blogposts" );
		$comment = $this->db->quick_query( "SELECT COUNT(comment_id) count FROM {$this->pre}blogcomments" );
		$file = $this->db->quick_query( "SELECT COUNT(file_id) count FROM {$this->pre}filelist" );
		$pics = $this->db->quick_query( "SELECT COUNT(photo_id) count FROM {$this->pre}photogallery" );
		$spam = isset($this->settings['spam_count']) ? $this->settings['spam_count'] : 0;
		$espam = isset($this->settings['email_spam_count']) ? $this->settings['email_spam_count'] : 0;
		$uspam = isset($this->settings['register_spam_count']) ? $this->settings['register_spam_count'] : 0;
		$ham = isset($this->settings['ham_count']) ? $this->settings['ham_count'] : 0;
		$false_neg = isset($this->settings['spam_uncaught']) ? $this->settings['spam_uncaught'] : 0;
		$users = $this->db->quick_query( "SELECT COUNT(user_id) count FROM {$this->pre}users" );

		$total_comments = $comment['count'] + $spam;
		$pct_spam = null;
		if( $total_comments > 0 && $spam > 0 ) {
			$percent = floor(( $spam / $total_comments ) * 100);

			$pct_spam = ", {$percent}";
		}

		$active = $this->db->query( "SELECT * FROM {$this->pre}active" );

		$xtpl = new XTemplate( './skins/' . $this->skin . '/AdminCP/stats.xtpl' );

		$xtpl->assign( 'user_count', $users['count'] );
		$xtpl->assign( 'post_count', $post['count'] );
		$xtpl->assign( 'total_comments', $total_comments );
		$xtpl->assign( 'pct_spam', $pct_spam );
		$xtpl->assign( 'spam', $spam );
		$xtpl->assign( 'ham', $ham );
		$xtpl->assign( 'false_neg', $false_neg );
		$xtpl->assign( 'espam', $espam );
		$xtpl->assign( 'uspam', $uspam );
		$xtpl->assign( 'file_count', $file['count'] );
		$xtpl->assign( 'pics_count', $pics['count'] );

		while( $user = $this->db->assoc( $active ) )
		{
			$xtpl->assign( 'ip', $user['active_ip'] );
			$xtpl->assign( 'agent', htmlspecialchars($user['active_user_agent']) );
			$xtpl->assign( 'date', date( $this->settings['blog_dateformat'], $user['active_time'] ) );
			$xtpl->assign( 'action', $user['active_action'] );

			$xtpl->parse( 'Stats.UserAgent' );
		}

		$xtpl->parse( 'Stats' );
		return $xtpl->text( 'Stats' );
	}

	function perform_sql()
	{
		$xtpl = new XTemplate( './skins/' . $this->skin . '/AdminCP/database.xtpl' );

		if ( !isset($this->post['submit']) )
		{
			$xtpl->assign( 'token', $this->generate_token() );
			$xtpl->assign( 'query', null );

			$xtpl->parse( 'QueryForm' );
			return $xtpl->text( 'QueryForm' );
		}

		if( !$this->is_valid_token() ) {
			return $this->error( 'Invalid or expired security token. Please go back, reload the form, and try again.' );
		}

		if( empty($this->post['sqlquery']) )
			return $this->message( 'SQL Query', 'You cannot supply an empty query.', 'Query Form', 'admin.php?a=sys&s=sql' );

		$result = $this->db->query( $this->post['sqlquery'], true );

		if( !$result ) {
			$xtpl->assign( 'error', $this->db->error() );
			$xtpl->parse( 'QueryForm.Error' );

			$xtpl->assign( 'token', $this->generate_token() );
			$xtpl->assign( 'query', $this->post['sqlquery'] );

			$xtpl->parse( 'QueryForm' );
			return $xtpl->text( 'QueryForm' );
		}

		$show_fields = true;
		$col_span = 0;
		while( $row = $this->db->assoc($result) )
		{
			if( $show_fields ) {
				foreach( $row as $field => $value ) {
					$xtpl->assign( 'result_field', htmlspecialchars($field) );
					$xtpl->parse( 'QueryResult.Field' );
					$col_span++;
				}
				$show_fields = false;
			}

			foreach( $row as $value ) {
				$xtpl->assign( 'result_row', htmlspecialchars($value) );
				$xtpl->parse( 'QueryResult.Row.Entry' );
			}
			$xtpl->parse( 'QueryResult.Row' );
		}

		$xtpl->assign( 'col_span', $col_span );
		$xtpl->assign( 'num_rows', $this->db->num_rows($result) );

		$xtpl->parse( 'QueryResult' );
		return $xtpl->text( 'QueryResult' );
	}
}
?>