<?php
/* Sandbox v0.5-1.0b http://sandbox.kiasyn.com
 * Copyright (c) 2006-2007 Sam O'Connor (Kiasyn)
 *
 * Additions to Sandbox after 1.0:
 * Copyright (c) 2007-2010
 * Roger Libiez [Samson] http://www.iguanadons.net
 *
 * Sandbox installer module. Based on QSF Portal installer module.
 * QSF Portal Copyright (c)2006-2007 The QSF Portal Team
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the authors be held liable for any damages arising from the
 * use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it freely,
 * subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not claim
 * that you wrote the original software. If you use this software in a product,
 * an acknowledgment in the product documentation is required.
 *
 * 2. Altered source versions must be plainly marked as such, and must not be
 * misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * 4. You must make an effort to notify the author (Sam O'Connor) at the email
 * address sandbox@kiasyn.com if you plan on publicly distributing a derivative
 * of this software, whether by email, download or a form of disk/disc.
 *
 * Notifying Roger Libiez is not required but would still be appreciated :)
 */

if ( !defined('SANDBOX_INSTALLER') ) {
	header('HTTP/1.0 403 Forbidden');
	die;
}

if ( isset( $_POST['db_type'] ) )
	$settings['db_type'] = $_POST['db_type'];

require_once '../lib/' . $settings['db_type'] . '.php';

function server_url()
{ 
   $proto = "http" .
	   ((isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == "on") ? "s" : "") . "://";
   $server = isset($_SERVER['HTTP_HOST']) ?
	   $_SERVER['HTTP_HOST'] : $_SERVER['SERVER_NAME'];
   return $proto . $server;
}

if (!isset($_GET['step'])) {
	$step = 1;
} else {
	$step = $_GET['step'];
}

function save_settings($settings, $db)
{
	$default_settings = array( 'db_host', 'db_user', 'db_pass', 'db_name', 'db_pre', 'db_type', 'error_email' );
	$save_sets = array();
	foreach( $settings as $set => $val )
		if ( !in_array( $set, $default_settings ) )
			$save_sets[$set] = $val;

	$db_set = $db->escape(serialize($save_sets));
	$db->query( "UPDATE {$settings['db_pre']}settings SET settings_value='$db_set' LIMIT 1" );

	$file = "<?php
if ( !defined('SANDBOX') ) {
	header('HTTP/1.0 403 Forbidden');
	die;
}
\$settings = array(
	'db_host'	=> '{$settings['db_host']}',
	'db_user'	=> '{$settings['db_user']}',
	'db_pass'	=> '{$settings['db_pass']}',
	'db_name'	=> '{$settings['db_name']}',
	'db_pre'	=> '{$settings['db_pre']}',
	'db_type'	=> '{$settings['db_type']}',
	'error_email'	=> '{$settings['error_email']}'
	);
?>";

	$fp = @fopen("../settings.php", 'w');

	if (!$fp) {
		return false;
	}

	if (!@fwrite($fp, $file)) {
		return false;
	}

	fclose($fp);
	return true;
}

switch( $step )
{
default:
$url = preg_replace('/install\/?$/i', '', server_url() . dirname($_SERVER['PHP_SELF']));

echo "<form action='{$self}?mode=new&amp;step=2' method='post'>
 <div class='article'>
  <div class='title'>New Sandbox Installation</div>
  <div class='subtitle'>Directory Permissions</div>";

  check_writeable_files();

echo "    <p></p>
  <div class='subtitle'>Database Configuration</div>

  <span class='field'>Host Server:</span>
  <span class='form'><input class='input' type='text' name='db_host' value='{$settings['db_host']}' /></span>
  <p class='line'></p>

  <span class='field'>Database Type:</span>
  <span class='form'>
   <select class='input' name='db_type'>";

  if (extension_loaded('mysqli')) {
    if( $settings['db_type'] == 'mysqli' )
      echo "<option value='mysqli' selected='selected'>MySQLi</option>";
    else
      echo "<option value='mysqli'>MySQLi</option>";
  }
  echo "<option value='mysql'>MySQL</option>
   </select>
  </span>
  <p class='line'></p>

  <span class='field'>Database Name:</span>
  <span class='form'><input class='input' type='text' name='db_name' value='{$settings['db_name']}' /></span>
  <p class='line'></p>

  <span class='field'>Database Username:</span>
  <span class='form'><input class='input' type='text' name='db_user' value='{$settings['db_user']}' /></span>
  <p class='line'></p>

  <span class='field'>Database Password:</span>
  <span class='form'><input class='input' type='password' name='db_pass' value='' /></span>
  <p class='line'></p>

  <span class='field'>Table Prefix:</span>
  <span class='form'>
   <input class='input' type='text' name='db_pre' value='{$settings['db_pre']}' /><br />
   This should only be changed if you need to install multiple Sandbox sites in the same database.
  </span>
  <p></p>

  <div class='subtitle'>New Site Settings</div>

  <span class='field'>Site Name:</span>
  <span class='form'><input class='input' type='text' name='site_name' value='Sandbox' size='75' /></span>
  <p class='line'></p>

  <span class='field'>Site URL:</span>
  <span class='form'><input class='input' type='text' name='site_url' value='{$url}' size='75' /></span>
  <p></p>

  <div class='subtitle'>Administrator Account Settings</div>

  <span class='field'>User Name:</span>
  <span class='form'><input class='input' type='text' name='admin_name' size='30' maxlength='30' /></span>
  <p class='line'></p>

  <span class='field'>User Password:</span>
  <span class='form'><input class='input' type='password' name='admin_pass' size='30' /></span>
  <p class='line'></p>

  <span class='field'>Password (confirmation):</span>
  <span class='form'><input class='input' type='password' name='admin_pass2' size='30' /></span>
  <p class='line'></p>

  <span class='field'>Contact Email:</span>
  <span class='form'>
   <input class='input' type='text' name='contact_email' size='50' maxlength='100' />
   This is where contact form emails and error messages are sent.
  </span>
  <p class='line'></p>

  <span class='field'>System Email:</span>
  <span class='form'>
   <input class='input' type='text' name='admin_email' size='50' maxlength='100' />
   Address used by the system to send mail. Can be fake if desired.
  </span>
  <p class='line'></p>

  <div style='text-align:center'><input type='submit' name='submit' value='Continue' /></div>
 </div>
</form>";
break;

case 2:
	$settings['db_host'] = $_POST['db_host'];
	$settings['db_user'] = $_POST['db_user'];
	$settings['db_pass'] = $_POST['db_pass'];
	$settings['db_name'] = $_POST['db_name'];
	$settings['db_type'] = $_POST['db_type'];
	$settings['db_pre']  = trim(preg_replace('/[^a-zA-Z0-9_]/', '', $_POST['db_pre']));

	$db = new database($settings['db_host'], $settings['db_user'], $settings['db_pass'], $settings['db_name'], $settings['db_pre']);

	if (!$db->dbconn) {
		echo "Couldn't connect to a database using the specified information.";
		break;
	}

	if(!is_writeable("../settings.php"))
	{
		echo "Cannot write to settings.php file. Please change the permissions to at least 0666, then go back and try again.";
		break;
	}

	if (!is_readable("sql_queries.php")) {
		echo "Unable to read queries file: sql_queries.php";
		break;
	}

	if ((trim($_POST['admin_name']) == '')
	|| (trim($_POST['admin_pass']) == '')
	|| (trim($_POST['admin_email']) == '')) {
		echo "You have not specified an admistrator account. Please go back and correct this error.";
		break;
	}

	if ($_POST['admin_pass'] != $_POST['admin_pass2']) {
		echo "Your administrator passwords do not match. Please go back and correct this error.";
		break;
	}

	$settings['site_name'] = $_POST['site_name'];

	if( !empty($_POST['site_url']) && $_POST['site_url'][strlen($_POST['site_url'])-1] != '/' )
		$_POST['site_url'] = $_POST['site_url'] . '/';
	$settings['site_address'] = $_POST['site_url'];

	$settings['site_meta'] = 'Personal websites made easy.';
	$settings['site_keywords'] = 'blog,gallery,downloads,personal website';
	$settings['email_adm'] = $_POST['contact_email'];
	$settings['error_email'] = $_POST['contact_email'];
	$settings['email_sys'] = $_POST['contact_email'];
	$settings['site_open'] = true;
 	$settings['site_closedmessage'] = 'This site is currently down for maintenance.';
	$settings['site_defaultskin'] = 'Default';
	$settings['site_analytics'] = '';
	$settings['wordpress_api_key'] = '';
	$settings['copyright_terms'] = '';
	$settings['footer_text'] = '';
	$settings['page_links']	= array(
			'Home'		=> '/',
			'Gallery'	=> 'index.php?a=gallery',
			'Downloads' 	=> 'index.php?a=downloads',
			'Contact'	=> 'index.php?a=contact' );
	$settings['blog_postsperpage'] = 5;
	$settings['blog_avatar'] = 'sandbox.jpg';
	$settings['blog_dateformat'] = 'M j, Y g:i a';
	$settings['blog_autoclose'] = 90;
	$settings['blog_notifycomments'] = true;
	$settings['blog_icon_width'] = 40;
	$settings['blog_icon_height'] = 40;
	$settings['site_owner'] = $_POST['admin_name'];
	$settings['blog_signature_on'] = true;
	$settings['cookie_prefix'] = 'sandbox_';
	$settings['cookie_path'] = '/';
	$settings['cookie_domain'] = '';
	$settings['cookie_logintime'] = 31536000;
	$settings['cookie_secure'] = false;
	$settings['html_email'] = false;
	$settings['spam_count'] = 0;
	$settings['email_spam_count'] = 0;
	$settings['ham_count'] = 0;
	$settings['spam_uncaught'] = 0;
	$settings['friendly_urls'] = false;
	$settings['site_pings'] = array();
	$settings['sidebar_avatar'] = true;
	$settings['sidebar_search'] = true;
	$settings['sidebar_calendar'] = true;
	$settings['sidebar_comments'] = true;
	$settings['sidebar_blogroll'] = true;
	$settings['sidebar_categories'] = true;
	$settings['sidebar_images'] = true;
	$settings['banned_ips'] = array();
	$settings['user_count'] = 1;
	$settings['gallery_thumb_w'] = 180;
	$settings['gallery_thumb_h'] = 180;
	$settings['register_spam_count'] = 0;
	$settings['global_announce'] = '';
	$settings['sidebar_comments_count'] = 5;
	$settings['sidebar_images_count'] = 5;
	$settings['rss_enabled'] = true;
	$settings['rss_name'] = $_POST['site_name'];
	$settings['rss_description'] = '';
	$settings['rss_image_url'] = '';
	$settings['rss_items'] = 10;
	$settings['rss_refresh'] = 60;

	$queries = array();
	$pre = $settings['db_pre'];

	// Create tables
	include "./sql_queries.php";
	execute_queries($queries, $db);
	$queries = null;

	save_settings($settings, $db);

	$name = $db->escape( $_POST['admin_name'] );
	$pass = hash( 'sha256', $_POST['admin_pass'] );
	$email = $db->escape( $_POST['contact_email'] );
	$time = time();
	$db->query( "INSERT INTO {$pre}users (user_name, user_password, user_email, user_level, user_perms, user_joined) VALUES( '$name', '$pass', '$email', 5, 7, $time )" );

	$id = $db->insert_id();
	setcookie($settings['cookie_prefix'] . 'user', $id, $time + $settings['cookie_logintime'], $settings['cookie_path'], $settings['cookie_domain'], $settings['cookie_secure'], true );
	setcookie($settings['cookie_prefix'] . 'pass', $pass, $time + $settings['cookie_logintime'], $settings['cookie_path'], $settings['cookie_domain'], $settings['cookie_secure'], true );

	echo "
<div class='article'>
 <div class='title'>Installation Successful!</div>
 Your Sandbox site is now installed. <a href=\"{$settings['site_address']}\">Click here</a> to go there now.<br />
 Or <a href=\"{$settings['site_address']}admin.php\">Click here</a> to go directly to the AdminCP.<br />
 <span style='color:red'>Please DELETE THE INSTALL DIRECTORY NOW for security purposes!!</span>
</div>";
}
?>