<?php
/* Sandbox v0.5-1.0b
 * Copyright (c) 2006-2007
 * Sam O'Connor (Kiasyn) http://www.kiasyn.com
 *
 * Additions to Sandbox after 1.0:
 * Copyright (c) 2007-2010
 * Roger Libiez [Samson] http://www.iguanadons.net
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the authors be held liable for any damages arising from the
 * use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it freely,
 * subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not claim
 * that you wrote the original software. If you use this software in a product,
 * an acknowledgment in the product documentation is required.
 *
 * 2. Altered source versions must be plainly marked as such, and must not be
 * misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * 4. You must make an effort to notify the author (Sam O'Connor) at the email
 * address sandbox@kiasyn.com if you plan on publicly distributing a derivative
 * of this software, whether by email, download or a form of disk/disc.
 *
 * Notifying Roger Libiez is not required but would still be appreciated :)
 */

if ( !defined('SANDBOX') ) {
	header('HTTP/1.0 403 Forbidden');
	die;
}

require_once './lib/sidebar.php';

class register extends module
{
	function execute()
	{
		if (!isset($this->post['submit'])) {
			$xtpl = new XTemplate( './skins/' . $this->skin . '/register.xtpl' );

			$SideBar = new sidebar($this);
			$xtpl->assign( 'sidebar', $SideBar->build_sidebar() );
			$xtpl->assign( 'token', $this->generate_token() );

			if( !empty($this->settings['wordpress_api_key']) ) {
				$xtpl->parse( 'Registration.Akismet' );
			}

			$xtpl->parse( 'Registration' );
			return $xtpl->text( 'Registration' );
		}

		if( !$this->is_valid_token() ) {
			return $this->message( 'New User Registration', 'Cookies are not being accepted by your browser. Please adjust your privacy settings, then go back and try again.' );
		}

		if ( !$this->valid_user( $this->post['user_name'] ) )
			return $this->message( 'New User Registration', 'User name contains illegal characters.' );

		if ( !$this->is_email( $this->post['user_email'] ) )
			return $this->message( 'New User Registration', 'User email contains illegal characters.' );

		$name = $this->db->escape( $this->post['user_name'] );
		$email = $this->db->escape( $this->post['user_email'] );
		$url = $this->db->escape( $this->post['user_url'] );
		$pass = $this->generate_pass(8);
		$dbpass = hash( 'sha256', $pass );

		$prev_user = $this->db->quick_query( "SELECT user_id FROM {$this->pre}users WHERE user_name='$name'" );
		if( $prev_user )
			return $this->message( 'New User Registration', 'A user by that name has already registered here.' );

		$prev_email = $this->db->quick_query( "SELECT user_id FROM {$this->pre}users WHERE user_email='$email'" );
		if( $prev_email )
			return $this->message( 'New User Registration', 'A user with that email address has already registered here.' );

		require_once( 'lib/akismet.php' );
		$spam_checked = false;

		try {
			$akismet = new Akismet($this->settings['site_address'], $this->settings['wordpress_api_key']);

			$akismet->setCommentAuthor($this->post['user_name']);
			$akismet->setCommentAuthorEmail($this->post['user_email']);
			$akismet->setCommentAuthorURL($this->post['user_url']);
			$akismet->setCommentContent($this->post['user_regcomment']);
			$akismet->setCommentType('registration');

			$spam_checked = true;
		}
		// Try and deal with it rather than say something.
		catch(Exception $e) {}

		if( $spam_checked && $akismet->isCommentSpam() ) {
			$this->settings['register_spam_count']++;
			$this->save_settings();
			return $this->message( 'Registration Failure', 'Information provided during registration has been flagged by Akismet as a spam source. You will need to find another means of contacting the administration if you wish to register.' );
		}

		$this->settings['user_count']++;
		$this->save_settings();

		$level = USER_MEMBER;
		$perms = PERM_URL | PERM_SIG | PERM_ICON;
		$this->db->query( "INSERT INTO {$this->pre}users (user_name, user_password, user_email, user_url, user_level, user_perms, user_joined)
				   VALUES( '$name', '$dbpass', '$email', '$url', $level, $perms, $this->time )" );

		$headers = "From: {$this->settings['site_name']} <{$this->settings['email_sys']}>\r\n" . "X-Mailer: PHP/" . phpversion();
		$subject = 'New account creation';
		$message = "A new account has been registered for you at {$this->settings['site_name']}: {$this->settings['site_address']}\n\n";
		$message .= "Your user name is: {$this->post['user_name']}\n";
		$message .= "Your temporary password is: $pass\n\n";
		$message .= 'Please write this information down as you will need it in order to log on to the site. You should change this password at your earliest convenience to something you will more easily remember. ';
		$message .= 'You will be able to make any changes to your user profile once you log on the first time.';

		mail( $this->post['user_email'], '[' . $this->settings['site_name'] . '] ' . str_replace( '\n', '\\n', $subject ), $message, $headers );

		$headers = "From: {$this->settings['site_name']} <{$this->settings['email_sys']}>\r\n" . "X-Mailer: PHP/" . phpversion();
		$subject = 'New user signup';
		$message = "A new user has signed up at {$this->settings['site_name']} named {$this->post['user_name']}\n";

		mail( $this->settings['email_adm'], '[' . $this->settings['site_name'] . '] ' . str_replace( '\n', '\\n', $subject ), $message, $headers );

		return $this->message( 'New User Registration', 'Your new account has been created. An email is being send to the address you provided with your temporary password.', 'Continue', '/' );
	}
}
?>