<?php

/**
 * i-doit
 *
 * UI: global category for Check_MK.
 *
 * @package     Modules
 * @subpackage  Check_MK
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.0
 */
class isys_cmdb_ui_category_g_cmk_tag extends isys_cmdb_ui_category_global
{
    /**
     * Gets the template file.
     *
     * @return  string
     */
    public function get_template()
    {
        return isys_module_check_mk::get_tpl_dir() . 'modules/cmdb/catg__cmk_tag.tpl';
    }

    /**
     * Processes the UI for the category check_mk.
     *
     * @param isys_cmdb_dao_category $p_cat
     *
     * @return  void
     * @throws  Exception
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function process(isys_cmdb_dao_category $p_cat)
    {
        $template = $this->get_template_component();
        $l_catdata = $p_cat->get_general_data();
        $l_rules = [];
        $cmdbTags = false;
        $dynamicTags = false;

        $this->fill_formfields($p_cat, $l_rules, $l_catdata);

        try {
            $rawCmdbTags = $p_cat->dynamic_property_callback_cmdb_tags($p_cat->get_object_id(), $p_cat->get_object_type_id());

            if (count($rawCmdbTags)) {
                $cmdbTags = isys_factory::get_instance('isys_smarty_plugin_f_dialog_list')
                    ->navigation_view($template, [
                        'name'     => 'cmdb_tags',
                        'p_arData' => $rawCmdbTags
                    ]);
            }
        } catch (Exception $e) {
            isys_notify::error($e->getMessage(), ['sticky' => true]);
        }

        try {
            $rawDynamicTags = $p_cat->dynamic_property_callback_dynamic_tags($p_cat->get_object_id());

            if (count($rawDynamicTags)) {
                $dynamicTags = isys_factory::get_instance('isys_smarty_plugin_f_dialog_list')
                    ->navigation_view($this->get_template_component(), [
                        'name'     => 'dynamic_tags',
                        'p_arData' => $rawDynamicTags
                    ]);
            }
        } catch (Exception $e) {
            isys_notify::error($e->getMessage(), ['sticky' => true]);
        }

        $template->assign('dynamic_tags', $dynamicTags)
            ->assign('cmdb_tags', $cmdbTags)
            ->smarty_tom_add_rules("tom.content.bottom.content", $l_rules);
    }
}