<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

use idoit\Module\Nagios\Console\Command\NagiosCommand;
use idoit\Module\Nagios\Console\Command\NagiosExportCommand;

/**
 * Class isys_model_console_nagios
 */
class isys_api_model_console_nagios extends isys_api_model_console
{
    /**
     * Export
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function export(array $params = [])
    {
        // Check whether command exists
        $this->commandExists(NagiosExportCommand::class);

        return $this->run(NagiosExportCommand::NAME, $params['options'], $params['arguments']);
    }

    /**
     * NdoUtils
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function ndoUtils(array $params = [])
    {
        // Check whether command exists
        $this->commandExists(NagiosCommand::class);

        return $this->run(NagiosCommand::NAME, $params['options'], $params['arguments']);
    }
}