<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

use idoit\Module\Workflow\Console\Command\HandleWorkflowsCommand;

/**
 * Class isys_model_console_workflow
 */
if (class_exists('isys_api_model_console')) {
    class isys_api_model_console_workflow extends isys_api_model_console
    {
        /**
         * Clean authentication cache
         *
         * @param array $params
         *
         * @return array
         * @throws Exception
         */
        public function process(array $params = [])
        {
            // Check whether command exists
            $this->commandExists(HandleWorkflowsCommand::class);

            return $this->run(HandleWorkflowsCommand::NAME, $params['options'], $params['arguments']);
        }
    }
}
