<?php

/**
 * i-doit
 *
 * Event class
 *
 * @package    i-doit
 * @subpackage Events
 * @author     Dennis Stücken <dstuecken@i-doit.org> 2006-07-24
 * @version    1.0
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_event_task_information extends isys_event_task
{

    /**
     * @var null
     */
    private $m_end_time = null;

    /**
     * @var null
     */
    private $m_enddate = null;

    /**
     * @var null
     */
    private $m_startdate = null;

    /**
     * @var null
     */
    private $m_task_description = null;

    /**
     * @desc handle notification
     *
     * @return bool
     */
    public function handle_event()
    {
        $this->set_initiator();
        $this->set_email($this->get_initiator_email());

        isys_application::instance()->template->assign("g_end_time", $this->m_end_time)
            ->assign("g_startdate", $this->m_startdate)
            ->assign("g_enddate", $this->m_enddate)
            ->assign("g_task_description", $this->m_task_description);

        return $this->_mail();
    }

    /**
     * @param      $p_workflow_id
     * @param null $p_email
     * @param null $p_cc
     * @param null $p_processor
     * @param null $p_end_time
     * @param null $p_startdate
     * @param null $p_enddate
     * @param null $p_task_description
     */
    public function __construct(
        $p_workflow_id,
        $p_email = null,
        $p_cc = null,
        $p_processor = null,
        $p_end_time = null,
        $p_startdate = null,
        $p_enddate = null,
        $p_task_description = null
    ) {
        parent::__construct();

        $l_session = isys_application::instance()->session->get_session_data();

        $this->m_end_time = $p_end_time;
        $this->m_startdate = $p_startdate;
        $this->m_enddate = $p_enddate;
        $this->m_task_description = $p_task_description;

        $this->init(C__EMAIL_TEMPLATE__TASK__BEFORE_ENDDATE, $p_workflow_id, 0,
            (empty($p_processor)) ? isys_component_dao_user::instance(isys_application::instance()->database)
                ->get_user_title($l_session["isys_user_session__isys_obj__id"]) : $p_processor, $p_email, $p_cc);
    }
}
