<?php
/**
 * @version   $Version
 * @author    Viviane Götzen <vgoetzen@synetics.de>
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */

if (isys_module_manager::instance()
    ->is_active('workflow')) {
    define("C__WF__VIEW__LIST", 4001);
    define("C__WF__VIEW__LIST_WF_TYPE", 4010);
    define("C__WF__VIEW__LIST_TEMPLATE", 4011);
    define("C__WF__VIEW__LIST_FILTER", 4012);
    define("C__WF__VIEW__DETAIL__SELECTOR", 4050);
    define("C__WF__VIEW__DETAIL__GENERIC", 4051);
    define("C__WF__VIEW__DETAIL__WF_TYPE", 4060);
    define("C__WF__VIEW__DETAIL__TEMPLATE", 4061);
    define("C__WF__VIEW__DETAIL__EMAIL_GUI", 4062);
    define("C__WF__VIEW__TREE", 4101);

    define("C__WF__GET__ID", "wid");
    define("C__WF__GET__TYPE", "wtype");
    define("C__WF__GET__TEMPLATE", "wtpl");
    define("C__WORKFLOW__GET__FILTER", "fltr");

    define("C__WF__PARAMETER_TYPE__INT", 1);
    define("C__WF__PARAMETER_TYPE__STRING", 2);
    define("C__WF__PARAMETER_TYPE__TEXT", 3);
    define("C__WF__PARAMETER_TYPE__DATETIME", 4);
    define("C__WF__PARAMETER_TYPE__YES_NO", 5);

    // E-Mail bitmasks (matched with tenant settings: isys_tenantsettings::get('workflow.notify')).
    define("C__WORKFLOW__MAIL__NOTIFICATION", 1 << 0);
    define("C__WORKFLOW__MAIL__ACCEPTED", 1 << 1);
    define("C__WORKFLOW__MAIL__OPEN", 1 << 2);
    define("C__WORKFLOW__MAIL__COMPLETED", 1 << 3);

    //load autoloader to create namespaces
    if (class_exists('\idoit\Psr4AutoloaderClass')) {
        \idoit\Psr4AutoloaderClass::factory()
            ->addNamespace('idoit\Module\Workflow', __DIR__ . '/src/');
    }

    if (include_once('isys_module_workflow_autoload.class.php')) {
        spl_autoload_register('isys_module_workflow_autoload::init');
    } // if

    // Handle module specific language files.
    global $g_comp_session;

    // Register CLI controller.
    $GLOBALS['g_controller']['handler']['workflow'] = ['class' => 'isys_handler_workflow'];

    if (file_exists(__DIR__ . '/lang/' . $g_comp_session->get_language() . '.inc.php')) {
        $l_language = include_once(__DIR__ . '/lang/' . $g_comp_session->get_language() . '.inc.php');
        if (is_array($l_language)) {
            global $g_comp_template_language_manager;
            $g_comp_template_language_manager->append_lang($l_language);
        } // if
    } // if

    isys_usersettings::extend([
        'LC__CMDB__CATG__WORKFLOW' => [
            'workflows.max-checklist-entries' => [
                'title'       => 'LC__USER_SETTINGS__CHECKLIST_LIMIT',
                'type'        => 'int',
                'placeholder' => 7
            ]
        ]
    ]);

    isys_register::factory('additional-dialog-admin-tables')
        ->set('isys_workflow_category');
} //if
