<?php

/**
 * i-doit
 *
 * Workflow module class
 *
 * @package     Modules
 * @subpackage  Workflow
 * @version     1.0.0
 * @author      Viviane Götzen <vgoetzen@synetics.de>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_workflow_autoload extends isys_module_manager_autoload
{
    /**
     * Module specific autoloader.
     *
     * @param   string  $p_classname
     * @return  boolean
     */
    public static function init ($p_classname)
    {
        $l_classlist = [
            'isys_workflow' => '/src/classes/modules/workflow/isys_workflow.class.php',
            'isys_workflow_action' => '/src/classes/modules/workflow/action/isys_workflow_action.class.php',
            'isys_workflow_action_accept' => '/src/classes/modules/workflow/action/isys_workflow_action_accept.class.php',
            'isys_workflow_action_assign' => '/src/classes/modules/workflow/action/isys_workflow_action_assign.class.php',
            'isys_workflow_action_cancel' => '/src/classes/modules/workflow/action/isys_workflow_action_cancel.class.php',
            'isys_workflow_action_complete' => '/src/classes/modules/workflow/action/isys_workflow_action_complete.class.php',
            'isys_workflow_action_new' => '/src/classes/modules/workflow/action/isys_workflow_action_new.class.php',
            'isys_workflow_action_notification' => '/src/classes/modules/workflow/action/isys_workflow_action_notification.class.php',
            'isys_workflow_action_parameter' => '/src/classes/modules/workflow/action/isys_workflow_action_parameter.class.php',
            'isys_workflow_dao' => '/src/classes/modules/workflow/dao/isys_workflow_dao.class.php',
            'isys_workflow_dao_action' => '/src/classes/modules/workflow/dao/isys_workflow_dao_action.class.php',
            'isys_workflow_dao_dynamic' => '/src/classes/modules/workflow/dao/isys_workflow_dao_dynamic.class.php',
            'isys_workflow_dao_list' => '/src/classes/modules/workflow/dao/list/isys_workflow_dao_list.class.php',
            'isys_workflow_dao_list_filter' => '/src/classes/modules/workflow/dao/list/isys_workflow_dao_list_filter.class.php',
            'isys_workflow_dao_list_generic' => '/src/classes/modules/workflow/dao/list/isys_workflow_dao_list_generic.class.php',
            'isys_workflow_dao_list_template' => '/src/classes/modules/workflow/dao/list/isys_workflow_dao_list_template.class.php',
            'isys_workflow_dao_list_wf_type' => '/src/classes/modules/workflow/dao/list/isys_workflow_dao_list_wf_type.class.php',
            'isys_workflow_dao_template' => '/src/classes/modules/workflow/dao/isys_workflow_dao_template.class.php',
            'isys_workflow_dao_type' => '/src/classes/modules/workflow/dao/isys_workflow_dao_type.class.php',
            'isys_workflow_data' => '/src/classes/modules/workflow/isys_workflow_data.class.php',
            'isys_workflow_list' => '/src/classes/modules/workflow/isys_workflow_list.class.php',
            'isys_workflow_request' => '/src/classes/modules/workflow/isys_workflow_request.class.php',
            'isys_workflow_status_map' => '/src/classes/modules/workflow/isys_workflow_status_map.class.php',
            'isys_workflow_view' => '/src/classes/modules/workflow/view/isys_workflow_view.class.php',
            'isys_workflow_view_detail' => '/src/classes/modules/workflow/view/isys_workflow_view_detail.class.php',
            'isys_workflow_view_detail_email_gui' => '/src/classes/modules/workflow/view/isys_workflow_view_detail_email_gui.class.php',
            'isys_workflow_view_detail_generic' => '/src/classes/modules/workflow/view/isys_workflow_view_detail_generic.class.php',
            'isys_workflow_view_detail_selector' => '/src/classes/modules/workflow/view/isys_workflow_view_detail_selector.class.php',
            'isys_workflow_view_detail_template' => '/src/classes/modules/workflow/view/isys_workflow_view_detail_template.class.php',
            'isys_workflow_view_detail_wf_type' => '/src/classes/modules/workflow/view/isys_workflow_view_detail_wf_type.class.php',
            'isys_workflow_view_list' => '/src/classes/modules/workflow/view/isys_workflow_view_list.class.php',
            'isys_workflow_view_list_filter' => '/src/classes/modules/workflow/view/isys_workflow_view_list_filter.class.php',
            'isys_workflow_view_list_handler' => '/src/classes/modules/workflow/view/isys_workflow_view_list_handler.class.php',
            'isys_workflow_view_list_template' => '/src/classes/modules/workflow/view/isys_workflow_view_list_template.class.php',
            'isys_workflow_view_list_wf_type' => '/src/classes/modules/workflow/view/isys_workflow_view_list_wf_type.class.php',
            'isys_workflow_view_tree' => '/src/classes/modules/workflow/view/isys_workflow_view_tree.class.php',
            'isys_cmdb_dao_category_g_workflow' => '/src/classes/modules/workflow/cmdb/dao/category/global/isys_cmdb_dao_category_g_workflow.class.php',
            'isys_cmdb_dao_list_catg_workflow' => '/src/classes/modules/workflow/cmdb/dao/list/isys_cmdb_dao_list_catg_workflow.class.php',
            'isys_cmdb_ui_category_g_workflow' => '/src/classes/modules/workflow/cmdb/ui/global/isys_cmdb_ui_category_g_workflow.class.php',
            'isys_handler_workflow' => '/src/classes/modules/workflow/handler/controller/isys_handler_workflow.class.php',
            'isys_popup_workflow' => '/src/classes/modules/workflow/popup/isys_popup_workflow.class.php',
            'isys_event' => '/src/classes/modules/workflow/event/isys_event.class.php',
            'isys_event_manager' => '/src/classes/modules/workflow/event/isys_event_manager.class.php',
            'isys_event_task' => '/src/classes/modules/workflow/event/task/isys_event_task.class.php',
            'isys_event_task_accept' => '/src/classes/modules/workflow/event/task/isys_event_task_accept.class.php',
            'isys_event_task_closed' => '/src/classes/modules/workflow/event/task/isys_event_task_closed.class.php',
            'isys_event_task_completion_accepted' => '/src/classes/modules/workflow/event/task/isys_event_task_completion_accepted.class.php',
            'isys_event_task_information' => '/src/classes/modules/workflow/event/task/isys_event_task_information.class.php',
            'isys_event_task_new' => '/src/classes/modules/workflow/event/task/isys_event_task_new.class.php',
            'isys_event_task_notification' => '/src/classes/modules/workflow/event/task/isys_event_task_notification.class.php',
            'isys_event_task_open' => '/src/classes/modules/workflow/event/task/isys_event_task_open.class.php',
            'isys_api_model_cmdb_workflow' => '/src/classes/modules/workflow/api/isys_api_model_cmdb_workflow.class.php',
            'isys_api_model_console_workflow' => '/src/classes/modules/workflow/api/isys_api_model_console_workflow.class.php',
            'isys_auth_workflow' => '/src/classes/modules/workflow/auth/isys_auth_workflow.class.php',
            'isys_workflow_event_manager' => '/src/classes/modules/workflow/event/isys_workflow_event_manager.class.php',
        ];

        if (isset($l_classlist[$p_classname]))
        {
            if (parent::include_file($l_classlist[$p_classname]))
            {
                isys_caching::factory('autoload')->set($p_classname, $l_classlist[$p_classname]);

                return true;
            } // if
        } // if

        return false;
    } // function
}
