<?php

/**
 * i-doit
 *
 * Workflow Popup for creating workflows with an ajax request or popup
 *
 * @deprecated
 * @todo       Clean-up! This popup is beeing used to display parameter details, when creating a new workflow and selecting a type.
 * @package    i-doit
 * @subpackage Popups
 * @author     Dennis Stücken <dstuecken@synetics.de>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_popup_workflow extends isys_component_popup
{
    /**
     *
     * @return string
     */
    public function retrievePopupUrl()
    {
        return '?mod=cmdb&popup=workflow';
    }

    /**
     * @param isys_module_request $p_modreq
     * @param bool                $p_module_request
     *
     * @throws Exception
     */
    public function &handle_ajax_request(isys_module_request $p_modreq, $p_module_request = false)
    {
        $this->handle($p_modreq, $p_module_request);
    }

    /**
     * @param isys_module_request $p_modreq
     *
     * @return isys_component_template|void
     * @throws Exception
     */
    public function &handle_module_request(isys_module_request $p_modreq)
    {
        $this->handle($p_modreq, false);
    }

    /**
     * @param isys_module_request $p_modreq
     * @param                     $p_module_request
     *
     * @return isys_component_template
     * @throws Exception
     */
    public function handle(isys_module_request $p_modreq, $p_module_request)
    {
        // Unpack module request.
        $l_gets = $p_modreq->get_gets();

        // Get dao for template handler.
        $l_workflow_template = new isys_workflow_dao_template($this->database);
        $l_workflow_type_dao = new isys_workflow_dao_type($this->database);

        $l_wf_tmp = $l_workflow_type_dao->get_workflow_types($l_gets[C__WF__GET__TYPE]);

        if (count($l_wf_tmp)) {
            $l_dao_wf = new isys_workflow_dao($this->database);
            $l_workflow_type = $l_wf_tmp->get_row();

            $this->template->assign('g_occurrence', $l_workflow_type['isys_workflow_type__occurrence'])
                ->assign('g_occurrence_data', $l_dao_wf->get_occurrence_data());
        }

        $this->template->assign('g_template_parameter', $l_workflow_template->get_template_parameter($l_gets[C__WF__GET__TYPE]))
            ->assign('g_workflow_type', $l_gets[C__WF__GET__TYPE])
            ->assign('g_ar_yes_no', get_smarty_arr_YES_NO());

        if ($p_module_request) {
            return $this->template;
        }

        return $this->template->display(isys_module_workflow::getPath() . 'templates/detail/generic.tpl');
    }
}
