<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

use idoit\Console\Command\Cleanup\CleanupAuthCommand;
use idoit\Module\Api\Exception\JsonRpc\InternalErrorException;

/**
 * Class isys_model_console_auth
 */
class isys_api_model_console_auth extends isys_api_model_console
{
    /**
     * Clean authentication cache
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function cleanup(array $params = [])
    {
        // Check whether command exists
        $this->commandExists(CleanupAuthCommand::class);

        return $this->run(CleanupAuthCommand::NAME, $params['options'], $params['arguments']);
    }
}