<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

use idoit\Console\Command\Import\Csv\ImportCsvCommand;
use idoit\Console\Command\Import\Csv\ListProfilesCommand;
use idoit\Console\Command\Import\ImportCmdbCommand;
use idoit\Console\Command\Import\ImportInventoryCommand;
use idoit\Console\Command\Import\ImportOcsCommand;
use idoit\Console\Command\Syslog\ParseCommand;
use idoit\Module\JDisc\Console\Command\JDiscDiscoveryCommand;
use idoit\Module\JDisc\Console\Command\JDiscImportCommand;

/**
 * Class isys_model_console_import
 */
class isys_api_model_console_import extends isys_api_model_console
{
    /**
     * @todo Most of this commands needs physical files
     *       How should we handle this?
     */

    /**
     * CSV import
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function csv(array $params = [])
    {
        // Check whether command exists
        $this->commandExists(ImportCsvCommand::class);

        return $this->run(ImportCsvCommand::NAME, $params['options'], $params['arguments']);
    }

    /**
     * CSV profiles
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function csvprofiles(array $params = [])
    {
        // Check whether command exists
        $this->commandExists(ListProfilesCommand::class);

        return $this->run(ListProfilesCommand::NAME, $params['options'], $params['arguments']);
    }

    /**
     * hInventory
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function hinventory(array $params = [])
    {
        // Check whether command exists
        $this->commandExists(ImportInventoryCommand::class);

        return $this->run(ImportInventoryCommand::NAME, $params['options'], $params['arguments']);
    }

    /**
     * jDisc
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function jdisc(array $params = [])
    {
        // Check whether command exists
        $this->commandExists(JDiscImportCommand::class);

        return $this->run(JDiscImportCommand::NAME, $params['options'], $params['arguments']);
    }

    /**
     * jDisc discovery
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function jdiscdiscovery(array $params = [])
    {
        // Check whether command exists
        $this->commandExists(JDiscDiscoveryCommand::class);

        return $this->run(JDiscDiscoveryCommand::NAME, $params['options'], $params['arguments']);
    }

    /**
     * Ocs
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function ocs(array $params = [])
    {
        // Check whether command exists
        $this->commandExists(ImportOcsCommand::class);

        return $this->run(ImportOcsCommand::NAME, $params['options'], $params['arguments']);
    }

    /**
     * Syslog
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function syslog(array $params = [])
    {
        // Check whether command exists
        $this->commandExists(ParseCommand::class);

        return $this->run(ParseCommand::NAME, $params['options'], $params['arguments']);
    }

    /**
     * Xml
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function xml(array $params = [])
    {
        // Check whether command exists
        $this->commandExists(ImportCmdbCommand::class);

        return $this->run(ImportCmdbCommand::NAME, $params['options'], $params['arguments']);
    }
}