<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

use idoit\Console\Command\Idoit\IncrementConfigCommand;
use idoit\Console\Command\RegenerateRelationsCommand;

/**
 * Class isys_model_console_system
 */
class isys_api_model_console_system extends isys_api_model_console
{
    /**
     * Change global autoincrement value for everything!
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function autoincrement(array $params = [])
    {
        // Check whether command exists
        $this->commandExists(IncrementConfigCommand::class);

        return $this->run(IncrementConfigCommand::NAME, $params['options'], $params['arguments']);
    }

    /**
     * Object cleanup
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function objectCleanup(array $params = [])
    {
        return $this->run('system-objectcleanup', $params['options'], $params['arguments']);
    }

    /**
     * Object relations
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function objectRelations(array $params = [])
    {
        // Check whether command exists
        $this->commandExists(RegenerateRelationsCommand::class);

        return $this->run(RegenerateRelationsCommand::NAME, $params['options'], $params['arguments']);
    }

}