<?php

/**
 * i-doit APi
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_api_model_idoit_addons implements isys_api_model_interface
{

    /**
     * Read installed addons for tenant
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function read($params)
    {
        return [
            'success' => true,
            'result'  => $this->getModules(isys_application::instance()->container->get('session')
                ->get_mandator_id(), !!$params['coreModules'])
        ];
    }

    /**
     * Prepare and parse raw license data
     *
     * @param string $licenseData
     *
     * @return array
     */
    private static function prepareLicenseData($licenseData)
    {
        $transformedLicenseData = unserialize(utf8_decode($licenseData));

        if (!$transformedLicenseData) {
            $transformedLicenseData = unserialize($licenseData);
        }

        return $transformedLicenseData;
    }

    /**
     * Get modules of mandator
     *
     * @param int  $mandatorId
     * @param bool $coreModules
     *
     * @return array
     * @throws Exception
     */
    private function getModules($mandatorId, $coreModules = false)
    {
        global $g_absdir, $g_product_info;

        // Get licence data
        $rawLicenseData = (new isys_module_licence())->get_installed_licences(isys_application::instance()->container->get('database_system'),
            $mandatorId)[$mandatorId]['licence_data'];

        // Check whether license was found
        if (empty($rawLicenseData)) {
            throw new Exception('Unable to retrieve license for mandator');
        }

        // Parse raw license data
        $licenseData = self::prepareLicenseData($rawLicenseData);

        // Check whether parsing was successfull
        if (empty($licenseData)) {
            throw new Exception('Unable to parse license data');
        }

        // Extract module specific licenses
        $moduleLicenses = [];

        if (isset($licenseData[C__LICENCE__DATA]) && is_array($licenseData[C__LICENCE__DATA])) {
            $moduleLicenses = array_map('utf8_encode', $licenseData[C__LICENCE__DATA]);
        }

        // Create module manager instance
        $moduleManager = new isys_module_manager(isys_application::instance()->container->get('database'));

        // Setup path to modules directory
        $modulesDirectory = $g_absdir . '/src/classes/modules/';

        // Create directory handle
        $handle = opendir($modulesDirectory);

        // Iterate over module directories
        while (($moduleDirectory = readdir($handle)) !== false) {
            // Check whether directory is an module folder
            if (is_dir($modulesDirectory . $moduleDirectory) && strpos($moduleDirectory, '.') !== 0 && $moduleDirectory !== 'open') {
                // Check whether package.json exists
                if (file_exists($modulesDirectory . $moduleDirectory . '/package.json')) {
                    // Parse package json
                    $packageJson = json_decode(file_get_contents($modulesDirectory . $moduleDirectory . '/package.json'), true);

                    // Pro module should be considered as always active
                    if ($moduleDirectory === 'pro') {
                        $addons[] = [
                            'title'     => $packageJson['title'] ?: $packageJson['name'],
                            'key'       => $packageJson['identifier'],
                            'version'   => $g_product_info['version'],
                            'author'    => [
                                'name' => $packageJson['author']
                            ],
                            'licensed'  => !!$licenseData,
                            'active'    => true,
                            'installed' => true,
                        ];

                        continue;
                    }

                    // Skip core modules
                    if ($packageJson['type'] === 'core' && !$coreModules) {
                        continue;
                    }

                    // Module information store
                    $addOnInformation = [
                        'title'     => $packageJson['title'] ?: $packageJson['name'],
                        'key'       => $packageJson['identifier'],
                        'version'   => $packageJson['version'],
                        'author'    => [
                            'name' => $packageJson['author']
                        ],
                        'licensed'  => false,
                        'active'    => false,
                        'installed' => false,
                    ];

                    // Get module id
                    $moduleId = $moduleManager->is_installed($packageJson['identifier']);

                    // Check license status
                    $addOnInformation['licensed'] = $licenseData ? true : false;

                    // Check whether packageJson is present and module is installed
                    if ($packageJson && $moduleId) {
                        // Setup module information and status
                        $addOnInformation['active'] = !!$moduleManager->is_active($packageJson['identifier']);
                        $addOnInformation['licensed'] = true;
                        $addOnInformation['installed'] = true;

                        // Check whether module specific license is needed
                        if ($packageJson['licence'] && $licenseData && $packageJson['licence']) {
                            $addOnInformation['licensed'] = isset($moduleLicenses[$packageJson['identifier']]) ? true : false;
                        }
                    }

                    // Add module information to addons store
                    $addons[] = $addOnInformation;
                }
            }
        }

        // Sort addons by id
        usort($addons, function ($a, $b) {
            return ($a['id'] < $b['id']) ? -1 : $a['id'] == $b['id'] ? 0 : 1;
        });

        return $addons;
    }

}