<?php

/**
 * i-doit APi
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_api_model_idoit_license implements isys_api_model_interface
{

    /**
     * Read license information
     *
     * @param array $params
     *
     * @return array
     * @throws \idoit\Module\Api\Exception\JsonRpc\AuthenticationException
     * @throws \idoit\Module\Api\Exception\JsonRpc\InternalErrorException
     */
    public function read($params)
    {
        /** @var isys_component_session $session */
        $session = isys_application::instance()->container->get('session');

        // Check for an valid session first
        if (!$session->is_logged_in()) {
            throw new \idoit\Module\Api\Exception\JsonRpc\AuthenticationException('Unable to retrieve license information without valid and active user session. Please provide an api key first.');
        }

        // Check whether license module exists
        if (!class_exists('isys_module_licence')) {
            throw new \idoit\Module\Api\Exception\JsonRpc\InternalErrorException('Unable to instantiate license module.');
        }

        // Authenticate user
        if (class_exists('isys_auth_system_licence')) {
            isys_auth_system_licence::instance()
                ->overview(isys_auth::EXECUTE);
        }

        // Create license module
        $licenseModule = new isys_module_licence();
        $licenseResult = null;

        // Get installed licenses for mandator
        $licenses = $licenseModule->get_installed_licences(
            isys_application::instance()->database_system,
            isys_application::instance()->session->get_mandator_id());

        // Check whether licenses are installed
        if (count($licenses) > 0) {
            // Consider licenses
            foreach ($licenses as $licenseData) {
                // License result
                $licenseResult = [
                    'id' => (int)$licenseData['id'],
                    'organization' => $licenseData['organisation'],
                    'email' => $licenseData['email'],
                    'registrationDate' => date('Y-m-d H:i:s', $licenseData['reg_date']),
                    'expiryDate' => date('Y-m-d H:i:s', $licenseData['expires']),
                    'installationDate' => $licenseData['uploaded'],
                    'type' => $licenseData['licencetype'],
                    'objectCapacity' => [
                        'total' => $licenseData['objcount'],
                        'inUse' => (int)$licenseData['in_use'],
                        'unlimited' => $licenseData['unlimited'],
                    ],
                    'modules' => array_keys($licenseData['data']),
                    'valid' => true,
                ];

                try {
                    // Check license for validity
                    $licenseModule->check_licence($licenseData["licence_data"], isys_application::instance()->database);
                } catch (Exception $e) {
                    $licenseResult['valid'] = false;
                }
            }
        }

        return $licenseResult;
    }
}