<?php

use idoit\Module\Api\Controller\JsonRpcController;
use idoit\Module\Api\Session\SystemUserSession;

/**
 * i-doit APi
 *
 * @package    i-doit
 * @subpackage API
 * @author     Dennis Stücken <dstuecken@synetics.de>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_api_model_idoit_login implements isys_api_model_interface
{

    /**
     * Documentation missing
     *
     * @param array $p_params
     *
     * @return array
     */
    public function read($p_params)
    {
        global $g_comp_session;

        /** @var \idoit\Module\Api\Controller\JsonRpcController $jsonRpcController */
        $jsonRpcController = JsonRpcController::instance();

        // Disallow persistent sessions for system user sessions
        if ($jsonRpcController->getSession() instanceof SystemUserSession) {
            throw new \Exception('Unable to create persistent session for system user.
            Please provide valid user credentials by HTTP BasicAuth or X-RPC-Header');
        }

        // Get user data from session
        $l_userdata = $g_comp_session->get_userdata();

        // Persist session to prevent logging out
        $jsonRpcController->getSession()->setPersistent(true);

        // Expose session id by setting corresponding x-rpc-header
        isys_core::send_header(isys_core::HTTP_RPCAuthSession, $jsonRpcController->getSession()->getSessionId());

        return [
            'result'      => $g_comp_session->is_logged_in(),
            'userid'      => $g_comp_session->get_user_id(),
            'name'        => $l_userdata['name'],
            'mail'        => $l_userdata['email'],
            'username'    => $g_comp_session->get_current_username(),
            'session-id'  => $g_comp_session->get_session_id(),
            'client-id'   => $g_comp_session->get_mandator_id(),
            'client-name' => $g_comp_session->get_mandator_name(),
        ];
    } // function

    /**
     * Allow logging out after request processing finished
     *
     * @return boolean
     */
    public function allowLogout()
    {
        return false;
    }

}
