<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Exception\JsonRpc;

/**
 * Class AuthenticationException
 *
 * @package idoit\Module\Api\Exception\JsonRpc
 */
class AuthenticationException extends AbstractJsonRpcException
{

    /**
     * Get error code
     *
     * @return int
     */
    public function getErrorCode()
    {
        return -32604;
    }

    /**
     * Get error topic
     *
     * @return string
     */
    public function getErrorTopic()
    {
        return 'Authentication error';
    }
}