<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Logging;

/**
 * Class LineFormatter
 *
 * @package idoit\Module\Api
 */
class LineFormatter extends \Monolog\Formatter\LineFormatter
{
    /**
     * Format data to its json representation
     *
     * @param mixed $data
     * @param bool  $ignoreErrors
     *
     * @return string
     */
    protected function toJson($data, $ignoreErrors = false)
    {
        return "\n" . json_encode($data, JSON_PRETTY_PRINT);
    }
}