<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\ResponseModifier;
use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\SyncModifier;

/**
 * IpProcessor
 *
 * @package    idoit\Module\Api\Model\Category
 */
class IpProcessor extends AbstractCategoryProcessor implements ResponseModifier, SyncModifier
{

    /**
     * Modify api response
     *
     * @param array $response
     *
     * @return array
     */
    public function modifyResponse(array $response)
    {
        // Get request
        $request = $this->getRequest();

        // Check whether api request is 'read' and response object has results
        if (is_array($request) && $request['option'] === 'read' && is_array($response) && count($response) > 0) {
            // Modify response
            array_walk($response, function (&$result) {
                // Switch net type and unset unnecessary type
                switch ($result['net_type']['const']) {
                    case 'C__CATS_NET_TYPE__IPV4':
                        unset($result['ipv6_address']);
                        break;
                    case 'C__CATS_NET_TYPE__IPV6':
                        unset($result['ipv4_address']);
                        break;
                }
            });
        }

        return array_values($response);
    }

    /**
     * Modify sync data
     *
     * @param array $syncData
     *
     * @return array
     */
    public function modifySyncData(array $syncData)
    {
        // Get request
        $request = $this->getRequest();

        /**
         * @see API-23 Unset DNS-Server which will represent category data id by default
         */
        if (empty($request['data']['dns_server']) && !empty($syncData['properties']['dns_server'][C__DATA__VALUE])) {
            unset($syncData['properties']['dns_server']);
        }

        return $syncData;
    }
}