<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\RequestModifier;
use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\SyncModifier;

/**
 * SoftwareAssignmentProcessor
 *
 * @package    idoit\Module\Api\Model\Category
 */
class SoftwareAssignmentProcessor extends AbstractCategoryProcessor implements RequestModifier, SyncModifier
{

    /**
     * Raw request
     *
     * @var array
     */
    protected $rawRequest = [];

    /**
     * Modify api request
     *
     * @param array $request
     *
     * @return array
     */
    public function modifyRequest(array $request)
    {
        // Check whether request wants to create some data and application is set
        if ($request['option'] === 'create' && isset($request['data']['application'])) {

            if ($request['category'] == 'C__CATG__APPLICATION') {
                // Create application  dao
                $dao = new \isys_cmdb_dao_category_g_application(\isys_application::instance()->container->get('database'));

                // Create application  assignment
                $entryId = $dao->create($request['objID'], C__RECORD_STATUS__NORMAL, $request['data']['application'], '');
            } else {
                // Create application  dao
                $dao = new \isys_cmdb_dao_category_g_operating_system(\isys_application::instance()->container->get('database'));

                // Create application  assignment
                $entryId = $dao->create($request['objID'], C__RECORD_STATUS__NORMAL, $request['data']['application'], '');
            }

            // Transform request into an update
            $request['option'] = 'update';
            $request['id'] = $entryId;
            $request['data']['id'] = $entryId;
        }

        $this->rawRequest = $request;

        return $request;
    }

    /**
     * Modify sync data
     *
     * @param array $syncData
     *
     * @return array
     */
    public function modifySyncData(array $syncData)
    {
        /**
         * Check whether assigned database schema was setted explicitly by request
         * or was added by isys_api_model_cmdb_category::__to_sync_structure().
         *
         * In last cas we will remove it because the key will simply hold the
         * isys_catg_relation__id but sync will interpret it as object id.
         */
        if (is_array($this->rawRequest['data']) && !array_key_exists('assigned_database_schema', $this->rawRequest['data'])) {
            $syncData['properties']['assigned_database_schema'] = null;
        }

        return $syncData;
    }
}