<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.com>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Property;

/**
 * Class PropertyReadEntity
 *
 * @package idoit\Module\Api\Property
 */
class PropertyReadEntity
{
    /**
     * @var string
     */
    private $title;

    /**
     * @var array
     */
    private $definition;

    /**
     * @var mixed
     */
    private $example;

    /**
     * @var string
     */
    private $type;

    /**
     * @return mixed
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @return mixed
     */
    public function getDefinition()
    {
        return $this->definition;
    }

    /**
     * @return mixed
     */
    public function getExample()
    {
        return $this->example;
    }

    /**
     * @return mixed
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * PropertyEntity constructor.
     *
     * @param $title
     * @param $type
     * @param $definition
     * @param $example
     */
    public function __construct($title, $type, $definition, $example)
    {
        $this->title = $title;
        $this->type = $type;
        $this->definition = $definition;
        $this->example = $example;
    }

    public function toArray()
    {
        return [
            'title'      => $this->getTitle(),
            'type'       => $this->getType(),
            'definition' => $this->getDefinition(),
            'example'    => $this->getExample()
        ];
    }
}