<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.com>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Property;

/**
 * Class PropertyWriteEntity
 *
 * @package idoit\Module\Api\Property
 */
class PropertyWriteEntity
{
    /**
     * @var string
     */
    private $title;

    /**
     * @var array
     */
    private $definitions;

    /**
     * @var mixed
     */
    private $example;

    /**
     * @return mixed
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @return mixed
     */
    public function getDefinitions()
    {
        return $this->definitions;
    }

    /**
     * @return mixed
     */
    public function getExample()
    {
        return $this->example;
    }

    /**
     * PropertyEntity constructor.
     *
     * @param $title
     * @param $example
     */
    public function __construct($title, $example)
    {
        $this->title = $title;
        $this->example = $example;
    }

    /**
     * Add new definition
     *
     * @param $type
     * @param $description
     * @param $example
     *
     * @return PropertyWriteEntity
     */
    public function addDefinition($type, $description, $example)
    {
        $this->definitions[] = [
            'type'        => $type,
            'description' => $description,
            'example'     => $example,
        ];

        return $this;
    }

    public function toArray()
    {
        return [
            'title'       => $this->getTitle(),
            'definitions' => $this->getDefinitions(),
            'example'     => $this->getExample()
        ];
    }
}