<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Validation\Property;

use idoit\Module\Api\Exception\ValidationException;
use idoit\Module\Api\Validation\PropertyValidation;

/**
 * Class Dialog
 *
 * @package idoit\Module\Api\Validation\Property
 */
class Dialog extends PropertyValidation
{

    /**
     * Validate value
     *
     * @return bool
     * @throws ValidationException
     */
    public function validate()
    {
        $value = $this->getValue();
        if ((!is_int($value) && !is_string($value))) {
            throw new ValidationException($this->getPropertyType(), 'Property has to be an integer or string value.');
        }

        if (is_string($value) && isys_strlen($value) > 255) {
            throw new ValidationException($this->getPropertyType(), 'Property exceeded maximum length of possible 255 characters.');
        }

        if (is_int($value) && $value < 0) {
            throw new ValidationException($this->getPropertyType(), 'Property value should be greater then zero.');
        }

        return true;
    }
}
