<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Validation\Property;

use idoit\Module\Api\Exception\ValidationException;
use idoit\Module\Api\Validation\PropertyValidation;

/**
 * Class Float
 *
 * @package idoit\Module\Api\Validation\Property
 */
class FloatValue extends PropertyValidation
{

    /**
     * Validate value
     *
     * @return bool
     * @throws ValidationException
     */
    public function validate()
    {
        $value = $this->getValue();

        if (!is_integer($value) && !is_float($value) && !is_double($value)) {
            throw new ValidationException($this->getPropertyType(), 'Property has to be a float or double value.');
        }

        return true;
    }
}
